// JavaScript Document
	
	/*
	 *	Date scripting was adapted from C sources written by
	 *	Scott E. Lee, which contain the following copyright notice:
	 *	
	 *	Copyright 1993-1995, Scott E. Lee, all rights reserved.
	 *	Permission granted to use, copy, modify, distribute and sell so long as
	 *	the above copyright and this permission statement are retained in all
	 *	copies.  THERE IS NO WARRANTY - USE AT YOUR OWN RISK.
	 *	
	 *	Bill Hastings
	 *	RBI Software Systems
	 *	bhastings@rbi.com
	 */
function surfto(form) {
        var myindex=form.select1.selectedIndex
        if (form.select1.options[myindex].value != "0") {
       	 location=form.select1.options[myindex].value;}
        }
        var GREG_SDN_OFFSET = 32045,
                DAYS_PER_5_MONTHS = 153,
                DAYS_PER_4_YEARS = 1461,
                DAYS_PER_400_YEARS = 146097;
        var HALAKIM_PER_HOUR = 1080,
                HALAKIM_PER_DAY = 25920,
                HALAKIM_PER_LUNAR_CYCLE = ((29 * HALAKIM_PER_DAY) + 13753),
                HALAKIM_PER_METONIC_CYCLE = (HALAKIM_PER_LUNAR_CYCLE * (12 * 19 + 7));
        var HEB_SDN_OFFSET = 347997,
                NEW_MOON_OF_CREATION = 31524,
                NOON = (18 * HALAKIM_PER_HOUR),
                AM3_11_20 = ((9 * HALAKIM_PER_HOUR) + 204),
                AM9_32_43 = ((15 * HALAKIM_PER_HOUR) + 589);
        var SUN = 0,
                MON = 1,
                TUES = 2,
                WED = 3,
                THUR = 4,
                FRI = 5,
                SAT = 6;
        var today = null,
                hebrewMonth = 0,
                hebrewDate = 0,
                hebrewYear = 0,
                metonicCycle = 0,
                metonicYear = 0,
                moladDay = 0,
                moladHalakim = 0;
        var gWeekday = new weekdayarr("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
        var gMonth = new gregmontharr("January","February","March","April","May","June","July","August","September","October","November","December");
        var hMonth = new hebrewmontharr("Tishri","Heshvan","Kislev","Tevet","Shevat","Adar","Adar II","Nisan","Iyar","Sivan","Tammuz","Av","Elul");
        var mpy = new monthsperyeararr(12,12,13,12,12,13,12,13,12,12,13,12,12,13,12,12,13,12,13);
        getToday();
                if (gMonth[today.getMonth()] == "January") {
                var SS = 35;
                }  else
                if (gMonth[today.getMonth()] == "February") {
                var SS = 80;
                }  else
                if (gMonth[today.getMonth()] == "March") {
                var SS = 120;
                }  else
                if (gMonth[today.getMonth()] == "April") {
                var SS = 220;
                }  else
                if (gMonth[today.getMonth()] == "May") {
                var SS = 255;
                }  else
                if (gMonth[today.getMonth()] == "June") {
                var SS = 280;
                }  else
                if (gMonth[today.getMonth()] == "July") {
                var SS = 275;
                }  else
                if (gMonth[today.getMonth()] == "August") {
                var SS = 230;
                }  else
                if (gMonth[today.getMonth()] == "September") {
                var SS = 180;
                }  else
                if (gMonth[today.getMonth()] == "October") {
                var SS = 120;
                }  else
                if (gMonth[today.getMonth()] == "November") {
                var SS = 20;
                }  else
                if (gMonth[today.getMonth()] == "December") {
                var SS = 15;
                }
				
        function weekdayarr(d0,d1,d2,d3,d4,d5,d6)
        {
                this[0] = d0; this[1] = d1; this[2] = d2; this[3] = d3;
                this[4] = d4; this[5] = d5; this[6] = d6;
        }
		
        function gregmontharr(m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11)
        {
                this[0] = m0; this[1] = m1; this[2] = m2; this[3] = m3;
                this[4] = m4; this[5] = m5; this[6] = m6; this[7] = m7;
                this[8] = m8; this[9] = m9; this[10] = m10; this[11] = m11;
        }
		
        function hebrewmontharr(m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12,m13)
        {
                this[0] = m0; this[1] = m1; this[2] = m2; this[3] = m3;
                this[4] = m4; this[5] = m5; this[6] = m6; this[7] = m7;
                this[8] = m8; this[9] = m9; this[10] = m10; this[11] = m11;
                this[12] = m12; this[13] = m13;
        }
		
        function monthsperyeararr(m0,m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,m11,m12,m13,m14,m15,m16,m17,m18)
        {
                this[0] = m0; this[1] = m1; this[2] = m2; this[3] = m3;
                this[4] = m4; this[5] = m5; this[6] = m6; this[7] = m7;
                this[8] = m8; this[9] = m9; this[10] = m10; this[11] = m11;
                this[12] = m8; this[13] = m13; this[14] = m14; this[15] = m15;
                this[16] = m16; this[17] = m17; this[18] = m18;
        }
		
        function getToday()
        {
                if(today == null)
                        today = new Date();
        }
		
        function displayWeekday()
        {
                getToday();
                H=today.getHours();
                M=today.getMinutes();
                //if ((((H-16)*60)+M)>=SS)  {
                //document.writeln(gWeekday[today.getDay()] + "DAY" + " " + "EVENING");
                //} else 
                document.writeln(gWeekday[today.getDay()]);
        }
		
        function displayGregorianDate()
        {
                getToday();
                document.writeln(today.getDate() + " " + gMonth[today.getMonth()] + " " +  today.getFullYear());
        }
        
        function displayHebrewDate()
        {
                if(hebrewDate != 0 && hebrewMonth != 0 && hebrewYear != 0)
                        document.writeln(hebrewDate + " " + hMonth[hebrewMonth-1] + " " + hebrewYear);
              
              //Add holidays - Calendar Maven
              //www.calendar-maven.com
              //May 2000
              
              getToday();
              
              //rosh hodesh
              if ((hebrewDate == "1" || hebrewDate == "30") && hMonth[hebrewMonth-1] != "Tishri") {
              document.writeln("<br>Rosh Hodesh");
              }
              
              //shabbat
              if (gWeekday[today.getDay()] == "Friday") {
              document.writeln("<br>Erev Shabbat");
              }          
              if (gWeekday[today.getDay()] == "Saturday") {
              document.writeln("<br>Shabbat");
              }        
              
              //tishri
               if ((hebrewDate == "1" || hebrewDate == "2") && hMonth[hebrewMonth-1] == "Tishri"){
              document.writeln("<br>Rosh Hashanah");
              }
               if ((hebrewDate == "3" ) && hMonth[hebrewMonth-1] == "Tishri"  && gWeekday[today.getDay()] != "Saturday"){
              document.writeln("<br>Fast of Gedaliah");
              }
               if ((hebrewDate == "4" ) && hMonth[hebrewMonth-1] == "Tishri"  && gWeekday[today.getDay()] == "Sunday"){
              document.writeln("<br>Fast of Gedaliah");
              }
               if ((hebrewDate == "10" ) && hMonth[hebrewMonth-1] == "Tishri"){
              document.writeln("<br>Yom Kippur");
              }
               if ((hebrewDate == "15" || hebrewDate == "16" || hebrewDate == "17" || hebrewDate == "18" || hebrewDate == "19" || hebrewDate == "20") && hMonth[hebrewMonth-1] == "Tishri"){
              document.writeln("<br>Sukkot");
              }
               if ((hebrewDate == "21" ) && hMonth[hebrewMonth-1] == "Tishri"){
              document.writeln("<br>Hoshanah Rabah");
              }
               if ((hebrewDate == "22" ) && hMonth[hebrewMonth-1] == "Tishri"){
              document.writeln("<br>Shemini Atzeret");
              }
               if ((hebrewDate == "23" ) && hMonth[hebrewMonth-1] == "Tishri"){
              document.writeln("<br>Simhat Torah");
              }
				//tevet
               if ((hebrewDate == "10" ) && hMonth[hebrewMonth-1] == "Tevet"  && gWeekday[today.getDay()] != "Saturday"){
              document.writeln("<br>Fast of Tevet 10");
              }
               if ((hebrewDate == "11" ) && hMonth[hebrewMonth-1] == "Tevet"  && gWeekday[today.getDay()] == "Sunday"){
              document.writeln("<br>Fast of Tevet 10");
              }
				//shevat
              if ((hebrewDate == "15" ) && hMonth[hebrewMonth-1] == "Shevat"){
              document.writeln("<br>Tu B'Shevat");
              }
				//nisan
              if ((hebrewDate == "15" || hebrewDate == "16" || hebrewDate == "17" || hebrewDate == "18" || hebrewDate == "19" || hebrewDate == "20" || hebrewDate == "21" || hebrewDate == "22") && hMonth[hebrewMonth-1] == "Nisan"){
              document.writeln("<br>Passover");
              }
				 if ((hebrewDate == "27" ) && hMonth[hebrewMonth-1] == "Nisan"  && gWeekday[today.getDay()] != "Saturday" && gWeekday[today.getDay()] != "Friday"){
              document.writeln("<br>Yom Hashoah");
              }
				 if ((hebrewDate == "26" || hebrewDate == "25") && hMonth[hebrewMonth-1] == "Nisan"  && gWeekday[today.getDay()] == "Thursday"){
	            document.writeln("<br>Yom Hashoah");
              }				
              
				//iyar  
	            if (hebrewDate == "14" && hMonth[hebrewMonth-1] == "Iyar"){
              document.writeln("<br>Pesach Sheini");
              }
              if (hebrewDate == "18" && hMonth[hebrewMonth-1] == "Iyar"){
              document.writeln("<br>Lag B'Omer");
              }
              if (hebrewDate == "28" && hMonth[hebrewMonth-1] == "Iyar"){
              document.writeln("<br>Yom Yerushalayim");
              }
              
				//sivan
              if ((hebrewDate == "6" || hebrewDate == "7") && hMonth[hebrewMonth-1] == "Sivan"){
              document.writeln("<br>Shavuot");
              }
				//tammuz
              if (hebrewDate == "17" && hMonth[hebrewMonth-1] == "Tammuz" && gWeekday[today.getDay()] != "Saturday"){
              document.writeln("<br>Fast of Tammuz 17");
              }
              if (hebrewDate == "18" && hMonth[hebrewMonth-1] == "Tammuz" && gWeekday[today.getDay()] == "Sunday"){
              document.writeln("<br>Fast of Tammuz 17");
              }
				//av
              if (hebrewDate == "9" && hMonth[hebrewMonth-1] == "Av" && gWeekday[today.getDay()] != "Saturday"){
              document.writeln("<br>Fast of Tisha B'Av");
              }
              if (hebrewDate == "10" && hMonth[hebrewMonth-1] == "Av" && gWeekday[today.getDay()] == "Sunday"){
              document.writeln("<br>Fast of Tammuz 17");
              }
              if ((hebrewDate == "15" ) && hMonth[hebrewMonth-1] == "Av"){
              document.writeln("<br>Tu B'Av");
              }
					
				//elul					
				if ((hebrewDate =="20" || hebrewDate=="21"  || hebrewDate=="22"  || hebrewDate=="23"  || hebrewDate=="24"  || hebrewDate=="25"  || hebrewDate=="26") && (hMonth[hebrewMonth-1] == "Elul") && gWeekday[today.getDay()] == "Saturday"){
              document.writeln("<br>Selihot");
              }
        }
		
		
        function GregorianToSdn(inputYear,inputMonth,inputDay)
        {
                var year = 0,
                        month = 0,
                        sdn;
                getToday();
                // Make year a positive number
                if (inputYear < 0)
                        year = inputYear + 4801;
                else
                        year = inputYear + 4800;
                // Adjust the start of the year
                if (inputMonth > 2) {
                        month = inputMonth - 3;
                }
                else {
                        month = inputMonth + 9;
                        year--;
                }
                sdn      = Math.floor((Math.floor(year / 100) * DAYS_PER_400_YEARS) / 4);
                sdn += Math.floor(((year % 100) * DAYS_PER_4_YEARS) / 4);
                sdn += Math.floor((month * DAYS_PER_5_MONTHS + 2) / 5);
                sdn += inputDay - GREG_SDN_OFFSET;
                return sdn;
          }
				
		function SdnToHebrew(sdn)
		{
                var inputDay,
                        tishri1 = 0,
                        tishri1After = 0,
                        yearLength = 0,
                H = today.getHours();
                M = today.getMinutes();
                if ((((H-16)*60)+M)>=SS)  {
                                        //flip-over time
                inputDay = sdn - HEB_SDN_OFFSET + 1;
                } else 
                   {
                inputDay = sdn - HEB_SDN_OFFSET;
                }
                FindTishriMolad(inputDay);
                tishri1 = Tishri1(metonicYear,moladDay,moladHalakim);
                if (inputDay >= tishri1) {
                        // It found Tishri 1 at the start of the year.
                        hebrewYear = metonicCycle * 19 + metonicYear + 1;
                        if (inputDay < tishri1 + 59) {
                                if (inputDay < tishri1 + 30) {
                                        hebrewMonth = 1;
                                        hebrewDate = inputDay - tishri1 + 1;
                                }
                                else {
                                        hebrewMonth = 2;
                                        hebrewDate = inputDay - tishri1 - 29;
                                }
                                return;
                        }
                        // We need the length of the year to figure this out,so find Tishri 1 of the next year.
                        moladHalakim += HALAKIM_PER_LUNAR_CYCLE * mpy[metonicYear];
                        moladDay += Math.floor(moladHalakim / HALAKIM_PER_DAY);
                        moladHalakim = moladHalakim % HALAKIM_PER_DAY;
                        tishri1After = Tishri1((metonicYear + 1) % 19,moladDay,moladHalakim);
                }
                else {
                        // It found Tishri 1 at the end of the year.
                        hebrewYear = metonicCycle * 19 + metonicYear;
                        if (inputDay >= tishri1 - 177) {
                                // It is one of the last 6 months of the year.
                                if (inputDay > tishri1 - 30) {
                                        hebrewMonth = 13;
                                        hebrewDate = inputDay - tishri1 + 30;
                                }
                                else if (inputDay > tishri1 - 60) {
                                        hebrewMonth = 12;
                                        hebrewDate = inputDay - tishri1 + 60;
                                }
                                else if (inputDay > tishri1 - 89) {
                                        hebrewMonth = 11;
                                        hebrewDate = inputDay - tishri1 + 89;
                                }
                                else if (inputDay > tishri1 - 119) {
                                        hebrewMonth = 10;
                                        hebrewDate = inputDay - tishri1 + 119;
                                }
                                else if (inputDay > tishri1 - 148) {
                                        hebrewMonth = 9;
                                        hebrewDate = inputDay - tishri1 + 148;
                                }
                                else {
                                        hebrewMonth = 8;
                                        hebrewDate = inputDay - tishri1 + 178;
                                }
                                return;
                        }
                        else {
                                if (mpy[(hebrewYear - 1) % 19] == 13) {
                                        hebrewMonth = 7;
                                        hebrewDate = inputDay - tishri1 + 207;
                                        if (hebrewDate > 0)
                                                return;
                                        hebrewMonth--;
                                        hebrewDate += 30;
                                        if (hebrewDate > 0)
                                                return;
                                        hebrewMonth--;
                                        hebrewDate += 30;
                                }
                                else {
                                        hebrewMonth = 6;
                                        hebrewDate = inputDay - tishri1 + 207;
                                        if (hebrewDate > 0)
                                                return;
                                        hebrewMonth--;
                                        hebrewDate += 30;
                                }
                                if (hebrewDate > 0)
                                        return;
                                hebrewMonth--;
                                hebrewDate += 29;
                                if (hebrewDate > 0)
                                        return;
                                // We need the length of the year to figure this out,so find Tishri 1 of this year.
                                tishri1After = tishri1;
                                FindTishriMolad(moladDay - 365);
                                tishri1 = Tishri1(metonicYear,moladDay,moladHalakim);
                        }
                }
                yearLength = tishri1After - tishri1;
                moladDay = inputDay - tishri1 - 29;
                if (yearLength == 355 || yearLength == 385) {
                        // Heshvan has 30 days
                        if (moladDay <= 30) {
                                hebrewMonth = 2;
                                hebrewDate = moladDay;
                                return;
                        }
                        moladDay -= 30;
                }
                else {
                        // Heshvan has 29 days
                        if (moladDay <= 29) {
                                hebrewMonth = 2;
                                hebrewDate = moladDay;
                                return;
                        }
                        moladDay -= 29;
                }
                // It has to be Kislev.
                hebrewMonth = 3;
                hebrewDate = moladDay;
        }
		
        function FindTishriMolad(inputDay)
        {
                // Estimate the metonic cycle number.  Note that this may be an under
                // estimate because there are 6939.6896 days in a metonic cycle not
                // 6940,but it will never be an over estimate.   The loop below will
                // correct for any error in this estimate.
                metonicCycle = Math.floor((inputDay + 310) / 6940);
                // Calculate the time of the starting molad for this metonic cycle.
                MoladOfMetonicCycle();
                // If the above was an under estimate,increment the cycle number until
                // the correct one is found.  For modern dates this loop is about 98.6%
                // likely to not execute,even once,because the above estimate is
                // really quite close.
                while (moladDay < inputDay - 6940 + 310) {
                        metonicCycle++;
                        moladHalakim += HALAKIM_PER_METONIC_CYCLE;
                        moladDay += Math.floor(moladHalakim / HALAKIM_PER_DAY);
                        moladHalakim = moladHalakim % HALAKIM_PER_DAY;
                }
                // Find the molad of Tishri closest to this date.
                for (metonicYear = 0; metonicYear < 18; metonicYear++) {
                        if (moladDay > inputDay - 74)
                                break;
                        moladHalakim += HALAKIM_PER_LUNAR_CYCLE * mpy[metonicYear];
                        moladDay += Math.floor(moladHalakim / HALAKIM_PER_DAY);
                        moladHalakim = moladHalakim % HALAKIM_PER_DAY;
                }
        }
		
        function MoladOfMetonicCycle()
        {
                var r1,r2,d1,d2;
                // Start with the time of the first molad after creation.
                r1 = NEW_MOON_OF_CREATION;
                // Calculate gMetonicCycle * HALAKIM_PER_METONIC_CYCLE.  The upper 32
                // bits of the result will be in r2 and the lower 16 bits will be in r1.
                r1 += metonicCycle * (HALAKIM_PER_METONIC_CYCLE & 0xFFFF);
                r2 = r1 >> 16;
                r2 += metonicCycle * ((HALAKIM_PER_METONIC_CYCLE >> 16) & 0xFFFF);
                // Calculate r2r1 / HALAKIM_PER_DAY.  The remainder will be in r1,the
                // upper 16 bits of the quotient will be in d2 and the lower 16 bits
                // will be in d1.
                d2 = Math.floor(r2 / HALAKIM_PER_DAY);
                r2 -= d2 * HALAKIM_PER_DAY;
                r1 = (r2 << 16) | (r1 & 0xFFFF);
                d1 = Math.floor(r1 / HALAKIM_PER_DAY);
                r1 -= d1 * HALAKIM_PER_DAY;
                moladDay = (d2 << 16) | d1;
                moladHalakim = r1;
        }
		
        function Tishri1(metonicYear,moladDay,moladHalakim)
        {
                var tishri1 = moladDay;
                var dow = tishri1 % 7;
                var leapYear =  metonicYear == 2 || metonicYear == 5 || metonicYear == 7 || metonicYear == 10 ||
                                                metonicYear == 13 || metonicYear == 16 || metonicYear == 18;
                var lastWasLeapYear =   metonicYear == 3 || metonicYear == 6 || metonicYear == 8 || metonicYear == 11 ||
                                                                metonicYear == 14 || metonicYear == 17 || metonicYear == 0;
                // Apply rules 2,3 and 4
                if ((moladHalakim >= NOON) ||
                        ((!leapYear) && dow == TUES && moladHalakim >= AM3_11_20) ||
                        (lastWasLeapYear && dow == MON && moladHalakim >= AM9_32_43))
                {
                        tishri1++;
                        dow++;
                        if (dow == 7)
                                dow = 0;
                }
                // Apply rule 1 after the others because it can cause an additional delay of one day.
                if (dow == WED || dow == FRI || dow == SUN) {
                        tishri1++;
                }
                return tishri1;
        }
		
//////////////////////////////////////////////////////////////////////////////
function getHebrewDateStr()
        {
                if(hebrewDate != 0 && hebrewMonth != 0 && hebrewYear != 0)
                  strHebrewDate = hebrewDate + " " + hMonth[hebrewMonth-1] + " " + hebrewYear;
              
              //Add holidays - Calendar Maven
              //www.calendar-maven.com
              //May 2000
              
              getToday();
              
              //rosh hodesh
              if ((hebrewDate == "1" || hebrewDate == "30") && hMonth[hebrewMonth-1] != "Tishri") {
              	strHebrewDate = strHebrewDate + " Rosh Hodesh";
              }
              
              //shabbat
              if (gWeekday[today.getDay()] == "Friday") {
				strHebrewDate = strHebrewDate + " Erev Shabbat";
              }          
              if (gWeekday[today.getDay()] == "Saturday") {
              	strHebrewDate = strHebrewDate + " Shabbat";
              }        
              
              //tishri
               if ((hebrewDate == "1" || hebrewDate == "2") && hMonth[hebrewMonth-1] == "Tishri"){
              	strHebrewDate = strHebrewDate + " Rosh Hashanah";
              }
               if ((hebrewDate == "3" ) && hMonth[hebrewMonth-1] == "Tishri"  && gWeekday[today.getDay()] != "Saturday"){
              	strHebrewDate = strHebrewDate + " Fast of Gedaliah";
              }
               if ((hebrewDate == "4" ) && hMonth[hebrewMonth-1] == "Tishri"  && gWeekday[today.getDay()] == "Sunday"){
              	strHebrewDate = strHebrewDate + " Fast of Gedaliah";
              }
               if ((hebrewDate == "10" ) && hMonth[hebrewMonth-1] == "Tishri"){
              	strHebrewDate = strHebrewDate + " Yom Kippur";
              }
               if ((hebrewDate == "15" || hebrewDate == "16" || hebrewDate == "17" || hebrewDate == "18" || hebrewDate == "19" || hebrewDate == "20") && hMonth[hebrewMonth-1] == "Tishri"){
              	strHebrewDate = strHebrewDate + " Sukkot";
              }
               if ((hebrewDate == "21" ) && hMonth[hebrewMonth-1] == "Tishri"){
              	strHebrewDate = strHebrewDate + " Hoshanah Rabah";
              }
               if ((hebrewDate == "22" ) && hMonth[hebrewMonth-1] == "Tishri"){
              	strHebrewDate = strHebrewDate + " Shemini Atzeret";
              }
               if ((hebrewDate == "23" ) && hMonth[hebrewMonth-1] == "Tishri"){
              	strHebrewDate = strHebrewDate + " Simhat Torah";
              }
				//tevet
               if ((hebrewDate == "10" ) && hMonth[hebrewMonth-1] == "Tevet"  && gWeekday[today.getDay()] != "Saturday"){
              	strHebrewDate = strHebrewDate + " Fast of Tevet 10";
              }
               if ((hebrewDate == "11" ) && hMonth[hebrewMonth-1] == "Tevet"  && gWeekday[today.getDay()] == "Sunday"){
              	strHebrewDate = strHebrewDate + " Fast of Tevet 10";
              }
				//shevat
              if ((hebrewDate == "15" ) && hMonth[hebrewMonth-1] == "Shevat"){
              	strHebrewDate = strHebrewDate + " Tu B'Shevat";
              }
				//nisan
              if ((hebrewDate == "15" || hebrewDate == "16" || hebrewDate == "17" || hebrewDate == "18" || hebrewDate == "19" || hebrewDate == "20" || hebrewDate == "21" || hebrewDate == "22") && hMonth[hebrewMonth-1] == "Nisan"){
              	strHebrewDate = strHebrewDate + " Passover";
              }
				 if ((hebrewDate == "27" ) && hMonth[hebrewMonth-1] == "Nisan"  && gWeekday[today.getDay()] != "Saturday" && gWeekday[today.getDay()] != "Friday"){
              		strHebrewDate = strHebrewDate + " Yom Hashoah";
              }
				 if ((hebrewDate == "26" || hebrewDate == "25") && hMonth[hebrewMonth-1] == "Nisan"  && gWeekday[today.getDay()] == "Thursday"){
	            	strHebrewDate = strHebrewDate + " Yom Hashoah";
              }				
              
				//iyar  
	            if (hebrewDate == "14" && hMonth[hebrewMonth-1] == "Iyar"){
              		strHebrewDate = strHebrewDate + " Pesach Sheini";
              }
              if (hebrewDate == "18" && hMonth[hebrewMonth-1] == "Iyar"){
              	strHebrewDate = strHebrewDate + " Lag B'Omer";
              }
              if (hebrewDate == "28" && hMonth[hebrewMonth-1] == "Iyar"){
              	strHebrewDate = strHebrewDate + " Yom Yerushalayim";
              }
              
				//sivan
              if ((hebrewDate == "6" || hebrewDate == "7") && hMonth[hebrewMonth-1] == "Sivan"){
              	strHebrewDate = strHebrewDate + " Shavuot";
              }
				//tammuz
              if (hebrewDate == "17" && hMonth[hebrewMonth-1] == "Tammuz" && gWeekday[today.getDay()] != "Saturday"){
              	strHebrewDate = strHebrewDate + " Fast of Tammuz 17";
              }
              if (hebrewDate == "18" && hMonth[hebrewMonth-1] == "Tammuz" && gWeekday[today.getDay()] == "Sunday"){
              	strHebrewDate = strHebrewDate + " Fast of Tammuz 17";
              }
				//av
              if (hebrewDate == "9" && hMonth[hebrewMonth-1] == "Av" && gWeekday[today.getDay()] != "Saturday"){
              	strHebrewDate = strHebrewDate + " Fast of Tisha B'Av";
              }
              if (hebrewDate == "10" && hMonth[hebrewMonth-1] == "Av" && gWeekday[today.getDay()] == "Sunday"){
              	strHebrewDate = strHebrewDate + " Fast of Tammuz 17";
              }
              if ((hebrewDate == "15" ) && hMonth[hebrewMonth-1] == "Av"){
              	strHebrewDate = strHebrewDate + " Tu B'Av";
              }
					
				//elul					
				if ((hebrewDate =="20" || hebrewDate=="21"  || hebrewDate=="22"  || hebrewDate=="23"  || hebrewDate=="24"  || hebrewDate=="25"  || hebrewDate=="26") && (hMonth[hebrewMonth-1] == "Elul") && gWeekday[today.getDay()] == "Saturday"){
              		strHebrewDate = strHebrewDate + " Selihot";
              }
			  
			  return(strHebrewDate);
        }
		
////////////////////////////////////////////////////////////////////////////////

function ConvertToHebrew(GregorianDateInput, HebrewDateOutput, nStringType)
{
	var strGregorianDate = document.getElementById(GregorianDateInput).value;
	
	var GregorianDateArray = strGregorianDate.split("/");
	var MonthNum = parseInt(GregorianDateArray[0]);
	var DayNum = parseInt(GregorianDateArray[1]);
	var YearNum = parseInt(GregorianDateArray[2]);
	var GregorianDate = new Date();
	MonthNum = MonthNum - 1;
	GregorianDate.setMonth(MonthNum);
	GregorianDate.setDate(DayNum);
	GregorianDate.setYear(YearNum);
	var nYear = GregorianDate.getFullYear();
	var nMonth = GregorianDate.getMonth() + 1;
	var nDate = GregorianDate.getDate();
	
	SdnToHebrew(GregorianToSdn(nYear,nMonth,nDate));
	if (nStringType == 1)
		strHebrewDate = getHebrewDateStr();
	else
		strHebrewDate = hebrewYear + "/" + hebrewMonth + "/" + hebrewDate;
	
	var HebrewDate = document.getElementById(HebrewDateOutput);
	HebrewDate.value=strHebrewDate;
}

////////////////////////////////////////////////////////////////////////////////

function ConvertToHebrewList(GregorianMonthInput, GregorianDayInput, GregorianYearInput, HebrewMonthOutput, HebrewDayOutput, HebrewYearOutput)
{
	var strGregorianMonth = document.getElementById(GregorianMonthInput).value;
	var strGregorianDay = document.getElementById(GregorianDayInput).value;
	var strGregorianYear = document.getElementById(GregorianYearInput).value;
	
	var GregorianDate = new Date();
	var MonthNum = strGregorianMonth - 1;
	GregorianDate.setMonth(MonthNum);
	GregorianDate.setDate(strGregorianDay);
	GregorianDate.setYear(strGregorianYear);
	var nYear = GregorianDate.getFullYear();
	var nMonth = GregorianDate.getMonth() + 1;
	var nDate = GregorianDate.getDate();
	
	SdnToHebrew(GregorianToSdn(nYear,nMonth,nDate));
	
	var HebrewMonth = document.getElementById(HebrewMonthOutput);
	HebrewMonth.selectedIndex=hebrewMonth - 1;
	var HebrewDay = document.getElementById(HebrewDayOutput);
	HebrewDay.selectedIndex=hebrewDate - 1;
	var HebrewYear = document.getElementById(HebrewYearOutput);
	HebrewYear.value=hebrewYear;
}
