<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Re-engineered: 4/23/2010	ELL
// Revised: 6/22/2010	ELL
// Modified so that upload image brings form back to class that was selected.
// Revised: 8/30/2010	ELL
// Fixed bug with handling # in HTML by using string replace. Replace ("#", ",", ".", " ") with ("POUND", "COMMA", "PERIOD", "SPACE").
// Revised: 9/28/2010	ELL
// Fixed bug with shadow parameters not loading into editor.
// Revised: 10/7/2010	ELL
// Added selection of top, bottom, right, left for border style assignment, each independently selectable.
// Revised: 11/9/2010	ELL
// Changed centering to modify #wrap instead of .wrap.  Part of switching 
// Revised: 11/10/2010	ELL
// Added persistence of style sheet selected.
// Revised: 2/3/2011	ELL
// Added sorting of image file list.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added reference to user files folder constant.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
// 
//
	include ("check_session.php");

	
	$style_sheet = $_REQUEST['style_sheet'];
	$_SESSION['last_style_sheet_edited'] = $style_sheet;
	$class_table = $style_sheet . "_classes";
	$css_table = $style_sheet . "_css";
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $style_sheet . "'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	$show_class_editor = $row["show_class_editor"];
		
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/ajax.js"></script>

<script type="text/javascript" src="js/check_color_str.js"></script>

<script language="JavaScript" type="text/javascript">
	function popupcolorpicker(form_name, field_name)
	{
		var start_color = document.getElementById(field_name).value;
		if (start_color == "")
			start_color = "-not set-";
		else
			start_color = start_color.replace("#", "");
		
		var URL = "colorpicker.php?form_name=" + form_name + "&field_name=" + field_name + "&source_page=edit_css.php&start_color=" + start_color;
		
		window.open (URL, "colorpicker", "alwaysRaised=0,dependent=1,menubar=0,resizable=0,width=450,height=350,scrollbars=0,location=0");
	}
	
	function enable_disable_controls(ShowMessage)
	{	
		if (document.getElementById("use_table_data").checked == true)
		{
			document.getElementById("font").disabled = false;
			document.getElementById("font_size").disabled = false;
			document.getElementById("text_color").disabled = false;
			document.getElementById("align").disabled = false;
			document.getElementById("vertical_align").disabled = false;
			document.getElementById("display").disabled = false;
			document.getElementById("weight").disabled = false;
			document.getElementById("font_stretch").disabled = false;
			document.getElementById("italic").disabled = false;
			document.getElementById("underline").disabled = false;
			document.getElementById("overline").disabled = false;
			document.getElementById("blink").disabled = false;
			document.getElementById("linethrough").disabled = false;
			document.getElementById("oblique").disabled = false;
			document.getElementById("small_caps").disabled = false;
			document.getElementById("no_text_decoration").disabled = false;
			document.getElementById("shadow").disabled = false;
			document.getElementById("line_height").disabled = false;
			document.getElementById("line_height_units").disabled = false;
			
			document.getElementById("bkgd_color").disabled = false;
			document.getElementById("bkgd_opacity").disabled = false;
			document.getElementById("border").disabled = false;
			document.getElementById("border_color").disabled = false;
			document.getElementById("border_style").disabled = false;
			document.getElementById("outline_style").disabled = false;
			document.getElementById("border_collapse").disabled = false;
			document.getElementById("border_top").disabled = false;
			document.getElementById("border_bottom").disabled = false;
			document.getElementById("border_left").disabled = false;
			document.getElementById("border_right").disabled = false;
			document.getElementById("padding_top").disabled = false;
			document.getElementById("padding_right").disabled = false;
			document.getElementById("padding_bottom").disabled = false;
			document.getElementById("padding_left").disabled = false;

			document.getElementById("width").disabled = false;
			document.getElementById("width_units").disabled = false;
			document.getElementById("height").disabled = false;
			document.getElementById("height_units").disabled = false;
			document.getElementById("background_image_select").disabled = false;
			document.getElementById("background_image").disabled = false;
			document.getElementById("browse_image").disabled = false;
			document.getElementById("upload_image").disabled = false;
			document.getElementById("background_attachment").disabled = false;
			document.getElementById("background_repeat").disabled = false;
			document.getElementById("background_position").disabled = false;
			document.getElementById("background_position_x").disabled = false;
			document.getElementById("background_position_y").disabled = false;
			document.getElementById("background_position_units").disabled = false;
			
			document.getElementById("margin_top_auto").disabled = false;
			document.getElementById("margin_right_auto").disabled = false;
			document.getElementById("margin_left_auto").disabled = false;
			document.getElementById("margin_bottom_auto").disabled = false;
			
			document.getElementById("position").disabled = false;
			document.getElementById("position_left").disabled = false;
			document.getElementById("position_left_units").disabled = false;
			document.getElementById("position_top").disabled = false;
			document.getElementById("position_top_units").disabled = false;
			document.getElementById("position_right").disabled = false;
			document.getElementById("position_right_units").disabled = false;
			document.getElementById("position_bottom").disabled = false;
			document.getElementById("position_bottom_units").disabled = false;
			document.getElementById("z_index").disabled = false;
			document.getElementById("overflow").disabled = false;
			document.getElementById("clip_top").disabled = false;
			document.getElementById("clip_top_units").disabled = false;
			document.getElementById("clip_right").disabled = false;
			document.getElementById("clip_right_units").disabled = false;
			document.getElementById("clip_bottom").disabled = false;
			document.getElementById("clip_bottom_units").disabled = false;
			document.getElementById("clip_left").disabled = false;
			document.getElementById("clip_left_units").disabled = false;
			document.getElementById("float").disabled = false;
			document.getElementById("white_space").disabled = false;
			
			document.getElementById("list_style_type").disabled = false;
			document.getElementById("list_style_position").disabled = false;
			document.getElementById("list_image_select").disabled = false;
			document.getElementById("list_style_image").disabled = false;
			
			document.getElementById("table_layout").disabled = false;
			
			enable_disable_shadow();
			margin_auto_clicked("top");
			margin_auto_clicked("bottom");
			margin_auto_clicked("left");
			margin_auto_clicked("right");
		}
		else
		{
			document.getElementById("font").disabled = true;
			document.getElementById("font_size").disabled = true;
			document.getElementById("text_color").disabled = true;
			document.getElementById("align").disabled = true;
			document.getElementById("vertical_align").disabled = true;
			document.getElementById("display").disabled = true;
			document.getElementById("weight").disabled = true;
			document.getElementById("font_stretch").disabled = true;
			document.getElementById("italic").disabled = true;
			document.getElementById("underline").disabled = true;
			document.getElementById("overline").disabled = true;
			document.getElementById("blink").disabled = true;
			document.getElementById("linethrough").disabled = true;
			document.getElementById("oblique").disabled = true;
			document.getElementById("small_caps").disabled = true;
			document.getElementById("no_text_decoration").disabled = true;
			document.getElementById("shadow").disabled = true;
			document.getElementById("shadow_color").disabled = true;
			document.getElementById("shadow_x_offset").disabled = true;
			document.getElementById("shadow_y_offset").disabled = true;
			document.getElementById("shadow_blur").disabled = true;
			document.getElementById("line_height").disabled = true;
			document.getElementById("line_height_units").disabled = true;
			
			document.getElementById("bkgd_color").disabled = true;
			document.getElementById("bkgd_opacity").disabled = true;
			document.getElementById("border").disabled = true;
			document.getElementById("border_color").disabled = true;
			document.getElementById("border_style").disabled = true;
			document.getElementById("outline_style").disabled = true;
			document.getElementById("border_collapse").disabled = true;
			document.getElementById("border_top").disabled = true;
			document.getElementById("border_bottom").disabled = true;
			document.getElementById("border_left").disabled = true;
			document.getElementById("border_right").disabled = true;
			document.getElementById("padding_top").disabled = true;
			document.getElementById("padding_right").disabled = true;
			document.getElementById("padding_bottom").disabled = true;
			document.getElementById("padding_left").disabled = true;
			
			document.getElementById("margin_top").disabled = true;
			document.getElementById("margin_right").disabled = true;
			document.getElementById("margin_left").disabled = true;
			document.getElementById("margin_bottom").disabled = true;
			document.getElementById("width").disabled = true;
			document.getElementById("width_units").disabled = true;
			document.getElementById("height").disabled = true;
			document.getElementById("height_units").disabled = true;
			document.getElementById("background_image_select").disabled = true;
			document.getElementById("background_image").disabled = true;
			document.getElementById("browse_image").disabled = true;
			document.getElementById("upload_image").disabled = true;
			document.getElementById("background_attachment").disabled = true;
			document.getElementById("background_repeat").disabled = true;
			document.getElementById("background_position").disabled = true;
			document.getElementById("background_position_x").disabled = true;
			document.getElementById("background_position_y").disabled = true;
			document.getElementById("background_position_units").disabled = true;
			
			document.getElementById("margin_top_units").disabled = true;
			document.getElementById("margin_top_auto").disabled = true;
			document.getElementById("margin_right_units").disabled = true;
			document.getElementById("margin_right_auto").disabled = true;
			document.getElementById("margin_left_units").disabled = true;
			document.getElementById("margin_left_auto").disabled = true;
			document.getElementById("margin_bottom_units").disabled = true;
			document.getElementById("margin_bottom_auto").disabled = true;
			
			document.getElementById("position").disabled = true;
			document.getElementById("position_left").disabled = true;
			document.getElementById("position_left_units").disabled = true;
			document.getElementById("position_top").disabled = true;
			document.getElementById("position_top_units").disabled = true;
			document.getElementById("position_right").disabled = true;
			document.getElementById("position_right_units").disabled = true;
			document.getElementById("position_bottom").disabled = true;
			document.getElementById("position_bottom_units").disabled = true;
			document.getElementById("z_index").disabled = true;
			document.getElementById("overflow").disabled = true;
			document.getElementById("clip_top").disabled = true;
			document.getElementById("clip_top_units").disabled = true;
			document.getElementById("clip_right").disabled = true;
			document.getElementById("clip_right_units").disabled = true;
			document.getElementById("clip_bottom").disabled = true;
			document.getElementById("clip_bottom_units").disabled = true;
			document.getElementById("clip_left").disabled = true;
			document.getElementById("clip_left_units").disabled = true;
			document.getElementById("float").disabled = true;
			document.getElementById("white_space").disabled = true;
			
			document.getElementById("list_style_type").disabled = true;
			document.getElementById("list_style_position").disabled = true;
			document.getElementById("list_image_select").disabled = true;
			document.getElementById("list_style_image").disabled = true;
			
			document.getElementById("table_layout").disabled = true;
		}
		if (ShowMessage == 1)
			document.getElementById("StatusMsg").innerHTML = "Click 'Update' to commit changes.";
	}
	
	function update_background_image()
	{
		var background_image = document.getElementById("background_image_select").value;
		document.getElementById("background_image").value = background_image;
	}
	
	function update_list_image()
	{
		var list_image = document.getElementById("list_image_select").value;
		document.getElementById("list_style_image").value = list_image;
	}
	
	function text_decoration_none_clicked()
	{
		if (document.getElementById("no_text_decoration").checked == true)
		{
			document.getElementById("underline").checked = false;
			document.getElementById("overline").checked = false;
			document.getElementById("blink").checked = false;
			document.getElementById("linethrough").checked = false;
		}
	}
	
	function margin_auto_clicked(side)
	{
		var margin_auto_control_name = "margin_" + side + "_auto";
		var margin_control_name = "margin_" + side;
		var margin_units_control_name = "margin_" + side + "_units";
		
		if (document.getElementById(margin_auto_control_name).checked == true)
		{
			document.getElementById(margin_control_name).disabled = true;
			document.getElementById(margin_units_control_name).disabled = true;
		}
		else
		{
			document.getElementById(margin_control_name).disabled = false;
			document.getElementById(margin_units_control_name).disabled = false;
		}
	}
	
	function enable_disable_shadow()
	{
		if (document.getElementById("shadow").checked == true)
		{
			document.getElementById("shadow_color").disabled = false;
			document.getElementById("shadow_x_offset").disabled = false;
			document.getElementById("shadow_y_offset").disabled = false;
			document.getElementById("shadow_blur").disabled = false;
		}
		else
		{
			document.getElementById("shadow_color").disabled = true;
			document.getElementById("shadow_x_offset").disabled = true;
			document.getElementById("shadow_y_offset").disabled = true;
			document.getElementById("shadow_blur").disabled = true;
		}
	}
	
	////////////////////////////////////////////////////////////////////////////////////
	
	function PopulateForm(class_select)
	{
		var class_index = class_select.selectedIndex;
		var class_name = class_select.options[class_index].value;
		var ajaxRequest;
		ajaxRequest = getXmlHttpRequestObject();

		// Create a function that will receive data sent from the server
		ajaxRequest.onreadystatechange = function(){
			if(ajaxRequest.readyState == 4){
				var row = ajaxRequest.responseText;
//				alert(row);
				if (row == "-no data-")
				{
					document.getElementById("use_table_data").checked = false;
					
					document.getElementById("font").value = "-not selected-";
					document.getElementById("font_size").value = -1;
					document.getElementById("text_color").value = "-not set-";
					document.getElementById("align").value = "-not selected-";
					document.getElementById("vertical_align").value = "-not selected-";
					document.getElementById("display").value = "-not selected-";
					document.getElementById("weight").value = "-not selected-";
					document.getElementById("font_stretch").disabled = "-not selected-";
					document.getElementById("italic").checked = false;
					document.getElementById("underline").checked = false;
					document.getElementById("overline").checked = false;
					document.getElementById("blink").checked = false;
					document.getElementById("linethrough").checked = false;
					document.getElementById("oblique").checked = false;
					document.getElementById("small_caps").checked = false;
					document.getElementById("no_text_decoration").checked = false;
					document.getElementById("line_height").value = -1;
					document.getElementById("line_height_units").value = 0;
					
					document.getElementById("shadow").checked = false;
					document.getElementById("shadow_color").value = "-not set-";
					document.getElementById("shadow_x_offset").value = 0;
					document.getElementById("shadow_y_offset").value = 0;
					document.getElementById("shadow_blur").value = 0;
			
					document.getElementById("bkgd_color").value = "-not set-";
					document.getElementById("bkgd_opacity").value = -1;
					document.getElementById("border").value = -1;
					document.getElementById("border_color").value = "-not set-";
					document.getElementById("border_style").value = "-not selected-";
					document.getElementById("outline_style").value = "-not selected-";
					document.getElementById("border_collapse").value = "-not selected-";
					document.getElementById("border_top").value = 1;
					document.getElementById("border_bottom").value = 1;
					document.getElementById("border_left").value = 1;
					document.getElementById("border_right").value = 1;
					document.getElementById("padding_top").value = -1;
					document.getElementById("padding_right").value = -1;
					document.getElementById("padding_bottom").value = -1;
					document.getElementById("padding_left").value = -1;

					document.getElementById("width").value = -1;
					document.getElementById("width_units").value = 0;
					document.getElementById("height").value = -1;
					document.getElementById("height_units").value = 0;
					document.getElementById("background_image_select").value = "-not selected-";
					document.getElementById("background_image").value = "-not selected-";
					document.getElementById("background_attachment").value = "-not selected-";
					document.getElementById("background_repeat").value = "-not selected-";
					document.getElementById("background_position").value = "-not selected-";
					document.getElementById("background_position_x").value = 0;
					document.getElementById("background_position_y").value = 0;
					document.getElementById("background_position_units").value = 0;
					
					document.getElementById("margin_top").value = -1000000;
					document.getElementById("margin_right").value = -1000000;
					document.getElementById("margin_left").value = -1000000;
					document.getElementById("margin_bottom").value = -1000000;
					document.getElementById("margin_top_auto").checked = false;
					document.getElementById("margin_right_auto").checked = false;
					document.getElementById("margin_left_auto").checked = false;
					document.getElementById("margin_bottom_auto").checked = false;
			
					document.getElementById("position").value = "-not selected-";
					document.getElementById("position_left").value = -1000000;
					document.getElementById("position_left_units").value = 0;
					document.getElementById("position_top").value = -1000000;
					document.getElementById("position_top_units").value = 0;
					document.getElementById("position_right").value = -1000000;
					document.getElementById("position_right_units").value = 0;
					document.getElementById("position_bottom").value = -1000000;
					document.getElementById("position_bottom_units").value = 0;
					document.getElementById("z_index").value = -1000000;
					document.getElementById("overflow").value = "-not selected-";
					document.getElementById("clip_top").value = -1;
					document.getElementById("clip_top_units").value = -1;
					document.getElementById("clip_right").value = -1;
					document.getElementById("clip_right_units").value = -1;
					document.getElementById("clip_bottom").value = -1;
					document.getElementById("clip_bottom_units").value = -1;
					document.getElementById("clip_left").value = -1;
					document.getElementById("clip_left_units").value = -1;
					document.getElementById("float").value = "-not selected-";
					document.getElementById("white_space").value = "-not selected-";
			
					document.getElementById("list_style_type").value = "-not selected-";
					document.getElementById("list_style_position").value = "-not selected-";
					document.getElementById("list_image_select").value = "-not selected-";
					document.getElementById("list_style_image").value = "-not selected-";
			
					document.getElementById("table_layout").value = "-not selected-";
				}
				else
				{
					var JSON_row = JSON.parse(row);
	
					if (JSON_row.use_table_data == 1)
						document.getElementById("use_table_data").checked = true;
					else
						document.getElementById("use_table_data").checked = false;
					document.getElementById("font").value = JSON_row.font;
					document.getElementById("font_size").value = JSON_row.font_size;
					document.getElementById("text_color").value = JSON_row.text_color;
					document.getElementById("align").value = JSON_row.align;
					document.getElementById("vertical_align").value = JSON_row.vertical_align;
					document.getElementById("display").value = JSON_row.display;
					document.getElementById("weight").value = JSON_row.weight;
					document.getElementById("font_stretch").disabled = JSON_row.font_stretch;
					if (JSON_row.italic == 1)
						document.getElementById("italic").checked = true;
					else
						document.getElementById("italic").checked = false;
					if (JSON_row.underline == 1)
						document.getElementById("underline").checked = true;
					else
						document.getElementById("underline").checked = false;
					if (JSON_row.overline == 1)
						document.getElementById("overline").checked = true;
					else
						document.getElementById("overline").checked = false;
					if (JSON_row.blink == 1)
						document.getElementById("blink").checked = true;
					else
						document.getElementById("blink").checked = false;
					if (JSON_row.linethrough == 1)
						document.getElementById("linethrough").checked = true;
					else
						document.getElementById("linethrough").checked = false;
					if (JSON_row.oblique == 1)
						document.getElementById("oblique").checked = true;
					else
						document.getElementById("oblique").checked = false;
					if (JSON_row.small_caps == 1)
						document.getElementById("small_caps").checked = true;
					else
						document.getElementById("small_caps").checked = false;
					if (JSON_row.no_text_decoration == 1)
						document.getElementById("no_text_decoration").checked = true;
					else
						document.getElementById("no_text_decoration").checked = false;
					document.getElementById("line_height").value = JSON_row.line_height;
					document.getElementById("line_height_units").value = JSON_row.line_heights_units;
					
					if (JSON_row.shadow == 1)
						document.getElementById("shadow").checked = true;
					else
						document.getElementById("shadow").checked = false;
					document.getElementById("shadow_color").value = JSON_row.shadow_color;
					document.getElementById("shadow_x_offset").value = JSON_row.shadow_x_offset;
					document.getElementById("shadow_y_offset").value = JSON_row.shadow_y_offset;
					document.getElementById("shadow_blur").value = JSON_row.shadow_blur;
			
					document.getElementById("bkgd_color").value = JSON_row.bkgd_color;
					document.getElementById("bkgd_opacity").value = JSON_row.bkgd_opacity;
					document.getElementById("border").value = JSON_row.border;
					document.getElementById("border_color").value = JSON_row.border_color;
					document.getElementById("border_style").value = JSON_row.border_style;
					document.getElementById("outline_style").value = JSON_row.outline_style;
					document.getElementById("border_collapse").value = JSON_row.border_collapse;
					if ((JSON_row.border_sides & 8) == 8)
						document.getElementById("border_top").checked = true;
					else
						document.getElementById("border_top").checked = false;
					if ((JSON_row.border_sides & 4) == 4)
						document.getElementById("border_bottom").checked = true;
					else
						document.getElementById("border_bottom").checked = false;
					if ((JSON_row.border_sides & 2) == 2)
						document.getElementById("border_left").checked = true;
					else
						document.getElementById("border_left").checked = false;
					if ((JSON_row.border_sides & 1) == 1)
						document.getElementById("border_right").checked = true;
					else
						document.getElementById("border_right").checked = false;
					document.getElementById("padding_top").value = JSON_row.padding_top;
					document.getElementById("padding_right").value = JSON_row.padding_right;
					document.getElementById("padding_bottom").value = JSON_row.padding_bottom;
					document.getElementById("padding_left").value = JSON_row.padding_left;

					document.getElementById("width").value = JSON_row.width;
					document.getElementById("width_units").value = JSON_row.width_units;
					document.getElementById("height").value = JSON_row.height;
					document.getElementById("height_units").value = JSON_row.height_units;
					document.getElementById("background_image_select").value = JSON_row.background_image_select;
					document.getElementById("background_image").value = JSON_row.background_image;
					document.getElementById("background_attachment").value = JSON_row.background_attachment;
					document.getElementById("background_repeat").value = JSON_row.background_repeat;
					document.getElementById("background_position").value = JSON_row.background_position;
					document.getElementById("background_position_x").value = JSON_row.background_position_x;
					document.getElementById("background_position_y").value = JSON_row.background_position_y;
					document.getElementById("background_position_units").value = JSON_row.background_position_units;
			
					document.getElementById("margin_top").value = JSON_row.margin_top;
					document.getElementById("margin_right").value = JSON_row.margin_right;
					document.getElementById("margin_left").value = JSON_row.margin_left;
					document.getElementById("margin_bottom").value = JSON_row.margin_bottom;
					if (JSON_row.margin_top_auto == 1)
						document.getElementById("margin_top_auto").checked = true;
					else
						document.getElementById("margin_top_auto").checked = false;
					if (JSON_row.margin_right_auto == 1)
						document.getElementById("margin_right_auto").checked = true;
					else
						document.getElementById("margin_right_auto").checked = false;
					if (JSON_row.margin_left_auto == 1)
						document.getElementById("margin_left_auto").checked = true;
					else
						document.getElementById("margin_left_auto").checked = false;
					if (JSON_row.margin_bottom_auto == 1)
						document.getElementById("margin_bottom_auto").checked = true;
					else
						document.getElementById("margin_bottom_auto").checked = false;
			
					document.getElementById("position").value = JSON_row.position;
					document.getElementById("position_left").value = JSON_row.position_left;
					document.getElementById("position_left_units").value = JSON_row.position_left_units;
					document.getElementById("position_top").value = JSON_row.position_top;
					document.getElementById("position_top_units").value = JSON_row.position_top_units;
					document.getElementById("position_right").value = JSON_row.position_right;
					document.getElementById("position_right_units").value = JSON_row.position_right_units;
					document.getElementById("position_bottom").value = JSON_row.position_bottom;
					document.getElementById("position_bottom_units").value = JSON_row.position_bottom_units;
					document.getElementById("z_index").value = JSON_row.z_index;
					document.getElementById("overflow").value = JSON_row.overflow;
					document.getElementById("clip_top").value = JSON_row.clip_top;
					document.getElementById("clip_top_units").value = JSON_row.clip_top_units;
					document.getElementById("clip_right").value = JSON_row.clip_right;
					document.getElementById("clip_right_units").value = JSON_row.clip_right_units;
					document.getElementById("clip_bottom").value = JSON_row.clip_bottom;
					document.getElementById("clip_bottom_units").value = JSON_row.clip_bottom_units;
					document.getElementById("clip_left").value = JSON_row.clip_left;
					document.getElementById("clip_left_units").value = JSON_row.clip_left_units;
					document.getElementById("float").value = JSON_row.float;
					document.getElementById("white_space").value = JSON_row.white_space;
			
					document.getElementById("list_style_type").value = JSON_row.list_style_type;
					document.getElementById("list_style_position").value = JSON_row.list_style_position;
					document.getElementById("list_image_select").value = JSON_row.list_image_select;
					document.getElementById("list_style_image").value = JSON_row.list_style_image;
			
					document.getElementById("table_layout").value = JSON_row.table_layout;
					
				}
				var heading_str = document.getElementById("goto_class").value;
				heading_str = heading_str.replace("PERIOD", ".");
				heading_str = heading_str.replace("POUND", "#");
				heading_str = heading_str.replace("SPACE", " ");
				heading_str = heading_str.replace("COMMA", ",");
				heading_str = heading_str.replace("PERIOD", ".");
				heading_str = heading_str.replace("POUND", "#");
				heading_str = heading_str.replace("SPACE", " ");
				heading_str = heading_str.replace("COMMA", ",");
				heading_str = heading_str.replace("PERIOD", ".");
				heading_str = heading_str.replace("POUND", "#");
				heading_str = heading_str.replace("SPACE", " ");
				heading_str = heading_str.replace("COMMA", ",");
				heading_str = heading_str.replace("PERIOD", ".");
				heading_str = heading_str.replace("POUND", "#");
				heading_str = heading_str.replace("SPACE", " ");
				heading_str = heading_str.replace("COMMA", ",");
				heading_str = heading_str.replace("PERIOD", ".");
				heading_str = heading_str.replace("POUND", "#");
				heading_str = heading_str.replace("SPACE", " ");
				heading_str = heading_str.replace("COMMA", ",");
				heading_str = heading_str.replace("PERIOD", ".");
				heading_str = heading_str.replace("POUND", "#");
				heading_str = heading_str.replace("SPACE", " ");
				heading_str = heading_str.replace("COMMA", ",");
				document.getElementById("class_heading").innerHTML = heading_str;
					
				enable_disable_controls(0);
			}
		}
		
		var queryString = "?class_table=" + "<?php echo $class_table; ?>" + "&css_table=" + "<?php echo $css_table; ?>" + "&class=" + class_name;
//		alert (queryString);
		ajaxRequest.open("GET", "populate_css_edit_form.php" + queryString, true);
		ajaxRequest.send(null);
		
		document.getElementById("class").value = class_name;
	}
	
	////////////////////////////////////////////////////////////////////////////////////
	
	function UpdateCSS()
	{
		var params = "";
		
		if (document.getElementById("StatusMsg").innerHTML == " ")
			document.getElementById("StatusMsg").innerHTML = "Starting update...";
		var xmlhttp;
		xmlhttp = getXmlHttpRequestObject();

		if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
		{
			xmlhttp.open("POST","save_css.php",true);
			xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
			xmlhttp = UpdateMessage(xmlhttp, "StatusMsg");

			params = "submit=Update";
			params = params + "&style_sheet=<? echo $style_sheet; ?>";
			params = params + "&class=" + document.getElementById("class").value;
			if (document.getElementById("use_table_data").checked == true) params = params + "&use_table_data=1";
			else params = params + "&use_table_data=0";
			params = params + "&font=" + document.getElementById("font").value;
			params = params + "&font_size=" + document.getElementById("font_size").value;
			params = params + "&text_color=" + document.getElementById("text_color").value;
			params = params + "&align=" + document.getElementById("align").value;
			params = params + "&vertical_align=" + document.getElementById("vertical_align").value;
			params = params + "&display=" + document.getElementById("display").value;
			params = params + "&weight=" + document.getElementById("weight").value;
			params = params + "&font_stretch=" + document.getElementById("font_stretch").value;
			if (document.getElementById("italic").checked == true) params = params + "&italic=1";
			else params = params + "&italic=0";
			if (document.getElementById("underline").checked == true) params = params + "&underline=1";
			else params = params + "&underline=0";
			if (document.getElementById("overline").checked == true)	params = params + "&overline=1";
			else params = params + "&overline=0";
			if (document.getElementById("blink").checked == true) params = params + "&blink=1";
			else params = params + "&blink=0";
			if (document.getElementById("linethrough").checked == true) params = params + "&linethrough=1";
			else params = params + "&linethrough=0";
			if (document.getElementById("oblique").checked == true) params = params + "&oblique=1";
			else params = params + "&oblique=0";
			if (document.getElementById("small_caps").checked == true) params = params + "&small_caps=1";
			else params = params + "&small_caps=0";
			if (document.getElementById("no_text_decoration").checked == true) params = params + "&no_text_decoration=1";
			else params = params + "&no_text_decoration=0";
			params = params + "&line_height=" + document.getElementById("line_height").value;
			params = params + "&line_height_units=" + document.getElementById("line_height_units").value;
			
			if (document.getElementById("shadow").checked == true) params = params + "&shadow=1";
			else params = params + "&shadow=0";
			params = params + "&shadow_color=" + document.getElementById("shadow_color").value;
			params = params + "&shadow_x_offset=" + document.getElementById("shadow_x_offset").value;
			params = params + "&shadow_y_offset=" + document.getElementById("shadow_y_offset").value;
			params = params + "&shadow_blur=" + document.getElementById("shadow_blur").value;
			
			params = params + "&bkgd_color=" + document.getElementById("bkgd_color").value;
			params = params + "&bkgd_opacity=" + document.getElementById("bkgd_opacity").value;
			params = params + "&border=" + document.getElementById("border").value;
			params = params + "&border_color=" + document.getElementById("border_color").value;
			params = params + "&border_style=" + document.getElementById("border_style").value;
			params = params + "&outline_style=" + document.getElementById("outline_style").value;
			params = params + "&border_collapse=" + document.getElementById("border_collapse").value;
			if (document.getElementById("border_top").checked == true) var border_top = 8;
			else var border_top = 0;
			if (document.getElementById("border_bottom").checked == true) var border_bottom = 4;
			else var border_bottom = 0;
			if (document.getElementById("border_left").checked == true) var border_left = 2;
			else var border_left = 0;
			if (document.getElementById("border_right").checked == true) var border_right = 1;
			else var border_right = 0;
			var border_sides = border_top | border_bottom | border_left | border_right;
			params = params + "&border_sides=" + border_sides;
			params = params + "&padding_top=" + document.getElementById("padding_top").value;
			params = params + "&padding_right=" + document.getElementById("padding_right").value;
			params = params + "&padding_bottom=" + document.getElementById("padding_bottom").value;
			params = params + "&padding_left=" + document.getElementById("padding_left").value;
			
			params = params + "&margin_top=" + document.getElementById("margin_top").value;
			params = params + "&margin_right=" + document.getElementById("margin_right").value;
			params = params + "&margin_left=" + document.getElementById("margin_left").value;
			params = params + "&margin_bottom=" + document.getElementById("margin_bottom").value;
			params = params + "&margin_top_units=" + document.getElementById("margin_top_units").value;
			if (document.getElementById("margin_top_auto").checked == true) params = params + "&margin_top_auto=1";
			else params = params + "&margin_top_auto=0";
			params = params + "&margin_right_units=" + document.getElementById("margin_right_units").value;
			if (document.getElementById("margin_right_auto").checked == true) params = params + "&margin_right_auto=1";
			else params = params + "&margin_right_auto=0";
			params = params + "&margin_left_units=" + document.getElementById("margin_left_units").value;
			if (document.getElementById("margin_left_auto").checked == true) params = params + "&margin_left_auto=1";
			else params = params + "&margin_left_auto=0";
			params = params + "&margin_bottom_units=" + document.getElementById("margin_bottom_units").value;
			if (document.getElementById("margin_bottom_auto").checked == true) params = params + "&margin_bottom_auto=1";
			else params = params + "&margin_bottom_auto=0";
			params = params + "&width=" + document.getElementById("width").value;
			params = params + "&width_units=" + document.getElementById("width_units").value;
			params = params + "&height=" + document.getElementById("height").value;
			params = params + "&height_units=" + document.getElementById("height_units").value;
			
			params = params + "&position=" + document.getElementById("position").value;
			params = params + "&position_left=" + document.getElementById("position_left").value;
			params = params + "&position_left_units=" + document.getElementById("position_left_units").value;
			params = params + "&position_top=" + document.getElementById("position_top").value;
			params = params + "&position_top_units=" + document.getElementById("position_top_units").value;
			params = params + "&position_right=" + document.getElementById("position_right" ).value;
			params = params + "&position_right_units=" + document.getElementById("position_right_units").value;
			params = params + "&position_bottom=" + document.getElementById("position_bottom").value;
			params = params + "&position_bottom_units=" + document.getElementById("position_bottom_units").value;
			params = params + "&z_index=" + document.getElementById("z_index").value;
			params = params + "&overflow=" + document.getElementById("overflow").value;
			params = params + "&clip_top=" + document.getElementById("clip_top").value;
			params = params + "&clip_top_units=" + document.getElementById("clip_top_units").value;
			params = params + "&clip_right=" + document.getElementById("clip_right").value;
			params = params + "&clip_right_units=" + document.getElementById("clip_right_units").value;
			params = params + "&clip_bottom=" + document.getElementById("clip_bottom").value;
			params = params + "&clip_bottom_units=" + document.getElementById("clip_bottom_units").value;
			params = params + "&clip_left=" + document.getElementById("clip_left").value;
			params = params + "&clip_left_units=" + document.getElementById("clip_left_units").value;
			params = params + "&float=" + document.getElementById("float").value;
			params = params + "&white_space=" + document.getElementById("white_space").value;

			params = params + "&background_image=" + document.getElementById("background_image").value;
			params = params + "&background_attachment=" + document.getElementById("background_attachment").value;
			params = params + "&background_repeat=" + document.getElementById("background_repeat").value;
			params = params + "&background_position=" + document.getElementById("background_position").value;
			params = params + "&background_position_x=" + document.getElementById("background_position_x").value;
			params = params + "&background_position_y=" + document.getElementById("background_position_y").value;
			params = params + "&background_position_units=" + document.getElementById("background_position_units").value;
			
			params = params + "&list_style_type=" + document.getElementById("list_style_type").value;
			params = params + "&list_style_position=" + document.getElementById("list_style_position").value;
			params = params + "&list_image_select=" + document.getElementById("list_image_select").value;
			params = params + "&list_style_image=" + document.getElementById("list_style_image").value;
			
			params = params + "&table_layout=" + document.getElementById("table_layout").value;
//			alert(params);
			
			xmlhttp.send(params);
		}
	}
	
//////////////////////////////////////////////////////////////////////////////////////
	function UpdateMessage(xmlhttp, StatusMsg_control_name)
	{
		xmlhttp.onreadystatechange=function()
		{
			if (xmlhttp.readyState==4)
			{
				if (xmlhttp.responseText.length > 0)
					document.getElementById(StatusMsg_control_name).innerHTML = "Update complete: " + xmlhttp.responseText;
				else
					document.getElementById(StatusMsg_control_name).innerHTML = "Update complete";
				var ClearMessageString = "ClearMessage('" + StatusMsg_control_name + "');";
				mTimer = setTimeout(ClearMessageString, 2000);
			}
			else if (xmlhttp.readyState==1)
				document.getElementById(StatusMsg_control_name).innerHTML = "Update ready to send...";
			else if (xmlhttp.readyState==2)
				document.getElementById(StatusMsg_control_name).innerHTML = "Update sent";
			else if (xmlhttp.readyState==3)
				document.getElementById(StatusMsg_control_name).innerHTML = "Updating...";
		}
		return (xmlhttp);
	}
	
	function ClearMessage(StatusMsg_control_name)
	{
		document.getElementById(StatusMsg_control_name).innerHTML = " ";
		clearInterval(mTimer);
	}
	
	////////////////////////////////////////////////////////////////////////////////////
	function LoadCenterParams()
	{
		alert("We will now load styles with settings that will cause your website to appear centered with a fixed width.");
		
		var params = "";
		
		if (document.getElementById("StatusMsg").innerHTML == " ")
			document.getElementById("StatusMsg").innerHTML = "Starting update...";
			
		var xmlhttp;
		xmlhttp = getXmlHttpRequestObject();
		if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
		{
			xmlhttp.open("POST","save_css.php",true);
			xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
			xmlhttp = UpdateMessage(xmlhttp, "StatusMsg");

			params = "submit=Update";
			params = params + "&style_sheet=site";
			params = params + "&class=body";
			params = params + "&use_table_data=1";
			params = params + "&align=center";
			params = params + "&bkgd_color=#111111";
			
			xmlhttp.send(params);
		}
		
		var xmlhttp2;
		xmlhttp2 = getXmlHttpRequestObject();
		if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
		{
			xmlhttp2.open("POST","save_css.php",true);
			xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
			xmlhttp2 = UpdateMessage(xmlhttp2, "StatusMsg");

			params = "submit=Update";
			params = params + "&style_sheet=site";
			params = params + "&class=#wrap";
			params = params + "&use_table_data=1";
			params = params + "&align=left";
			params = params + "&bkgd_color=#FFFFFF";
			params = params + "&position=relative";
			params = params + "&width=900";
			params = params + "&width_units=0";
			params = params + "&height=100";
			params = params + "&height_units=1";
			params = params + "&margin_left_auto=1";
			params = params + "&margin_right_auto=1";
			
			xmlhttp2.send(params);
		}
			
		alert("Your site has been centered.  You may also want to revise the 'body' width, the 'body' background color, and the '#wrap' backgound color to your needs.");
		document.getElementById("StatusMsg").innerHTML = "Your site has been centered.  You may want to revise the 'body' width, the 'body' background color, and the '#wrap' backgound color to your needs.";
	}
	
//////////////////////////////////////////////////////////////////////////////////////
	function OpenHelpWindow()
	{
		window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_css", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
	}
	
</script>
</head>

<body onLoad="enable_disable_controls(0);">
<div align="center">
<table border="0" width="90%">
 <tr>
  <td width="80%" align="center">
	<span class="title">Site Styles Editor</span>
    <a name="top_anchor"></a>
  </td>
  <td>
	<input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=css';" />
  </td>
  <td>
  	<div id="help_button_sm" onClick="OpenHelpWindow();">
	    &nbsp;
    </div>
  </td>
 </tr>
</table>

<table width="90%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
   <form action="save_css.php" method="post" enctype="multipart/form-data" name="frm_site_styles">
     <table width="100%" border="1"><tr><td>
	  <table width="100%" border="0" cellspacing="1" cellpadding="1">
	  	<tr>
		  <td>
		    <table width="100%" border="0">
			  <tr>
		        <td><h3 id="class_heading">&nbsp;</h3></td>
		        <td>Use Settings Below: <input type="checkbox" name="use_table_data" id="use_table_data" value="1" onClick="enable_disable_controls(1);"></td>
                <td>
                Go to:
                  <select name="goto_class" id="goto_class" onChange="PopulateForm(this);">
                    <option value=''>-not selected-</option>
                    <?php
				$goto_class = $_REQUEST['goto_class'];
				$search = array("PERIOD", "POUND", "SPACE", "COMMA");
				$replace = array(".", "#", " ", ",");
				$goto_class_cmp = str_replace($search, $replace, $goto_class);
				$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `sort_order`";
				$result = mysql_query($query, $bwb_link);
				while ($row = mysql_fetch_array($result))
				{
					$tmp_class = $row['class'];
					$tmp_desc = $row['description'];
					$tmp_class_val = str_replace($replace, $search, $tmp_class);
					if ($tmp_class == $goto_class_cmp)
					{
						echo "<option value='$tmp_class_val' selected='selected'>$tmp_class ----- $tmp_desc</option>\n";
						echo "<script language='JavaScript' type='text/javascript'> PopulateForm(document.getElementById('goto_class')); </script>";
					}
					else
						echo "<option value='$tmp_class_val'>$tmp_class ----- $tmp_desc</option>\n";
				}
		?>
                  </select></td>
		      </tr>
			</table>
		  </td>
	    </tr>
	    <tr>
		  <td>
		  
		    <table border="1" width="100%">
		      <tr>
			    <td>
				  <table border="0" width="100%">
				    <tr>
					  <td colspan="8" class="bold">Text</td>
				    </tr>
				    <tr>
					  <td align="right">Font: </td>
					  <td colspan="3">
					      <select name="font" id="font">
					      <?php
						  	echo "<option value='-not selected-'";
							echo ">-not selected-</option>\n";
							
						  $query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						  $result = mysql_query($query, $bwb_link);
						  while ($row = mysql_fetch_array($result))
						  {
							$tmp_font = $row['font'];
							$tmp_websafe = $row['websafe'];
							echo "<option value='$tmp_font'";
							echo " style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						  }
					      ?>
					      </select>
					  </td>
					  <td align="right">Font Size: </td>
					  <td><input name="font_size" type="text" id="font_size" value="" size="6" /> px</td>					
					  <td align="right">Color: </td>
					  <td>
					      <input name="text_color" type="text" id="text_color" value="" size="10" onBlur="CheckColorString(this);" /> 
					      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'text_color');">#RRGGBB</a></span>
					  </td>
				    </tr>
				    <tr>
					  <td align="right">&nbsp;</td>
					  <td class="small_message" valign="top">&radic; = websafe</td>
					  <td align="right">Align: </td>
					  <td>
					      <font size="1">
					      <select name="align" id="align">
						  <option value="-not selected-">-not selected-</option>
                          <option value="left">Left</option>
                          <option value="center">Center</option>
                          <option value="right">Right</option>
                          <option value="justify">Justify</option>
                          </select>
					      </font>
					  </td>
					  <td align="right">Vertical Align: </td>
					  <td>
					      <select name="vertical_align" id="vertical_align">
						  <option value="-not selected-">-not selected-</option>
					      <option value="baseline">Baseline</option>
					      <option value="sub">Sub</option>
					      <option value="super">Super</option>
					      <option value="top">Top</option>
					      <option value="text-top">Text Top</option>
					      <option value="middle">Middle</option>
					      <option value="bottom">Bottom</option>
					      <option value="text-bottom">Text Bottom</option>              
					      </select>
				      </td>
					  <td align="right">&nbsp;</td>
					  <td>&nbsp;</td>
				    </tr>
					<tr>
					  <td align="right">Weight: </td>
					  <td>
					      <select name="weight" id="weight">
					   <option value="-not selected-">-not selected-</option>
					   <option value="normal">Normal</option>
					   <option value="bold">Bold</option>
					   <option value="bolder">Bolder</option>
					   <option value="lighter">Lighter</option>
					   <option value="100">100</option>
					   <option value="200">200</option>
					   <option value="300">300</option>
					   <option value="400">400</option>
					   <option value="500">500</option>
					   <option value="600">600</option>
					   <option value="700">700</option>
					   <option value="800">800</option>
					   <option value="900">900</option>
					   </select>
					  </td>
					  <td align="right">Font Stretch:</td>
					  <td>
					   <select name="font_stretch" id="font_stretch">
					   <option value="-not selected-">-not selected-</option>
					   <option value="normal">Normal</option>
					   <option value="wider">Wider</option>
					   <option value="narrower">Narrower</option>
					   <option value="ultra-condensed">Ultra-Condensed</option>
					   <option value="extra-condensed">Extra-Condensed</option>
					   <option value="condensed">Condensed</option>
					   <option value="semi-condensed">Semi-Condensed</option>
					   <option value="semi-expanded">Semi-Expanded</option>
					   <option value="expanded">Expanded</option>
					   <option value="extra-expanded">Extra-Expanded</option>
					   <option value="ultra-expanded">Ultra-Expanded</option>
					   </select>
					  </td>  
					  <td align="right">Line Height: </td>
					  <td colspan="2" >
					   <input name="line_height" type="text" id="line_height" value="" size="6">
                       <select name="line_height_units" id="line_height_units">
						    <option value="0">Normal</option>
						    <option value="1">Multiplier</option>
                            <option value="2">px</option>
                            <option value="3">%</option>
                            <option value="4">Inherit</option>
						</select>
					  </td>
					  <td class="small_message" align="right" valign="bottom">Click &quot;None&quot; only to explicitly enforce no text decoration.</td>
					</tr>
				    <tr>
					  <td colspan="8">
					    <table border="0" width="100%">
					      <tr>
						    <td align="center">
							   Italic: 
							   <input name="italic" type="checkbox" id="italic" value="1" />
						    </td>
						    <td align="center">
						       Underline: 
						       <input name="underline" type="checkbox" id="underline" value="1" />
						    </td>
						    <td align="center">
						       Overline: 
						       <input name="overline" type="checkbox" id="overline" value="1" />
						    </td>
						    <td align="center">
						       Blink: 
						       <input name="blink" type="checkbox" id="blink" value="1" />
						    </td>
						    <td align="center">
						       Linethrough: 
						       <input name="linethrough" type="checkbox" id="linethrough" value="1" />
						    </td>
						    <td align="center">
						       Oblique: 
						       <input name="oblique" type="checkbox" id="oblique" value="1" />
						    </td>
						    <td align="center">
						       Small Caps: 
						       <input name="small_caps" type="checkbox" id="small_caps" value="1" />
						    </td>
                            <td align="center">
						       None: 
						       <input name="no_text_decoration" type="checkbox" id="no_text_decoration" value="1" onChange="text_decoration_none_clicked();" />
						    </td>
						  </tr>
					    </table>
                        <table border="0" width="100%">
                          <tr>
                             <td align="center">
                                Shadow:
                                <input name="shadow" type="checkbox" id="shadow" value="1" onClick="enable_disable_shadow();" /> 
                            </td>
                            <td align="center">
                                Color: 
                                  <input name="shadow_color" type="text" id="shadow_color" value="" size="10" onBlur="CheckColorString(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'shadow_color');">#RRGGBB</a></span>						  </td>
                            <td align="center">
                                X-Offset: 
                                  <input name="shadow_x_offset" type="text" id="shadow_x_offset" value="" size="10" /> 
                                  px
                           </td>
                           <td align="center">
                                Y-Offset: 
                                  <input name="shadow_y_offset" type="text" id="shadow_y_offset" value="" size="10" /> 
                                  px
                           </td>
                           <td align="center">
                                Blur: 
                                  <input name="shadow_blur" type="text" id="shadow_blur" value="" size="10" /> 
                                  px
                           </td>
                         </tr>
                       </table>
					  </td>
				    </tr>
			      </table>
			    </td>
			   </tr>
             </table>
			 
	       </td>
	     </tr>
	     <tr>
	       <td>
		   
		     <table border="1" width="100%">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="8" class="bold">Background</td>
				     </tr>
				     <tr>
					   <td align="right">Background Color: </td>
					   <td>
					     <input name="bkgd_color" type="text" id="bkgd_color" value="" size="10" onBlur="CheckColorString(this);" />
                         <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'bkgd_color');"> #RRGGBB</a></span>
					   </td>					  
					   <td align="right">Opacity: </td>
					   <td>
					     <input name="bkgd_opacity" type="text" id="bkgd_opacity" value="" size="10" /> % 
					   </td>
					   <td align="right">Table Layout:</td>
					   <td>
                       <select name="table_layout" id="table_layout">
					     <option value="-not selected-">-not selected-</option>
                         <option value="auto">Auto</option>
                         <option value="fixed">Fixed</option>
                         <option value="inherit">Inherit</option>
					     </select>
                       </td>
					   <td align="right">&nbsp;</td>
					   <td>&nbsp;
                       
					   </td>
				     </tr>
			       </table>
			     </td>
			   </tr>
	         </table>
             
           </td>
	     </tr>
         <tr>
	       <td>
		   
		     <table border="1" width="100%">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold">Border</td>
				     </tr>
				     <tr>
					   <td align="right">Border: </td>
					   <td>
					     <input name="border" type="text" id="border" value="" size="6" /> px
					   </td>					  
					   <td align="right">Border Color: </td>
					   <td>
					     <input name="border_color" type="text" id="border_color" value="" size="10" onBlur="CheckColorString(this);" />
                         <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'border_color');"> #RRGGBB</a></span>
                         </td>
					   <td align="right">Border Style: </td>
					   <td>
                       <select name="border_style" id="border_style">
					     <option value="-not selected-">-not selected-</option>
                         <option value="none">None</option>
					     <option value="hidden">Hidden</option>
                         <option value="dotted">Dotted</option>
                         <option value="dashed">Dashed</option>
                         <option value="solid">Solid</option>
                         <option value="double">Double</option>
                         <option value="groove">Groove</option>
                         <option value="ridge">Ridge</option>
                         <option value="inset">Inset</option>
                         <option value="outset">Outset</option>
                         <option value="inherit">Inherit</option>
					     </select>
                       </td>
					   <td align="right">Outline Style: </td>
					   <td>
                       <select name="outline_style" id="outline_style">
					     <option value="-not selected-">-not selected-</option>
                         <option value="none">None</option>
                         <option value="dotted">Dotted</option>
                         <option value="dashed">Dashed</option>
                         <option value="solid">Solid</option>
                         <option value="double">Double</option>
                         <option value="groove">Groove</option>
                         <option value="ridge">Ridge</option>
                         <option value="inset">Inset</option>
                         <option value="outset">Outset</option>
                         <option value="inherit">Inherit</option>
					     </select>
					   </td>
                       <td align="right">Border Collapse: </td>
					   <td>
                       <select name="border_collapse" id="border_collapse">
					     <option value="-not selected-">-not selected-</option>
                         <option value="collapse">Collapse</option>
                         <option value="separate">Separate</option>
                         <option value="inherit">Inherit</option>
					     </select>
					   </td>
				     </tr>
                  </table>
                  <table width="100%" border="0">
                     <tr>
                       <td>Top: <input name="border_top" type="checkbox" id="border_top" value="1" /> </td>
                       <td>Bottom: <input name="border_bottom" type="checkbox" id="border_bottom" value="1" /> </td>
                       <td>Left: <input name="border_left" type="checkbox" id="border_left" value="1" /> </td>
                       <td>Right: <input name="border_right" type="checkbox" id="border_right" value="1" /> </td>
					   <td align="right" class="bold">Padding</td>
					   <td align="right">
                       Top:</td>					  
					   <td>
                       <input name="padding_top" type="text" id="padding_top" value="" size="6"> px
                       </td>
					   <td align="right">Right:</td>
					   <td>
                       <input name="padding_right" type="text" id="padding_right" value="" size="6"> px
                       </td>
					   <td align="right">Bottom:</td>
					   <td>
                       <input name="padding_bottom" type="text" id="padding_bottom" value="" size="6"> px
                       </td>
					   <td align="right">Left:</td>
                       <td>
                       <input name="padding_left" type="text" id="padding_left" value="" size="6"> px
                       </td>
				     </tr>
			       </table>
			     </td>
			   </tr>
	         </table>
             
           </td>
	     </tr>
	     <tr>
	       <td>
			 
	         <table border="1" width="100%">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="4" class="bold">Margin </td>
                       <td colspan="4" align="center"><span class="small_message">Click &quot;Auto&quot; only to explicitly enforce auto margin.</span></td>
                       <td colspan="2" ><span class="bold">Size</span></td>
				     </tr>
				     <tr>
					   <td align="right">Top: </td>
					   <td>
						  <input name="margin_top" type="text" id="margin_top" value="" size="6" />
						  <select name="margin_top_units" id="margin_top_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select> 
                       </td>					  
					   <td align="right">Right: </td>
					   <td>
					     <input name="margin_right" type="text" id="margin_right" value="" size="6" /> 				
                         <select name="margin_right_units" id="margin_right_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>					
					   <td align="right">Left: </td>
					   <td>
					     <input name="margin_left" type="text" id="margin_left" value="" size="6"/>
                         	<select name="margin_left_units" id="margin_left_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select> 
					   </td>
					   <td align="right">Bottom: </td>
					   <td>
					     <input name="margin_bottom" type="text" id="margin_bottom" value="" size="6" />
                         <select name="margin_bottom_units" id="margin_bottom_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
                       <td align="right">Width: </td>
					   <td>
					     <input name="width" type="text" id="width" value="" size="6" />
					     <select name="width_units" id="width_units">
                          <option value="0">px</option>
                          <option value="1">%</option>
					     </select>
                       </td>
				     </tr>
                     <tr>
                     	<td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_top_auto" type="checkbox" id="margin_top_auto" value="1" onChange="margin_auto_clicked('top')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_right_auto" type="checkbox" id="margin_right_auto" value="1" onChange="margin_auto_clicked('right')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_left_auto" type="checkbox" id="margin_left_auto" value="1" onChange="margin_auto_clicked('left')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_bottom_auto" type="checkbox" id="margin_bottom_auto" value="1" onChange="margin_auto_clicked('bottom')" />
                        </td>
                        <td align="right">Height: </td>
					   <td>
					     <input name="height" type="text" id="height" value="" size="6" />
                         <select name="height_units" id="height_units">
                          <option value="0">px</option>
                          <option value="1">%</option>
					     </select>
					   </td>
                     </tr>
			       </table>
                   
                </td>
               </tr>
              </table>
                   
               <table border="1" width="100%">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold">Position</td>
				     </tr>
				     <tr>
                       <td align="right">Positioning: </td>
					   <td><select name="position" id="position">
                         <option value="-not selected-">-not selected-</option>
					     <option value="absolute">Absolute</option>
					     <option value="fixed">Fixed</option>
                         <option value="relative">Relative</option>
                         <option value="static">Static</option>
                         <option value="inherit">Inherit</option>
					     </select>
                       </td>
					   <td align="right">Left: </td>
					   <td>
						  <input name="position_left" type="text" id="position_left" value="" size="6" />
						  <select name="position_left_units" id="position_left_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
                        </td>					  
					   <td align="right">Top: </td>
					   <td>
					     <input name="position_top" type="text" id="position_top" value="" size="6" />
                         <select name="position_top_units" id="position_top_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>					
					   <td align="right">Right: </td>
					   <td>
					     <input name="position_right" type="text" id="position_right" value="" size="6" />
                         <select name="position_right_units" id="position_right_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
					   <td align="right">Bottom: </td>
					   <td>
					     <input name="position_bottom" type="text" id="position_bottom" value="" size="6" />
                         <select name="position_bottom_units" id="position_bottom_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
				     </tr>
                     <tr>
                       <td align="right">Display: </td>
					   <td>
                       <select name="display" id="display">
						  <option value="-not selected-">-not selected-</option>
					      <option value="none">None</option>
					      <option value="inline">Inline</option>
					      <option value="block">Block</option>
                          <option value="inline-block">Inline-Block</option>
					      <option value="list-item">List Item</option>
					      <option value="run-in">Run In</option>
					      <option value="compact">Compact</option>
					      <option value="marker">Marker</option>
					      <option value="table">Table</option>
					      <option value="inline-table">Inline Table</option>
					      <option value="table-row-group">Table Row Group</option>
					      <option value="table-footer-group">Table Footer Group</option>
					      <option value="table-row">Table Row</option>
					      <option value="table-column-group">Table Column Group</option>
					      <option value="table-column">Table Column</option>
					      <option value="table-cell">Table Cell</option>
					      <option value="table-caption">Table Caption</option>
					      </select>
                       </td>
					   <td align="right">Z Index:</td>
					   <td>
                       <input name="z_index" type="text" id="z_index" value="" size="6" />
                        </td>					  
					   <td align="right">Overflow:</td>
					   <td>
                       <select name="overflow" id="overflow">
					     <option value="-not selected-">-not selected-</option>
                         <option value="visible">Visible</option>
					     <option value="hidden">Hidden</option>
                         <option value="scroll">Scroll</option>
                         <option value="auto">Auto</option>
                         <option value="inherit">Inherit</option>
					     </select>
                       </td>					
					   <td align="right">Float: </td>
					   <td>
                       <select name="float" id="float">
					     <option value='-not selected-'>-not selected-</option>
                         <option value='left'>Left</option>
                         <option value='right'>Right</option>
                         <option value='none'>None</option>
                         <option value='inherit'>Inherit</option>
					     </select>
                       </td>
					   <td align="right">White Space:</td>
					   <td>
                       <select name="white_space" id="white_space">
					     <option value='-not selected-'>-not selected-</option>
					     <option value='normal'>Normal</option>
                         <option value='nowrap'>No Wrap</option>
                         <option value='pre'>Pre</option>
                         <option value='pre-line'>Pre-Line</option>
                         <option value='pre-wrap'>Pre-Wrap</option>
                         <option value='inherit'>Inherit</option>
					     </select>
                       </td>
				     </tr>
                     <tr>
                       <td>&nbsp;</td>
					   <td align="right">Clipping:</td>
					   <td align="right">Top: </td>
					   <td>
						  <input name="clip_top" type="text" id="clip_top" value="" size="6" />
						  <select name="clip_top_units" id="clip_top_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
                        </td>					  
					   <td align="right">Right: </td>
					   <td>
					     <input name="clip_right" type="text" id="clip_right" value="" size="6" /> 				
                         <select name="clip_right_units" id="clip_right_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>					
					   <td align="right">Bottom: </td>
					   <td>
					     <input name="clip_bottom" type="text" id="clip_bottom" value="" size="6" /> 					
                         <select name="clip_bottom_units" id="clip_bottom_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
					   <td align="right">Left: </td>
					   <td>
					     <input name="clip_left" type="text" id="clip_left" value="" size="6" /> 				
                         <select name="clip_left_units" id="clip_left_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>
             
             <table border="1" width="100%">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold">Background Image</td>
				     </tr>
				     <tr>
					   <td align="right">Image: </td>
					   <td><select name="background_image_select" id="background_image_select" onChange="update_background_image()">
                       		<option value='-not selected-'>-not selected-</option>
                       <?php
					   $file_arr = array();
					   $document_root = $_SERVER['DOCUMENT_ROOT'];
						if (BWB_BASE_DIR == '')
							$path = $document_root . "/" . BWB_IMAGE_DIR;
						else
							$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR;
						
					   	if ($handle = opendir($path)) 
						{
							/* This is the correct way to loop over the directory. */
							while (false !== ($file = readdir($handle)))
							{
								if (($file != ".") && ($file != ".."))
								{
									$file_arr[] = $file;
								}
							}
							closedir($handle);
							
							sort($file_arr);
							foreach($file_arr as $file)
							{
								if ($background_image == $file)
									echo "      <option value='$file' selected='selected'>$file</option>\n";
								else
									echo "      <option value='$file'>$file</option>\n";
							}
					    } 
                       ?>
					     </select></td>					  
					   <td align="left"> <input name="background_image" type="text" id="background_image" value="" /></td>
					   <td>&nbsp;</td>					
					   <td align="right">Attachment:</td>
					   <td><select name="background_attachment" id="background_attachment">
                         <option value="-not selected-">-not selected-</option>
                         <option value="fixed">Fixed</option>
					     <option value="scroll">Scrolling</option>
					     </select></td>
					   <td align="right">Repeat:</td>
					   <td><select name="background_repeat" id="background_repeat">
					     <option value="-not selected-">-not selected-</option>
                         <option value="repeat">Repeat</option>
					     <option value="repeat-x">Repeat Horizontally</option>
					     <option value="repeat-y">Repeat Vertically</option>
					     <option value="no-repeat">No Repeat</option>
					     </select></td>
                       <td align="right">&nbsp;</td>
					   <td>&nbsp;</td>
				     </tr>
                     <tr>
					   
					   <td align="center" colspan="2">
                       	<input type="file" name="browse_image" id="browse_image" />	
                       </td>					  
					   <td align="left"><input type="submit" name="submit" id="upload_image" value="Upload" /></td>
                       <td>&nbsp;</td>
                       
                       <td colspan="6">
                       <table border="1" width="100%">
                       <tr>
                       <td>
                       <table border="0" width="100%">
                       <tr>
                           <td align="right">Position:</td>
                           <td><select name="background_position" id="background_position">
                             <option value="-not selected-">-not selected-</option>
                             <option value="top left">top left</option>
                             <option value="top center">top center</option>
                             <option value="top right">top right</option>
                             <option value="center left">center left</option>
                             <option value="center center">center center</option>
                             <option value="center right">center right</option>
                             <option value="bottom left">bottom left</option>
                             <option value="bottom center">bottom center</option>
                             <option value="bottom right">bottom right</option>
                             <option value="xpos ypos">xpos ypos</option>
                             </select></td>
                           <td align="right">X:</td>
                           <td><input name="background_position_x" type="text" id="background_position_x" value="" size="6" /></td>
                           <td align="right">Y:</td>
                           <td><input name="background_position_y" type="text" id="background_position_y" value="" size="6" /></td>
                           <td>
                             <select name="background_position_units" id="background_position_units">
                               <option value="0">px</option>
                               <option value="1">%</option>
                             </select>
                           </td>
                        </tr>
                       </table>
                       
                       </td>       
                      </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>
			 
	       </td>
	     </tr>
	   </table>
       
       <table border="1" width="100%">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="8" class="bold">List</td>
				     </tr>
				     <tr>
                       <td align="right">Type: </td>
					   <td><select name="list_style_type" id="list_style_type">
					     <option value="-not selected-">-not selected-</option>
					     <option value="none">None</option>
					     <option value="disc">Disc</option>
					     <option value="circle">Circle</option>
					     <option value="square">Square</option>
					     <option value="decimal">Decimal</option>
					     <option value="decimal-leading-zero">Decimal Leading Zero</option>
					     <option value="lower-roman">Lower Roman</option>
					     <option value="upper-roman">Upper Roman</option>
					     <option value="lower-alpha">Lower Alpha</option>
					     <option value="upper-alpha">Upper Alpha</option>
					     <option value="lower-greek">Lower Greek</option>
					     <option value="lower-latin">Lower Latin</option>
					     <option value="upper-latin">Upper Latin</option>
					     <option value="hebrew">Hebrew</option>
					     <option value="armenian">Armenian</option>
					     <option value="gorgian">Georgian</option>
					     <option value="cjk-ideographic">CJK-Ideographic</option>
					     <option value="hiragana">Hiragana</option>
					     <option value="katakana">Katakana</option>
					     <option value="hiragana-iroha">Hiragana Iroha</option>
					     <option value="katakana-iroha">Katakana Iroha </option>
					     </select>
                       </td>
					   <td align="right">Position: </td>
					   <td><select name="list_style_position" id="list_style_position">
					     <option value="-not selected-">-not selected-</option>
					     <option value="inside">Inside</option>
					     <option value="outside">Outside</option>
					     <option value="inherit">Inherit</option>
					     </select></td>					  
					   <td align="right">Image: </td>
					   <td>
                       <select name="list_image_select" id="list_image_select" onChange="update_list_image()">
					     <option value='-not selected-'>-not selected-</option>
					   <?php
						foreach($file_arr as $file)
						{
							if ($list_style_image == $file)
								echo "      <option value='$file' selected='selected'>$file</option>\n";
							else
								echo "      <option value='$file'>$file</option>\n";
						}
                       ?>
					     </select>
                       </td>					
					   <td>
                       <input name="list_style_image" type="text" id="list_style_image" value="">
                       </td>
					   <td class="small_message">Upload new images via browse/upload for background image.</td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>

             
	 </td></tr></table>
     </td>
     <tr><td align="center">
     <table width="100%">
       <tr>
     	<td align="center">
            <input type="submit" value="Preview" name="submit" />
            <input type="hidden" name="MAX_FILE_SIZE" value="500000" />
            <input type="hidden" name="browse_image_control" value="browse_image"/>
            <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
            <input type="hidden" name="show_class_editor" value="<?php echo $show_class_editor; ?>" />
            <input type="hidden" name="class" id="class" value="<?php echo $goto_class; ?>"/>
        </td>
        <td align="center" width="70%">
        	<div id="StatusMsg"> </div>
        </td>
        <td align="center">
        	<input type="button" name="update" id="update" value="Update" onClick="UpdateCSS();">
        </td>
       </tr>
      </table>
      </td></tr></table>
      </form>
	 
	   <table width="100%" border="0" cellspacing="1" cellpadding="1"> 
       <?php
	   		if (($show_class_editor == 1) || ($style_sheet == "site"))
			{
		?>
	     <tr>
          <?php
	   		if ($style_sheet == "site")
			{
		  ?>
           <td align="center">
         		<input type="button" name="load_center_params" id="load_center_params" value="Setup For Centered Pages" onClick="LoadCenterParams();">
           </td>
           <?php
			}
		 
	   		if ($show_class_editor == 1)
			{
		   ?>
		 	<td align="center">
             <input type="button" value="Add/Delete Custom Style" name="manage_tags" onClick="window.location.href='classes.php?style_sheet=<?php echo $style_sheet; ?>';"/>
		    </td>
          <?php
			}
		  ?>
		 </tr>
         <?php
			}
		?>
       </table>
	 
       <table width="100%" border="0" cellspacing="0" cellpadding="0">
         <tr>
	       <td>&nbsp;
             
           </td>
	     </tr>
         <tr>
		   <td align="center">
             <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=css';" />
		   </td>
	     </tr>
       </table>
	 </td>
   </tr>
</table>
<a name="bottom_anchor"></a>
</div>

</body>
</html>