<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/18/2009	ELL
// Modified: 1/7/2010		ELL
// Changed the way hover text color is handled.  Was able to add separate user-electable sublevel 2 hover text color.
// Revised: 10/7/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 1/10/2011	ELL
// Added preview mode.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
		
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<script type="text/javascript" src="js/check_color_str.js"></script>

<script language="javascript" type="text/javascript" >
	function SelectMenu(menu)
	{
		var url = "edit_css_menu_styles.php?menu=" + menu;
		window.location.href = url;
	}

	function popupcolorpicker(form_name, field_name)
	{
		var start_color = document.getElementById(field_name).value;
		if (start_color == "")
			start_color = "-not set-";
		else
			start_color = start_color.replace("#", "");
		
		var URL = "colorpicker.php?form_name=" + form_name + "&field_name=" + field_name + "&source_page=edit_css_menu_styles.php&start_color=" + start_color;
		
		window.open (URL, "colorpicker", "alwaysRaised=0,dependent=1,menubar=0,resizable=0,width=450,height=350,scrollbars=0,location=0");
	}
	
	function OpenHelpWindow()
	{
		window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_css_menu_styles", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
	}
</script>
</head>

<body>

<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td class="bold" width="40%">
Select a menu to add items to:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus`";
	$result = mysql_query($query, $bwb_link);
	while($row = mysql_fetch_array($result))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
?>
</select>
</td>
<td>
<span class="title">CSS Menu Styles Quick-Setup Editor</span>
</td>
<td align="left">
  <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=menu';" />
</td>
<td valign="top" align="right">
          <div id="help_button_sm" onClick="OpenHelpWindow();">
            &nbsp;
          </div>
        </td>
</tr>
</table>

<?php
	if (($menu == "-not selected-") || ($menu == ""))
	{
		echo "Please select a menu to edit menu items.";
		exit;
	}
	else
		$suffix = substr($menu, 4);
	
	$menu_source  = "menu" . $suffix . "_items" ;
	
	$menu_css_table = $menu . "_css" ;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = mysql_query($query, $bwb_link);
	$row_count = mysql_num_rows($result);
	if ($row_count < 1)
	{
		echo "CSS menu parameters have not been set.  Please click <a href='edit_css_menu_params.php'>here</a> to setup the CSS menu parameters";
		exit;
	}
	$row = mysql_fetch_array($result);
	if ($row["border"] == -2)
		$load_defaults = 1;
	else
		$load_defaults = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.top_level_a" . $suffix . "'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$top_level_font = $row["font"];
	elseif($load_defaults == 1)
		$top_level_font = "Arial";
	else
		$top_level_font = "-not set-";
	if (!is_null($row["font_size"]))
		$top_level_font_size = $row["font_size"];
	else
		$top_level_font_size = -1;
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$top_level_weight = $row["weight"];
	elseif($load_defaults == 1)
		$top_level_weight = "bold";
	else
		$top_level_weight = "-not set-";
	if (!is_null($row["font_stretch"]))
		$top_level_font_stretch = $row["font_stretch"];
	else
		$top_level_font_stretch = "-not selected-";
	if (!is_null($row["italic"]))
		$top_level_italic = $row["italic"];
	else
		$top_level_italic = 0;
	if (!is_null($row["underline"]))
		$top_level_underline = $row["underline"];
	else
		$top_level_underline = 0;
	if (!is_null($row["overline"]))
		$top_level_overline = $row["overline"];
	else
		$top_level_overline = 0;
	if (!is_null($row["blink"]))
		$top_level_blink = $row["blink"];
	else
		$top_level_blink = 0;
	if (!is_null($row["oblique"]))
		$top_level_oblique = $row["oblique"];
	else
		$top_level_oblique = 0;
	if (!is_null($row["small_caps"]))
		$top_level_small_caps = $row["small_caps"];
	else
		$top_level_small_caps = 0;
	if (!is_null($row["shadow"]))
		$top_level_shadow = $row["shadow"];
	else
		$top_level_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$top_level_shadow_color = $row["shadow_color"];
	else
		$top_level_shadow_color = "-not set-";
	if (!is_null($row["shadow_x_offset"]))
		$top_level_shadow_x_offset = $row["shadow_x_offset"];
	else
		$top_level_shadow_x_offset = 0;
	if (!is_null($row["shadow_y_offset"]))
		$top_level_shadow_y_offset = $row["shadow_y_offset"];
	else
		$top_level_shadow_y_offset = 0;
	if (!is_null($row["shadow_blur"]))
		$top_level_shadow_blur = $row["shadow_blur"];
	else
		$top_level_shadow_blur = 0;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color = $row["text_color"];
	elseif($load_defaults == 1)
		$top_level_text_color = "#336699";
	else
		$top_level_text_color = "-not set-";
		
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_1_a" . $suffix . "'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$sub_level_1_font = $row["font"];
	elseif($load_defaults == 1)
		$sub_level_1_font = "Arial";
	else
		$sub_level_1_font = "-not set-";
	if (!is_null($row["font_size"]))
		$sub_level_1_font_size = $row["font_size"];
	else
		$sub_level_1_font_size = -1;
	if (!is_null($row["weight"]))
		$sub_level_1_weight = $row["weight"];
	else
		$sub_level_1_weight = "bold";
	if (!is_null($row["font_stretch"]))
		$sub_level_1_font_stretch = $row["font_stretch"];
	else
		$sub_level_1_font_stretch = "-not selected-";
	if (!is_null($row["italic"]))
		$sub_level_1_italic = $row["italic"];
	else
		$sub_level_1_italic = 0;
	if (!is_null($row["underline"]))
		$sub_level_1_underline = $row["underline"];
	else
		$sub_level_1_underline = 0;
	if (!is_null($row["overline"]))
		$sub_level_1_overline = $row["overline"];
	else
		$sub_level_1_overline = 0;
	if (!is_null($row["blink"]))
		$sub_level_1_blink = $row["blink"];
	else
		$sub_level_1_blink = 0;
	if (!is_null($row["oblique"]))
		$sub_level_1_oblique = $row["oblique"];
	else
		$sub_level_1_oblique = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_1_small_caps = $row["small_caps"];
	else
		$sub_level_1_small_caps = 0;
	if (!is_null($row["shadow"]))
		$sub_level_1_shadow = $row["shadow"];
	else
		$sub_level_1_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_1_shadow_color = $row["shadow_color"];
	else
		$sub_level_1_shadow_color = "-not set-";
	if (!is_null($row["shadow_x_offset"]))
		$sub_level_1_shadow_x_offset = $row["shadow_x_offset"];
	else
		$sub_level_1_shadow_x_offset = 0;
	if (!is_null($row["shadow_y_offset"]))
		$sub_level_1_shadow_y_offset = $row["shadow_y_offset"];
	else
		$sub_level_1_shadow_y_offset = 0;
	if (!is_null($row["shadow_blur"]))
		$sub_level_1_shadow_blur = $row["shadow_blur"];
	else
		$sub_level_1_shadow_blur = 0;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_1_text_color = "#336699";
	else
		$sub_level_1_text_color = "-not set-";
		
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_2_a" . $suffix . "'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$sub_level_2_font = $row["font"];
	elseif($load_defaults == 1)
		$sub_level_2_font = "Arial";
	else
		$sub_level_2_font = "-not set-";
	if (!is_null($row["font_size"]))
		$sub_level_2_font_size = $row["font_size"];
	else
		$sub_level_2_font_size = -1;
	if (!is_null($row["weight"]))
		$sub_level_2_weight = $row["weight"];
	else
		$sub_level_2_weight = "bold";
	if (!is_null($row["font_stretch"]))
		$sub_level_2_font_stretch = $row["font_stretch"];
	else
		$sub_level_2_font_stretch = "-not selected-";
	if (!is_null($row["italic"]))
		$sub_level_2_italic = $row["italic"];
	else
		$sub_level_2_italic = 0;
	if (!is_null($row["underline"]))
		$sub_level_2_underline = $row["underline"];
	else
		$sub_level_2_underline = 0;
	if (!is_null($row["overline"]))
		$sub_level_2_overline = $row["overline"];
	else
		$sub_level_2_overline = 0;
	if (!is_null($row["blink"]))
		$sub_level_2_blink = $row["blink"];
	else
		$sub_level_2_blink = 0;
	if (!is_null($row["oblique"]))
		$sub_level_2_oblique = $row["oblique"];
	else
		$sub_level_2_oblique = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_2_small_caps = $row["small_caps"];
	else
		$sub_level_2_small_caps = 0;
	if (!is_null($row["shadow"]))
		$sub_level_2_shadow = $row["shadow"];
	else
		$sub_level_2_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_2_shadow_color = $row["shadow_color"];
	else
		$sub_level_2_shadow_color = "-not set-";
	if (!is_null($row["shadow_x_offset"]))
		$sub_level_2_shadow_x_offset = $row["shadow_x_offset"];
	else
		$sub_level_2_shadow_x_offset = 0;
	if (!is_null($row["shadow_y_offset"]))
		$sub_level_2_shadow_y_offset = $row["shadow_y_offset"];
	else
		$sub_level_2_shadow_y_offset = 0;
	if (!is_null($row["shadow_blur"]))
		$sub_level_2_shadow_blur = $row["shadow_blur"];
	else
		$sub_level_2_shadow_blur = 0;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_2_text_color = "#336699";
	else
		$sub_level_2_text_color = "-not set-";
		

//	$query = "SELECT * FROM " . $menu_css_table . " WHERE class = '.nav" . $suffix . " a:hover'";
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.top_level_li" . $suffix . " A:hover'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color_hover = $row["text_color"];
	elseif($load_defaults == 1)
		$top_level_text_color_hover = "#FFFFFF";
	else
		$top_level_text_color_hover = "-not set-";
		
//////////////////// new /////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_1_li" . $suffix . " A:hover'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color_hover = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_1_text_color_hover = "#FFFFFF";
	else
		$sub_level_1_text_color_hover = "-not set-";
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_2_li" . $suffix . " A:hover'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color_hover = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_2_text_color_hover = "#FFFFFF";
	else
		$sub_level_2_text_color_hover = "-not set-";
//////////////////////////////////////////////////////////////

	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li:hover, .nav" . $suffix . " ul li a:hover'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
/*
	if (!is_null($row["text_color"])  && ($row["text_color"] != ""))
		$sub_level_1_text_color_hover = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_1_text_color_hover = "#FFFFFF";
	else
		$sub_level_1_text_color_hover = "-not set-";
*/
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_hover = $row["bkgd_color"];
	elseif($load_defaults == 1)
		$top_level_background_color_hover = "#336699";
	else
		$top_level_background_color_hover = "-not set-";
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_hover = $row["border_color"];
	else
		$top_level_item_border_color_hover = "-not set-";
		
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul, .nav" . $suffix . " ul li a'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_background_color = $row["bkgd_color"];
	elseif($load_defaults == 1)
		$sub_level_background_color = "#FFFFFF";
	else
		$sub_level_background_color = "-not set-";
		
	
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ">li'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color = $row["bkgd_color"];
	elseif($load_defaults == 1)
		$top_level_background_color = "#FFFFFF";
	else
		$top_level_background_color = "-not set-";
	if ($row["border"] > -1)
		$top_level_item_border_width = $row["border"];
	else
		$top_level_item_border_width = -1;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color = $row["border_color"];
	else
		$top_level_item_border_color = "-not set-";
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$top_level_item_border_top = 1;
		else
			$top_level_item_border_top = 0;
		if (($border_sides & 4) == 4)
			$top_level_item_border_bottom = 1;
		else
			$top_level_item_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$top_level_item_border_left = 1;
		else
			$top_level_item_border_left = 0;
		if (($border_sides & 1) == 1)
			$top_level_item_border_right = 1;
		else
			$top_level_item_border_right = 0;
	}
	else
	{
		$top_level_item_border_top = 1;
		$top_level_item_border_bottom = 1;
		$top_level_item_border_left = 1;
		$top_level_item_border_right = 1;
	}
		
		
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if ($row["border"] > -1)
		$top_level_block_border_width = $row["border"];
	elseif($load_defaults == 1)
		$top_level_block_border_width = 1;
	else
		$top_level_block_border_width = -1;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_block_border_color = $row["border_color"];
	elseif($load_defaults == 1)
		$top_level_block_border_color = "#336699";
	else
		$top_level_block_border_color = "-not set-";
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$top_level_block_border_top = 1;
		else
			$top_level_block_border_top = 0;
		if (($border_sides & 4) == 4)
			$top_level_block_border_bottom = 1;
		else
			$top_level_block_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$top_level_block_border_left = 1;
		else
			$top_level_block_border_left = 0;
		if (($border_sides & 1) == 1)
			$top_level_block_border_right = 1;
		else
			$top_level_block_border_right = 0;
	}
	else
	{
		$top_level_block_border_top = 1;
		$top_level_block_border_bottom = 1;
		$top_level_block_border_left = 1;
		$top_level_block_border_right = 1;
	}
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li>ul'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if ($row["border"] > -1)
		$sub_level_block_border_width = $row["border"];
	elseif($load_defaults == 1)
		$sub_level_block_border_width = 1;
	else
		$sub_level_block_border_width = -1;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_block_border_color = $row["border_color"];
	elseif($load_defaults == 1)
		$sub_level_block_border_color = "#336699";
	else
		$sub_level_block_border_color = "-not set-";
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_block_border_top = 1;
		else
			$sub_level_block_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_block_border_bottom = 1;
		else
			$sub_level_block_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_block_border_left = 1;
		else
			$sub_level_block_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_block_border_right = 1;
		else
			$sub_level_block_border_right = 0;
	}
	else
	{
		$sub_level_block_border_top = 1;
		$sub_level_block_border_bottom = 1;
		$sub_level_block_border_left = 1;
		$sub_level_block_border_right = 1;
	}
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.nav" . $suffix . " ul li a'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if ($row["border"] > -1)
		$sub_level_item_border_width = $row["border"];
	else
		$sub_level_item_border_width = -1;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_item_border_color = $row["border_color"];
	else
		$sub_level_item_border_color = "-not set-";
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_item_border_top = 1;
		else
			$sub_level_item_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_item_border_bottom = 1;
		else
			$sub_level_item_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_item_border_left = 1;
		else
			$sub_level_item_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_item_border_right = 1;
		else
			$sub_level_item_border_right = 0;
	}
	else
	{
		$sub_level_item_border_top = 1;
		$sub_level_item_border_bottom = 1;
		$sub_level_item_border_left = 1;
		$sub_level_item_border_right = 1;
	}
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li:active, .nav" . $suffix . " ul li a:active'";
	$result = mysql_query($query, $bwb_link);
	$row = mysql_fetch_array($result);
	if (!is_null($row["text_color"])   && ($row["text_color"] != ""))
		$sub_level_1_text_color_active = $row["text_color"];
	else
		$sub_level_1_text_color_active = "-not set-";
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_active = $row["bkgd_color"];
	else
		$top_level_background_color_active = "-not set-";
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_active = $row["border_color"];
	else
		$top_level_item_border_color_active = "-not set-";
?>

<form name="frm_menu_styles" action="save_css_menu_styles.php" method="post">
<table width="90%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
      <table border="0" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold">Top Level Font</td>
          </tr>
        <tr>
          <td>
            <table width="100%" border="0">
              <tr>
                <td align="right">Font:</td>
                <td>
                  <select name="top_level_font" id="top_level_font">
                    <?php
						echo "<option value='-not selected-'";
						if ($font == "-not selected-")
							echo " selected='selected'";
						echo ">-not selected-</option>\n";
						  
					 	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = mysql_query($query, $bwb_link);
						while ($row = mysql_fetch_array($result))
						{
							$tmp_font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$tmp_font' style='font-family:$tmp_font;'";
							if ($tmp_font == $top_level_font)
								echo " selected='selected'";
							echo ">$tmp_font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                    <span class="small_message">&radic; = websafe</span>
                  </td>
                <td align="right">Size: </td>
                <td>
                  <input name="top_level_font_size" type="text" id="top_level_font_size" size="10" value="<?php echo $top_level_font_size; ?>">
                  px
                  </td>
                <td align="right">Weight: </td>
                <td>
                  <select name="top_level_weight" id="top_level_weight">
                    <option value="-not selected-" <?php if ($top_level_weight == "-not selected-") echo " selected='selected'"; ?>>-not selected-</option>
                    <option value="normal" <?php if ($top_level_weight == "normal") echo " selected='selected'"; ?>>Normal</option>
                    <option value="bold" <?php if ($top_level_weight == "bold") echo " selected='selected'"; ?>>Bold</option>
                    <option value="bolder" <?php if ($top_level_weight == "bolder") echo " selected='selected'"; ?>>Bolder</option>
                    <option value="lighter" <?php if ($top_level_weight == "lighter") echo " selected='selected'"; ?>>Lighter</option>
                    <option value="100" <?php if ($top_level_weight == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($top_level_weight == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($top_level_weight == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($top_level_weight == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($top_level_weight == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($top_level_weight == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($top_level_weight == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($top_level_weight == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($top_level_weight == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right">Font Stretch:</td>
                <td>
                  <select name="top_level_font_stretch" id="top_level_font_stretch">
                    <option value="-not selected-" <?php if ($top_level_font_stretch == "-not selected-") echo " selected='selected'"; ?>>-not selected-</option>
                    <option value="normal" <?php if ($top_level_font_stretch == "normal") echo " selected='selected'"; ?>>Normal</option>
                    <option value="wider" <?php if ($top_level_font_stretch == "wider") echo " selected='selected'"; ?>>Wider</option>
                    <option value="narrower" <?php if ($top_level_font_stretch == "narrower") echo " selected='selected'"; ?>>Narrower</option>
                    <option value="ultra-condensed" <?php if ($top_level_font_stretch == "ultra-condensed") echo " selected='selected'"; ?>>Ultra-Condensed</option>
                    <option value="extra-condensed" <?php if ($top_level_font_stretch == "extra-condensed") echo " selected='selected'"; ?>>Extra-Condensed</option>
                    <option value="condensed" <?php if ($top_level_font_stretch == "condensed") echo " selected='selected'"; ?>>Condensed</option>
                    <option value="semi-condensed" <?php if ($top_level_font_stretch == "semi-condensed") echo " selected='selected'"; ?>>Semi-Condensed</option>
                    <option value="semi-expanded" <?php if ($top_level_font_stretch == "semi-expanded") echo " selected='selected'"; ?>>Semi-Expanded</option>
                    <option value="expanded" <?php if ($top_level_font_stretch == "expanded") echo " selected='selected'"; ?>>Expanded</option>
                    <option value="extra-expanded" <?php if ($top_level_font_stretch == "extra-expanded") echo " selected='selected'"; ?>>Extra-Expanded</option>
                    <option value="ultra-expanded" <?php if ($top_level_font_stretch == "ultra-expanded") echo " selected='selected'"; ?>>Ultra-Expanded</option>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" border="0">
              <tr>
                <td align="right">Italic:</td>
                <td>
                  <input name="top_level_italic" type="checkbox" id="top_level_italic" value="1" <?php if ($top_level_italic == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right">Underline:</td>
                <td>
                  <input name="top_level_underline" type="checkbox" id="top_level_underline" value="1" <?php if ($top_level_underline == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right">Overline:</td>
                <td>
                  <input name="top_level_overline" type="checkbox" id="top_level_overline" value="1" <?php if ($top_level_overline == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right">Blink:</td>
                <td>
                  <input name="top_level_blink" type="checkbox" id="top_level_blink" value="1" <?php if ($top_level_blink == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right">Oblique:</td>
                <td>
                  <input name="top_level_oblique" type="checkbox" id="top_level_oblique" value="1" <?php if ($top_level_oblique == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right">Small Caps:</td>
                <td>
                  <input name="top_level_small_caps" type="checkbox" id="top_level_small_caps" value="1" <?php if ($top_level_small_caps == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><table border="0" width="100%">
            <tr>
              <td align="center"> Shadow:
                <input name="top_level_shadow" type="checkbox" id="top_level_shadow" value="1" <?php if ($top_level_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('<?php echo $tagid; ?>');"></td>
              <td align="center"> Color:
                <input name="top_level_shadow_color" type="text" id="top_level_shadow_color" value="<?php echo $top_level_shadow_color; ?>" size="10" onBlur="CheckColorString(this);">
                <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color');" class="small_message">#RRGGBB</a></td>
              <td align="center"> X-Offset:
                <input name="top_level_shadow_x_offset" type="text" id="top_level_shadow_x_offset" value="<?php echo $top_level_shadow_x_offset; ?>" size="10">
                px </td>
              <td align="center"> Y-Offset:
                <input name="top_level_shadow_y_offset" type="text" id="top_level_shadow_y_offset" value="<?php echo $top_level_shadow_y_offset; ?>" size="10">
                px </td>
              <td align="center"> Blur:
                <input name="top_level_shadow_blur" type="text" id="top_level_shadow_blur" value="<?php echo $top_level_shadow_blur; ?>" size="10">
                px </td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td align="right" class="small_message">Link-underline will be forced to off unless underline is checked.</td></tr>
        </table>
      </td>
  </tr>
  <tr>
    <td>
	   <table border="0" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td class="bold">Sub  Level 1 Font</td>
		  </tr>
		  <tr>
		    <td><table width="100%" border="0">
		      <tr>
		        <td align="right">Font:</td>
		        <td>
                <select name="sub_level_1_font" id="sub_level_1_font">
		          <?php
						echo "<option value='-not selected-'";
						if ($font == "-not selected-")
							echo " selected='selected'";
						echo ">-not selected-</option>\n";
							
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = mysql_query($query, $bwb_link);
						while ($row = mysql_fetch_array($result))
						{
							$tmp_font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$tmp_font' style='font-family:$tmp_font;'";
							if ($tmp_font == $sub_level_1_font)
								echo " selected='selected'";
							echo ">$tmp_font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
				?>
		          </select>
                  <span class="small_message">&radic; = websafe</span>  
                </td>
		        <td align="right">Size: </td>
		        <td><input name="sub_level_1_font_size" type="text" id="sub_level_1_font_size" size="10" value="<?php echo $sub_level_1_font_size; ?>" />
		          px</td>
		        <td align="right">Weight: </td>
		        <td><select name="sub_level_1_weight" id="sub_level_1_weight">
		          <option value="-not selected-" <?php if ($sub_level_1_weight == "-not selected-") echo " selected='selected'"; ?>>-not selected-</option>
		          <option value="normal" <?php if ($sub_level_1_weight == "normal") echo " selected='selected'"; ?>>Normal</option>
		          <option value="bold" <?php if ($sub_level_1_weight == "bold") echo " selected='selected'"; ?>>Bold</option>
		          <option value="bolder" <?php if ($sub_level_1_weight == "bolder") echo " selected='selected'"; ?>>Bolder</option>
		          <option value="lighter" <?php if ($sub_level_1_weight == "lighter") echo " selected='selected'"; ?>>Lighter</option>
		          <option value="100" <?php if ($sub_level_1_weight == "100") echo " selected='selected'"; ?>>100</option>
		          <option value="200" <?php if ($sub_level_1_weight == "200") echo " selected='selected'"; ?>>200</option>
		          <option value="300" <?php if ($sub_level_1_weight == "300") echo " selected='selected'"; ?>>300</option>
		          <option value="400" <?php if ($sub_level_1_weight == "400") echo " selected='selected'"; ?>>400</option>
		          <option value="500" <?php if ($sub_level_1_weight == "500") echo " selected='selected'"; ?>>500</option>
		          <option value="600" <?php if ($sub_level_1_weight == "600") echo " selected='selected'"; ?>>600</option>
		          <option value="700" <?php if ($sub_level_1_weight == "700") echo " selected='selected'"; ?>>700</option>
		          <option value="800" <?php if ($sub_level_1_weight == "800") echo " selected='selected'"; ?>>800</option>
		          <option value="900" <?php if ($sub_level_1_weight == "900") echo " selected='selected'"; ?>>900</option>
		          </select></td>
		        <td align="right">Font Stretch:</td>
		        <td><select name="sub_level_1_font_stretch" id="sub_level_1_font_stretch">
		          <option value="-not selected-" <?php if ($sub_level_1_font_stretch == "-not selected-") echo " selected='selected'"; ?>>-not selected-</option>
		          <option value="normal" <?php if ($sub_level_1_font_stretch == "normal") echo " selected='selected'"; ?>>Normal</option>
		          <option value="wider" <?php if ($sub_level_1_font_stretch == "wider") echo " selected='selected'"; ?>>Wider</option>
		          <option value="narrower" <?php if ($sub_level_1_font_stretch == "narrower") echo " selected='selected'"; ?>>Narrower</option>
		          <option value="ultra-condensed" <?php if ($sub_level_1_font_stretch == "ultra-condensed") echo " selected='selected'"; ?>>Ultra-Condensed</option>
		          <option value="extra-condensed" <?php if ($sub_level_1_font_stretch == "extra-condensed") echo " selected='selected'"; ?>>Extra-Condensed</option>
		          <option value="condensed" <?php if ($sub_level_1_font_stretch == "condensed") echo " selected='selected'"; ?>>Condensed</option>
		          <option value="semi-condensed" <?php if ($sub_level_1_font_stretch == "semi-condensed") echo " selected='selected'"; ?>>Semi-Condensed</option>
		          <option value="semi-expanded" <?php if ($sub_level_1_font_stretch == "semi-expanded") echo " selected='selected'"; ?>>Semi-Expanded</option>
		          <option value="expanded" <?php if ($sub_level_1_font_stretch == "expanded") echo " selected='selected'"; ?>>Expanded</option>
		          <option value="extra-expanded" <?php if ($sub_level_1_font_stretch == "extra-expanded") echo " selected='selected'"; ?>>Extra-Expanded</option>
		          <option value="ultra-expanded" <?php if ($sub_level_1_font_stretch == "ultra-expanded") echo " selected='selected'"; ?>>Ultra-Expanded</option>
		          </select></td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td><table width="100%" border="0">
		      <tr>
		        <td align="right">Italic:</td>
		        <td><input name="sub_level_1_italic" type="checkbox" id="sub_level_1_italic" value="1" <?php if ($sub_level_1_italic == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Underline:</td>
		        <td><input name="sub_level_1_underline" type="checkbox" id="sub_level_1_underline" value="1" <?php if ($sub_level_1_underline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Overline:</td>
		        <td><input name="sub_level_1_overline" type="checkbox" id="sub_level_1_overline" value="1" <?php if ($sub_level_1_overline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Blink:</td>
		        <td><input name="sub_level_1_blink" type="checkbox" id="sub_level_1_blink" value="1" <?php if ($sub_level_1_blink == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Oblique:</td>
		        <td><input name="sub_level_1_oblique" type="checkbox" id="sub_level_1_oblique" value="1" <?php if ($sub_level_1_oblique == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Small Caps:</td>
		        <td><input name="sub_level_1_small_caps" type="checkbox" id="sub_level_1_small_caps" value="1" <?php if ($sub_level_1_small_caps == 1) echo "checked='checked'"; ?>></td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message"><table border="0" width="100%">
		      <tr>
		        <td align="center"> Shadow:
		          <input name="sub_level_1_shadow" type="checkbox" id="sub_level_1_shadow" value="1" <?php if ($sub_level_1_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('<?php echo $tagid; ?>');"></td>
		        <td align="center"> Color:
		          <input name="sub_level_1_shadow_color" type="text" id="sub_level_1_shadow_color" value="<?php echo $sub_level_1_shadow_color; ?>" size="10" onBlur="CheckColorString(this);">
<a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color');" class="small_message">#RRGGBB</a></td>
		        <td align="center"> X-Offset:
		          <input name="sub_level_1_shadow_x_offset" type="text" id="sub_level_1_shadow_x_offset" value="<?php echo $sub_level_1_shadow_x_offset; ?>" size="10">
		          px </td>
		        <td align="center"> Y-Offset:
		          <input name="sub_level_1_shadow_y_offset" type="text" id="sub_level_1_shadow_y_offset" value="<?php echo $sub_level_1_shadow_y_offset; ?>" size="10">
		          px </td>
		        <td align="center"> Blur:
		          <input name="sub_level_1_shadow_blur" type="text" id="sub_level_1_shadow_blur" value="<?php echo $sub_level_1_shadow_blur; ?>" size="10">
		          px </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message">Link-underline will be forced to off unless underline is checked.</td></tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table border="0" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td class="bold">Sub  Level 2 Font</td>
		  </tr>
		  <tr>
		    <td><table width="100%" border="0">
		      <tr>
		        <td align="right">Font:</td>
		        <td>
                  <select name="sub_level_2_font" id="sub_level_2_font">
		          <?php
						echo "<option value='-not selected-'";
						if ($font == "-not selected-")
							echo " selected='selected'";
						echo ">-not selected-</option>\n";
						  
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = mysql_query($query, $bwb_link);
						while ($row = mysql_fetch_array($result))
						{
							$tmp_font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$tmp_font' style='font-family:$tmp_font;'";
							if ($tmp_font == $sub_level_2_font)
								echo " selected='selected'";
							echo ">$tmp_font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
				?>
		          </select>
                  <span class="small_message">&radic; = websafe</span>
                </td>
		        <td align="right">Size: </td>
		        <td><input name="sub_level_2_font_size" type="text" id="sub_level_2_font_size" size="10" value="<?php echo $sub_level_2_font_size; ?>" />
		          px</td>
		        <td align="right">Weight: </td>
		        <td><select name="sub_level_2_weight" id="sub_level_2_weight">
		          <option value="-not selected-" <?php if ($sub_level_2_weight == "-not selected-") echo " selected='selected'"; ?>>-not selected-</option>
		          <option value="normal" <?php if ($sub_level_2_weight == "normal") echo " selected='selected'"; ?>>Normal</option>
		          <option value="bold" <?php if ($sub_level_2_weight == "bold") echo " selected='selected'"; ?>>Bold</option>
		          <option value="bolder" <?php if ($sub_level_2_weight == "bolder") echo " selected='selected'"; ?>>Bolder</option>
		          <option value="lighter" <?php if ($sub_level_2_weight == "lighter") echo " selected='selected'"; ?>>Lighter</option>
		          <option value="100" <?php if ($sub_level_2_weight == "100") echo " selected='selected'"; ?>>100</option>
		          <option value="200" <?php if ($sub_level_2_weight == "200") echo " selected='selected'"; ?>>200</option>
		          <option value="300" <?php if ($sub_level_2_weight == "300") echo " selected='selected'"; ?>>300</option>
		          <option value="400" <?php if ($sub_level_2_weight == "400") echo " selected='selected'"; ?>>400</option>
		          <option value="500" <?php if ($sub_level_2_weight == "500") echo " selected='selected'"; ?>>500</option>
		          <option value="600" <?php if ($sub_level_2_weight == "600") echo " selected='selected'"; ?>>600</option>
		          <option value="700" <?php if ($sub_level_2_weight == "700") echo " selected='selected'"; ?>>700</option>
		          <option value="800" <?php if ($sub_level_2_weight == "800") echo " selected='selected'"; ?>>800</option>
		          <option value="900" <?php if ($sub_level_2_weight == "900") echo " selected='selected'"; ?>>900</option>
		          </select></td>
		        <td align="right">Font Stretch:</td>
		        <td>
                <select name="sub_level_2_font_stretch" id="sub_level_2_font_stretch">
		          <option value="-not selected-" <?php if ($sub_level_2_font_stretch == "-not selected-") echo " selected='selected'"; ?>>-not selected-</option>
		          <option value="normal" <?php if ($sub_level_2_font_stretch == "normal") echo " selected='selected'"; ?>>Normal</option>
		          <option value="wider" <?php if ($sub_level_2_font_stretch == "wider") echo " selected='selected'"; ?>>Wider</option>
		          <option value="narrower" <?php if ($sub_level_2_font_stretch == "narrower") echo " selected='selected'"; ?>>Narrower</option>
		          <option value="ultra-condensed" <?php if ($sub_level_2_font_stretch == "ultra-condensed") echo " selected='selected'"; ?>>Ultra-Condensed</option>
		          <option value="extra-condensed" <?php if ($sub_level_2_font_stretch == "extra-condensed") echo " selected='selected'"; ?>>Extra-Condensed</option>
		          <option value="condensed" <?php if ($sub_level_2_font_stretch == "condensed") echo " selected='selected'"; ?>>Condensed</option>
		          <option value="semi-condensed" <?php if ($sub_level_2_font_stretch == "semi-condensed") echo " selected='selected'"; ?>>Semi-Condensed</option>
		          <option value="semi-expanded" <?php if ($sub_level_2_font_stretch == "semi-expanded") echo " selected='selected'"; ?>>Semi-Expanded</option>
		          <option value="expanded" <?php if ($sub_level_2_font_stretch == "expanded") echo " selected='selected'"; ?>>Expanded</option>
		          <option value="extra-expanded" <?php if ($sub_level_2_font_stretch == "extra-expanded") echo " selected='selected'"; ?>>Extra-Expanded</option>
		          <option value="ultra-expanded" <?php if ($sub_level_2_font_stretch == "ultra-expanded") echo " selected='selected'"; ?>>Ultra-Expanded</option>
		          </select>
		          </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td><table width="100%" border="0">
		      <tr>
		        <td align="right">Italic:</td>
		        <td><input name="sub_level_2_italic" type="checkbox" id="sub_level_2_italic" value="1" <?php if ($sub_level_2_italic == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Underline:</td>
		        <td><input name="sub_level_2_underline" type="checkbox" id="sub_level_2_underline" value="1" <?php if ($sub_level_2_underline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Overline:</td>
		        <td><input name="sub_level_2_overline" type="checkbox" id="sub_level_2_overline" value="1" <?php if ($sub_level_2_overline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Blink:</td>
		        <td><input name="sub_level_2_blink" type="checkbox" id="sub_level_2_blink" value="1" <?php if ($sub_level_2_blink == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Oblique:</td>
		        <td><input name="sub_level_2_oblique" type="checkbox" id="sub_level_2_oblique" value="1" <?php if ($sub_level_2_oblique == 1) echo "checked='checked'"; ?>></td>
		        <td align="right">Small Caps:</td>
		        <td><input name="sub_level_2_small_caps" type="checkbox" id="sub_level_2_small_caps" value="1" <?php if ($sub_level_2_small_caps == 1) echo "checked='checked'"; ?>></td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message"><table border="0" width="100%">
		      <tr>
		        <td align="center"> Shadow:		          
		          <input name="sub_level_2_shadow" type="checkbox" id="sub_level_2_shadow" value="1" <?php if ($sub_level_2_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('<?php echo $tagid; ?>');"></td>
		        <td align="center"> Color:
		          <input name="sub_level_2_shadow_color" type="text" id="sub_level_2_shadow_color" value="<?php echo $sub_level_2_shadow_color; ?>" size="10" onBlur="CheckColorString(this);">
		          <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color');" class="small_message">#RRGGBB</a></td>
		        <td align="center"> X-Offset:
		          <input name="sub_level_2_shadow_x_offset" type="text" id="sub_level_2_shadow_x_offset" value="<?php echo $sub_level_2_shadow_x_offset; ?>" size="10">
		          px </td>
		        <td align="center"> Y-Offset:
		          <input name="sub_level_2_shadow_y_offset" type="text" id="sub_level_2_shadow_y_offset" value="<?php echo $sub_level_2_shadow_y_offset; ?>" size="10">
		          px </td>
		        <td align="center"> Blur:
		          <input name="sub_level_2_shadow_blur" type="text" id="sub_level_2_shadow_blur" value="<?php echo $sub_level_2_shadow_blur; ?>" size="10">
		          px </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message">Link-underline will be forced to off unless underline is checked.</td></tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table border="0" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td colspan="9" class="bold">Colors and Background</td>
		  </tr>
		  <tr>
          	<td>&nbsp;</td>
			<td class="bold">Normal (mouse out)</td>
			<td class="bold">Hover (mouse over)</td>
			<td class="bold">Active (mouse click)</td>
			<td class="bold">&nbsp;</td>
            <td align="center" rowspan="6" valign="bottom" class="bold">T<br>o<br>p</td>
            <td  align="center" rowspan="6" valign="bottom" class="bold">B<br>o<br>t<br>t<br>o<br>m</td>
            <td align="center" rowspan="6" valign="bottom" class="bold">L<br>e<br>f<br>t</td>
            <td  align="center" rowspan="6" valign="bottom" class="bold">R<br>i<br>g<br>h<br>t</td>
		  </tr>
		  <tr>
			<td align="right">Top Level Text Color: </td>
            <td align="left"><input name="top_level_text_color" type="text" id="top_level_text_color" value="<?php echo $top_level_text_color; ?>" size="10" onBlur="CheckColorString(this);">              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color');">#RRGGBB
              
              </a></span></td>
			<td><input name="top_level_text_color_hover" type="text" id="top_level_text_color_hover" value="<?php echo $top_level_text_color_hover; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_hover');">#RRGGBB</a></span></td>
			<td class="small_message">na</td>
			<td>&nbsp;</td>
		  </tr>
		  <tr>
		    <td align="right">Sub Level 1 Text Color: </td>
		    <td align="left"><input name="sub_level_1_text_color" type="text" id="sub_level_1_text_color" value="<?php echo $sub_level_1_text_color; ?>" size="10" onBlur="CheckColorString(this);">
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color');">#RRGGBB
		        
		        
		        </a></span></td>
		    <td><input name="sub_level_1_text_color_hover" type="text" id="sub_level_1_text_color_hover" value="<?php echo $sub_level_1_text_color_hover; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_hover');">#RRGGBB</a></span></td>
		    <td><input name="sub_level_1_text_color_active" type="text" id="sub_level_1_text_color_active" value="<?php echo $sub_level_1_text_color_active; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_active');">#RRGGBB</a></span></td>
		    <td>&nbsp;</td>
            
		    </tr>
		  <tr>
		    <td align="right">		      Sub Level 2 Text Color: </td>
		    <td align="left"><input name="sub_level_2_text_color" type="text" id="sub_level_2_text_color" value="<?php echo $sub_level_2_text_color; ?>" size="10" onBlur="CheckColorString(this);">
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color');">#RRGGBB
		        
		        </a></span></td>
		    <td><input name="sub_level_2_text_color_hover" type="text" id="sub_level_2_text_color_hover" value="<?php echo $sub_level_2_text_color_hover; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_hover');">#RRGGBB</a></span></td>
		    <td><span class="small_message">(same as top level)</span></td>
		    <td>&nbsp;</td>
            
		    </tr>
		  <tr>
		    <td align="right">Top Level Background Color:</td>
		    <td><input name="top_level_background_color" type="text" id="top_level_background_color" value="<?php echo $top_level_background_color; ?>" size="10" onBlur="CheckColorString(this);">
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color');">#RRGGBB</a></span></td>
		    <td><input name="top_level_background_color_hover" type="text" id="top_level_background_color_hover" value="<?php echo $top_level_background_color_hover; ?>" size="10" onBlur="CheckColorString(this);">
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color_hover');">#RRGGBB</a></span></td>
		    <td><input name="top_level_background_color_active" type="text" id="top_level_background_color_active" value="<?php echo $top_level_background_color_active; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color_active');">#RRGGBB</a></span></td>
		    <td>&nbsp;</td>
            
		    </tr>
		  <tr>
		    <td align="right">Sub Level Background Color: </td>
		    <td><input name="sub_level_background_color" type="text" id="sub_level_background_color" value="<?php echo $sub_level_background_color; ?>" size="10" onBlur="CheckColorString(this);">
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_background_color');">#RRGGBB</a></span></td>
		    <td class="small_message">(same as top level)</td>
		    <td><span class="small_message">(same as top level)</span></td>
		    <td><span class="bold">Width</span></td>
           
		    </tr>
          <tr>
            <td align="right">Top Level Block Border Color:</td>
            <td><input name="top_level_block_border_color" type="text" id="top_level_block_border_color" value="<?php echo $top_level_block_border_color; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_block_border_color');">#RRGGBB</a></span></td>
            <td><span class="small_message">(same as normal)</span></td>
            <td><span class="small_message">na</span></td>
            <td><input name="top_level_block_border_width" type="text" id="top_level_block_border_width" value="<?php echo $top_level_block_border_width; ?>" size="10" /> 
              px</td>
              <td>
              	<input name="top_level_block_border_top" type="checkbox" id="top_level_block_border_top" value="1" <?php if ($top_level_block_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_bottom" type="checkbox" id="top_level_block_border_bottom" value="1" <?php if ($top_level_block_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_left" type="checkbox" id="top_level_block_border_left" value="1" <?php if ($top_level_block_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_right" type="checkbox" id="top_level_block_border_right" value="1" <?php if ($top_level_block_border_right == 1) echo "checked='checked'"; ?>>
              </td>
          </tr>
           <tr>
          	<td align="right">Sub Level Block Border Color:</td>
            <td><input name="sub_level_block_border_color" type="text" id="sub_level_block_border_color" value="<?php echo $sub_level_block_border_color; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_block_border_color');">#RRGGBB</a></span></td>
            <td><span class="small_message">(same as normal)</span></td>
            <td><span class="small_message">na</span></td>
            <td><input name="sub_level_block_border_width" type="text" id="sub_level_block_border_width" value="<?php echo $sub_level_block_border_width; ?>" size="10" />
              px</td>
              <td>
              	<input name="sub_level_block_border_top" type="checkbox" id="sub_level_block_border_top" value="1" <?php if ($sub_level_block_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_block_border_bottom" type="checkbox" id="sub_level_block_border_bottom" value="1" <?php if ($sub_level_block_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_block_border_left" type="checkbox" id="sub_level_block_border_left" value="1" <?php if ($sub_level_block_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_block_border_right" type="checkbox" id="sub_level_block_border_right" value="1" <?php if ($sub_level_block_border_right == 1) echo "checked='checked'"; ?>>
              </td>
       	  </tr>
            <tr>
            <td align="right">Top Level Item Border Color:</td>
            <td><input name="top_level_item_border_color" type="text" id="top_level_item_border_color" value="<?php echo $top_level_item_border_color; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color');">#RRGGBB</a></span></td>
            <td><input name="top_level_item_border_color_hover" type="text" id="top_level_item_border_color_hover" value="<?php echo $top_level_item_border_color_hover; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color_hover');">#RRGGBB</a></span></td>
            <td><input name="top_level_item_border_color_active" type="text" id="top_level_item_border_color_active" value="<?php echo $top_level_item_border_color_active; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color_active');">#RRGGBB</a></span></td>
            <td><input name="top_level_item_border_width" type="text" id="top_level_item_border_width" value="<?php echo $top_level_item_border_width; ?>" size="10" />
              px</td>
              <td>
              	<input name="top_level_item_border_top" type="checkbox" id="top_level_item_border_top" value="1" <?php if ($top_level_item_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_item_border_bottom" type="checkbox" id="top_level_item_border_bottom" value="1" <?php if ($top_level_item_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_item_border_left" type="checkbox" id="top_level_item_border_left" value="1" <?php if ($top_level_item_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_item_border_right" type="checkbox" id="top_level_item_border_right" value="1" <?php if ($top_level_item_border_right == 1) echo "checked='checked'"; ?>>
              </td>
          </tr>
           <tr>
          	<td align="right">Sub Level Item Border Color:</td>
            <td><input name="sub_level_item_border_color" type="text" id="sub_level_item_border_color" value="<?php echo $sub_level_item_border_color; ?>" size="10" onBlur="CheckColorString(this);">
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_item_border_color');">#RRGGBB</a></span></td>
            <td><span class="small_message">(same as top level)</span></td>
            <td><span class="small_message">(same as top level)</span></td>
            <td><input name="sub_level_item_border_width" type="text" id="sub_level_item_border_width" value="<?php echo $sub_level_item_border_width; ?>" size="10" />
              px</td>
              <td>
              	<input name="sub_level_item_border_top" type="checkbox" id="sub_level_item_border_top" value="1" <?php if ($sub_level_item_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td><input name="sub_level_item_border_bottom" type="checkbox" id="sub_level_item_border_bottom" value="1" <?php if ($sub_level_item_border_bottom == 1) echo "checked='checked'"; ?>></td>
              <td>
              	<input name="sub_level_item_border_left" type="checkbox" id="sub_level_item_border_left" value="1" <?php if ($sub_level_item_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_item_border_right" type="checkbox" id="sub_level_item_border_right" value="1" <?php if ($sub_level_item_border_right == 1) echo "checked='checked'"; ?>>
              </td>
       	  </tr>
	   </table>
	</td>
  </tr>
</table>
<table width="90%" border="0" cellspacing="0" cellpadding="0">
  <tr><td colspan="3">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <input type="submit" value="Update" name="submit" />
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
		</td>
        <td align="center">
          <input type="submit" value="Preview" name="submit" />
		</td>
		<td align="center">
          <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=menu';" />
		</td>
	  </tr>
</table>
</form>
</div>

</body>
</html>