<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Completely re-engineered: 12/17/2010	ELL
// Revised: 2/19/2011	ELL
// Fixed bugs with moving items and inserting items when using Internet Explore.  It was working fine in
// Firefox, Opera, Safari and Chrome, but IE processes .innerHTML in a very weird way.  Note that UpdateAll() 
// function is run after moving items for IE only to correct some of the problems with working with id
// attributes to tags once IE processes the .innerHTML.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 3/1/2012	ELL
// Fixed bugs with indents not working properly upon inserting new items.
// 
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
	
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{
	top:30px;
	right:20px;
}

.header_row	{
	padding-left:5px;
	padding-right:5px;
}
</style>

<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/ajax.js"></script>
<script type="text/javascript" src="js/trim.js"></script>
<script type="text/javascript" src="js/escape_url.js"></script>
<script type="text/javascript" src="js/mouse_position.js"></script>

<script language="javascript" type="text/javascript" >

var update_all = false;
var pages = new Array();
var pages_full = new Array();
var bgclr = "#eeeeee";
var saved = true;

<?php
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = mysql_query($query, $bwb_link);
	$num_results = mysql_num_rows($result);
	$page_name_tmp = "";
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = mysql_fetch_array($result);
		$page_name = $row["page_name"];
		$page_name_full = $page_name . ".php";
		echo "pages[$j] = '$page_name';\n";
		echo "pages_full[$j] = '$page_name_full';\n";
	}
	echo "var page_cnt = $j;\n";
?>

///////////////////////////////////////////////////////////////////////////////////////////
function Indent(level)
{
	var indent = "";
	for (var i = 0; i < level; i++)
	{
		indent = indent + "   ";
	}
	return indent;
}

////////////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_menu_items", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(item_text, ID, i)
{
	var ntop;
	ntop = tempY;
	if (ntop < 500)
		ntop = ntop + 20;
	else
		ntop = ntop - 20;
	var strtop = ntop + "px";
	
	document.getElementById("delete_confirm").style.display = "block";
	document.getElementById("delete_confirm").style.position = "absolute";
	document.getElementById("delete_confirm").style.top = strtop;
	document.getElementById("delete_confirm").style.left = "200px";
	document.getElementById("delete_confirm").style.width = "450px";
	document.getElementById("delete_confirm").style.backgroundColor = "#FFF";
	document.getElementById("delete_confirm").style.borderStyle = "solid";
	document.getElementById("delete_confirm").style.borderWidth = "2px";
	document.getElementById("delete_confirm").style.borderColor = "#000";
	document.getElementById("delete_text").innerHTML = item_text;
	document.getElementById("menu_item_to_delete").value = ID;
}

function DeleteMenuItem()
{
	var params = "";
	var IDRemove = document.getElementById("menu_item_to_delete").value;

	document.getElementById("delete_confirm").style.display = "none";
	menu = document.getElementById("selectMenu").value;
	
	if (document.getElementById("StatusMsg").innerHTML == " ")
	{
		document.getElementById("StatusMsg").innerHTML = "Starting delete...";
		document.getElementById("StatusMsg2").innerHTML = "Starting delete...";
	}
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","delete_menu_item.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg", "Delete");
		
		params = "menu=" + document.getElementById("selectMenu").value;
		params = params + "&IDRemove=" + IDRemove;
//		alert(params);
		xmlhttp.send(params);
	}
}

function HideDelete()
{
	document.getElementById("delete_confirm").style.display = "none";
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMenuItem(ID, i)
{
	if (update_all)
	{
		UpdateAll();
		return;
	}
		
	var params = "";
	var ID_ctl = "ID" + i;
	var item_text_ctl = "item_text" + i;
	var level_ctl = "level" + i;
	var URL_ctl = "URL" + i;
	var target_ctl = "target" + i;
	var sort_order_ctl = "sort_order" + i;
	var item_text = "";

	if (document.getElementById("StatusMsg").innerHTML == " ")
	{
		document.getElementById("StatusMsg").innerHTML = "Starting update...";
		document.getElementById("StatusMsg2").innerHTML = "Starting update...";
	}
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_menu_item.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg", "Update");
		
		// Escape URL string
		item_text = document.getElementById(item_text_ctl).value;
		item_text = EscapeURL(item_text);
		
		params = "menu=" + document.getElementById("selectMenu").value;
		params = params + "&ID=" + ID;
		params = params + "&item_text=" + item_text;
		params = params + "&level=" + document.getElementById(level_ctl).value;
		params = params + "&URL=" + document.getElementById(URL_ctl).value;
		params = params + "&target=" + document.getElementById(target_ctl).value;
		params = params + "&sort_order=" + document.getElementById(sort_order_ctl).value;
		//alert(params);
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateAll()
{
	var params = "";
	var ID_ctl;
	var item_text_ctl;
	var level_ctl;
	var URL_ctl;
	var target_ctl;
	var sort_order_ctl;
	var item_text;

	if (document.getElementById("StatusMsg").innerHTML == " ")
	{
		document.getElementById("StatusMsg").innerHTML = "Starting update...";
		document.getElementById("StatusMsg2").innerHTML = "Starting update...";
	}
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_menu_items.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg", "UpdateAll");
		
		params = "menu=" + document.getElementById("selectMenu").value;
		var cnt = document.getElementById("nCount").value;
		params = params + "&cnt=" + cnt;
		for (i = 0; i < cnt; i++)
		{
			ID_ctl = "ID" + i;
			item_text_ctl = "item_text" + i;
			level_ctl = "level" + i;
			URL_ctl = "URL" + i;
			target_ctl = "target" + i;
			sort_order_ctl = "sort_order" + i;
			
			params = params + "&ID" + i + "=" + document.getElementById(ID_ctl).value;
			// Escape URL string
			item_text = document.getElementById(item_text_ctl).value;
			item_text = EscapeURL(item_text);
			params = params + "&item_text" + i + "=" + item_text;
			params = params + "&level" + i + "=" + document.getElementById(level_ctl).value;
			params = params + "&URL" + i + "=" + document.getElementById(URL_ctl).value;
			params = params + "&target" + i + "=" + document.getElementById(target_ctl).value;
			params = params + "&sort_order" + i + "=" + document.getElementById(sort_order_ctl).value;
		}
//		alert(params);
		xmlhttp.send(params);
	}
	saved = true;
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, StatusMsg_control_name, Source)
{
	var StatusMsg_control_name2 = StatusMsg_control_name + "2";
	var query_complete_no_record = "Query complete.  No records found.";
	var query_complete = "<b>Query complete<\/b><br/>\n";
	var query_read_to_send = "Query ready to send...";
	var query_sent = "Query sent";
	var query_starting = "Locating menu items...";
	if (Source == "Delete")
	{
		query_complete_no_record = "No records found. Could not delete menu item.";
		query_complete = "<b>Menu item deleted<\/b><br/>\n";
		query_starting = "Deleting menu item...";
	}
	else if (Source == "Update")
	{
		query_complete_no_record = "No record found. Could not update menu item.";
		query_complete = "<b>Menu item updated<\/b><br/>\n";
		query_starting = "Updating menu item...";
	}
	else if (Source == "UpdateAll")
	{
		query_complete_no_record = "No records found. Could not update menu items.";
		query_complete = "<b>Menu items updated<\/b><br/>\n";
		query_starting = "Updating menu items...";
	}
	
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				var rows_str = xmlhttp.responseText;
//				alert(rows_str);
				if (rows_str == "-no data-")
				{
					document.getElementById(StatusMsg_control_name).innerHTML = query_complete_no_record;
					document.getElementById(StatusMsg_control_name2).innerHTML = query_complete_no_record;
				}
				else
				{
					document.getElementById(StatusMsg_control_name).innerHTML = query_complete;
					document.getElementById(StatusMsg_control_name2).innerHTML = query_complete;
				}
				if ((Source == "Populate") || (Source == "Delete") || (Source == "UpdateAll"))
					PopulateTable(rows_str);
			}
			else
			{
				document.getElementById(StatusMsg_control_name).innerHTML = query_complete_no_record;
				document.getElementById(StatusMsg_control_name2).innerHTML = query_complete_no_record;
			}

			var ClearMessageString = "ClearMessage('" + StatusMsg_control_name + "');";
			mTimer = setTimeout(ClearMessageString, 2000);
		}
		else if (xmlhttp.readyState==1)
		{
			document.getElementById(StatusMsg_control_name).innerHTML = query_read_to_send;
			document.getElementById(StatusMsg_control_name2).innerHTML = query_read_to_send;
		}
		else if (xmlhttp.readyState==2)
		{
			document.getElementById(StatusMsg_control_name).innerHTML = query_sent;
			document.getElementById(StatusMsg_control_name2).innerHTML = query_sent;
		}
		else if (xmlhttp.readyState==3)
		{
			document.getElementById(StatusMsg_control_name).innerHTML = query_starting;
			document.getElementById(StatusMsg_control_name2).innerHTML = query_starting;
		}
	}
	return (xmlhttp);
}

//////////////////////////////////////////////////////////////////////////////////////
function ClearMessage(StatusMsg_control_name)
{
	var StatusMsg_control_name2 = StatusMsg_control_name + "2";
	document.getElementById(StatusMsg_control_name).innerHTML = "&nbsp;";
	document.getElementById(StatusMsg_control_name2).innerHTML = "&nbsp;";
	clearInterval(mTimer);
}

////////////////////////////////////////////////////////////////////////////////////
function AddMenuItem(i)
{
	update_all = true;
	saved = false;
	
	var html = document.getElementById("MenuItemsTable").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var d = 0;
	var srch_str;
	
	if (navigator.appName == "Microsoft Internet Explorer")
		srch_str = "<TR id=row" + i;
	else
		srch_str = "<tr id=\"row" + i + "\"";
		
	var html_arr = new Array();
	html_arr = html.split(srch_str);
	var html_top = html_arr[0];
	var html_bottom = html.substring(html_top.length);

	var bgclr = "#FFFF99";
	var new_row = "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='images/indent_remove.png' border=0 alt='Indent Remove' name='IndentRemove' id='IndentRemove" + i + "' onClick=\"IndentItemRemove(" + i + ");\" />\n<\/td>\n";
	new_row = new_row + "<td valign='top'>\n<img src='images/indent.png' border=0 alt='Indent' name='Indent' id='Indent" + i + "' onClick=\"IndentItem(" + i + ");\" />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'><input type='hidden' name='ID" + i + "' id='ID" + i + "' value='-1'>\n";
	new_row = new_row + "<input type='text' name='item_text" + i + "' id='item_text" + i + "' value=''><\/td>\n";
		
	new_row = new_row + "<td>\n";
	new_row = new_row + "<input type='hidden' id='level" + i + "' value='' />\n";
	new_row = new_row + "<span id='level_text" + i + "'>Top Level<\/span>\n";
	new_row = new_row + "<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='selectPage" + i + "' id='selectPage" + i + "' onChange='PopulatePage(" + i + ");'>\n";
	new_row = new_row + "<option value=''>-not selected-<\/option>\n";
	
	for (var k = 0; k < page_cnt; k++)
	{
		new_row = new_row + "<option value='" + pages[k] + "'>" + pages[k] + "<\/option>\n";
	}
	new_row = new_row + "<\/select>\n";
	
	new_row = new_row + "<input type='text' name='URL" + i + "' id='URL" + i + "' value=''><\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='target_select" + i + "' id='target_select" + i + "' onChange='PopulateTarget(" + i + ");'>\n";
	new_row = new_row + "<option value='_self'>Self (normal)<\/option>\n";
	new_row = new_row + "<option value='_blank'>New Window<\/option>\n";
	new_row = new_row + "<option value='enter frame frame'>Named Frame<\/option>\n";
	new_row = new_row + "<\/select>\n";
	new_row = new_row + "<input type='hidden' name='target" + i + "' id='target" + i + "' value=''><\/td>\n";
	new_row = new_row + "<td valign='top'>\n<input type='hidden' id='sort_order" + i + "' name='sort_order" + i + "' value='' />\n";
	
	new_row = new_row + "<img src='images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateMenuItem(-1, " + i + ");\" />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddMenuItem(" + i + ");\" />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='images/arrow-up.png' border=0 alt='Move Up' name='MoveUp' id='MoveUp" + i + "' onClick=\"MoveItem(" + i + ");\" />\n<\/td>\n";
	d = parseInt(i) + 1;
	new_row = new_row + "<td valign='top'>\n<img src='images/arrow-down.png' border=0 alt='Move Down' name='MoveDown' id='MoveDown" + i + "' onClick=\"MoveItemDown(" + d + ");\" />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm('', -1, " + i + ");\" />\n<\/td>\n";
	
	new_row = new_row + "<\/tr>\n";
	var n = i - 1;
	var rplc_str;
	for (var j = cnt; j >= i; j--)
	{
		k = j + 1;
		srch_str = "row" + j;
		rplc_str = "row" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "ID" + j;
		rplc_str = "ID" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "item_text" + j;
		rplc_str = "item_text" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "level" + j;
		rplc_str = "level" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "level_text" + j;
		rplc_str = "level_text" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "selectPage" + j;
		rplc_str = "selectPage" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "PopulatePage(" + j;
		rplc_str = "PopulatePage(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "URL" + j;
		rplc_str = "URL" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "target_select" + j;
		rplc_str = "target_select" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "PopulateTarget(" + j;
		rplc_str = "PopulateTarget(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "target" + j;
		rplc_str = "target" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "sort_order" + j;
		rplc_str = "sort_order" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "UpdateMenuItem(-1, " + j;
		rplc_str = "UpdateMenuItem(-1, " + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "AddMenuItem(" + j;
		rplc_str = "AddMenuItem(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "DeleteConfirm('', -1, " + j;
		rplc_str = "DeleteConfirm('', -1, " + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveUp" + j;
		rplc_str = "MoveUp" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveDown" + j;
		rplc_str = "MoveDown" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveItem(" + j;
		rplc_str = "MoveItem(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveItemDown(" + j;
		rplc_str = "MoveItemDown(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "Indent" + j;
		rplc_str = "Indent" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "IndentRemove" + j;
		rplc_str = "IndentRemove" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "IndentItem(" + j;
		rplc_str = "IndentItem(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "IndentItemRemove(" + j;
		rplc_str = "IndentItemRemove(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
	}
	html = html_top + new_row + html_bottom;
	document.getElementById("MenuItemsTable").innerHTML = html;
	cnt++;
	document.getElementById("nCount").value = cnt;
	
	if (n > 0)
	{
		var m = n + 1
		var nesting_level_ctl = "level" + m;
		var parent_nesting_level_ctl = "level" + n;
		var nesting_level_text_ctl = "level_text" + m;
		var parent_nesting_text_level_ctl = "level_text" + n;
		document.getElementById(nesting_level_ctl).value = document.getElementById(parent_nesting_level_ctl).value;
		document.getElementById(nesting_level_text_ctl).innerHTML = document.getElementById(parent_nesting_text_level_ctl).innerHTML;
	}
	else
	{
		document.getElementById("level0").value = 0;
		document.getElementById("level_text0").innerHTML = "Top Level";
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById("MoveUp1").style.display = "table-row";
		document.getElementById("Indent0").style.display = "none";
		document.getElementById("Indent1").style.display = "table-row";
		document.getElementById("IndentRemove0").style.display = "none";
		document.getElementById("IndentRemove1").style.display = "table-row";
	}
}

////////////////////////////////////////////////////////////////////////////////////
function RetrieveMenuItems()
{
	if ((document.getElementById("selectMenu").value) == "-not selected-")
	{
		document.getElementById("MenuItemsTable").innerHTML ="&nbsp;\n";
		return;
	}
		
	if (document.getElementById("StatusMsg").innerHTML == " ")
	{
		document.getElementById("StatusMsg").innerHTML = "Retrieving menu items...";
		document.getElementById("StatusMsg2").innerHTML = "Retrieving menu items...";
	}
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_menu_items.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg", "Populate");
		params = "menu=" + document.getElementById("selectMenu").value;
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateTable(rows_str)
{
	var rows = new Array();
	var fields = new Array();
	var d = 0;
	var tmp;
	
	var output_str = "<table>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td colspan='2'>&nbsp;<\/td>\n";
	output_str = output_str + "<td class='header_row'><b>Item Text<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>Nesting Level<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>URL<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>Target Window<\/b><\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<td colspan='2'>&nbsp;<\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	
	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no menu items yet (first time).
		var i = 0;
	else	// Create rows for menu items.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			if (bgclr == "#dddddd")
				bgclr = "#eeeeee";
			else
				bgclr = "#dddddd";
				
			output_str = output_str + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
				
			output_str = output_str + "<td valign='top'>\n<img src='images/indent_remove.png' border=0 alt='Indent Remove' name='IndentRemove' id='IndentRemove" + i + "' onClick=\"IndentItemRemove(" + i + ");\" />\n<\/td>\n";
			output_str = output_str + "<td valign='top'>\n<img src='images/indent.png' border=0 alt='Indent' name='Indent' id='Indent" + i + "' onClick=\"IndentItem(" + i + ");\" />\n<\/td>\n";
				
			output_str = output_str + "<td valign='top'><input type='hidden' name='ID" + i + "' id='ID" + i + "' value='" + JSON_row.ID + "'>\n";
			output_str = output_str + "<input type='text' name='item_text" + i + "' id='item_text" + i + "' value='" + Indent(JSON_row.level) + JSON_row.item_text + "'><\/td>\n";
				
			output_str = output_str + "<td>\n";
			output_str = output_str + "<input type='hidden' id='level" + i + "' value='" + JSON_row.level + "' />\n";
			if ((JSON_row.level == 0) || !JSON_row.level)
				output_str = output_str + "<span id='level_text" + i + "'>Top Level<\/span>\n";
			else if (JSON_row.level == 1)
				output_str = output_str + "<span id='level_text" + i + "'>1st Sub Level<\/span>\n";
			else if (JSON_row.level == 2)
				output_str = output_str + "<span id='level_text" + i + "'>2nd Sub Level<\/span>\n";
			else if (JSON_row.level == 3)
				output_str = output_str + "<span id='level_text" + i + "'>3rd Sub Level<\/span>\n";
			else if (JSON_row.level == 4)
				output_str = output_str + "<span id='level_text" + i + "'>4th Sub Level<\/span>\n";
			else if (JSON_row.level == 5)
				output_str = output_str + "<span id='level_text" + i + "'>5th Sub Level<\/span>\n";
			output_str = output_str + "<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='selectPage" + i + "' id='selectPage" + i + "' onChange='PopulatePage(" + i + ");'>\n";
			output_str = output_str + "<option value=''>-not selected-<\/option>\n";
			
			for (j = 0; j < page_cnt; j++)
			{
				if (pages_full[j] == JSON_row.URL)
					output_str = output_str + "<option value='" + pages[j] + "' selected='selected'>" + pages[j] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + pages[j] + "'>" + pages[j] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			
			output_str = output_str + "<input type='text' name='URL" + i + "' id='URL" + i + "' value='" + JSON_row.URL + "'><\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='target_select" + i + "' id='target_select" + i + "' onChange='PopulateTarget(" + i + ");'>\n";
			if (!JSON_row.target)
				JSON_row.target = "_self";
			if (JSON_row.target == "_self")
				output_str = output_str + "<option value='_self' selected='selected'>Self (normal)<\/option>\n";
			else
				output_str = output_str + "<option value='_self'>Self (normal)<\/option>\n";
			if (JSON_row.target == "_blank")
				output_str = output_str + "<option value='_blank' selected='selected'>New Window<\/option>\n";
			else
				output_str = output_str + "<option value='_blank'>New Window<\/option>\n";
			if ((JSON_row.target != "_blank") && (JSON_row.target != "_self"))
				output_str = output_str + "<option value='enter frame name' selected='selected'>Named Frame<\/option>\n";
			else
				output_str = output_str + "<option value='enter frame frame'>Named Frame<\/option>\n";
			output_str = output_str + "<\/select>\n";
			if ((JSON_row.target == "_blank") || (JSON_row.target == "_self"))
				output_str = output_str + "<input type='hidden' name='target" + i + "' id='target" + i + "' value='" + JSON_row.target + "'><\/td>\n";
			else
				output_str = output_str + "<input type='text' name='target" + i + "' id='target" + i + "' value='" + JSON_row.target + "'><\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<input type='hidden' id='sort_order" + i + "' name='sort_order" + i + "' value='" + JSON_row.sort_order + "' />\n";
			
			output_str = output_str + "<img src='images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateMenuItem(" + JSON_row.ID + ", " + i + ");\" />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddMenuItem(" + i + ");\" />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='images/arrow-up.png' border=0 alt='Move Up' name='MoveUp' id='MoveUp" + i + "' onClick=\"MoveItem(" + i + ");\" />\n<\/td>\n";
			
			d = parseInt(i) + 1;
			output_str = output_str + "<td valign='top'>\n<img src='images/arrow-down.png' border=0 alt='Move Down' name='MoveDown'  id='MoveDown" + i + "' onClick=\"MoveItemDown(" + d + ");\" />\n<\/td>\n";
			
			tmp = JSON_row.item_text;
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			output_str = output_str + "<td valign='top'>\n<img src='images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm('" + tmp + "', " + JSON_row.ID + ", " + i + ");\" />\n<\/td>\n";
			
			output_str = output_str + "<\/tr>\n";
		}
		i++;
	}
	if (bgclr == "#dddddd")
		bgclr = "#eeeeee";
	else
		bgclr = "#dddddd";
	output_str = output_str + "<tr id=\"row" + i + "\" bgcolor='" + bgclr + "'>\n";
	output_str = output_str + "<td colspan='7'>&nbsp;<\/td>\n";
	output_str = output_str + "<td valign='top'>\n<img src='images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddMenuItem(" + i + ");\" />\n<\/td>\n";
	output_str = output_str + "<td colspan='3'>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	output_str = output_str + "<\/table>\n";
	
	document.getElementById("MenuItemsTable").innerHTML = output_str;
	document.getElementById("nCount").value = i;
	
	if (rows[0] != "-no data-")
	{
		LastMoveDown = "MoveDown" + (i - 1);
		document.getElementById(LastMoveDown).style.display = "none";
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById("Indent0").style.display = "none";
		document.getElementById("IndentRemove0").style.display = "none";
	}
}

///////////////////////////////////////////////////////////////////////////////////
function RetunToMainConfirm()
{
	if (!saved)
	{
		var ntop;
		ntop = tempY;
		if (ntop < 500)
			ntop = ntop + 20;
		else
			ntop = ntop - 20;
		var strtop = ntop + "px";
		
		document.getElementById("return_confirm").style.display = "block";
		document.getElementById("return_confirm").style.position = "absolute";
		document.getElementById("return_confirm").style.top = strtop;
		document.getElementById("return_confirm").style.left = "200px";
		document.getElementById("return_confirm").style.width = "450px";
		document.getElementById("return_confirm").style.backgroundColor = "#FFF";
		document.getElementById("return_confirm").style.borderStyle = "solid";
		document.getElementById("return_confirm").style.borderWidth = "2px";
		document.getElementById("return_confirm").style.borderColor = "#000";
	}
	else
		window.location.href = "main.php?mode=edit";
}

function ReturnToMainMenu(response)
{
	if (response == 1)
		UpdateAll();
	window.location.href = "main.php?mode=edit";
}

////////////////////////////////////////////////////////////////////////////////////////
function MoveItem(i)
{
	update_all = true;
	saved = false;
	
	var html = document.getElementById("MenuItemsTable").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var t = i - 1;
	var b = i + 1;
	var srch_str_t;
	var srch_str_b;
	var srch_str_i;
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		srch_str_t = "<TR id=row" + t;
		srch_str_b = "<TR id=row" + b;
		srch_str_i = "<TR id=row" + i;
	}
	else
	{
		srch_str_t = "<tr id=\"row" + t + "\"";
		srch_str_b = "<tr id=\"row" + b + "\"";
		srch_str_i = "<tr id=\"row" + i + "\"";
	}
	
	// Get top part of table.
	var html_top = html.substring(0, html.indexOf(srch_str_t));
	
	// Get bottom part of table.
	var html_bottom = html.substring(html.indexOf(srch_str_b));
	
	// Get row to move down.
	var html_move_down = html.substring(html_top.length, html.indexOf(srch_str_i));
	
	// Get row to move up.
	var html_move_up = html.substring(html_top.length + html_move_down.length, html.indexOf(srch_str_b));
	
	var rplc_str;
	srch_str = "row" + t;
	rplc_str = "row" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "ID" + t;
	rplc_str = "ID" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "item_text" + t;
	rplc_str = "item_text" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "level" + t;
	rplc_str = "level" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "level_text" + t;
	rplc_str = "level_text" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "selectPage" + t;
	rplc_str = "selectPage" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "PopulatePage(" + t;
	rplc_str = "PopulatePage(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "URL" + t;
	rplc_str = "URL" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "target_select" + t;
	rplc_str = "target_select" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "PopulateTarget(" + t;
	rplc_str = "PopulateTarget(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "target" + t;
	rplc_str = "target" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "sort_order" + t;
	rplc_str = "sort_order" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "UpdateMenuItem(-1, " + t;
	rplc_str = "UpdateMenuItem(-1, " + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "AddMenuItem(" + t;
	rplc_str = "AddMenuItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "DeleteConfirm('', -1, " + t;
	rplc_str = "DeleteConfirm('', -1, " + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveUp" + t;
	rplc_str = "MoveUp" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveDown" + t;
	rplc_str = "MoveDown" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItem(" + t;
	rplc_str = "MoveItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItemDown(" + i;
	rplc_str = "MoveItemDown(" + b;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "Indent" + t;
	rplc_str = "Indent" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "IndentRemove" + t;
	rplc_str = "IndentRemove" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "IndentItem(" + t;
	rplc_str = "IndentItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "IndentItemRemove(" + t;
	rplc_str = "IndentItemRemove(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	
	var topclr = "#aaffaa";
	var botclr = "#ffaaaa";
	var bgclr1 = "#dddddd";
	var bgclr2 = "#eeeeee";
	html_move_up = html_move_up.replace(bgclr1,topclr);
	html_move_up = html_move_up.replace(bgclr2,topclr);
	html_move_down = html_move_down.replace(bgclr1,botclr);
	html_move_down = html_move_down.replace(bgclr2,botclr);
			
	html = html_top + html_move_up + html_move_down + html_bottom;
	
	var cnt_1 = cnt - 1;
	var cnt_2 = cnt - 2;
	LastMoveDown = "MoveDown" + cnt_1;
	NextToLastMoveDown = "MoveDown" + cnt_2;
	
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		// This next block of code is intenended to fix an id attribute issue with IE, but does not work.
		srch_str = "id=" + LastMoveDown;
		rplc_str = "id='" + LastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		srch_str = "id=" + NextToLastMoveDown;
		rplc_str = "id='" + NextToLastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		html = html.replace("id=MoveUp0","id=\"MoveUp0\"");
		html = html.replace("id=MoveUp1","id=\"MoveUp1\"");
		html = html.replace("id=IndentRemove0","id=\"IndentRemove0\"");
		html = html.replace("id=IndentRemove1","id=\"IndentRemove1\"");
		
		// Note the order in which the HTML is added to the element.
		document.getElementById("MenuItemsTable").innerHTML = html;
		
		// Since the trick above for fixing the ids did not work, just update everthing now which will refresh the page.
		UpdateAll();
	}
	else
	{
		// Note the order in which the HTML is added to the element.
		document.getElementById("MenuItemsTable").innerHTML = html;
		
		document.getElementById(LastMoveDown).style.display = "none";
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById(NextToLastMoveDown).style.display = "table-row";
		document.getElementById("MoveUp1").style.display = "table-row";
		document.getElementById("Indent0").style.display = "none";
		document.getElementById("Indent1").style.display = "table-row";
		document.getElementById("IndentRemove0").style.display = "none";
		document.getElementById("IndentRemove1").style.display = "table-row";
	}
}

function MoveItemDown(i)
{
	MoveItem(i);
}

///////////////////////////////////////////////////////////////////////////////////
function IndentItem(i)
{	
	var j = i - 1;
	var nesting_level_ctl = "level" + i;
	var parent_nesting_level_ctl = "level" + j;
	var nesting_level = document.getElementById(nesting_level_ctl).value;
	var parent_nesting_level = document.getElementById(parent_nesting_level_ctl).value;
	var indent = "   ";
	
	if ((nesting_level < 5) && (nesting_level <= parent_nesting_level))
	{
		saved = false;
		
		nesting_level++;
		var item_text_ctl = "item_text" + i;
		document.getElementById(item_text_ctl).value = indent + document.getElementById(item_text_ctl).value;
		document.getElementById(nesting_level_ctl).value = nesting_level;
		var nesting_level_text_ctl = "level_text" + i;
		if (nesting_level == 0)
			document.getElementById(nesting_level_text_ctl).innerHTML = "Top Level";
		else if (nesting_level == 1)
			document.getElementById(nesting_level_text_ctl).innerHTML = "1st Sub Level";
		else if (nesting_level == 2)
			document.getElementById(nesting_level_text_ctl).innerHTML = "2nd Sub Level";
		else if (nesting_level == 3)
			document.getElementById(nesting_level_text_ctl).innerHTML = "3rd Sub Level";
		else if (nesting_level == 4)
			document.getElementById(nesting_level_text_ctl).innerHTML = "4th Sub Level";
		else if (nesting_level == 5)
			document.getElementById(nesting_level_text_ctl).innerHTML = "5th Sub Level";
			
	}
}

function IndentItemRemove(i)
{	
	var j = i - 1;
	var nesting_level_ctl = "level" + i;
	var parent_nesting_level_ctl = "level" + j;
	var nesting_level = document.getElementById(nesting_level_ctl).value;
	var parent_nesting_level = document.getElementById(parent_nesting_level_ctl).value;
	
	if (nesting_level > 0)
	{
		saved = false;
		
		nesting_level--;
		var item_text_ctl = "item_text" + i;
		var item_text = document.getElementById(item_text_ctl).value;
		item_text = item_text.trim();
		
		document.getElementById(nesting_level_ctl).value = nesting_level;
		var nesting_level_text_ctl = "level_text" + i;
		if (nesting_level == 0)
			document.getElementById(nesting_level_text_ctl).innerHTML = "Top Level";
		else if (nesting_level == 1)
			document.getElementById(nesting_level_text_ctl).innerHTML = "1st Sub Level";
		else if (nesting_level == 2)
			document.getElementById(nesting_level_text_ctl).innerHTML = "2nd Sub Level";
		else if (nesting_level == 3)
			document.getElementById(nesting_level_text_ctl).innerHTML = "3rd Sub Level";
		else if (nesting_level == 4)
			document.getElementById(nesting_level_text_ctl).innerHTML = "4th Sub Level";
		else if (nesting_level == 5)
			document.getElementById(nesting_level_text_ctl).innerHTML = "5th Sub Level";

		document.getElementById(item_text_ctl).value = Indent(nesting_level) + item_text;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function PopulatePage(i)
{
	var pageSelect_ctl = "selectPage" + i;
	var URL_ctl = "URL" + i;
	var url = document.getElementById(pageSelect_ctl).value + ".php";
	document.getElementById(URL_ctl).value = url;
	
	saved = false;
}

function PopulateTarget(i)
{
	var target_select_ctl = "target_select" + i;
	var target_ctl = "target" + i;
	var target = document.getElementById(target_select_ctl).value;
	document.getElementById(target_ctl).value = target;
	
	if ((target != "_self") && (target != "_blank"))
		document.getElementById(target_ctl).type = "text";
	else
		document.getElementById(target_ctl).type = "hidden";
	
	saved = false;
}
</script>

</head>

<body>
<div align="center">

<table width="80%"><tr>
<td class="title" align="right">Revise Menu Items</td>
<td align="center" width="35%"><div id="StatusMsg"> </div></td>
<td align="right"><input type="button" name="Back" id="Back" value="Back to Main Menu" onClick="RetunToMainConfirm();"></td>
</tr></table>
	Select a menu to add items to: 
    <select name="selectMenu" id="selectMenu" onChange="javascript:RetrieveMenuItems();">
    <option value="-not selected-">-not selected-</option>
<?php
	$use_default_menu = 0;
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus`";
	$result = mysql_query($query, $bwb_link);
	$use_default_menu = mysql_num_rows($result);
	while($row = mysql_fetch_array($result))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if (($menu_name == $menu) || (($use_default_menu == 2) && ($menu_name == "menu1") && ($menu == "")))
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
?>
    </select>
	
    <div id="help_button" onClick="OpenHelpWindow();">
    &nbsp;
  	</div>
    
<?php
	if (($use_default_menu == 2) && ($menu == ""))
		$menu_source = "menu1_items";
	elseif (($menu == "-not selected-") || ($menu == ""))
		echo "Please select a menu to edit menu items.";
	else
	{
		$suffix = substr($menu, 4);
		$menu_source  = "menu" . $suffix . "_items";
	}
?>
	<div id="MenuItemsTable">&nbsp;</div>
    
		<input type='hidden' name='nCount' id='nCount'>
        <table width="80%">
		<tr><td colspan="5">&nbsp;</td></tr>
		<tr>
		<td align="center"><input type="button" value="Update All" name="update" id="update" onClick="UpdateAll();"></td>
        <td colspan="3" align="center"><div id="StatusMsg2"> </div></td>
		<td align="right">
          <input type="button" value="Back to Main Menu" name="back" onClick="RetunToMainConfirm();">
		</td>
		</tr>
	</table>

</div>

<div id="delete_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td colspan="2">Are your sure you want to delete the <b><div id="delete_text">&nbsp;</div></b> menu item?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="delete" id="delete" value="Yes" onClick="DeleteMenuItem();"></td>
	<td align="center"><input type="button" name="hide_delete" value="No" onClick="HideDelete();">
    <input type="hidden" name="menu_item_to_delete" id="menu_item_to_delete">
    </td>
  </tr>
</table>
</div>

<div id="return_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td colspan="2">Your changes have not been saved. Do you want to save your changes before returning to the main menu?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="save" value="Yes" onClick="ReturnToMainMenu(1);"></td>
	<td align="center"><input type="button" name="abort" value="No" onClick="ReturnToMainMenu(0);">
    </td>
  </tr>
</table>
</div>
<?php
	if (isset($menu))
	{
		echo "<script language='javascript' type='text/javascript'>\n";
		echo "   RetrieveMenuItems();\n";
		echo "</script>\n";
	}
?>
</body>
</html>