<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 4/26/2010	ELL
// Added warning message about system requiring JavaScript.
// Revised: 11/16/2012	ELL
// Added sending of passwords as SHA-256 hashed.  Set focus on user ID upon body load.  Capture enter key for submitting form.
//
	
	session_start();
	session_regenerate_id(true);
	
	include ("../connect/config.php");
	if (BWB_REQUIRE_SSL == 1)
	{
		//if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off' || $_SERVER['SERVER_PORT'] !== 443)
		if ($_SERVER['HTTPS'] !== 'on')
		{
			$server_name = $_SERVER['SERVER_NAME'];
			$script_filename = $_SERVER['SCRIPT_NAME'];
			$url = "https://" . $server_name . $script_filename;
			header("Location: $url");
		}
	}
	
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<script language="javascript" src="js/hash.js" type="text/javascript"> </script>
<script language="javascript" type="text/javascript">
	function SubmitLogin()
	{
		var password = document.getElementById("password_input").value;
		var hash = Sha256.hash(password);
		document.getElementById("password").value = hash;
		document.getElementById("password_input").value = '';
		document.forms["formLogin"].submit();
	}

function checkForEnter(e) {
	if (e.keyCode == 13) {
		SubmitLogin();	
	}
}

</script>
</head>

<body onLoad="document.getElementById('userid').focus();">
<form name="formLogin" method="post" action="login_verify.php">
<p align="center">&nbsp;</p>
<div align="center">
  <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td colspan="2" class="sub_title">Please enter your User ID and Password:</td>
      </tr>
      <tr>
        <td>User ID:</td>
        <td><input type="text" name="userid" id="userid" /></td>
      </tr>
      <tr>
        <td>Password:</td>
        <td>
        	<input type="password" name="password_input" id="password_input" onKeyDown="checkForEnter(event);" />
            <input type="hidden" name="password" id="password" />
        </td>
      </tr>
      <tr>
        <td colspan="2"><input type="button" name="Submit" value="Login" onClick="SubmitLogin();" /></td>
      </tr>
  </table>
</div>
</form>
<div id="javascript_warning" align="center" class="warning_text">
WARNING: JavaScript must be enabled to use this system.  Please turn on JavaScipt in your browser.
</div>
<script language="javascript" type="text/javascript">
	document.getElementById("javascript_warning").innerHTML = "";
</script>
</body>
</html>