<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/18/2009	ELL
//
// Rezised:	10/11/2011	ELL
// Fixed possible bug of semi-colon at end of line from JavaScript or PHP code in record causing false detection of end of SQL command.
// Revised: 2/9/2012	ELL
// Added table prefix handling.

	include ("check_session.php");

	$enable_file_manager = $_SESSION['enable_file_manager'];
	if ($enable_file_manager != "100")
		header("Location: /index.php");
		
	$sql_string = $_POST['sql_string'];
	
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">

<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

</head>

<body>
<table align="center" width="80%">
 <tr>
  	<td align="center">
  		<input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=admin';">
  	</td>  
  </tr>
 <tr>
 	<td>
<?php
	$sql_string = stripslashes($sql_string);
	$sql_string_arr = array();
	$line_arr = array();
	// Split SQL input into lines.
	$line_arr = preg_split("[\n|\r]", $sql_string);
	$sql_string_arr[0] = "";
	$j = 0;
	$find_start = true;
	$got_script = false;
	$got_php = false;
	$got_style = false;
	// Search for commands and assemble into SQL command array.
	for ($i = 0; $i < count($line_arr); $i++)
	{
		// Test for comment line.
		$curr_line = trim($line_arr[$i]);
		if ($find_start)
		{
			$first_chars = substr($curr_line, 0, 2);
			if (($first_chars == "--") || ($first_chars == "//"))
				continue;
		}
		$find_start = false;
		
		// It is possible for a line to end with a semicolon (;) if records contain JavaScript or PHP.  Need to turn off looking end of SQL command
		// if script or PHP is found until end of script or PHP is also found.  Otherwise we run the risk of trying to run only part of a record insert
		// which usually results in an SQL syntax error.
		if (!$got_script)
		{
			if (stripos($curr_line, "<script") !== false)
				$got_script = true;
		}
		if ($got_script)
		{
			if (stripos($curr_line, "</script>") !== false)
				$got_script = false;
		}
		
		if (!$got_php)
		{
			if (stripos($curr_line, "<?php") !== false)
				$got_php = true;
		}
		if ($got_php)
		{
			if (stripos($curr_line, "?>") !== false)
				$got_php = false;
		}
		
		if (!$got_style)
		{
			if (stripos($curr_line, "<style") !== false)
				$got_style = true;
		}
		if ($got_style)
		{
			if (stripos($curr_line, "</style>") !== false)
				$got_style = false;
		}
		
		// Build SQL command.
		$sql_string_arr[$j] = $sql_string_arr[$j] . $line_arr[$i];
		
		// Look for end of command.
		if ((!$got_script) && (!$got_php) && (!$got_style))
		{
			$last_char = substr($curr_line, (strlen($curr_line) - 1), 1);
			if ($last_char == ";")	// Got end of SQL command.
			{
				// Check for other possible reasons that ; is at end of line.
				$last_6_chars = substr($curr_line, (strlen($curr_line) - 7), 6);
				if (stripos($curr_line, "&") === false) // Looks like ; is not do to & code, good to go.
				{
					$j++;
					$sql_string_arr[$j] = "";
					$find_start = true;
				}
			}
		}
	}
	// Run SQL commands one at a time.
	for ($i = 0; $i < count($sql_string_arr); $i++)
	{
		if (strlen($sql_string_arr[$i]) > 2)
		{
			if (BWB_TABLE_PREFIX != "bwb_")
			{
				$sql_string_arr[$i] = str_replace("bwb_link", "@@@link_retention@@@", $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("bwb_", BWB_TABLE_PREFIX, $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("@@@link_retention@@@", "bwb_link", $sql_string_arr[$i]);
			}
			$result = mysql_query($sql_string_arr[$i], $bwb_link);
			echo $sql_string_arr[$i] . "<br><br>\n";
			if ($result > 0)
				echo $result . " row(s) affected.<br>\n";
			else
				echo mysql_error() . "<br>\n";
			if ($i < (count($sql_string_arr) - 1))
				echo "<br>-------------------------------------------------------------------------------<br>\n";
		}
	}
	
?>	
	</td>
  </tr>
  <tr>
  	<td align="center">
  		<input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=admin';">
  	</td>  
  </tr>
 </table>
</body>
</html>