<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/3/2011	ELL
// Revised: 2/9/2012	ELL
// Added table prefix handling.

	include_once ("check_session.php");
	
	$enable_file_manager = $_SESSION['enable_file_manager'];
	if ($enable_file_manager != "100")
		header("Location: /index.php");
	
	// Open SQL file and read in all lines.
	echo "Reading template SQL file...<br><br>\n";
	$document_root = getenv('DOCUMENT_ROOT');
	$sql_file = $document_root . "/tmp/template.sql";
	$sql_string = "";
	$handle = @fopen($sql_file, "r");
	if ($handle) {
		$sql_string = fread($handle, filesize($sql_file));
		fclose($handle);
	}
//	echo "SQL: $sql_string<br><br>\n";
	
	echo "Parsing template SQL...<br><br>\n";
	$sql_string_arr = array();
	$line_arr = array();
	// Split SQL input into lines.
	$line_arr = preg_split("[\n|\r]", $sql_string);
	$sql_string_arr[0] = "";
	$j = 0;
	$find_start = true;
	$got_script = false;
	$got_php = false;
	$got_style = false;
	// Search for commands and assemble into SQL command array.
	for ($i = 0; $i < count($line_arr); $i++)
	{
		// Test for comment line.
		// echo "i: $i ------ j: $j<br><br>\n";
		// echo "line_arr: " . $line_arr[$i] . "<br><br>\n";
		$curr_line = trim($line_arr[$i]);
		// echo "curr_line: $curr_line<br><br>\n";
		if ($find_start)
		{
			$first_chars = substr($curr_line, 0, 2);
			if (($first_chars == "--") || ($first_chars == "//"))
				continue;
		}
		$find_start = false;
		
		// It is possible for a line to end with a semicolon (;) if records contain JavaScript or PHP.  Need to turn off looking end of SQL command
		// if script or PHP is found until end of script or PHP is also found.  Otherwise we run the risk of trying to run only part of a record insert
		// which usually results in an SQL syntax error.
		if (!$got_script)
		{
			if (stripos($curr_line, "<script") !== false)
				$got_script = true;
		}
		if ($got_script)
		{
			if (stripos($curr_line, "</script>") !== false)
				$got_script = false;
		}
		
		if (!$got_php)
		{
			if (stripos($curr_line, "<?php") !== false)
				$got_php = true;
		}
		if ($got_php)
		{
			if (stripos($curr_line, "?>") !== false)
				$got_php = false;
		}
		
		if (!$got_style)
		{
			if (stripos($curr_line, "<style") !== false)
				$got_style = true;
		}
		if ($got_style)
		{
			if (stripos($curr_line, "</style>") !== false)
				$got_style = false;
		}
		
		// Build SQL command.
		$sql_string_arr[$j] = $sql_string_arr[$j] . $line_arr[$i];
		
		// Look for end of command.
		if ((!$got_script) && (!$got_php) && (!$got_style))
		{
			$last_char = substr($curr_line, (strlen($curr_line) - 1), 1);
			if ($last_char == ";")	// Got end of SQL command.
			{
				// Check for other possible reasons that ; is at end of line.
				$last_6_chars = substr($curr_line, (strlen($curr_line) - 7), 6);
				if (stripos($curr_line, "&") === false) // Looks like ; is not do to & code, good to go.
				{
					// echo "Full command: " . $sql_string_arr[$j] . "<br><br>\n";
					$j++;
					$sql_string_arr[$j] = "";
					$find_start = true;
				}
			}
		}
	}
	// Run SQL commands one at a time.
	for ($i = 0; $i < count($sql_string_arr); $i++)
	{
		if (strlen($sql_string_arr[$i]) > 2)
		{
			if (BWB_TABLE_PREFIX != "bwb_")
			{
				$sql_string_arr[$i] = str_replace("bwb_link", "@@@link_retention@@@", $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("bwb_", BWB_TABLE_PREFIX, $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("@@@link_retention@@@", "bwb_link", $sql_string_arr[$i]);
			}
			echo "SQL: " . $sql_string_arr[$i] . "<br><br>\n";
			$result = mysql_query($sql_string_arr[$i], $bwb_link);
			if ($result > 0)
				echo $result . " row(s) affected.<br>\n";
			else
				echo mysql_error() . "<br>\n";
			if ($i < (count($sql_string_arr) - 1))
				echo "<br>-------------------------------------------------------------------------------<br>\n";
		}
	}
	
?>