<?php
// "mime_mail.inc"
// Generic MIME mailer module modified by Ed Lemmers, EB Dynamics, Inc.
// For licensing, see license.txt.
// This module has the capability of sending attachments and creating either htlm or text messages.
// Other header information has been broken out from the original module including html, cc and bc
// for easier usage.  The intent is to provide easy email creating and handling without any further
// customization of this module.

class mime_mail
{
   var $parts;
   var $to;
   var $from;
   var $headers;
   var $subject;
   var $body;
   var $replyto;
   var $cc;
   var $bc;
   var $html;			// Set equal to something for html message.  Leave undefined for plain text.
   						// If plain text, the /n causes new line.  If html, then use <br> for new line.
						
   var $encode_type;	//Content Transfer Encoding:
   						// 1 -- "7bit"
						// 2 -- "quoted-printable"
						// 3 -- "base64"
						// 4 -- "8bit"
						// 5 -- "binary"
						// 0 or not set -- server default.
	
	var $no_mime;		// Some mail servers such as GoDaddy don't support mime.
	var $name;			// Name of file if adding attachment.  Set $body to attached-file data.
	var $octet_stream;	// Overrides HTML.  Use for adding attachments.

   /*
    *     void mime_mail()
    *     class constructor
    */

   function mime_mail() {
      $this->parts = array();
      $this->to =  "";
      $this->from =  "";
      $this->subject =  "";
      $this->body =  "";
      $this->headers =  "";
	  $this->replyto =  "";
	  $this->cc =  "";
	  $this->bc =  "";
	  $this->html =  "";
	  $this->encode_type = "";
	  $this->no_mime = "";
	  $this->name = "";
	  $this->octet_stream = "";
   }


   /*
    *     void add_attachment(string message, [string name], [string ctype])
    *     Add an attachment to the mail object
    */

   function add_attachment($message, $name =  "", $ctype =
"application/octet-stream") {
      $this->parts[] = array (
            "ctype" => $ctype,
            "message" => $message,
            "encode" => $encode,
            "name" => $name
                           );
		$use_base64_encode = 1;		// Flag for base64_encode if attaching binary files.
   }

   /*
    *      void build_message(array part=
    *      Build message parts of an multipart mail
    */

   function build_message($part) {
      $message = $part[ "message"];
	  if ($use_base64_encode)	// If attaching binary files then encode base64.
	  {
		  $message = chunk_split(base64_encode($message));
		  $encoding =  "base64";
	  }
	  elseif ($encode_type == 1)
	  	$encoding = "7bit";
	  elseif ($encode_type == 2)
	    $encoding =  "quoted-printable";
	  elseif ($encode_type == 3)
	    $encoding =  "base64";
	  elseif ($encode_type == 4)
	    $encoding =  "8bit";
	  elseif ($encode_type == 5)
	    $encoding =  "binary";
		
      return  "Content-Type: ".$part[ "ctype"].
         ($part[ "name"]? "; name = \"".$part[ "name"].
         "\"" :  "").

         "\nContent-Transfer-Encoding: $encoding\n\n$message\n";
   }

   /*
    *      void build_multipart()
    *      Build a multipart mail
    */

   function build_multipart() {
      $boundary =  "b".md5(uniqid(time()));
      $multipart =
         "Content-Type: multipart/mixed; boundary = $boundary\n\nThis is a
MIME encoded message.\n\n--$boundary";

         for($i = sizeof($this->parts)-1; $i >= 0; $i--)
      {
         $multipart .=  "\n".$this->build_message($this->parts[$i]).
            "--$boundary";
      }
      return $multipart.=  "--\n";
   }

   /*
    *      string get_mail()
    *      returns the constructed mail
    */


   function get_mail($complete = true) {
      $mime =  "";
       $msg_params = "";

      if (!empty($this->from))
         $msg_params .=  "From: ".$this->from. "\n";
	  if (!empty($this->replyto))
         $msg_params .=  "Reply-To: ".$this->replyto. "\n"; 
      if (!empty($this->cc))
         $msg_params .= "CC: " . $this->cc . "\n";
	  if (!empty($this->bc))
         $msg_params .= "BC: " . $this->bc . "\n";
	  if (!empty($this->headers))
         $msg_params .= $this->headers . "\n";
		 
	if ($this->no_mime)
	{
		$this->headers = $msg_params;
		$pre = 'MIME-Version: 1.0' . "\r\n";
		if ($this->html)
			$pre .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		else
			$pre .= 'Content-type: text/plain; charset=iso-8859-1' . "\r\n";
		$this->headers = $pre . $this->headers;
	}
	else
		$mime = $msg_params;

      if ($complete) {
         if (!empty($this->to)) {
            $mime .= "To: $this->to\n";
         }
         if (!empty($this->subject)) {
            $mime .= "Subject: $this->subject\n";
         }
      }

      if (!empty($this->body))
	  {
	    if ($this->octet_stream)
			$this->add_attachment($this->body,  $this->name);
	  	elseif ($this->html)
			$this->add_attachment($this->body,  $this->name,  "text/html");
		else
			$this->add_attachment($this->body,  $this->name,  "text/plain");
	  }
      $mime .=  "MIME-Version: 1.0\n".$this->build_multipart();

      return $mime;
   }

   /*
    *      void send()
    *      Send the mail (last class-function to be called)
    */

   function send() {
      $mime = $this->get_mail(false);
	  if ($this->no_mime)
      	mail($this->to, $this->subject, $this->body, $this->headers);
	  else
	  	mail($this->to, $this->subject, "", $mime);
   }
};  // end of class

?>
