<?php
/*
  $Id: paymate.php,v 2.20 2004/04/23

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2004 osCommerce

  Released under the GNU General Public License
  Modified to work with Zen Cart on ^/28/2004
  code modified by ramana on 10 apr 2008


*/

  class paymate {
    var $code, $title, $description, $enabled;

// class constructor
    function paymate() {
      global $order;

      $this->code = 'paymate';
      $this->title = MODULE_PAYMENT_PAYMATE_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_PAYMATE_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_PAYMATE_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_PAYMATE_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_PAYMATE_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_PAYMATE_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();

      $this->form_action_url = 'https://www.paymate.com/PayMate/ExpressPayment?mid=username&return=http://www.site.com.au/index.php?main_page=checkout_process';
    }

// class methods
    function update_status() {
      global $order, $db;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_PAYMATE_ZONE > 0) ) {
        $check_flag = false;
        $check_query = $db->Execute("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_PAYMATE_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while (!$check_query->EOF) {
          if ($check_query['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check_query['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
            $check_query->MoveNext();
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return false;
    }

    function process_button() {
      global $order, $currencies, $currency;	  
 
      if (MODULE_PAYMENT_PAYMATE_CURRENCY == 'Selected Currency') {
        $my_currency = $currency;		
		
      } else {
        $my_currency = substr(MODULE_PAYMENT_PAYMATE_CURRENCY, 2);
				
      } 
	  
	  //code added by ramana on 12 apr 2008. to make $my_currency to default set by admin
	  if($_SESSION['currency']=="USD") 
	     {
		   $my_currency='USD';
		 }
		 elseif($_SESSION['currency']=="EUR")
		 {
		 $my_currency='EUR';
		 }
		 elseif($_SESSION['currency']=="GBP")
		 {
		 $my_currency='GBP';
		 }
		 elseif($_SESSION['currency']=="NZD")
		 {
		 $my_currency='NZD';
		 }
		 else
		 {
		 $my_currency='AUD';
		 } 
		

      $process_button_string = 
      						   zen_draw_hidden_field('mid', MODULE_PAYMENT_PAYMATE_ID) .
                               zen_draw_hidden_field('ref', time()) .
                               zen_draw_hidden_field('pmt_sender_email', $order->customer['email_address']) .
                               zen_draw_hidden_field('pmt_contact_firstname', $order->billing['firstname']) .
                               zen_draw_hidden_field('pmt_contact_surname', $order->billing['lastname']) .
                               zen_draw_hidden_field('regindi_address1', $order->billing['street_address']) .
							   zen_draw_hidden_field('regindi_address2', $order->billing['suburb']) .
                               zen_draw_hidden_field('regindi_sub', $order->billing['city']) .
							   zen_draw_hidden_field('regindi_state', $order->billing['state']) .
							   zen_draw_hidden_field('PMT_CONTACT_PHONE', $order->customer['telephone']) .
							   zen_draw_hidden_field('pmt_country', $order->billing['country']['iso_code_2']) .
							   zen_draw_hidden_field('currency', $my_currency) .
							   zen_draw_hidden_field('currency_editable', 'N') .							   
                               zen_draw_hidden_field('regindi_pcode', $order->billing['postcode']) .
							   zen_draw_hidden_field('amt', number_format(($order->info['total'] - $order->info['']) * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency))) .
							   zen_draw_hidden_field('amt_editable', 'N').							   
							   zen_draw_hidden_field('popup', 'false').
							   zen_draw_hidden_field('notify', 'place holder for notify url').		   
							   zen_draw_hidden_field('back', zen_href_link( FILENAME_CHECKOUT_CONFIRMATION).
							   zen_draw_hidden_field('return', zen_href_link(FILENAME_CHECKOUT_PROCESS), '', 'SSL'));
      return $process_button_string;
	  	 
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function output_error() {
      return false;
    }

    function check() {
    global $db;
      if (!isset($this->_check)) {
        $check_query = $db->Execute("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PAYMATE_STATUS'");
        $this->_check = $check_query->RecordCount();
		      }
		      return $this->_check;
    }

    function install() {
    global $db;
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enable Paymate Module', 'MODULE_PAYMENT_PAYMATE_STATUS', 'True', 'Do you want to accept Paymate payments?', '6', '3', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Your Paymate Username', 'MODULE_PAYMENT_PAYMATE_ID', 'username', 'The username you use to login to the Paymate website', '6', '4', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Transaction Currency', 'MODULE_PAYMENT_PAYMATE_CURRENCY', 'Selected Currency', 'The currency to use for credit card transactions', '6', '6', 'zen_cfg_select_option(array(\'Selected Currency\',\'Only USD\',\'Only AUD\'), ', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display.', 'MODULE_PAYMENT_PAYMATE_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_PAYMATE_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'zen_get_zone_class_title', 'zen_cfg_pull_down_zone_classes(', now())");
      $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('Set Order Status', 'MODULE_PAYMENT_PAYMATE_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'zen_cfg_pull_down_order_statuses(', 'zen_get_order_status_name', now())");
    }

    function remove() {
    global $db;
      $db->Execute("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_PAYMATE_STATUS', 'MODULE_PAYMENT_PAYMATE_ID', 'MODULE_PAYMENT_PAYMATE_CURRENCY', 'MODULE_PAYMENT_PAYMATE_ZONE', 'MODULE_PAYMENT_PAYMATE_ORDER_STATUS_ID', 'MODULE_PAYMENT_PAYMATE_SORT_ORDER');
    }
  }
?>
