<?php
/**
    $Id: packaging.php,v 1.1 2010/02/03 pickupman Exp $
    
    Copyright (c) 2003 Torin Walker
    Revised for ZenCart by Joe McFrederick
    
    This program is free software; you can redistribute it and/or modify it under the terms
    of the GNU General Public License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License along with this program;
    If not, you may obtain one by writing to and requesting one from
    
    The Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA 02111-1307 USA
*/

require('includes/application_top.php');
require(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();

//Check if `packaging` table exists
$table_query = $db->Execute("SHOW TABLES FROM " . DB_DATABASE);

$tables = array();
while(!$table_query->EOF){
    $tables[] = $table_query->fields['Tables_in_' . DB_DATABASE];
    $table_query->MoveNext();
}

$columns_query = $db->Execute("SHOW COLUMNS FROM " . DB_PREFIX . "products");

$columns = array();
while(!$columns_query->EOF){
    $columns[] = $columns_query->fields['Field'];
    $columns_query->MoveNext();
}

//Packing table doesn't exists
if( !in_array(DB_PREFIX . 'packaging', $tables)){
    
    //Check columns in products table
    $alter_table = '';
    if( !in_array('products_ready_to_ship', $columns))
        $alter_table .= 'ADD COLUMN `products_ready_to_ship` tinyint(2) unsigned NOT NULL,';
    
    if( !in_array('products_length', $columns))
        $alter_table .= 'ADD COLUMN `products_length` varchar(10) DEFAULT NULL,';
        
    if ( !in_array('products_width', $columns))
        $alter_table .= 'ADD COLUMN `products_width` varchar(10) DEFAULT NULL,';
        
    if( !in_array('products_height', $columns))
        $alter_table .= 'ADD COLUMN `products_height` varchar(10) DEFAULT NULL,';
        
    if( !in_array('products_packaging', $columns))
        $alter_table .= 'ADD COLUMN `products_packaging` CHAR( 50 ) NOT NULL';
    
    
    $db->Execute("ALTER TABLE " . DB_PREFIX ."products  " . rtrim($alter_table, ','));

    $db->Execute("CREATE TABLE  " . DB_PREFIX . "packaging (
                  `package_id` int(11) NOT NULL auto_increment,
                  `package_name` varchar(64) NOT NULL default '',
                  `package_description` varchar(255) NOT NULL default '',
                  `package_length` decimal(6,2) NOT NULL default '5.00',
                  `package_width` decimal(6,2) NOT NULL default '5.00',
                  `package_height` decimal(6,2) NOT NULL default '5.00',
                  `package_empty_weight` decimal(6,2) NOT NULL default '0.00',
                  `package_max_weight` decimal(6,2) NOT NULL default '50.00',
                  `package_cost` int(5) NOT NULL default '0',
                  PRIMARY KEY  (`package_id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=0");

    $db->Execute("INSERT INTO " . DB_PREFIX . "packaging (package_name, package_description, package_length, package_width, package_height, package_empty_weight, package_max_weight, package_cost) VALUES ('Standard Case','Case box 18 x 18 x 12','18','18','12','.2','25','1.00');");
    //Make all products fit into default box to prevent errors.
    $db->Execute("UPDATE " . DB_PREFIX . " SET products_packaging = '1', products_width = '1', products_height = '1', products_length = '1'");
    $messageStack->add('Succesfully Installed: ' . DB_PREFIX . "packaging table", 'success');
    $messageStack->add('Set default products dimensions to 1in x 1in x 1in. Please update your products for the appropriate sizes for proper freight quotes.', 'error');
}
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<script language="javascript" src="includes/menu.js"></script>
<script language="javascript" src="includes/general.js"></script>
<script type="text/javascript">
  <!--
  function init()
  {
    cssjsmenu('navbar');
    if (document.getElementById)
    {
      var kill = document.getElementById('hoverJS');
      kill.disabled = true;
    }
  }
  // -->
</script>
<script language="javascript"><!--
function getObject(name) {
   var ns4 = (document.layers) ? true : false;
   var w3c = (document.getElementById) ? true : false;
   var ie4 = (document.all) ? true : false;

   if (ns4) return eval('document.' + name);
   if (w3c) return document.getElementById(name);
   if (ie4) return eval('document.all.' + name);
   return false;
}
//--></script>
<script language="javascript"><!--

var req, name;

function loadFroogleXMLDoc(request,field, loading) {

   name = field;
   var url="<?php echo HTTP_SERVER . DIR_WS_CATALOG . FILENAME_GOOGLEFROOGLE . ".php?" ?>"+request;
   // Internet Explorer
   try { req = new ActiveXObject("Msxml2.XMLHTTP"); }
   catch(e) {
      try { req = new ActiveXObject("Microsoft.XMLHTTP"); }
      catch(oc) { req = null; }
   }

   // Mozailla/Safari
   if (!req && typeof XMLHttpRequest != "undefined") { req = new XMLHttpRequest(); }

   // Call the processChange() function when the page has loaded
   if (req != null) {
      processLoading(loading);
      req.onreadystatechange = processChange;
      req.open("GET", url, true);
      req.send(null);
   }
}

function processChange() {
   if (req.readyState == 4 && req.status == 200)
      getObject(name).innerHTML = req.responseText;
}

function processLoading(text) {
  getObject(name).innerHTML = text;
}
//--></script>
</head>
<body onload="init()">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
<!-- body_text //-->
    <td width="100%" valign="top">
        <table border="0" width="100%" cellspacing="0" cellpadding="2">
          <tr>
            <td>
            <table border="0" width="100%" cellspacing="0" cellpadding="0">
              <tr>
                <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
                <td class="pageHeading" align="right"><img src="images/googlebase.gif" width="110" height="48" /></td>
              </tr>
            </table>
            </td>
          </tr>
          <tr>
          	<td width="100%" valign="top">
              <table width="100%"  border="0" cellpadding="0" cellspacing="0" class="main">
                <tr>
                  <td width="78%" align="left" valign="top"><!--end header -->
                  
                  
<?php
$activeid = $_GET['id'];

//********** New Package
if(($_POST['name'] != "" && $_POST["Action"] == "newpackage") && $_SESSION['securityToken'] || ($_POST['id'] != "" && $_POST["Action"] == "updatepackage" && $_SESSION['securityToken'])) {
    if (number_format(trim($_POST['length']), 2, '.', '') <= 0) {
        $error = MIN_LENGTH_NOT_MET;
    } else if (number_format(trim($_POST['width']), 2, '.', '') <= 0) {
        $error = MIN_WIDTH_NOT_MET;
    } else if (number_format(trim($_POST['height']), 2, '.', '') <= 0) {
        $error = MIN_HEIGHT_NOT_MET;
    } else if (number_format(trim($_POST['empty_weight']), 2, '.', '') < 0) {	
        $error = MIN_EMPTY_WEIGHT_NOT_MET;
    } else if (number_format(trim($_POST['max_weight']), 2, '.', '') < 0) {	
        $error = MIN_MAX_WEIGHT_NOT_MET;
    } else {
        
        //Prepare $_POST data
        $sql_data_array = array();
        $sql_data_array[] = array('fieldName'=>'package_name','value'=>$_POST['name'],'type'=>'string');
        $sql_data_array[] = array('fieldName'=>'package_description', 'value'=>$_POST['description'], 'type'=>'string');
        $sql_data_array[] = array('fieldName'=> 'package_length', 'value'=> $_POST['length'],'type'=>'float');
        $sql_data_array[] = array('fieldName'=> 'package_width', 'value'=> $_POST['width'],'type'=>'float');
        $sql_data_array[] = array('fieldName'=> 'package_height', 'value'=> $_POST['height'],'type'=>'float');
        $sql_data_array[] = array('fieldName'=> 'package_empty_weight', 'value'=> $_POST['empty_weight'],'type'=>'float');
        $sql_data_array[] = array('fieldName'=> 'package_cost', 'value'=> $_POST['cost'],'type'=>'float');
        $sql_data_array[] = array('fieldName'=> 'package_max_weight', 'value'=> $_POST['max_weight'],'type'=>'float');
            
      
        if ($_POST["Action"] == "newpackage") {
            
            $db->perform(TABLE_PACKAGING, $sql_data_array);
                        
        } else {
            
            $where_clause = "package_id = :packageID";
            $where_clause = $db->bindVars($where_clause, ':packageID', $_POST['id'], 'integer');
                        
            $db->perform(TABLE_PACKAGING, $sql_data_array, "update", $where_clause);
        }
    }
}

// Delete Package
if($_POST['id'] != "" && $_POST["Action"] == "deletepackage") {
    $db->Execute("delete from " . TABLE_PACKAGING . " where package_id = '" . $_POST['id'] . "'");
}


//  Display Packages
DisplayPackages($activeid, $error);

$Action = htmlspecialchars($_GET['Action']);

switch ($Action) {
    case "shownewpackageform":
    showNewPackageForm();
    break;
    case "showupdatepackageform":
    showUpdatePackageForm();
    break;
    case "showconfirmdeletepackageform":
    showConfirmDeletePackageForm();
    break;
    
    default:
    showPackageInfoForm();
    break;
}

/**
 * Get set of packages/boxes
 * @param none
 * @return array of box sizes
 */
function getPackages() {
       global $db;
               
        $sql = "select * from " . TABLE_PACKAGING . " order by package_cost";
        
        $packages = array();
        $packages_query = $db->Execute($sql);
               
        if($packages_query->RecordCount()> 0)
        {
            
            while (!$packages_query->EOF) {
                $packages[] = array(
                'id' => $packages_query->fields['package_id'],
                'name' => $packages_query->fields['package_name'],
                'description' => $packages_query->fields['package_description'],
                'length' => $packages_query->fields['package_length'],
                'width' => $packages_query->fields['package_width'],
                'height' => $packages_query->fields['package_height'],
                'empty_weight' => $packages_query->fields['package_empty_weight'],
                'max_weight' => $packages_query->fields['package_max_weight'],
                'cost' => $packages_query->fields['package_cost']);
                
                $packages_query->MoveNext();
                
            }
          
            return $packages;
        }  
        return FALSE;
}

/**
*  DisplayPackages()
* @param int $activeid of selected package id
* @param string $error
* @returns table of current packages in DB* 
*/
function DisplayPackages($activeid,$error) {
?>

    <table border="0" width="100%" cellspacing="0" cellpadding="2" width="100%">
      <tr class="dataTableHeadingRow">
        <td class="dataTableHeadingContent"><?php echo HEADING_NAME; ?></td>
        <td class="dataTableHeadingContent" align="left"><?php echo HEADING_DESCRIPTION; ?></td>
        <td class="dataTableHeadingContent" align="center"><?php echo HEADING_LENGTH; ?></td>
        <td class="dataTableHeadingContent" align="center"><?php echo HEADING_WIDTH; ?></td>
        <td class="dataTableHeadingContent" align="center"><?php echo HEADING_HEIGHT; ?></td>
        <td class="dataTableHeadingContent" align="center"><?php echo HEADING_EMPTY_WEIGHT; ?></td>
        <td class="dataTableHeadingContent" align="center"><?php echo HEADING_MAX_WEIGHT; ?></td>
        <td class="dataTableHeadingContent" align="center"><?php echo HEADING_COST; ?></td>
        <td class="dataTableHeadingContent" align="left"><?php echo HEADING_ACTION; ?></td>
      </tr>

    <?php
    
    $packages = getPackages();
    
   if (count($packages) == 0) {
        echo                         '<tr><td colspan="8">' . NO_PACKAGES_DEFINED . '</td></tr>';
    }
    if ($error != "") {
        echo '<SPAN class="errorText">'.$error.'</SPAN>';
    }
    for ($i = 0; $i < count($packages); $i++) {
        if (($_GET["Action"] != "shownewpackageform") && ($error == "")) {
            if ($activeid == "") {
                $activeid = $packages[0]['id'];
            }
        }
        if ($activeid == $packages[$i]['id']) {
            echo '<tr class="dataTableRowSelected" onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . zen_href_link(FILENAME_PACKAGING, 'id=' . $packages[$i]['id'] ).'\'">' . "\n";
        } else {
            echo '<tr class="dataTableRow" onmouseover="this.className=\'dataTableRowOver\';this.style.cursor=\'hand\'" onmouseout="this.className=\'dataTableRow\'" onclick="document.location.href=\'' . zen_href_link(FILENAME_PACKAGING, 'id=' .$packages[$i]['id'] ). '\'">' . "\n";
        }
        echo '<td class="dataTableContent" align="left"><br>' . $packages[$i]['name'] . '</td>';
        echo '<td class="dataTableContent" align="left"><br>' . $packages[$i]['description'] . '</td>';
        echo '<td class="dataTableContent" align="center"><br>' . $packages[$i]['length'] . '</td>';
        echo '<td class="dataTableContent" align="center"><br>' . $packages[$i]['width'] . '</td>';
        echo '<td class="dataTableContent" align="center"><br>' . $packages[$i]['height'] . '</td>';
        echo '<td class="dataTableContent" align="center"><br>' . $packages[$i]['empty_weight'] . '</td>';
        echo '<td class="dataTableContent" align="center"><br>' . $packages[$i]['max_weight'] . '</td>';
        echo '<td class="dataTableContent" align="center"><br>' . $packages[$i]['cost'] . '</td>';

        if ($activeid == $packages[$i]['id'] ) { 
            echo '<td>' . zen_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', ''); 
        } else { 
            echo '<td><a href="' . zen_href_link(FILENAME_PACKAGING, 'id=' . $packages[$i]['id'] ). '">' . zen_image(DIR_WS_IMAGES . 'icon_info.gif', ICON_INFO) . '</a>'; 
        }
    }
    echo '</td></tr></table><br>'."\n";
    echo '<a href="' . zen_href_link( FILENAME_PACKAGING , 'Action=shownewpackageform') .  '">'.zen_image_button('button_new_package.gif', 'New Package').'</a>&nbsp;';
    if ($activeid == "") {
        $activeid = $packages[0]['id'];
        }
    echo '<a href="' . zen_href_link( FILENAME_PACKAGING , 'Action=showupdatepackageform&id='.$activeid['id'].'') . '">'.zen_image_button('button_edit.gif', IMAGE_EDIT).'</a>&nbsp;' ;	 
    echo '<a href="' . zen_href_link( FILENAME_PACKAGING , 'Action=showconfirmdeletepackageform&id='.$activeid['id'].'') . '">'.zen_image_button('button_delete.gif', IMAGE_DELETE).'</a>' ;	 
   echo '</td><td class="infoBoxContent" valign="top">'."\n";
}

/**
 * Show the form to create a new package
 * @param none
 * @return string html of edit form
 */
function showNewPackageForm() {
    $packages = getPackages();
    $cost = 0;
    for ($i = 0; $i < count($packages); $i++) {
        if ($packages[$i]['cost'] > $cost) {
            $cost = $packages[$i]['cost'] + 1;
        }
    }

    echo "<table cellspacing='0' width='100%' cellpadding='0'><tr>\n";
    echo "<td colspan='2' class='infoBoxHeading'>". CREATE_NEW_PACKAGE."</td></tr></table>\n";
    echo zen_draw_form("newpackage", FILENAME_PACKAGING);
    echo zen_draw_hidden_field("Action", "newpackage");
    echo '<table><tr><td class="infoBoxContent"><b>'.HEADING_NAME.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_NAME_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("name").'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_DESCRIPTION.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_DESCRIPTION_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("description").'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_LENGTH.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_LENGTH_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("length").'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_WIDTH.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_WIDTH_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("width").'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_HEIGHT.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_HEIGHT_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("height").'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_EMPTY_WEIGHT.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_EMPTY_WEIGHT_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("empty_weight").'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_MAX_WEIGHT.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_MAX_WEIGHT_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("max_weight").'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_COST.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_COST_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("cost", $cost).'</td></tr>';
    echo '<tr><td colspan="2">'. zen_image_submit('button_update.gif', 'Save these values as a new package.') ;
    echo '&nbsp;&nbsp;<a href="' . zen_href_link( FILENAME_PACKAGING ) . '">'.zen_image_button('button_cancel.gif', IMAGE_CANCEL) .'</A>' ;	 
    echo "</td></tr></table>" ;
    echo ("</form>");
}

//******************************   showUpdatePackageForm()
// Show the form to update a package
function showUpdatePackageForm() {
    $packages = getPackages();
    $activepackage = $packages[0];
    if ($_GET['id'] != "") {
        for ($i = 0; $i < count($packages); $i++) {
            if ($_GET['id'] == $packages[$i]['id']) {
                $activepackage = $packages[$i];
            }
        }
    }
    echo "<table cellspacing='0' width='100%' cellpadding='0'> <tr><td colspan='2' class='infoBoxHeading'>". UPDATE_PACKAGE."</td></tr></table>\n";
    echo zen_draw_form("updatepackage", FILENAME_PACKAGING, 'id='.$activepackage['id'], 'post');
    echo zen_draw_hidden_field("Action", "updatepackage");
    echo zen_draw_hidden_field("id", $activepackage['id']);
    echo '<table><tr><td class="infoBoxContent"><b>'.HEADING_NAME.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_NAME_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("name", $activepackage['name']).'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_DESCRIPTION.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_DESCRIPTION_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("description", $activepackage['description']).'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_LENGTH.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_LENGTH_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("length", $activepackage['length']).'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_WIDTH.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_WIDTH_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("width", $activepackage['width']).'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_HEIGHT.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_HEIGHT_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("height", $activepackage['height']).'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_EMPTY_WEIGHT.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_EMPTY_WEIGHT_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("empty_weight", $activepackage['empty_weight']).'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_MAX_WEIGHT.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_MAX_WEIGHT_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("max_weight", $activepackage['max_weight']).'</td></tr>'."\n";
    echo '<tr><td class="infoBoxContent"><b>'.HEADING_COST.'</b></td></tr><tr><td class="infoBoxContent">'.HEADING_COST_TEXT.'</td></tr><tr><td class="infoBoxContent">'.zen_draw_input_field("cost", $activepackage['cost']).'</td></tr>';
    echo '<tr><td colspan="2">'. zen_image_submit('button_update.gif', 'Update the package with these values.') ;
    echo '&nbsp;&nbsp;<a href="' . zen_href_link( FILENAME_PACKAGING,'id='.$activepackage['id'] ) . '">'.zen_image_button('button_cancel.gif', IMAGE_CANCEL) .'</a>'."\n";	 
    echo "</td></tr></table>\n" ;
    echo ("</form>\n");
}

//*************************** showConfirmDeletePackageForm()
// Shows the form to confirm package deletion
function showConfirmDeletePackageForm() {
    $packages = getPackages();
    $package_name = "";
    for ($i = 0; $i < count($packages); $i++) {
        if ($packages[$i]['id'] == $_GET['id']) {
            $package_name = $packages[$i]['name'];
        }
    }
    echo "<table cellspacing='0' width='100%' cellpadding='0'> <tr><td colspan='2' class='infoBoxHeading'>". DELETE_PACKAGE."</td></tr></table>";
    echo zen_draw_form("confirmDeletePackage", FILENAME_PACKAGING);
    echo zen_draw_hidden_field("Action", "deletepackage");
    echo zen_draw_hidden_field("id", $_GET['id']);
    echo '<table cellpadding="5"><tr><td class="infoBoxContent">'.CONFIRM_DELETE.'</td></tr>' ;
    echo "<tr><td>".$package_name."</td></td>";
    echo "<tr><td>";
//    echo '<a href="' . zen_href_link( FILENAME_PACKAGING ) . '">'.zen_image_button('button_confirm.gif', IMAGE_CONFIRM) .'</a>' ;
    echo zen_image_submit('button_confirm.gif', IMAGE_CONFIRM) ;	 
    echo '&nbsp;&nbsp;<a href="' . zen_href_link( FILENAME_PACKAGING ) . '">'.zen_image_button('button_cancel.gif', IMAGE_CANCEL) .'</a>' ;	 
    echo '</td></tr></table>'."\n";
    echo '</form>'."\n";
}

//************************  ShowPackageInfo()
// Shows the info a package
function showPackageInfoForm() {
    $packages = getPackages();
    $activepackage = $packages[0];
    $activeid = $_GET["id"];
    if ($activeid != "") {
        for ($i = 0; $i < count($packages); $i++) {
            if ($activeid == $packages[$i]['id']) {
                $activepackage = $packages[$i];
            }
        }
    }
    if ($error != "") {
        echo '<SPAN class="errorText">'.$error.'</SPAN>';
    }

    echo "<table cellspacing='0' width='100%' cellpadding='0'><tr>\n<td colspan='2' class='infoBoxHeading'><b>". HEADING_INFO ."</b></td></tr></table>\n";
    if (count($packages) != 0) {
        echo '<table>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'.    HEADING_NAME    .'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['name'].'</td></tr>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'. HEADING_DESCRIPTION.'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['description'].'</td></tr>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'.   HEADING_LENGTH   .'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['length'].'</td></tr>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'.   HEADING_WIDTH    .'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['width'].'</td></tr>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'.   HEADING_HEIGHT   .'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['height'].'</td></tr>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'.HEADING_EMPTY_WEIGHT.'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['empty_weight'].'</td></tr>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'. HEADING_MAX_WEIGHT .'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['max_weight'].'</td></tr>'."\n";
        echo '<tr><td class="infoBoxContent"><b>'.    HEADING_COST    .'</b></td></tr><tr><td class="infoBoxContent">'.$activepackage['cost'].'</td></tr>'."\n";
        echo "</table>\n";
    }
    echo "";
}
?>

                    </td>
                </tr>
              </table>
           </td>
          </tr>
        </table>
      </td>
<!-- body_text_eof //-->
    </tr>
</table>
 <!-- body_eof //-->             


<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>