<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 11/12/2008	ELL
// Fixed bug with custom tags using "#" instead of ".".
// Revised: 7/30/2009	ELL
// Added section for defining class/subclass relationships.
// Revised: 8/1/2009	ELL
// Added ability to operate using different class tables and different CSS tables.  This was done to give the ability
// to style calendar grids and event grids without adding 14 more classes to the site style list.
// Renamed from tags.php to classes.php.
// Added feed thru to show/hide custom styles.
// Revised: 8/25/2009	ELL
// Removed feed thru to show/hide custom styles as no longer need with new design of having completely separate area for doing custom CSS.
// Revised: 2/7/2012	ELL
// Added table prefix handling.
// Revised: 5/29/2012	ELL
// Added ability to revise class descriptions.
// Revised: 2/13/2013	ELL
// Added class/ID dropdown for automatically prefixing class string.
// Revised: 2/18/2013	ELL
// Added checkbox for creating link set.
// 
	include ("check_session.php");
		
	$style_sheet = $_REQUEST['style_sheet'];
	$class_table = $style_sheet . "_classes";
	$last_class_edited = $_SESSION['last_class_edited'];
		
			
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` WHERE `custom` = 1 ORDER BY `sort_order`";
		if ($result = $bwb_dbh->query($query))
		{
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$class[$i] = $row["class"];
				$description[$i] = $row["description"];
				$sort_order[$i] = $row["sort_order"];
			}
		}
		
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `sort_order`";
		if ($result = $bwb_dbh->query($query))
		{
			$num_results2 = $result->rowCount();
			for ($i = 0; $i < $num_results2; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$class2[$i] = $row["class"];
				$description2[$i] = $row["description"];
				$sort_order2[$i] = $row["sort_order"];
			}
		}
		
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `subclass_sort_order`, `sort_order`";
		if ($result = $bwb_dbh->query($query))
		{
			$num_results2 = $result->rowCount();
			for ($i = 0; $i < $num_results2; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$class3[$i] = $row["class"];
				$description3[$i] = $row["description"];
				$sort_order3[$i] = $row["sort_order"];
			}
		}
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/ajax.js"></script>

<script type="text/javascript" src="js/classes.js"></script>

<script language="javascript" type="text/javascript">
function DeleteClass()
{
	var class_delete = document.getElementById("class_delete").value;
	class_delete = EscapeClass(class_delete);
	document.getElementById("delete_confirm").style.display = "none";
	var url = "delete_class.php?class=" + class_delete + "&style_sheet=<?php echo $style_sheet; ?>";
	window.location = url;
}

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
function PopulateDescription()
{
	var params = "";

	if (document.getElementById("StatusMsg").innerHTML == " ")
		document.getElementById("StatusMsg").innerHTML = "Starting populate...";

	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_class_description.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg", "Populate");
		
		var class_edit = document.getElementById("class_edit").value;
		class_edit = EscapeClass(class_edit);
		params = "class=" + class_edit;
		params = params + "&style_sheet=" + "<?php echo $style_sheet; ?>";
//		alert(params);
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateDescription()
{
	var params = "";

	if (document.getElementById("StatusMsg").innerHTML == " ")
		document.getElementById("StatusMsg").innerHTML = "Starting update...";

	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_class_description.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg", "Update");
		
		var class_edit = document.getElementById("class_edit").value;
		class_edit = EscapeClass(class_edit);
		params = "class=" + class_edit;
		params = params + "&style_sheet=" + "<?php echo $style_sheet; ?>";
		params = params + "&description=" + document.getElementById("description_edit").value;
//		alert(params);
		xmlhttp.send(params);
	}
}

</script>
</head>

<body>
<div align="center">
<table width="80%" border="0"><tr><td align="right">
  <input type="button" name="Back" value="Back to Edit Site CSS" onClick="window.location.href='edit_css.php?style_sheet=<?php echo $style_sheet; ?>&goto_class=<?php echo $last_class_edited; ?>'">
</td></tr></table>

<table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>
<form name="formAddTag" method="post" action="add_class.php">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title" style="padding-left:5px;">Add Class</td>
  </tr>
  <tr>
    <td align="right">
    	<select name="class_prefix" id="class_prefix">
            <option value="." selected="selected">Class:</option>
            <option value="#">ID:</option>
            <option value="">-none-</option>
        </select>
    </td>
    <td><input type="text" name="class" id="class" /></td>
    <td align="right">Description:&nbsp;</td>
    <td><input type="text" name="description"></td>
    <td align="right">Sort Order:&nbsp;</td>
    <td><input type="text" name="sort_order" value="100"></td>
  </tr>
  <tr><td colspan="6">&nbsp;<input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
  <input type="hidden" name="show_class_editor" value="1" />
  <span class="small_message">Select "Class" for . (dot) prefix or select "ID" for # prefix.</span></td></tr>
  <tr>
    <td width="10%">&nbsp;</td>
    <td colspan="4" align="center" ><input type="submit" name="Submit" value="Add"></td>
  	<td width="10%" align="center">
    <div id="help_button_sm" onClick="OpenHelpWindow();">
    &nbsp;
  	</div>
  	</td>
  </tr>
  </table>
  </form>
  </td></tr></table>
<br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>
<form name="formDefineSubclass" method="post" action="define_sub_class.php">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="5" class="sub_title" style="padding-left:5px;">Create Class / Subclass Relationship</td>
  </tr>
  <tr>
    <td align="right">Class:&nbsp;</td>
    <td><select name="class" id="class">
      <?php
	for ($i = 0; $i < $num_results2; $i++)
		echo "<option value='$class2[$i]'>$class2[$i]</option>";
?>
    </select></td>
    <td align="right">Subclass:&nbsp;</td>
    <td>
    <select name="subclass" id="subclass">
      <?php
	for ($i = 0; $i < $num_results2; $i++)
		echo "<option value='$class3[$i]'>$class3[$i]</option>";
?>
    </select>
    </td>
    <td>
    	<input type="checkbox" name="create_link_set" id="create_link_set" onClick="EnableDisableSubclass(this.checked);" value="1" />
        Create Link Set
    </td>
  </tr>
  <tr><td colspan="5" align="right">
  <span class="small_message">Checking "Create Link Set" will create 4 sub classes of the selected class: a:link, a:visited, a:hover, a:active.</span>
  <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
  <input type="hidden" name="show_class_editor" value="1" /></td></tr>
  <tr>
    <td colspan="5" align="center"><input type="submit" name="Submit" value="Create"></td>
  </tr>
  </table>
  </form>
  </td></tr></table>
  <br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>

  <table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title" style="padding-left:5px;">Delete Class</td>
  </tr>
  <tr>
  	<td>&nbsp;</td>
    <td align="right">Class / Description:&nbsp;</td>
    <td><select name="class_delete" id="class_delete">
<?php
	for ($i = 0; $i < $num_results; $i++)
		echo "<option value='$class[$i]'>$class[$i] / $description[$i]</option>";
?>
    </select></td>
    <td>&nbsp;</td>
  </tr>
  <tr><td colspan="4">&nbsp;</td></tr>
  <tr>
    <td colspan="4" align="center"><input type="button" name="delete" value="Delete" onClick="DeleteConfirm();"></td>
  </tr>
</table>

  </td></tr></table>
  <br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>

  <table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title" style="padding-left:5px;">Edit Class Description</td>
  </tr>
  <tr>
  	<td align="right">Class:&nbsp;</td>
    <td><select name="class_edit" id="class_edit" onChange="PopulateDescription();">
    <option>-not selected-</option>
<?php
	for ($i = 0; $i < $num_results; $i++)
		echo "<option value='$class[$i]'>$class[$i]</option>";
?>
    </select></td>
    <td align="right">Description:&nbsp;</td>
    <td><input type="text" name="description_edit" id="description_edit" /></td>
  </tr>
  <tr><td colspan="4" align="center"><div id="StatusMsg"> </div></td></tr>
  <tr>
    <td colspan="4" align="center"><input type="button" name="update" value="Update" onClick="UpdateDescription();"></td>
  </tr>
</table>

  </td></tr></table>
  <br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>
  <form name="formSortTags" method="post" action="set_class_sort_order.php">
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title" style="padding-left:5px;">Set Class Sort Order</td>
  </tr>
  <tr bgcolor="#CCCCCC">
  	<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
    <td><b>Class / Description:</b></td>
    <td><b>Sort Order:</b></td>
    <td><b>Custom:</b></td>
  </tr>
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `sort_order`";
	if ($result = $bwb_dbh->query($query))
	{
		$num_results = $result->rowCount();
		for ($i = 0; $i < $num_results; $i++)
		{
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$class[$i] = $row["class"];
			$description[$i] = $row["description"];
			$sort_order[$i] = $row["sort_order"];
			$custom[$i] = $row["custom"];
		}
	}
		
	$bgcolor = "#E5E5E5";
	for ($i = 0; $i < $num_results; $i++)
	{
		echo "<tr bgcolor='$bgcolor'>\n<td>&nbsp;</td>\n";
		echo "<td>$class[$i] / $description[$i]<input type='hidden' name='class_$i' value='$class[$i]'></td>\n";
		echo "<td><input type='text' name='sort_order_$i' value='$sort_order[$i]'></td>\n";
		if ($custom[$i] == 1)
			echo "<td>&radic;</td>\n</tr>\n";
		else
			echo "<td>&nbsp;</td>\n</tr>\n";
		if ($bgcolor == "#E5E5E5")
			$bgcolor = "#DDDDDD";
		else
			$bgcolor = "#E5E5E5";
	}
?>
  <tr><td colspan="4">&nbsp;
  <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
  <input type="hidden" name="show_class_editor" value="1" /></td></tr>
  <tr>
    <td colspan="4" align="center"><input type="submit" name="Submit" value="Update"></td>
  </tr>
</table>
  </form>
  </td></tr></table>
  <br>
  <table width="80%" border="0" cellspacing="0" cellpadding="0">
  <tr>
  <td align="right">
  <input type="button" name="Back" value="Back to Edit Site CSS" onClick="window.location.href='edit_css.php?style_sheet=<?php echo $style_sheet; ?>&goto_class=<?php echo $last_class_edited; ?>'">
  </td>
  </tr>
</table>
</div>

<div id="delete_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td colspan="2">Are your sure you want to delete the class <b><div id="delete_text">&nbsp;</div></b>?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="delete" id="delete" value="Yes" onClick="DeleteClass();" /></td>
	<td align="center"><input type="button" name="hide_delete" value="No" onClick="HideDelete();" />
    </td>
  </tr>
</table>
</div>

</body>
</html>
