<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 9/20/2008
// Modified to allow for no background colors or border.
// Revised: 9/22/2008	ELL
// Added text shadow effects.
// Revised: 11/13/08	ELL
// Fixed bug of not saving data if no shadow selected.  Bug caused by '' in SQL string.  Replaed with '-none-'.
// '-none-' will be captured in build_menu_css_string.php.
// Added GET of source page to allow color picker to populate CSS editor properly. 
// Revised: 1/9/2011	ELL
// Added capability to handle multiple JavaScript Menus.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.

	
	include ("check_session.php");
	
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
	
	$suffix = substr($menu, 4);
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<script type="text/javascript" src="js/check_color_str.js"></script>

<script language="JavaScript" type="text/javascript">
	function SelectMenu(menu)
	{
		var url = "edit_js_menu_styles.php?menu=" + menu;
		window.location.href = url;
	}

	function popupcolorpicker(form_name, field_name)
	{
		var start_color = document.getElementById(field_name).value;
		if (start_color == "")
			start_color = "-not set-";
		else
			start_color = start_color.replace("#", "");
		
		var URL = "colorpicker.php?form_name=" + form_name + "&field_name=" + field_name + "&source_page=edit_js_menu_styles.php&start_color=" + start_color;
		
		window.open (URL, "colorpicker", "alwaysRaised=0,dependent=1,menubar=0,resizable=0,width=450,height=350,scrollbars=0,location=0");
	}
	
	function enable_disable_shadow(level, mouse_event)
	{
		var shadow = level + "_shadow_" + mouse_event;
		var shadow_color = level + "_shadow_color_" + mouse_event;
		var shadow_x_offset = level + "_shadow_x_offset_" + mouse_event;
		var shadow_y_offset = level + "_shadow_y_offset_" + mouse_event;
		var shadow_blur = level + "_shadow_blur_" + mouse_event;
		
		
		if (document.getElementById(shadow).checked == true)
		{
			document.getElementById(shadow_color).disabled = false;
			document.getElementById(shadow_x_offset).disabled = false;
			document.getElementById(shadow_y_offset).disabled = false;
			document.getElementById(shadow_blur).disabled = false;
		}
		else
		{
			document.getElementById(shadow_color).disabled = true;
			document.getElementById(shadow_x_offset).disabled = true;
			document.getElementById(shadow_y_offset).disabled = true;
			document.getElementById(shadow_blur).disabled = true;
		}
	}
	
	function enable_disable_controls()
	{
		enable_disable_shadow('top_level', 'out');
		enable_disable_shadow('top_level', 'over');
		enable_disable_shadow('sub_level_1', 'out');
		enable_disable_shadow('sub_level_1', 'over');
		enable_disable_shadow('sub_level_2', 'out');
		enable_disable_shadow('sub_level_2', 'over');
	}
	
	function OpenHelpWindow()
	{
		window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_menu_styles", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
	}
</script>
</head>

<body onLoad="enable_disable_controls();">
<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td class="bold" width="40%">
Select a menu to add items to:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` WHERE `menu_type` = 1";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
?>
</select>
</td>
<td><span class="title">Menu Styles Editor</span></td>
<td align="left">
          <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=menu';" />
	</td>
<td align="right">
<div id="help_button_sm" onClick="OpenHelpWindow();">
&nbsp;
</div>
</td></tr>
</table>

<?php
if (($menu == "-not selected-") || ($menu == ""))
{
	echo "Please select a menu to edit menu items.";
	exit;
}
else
{	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $top_level_font_out = $row["font"];
	else $top_level_font_out = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $top_level_font_size_out = $row["font_size"];
	else $top_level_font_size_out = 12;
	if ($row["text_color"]) $top_level_text_color_out = $row["text_color"];
	else $top_level_text_color_out = "#000000";
	if (!is_null($row["padding_top"])) $top_level_padding_out = $row["padding_top"];
	else $top_level_padding_out = 4;
	if ($row["weight"]) $top_level_bold_out = $row["weight"];
	else $top_level_bold_out = "-not selected-";
	if ($row["italic"]) $top_level_italic_out = $row["italic"];
	else $top_level_italic_out = 0;
	if ($row["underline"]) $top_level_underline_out = $row["underline"];
	else $top_level_underline_out = 0;
	if ($row["overline"]) $top_level_overline_out = $row["overline"];
	else $top_level_overline_out = 0;
	if ($row["blink"]) $top_level_blink_out = $row["blink"];
	else $top_level_blink_out = 0;
	if ($row["shadow"]) $top_level_shadow_out = $row["shadow"];
	else $top_level_shadow_out = 0;
	if ($row["shadow_color"]) $top_level_shadow_color_out = $row["shadow_color"];
	else $top_level_shadow_color_out = "-not set-";
	if ($row["shadow_x_offset"]) $top_level_shadow_x_offset_out = $row["shadow_x_offset"];
	else $top_level_shadow_x_offset_out = 0;
	if ($row["shadow_y_offset"]) $top_level_shadow_y_offset_out = $row["shadow_y_offset"];
	else $top_level_shadow_y_offset_out = 0;
	if ($row["shadow_blur"]) $top_level_shadow_blur_out = $row["shadow_blur"];
	else $top_level_shadow_blur_out = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $top_level_font_over = $row["font"];
	else $top_level_font_over = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $top_level_font_size_over = $row["font_size"];
	else $top_level_font_size_over = 12;
	if ($row["text_color"]) $top_level_text_color_over = $row["text_color"];
	else $top_level_text_color_over = "#000000";
	if (!is_null($row["padding_top"])) $top_level_padding_over = $row["padding_top"];
	else $top_level_padding_over = 4;
	if ($row["weight"]) $top_level_bold_over = $row["weight"];
	else $top_level_bold_over = "-not selected-";
	if ($row["italic"]) $top_level_italic_over = $row["italic"];
	else $top_level_italic_over = 0;
	if (!is_null($row["underline"])) $top_level_underline_over = $row["underline"];
	else $top_level_underline_over = 1;
	if ($row["overline"]) $top_level_overline_over = $row["overline"];
	else $top_level_overline_over = 0;
	if ($row["blink"]) $top_level_blink_over = $row["blink"];
	else $top_level_blink_over = 0;
	if ($row["shadow"]) $top_level_shadow_over = $row["shadow"];
	else $top_level_shadow_over = 0;
	if ($row["shadow_color"]) $top_level_shadow_color_over = $row["shadow_color"];
	else $top_level_shadow_color_over = "-not set-";
	if ($row["shadow_x_offset"]) $top_level_shadow_x_offset_over = $row["shadow_x_offset"];
	else $top_level_shadow_x_offset_over = 0;
	if ($row["shadow_y_offset"]) $top_level_shadow_y_offset_over = $row["shadow_y_offset"];
	else $top_level_shadow_y_offset_over = 0;
	if ($row["shadow_blur"]) $top_level_shadow_blur_over = $row["shadow_blur"];
	else $top_level_shadow_blur_over = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $top_level_bkgd_color_out = $row["bkgd_color"];
	else $top_level_bkgd_color_out = "-not set-";
	if ($row["bkgd_opacity"]) $top_level_bkgd_opacity_out = $row["bkgd_opacity"];
	else $top_level_bkgd_opacity_out = -1;
	if (!is_null($row["border"])) $top_level_border_out = $row["border"];
	else $top_level_border_out = 1;
	if ($row["border_color"]) $top_level_border_color_out = $row["border_color"];
	else $top_level_border_color_out = "-not set-";
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $top_level_bkgd_color_over = $row["bkgd_color"];
	else $top_level_bkgd_color_over = "-not set-";
	if (!is_null($row["border"])) $top_level_border_over = $row["border"];
	else $top_level_border_over = 1;
	if ($row["border_color"]) $top_level_border_color_over = $row["border_color"];
	else $top_level_border_color_over = "-not set-";
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $sub_level_1_font_out = $row["font"];
	else $sub_level_1_font_out = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_1_font_size_out = $row["font_size"];
	else $sub_level_1_font_size_out = 12;
	if ($row["text_color"]) $sub_level_1_text_color_out = $row["text_color"];
	else $sub_level_1_text_color_out = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_1_padding_out = $row["padding_top"];
	else $sub_level_1_padding_out = 4;
	if ($row["weight"]) $sub_level_1_bold_out = $row["weight"];
	else $sub_level_1_bold_out = "-not selected-";
	if ($row["italic"]) $sub_level_1_italic_out = $row["italic"];
	else $sub_level_1_italic_out = 0;
	if ($row["underline"]) $sub_level_1_underline_out = $row["underline"];
	else $sub_level_1_underline_out = 0;
	if ($row["overline"]) $sub_level_1_overline_out = $row["overline"];
	else $sub_level_1_overline_out = 0;
	if ($row["blink"]) $sub_level_1_blink_out = $row["blink"];
	else $sub_level_1_blink_out = 0;
	if ($row["shadow"]) $sub_level_1_shadow_out = $row["shadow"];
	else $sub_level_1_shadow_out = 0;
	if ($row["shadow_color"]) $sub_level_1_shadow_color_out = $row["shadow_color"];
	else $sub_level_1_shadow_color_out = "-not set-";
	if ($row["shadow_x_offset"]) $sub_level_1_shadow_x_offset_out = $row["shadow_x_offset"];
	else $sub_level_1_shadow_x_offset_out = 0;
	if ($row["shadow_y_offset"]) $sub_level_1_shadow_y_offset_out = $row["shadow_y_offset"];
	else $sub_level_1_shadow_y_offset_out = 0;
	if ($row["shadow_blur"]) $sub_level_1_shadow_blur_out = $row["shadow_blur"];
	else $sub_level_1_shadow_blur_out = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $sub_level_1_font_over = $row["font"];
	else $sub_level_1_font_over = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_1_font_size_over = $row["font_size"];
	else $sub_level_1_font_size_over = 12;
	if ($row["text_color"]) $sub_level_1_text_color_over = $row["text_color"];
	else $sub_level_1_text_color_over = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_1_padding_over = $row["padding_top"];
	else $sub_level_1_padding_over = 4;
	if (!is_null($row["weight"])) $sub_level_1_bold_over = $row["weight"];
	else $sub_level_1_bold_over = "-not selected-";
	if ($row["italic"]) $sub_level_1_italic_over = $row["italic"];
	else $sub_level_1_italic_over = 0;
	if ($row["underline"]) $sub_level_1_underline_over = $row["underline"];
	else $sub_level_1_underline_over = 0;
	if ($row["overline"]) $sub_level_1_overline_over = $row["overline"];
	else $sub_level_1_overline_over = 0;
	if ($row["blink"]) $sub_level_1_blink_over = $row["blink"];
	else $sub_level_1_blink_over = 0;
	if ($row["shadow"]) $sub_level_1_shadow_over = $row["shadow"];
	else $sub_level_1_shadow_over = 0;
	if ($row["shadow_color"]) $sub_level_1_shadow_color_over = $row["shadow_color"];
	else $sub_level_1_shadow_color_over = "-not set-";
	if ($row["shadow_x_offset"]) $sub_level_1_shadow_x_offset_over = $row["shadow_x_offset_over"];
	else $sub_level_1_shadow_x_offset_over = 0;
	if ($row["shadow_y_offset"]) $sub_level_1_shadow_y_offset_over = $row["shadow_y_offset"];
	else $sub_level_1_shadow_y_offset_over = 0;
	if ($row["shadow_blur"]) $sub_level_1_shadow_blur_over = $row["shadow_blur"];
	else $sub_level_1_shadow_blur_over = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_1_bkgd_color_out = $row["bkgd_color"];
	else $sub_level_1_bkgd_color_out = "-not set-";
	if ($row["bkgd_opacity"]) $sub_level_1_bkgd_opacity_out = $row["bkgd_opacity"];
	else $sub_level_1_bkgd_opacity_out = 85;
	if (!is_null($row["border"])) $sub_level_1_border_out = $row["border"];
	else $sub_level_1_border_out = 1;
	if ($row["border_color"]) $sub_level_1_border_color_out = $row["border_color"];
	else $sub_level_1_border_color_out = "-not set-";
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_1_bkgd_color_over = $row["bkgd_color"];
	else $sub_level_1_bkgd_color_over = "-not set-";
	if (!is_null($row["border"])) $sub_level_1_border_over = $row["border"];
	else $sub_level_1_border_over = 1;
	if ($row["border_color"]) $sub_level_1_border_color_over = $row["border_color"];
	else $sub_level_1_border_color_over = "-not set-";
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $sub_level_2_font_out = $row["font"];
	else $sub_level_2_font_out = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_2_font_size_out = $row["font_size"];
	else $sub_level_2_font_size_out = 12;
	if ($row["text_color"]) $sub_level_2_text_color_out = $row["text_color"];
	else $sub_level_2_text_color_out = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_2_padding_out = $row["padding_top"];
	else $sub_level_2_padding_out = 4;
	if ($row["weight"]) $sub_level_2_bold_out = $row["weight"];
	else $sub_level_2_bold_out = "-not selected-";
	if ($row["italic"]) $sub_level_2_italic_out = $row["italic"];
	else $sub_level_2_italic_out = 0;
	if ($row["underline"]) $sub_level_2_underline_out = $row["underline"];
	else $sub_level_2_underline_out = 0;
	if ($row["overline"]) $sub_level_2_overline_out = $row["overline"];
	else $sub_level_2_overline_out = 0;
	if ($row["blink"]) $sub_level_2_blink_out = $row["blink"];
	else $sub_level_2_blink_out = 0;
	if ($row["shadow"]) $sub_level_2_shadow_out = $row["shadow"];
	else $sub_level_2_shadow_out = 0;
	if ($row["shadow_color"]) $sub_level_2_shadow_color_out = $row["shadow_color"];
	else $sub_level_2_shadow_color_out = "-not set-";
	if ($row["shadow_x_offset"]) $sub_level_2_shadow_x_offset_out = $row["shadow_x_offset"];
	else $sub_level_2_shadow_x_offset_out = 0;
	if ($row["shadow_y_offset"]) $sub_level_2_shadow_y_offset_out = $row["shadow_y_offset"];
	else $sub_level_2_shadow_y_offset_out = 0;
	if ($row["shadow_blur"]) $sub_level_2_shadow_blur_out = $row["shadow_blur"];
	else $sub_level_2_shadow_blur_out = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $sub_level_2_font_over = $row["font"];
	else $sub_level_2_font_over = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_2_font_size_over = $row["font_size"];
	else $sub_level_2_font_size_over = 12;
	if ($row["text_color"]) $sub_level_2_text_color_over = $row["text_color"];
	else $sub_level_2_text_color_over = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_2_padding_over = $row["padding_top"];
	else $sub_level_2_padding_over = 4;
	if (!is_null($row["weight"])) $sub_level_2_bold_over = $row["weight"];
	else $sub_level_2_bold_over = "-not selected-";
	if ($row["italic"]) $sub_level_2_italic_over = $row["italic"];
	else $sub_level_2_italic_over = 0;
	if ($row["underline"]) $sub_level_2_underline_over = $row["underline"];
	else $sub_level_2_underline_over = 0;
	if ($row["overline"]) $sub_level_2_overline_over = $row["overline"];
	else $sub_level_2_overline_over = 0;
	if ($row["blink"]) $sub_level_2_blink_over = $row["blink"];
	else $sub_level_2_blink_over = 0;
	if ($row["shadow"]) $sub_level_2_shadow_over = $row["shadow"];
	else $sub_level_2_shadow_over = 0;
	if ($row["shadow_color"]) $sub_level_2_shadow_color_over = $row["shadow_color"];
	else $sub_level_2_shadow_color_over = "-not set-";
	if ($row["shadow_x_offset"]) $sub_level_2_shadow_x_offset_over = $row["shadow_x_offset"];
	else $sub_level_2_shadow_x_offset_over = 0;
	if ($row["shadow_y_offset"]) $sub_level_2_shadow_y_offset_over = $row["shadow_y_offset"];
	else $sub_level_2_shadow_y_offset_over = 0;
	if ($row["shadow_blur"]) $sub_level_2_shadow_blur_over = $row["shadow_blur"];
	else $sub_level_2_shadow_blur_over = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_2_bkgd_color_out = $row["bkgd_color"];
	else $sub_level_2_bkgd_color_out = "-not set-";
	if ($row["bkgd_opacity"]) $sub_level_2_bkgd_opacity_out = $row["bkgd_opacity"];
	else $sub_level_2_bkgd_opacity_out = -1;
	if (!is_null($row["border"])) $sub_level_2_border_out = $row["border"];
	else $sub_level_2_border_out = 1;
	if ($row["border_color"]) $sub_level_2_border_color_out = $row["border_color"];
	else $sub_level_2_border_color_out = "-not set-";
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_2_bkgd_color_over = $row["bkgd_color"];
	else $sub_level_2_bkgd_color_over = "-not set-";
	if (!is_null($row["border"])) $sub_level_2_border_over = $row["border"];
	else $sub_level_2_border_over = 1;
	if ($row["border_color"]) $sub_level_2_border_color_over = $row["border_color"];
	else $sub_level_2_border_color_over = "-not set-";
}
?>

<form name="frm_menu_styles" action="save_js_menu_styles.php" method="post">
<table width="90%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
		<table width="100%" border="0" cellspacing="1" cellpadding="1">
	  <tr>
		 <td class="sub_title">Top-Level Menu</td>
	  </tr>
	  <tr><td>
	  
	  
	  
	    
		
		<table border="1" width="100%">
		  	<tr><td><table border="1" width="100%">
			 <tr>
			   <td class="sub_title">Text</td>
		     </tr>
				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Out</td>
				  </tr>
				  <tr>
					<td align="right">Font: </td>
					<td>
					<select name="top_level_font_out">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $top_level_font_out)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = websafe</span>
					</td>
					<td align="right">Font Size: </td>
					<td><input name="top_level_font_size_out" type="text" id="top_level_font_size_out" value="<?php echo $top_level_font_size_out; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td align="right">Color: </td>
					<td><input name="top_level_text_color_out" type="text" id="top_level_text_color_out" value="<?php echo $top_level_text_color_out; ?>" size="10" onBlur="CheckColorString(this);"> 
					<span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_out');">#RRGGBB</a></span></td>
					<td align="right">Padding: </td>
					<td><input name="top_level_padding_out" type="text" id="top_level_padding_out" value="<?php echo $top_level_padding_out; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table border="0" width="100%">
					     <tr>
						   <td align="center">
							   Weight:
                              <select name="top_level_bold_out" id="top_level_bold_out">
                               <option value="-not selected-" <?php if ($top_level_bold_out == "-not selected-") echo "selected='selected'"; ?>>-not selected-</option>
                               <option value="normal" <?php if ($top_level_bold_out == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($top_level_bold_out == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($top_level_bold_out == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($top_level_bold_out == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($top_level_bold_out == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($top_level_bold_out == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($top_level_bold_out == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($top_level_bold_out == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($top_level_bold_out == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($top_level_bold_out == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($top_level_bold_out == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($top_level_bold_out == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($top_level_bold_out == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  Italic: 
							  <input name="top_level_italic_out" type="checkbox" id="top_level_italic_out" value="1" <?php if ($top_level_italic_out == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      Underline: 
						      <input name="top_level_underline_out" type="checkbox" id="top_level_underline_out" value="1" <?php if ($top_level_underline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Overline: 
						      <input name="top_level_overline_out" type="checkbox" id="top_level_overline_out" value="1" <?php if ($top_level_overline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Blink: 
						      <input name="top_level_blink_out" type="checkbox" id="top_level_blink_out" value="1" <?php if ($top_level_blink_out == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   Shadow:
							  <input name="top_level_shadow_out" type="checkbox" id="top_level_shadow_out" value="1" <?php if ($top_level_shadow_out == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('top_level', 'out');"> 
						  </td>
						  <td align="center">
							  Color: 
							    <input name="top_level_shadow_color_out" type="text" id="top_level_shadow_color_out" value="<?php echo $top_level_shadow_color_out; ?>" size="10" onBlur="CheckColorString(this);"> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color_out');">#RRGGBB</a></span>						  </td>
						  <td align="center">
						      X-Offset: 
						        <input name="top_level_shadow_x_offset_out" type="text" id="top_level_shadow_x_offset_out" value="<?php echo $top_level_shadow_x_offset_out; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Y-Offset: 
						        <input name="top_level_shadow_y_offset_out" type="text" id="top_level_shadow_y_offset_out" value="<?php echo $top_level_shadow_y_offset_out; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Blur: 
						        <input name="top_level_shadow_blur_out" type="text" id="top_level_shadow_blur_out" value="<?php echo $top_level_shadow_blur_out; ?>" size="10"> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>

				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Over</td>
				  </tr>
				  <tr>
					<td align="right">Font: </td>
					<td>
					<select name="top_level_font_over">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $top_level_font_over)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = websafe</span>
					</td>
					<td align="right">Font Size: </td>
					<td><input name="top_level_font_size_over" type="text" id="top_level_font_size_over" value="<?php echo $top_level_font_size_over; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td align="right">Color: </td>
					<td><input name="top_level_text_color_over" type="text" id="top_level_text_color_over" value="<?php echo $top_level_text_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_over');"> #RRGGBB</a></span></td>
					<td align="right">Padding: </td>
					<td><input name="top_level_padding_over" type="text" id="top_level_padding_over" value="<?php echo $top_level_padding_over; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table border="0" width="100%">
					     <tr>
						   <td align="center">
                              Weight:
                              <select name="top_level_bold_over" id="top_level_bold_over">
                               <option value="-not selected-" <?php if ($top_level_bold_over == "-not selected-") echo "selected='selected'"; ?>>-not selected-</option>
                               <option value="normal" <?php if ($top_level_bold_over == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($top_level_bold_over == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($top_level_bold_over == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($top_level_bold_over == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($top_level_bold_over == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($top_level_bold_over == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($top_level_bold_over == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($top_level_bold_over == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($top_level_bold_over == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($top_level_bold_over == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($top_level_bold_over == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($top_level_bold_over == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($top_level_bold_over == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  Italic: 
							  <input name="top_level_italic_over" type="checkbox" id="top_level_italic_over" value="1" <?php if ($top_level_italic_over == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      Underline: 
						      <input name="top_level_underline_over" type="checkbox" id="top_level_underline_over" value="1" <?php if ($top_level_underline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Overline: 
						      <input name="top_level_overline_over" type="checkbox" id="top_level_overline_over" value="1" <?php if ($top_level_overline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Blink: 
						      <input name="top_level_blink_over" type="checkbox" id="top_level_blink_over" value="1" <?php if ($top_level_blink_over == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   Shadow:
							  <input name="top_level_shadow_over" type="checkbox" id="top_level_shadow_over" value="1" <?php if ($top_level_shadow_over == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('top_level', 'over');"> 
						  </td>
						  <td align="center">
							  Color: 
							    <input name="top_level_shadow_color_over" type="text" id="top_level_shadow_color_over" value="<?php echo $top_level_shadow_color_over; ?>" size="10" onBlur="CheckColorString(this);"> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color_over');">#RRGGBB</a></span>						  </td>
						  <td align="center">
						      X-Offset: 
						        <input name="top_level_shadow_x_offset_over" type="text" id="top_level_shadow_x_offset_over" value="<?php echo $top_level_shadow_x_offset_over; ?>" size="10">
						        px
						 </td>
						  <td align="center">
						      Y-Offset: 
						        <input name="top_level_shadow_y_offset_over" type="text" id="top_level_shadow_y_offset_over" value="<?php echo $top_level_shadow_y_offset_over; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Blur: 
						        <input name="top_level_shadow_blur_over" type="text" id="top_level_shadow_blur_over" value="<?php echo $top_level_shadow_blur_over; ?>" size="10"> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>
		</table></td></tr>

	  <tr><td><table border="1" width="100%">
			 <tr>
			   <td class="sub_title">Background</td>
		     </tr>
				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="8" class="sub_title">Mouse Out</td>
				  </tr>
				  <tr>
					<td align="right">Background Color: </td>
					<td><input name="top_level_bkgd_color_out" type="text" id="top_level_bkgd_color_out" value="<?php echo $top_level_bkgd_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_bkgd_color_out');"> #RRGGBB</a></span></td>
					  
					<td align="right">Opacity: </td>
					<td><input name="top_level_bkgd_opacity_out" type="text" id="top_level_bkgd_opacity_out" value="<?php echo $top_level_bkgd_opacity_out; ?>" size="10"> 
					%</td>
					<td align="right">Border: </td>
					<td><input name="top_level_border_out" type="text" id="top_level_border_out" value="<?php echo $top_level_border_out; ?>" size="6"> 
					px</td>
					<td align="right">Border Color: </td>
					<td><input name="top_level_border_color_out" type="text" id="top_level_border_color_out" value="<?php echo $top_level_border_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_border_color_out');"> #RRGGBB</a></span></td>
				  </tr>
				  <tr>
			</table></td></tr>

				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Over</td>
				  </tr>
				  <tr>
					<td align="right">Background Color: </td>
					<td><input name="top_level_bkgd_color_over" type="text" id="top_level_bkgd_color_over" value="<?php echo $top_level_bkgd_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_bkgd_color_over');"> #RRGGBB</a></span></td>
					<td align="right">Border: </td>
					<td><input name="top_level_border_over" type="text" id="top_level_border_over" value="<?php echo $top_level_border_over; ?>" size="6"> 
					px</td>
					<td align="right">Border Color: </td>
					<td><input name="top_level_border_color_over" type="text" id="top_level_border_color_over" value="<?php echo $top_level_border_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_border_color_over');"> #RRGGBB</a></span></td>
				  </tr>
			</table></td></tr>

	  </table></td></tr>
	  
	 </table>
	 
	 
	  </td></tr>
	  <tr><td>&nbsp;</td></tr>
	  <tr>
		 <td class="sub_title">Sub-Level 1 Menu</td>
	  </tr>
	  <tr><td>
	 
	 
	 
	 <table border="1" width="100%">
		  	<tr><td><table border="1" width="100%">
			 <tr>
			   <td class="sub_title">Text</td>
		     </tr>
				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Out</td>
				  </tr>
				  <tr>
					<td align="right">Font: </td>
					<td>
					<select name="sub_level_1_font_out">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_1_font_out)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = websafe</span>
					</td>
					<td align="right">Font Size: </td>
					<td><input name="sub_level_1_font_size_out" type="text" id="sub_level_1_font_size_out" value="<?php echo $sub_level_1_font_size_out; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td align="right">Color: </td>
					<td><input name="sub_level_1_text_color_out" type="text" id="sub_level_1_text_color_out" value="<?php echo $sub_level_1_text_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_out');"> #RRGGBB</a></span></td>
					<td align="right">Padding: </td>
					<td><input name="sub_level_1_padding_out" type="text" id="sub_level_1_padding_out" value="<?php echo $sub_level_1_padding_out; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table border="0" width="100%">
					     <tr>
						   <td align="center">
                              Weight:
                              <select name="sub_level_1_bold_out" id="sub_level_1_bold_out">
                               <option value="-not selected-" <?php if ($sub_level_1_bold_out == "-not selected-") echo "selected='selected'"; ?>>-not selected-</option>
                               <option value="normal" <?php if ($sub_level_1_bold_out == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_1_bold_out == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_1_bold_out == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_1_bold_out == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_1_bold_out == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_1_bold_out == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_1_bold_out == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_1_bold_out == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_1_bold_out == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_1_bold_out == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_1_bold_out == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_1_bold_out == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_1_bold_out == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  Italic: 
							  <input name="sub_level_1_italic_out" type="checkbox" id="sub_level_1_italic_out" value="1" <?php if ($sub_level_1_italic_out == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      Underline: 
						      <input name="sub_level_1_underline_out" type="checkbox" id="sub_level_1_underline_out" value="1" <?php if ($sub_level_1_underline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Overline: 
						      <input name="sub_level_1_overline_out" type="checkbox" id="sub_level_1_overline_out" value="1" <?php if ($sub_level_1_overline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Blink: 
						      <input name="sub_level_1_blink_out" type="checkbox" id="sub_level_1_blink_out" value="1" <?php if ($sub_level_1_blink_out == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   Shadow:
							  <input name="sub_level_1_shadow_out" type="checkbox" id="sub_level_1_shadow_out" value="1" <?php if ($sub_level_1_shadow_out == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_1', 'out');"> 
						  </td>
						  <td align="center">
							  Color: 
							    <input name="sub_level_1_shadow_color_out" type="text" id="sub_level_1_shadow_color_out" value="<?php echo $sub_level_1_shadow_color_out; ?>" size="10" onBlur="CheckColorString(this);"> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color_out');">#RRGGBB</a></span>						  </td>
						  <td align="center">
						      X-Offset: 
						        <input name="sub_level_1_shadow_x_offset_out" type="text" id="sub_level_1_shadow_x_offset_out" value="<?php echo $sub_level_1_shadow_x_offset_out; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Y-Offset: 
						        <input name="sub_level_1_shadow_y_offset_out" type="text" id="sub_level_1_shadow_y_offset_out" value="<?php echo $sub_level_1_shadow_y_offset_out; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Blur: 
						        <input name="sub_level_1_shadow_blur_out" type="text" id="sub_level_1_shadow_blur_out" value="<?php echo $sub_level_1_shadow_blur_out; ?>" size="10"> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>

				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Over</td>
				  </tr>
				  <tr>
					<td align="right">Font: </td>
					<td>
					<select name="sub_level_1_font_over">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_1_font_over)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = websafe</span>
					</td>
					<td align="right">Font Size: </td>
					<td><input name="sub_level_1_font_size_over" type="text" id="sub_level_1_font_size_over" value="<?php echo $sub_level_1_font_size_over; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td align="right">Color: </td>
					<td><input name="sub_level_1_text_color_over" type="text" id="sub_level_1_text_color_over" value="<?php echo $sub_level_1_text_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_over');"> #RRGGBB</a></span></td>
					<td align="right">Padding: </td>
					<td><input name="sub_level_1_padding_over" type="text" id="sub_level_1_padding_over" value="<?php echo $sub_level_1_padding_over; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table border="0" width="100%">
					     <tr>
						   <td align="center">
                               Weight:
                              <select name="sub_level_1_bold_over" id="sub_level_1_bold_over">
                               <option value="-not selected-" <?php if ($sub_level_1_bold_over == "-not selected-") echo "selected='selected'"; ?>>-not selected-</option>
                               <option value="normal" <?php if ($sub_level_1_bold_over == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_1_bold_over == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_1_bold_over == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_1_bold_over == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_1_bold_over == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_1_bold_over == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_1_bold_over == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_1_bold_over == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_1_bold_over == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_1_bold_over == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_1_bold_over == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_1_bold_over == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_1_bold_over == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  Italic: 
							  <input name="sub_level_1_italic_over" type="checkbox" id="sub_level_1_italic_over" value="1" <?php if ($sub_level_1_italic_over == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      Underline: 
						      <input name="sub_level_1_underline_over" type="checkbox" id="sub_level_1_underline_over" value="1" <?php if ($sub_level_1_underline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Overline: 
						      <input name="sub_level_1_overline_over" type="checkbox" id="sub_level_1_overline_over" value="1" <?php if ($sub_level_1_overline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Blink: 
						      <input name="sub_level_1_blink_over" type="checkbox" id="sub_level_1_blink_over" value="1" <?php if ($sub_level_1_blink_over == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   Shadow:
							  <input name="sub_level_1_shadow_over" type="checkbox" id="sub_level_1_shadow_over" value="1" <?php if ($sub_level_1_shadow_over == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_1', 'over');"> 
						  </td>
						  <td align="center">
							  Color: 
							    <input name="sub_level_1_shadow_color_over" type="text" id="sub_level_1_shadow_color_over" value="<?php echo $sub_level_1_shadow_color_over; ?>" size="10" onBlur="CheckColorString(this);"> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color_over');">#RRGGBB</a></span>						  </td>
						  <td align="center">
						      X-Offset: 
						        <input name="sub_level_1_shadow_x_offset_over" type="text" id="sub_level_1_shadow_x_offset_over" value="<?php echo $sub_level_1_shadow_x_offset_over; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Y-Offset: 
						        <input name="sub_level_1_shadow_y_offset_over" type="text" id="sub_level_1_shadow_y_offset_over" value="<?php echo $sub_level_1_shadow_y_offset_over; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Blur: 
						        <input name="sub_level_1_shadow_blur_over" type="text" id="sub_level_1_shadow_blur_over" value="<?php echo $sub_level_1_shadow_blur_over; ?>" size="10"> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>
		</table></td></tr>

	  <tr><td><table border="1" width="100%">
			 <tr>
			   <td class="sub_title">Background</td>
		     </tr>
				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="6" class="sub_title">Mouse Out</td>
				  </tr>
				  <tr>
					<td align="right">Background Color: </td>
					<td><input name="sub_level_1_bkgd_color_out" type="text" id="sub_level_1_bkgd_color_out" value="<?php echo $sub_level_1_bkgd_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_bkgd_color_out');"> #RRGGBB</a></span></td>
					<td align="right">Opacity: </td>
					<td><input name="sub_level_1_bkgd_opacity_out" type="text" id="sub_level_1_bkgd_opacity_out" value="<?php echo $sub_level_1_bkgd_opacity_out; ?>" size="10"> 
					%</td>
					<td align="right">Border: </td>
					<td><input name="sub_level_1_border_out" type="text" id="sub_level_1_border_out" value="<?php echo $sub_level_1_border_out; ?>" size="6"> 
					px</td>
					<td align="right">Border Color: </td>
					<td><input name="sub_level_1_border_color_out" type="text" id="sub_level_1_border_color_out" value="<?php echo $sub_level_1_border_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_border_color_out');"> #RRGGBB</a></span></td>
				  </tr>
				  <tr>
			</table></td></tr>

				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Over</td>
				  </tr>
				  <tr>
					<td align="right">Background Color: </td>
					<td><input name="sub_level_1_bkgd_color_over" type="text" id="sub_level_1_bkgd_color_over" value="<?php echo $sub_level_1_bkgd_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_bkgd_color_over');"> #RRGGBB</a></span></td>
					<td align="right">Border: </td>
					<td><input name="sub_level_1_border_over" type="text" id="sub_level_1_border_over" value="<?php echo $sub_level_1_border_over; ?>" size="6"> 
					px</td>
					<td align="right">Border Color: </td>
					<td><input name="sub_level_1_border_color_over" type="text" id="sub_level_1_border_color_over" value="<?php echo $sub_level_1_border_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_border_color_over');"> #RRGGBB</a></span></td>
				  </tr>
			</table></td></tr>

	  </table></td></tr>
	  
	 </table>
	 
	 
	 
	 </td></tr>
	 <tr><td>&nbsp;</td></tr>
	  <tr>
		 <td class="sub_title">Sub-Level 2 Menu</td>
	  </tr>
	  <tr><td>
	 
	 
	 
	 <table border="1" width="100%">
		  	<tr><td><table border="1" width="100%">
			 <tr>
			   <td class="sub_title">Text</td>
		     </tr>
				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Out</td>
				  </tr>
				  <tr>
					<td align="right">Font: </td>
					<td>
					<select name="sub_level_2_font_out">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_2_font_out)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = websafe</span>
					</td>
					<td align="right">Font Size: </td>
					<td><input name="sub_level_2_font_size_out" type="text" id="sub_level_2_font_size_out" value="<?php echo $sub_level_2_font_size_out; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td align="right">Color: </td>
					<td><input name="sub_level_2_text_color_out" type="text" id="sub_level_2_text_color_out" value="<?php echo $sub_level_2_text_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_out');"> #RRGGBB</a></span></td>
					<td align="right">Padding: </td>
					<td><input name="sub_level_2_padding_out" type="text" id="sub_level_2_padding_out" value="<?php echo $sub_level_2_padding_out; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table border="0" width="100%">
					     <tr>
						   <td align="center">
                               Weight:
                              <select name="sub_level_2_bold_out" id="sub_level_2_bold_out">
                               <option value="-not selected-" <?php if ($sub_level_2_bold_out == "-not selected-") echo "selected='selected'"; ?>>-not selected-</option>
                               <option value="normal" <?php if ($sub_level_2_bold_out == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_2_bold_out == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_2_bold_out == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_2_bold_out == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_2_bold_out == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_2_bold_out == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_2_bold_out == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_2_bold_out == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_2_bold_out == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_2_bold_out == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_2_bold_out == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_2_bold_out == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_2_bold_out == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  Italic: 
							  <input name="sub_level_2_italic_out" type="checkbox" id="sub_level_2_italic_out" value="1" <?php if ($sub_level_2_italic_out == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      Underline: 
						      <input name="sub_level_2_underline_out" type="checkbox" id="sub_level_2_underline_out" value="1" <?php if ($sub_level_2_underline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Overline: 
						      <input name="sub_level_2_overline_out" type="checkbox" id="sub_level_2_overline_out" value="1" <?php if ($sub_level_2_overline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Blink: 
						      <input name="sub_level_2_blink_out" type="checkbox" id="sub_level_2_blink_out" value="1" <?php if ($sub_level_2_blink_out == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   Shadow:
							  <input name="sub_level_2_shadow_out" type="checkbox" id="sub_level_2_shadow_out" value="1" <?php if ($sub_level_2_shadow_out == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_2', 'out');"> 
						  </td>
						  <td align="center">
							  Color: 
							    <input name="sub_level_2_shadow_color_out" type="text" id="sub_level_2_shadow_color_out" value="<?php echo $sub_level_2_shadow_color_out; ?>" size="10" onBlur="CheckColorString(this);"> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color_out');">#RRGGBB</a></span>						  </td>
						  <td align="center">
						      X-Offset: 
						        <input name="sub_level_2_shadow_x_offset_out" type="text" id="sub_level_2_shadow_x_offset_out" value="<?php echo $sub_level_2_shadow_x_offset_out; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Y-Offset: 
						        <input name="sub_level_2_shadow_y_offset_out" type="text" id="sub_level_2_shadow_y_offset_out" value="<?php echo $sub_level_2_shadow_y_offset_out; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Blur: 
						        <input name="sub_level_2_shadow_blur_out" type="text" id="sub_level_2_shadow_blur_out" value="<?php echo $sub_level_2_shadow_blur_out; ?>" size="10"> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>

				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Over</td>
				  </tr>
				  <tr>
					<td align="right">Font: </td>
					<td>
					<select name="sub_level_2_font_over">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_2_font_over)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = websafe</span>
					</td>
					<td align="right">Font Size: </td>
					<td><input name="sub_level_2_font_size_over" type="text" id="sub_level_2_font_size_over" value="<?php echo $sub_level_2_font_size_over; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td align="right">Color: </td>
					<td><input name="sub_level_2_text_color_over" type="text" id="sub_level_2_text_color_over" value="<?php echo $sub_level_2_text_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_over');"> #RRGGBB</a></span></td>
					<td align="right">Padding: </td>
					<td><input name="sub_level_2_padding_over" type="text" id="sub_level_2_padding_over" value="<?php echo $sub_level_2_padding_over; ?>" size="6"> 
					px</td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table border="0" width="100%">
					     <tr>
						   <td align="center">
                               Weight:
                              <select name="sub_level_2_bold_over" id="sub_level_2_bold_over">
                               <option value="-not selected-" <?php if ($sub_level_2_bold_over == "-not selected-") echo "selected='selected'"; ?>>-not selected-</option>
                               <option value="normal" <?php if ($sub_level_2_bold_over == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_2_bold_over == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_2_bold_over == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_2_bold_over == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_2_bold_over == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_2_bold_over == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_2_bold_over == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_2_bold_over == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_2_bold_over == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_2_bold_over == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_2_bold_over == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_2_bold_over == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_2_bold_over == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  Italic: 
							  <input name="sub_level_2_italic_over" type="checkbox" id="sub_level_2_italic_over" value="1" <?php if ($sub_level_2_italic_over == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      Underline: 
						      <input name="sub_level_2_underline_over" type="checkbox" id="sub_level_2_underline_over" value="1" <?php if ($sub_level_2_underline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Overline: 
						      <input name="sub_level_2_overline_over" type="checkbox" id="sub_level_2_overline_over" value="1" <?php if ($sub_level_2_overline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      Blink: 
						      <input name="sub_level_2_blink_over" type="checkbox" id="sub_level_2_blink_over" value="1" <?php if ($sub_level_2_blink_over == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   Shadow:
							  <input name="sub_level_2_shadow_over" type="checkbox" id="sub_level_2_shadow_over" value="1" <?php if ($sub_level_2_shadow_over == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_2', 'over');"> 
						  </td>
						  <td align="center">
							  Color: 
							    <input name="sub_level_2_shadow_color_over" type="text" id="sub_level_2_shadow_color_over" value="<?php echo $sub_level_2_shadow_color_over; ?>" size="10" onBlur="CheckColorString(this);"> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color_over');">#RRGGBB</a></span>						  </td>
						  <td align="center">
						      X-Offset: 
						        <input name="sub_level_2_shadow_x_offset_over" type="text" id="sub_level_2_shadow_x_offset_over" value="<?php echo $sub_level_2_shadow_x_offset_over; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Y-Offset: 
						        <input name="sub_level_2_shadow_y_offset_over" type="text" id="sub_level_2_shadow_y_offset_over" value="<?php echo $sub_level_2_shadow_y_offset_over; ?>" size="10"> 
						        px
						 </td>
						  <td align="center">
						      Blur: 
						        <input name="sub_level_2_shadow_blur_over" type="text" id="sub_level_2_shadow_blur_over" value="<?php echo $sub_level_2_shadow_blur_over; ?>" size="10"> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>
		</table></td></tr>

	  <tr><td><table border="1" width="100%">
			 <tr>
			   <td class="sub_title">Background</td>
		     </tr>
				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="6" class="sub_title">Mouse Out</td>
				  </tr>
				  <tr>
					<td align="right">Background Color: </td>
					<td><input name="sub_level_2_bkgd_color_out" type="text" id="sub_level_2_bkgd_color_out" value="<?php echo $sub_level_2_bkgd_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_bkgd_color_out');"> #RRGGBB</a></span></td>
					<td align="right">Opacity: </td>
					<td><input name="sub_level_2_bkgd_opacity_out" type="text" id="sub_level_2_bkgd_opacity_out" value="<?php echo $sub_level_2_bkgd_opacity_out; ?>" size="10"> 
					%</td>
					<td align="right">Border: </td>
					<td><input name="sub_level_2_border_out" type="text" id="sub_level_2_border_out" value="<?php echo $sub_level_2_border_out; ?>" size="6"> 
					px</td>
					<td align="right">Border Color: </td>
					<td><input name="sub_level_2_border_color_out" type="text" id="sub_level_2_border_color_out" value="<?php echo $sub_level_2_border_color_out; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_border_color_out');"> #RRGGBB</a></span></td>
				  </tr>
				  <tr>
			</table></td></tr>

				<tr><td><table border="0" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title">Mouse Over</td>
				  </tr>
				  <tr>
					<td align="right">Background Color: </td>
					<td><input name="sub_level_2_bkgd_color_over" type="text" id="sub_level_2_bkgd_color_over" value="<?php echo $sub_level_2_bkgd_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_bkgd_color_over');"> #RRGGBB</a></span></td>
					<td align="right">Border: </td>
					<td><input name="sub_level_2_border_over" type="text" id="sub_level_2_border_over" value="<?php echo $sub_level_2_border_over; ?>" size="6"> 
					px</td>
					<td align="right">Border Color: </td>
					<td><input name="sub_level_2_border_color_over" type="text" id="sub_level_2_border_color_over" value="<?php echo $sub_level_2_border_color_over; ?>" size="10" onBlur="CheckColorString(this);">
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_border_color_over');"> #RRGGBB</a></span></td>
				  </tr>
			</table></td></tr>

	  </table></td></tr>
	
	 </table>
	 
	 
	 

	 
	 
	 
	</td>
  </tr>
  
</table>
</table>

<table width="90%" border="0" cellspacing="0" cellpadding="0">
  <tr><td colspan="3">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <input type="submit" value="Update" name="submit" />
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
		</td>
		<td align="center">
          <input type="submit" value="Preview" name="submit" />
		</td>
		<td align="center">
          <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=menu';" />
		</td>
	  </tr>
</table>
</form>
</div>

</body>
</html>