////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 3/9/2013	ELL

var mTimer;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_page", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function ShowStatusMsg()
{
	var ntop;
	ntop = tempY;
	
	if (ntop < 500)
		ntop = ntop + 50;
	else
		ntop = ntop - 200;
	var strtop = ntop + "px";
	
	document.getElementById("popup_msg_div").style.display = "block";
	document.getElementById("popup_msg_div").style.position = "absolute";
	document.getElementById("popup_msg_div").style.top = strtop;
	document.getElementById("popup_msg_div").style.left = "500px";
}

function ShowStatusMsgCloseBtn()
{
	document.getElementById("popup_msg_close_btn").style.display = "inline";
}

function HideStatusMsg()
{
	document.getElementById("popup_msg_div").style.display = "none";
	document.getElementById("popup_msg_close_btn").style.display = "none";
	document.getElementById("StatusMsg").innerHTML = " ";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function LoadPage()
{
	$.post( "load_page.php", { page_name: page_name, blog_id: blog_id, special: special, mode: mode } ).done(CompleteLoadPage) ;
}
function CompleteLoadPage(data)
{
	CKEDITOR.instances['editorContainer'].setData(data);
}

function Save(action)
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	ShowStatusMsg();
	document.getElementById("StatusMsg").innerHTML = "Starting update...";
	$.post( "save_page.php", { sValue: sValue, page_name: page_name, blog_id: blog_id, special: special, mode: mode, action: action } ).done(CompleteSave) ;
}
function CompleteSave(data)	{
	document.getElementById("StatusMsg").innerHTML = data;
	mTimer = setTimeout("HideStatusMsg('StatusMsg');", 2000);
	saved = true;
}

function Preview()
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	ShowStatusMsg();
	document.getElementById("StatusMsg").innerHTML = "Preparing preview...";
	$.post( "preview_page_init.php", { sValue: sValue }, function(data){ document.getElementById("StatusMsg").innerHTML = data; }, "text" ) ;
	mTimer = setTimeout("HideStatusMsg('StatusMsg');", 2000);
	
	var preview_page_string = "preview_page.php?page_name=" + page_name + "&special=" + special + "&mode=" + mode + "&blog_id=" + blog_id;
	window.open(preview_page_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
}

function ClearContent()
{
	var encap_delim = "<!-- WYSIWYG Encapsulation. Modify HTML inside of these comments only.  All code outside of these comments is discarded. -->";
	
	page_content = prepend + encap_delim + "&nbsp;" + encap_delim + postpend;
	CKEDITOR.instances['editorContainer'].setData(page_content);
}

function Revert()
{	
	ShowStatusMsg();
	document.getElementById("StatusMsg").innerHTML = "Reverting to last published version...";
	$.post( "revert.php", { page_name: page_name, blog_id: blog_id, special: special, mode: mode, prepend: prepend, postpend: postpend }).done(CompleteRevert) ;
	
}
function CompleteRevert(data)	{
	CKEDITOR.instances['editorContainer'].setData(data);
	mTimer = setTimeout("HideStatusMsg('StatusMsg');", 2000);
}

function OptimizeResetImages(action)
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	ShowStatusMsg();
	document.getElementById("StatusMsg").innerHTML = "Starting update...";
	$.post( "optimize_reset_images.php", { sValue: sValue, userfiles: userfiles, action: action }).done(CompleteOptimizeResetImages);
}
function CompleteOptimizeResetImages(data)	{
	document.getElementById("StatusMsg").innerHTML = data;
	mTimer = setTimeout("HideStatusMsg('StatusMsg');", 2000);
}

function MainMenu(ok)
{
	if (ok)
		window.location.href = 'main.php?mode=' + mode;
	else
	{
		document.getElementById("alert_msg_div").style.display = "block";
		document.getElementById("alert_msg_div").style.position = "absolute";
		document.getElementById("alert_msg_div").style.top = "500px";
		document.getElementById("alert_msg_div").style.left = "300px";
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function ShowSaveAsMsg()
{
	var ntop;
	ntop = tempY;
	
	if (ntop < 500)
		ntop = ntop + 50;
	else
		ntop = ntop - 200;
	var strtop = ntop + "px";
	
	document.getElementById("save_as_div").style.display = "block";
	document.getElementById("save_as_div").style.position = "absolute";
	document.getElementById("save_as_div").style.top = strtop;
	document.getElementById("save_as_div").style.left = "500px";
}

function HideSaveAsMsg()
{
	document.getElementById("save_as_div").style.display = "none";
}

function SaveAs()
{
	var old_page_name = page_name;
	var new_page_name = document.getElementById("new_page_name").value;
	if ((new_page_name == null) || (new_page_name == ""))
	{
		alert("Page name cannot be blank. Please enter a page name and try again.");
		return;
	}
	var page_exists;
	$.post( "check_page_exists.php", { page_name: new_page_name }, function(data){ page_exists = data; }, "text" ) ;
	if (page_exists == "1")
		alert("Page " + new_page_name + " already exists. Please go back to the main menu to copy and rename your pages.");
	else
	{
		page_name = new_page_name;
		$.post( "copy_rename_page.php", { page_name: old_page_name, new_name: new_page_name, copy_mode: "copy", overwrite: 0, overwrite_content_only: 0, create_new_template: 0 } ) ;
		
		document.getElementById("page_name_label").innerHTML = new_page_name;
		
		Save('publish');
	}
	
	HideSaveAsMsg();
}