<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/12/2009
// Modified: 1/6/2010	ELL
// Revised list to show descriptions as well as names.
// Added ability to update descriptions after the fact.
// Revised: 1/8/2011	ELL
// Added ability to assign either CSS or JavaScript menus.
// Revised: 4/7/2011	ELL
// Fixed bug of adding JavaScript menu code to header even though CSS menu type upon assigning menus.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
//
	
	include ("check_session.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Breeze Website Builder</title>

<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style>
#help_button	{
	top:30px;
	right:20px;
}
</style>

<script language="javascript" type="text/javascript" >
function UpdateDescription(menu_name)
{
	if (menu_name == "-not selected-")
		document.getElementById("new_description").value = "";
	else
	{
		var menu_name_arr = new Array();
		var menu_desc_arr = new Array();
<?php
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY menu_name";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	$i = 0;
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		echo "		menu_name_arr[$i] = '$menu_name';\n";
		echo "		menu_desc_arr[$i] = '$description';\n";
		$i++;
	}
	echo "		var count = $i;\n";
?>
	
		for (i = 0; i < count; i++)
		{
			if (menu_name == menu_name_arr[i])
				document.getElementById("new_description").value = menu_desc_arr[i];
		}
	}
}

function UpdateType(menu_name)
{
	if (menu_name == "-not selected-")
	{
		document.getElementById("menu_type3").value = -1;
		document.getElementById("menu_type3").text = "-not selected-";
	}
	else
	{
		var menu_name_arr = new Array();
		var menu_type_arr = new Array();
<?php
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY menu_name";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	$i = 0;
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$menu_type = $row['menu_type'];
		echo "		menu_name_arr[$i] = '$menu_name';\n";
		echo "		menu_type_arr[$i] = '$menu_type';\n";
		$i++;
	}
	echo "		var count = $i;\n";
?>
	
		var new_val;
		for (i = 0; i < count; i++)
		{
			if (menu_name == menu_name_arr[i])
			{
				if (menu_type_arr[i] == 0)
					new_val = 1
				else
					new_val = 0;
				document.getElementById("menu_type3").value = new_val;
				if (new_val == 0)
					document.getElementById("menu_type3").text = "CSS";
				else
					document.getElementById("menu_type3").text = "JavaScript";
			}
		}
	}
}
function SubmitUpdateType()
{
	alert("You will need to re-assign this menu to the border area to complete the conversion.");
	document.forms["frmUpdateMenuType"].submit();
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#manage_menu", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function DeleteConfirm()
{
	document.getElementById("delete_confirm").style.display = "block";
	document.getElementById("delete_confirm").style.position = "absolute";
	document.getElementById("delete_confirm").style.top = "200px";
	document.getElementById("delete_confirm").style.left = "300px";
	document.getElementById("delete_confirm").style.width = "450px";
	document.getElementById("delete_confirm").style.backgroundColor = "#FFF";
	document.getElementById("delete_confirm").style.borderStyle = "solid";
	document.getElementById("delete_confirm").style.borderWidth = "2px";
	document.getElementById("delete_confirm").style.borderColor = "#000";
	document.getElementById("delete_text").innerHTML = document.getElementById("selectMenuDelete").value;
}

function DeleteMenu()
{
	var menu = document.getElementById("selectMenuDelete").value;
	document.getElementById("delete_confirm").style.display = "none";
	var url = "delete_menu.php?menu=" + menu;
	window.location = url;
}

function HideDelete()
{
	document.getElementById("delete_confirm").style.display = "none";
}

function UpdateMenuType(nFrmIndex)
{
	var sFormName = "frmAssign" + nFrmIndex;
	var frmElement = document.forms[sFormName]
	var cntMenuSelect = frmElement.elements["menu_name"];
	var cntMenuType = frmElement.elements["menu_type"];
	var nSelectedIndex = cntMenuSelect.selectedIndex;
	var sMenuSting = cntMenuSelect.options[nSelectedIndex].text;
	// menu_type = 1 ---> JavaScript, menu_type = 0 ---> CSS
	var nResult = sMenuSting.indexOf("(JavaScript)");
	if (nResult > 0)
		cntMenuType.value = 1;
	else
		cntMenuType.value = 0;
}
</script>

</head>

<body>
<p align="center" class="title">Menu  Assignment</p>
<table width="80%" border="1" align="center"><tr>
  <td>
<span class="sub_title">Add Menu</span>
<form name="frmAddMenu" method="post" action="add_menu.php">
<table width="100%" border="0" align="center">
<tr>
<td align="center">
Menu Type:
<select name="menu_type" id="menu_type">
  <option value="0">CSS</option>
  <option value="1">JavaScript</option>
</select>
</td>
<td align="center">
  Description: 
  <input type="text" name="description" id="description" />
</td>
<td align="center">
  <input type="submit" name="submit" value="Create New Menu" />
</td>
</tr>
</table>
</form>
</td></tr></table>
<br />

<table width="80%" border="1" align="center"><tr><td>
<table width="100%" border="0" align="center">
<tr bgcolor="#CCCCCC">
  <td colspan="3"><span class="sub_title">Assign Menu to Border Area</span></td></tr>
  <?php
  		$bgcolor = "#EEEEEE";
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special";
		$result = $bwb_dbh->query($query);
		$i = 1;
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_type = -1;
			$border_area = $row["page_name"];
			echo "<form name='frmAssign$i' method='post' action='assign_menu.php'>\n";
			echo "<tr bgcolor='$bgcolor'>\n";
			echo "<td>$border_area</td>";
			
			echo "<td>\n";
			echo "<select name=\"menu_name\" onChange=\"UpdateMenuType($i);\">\n";
			echo "<option value='-not assigned-'>-not assigned-</option>\n";
			$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus`";
			$result2 = $bwb_dbh->query($query2);
			while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
			{
				$menu_name = $row2["menu_name"];
				$description = $row2['description'];
				$tmp_menu_type = $row2["menu_type"];
				if ($tmp_menu_type == 1)
					$type_str = "JavaScript";
				else
					$type_str = "CSS";
				
				$query3 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menu_assignments` WHERE menu_name = '$menu_name' AND border_area = '$border_area'";
				$result3 = $bwb_dbh->query($query3);
				if ($result3->rowCount() > 0)
				{
					echo "<option value='$menu_name' selected='selected'>$description ($menu_name) ($type_str)</option>\n";
					$menu_type = $tmp_menu_type;
				}
				else
					echo "<option value='$menu_name'>$description ($menu_name) ($type_str)</option>\n";
			}
			echo "</select>\n";
			echo "</td>\n";
			echo "<td>\n";
			echo "<input type='submit' name='submit' value='Assign' />\n";
			echo "<input type='hidden' name='border_area' value='$border_area' />\n";
			echo "<input type='hidden' name='menu_type' value='$menu_type' />\n";
			echo "</td>\n";
			echo "</tr>\n";
			echo "</form>";
			$i++;
			if ($bgcolor == "#EEEEEE")
				$bgcolor = "#DDDDDD";
			else
				$bgcolor = "#EEEEEE";
		}
   ?>
</table>
</td></tr></table>
<br />

	<table width="80%" border="1" align="center"><tr>
	  <td>
    <span class="sub_title">Delete Menu</span>
	<table width="100%" align="center" border="0"><tr>
	  <td align="center">Select the menu you want to delete: </td>
	  <td>
		<select name="selectMenuDelete" id="selectMenuDelete">
	<?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE (menu_name != 'menu') AND (menu_name != 'menu1') ORDER BY menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			if ($menu_name == $menu)
				echo "<option value='$menu_name' selected='selected'>$description ($menu_name)</option>\n";
			else
				echo "<option value='$menu_name'>$description ($menu_name)</option>\n";
		}
	?>
		</select>
	  </td>
	  <td align="center">
	  <input type="button" name="delete" value="Delete" <?php if ($row_count < 1) echo "disabled='disabled'"; ?> onClick="DeleteConfirm();" />
	  </td>
	</tr></table>
    </td></tr></table>


<br />
	<table width="80%" border="1" align="center"><tr>
	  <td>
    <span class="sub_title">Update Menu Description</span>
    <form name="frmUpdateMenuDesc" method="post" action="update_menu_description.php">
	<table width="100%" align="center" border="0"><tr>
	  <td align="center">Select the menu you want to revise: </td>
	  <td>
		<select name="selectMenu2" onchange="UpdateDescription(this.value);">
        <option >-not selected-</option>
	<?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			if ($menu_name == $menu)
				echo "<option value='$menu_name' selected='selected'>$description ($menu_name)</option>\n";
			else
				echo "<option value='$menu_name'>$description ($menu_name)</option>\n";
		}
	?>
		</select>
	  </td>
      <td>New Description: </td>
      <td><input type="text" name="new_description" id="new_description" /></td>
	  <td align="center">
	  <input type="submit" name="Submit" value="Update">
	  </td>
	</tr></table>
    </form>
    </td></tr></table>
    
    <br />
	<table width="80%" border="1" align="center"><tr>
	  <td>
    <span class="sub_title">Change Menu Type</span>
    <form name="frmUpdateMenuType" method="post" action="update_menu_type.php">
	<table width="100%" align="center" border="0"><tr>
	  <td align="center">Select the menu you want to revise: </td>
	  <td><select name="selectMenu3" onchange="UpdateType(this.value);">
	    <option >-not selected-</option>
	    <?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			$menu_type = $row['menu_type'];
			if ($menu_type == 1)
				$type_str = "JavaScript";
			else
				$type_str = "CSS";
			echo "<option value='$menu_name'>$description ($menu_name) ($type_str)</option>\n";
		}
	?>
	    </select></td>
      <td>New Menu Type: </td>
      <td>
      <select name="menu_type3" id="menu_type3">
      <option value="-1">-not selected-</option>
	  <option value="0">CSS</option>
	  <option value="1">JavaScript</option>
	  </select>
      </td>
	  <td align="center">
	  <input type="button" name="update_type" value="Update" onclick="SubmitUpdateType();">
	  </td>
	</tr></table>
    </form>
    </td></tr></table>

<br />
<table width="80%" border="0" cellspacing="0" cellpadding="0">
  <tr><td align="right">
  <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=menu';">
  </td></tr>
</table>

<div id="help_button" onClick="OpenHelpWindow();">
&nbsp;
</div>

<div id="delete_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td colspan="2">Are your sure you want to delete the <b><div id="delete_text">&nbsp;</div></b> menu?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="delete" id="delete" value="Yes" onClick="DeleteMenu();" /></td>
	<td align="center"><input type="button" name="hide_delete" value="No" onClick="HideDelete();" />
    </td>
  </tr>
</table>
</div>

</body>
</html>