<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 10/12/2010 ELL
// Added order by `revised` descending which is now possible because `revised` field was changed from VARCHAR to TIMESTAMP.
// Revised: 2/3/2011	ELL
// Added selection of page name and filtering by page name to make less cumbersome.
// Revised: 2/9/2012	ELL
// Added table prefix handling.
//
	include ("check_session.php");
	
	$page_name = $_REQUEST['page_name'];
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="../userfiles/css/site.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<style>
body	{
	background-color:#FFFFFF;
}

#help_button_sm	{
	position:inherit;
	width:30px;
	height:28px;
	background-image:url(images/HelpIcon_xsm.png);
}

#delete_confirm	{	display:none;	}
#delete_text	{	display:inline; font-weight:bold;	}
#restore_confirm	{	display:none;	}
#restore_text	{	display:inline; font-weight:bold;	}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>

<script language="javascript" type="text/ecmascript">
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#restore_page_select", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

//////////////////////////////////////////////////////////////
function DeleteConfirm(page_name, ID, y_offset)
{
	var ntop;
	ntop = tempY;
	if (ntop < 500)
		ntop = ntop + 20;
	else
		ntop = ntop - 20;
	var strtop = ntop + "px";
	
	document.getElementById("delete_confirm").style.display = "block";
	document.getElementById("delete_confirm").style.position = "absolute";
	document.getElementById("delete_confirm").style.top = strtop;
	document.getElementById("delete_confirm").style.left = "200px";
	document.getElementById("delete_confirm").style.width = "450px";
	document.getElementById("delete_confirm").style.backgroundColor = "#FFF";
	document.getElementById("delete_confirm").style.borderStyle = "solid";
	document.getElementById("delete_confirm").style.borderWidth = "2px";
	document.getElementById("delete_confirm").style.borderColor = "#000";
	document.getElementById("delete_text").innerHTML = page_name;
	document.getElementById("page_to_delete").value = ID;
}

function DeletePageFromHistory()
{
	var ID = document.getElementById("page_to_delete").value;
	var page_name = document.getElementById("delete_text").innerHTML
	document.getElementById("delete_confirm").style.display = "none";
	var url = "delete_from_history.php?ID=" + ID + "&page_name=" + page_name;
	window.location = url;
}

function HideDelete()
{
	document.getElementById("delete_confirm").style.display = "none";
}

////////////////////////////////////////////////////////////////////
function RestoreConfirm(page_name, ID, y_offset)
{
	var ntop;
	ntop = tempY;
	if (ntop < 500)
		ntop = ntop + 20;
	else
		ntop = ntop - 20;
	var strtop = ntop + "px";
	
	document.getElementById("restore_confirm").style.display = "block";
	document.getElementById("restore_confirm").style.position = "absolute";
	document.getElementById("restore_confirm").style.top = strtop;
	document.getElementById("restore_confirm").style.left = "200px";
	document.getElementById("restore_confirm").style.width = "450px";
	document.getElementById("restore_confirm").style.backgroundColor = "#FFF";
	document.getElementById("restore_confirm").style.borderStyle = "solid";
	document.getElementById("restore_confirm").style.borderWidth = "2px";
	document.getElementById("restore_confirm").style.borderColor = "#000";
	document.getElementById("restore_text").innerHTML = page_name;
	document.getElementById("page_to_restore").value = ID;
}

function RestorePage()
{
	var ID = document.getElementById("page_to_restore").value;
	var page_name = document.getElementById("restore_text").innerHTML
	document.getElementById("restore_confirm").style.display = "none";
	var url = "restore_page.php?ID=" + ID + "&page_name=" + page_name;
	window.location = url;
}

function HideRestore()
{
	document.getElementById("restore_confirm").style.display = "none";
}

/////////////////////////////////////////////////////////////////////////////////
function SelectPage(page_name)
{
	var url = "restore_page_select.php?page_name=" + page_name;
	window.location = url;
}
</script>
</head>

<body>
<table width="100%"><tr>
<td><strong>Select the page you want to restore:</strong> </td>
<td>
<select name="selectPage" onChange="SelectPage(this.value);">
<option value="-not selected-">-not selected-</option>
<?php
$query = "SELECT DISTINCT page_name FROM " . BWB_TABLE_PREFIX . "page_data_bkup ORDER BY page_name";
$result = $bwb_dbh->query($query);
while ($row = $result->fetch(PDO::FETCH_ASSOC))
{
	$tmp_page_name = $row['page_name'];
	if ($tmp_page_name == $page_name)
		echo "   <option value='$tmp_page_name' selected='selected'>$tmp_page_name</option>\n";
	else
		echo "   <option value='$tmp_page_name'>$tmp_page_name</option>\n";
}
?>
</select>
</td>
<td><input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=delete';"></td>
<td valign="top">
    <div id="help_button_sm" onClick="OpenHelpWindow();">
    &nbsp;
    </div>
</td>
</tr></table>

<table border="1">
	<tr bgcolor='#CCCCCC'>
		<td>Content</td><td>Last Revised</td><td>Deleted</td><td>Restore</td><td>Remove</td>
	</tr>
<?php
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_bkup WHERE page_name='$page_name' ORDER BY `revised` DESC";
	$result = $bwb_dbh->query($query);
	$i = 1;
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		if ($bgclr == "#DDDDDD")
			$bgclr = "#EEEEEE";
		else
			$bgclr = "#DDDDDD";
			
		$ID = $row["ID"];
		$page_name = $row["page_name"];
		$page_content = $row["page_content"];
		$revised = $row["revised"];
		$deleted = $row["deleted"];
		echo "<tr bgcolor='$bgclr'><td>" . $page_content . "</td>\n";
		echo "<td>$revised</td>\n";
		echo "<td>$deleted</td>\n";
		echo "<td><img src='images/check.png' border=0 alt='Restore' name='Restore' onClick=\"RestoreConfirm('" . $page_name . "', " . $ID . ", " . $i . ");\" /></td>\n";
		echo "<td><img src='images/delete.png' border=0 alt='Delete from History' name='Delete from History' onClick=\"DeleteConfirm('" . $page_name . "', " . $ID . ", " . $i . ");\" /></td></tr>\n";
		
		$i++;
    }
?>
</table>
<p align="center">
<input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=delete';">
</p>

<div id="delete_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td colspan="2">Are your sure you want to <b>delete</b> the <div id="delete_text">&nbsp;</div> page from the backup history?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="delete" id="delete" value="Yes" onClick="DeletePageFromHistory();" /></td>
	<td align="center"><input type="button" name="hide_delete" value="No" onClick="HideDelete();" />
    <input type="hidden" name="page_to_delete" id="page_to_delete" />
    </td>
  </tr>
</table>
</div>

<div id="restore_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td colspan="2">Are your sure you want to restore the <div id="restore_text">&nbsp;</div> page?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="restore" id="restore" value="Yes" onClick="RestorePage();" /></td>
	<td align="center"><input type="button" name="hide_restore" value="No" onClick="HideRestore();" />
    <input type="hidden" name="page_to_restore" id="page_to_restore" />
    </td>
  </tr>
</table>
</div>

</body>
</html>
