<?php
/////////////////////////////////////////////
// Upload Favicon /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/13/2009	ELL
// Modified: 6/22/2010	ELL
// Added file extension checking for icon files to prevent uploading of scripts.
// Revised: 2/10/2012	ELL
//  Added table prefix handling.  Added references to images folder configuration.
// 
//
	include ("check_session.php");

	if (is_uploaded_file($_FILES['favicon']['tmp_name']))
	{		
		$source = $_FILES['favicon']['tmp_name'];
		$file_name = $_FILES['favicon']['name'];
		$file_parts = explode(".", $file_name);
		$file_ext = $file_parts[count($file_parts) - 1];
		if (strcasecmp($file_ext, "ico") != 0)
		{
			echo "Only icon files are allowed to be uploaded, i.e. 'myicon.ico'.  Please click <a href='edit_favicon.php'>here</a> and try again.";
			exit;
		}
		if (BWB_BASE_DIR == '')
			$userfiles = '';
		else
			$userfiles = "/" . BWB_BASE_DIR;
			
		$document_root = getenv('DOCUMENT_ROOT');
		$destination = $document_root . $userfiles . "/" . BWB_IMAGE_DIR . "/favicon.ico";
		if (file_exists($destination))
			rename($destination, $document_root . $userfiles . "/" . BWB_IMAGE_DIR . "/favicon_" . time() . ".ico");
		move_uploaded_file( $source, $destination );
		
		$today = addslashes(date("m/d/Y  H:m:s"));
		
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "head";
		$result = $bwb_dbh->query($query);
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$id = $row["id"];
			$head_content = $row["head_content"];
			$pos = strrpos($head_content, "favicon.ico");
			if ($pos === false)
			{
				if (BWB_WEBPAGE_DIR == '')
					$rel_path = '';
				else
					$rel_path = "../";
					
				$head_content .= "\n\n<link rel='shortcut icon' href='" . $rel_path . BWB_IMAGE_DIR . "/favicon.ico' type='image/x-icon'>\n";
				$head_content = addslashes($head_content);
				$query2 = "UPDATE " . BWB_TABLE_PREFIX . "head SET head_content = '" . $head_content . "', revised='" . $today . "' WHERE id = " . $id;
				$cnt = $bwb_dbh->exec($query2);
			}
		}
		
		header("Location: edit_favicon.php");
	}
	else
		echo "There was an error uploading the file.  Click <a href='edit_favicon.php'>here</a> to try again.";
?>
