<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 4/26/2010	ELL
// Added dictionary attack protection.
// Revised: 10/15/2011	ELL
// Added ability to lockout file manager for restricted users.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 11/22/2012	ELL
// Added handling of passwords sent SHA-256 hashed and added handling of salt.
//
	$userid = $_REQUEST['userid'];
	$password = $_REQUEST['password'];
	$user_table = $_REQUEST['user_table'];
	$AccessLevel = $_REQUEST['AccessLevel'];
	$redirect = $_REQUEST['redirect'];

	include ("../connect/db_connect.php");
	include ("../connect/config.php");
	
	// If alternate go back specified, then use that if any errors.  This is usefule if sending page session expires if back button is used.
	if ($_POST['alt_go_back'])
	{
		$go_back = $_POST['alt_go_back'];
		$delim = "?";
		foreach($_POST as $key => $val)
		{
			$go_back .= $delim . $key . "=" . $val;
			$delim = "&";
		}
	}
	else
		$go_back = "javascript:history.go(-1);";
	
	// Check referers to make sure SPAM bot is not trying to brake in.
	$server_name = $_SERVER['SERVER_NAME'];
	$server_name_www = "www." . $server_name;
	$referers = array($server_name_www, $server_name);
	if (!check_referer($referers))
	{
		$err = "You do not appear to be a valid.  If this is in error, go back and try again.<br />\n<a href='$go_back'>Click here</a> to return to the login page, or use your 'Back' button.";
		$button_label = "OK";
		include("error_msg.php");
		exit;
	}
	
	// If dictionary attack detected, just dump 'em. 
	$attempt_limit = CheckAttempts($userid, $bwb_dbh);
	if ($attempt_limit > 20)
	{
		LogAttempt($userid, $bwb_dbh);
		$err = "You have exceeded the maximum number of login attempts.  Please contact your system administrator.";
		$button_label = "OK";
		include("error_msg.php");
		exit;
	}
	
	if (!isset($user_table) || ($user_table == ""))
	{
		$err = "There is no user table associated with the page you are trying to access.  Please contact your web master.";
		$button_label = "OK";
		include("error_msg.php");
		exit;
	}
		
	$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID` = '$userid'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$num_results = $result->rowCount();
	
	if ($num_results < 1)
	{
		LogAttempt($userid, $bwb_dbh);
		$err = "There is no user by that name.  Click <a href='$go_back'><span onclick='$go_back'><u><b>here</b></u></span></a> to re-enter your user ID and password.";
		$button_label = "OK";
		include("error_msg.php");
		exit;
	}
	
	$Active = $row['Active'];
	if ($Active != 1)
	{
		$err = "The user ID <b>$userid</b> has not been activated yet. Contact the administration to followup on the activation for your account.  Click <a href='$go_back'><span onclick='$go_back'> <u><b>here</b></u></span></a> and try again once account has been activated.";
		$button_label = "OK";
		include("error_msg.php");
		exit;
	}
		
	$access_level = $row["AccessLevel"];
	if (($access_level != $AccessLevel) && ($AccessLevel != "") && (!is_null($AccessLevel)))
	{
		$err = "You don't have the required access level to access this page.   Click <a href='$go_back'><span onclick='$go_back'> <u><b>here</b></u></span></a> to enter a different user ID and password.";
		$button_label = "OK";
		include("error_msg.php");
		exit;
	}
	
	/////////////////////////////////////////////
	//Decrypt password for comparison:
	$enc_text = stripslashes($row["password"]);
	$key = stripslashes($row["UserID"]);
	
	//Convert key to codes and pad as necessary.
	for( $i = 0; $i < (strlen($enc_text))/2; $i++)
	{
		if ($i < strlen($key))
		{
			$c = $key{$i};
			$k[$i] = ord($c);
		}
		else
			$k[$i] = 65 + $i;
	}
	
	//Convert encrypted string to array of HEX uni-character codes.
	$j = 0;
	$q = 0;
	for( $i = 0; $i < strlen($enc_text); $i++)
	{
		if ($j == 0) {
			$c = $enc_text{$i};
			$j++;
		}
		else {
			$c = $c.$enc_text{$i};
			$e[$q] = hexdec($c);
			$q++;
			$j = 0;
		}
		
	}
	
	//Decrypt encrypted string with key to get original data.
	$decrypt_text = "";
	for( $i = 0; $i < (strlen($enc_text))/2; $i++)
   	{
   		$a[$i] = $e[$i] ^ $k[$i];
		$decrypt_text = $decrypt_text. chr($a[$i]);
   	}
	////////////////////////////////////////////////////
	
	$decrypt_text = str_replace(BWB_PUB_SALT, '', $decrypt_text);
	$password_lookup = hash('sha256', $decrypt_text);
	if ($password_lookup == $password)
	{
		session_start();
		$_SESSION['userid'] = $userid;
		$session = md5(session_id());
		$ip = $_SERVER['REMOTE_ADDR'];
		$query = "UPDATE `" . $user_table . "` SET `Session`='$session', `IP`='$ip' WHERE `UserID` = '$userid'";
		$cnt = $bwb_dbh->exec($query);
		CleanAttemptLog($bwb_dbh);
		LogAttempt($userid, $bwb_dbh, 1);
/*		
		if ($access_level == "restricted")
		{
			$query = "SELECT `option_value` FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name`='EnableFileManager'";
			$result = $bwb_dbh->query($query);
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$enable_file_manager = $row["option_value"];
		}
		
		if (($access_level != "restricted") || ($enable_file_manager == 1))
			$_SESSION['enable_file_manager'] = "100";
		else
			$_SESSION['enable_file_manager'] = "0";
*/		
		if (strpos($redirect, '?') > 0)
			$redirect .= "&login_success=1";
		else
			$redirect .= "?login_success=1";
		header("Location: $redirect");
	}
	else
	{
		LogAttempt($userid, $bwb_dbh);
		$err = "Your password has not been confirmed.  Click <a href='$go_back'><span onclick='$go_back'> <u><b>here</b></u></span></a> to re-enter your password.";
		$button_label = "OK";
		include("error_msg.php");
	}
	exit;
	
	//////////////////////////////////////////////////
	function CheckAttempts($userid, $dbh)
	{
		$ip = $_SERVER['REMOTE_ADDR'];
		$current_ts = date('Y-m-d H:i:s', time());
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "login_attempts WHERE (`IP` = '$ip') AND (TIMESTAMPDIFF(MINUTE, `AttemptTimeStamp`, '$current_ts') < 60)";
		$result = $dbh->query($query);
		return ($result->rowCount());
	}
	
	function LogAttempt($userid, $dbh, $success = 0)
	{
		$ip = $_SERVER['REMOTE_ADDR'];
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "login_attempts (`UserID`, `IP`, `Success`) VALUES ('$userid', '$ip', $success)";
		$cnt = $dbh->exec($query);
	}
	
	function CleanAttemptLog($dbh)
	{
		$current_ts = date('Y-m-d H:i:s', time());
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "login_attempts WHERE (TIMESTAMPDIFF(DAY, `AttemptTimeStamp`, '$current_ts') > 7)";
		$cnt = $dbh->exec($query);
	}
	
 /****************************************************************
 * check_referer() breaks up the enviromental variable		*
 * HTTP_REFERER by "/" and then checks to see if the second	*
 * member of the array (from the explode) matches any of the	*
 * domains listed in the $referers array (declaired at top)	*
 ****************************************************************/

function check_referer($referers)
{
	global $errors;
	if (count($referers)) {
		if (getenv('HTTP_REFERER')) {
			$temp = explode('/', getenv('HTTP_REFERER'));
			$found = false;
			while (list(,$stored_referer) = each($referers)) {
				if (eregi('^' . $stored_referer . '$', $temp[2]))
					$found = true;
			}
			if (!$found) {
				$errors[] = '1|You are coming from an unauthorized domain.  Please read the manual section titled &quot;<a href="' . MANUAL . '#setting_up" target="_blank">Setting Up the PHPFormMail Script</a>&quot;.';
				error_log('[PHPFormMail] Illegal Referer. (' . getenv('HTTP_REFERER') . ')', 0);
			}
			return $found;
		} else {
			$errors[] = '0|Sorry, but I cannot figure out who sent you here.  Your browser is not sending an HTTP_REFERER.  This could be caused by a firewall or browser that removes the HTTP_REFERER from each HTTP request you submit.';
			error_log('[PHPFormMail] HTTP_REFERER not defined. Browser: ' . getenv('HTTP_USER_AGENT') . '; Client IP: ' . getenv('REMOTE_ADDR') . '; Request Method: ' . getenv('REQUEST_METHOD') . ';', 0);
			return false;
		}
	} else {
		$errors[] = '1|There are no referers defined.  All submissions will be denied.  Please read the manual section titled &quot;<a href="' . MANUAL . '#setting_up" target="_blank">Setting Up the PHPFormMail Script</a>&quot;.';
		error_log('[PHPFormMail] You have no referers defined.  All submissions will be denied.', 0);
		return false;
	}
}
?>
