<?php
/////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Build string for site.css file /////
// Revised: 9/20/08	Fixed bug with reversed logic for "-not selected-" and "opocity = 100%".
// Revised: 11/12/08  Fixed bug with reversed logic for "-not selected-" for text alignment.	ELL
// Revised: 6/26/09		ELL
// Added heigh, width and background-image styles.
// Revised: 7/30/2009	ELL
// Removed "sub_class_of" as a separate field.
// Revised: 8/2/2009	ELL
// Added explicit defining of "text_decoration: none" so that this can be called out explicitly instead of implied only if <a> tag is being used.
// If omitted and no other text decoration is called for, style will simply not define text decoration.  This will be usefull to keep from breaking
// inherited text decorations from nested classes.
// Added switch to turn off custom styles.
// Added text shadow effects.
// Added feed thru for show/hide class editor.
// Revised: 8/24/2009	ELL
// Removed switch to turn off custom styles as this is now done from main menu.
// Revised: 10/15/2009	ELL
// Added line-height, float, border-style, outline-style, border-collapse and white-space.  Added inline-block to display.
// Renamed z-index, overflow and clip vars to not have prepended "position_".
// Revised: 8/30/2010	ELL
// Fixed bug of position_left, etc not thinking 0 is a valid number.  Used !is_null() function to test instead of simply true or false for $_POST.
// PHP was interpretting 0 as false.
// Revised: 8/31/2010	ELL
// Added !is_null() check to all parameters that default to negative numbers but could have 0 as a possible value.  PHP evaluates 0 as false, so !is_null() 
// check is necessary to keep 0 from being converted to -1 or -1000000.
// Revised: 10/7/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 2/7/2012	ELL
// Added table prefix handling.
// Revised: 3/12/2012	ELL
// Added handling of custom image folder location for background image and list item image.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear and min/max prefix for width and height.
//

	if (BWB_BASE_DIR == "")
		$image = "/" . BWB_IMAGE_DIR . "/";
	else
		$image = "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/";
	
	$css_string = "";
	$query_build_string = "SELECT * FROM `" . BWB_TABLE_PREFIX . $site_css_table . "`";
	$result_build_string = $bwb_dbh->query($query_build_string);
	
	while ($row_bs = $result_build_string->fetch(PDO::FETCH_ASSOC))
	{
		$class = $row_bs["class"];
		if (!is_null($row_bs["use_table_data"])) $use_table_data = $row_bs["use_table_data"];
		else $use_table_data = 0;
		if ($row_bs["font"]) $font = $row_bs["font"];
		else $font = "-not selected-";
		if ($row_bs["font2"]) $font2 = $row_bs["font2"];
		else $font2 = "-not selected-";
		if ($row_bs["font3"]) $font3 = $row_bs["font3"];
		else $font3 = "-not selected-";
		if (!is_null($row_bs["font_size"])) $font_size = $row_bs["font_size"];
		else $font_size = -1;
		if ($row_bs["text_color"]) $text_color = $row_bs["text_color"];
		else $text_color = "-not set-";
		if (!is_null($row_bs["padding_top"])) $padding_top = $row_bs["padding_top"];
		else $padding_top = -1;
		if (!is_null($row_bs["padding_right"])) $padding_right = $row_bs["padding_right"];
		else $padding_right = -1;
		if (!is_null($row_bs["padding_bottom"])) $padding_bottom = $row_bs["padding_bottom"];
		else $padding_bottom = -1;
		if (!is_null($row_bs["padding_left"])) $padding_left = $row_bs["padding_left"];
		else $padding_left = -1;
		if ($row_bs["weight"]) $weight = $row_bs["weight"];
		else $weight = "-not selected-";
		if (!is_null($row_bs["italic"])) $italic = $row_bs["italic"];
		else $italic = 0;
		if (!is_null($row_bs["underline"])) $underline = $row_bs["underline"];
		else $underline = 0;
		if (!is_null($row_bs["overline"])) $overline = $row_bs["overline"];
		else $overline = 0;
		if (!is_null($row_bs["blink"])) $blink = $row_bs["blink"];
		else $blink = 0;
		if ($row_bs["linethrough"]) $linethrough = $row_bs["linethrough"];
		else $linethrough = 0;
		if ($row_bs["font_stretch"]) $font_stretch = $row_bs["font_stretch"];
		else $font_stretch = "-not selected-";
		if ($row_bs["oblique"]) $oblique = $row_bs["oblique"];
		else $oblique = 0;
		if ($row_bs["small_caps"]) $small_caps = $row_bs["small_caps"];
		else $small_caps = 0;
		if ($row_bs["no_text_decoration"]) $no_text_decoration = $row_bs["no_text_decoration"];
		else $no_text_decoration = 0;
		if ($row_bs["shadow"]) $shadow = $row_bs["shadow"];
		else $shadow = 0;
		if ($row_bs["shadow_color"]) $shadow_color = $row_bs["shadow_color"];
		else $shadow_color = "-not set-";
		if ($row_bs["shadow_x_offset"]) $shadow_x_offset = $row_bs["shadow_x_offset"];
		else $shadow_x_offset = 0;
		if ($row_bs["shadow_y_offset"]) $shadow_y_offset = $row_bs["shadow_y_offset"];
		else $shadow_y_offset = 0;
		if ($row_bs["shadow_blur"]) $shadow_blur = $row_bs["shadow_blur"];
		else $shadow_blur = 0;
		if (!is_null($row_bs["line_height"])) $line_height = $row_bs["line_height"];
		else $line_height = -1;
		if ($row_bs["line_height_units"]) $line_height_units = $row_bs["line_height_units"];
		else $line_height_units = 0;
		
		if ($row_bs["align"]) $align = $row_bs["align"];
		else $align = "-not selected-";
		if (!is_null($row_bs["vertical_align"])) $vertical_align = $row_bs["vertical_align"];
		else $vertical_align = "-not selected-";
		if ($row_bs["bkgd_color"]) $bkgd_color = $row_bs["bkgd_color"];
		else $bkgd_color = "-not set-";
		if (!is_null($row_bs["bkgd_opacity"])) $bkgd_opacity = $row_bs["bkgd_opacity"];
		else $bkgd_opacity = -1;
		if (!is_null($row_bs["border"])) $border = $row_bs["border"];
		else $border = -1;
		if ($row_bs["border_color"]) $border_color = $row_bs["border_color"];
		else $border_color = "-not set-";
		if ($row_bs["border_style"]) $border_style = $row_bs["border_style"];
		else $border_style = "-not selected-";
		if ($row_bs["outline_style"]) $outline_style = $row_bs["outline_style"];
		else $outline_style = "-not selected-";
		if ($row_bs["border_collapse"]) $border_collapse = $row_bs["border_collapse"];
		else $border_collapse = "-not selected-";
		if (!is_null($row_bs["border_sides"])) $border_sides = $row_bs["border_sides"];
		else $border_sides = 15;
		
		if (!is_null($row_bs["margin_top"])) $margin_top = $row_bs["margin_top"];
		else $margin_top = -1000000;
		if (!is_null($row_bs["margin_right"])) $margin_right = $row_bs["margin_right"];
		else $margin_right = -1000000;
		if (!is_null($row_bs["margin_left"])) $margin_left = $row_bs["margin_left"];
		else $margin_left = -1000000;
		if (!is_null($row_bs["margin_bottom"])) $margin_bottom = $row_bs["margin_bottom"];
		else $margin_bottom = -1000000;
		if ($row_bs["display"]) $display = $row_bs["display"];
		else $display = "-not selected-";
		if (!is_null($row_bs["width"])) $width = $row_bs["width"];
		else $width = -1;
		if ($row_bs["width_units"]) $width_units = $row_bs["width_units"];
		else $width_units = 0;
		if ($row_bs["width_prefix"]) $width_prefix = $row_bs["width_prefix"];
		else $width_prefix = "-not selected-";
		if (!is_null($row_bs["height"])) $height = $row_bs["height"];
		else $height = -1;
		if ($row_bs["height_units"]) $height_units = $row_bs["height_units"];
		else $height_units = 0;
		if ($row_bs["height_prefix"]) $height_prefix = $row_bs["height_prefix"];
		else $height_prefix = "-not selected-";
		if ($row_bs["background_image"]) $background_image = $row_bs["background_image"];
		else $background_image = "-not selected-";
		if ($row_bs["background_attachment"]) $background_attachment = $row_bs["background_attachment"];
		else $background_attachment = "-not selected-";
		if ($row_bs["background_repeat"]) $background_repeat = $row_bs["background_repeat"];
		else $background_repeat = "-not selected-";
		if ($row_bs["background_position"]) $background_position = $row_bs["background_position"];
		else $background_position = "-not selected-";
		if ($row_bs["background_position_x"]) $background_position_x = $row_bs["background_position_x"];
		else $background_position_x = 0;
		if ($row_bs["background_position_y"]) $background_position_y = $row_bs["background_position_y"];
		else $background_position_y = 0;
		if ($row_bs["background_position_units"]) $background_position_units = $row_bs["background_position_units"];
		else $background_position_units = 0;
		
		if ($row_bs["margin_top_units"]) $margin_top_units = $row_bs["margin_top_units"];
		else $margin_top_units = 0;
		if ($row_bs["margin_top_auto"]) $margin_top_auto = $row_bs["margin_top_auto"];
		else $margin_top_auto = 0;
		if ($row_bs["margin_right_units"]) $margin_right_units = $row_bs["$margin_right_units"];
		else $margin_right_units = 0;
		if ($row_bs["margin_right_auto"]) $margin_right_auto = $row_bs["margin_right_auto"];
		else $margin_right_auto = 0;
		if ($row_bs["margin_left_units"]) $margin_left_units = $row_bs["margin_left_units"];
		else $margin_left_units = 0;
		if ($row_bs["margin_left_auto"]) $margin_left_auto = $row_bs["margin_left_auto"];
		else $margin_left_auto = 0;
		if ($row_bs["margin_bottom_units"]) $margin_bottom_units = $row_bs["margin_bottom_units"];
		else $margin_bottom_units = 0;
		if ($row_bs["margin_bottom_auto"]) $margin_bottom_auto = $row_bs["margin_bottom_auto"];
		else $margin_bottom_auto = 0;
		
		if ($row_bs["position"]) $position = $row_bs["position"];
		else $position = "-not selected-";
		if (!is_null($row_bs["position_left"])) $position_left = $row_bs["position_left"];
		else $position_left = -1000000;
		if ($row_bs["position_left_units"]) $position_left_units = $row_bs["position_left_units"];
		else $position_left_units = 0;
		if (!is_null($row_bs["position_top"])) $position_top = $row_bs["position_top"];
		else $position_top = -1000000;
		if ($row_bs["position_top_units"]) $position_top_units = $row_bs["position_top_units"];
		else $position_top_units = 0;
		if (!is_null($row_bs["position_right"])) $position_right = $row_bs["position_right"];
		else $position_right = -1000000;
		if ($row_bs["position_right_units"]) $position_right_units = $row_bs["position_right_units"];
		else $position_right_units = 0;
		if (!is_null($row_bs["position_bottom"])) $position_bottom = $row_bs["position_bottom"];
		else $position_bottom = -1000000;
		if ($row_bs["position_bottom_units"]) $position_bottom_units = $row_bs["position_bottom_units"];
		else $position_bottom_units = 0;
		if ($row_bs["z_index"]) $z_index = $row_bs["z_index"];
		else $z_index = 0;
		if ($row_bs["overflow"]) $overflow = $row_bs["overflow"];
		else $overflow = "-not selected-";
		if (!is_null($row_bs["clip_top"])) $clip_top = $row_bs["clip_top"];
		else $clip_top = -1;
		if (!is_null($row_bs["clip_top_units"])) $clip_top_units = $row_bs["clip_top_units"];
		else $clip_top_units = -1;
		if (!is_null($row_bs["clip_right"])) $clip_right = $row_bs["clip_right"];
		else $clip_right = -1;
		if (!is_null($row_bs["clip_right_units"])) $clip_right_units = $row_bs["clip_right_units"];
		else $clip_right_units = -1;
		if (!is_null($row_bs["clip_bottom"])) $clip_bottom = $row_bs["clip_bottom"];
		else $clip_bottom = -1;
		if (!is_null($row_bs["clip_bottom_units"])) $clip_bottom_units = $row_bs["clip_bottom_units"];
		else $clip_bottom_units = -1;
		if (!is_null($row_bs["clip_left"])) $clip_left = $row_bs["clip_left"];
		else $clip_left = -1;
		if (!is_null($row_bs["clip_left_units"])) $clip_left_units = $row_bs["clip_left_units"];
		else $clip_left_units = -1;
		if ($row_bs["float"]) $float = $row_bs["float"];
		else $float = "-not selected-";
		if ($row_bs["white_space"]) $white_space = $row_bs["white_space"];
		else $white_space = "-not selected-";
		
		if ($row_bs["list_style_type"]) $list_style_type = $row_bs["list_style_type"];
		else $list_style_type = "-not selected-";
		if ($row_bs["list_style_position"]) $list_style_position = $row_bs["list_style_position"];
		else $list_style_position = "-not selected-";
		if ($row_bs["list_style_image"]) $list_style_image = $row_bs["list_style_image"];
		else $list_style_image = "-not selected-";
		
		if ($row_bs["table_layout"]) $table_layout = $row_bs["table_layout"];
		else $table_layout = "-not selected-";
		if ($row_bs["clear"]) $clear = $row_bs["clear"];
		else $clear = "-not selected-";
		
		if ($row_bs["radius_top_left"]) $radius_top_left = $row_bs["radius_top_left"];
		else $radius_top_left = 0;
		if ($row_bs["radius_top_left_units"]) $radius_top_left_units = $row_bs["radius_top_left_units"];
		else $radius_top_left_units = 0;
		if ($row_bs["radius_top_right"]) $radius_top_right = $row_bs["radius_top_right"];
		else $radius_top_right = 0;
		if ($row_bs["radius_top_right_units"]) $radius_top_right_units = $row_bs["radius_top_right_units"];
		else $radius_top_right_units = 0;
		if ($row_bs["radius_bottom_right"]) $radius_bottom_right = $row_bs["radius_bottom_right"];
		else $radius_bottom_right = 0;
		if ($row_bs["radius_bottom_right_units"]) $radius_bottom_right_units = $row_bs["radius_bottom_right_units"];
		else $radius_bottom_right_units = 0;
		if ($row_bs["radius_bottom_left"]) $radius_bottom_left = $row_bs["radius_bottom_left"];
		else $radius_bottom_left = 0;
		if ($row_bs["radius_bottom_left_units"]) $radius_bottom_left_units = $row_bs["radius_bottom_left_units"];
		else $radius_bottom_left_units = 0;
		
		if (isset($row_bs["box_shadow_horizontal"])) $box_shadow_horizontal = $row_bs["box_shadow_horizontal"];
		else $box_shadow_horizontal = -1000000;
		if (isset($row_bs["box_shadow_vertical"])) $box_shadow_vertical = $row_bs["box_shadow_vertical"];
		else $box_shadow_vertical = -1000000;
		if (isset($row_bs["box_shadow_blur"])) $box_shadow_blur = $row_bs["box_shadow_blur"];
		else $box_shadow_blur = -1;
		if (isset($row_bs["box_shadow_spread"])) $box_shadow_spread = $row_bs["box_shadow_spread"];
		else $box_shadow_spread = -1000000;
		if (isset($row_bs["box_shadow_color"])) $box_shadow_color = $row_bs["box_shadow_color"];
		else $box_shadow_color = "-not set-";
		if (isset($row_bs["box_shadow_inset"])) $box_shadow_inset = $row_bs["box_shadow_inset"];
		else $box_shadow_inset = 0;
		
		//////////////////////////////////////////////////////////////////
	
		if ($use_table_data == 1)
		{
			$css_string .= $class . " {\n";
				
			if ($font != "-not selected-")
			{
				$css_string .= "   font-family: " . $font;
				if ($font2 != "-not selected-")
				{
					$css_string .= ", " . $font2;
					if ($font3 != "-not selected-")
						$css_string .= ", " . $font3;
				}
				$css_string .= ";\n";
			}
				
			if ($font_size != -1)
				$css_string .= "   font-size: " . $font_size . "px;\n";
			if ($text_color != "-not set-")
				$css_string .= "   color: " . $text_color . ";\n";
			if ($padding_top != -1)
				$css_string .= "   padding-top: " . $padding_top . "px;\n";
			if ($padding_right != -1)
				$css_string .= "   padding-right: " . $padding_right . "px;\n";
			if ($padding_bottom != -1)
				$css_string .= "   padding-bottom: " . $padding_bottom . "px;\n";
			if ($padding_left != -1)
				$css_string .= "   padding-left: " . $padding_left . "px;\n";
			if (($weight != "-not selected-") && ($weight != "normal"))
				$css_string .= "   font-weight: " . $weight . ";\n";
				
			if (($italic != 0) || ($oblique != 0))
			{
				$css_string .= "   font-style:";
				if ($italic == 1)
					$css_string .= " italic";
				if ($oblique == 1)
					$css_string .= " oblique";
				$css_string .= ";\n";
			}
			
			if ((($underline != 0) || ($overline != 0) || ($blink != 0) || ($linethrough != 0)) && ($no_text_decoration != 1))
			{
				$css_string .= "   text-decoration:";
				if ($underline == 1)
					$css_string .= " underline";
				if ($overline == 1)
					$css_string .= " overline";
				if ($blink == 1)
					$css_string .= " blink";
				if ($linethrough == 1)
					$css_string .= " linethrough";
				$css_string .= ";\n";
			}
			elseif ($no_text_decoration == 1)
				$css_string .= "   text-decoration: none;\n";
				
			if ($shadow == 1)
			{
				if ($shadow_color != "-not set-")
					$css_string .= "   text-shadow: " . $shadow_color . " " . $shadow_x_offset . "px " . $shadow_y_offset . "px " . $shadow_blur . "px;\n";
				else
					$css_string .= "   text-shadow: " . $shadow_x_offset . "px " . $shadow_y_offset . "px " . $shadow_blur . "px;\n";
			}
			
			if ($line_height != -1)
			{
				if ($line_height_units == 0)
					$css_string .= "   line-height: normal;\n";
				elseif ($line_height_units == 1)		
					$css_string .= "   line-height: " . $line_height . ";\n";
				elseif ($line_height_units == 2)		
					$css_string .= "   line-height: " . $line_height . "px;\n";
				elseif ($line_height_units == 3)		
					$css_string .= "   line-height: " . $line_height . "%;\n";
				elseif ($line_height_units == 4)		
					$css_string .= "   line-height: inherit;\n";
			}
				
			if (($font_stretch != "-not selected-") && ($font_stretch != "normal"))
				$css_string .= "   font-stretch: " . $font_stretch . ";\n";
			if ($small_caps == 1)
				$css_string .= "   font-variant: small-caps;\n";
			if ($align != "-not selected-")
				$css_string .= "   text-align: " . $align . ";\n";
			if (($vertical_align != "-not selected-") && ($vertical_align != "") && isset($vertical_align))
				$css_string .= "   vertical-align: " . $vertical_align . ";\n";
			if ($bkgd_color != "-not set-")
				$css_string .= "   background-color: " . $bkgd_color . ";\n";
				
			if ($bkgd_opacity != -1)
			{
				$css_string .= "   filter: alpha(opacity=" . $bkgd_opacity . ");\n";
				$css_string .= "   -moz-opacity: " . $bkgd_opacity . "%;\n";
				$bkgd_opacity = $bkgd_opacity/100;
				$css_string .= "   opacity: " . $bkgd_opacity . ";\n";
			}
			
			if ($border > -1)
			{
				if ($border_sides == 15) // All sides selected.
				{
					if ($border_style == "-not selected-") $border_style_str = "solid";
					else $border_style_str = $border_style;
					
					if ($border_color != "-not set-")
						$css_string .= "   border: " . $border . "px " . $border_style_str . " " . $border_color . ";\n";
					else
						$css_string .= "   border: " . $border . "px " . $border_style_str . ";\n";
				}
				else  // Not all sides selected.  Look for each side.
				{
					if (($border_sides & 8) == 8)
					{
						$border_side_str = "-top";
						if ($border_style == "-not selected-") $border_style_str = "solid";
						else $border_style_str = $border_style;
						
						if ($border_color != "-not set-")
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str
							. " " . $border_color . ";\n";
						else
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str . ";\n";
					}
					if (($border_sides & 4) == 4)
					{
						$border_side_str = "-bottom";
						if ($border_style == "-not selected-") $border_style_str = "solid";
						else $border_style_str = $border_style;
						
						if ($border_color != "-not set-")
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str
							. " " . $border_color . ";\n";
						else
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str . ";\n";
					}
					if (($border_sides & 2) == 2)
					{
						$border_side_str = "-left";
						if ($border_style == "-not selected-") $border_style_str = "solid";
						else $border_style_str = $border_style;
						
						if ($border_color != "-not set-")
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str
							. " " . $border_color . ";\n";
						else
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str . ";\n";
					}
					if (($border_sides & 1) == 1)
					{
						$border_side_str = "-right";
						if ($border_style == "-not selected-") $border_style_str = "solid";
						else $border_style_str = $border_style;
						
						if ($border_color != "-not set-")
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str
							. " " . $border_color . ";\n";
						else
							$css_string .= "   border" . $border_side_str . ": " . $border . "px " . $border_style_str . ";\n";
					}
				}
			}
			
			if (($border_style != "-not selected-") && ($border < 1))
				$css_string .= "   border-style: " . $border_style . ";\n";
				
			if ($outline_style != "-not selected-")
				$css_string .= "   outline-style: " . $outline_style . ";\n";
			
			if ($border_collapse != "-not selected-")
				$css_string .= "   border-collapse: " . $border_collapse . ";\n";
			
			if ($margin_top_units == 0)
				$units = "px";
			else
				$units = "%";
			if (($margin_top != -1000000) && ($margin_top_auto == 0))
				$css_string .= "   margin-top: " . $margin_top . $units . ";\n";
			elseif ($margin_top_auto == 1)
				$css_string .= "   margin-top: auto;\n";
				
			if ($margin_right_units == 0)
				$units = "px";
			else
				$units = "%";
			if (($margin_right != -1000000) && ($margin_right_auto == 0))
				$css_string .= "   margin-right: " . $margin_right . $units . ";\n";
			elseif ($margin_right_auto == 1)
				$css_string .= "   margin-right: auto;\n";
				
			if ($margin_left_units == 0)
				$units = "px";
			else
				$units = "%";
			if (($margin_left != -1000000) && ($margin_left_auto == 0))
				$css_string .= "   margin-left: " . $margin_left . $units . ";\n";
			elseif ($margin_left_auto == 1)
				$css_string .= "   margin-left: auto;\n";
				
			if ($margin_bottom_units == 0)
				$units = "px";
			else
				$units = "%";
			if (($margin_bottom != -1000000) && ($margin_bottom_auto == 0))
				$css_string .= "   margin-bottom: " . $margin_bottom . $units . ";\n";
			elseif ($margin_bottom_auto == 1)
				$css_string .= "   margin-bottom: auto;\n";
				
				
			if ($position != "-not selected-")
				$css_string .= "   position: " . $position  . ";\n";
				
			if ($position_left_units == 0)
				$units = "px";
			else
				$units = "%";
			if ($position_left != -1000000)
				$css_string .= "   left: " . $position_left . $units . ";\n";
			
			if ($position_top_units == 0)
				$units = "px";
			else
				$units = "%";
			if ($position_top != -1000000)
				$css_string .= "   top: " . $position_top . $units . ";\n";
				
			if ($position_right_units == 0)
				$units = "px";
			else
				$units = "%";
			if ($position_right != -1000000)
				$css_string .= "   right: " . $position_right . $units . ";\n";
				
			if ($position_bottom_units == 0)
				$units = "px";
			else
				$units = "%";
			if ($position_bottom != -1000000)
				$css_string .= "   bottom: " . $position_bottom . $units . ";\n";
				
			if ($z_index != -1000000)
				$css_string .= "   z-index: " . $z_index  . ";\n";
				
			if ($overflow != "-not selected-")
				$css_string .= "   overflow: " . $overflow  . ";\n";
				
			if ($float != "-not selected-")
				$css_string .= "   float: " . $float  . ";\n";
				
			if ($white_space != "-not selected-")
				$css_string .= "   white_space: " . $white_space  . ";\n";
			
			if (($clip_top != -1) && ($clip_right != -1) && ($clip_bottom != -1) && ($clip_left != -1))
			{
				if ($clip_top_units == 0)
					$units_top = "px";
				else
					$units_top = "%";
				if ($clip_right_units == 0)
					$units_right = "px";
				else
					$units_right = "%";
				if ($clip_bottom_units == 0)
					$units_bottom = "px";
				else
					$units_bottom = "%";
				if ($clip_left_units == 0)
					$units_left = "px";
				else
					$units_left = "%";
					
				if ($clip_top != -1)
					$css_string .= "   clip: rect(" . $clip_top . $units_top . "," . $clip_right . $units_right . "," . $clip_bottom . $units_bottom . "," . $clip_left . $units_left . ");\n";
			}
			
			
			if ($display != "-not selected-")
				$css_string .= "   display: " . $display . ";\n";
				
			if ($width != -1)
			{
				if ($width_prefix == "-not selected-")
					$prefix = "";
				else
					$prefix = $width_prefix . "-";
					
				if ($width_units == 0)
					$css_string .= "   " . $prefix . "width: " . $width . "px;\n";
				else
					$css_string .= "   " .  $prefix . "width: " . $width . "%;\n";
			}
			if ($height != -1)
			{
				if ($height_prefix == "-not selected-")
					$prefix = "";
				else
					$prefix = $height_prefix . "-";
					
				if ($height_units == 0)
					$css_string .= "   " . $prefix . "height: " . $height . "px;\n";
				else
					$css_string .= "   " . $prefix . "height: " . $height . "%;\n";
			}
			
			if (($background_image != "-not set-") && ($background_image != "-not selected-") && ($background_image != ""))
				$css_string .= "   background-image: url('" . $image . $background_image . "');\n";
			if (($background_attachment != "-not selected-") && ($background_attachment != ""))
				$css_string .= "   background-attachment: " . $background_attachment . ";\n";
			if (($background_repeat != "-not selected-") && ($background_repeat != ""))
				$css_string .= "   background-repeat: " . $background_repeat . ";\n";
			if (($background_position != "-not selected-") && ($background_position != "") && ($background_position != "xpos ypos"))
				$css_string .= "   background-position: " . $background_position . ";\n";
			elseif ($background_position == "xpos ypos")
			{
				if ($background_position_units == 0)
					$css_string .= "   background-position: " . $background_position_x . "px " . $background_position_y . "px;\n";
				else
					$css_string .= "   background-position: " . $background_position_x . "% " . $background_position_y . "%;\n";
			}
			
			if ($list_style_type != "-not selected-")
				$css_string .= "   list-style-type: " . $list_style_type . ";\n";
			if ($list_style_position != "-not selected-")
				$css_string .= "   list-style-position: " . $list_style_position . ";\n";
			if (($list_style_image != "-not set-") && ($list_style_image != "-not selected-") && ($list_style_image != ""))
				$css_string .= "   list-style-image: url('" . $image . $list_style_image . "');\n";
				
			if ($table_layout != "-not selected-")
				$css_string .= "   table-layout: " . $table_layout . ";\n";
			if ($clear != "-not selected-")
				$css_string .= "   clear: " . $clear . ";\n";
				
			if ($radius_top_left > 0)
			{
				if ($radius_top_left_units == 0)
					$css_string .= "   border-top-left-radius: " . $radius_top_left . "px;\n";
				else
					$css_string .= "   border-top-left-radius: " . $radius_top_left . "%;\n";
			}
			if ($radius_top_right > 0)
			{
				if ($radius_top_right_units == 0)
					$css_string .= "   border-top-right-radius: " . $radius_top_right . "px;\n";
				else
					$css_string .= "   border-top-right-radius: " . $radius_top_right . "%;\n";
			}
			if ($radius_bottom_right > 0)
			{
				if ($radius_bottom_right_units == 0)
					$css_string .= "   border-bottom-right-radius: " . $radius_bottom_right . "px;\n";
				else
					$css_string .= "   border-bottom-right-radius: " . $radius_bottom_right . "%;\n";
			}
			if ($radius_bottom_left > 0)
			{
				if ($radius_bottom_left_units == 0)
					$css_string .= "   border-bottom-left-radius: " . $radius_bottom_left . "px;\n";
				else
					$css_string .= "   border-bottom-left-radius: " . $radius_bottom_left . "%;\n";
			}
			
			if ($box_shadow_horizontal != -1000000)
			{
				$css_string .= "   box-shadow: " . $box_shadow_horizontal . "px " . $box_shadow_vertical . "px";
				if ($box_shadow_blur > -1)
					$css_string .= " " . $box_shadow_blur . "px";
				if ($box_shadow_spread != -1000000)
					$css_string .= " " . $box_shadow_spread . "px";
				if (isset($box_shadow_color) && ($box_shadow_color != "-not set-"))
					$css_string .= " " . $box_shadow_color;
				if ($box_shadow_inset == 1)
					$css_string .= " inset";
				$css_string .= ";\n";
			}
			
			$css_string .= "}\n\n";
		} // end if use table data for tag
	}	// end while
	
//	echo $css_string;
	
	if ($site_css_table == "site_css")
	{
		$query_build_string = "SELECT * FROM `" . BWB_TABLE_PREFIX . $custom_site_css_table . "`";	
		$result_build_string = $bwb_dbh->query($query_build_string);
		$row_bs = $result_build_string->fetch(PDO::FETCH_ASSOC);
		if ($row_bs["custom_css"])
			$css_string .= $row_bs["custom_css"];
	}
?>