////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/10/2013	ELL
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear, min/max prefix for width and height and sticky footer setup button.

function popupcolorpicker(form_name, field_name)
{
	var start_color = document.getElementById(field_name).value;
	if (start_color == "")
		start_color = "-not set-";
	else
		start_color = start_color.replace("#", "");
	
	var URL = "colorpicker.php?form_name=" + form_name + "&field_name=" + field_name + "&source_page=edit_css.php&start_color=" + start_color;
	
	window.open (URL, "colorpicker", "alwaysRaised=0,dependent=1,menubar=0,resizable=0,width=450,height=350,scrollbars=0,location=0");
}

function enable_disable_controls(ShowMessage)
{	
	if (document.getElementById("use_table_data").checked == true)
	{
		document.getElementById("font").disabled = false;
		document.getElementById("font2").disabled = false;
		document.getElementById("font3").disabled = false;
		document.getElementById("font_size").disabled = false;
		document.getElementById("text_color").disabled = false;
		document.getElementById("align").disabled = false;
		document.getElementById("vertical_align").disabled = false;
		document.getElementById("display").disabled = false;
		document.getElementById("weight").disabled = false;
		document.getElementById("font_stretch").disabled = false;
		document.getElementById("italic").disabled = false;
		document.getElementById("underline").disabled = false;
		document.getElementById("overline").disabled = false;
		document.getElementById("blink").disabled = false;
		document.getElementById("linethrough").disabled = false;
		document.getElementById("oblique").disabled = false;
		document.getElementById("small_caps").disabled = false;
		document.getElementById("no_text_decoration").disabled = false;
		document.getElementById("shadow").disabled = false;
		document.getElementById("line_height").disabled = false;
		document.getElementById("line_height_units").disabled = false;
		
		document.getElementById("bkgd_color").disabled = false;
		document.getElementById("bkgd_opacity").disabled = false;
		document.getElementById("border").disabled = false;
		document.getElementById("border_color").disabled = false;
		document.getElementById("border_style").disabled = false;
		document.getElementById("outline_style").disabled = false;
		document.getElementById("border_collapse").disabled = false;
		document.getElementById("border_top").disabled = false;
		document.getElementById("border_bottom").disabled = false;
		document.getElementById("border_left").disabled = false;
		document.getElementById("border_right").disabled = false;
		document.getElementById("padding_top").disabled = false;
		document.getElementById("padding_right").disabled = false;
		document.getElementById("padding_bottom").disabled = false;
		document.getElementById("padding_left").disabled = false;

		document.getElementById("width").disabled = false;
		document.getElementById("width_units").disabled = false;
		document.getElementById("width_prefix").disabled = false;
		document.getElementById("height").disabled = false;
		document.getElementById("height_units").disabled = false;
		document.getElementById("height_prefix").disabled = false;
		document.getElementById("background_image_select").disabled = false;
		document.getElementById("background_image").disabled = false;
		document.getElementById("browse_image").disabled = false;
		document.getElementById("upload_image").disabled = false;
		document.getElementById("background_attachment").disabled = false;
		document.getElementById("background_repeat").disabled = false;
		document.getElementById("background_position").disabled = false;
		document.getElementById("background_position_x").disabled = false;
		document.getElementById("background_position_y").disabled = false;
		document.getElementById("background_position_units").disabled = false;
		
		document.getElementById("margin_top_auto").disabled = false;
		document.getElementById("margin_right_auto").disabled = false;
		document.getElementById("margin_left_auto").disabled = false;
		document.getElementById("margin_bottom_auto").disabled = false;
		
		document.getElementById("position").disabled = false;
		document.getElementById("position_left").disabled = false;
		document.getElementById("position_left_units").disabled = false;
		document.getElementById("position_top").disabled = false;
		document.getElementById("position_top_units").disabled = false;
		document.getElementById("position_right").disabled = false;
		document.getElementById("position_right_units").disabled = false;
		document.getElementById("position_bottom").disabled = false;
		document.getElementById("position_bottom_units").disabled = false;
		document.getElementById("z_index").disabled = false;
		document.getElementById("overflow").disabled = false;
		document.getElementById("clip_top").disabled = false;
		document.getElementById("clip_top_units").disabled = false;
		document.getElementById("clip_right").disabled = false;
		document.getElementById("clip_right_units").disabled = false;
		document.getElementById("clip_bottom").disabled = false;
		document.getElementById("clip_bottom_units").disabled = false;
		document.getElementById("clip_left").disabled = false;
		document.getElementById("clip_left_units").disabled = false;
		document.getElementById("float").disabled = false;
		document.getElementById("white_space").disabled = false;
		
		document.getElementById("list_style_type").disabled = false;
		document.getElementById("list_style_position").disabled = false;
		document.getElementById("list_image_select").disabled = false;
		document.getElementById("list_style_image").disabled = false;
		
		document.getElementById("table_layout").disabled = false;
		document.getElementById("clear").disabled = false;
		
		document.getElementById("radius_top_left").disabled = false;
		document.getElementById("radius_top_left_units").disabled = false;
		document.getElementById("radius_top_right").disabled = false;
		document.getElementById("radius_top_right_units").disabled = false;
		document.getElementById("radius_bottom_right").disabled = false;
		document.getElementById("radius_bottom_right_units").disabled = false;
		document.getElementById("radius_bottom_left").disabled = false;
		document.getElementById("radius_bottom_left_units").disabled = false;
		
		document.getElementById("box_shadow_horizontal").disabled = false;
		document.getElementById("box_shadow_vertical").disabled = false;
		document.getElementById("box_shadow_blur").disabled = false;
		document.getElementById("box_shadow_spread").disabled = false;
		document.getElementById("box_shadow_color").disabled = false;
		document.getElementById("box_shadow_inset").disabled = false;
		
		enable_disable_shadow();
		margin_auto_clicked("top");
		margin_auto_clicked("bottom");
		margin_auto_clicked("left");
		margin_auto_clicked("right");
	}
	else
	{
		document.getElementById("font").disabled = true;
		document.getElementById("font2").disabled = true;
		document.getElementById("font3").disabled = true;
		document.getElementById("font_size").disabled = true;
		document.getElementById("text_color").disabled = true;
		document.getElementById("align").disabled = true;
		document.getElementById("vertical_align").disabled = true;
		document.getElementById("display").disabled = true;
		document.getElementById("weight").disabled = true;
		document.getElementById("font_stretch").disabled = true;
		document.getElementById("italic").disabled = true;
		document.getElementById("underline").disabled = true;
		document.getElementById("overline").disabled = true;
		document.getElementById("blink").disabled = true;
		document.getElementById("linethrough").disabled = true;
		document.getElementById("oblique").disabled = true;
		document.getElementById("small_caps").disabled = true;
		document.getElementById("no_text_decoration").disabled = true;
		document.getElementById("shadow").disabled = true;
		document.getElementById("shadow_color").disabled = true;
		document.getElementById("shadow_x_offset").disabled = true;
		document.getElementById("shadow_y_offset").disabled = true;
		document.getElementById("shadow_blur").disabled = true;
		document.getElementById("line_height").disabled = true;
		document.getElementById("line_height_units").disabled = true;
		
		document.getElementById("bkgd_color").disabled = true;
		document.getElementById("bkgd_opacity").disabled = true;
		document.getElementById("border").disabled = true;
		document.getElementById("border_color").disabled = true;
		document.getElementById("border_style").disabled = true;
		document.getElementById("outline_style").disabled = true;
		document.getElementById("border_collapse").disabled = true;
		document.getElementById("border_top").disabled = true;
		document.getElementById("border_bottom").disabled = true;
		document.getElementById("border_left").disabled = true;
		document.getElementById("border_right").disabled = true;
		document.getElementById("padding_top").disabled = true;
		document.getElementById("padding_right").disabled = true;
		document.getElementById("padding_bottom").disabled = true;
		document.getElementById("padding_left").disabled = true;
		
		document.getElementById("margin_top").disabled = true;
		document.getElementById("margin_right").disabled = true;
		document.getElementById("margin_left").disabled = true;
		document.getElementById("margin_bottom").disabled = true;
		document.getElementById("width").disabled = true;
		document.getElementById("width_units").disabled = true;
		document.getElementById("width_prefix").disabled = true;
		document.getElementById("height").disabled = true;
		document.getElementById("height_units").disabled = true;
		document.getElementById("height_prefix").disabled = true;
		document.getElementById("background_image_select").disabled = true;
		document.getElementById("background_image").disabled = true;
		document.getElementById("browse_image").disabled = true;
		document.getElementById("upload_image").disabled = true;
		document.getElementById("background_attachment").disabled = true;
		document.getElementById("background_repeat").disabled = true;
		document.getElementById("background_position").disabled = true;
		document.getElementById("background_position_x").disabled = true;
		document.getElementById("background_position_y").disabled = true;
		document.getElementById("background_position_units").disabled = true;
		
		document.getElementById("margin_top_units").disabled = true;
		document.getElementById("margin_top_auto").disabled = true;
		document.getElementById("margin_right_units").disabled = true;
		document.getElementById("margin_right_auto").disabled = true;
		document.getElementById("margin_left_units").disabled = true;
		document.getElementById("margin_left_auto").disabled = true;
		document.getElementById("margin_bottom_units").disabled = true;
		document.getElementById("margin_bottom_auto").disabled = true;
		
		document.getElementById("position").disabled = true;
		document.getElementById("position_left").disabled = true;
		document.getElementById("position_left_units").disabled = true;
		document.getElementById("position_top").disabled = true;
		document.getElementById("position_top_units").disabled = true;
		document.getElementById("position_right").disabled = true;
		document.getElementById("position_right_units").disabled = true;
		document.getElementById("position_bottom").disabled = true;
		document.getElementById("position_bottom_units").disabled = true;
		document.getElementById("z_index").disabled = true;
		document.getElementById("overflow").disabled = true;
		document.getElementById("clip_top").disabled = true;
		document.getElementById("clip_top_units").disabled = true;
		document.getElementById("clip_right").disabled = true;
		document.getElementById("clip_right_units").disabled = true;
		document.getElementById("clip_bottom").disabled = true;
		document.getElementById("clip_bottom_units").disabled = true;
		document.getElementById("clip_left").disabled = true;
		document.getElementById("clip_left_units").disabled = true;
		document.getElementById("float").disabled = true;
		document.getElementById("white_space").disabled = true;
		
		document.getElementById("list_style_type").disabled = true;
		document.getElementById("list_style_position").disabled = true;
		document.getElementById("list_image_select").disabled = true;
		document.getElementById("list_style_image").disabled = true;
		
		document.getElementById("table_layout").disabled = true;
		document.getElementById("clear").disabled = true;
		
		document.getElementById("radius_top_left").disabled = true;
		document.getElementById("radius_top_left_units").disabled = true;
		document.getElementById("radius_top_right").disabled = true;
		document.getElementById("radius_top_right_units").disabled = true;
		document.getElementById("radius_bottom_right").disabled = true;
		document.getElementById("radius_bottom_right_units").disabled = true;
		document.getElementById("radius_bottom_left").disabled = true;
		document.getElementById("radius_bottom_left_units").disabled = true;
		
		document.getElementById("box_shadow_horizontal").disabled = true;
		document.getElementById("box_shadow_vertical").disabled = true;
		document.getElementById("box_shadow_blur").disabled = true;
		document.getElementById("box_shadow_spread").disabled = true;
		document.getElementById("box_shadow_color").disabled = true;
		document.getElementById("box_shadow_inset").disabled = true;
		
	}
	if (ShowMessage == 1)
	{
		ShowStatusMsg();
		ShowStatusMsgCloseBtn();
		document.getElementById("StatusMsg").innerHTML = "Click 'Update' to commit changes.";
	}
}

function update_background_image()
{
	var background_image = document.getElementById("background_image_select").value;
	document.getElementById("background_image").value = background_image;
}

function update_list_image()
{
	var list_image = document.getElementById("list_image_select").value;
	document.getElementById("list_style_image").value = list_image;
}

function text_decoration_none_clicked()
{
	if (document.getElementById("no_text_decoration").checked == true)
	{
		document.getElementById("underline").checked = false;
		document.getElementById("overline").checked = false;
		document.getElementById("blink").checked = false;
		document.getElementById("linethrough").checked = false;
	}
}

function margin_auto_clicked(side)
{
	var margin_auto_control_name = "margin_" + side + "_auto";
	var margin_control_name = "margin_" + side;
	var margin_units_control_name = "margin_" + side + "_units";
	
	if (document.getElementById(margin_auto_control_name).checked == true)
	{
		document.getElementById(margin_control_name).disabled = true;
		document.getElementById(margin_units_control_name).disabled = true;
	}
	else
	{
		document.getElementById(margin_control_name).disabled = false;
		document.getElementById(margin_units_control_name).disabled = false;
	}
}

function enable_disable_shadow()
{
	if (document.getElementById("shadow").checked == true)
	{
		document.getElementById("shadow_color").disabled = false;
		document.getElementById("shadow_x_offset").disabled = false;
		document.getElementById("shadow_y_offset").disabled = false;
		document.getElementById("shadow_blur").disabled = false;
	}
	else
	{
		document.getElementById("shadow_color").disabled = true;
		document.getElementById("shadow_x_offset").disabled = true;
		document.getElementById("shadow_y_offset").disabled = true;
		document.getElementById("shadow_blur").disabled = true;
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, StatusMsg_control_name)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
				document.getElementById(StatusMsg_control_name).innerHTML = "Update complete: " + xmlhttp.responseText;
			else
				document.getElementById(StatusMsg_control_name).innerHTML = "Update complete";
			var ClearMessageString = "ClearMessage('" + StatusMsg_control_name + "');";
			mTimer = setTimeout(ClearMessageString, 2000);
		}
		else if (xmlhttp.readyState==1)
			document.getElementById(StatusMsg_control_name).innerHTML = "Update ready to send...";
		else if (xmlhttp.readyState==2)
			document.getElementById(StatusMsg_control_name).innerHTML = "Update sent";
		else if (xmlhttp.readyState==3)
			document.getElementById(StatusMsg_control_name).innerHTML = "Updating...";
	}
	return (xmlhttp);
}

function ClearMessage(StatusMsg_control_name)
{
	HideStatusMsg();
	document.getElementById(StatusMsg_control_name).innerHTML = " ";
	clearInterval(mTimer);
}

////////////////////////////////////////////////////////////////////////////////////
function LoadCenterParams()
{
	alert("We will now load styles with settings that will cause your website to appear centered with a fixed width.");
	
	var params = "";
	
	if (document.getElementById("StatusMsg").innerHTML == " ")
	{
		ShowStatusMsg();
		document.getElementById("StatusMsg").innerHTML = "Starting update...";
	}
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg");

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=body";
		params = params + "&use_table_data=1";
		params = params + "&align=center";
		params = params + "&bkgd_color=#111111";
		
		xmlhttp.send(params);
	}
	
	var xmlhttp2;
	xmlhttp2 = getXmlHttpRequestObject();
	if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
	{
		xmlhttp2.open("POST","save_css.php",true);
		xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp2 = UpdateMessage(xmlhttp2, "StatusMsg");

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=#wrap";
		params = params + "&use_table_data=1";
		params = params + "&align=left";
		params = params + "&bkgd_color=#FFFFFF";
		params = params + "&position=relative";
		params = params + "&width=900";
		params = params + "&width_units=0";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&margin_left_auto=1";
		params = params + "&margin_right_auto=1";
		params = params + "&margin_top=-8";
		params = params + "&margin_top_units=0";
		
		xmlhttp2.send(params);
	}
		
	alert("Your site has been centered.  You may also want to revise the 'body' width, the 'body' background color, and the '#wrap' backgound color to your needs.");
	document.getElementById("StatusMsg").innerHTML = "Your site has been centered.  You may want to revise the 'body' width, the 'body' background color, and the '#wrap' backgound color to your needs.";
	ShowStatusMsgCloseBtn();
}

//////////////////////////////////////////////////////////////////////////////////////
function LoadStickyFooterParams()
{
	alert("We will now load styles with settings that will cause the footer of your web pages to 'stick' to the bottom of your browser window.");
	
	var params = "";
	
	if (document.getElementById("StatusMsg").innerHTML == " ")
	{
		ShowStatusMsg();
		document.getElementById("StatusMsg").innerHTML = "Starting update...";
	}
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "StatusMsg");

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=body";
		params = params + "&use_table_data=1";
		params = params + "&height=100";
		params = params + "&height_units=1";
		
		xmlhttp.send(params);
	}
	
	var xmlhttp2;
	xmlhttp2 = getXmlHttpRequestObject();
	if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
	{
		xmlhttp2.open("POST","save_css.php",true);
		xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp2 = UpdateMessage(xmlhttp2, "StatusMsg");

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=#wrap";
		params = params + "&use_table_data=1";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&height_prefix=min";
		params = params + "&overflow=auto";
		params = params + "&padding_bottom=50";
		params = params + "&padding_bottom_units=0";
		params = params + "&position=relative";
		
		xmlhttp2.send(params);
	}
	
	var xmlhttp3;
	xmlhttp3 = getXmlHttpRequestObject();
	if (xmlhttp3.readyState == 4 || xmlhttp3.readyState == 0)
	{
		xmlhttp3.open("POST","save_css.php",true);
		xmlhttp3.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp3 = UpdateMessage(xmlhttp3, "StatusMsg");

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=html";
		params = params + "&use_table_data=1";
		params = params + "&height=94";
		params = params + "&height_units=1";
		
		xmlhttp3.send(params);
	}
	
	var xmlhttp4;
	xmlhttp4 = getXmlHttpRequestObject();
	if (xmlhttp4.readyState == 4 || xmlhttp4.readyState == 0)
	{
		xmlhttp4.open("POST","save_css.php",true);
		xmlhttp4.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp4 = UpdateMessage(xmlhttp4, "StatusMsg");

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=footer";
		params = params + "&use_table_data=1";
		params = params + "&width=100";
		params = params + "&width_units=1";
		params = params + "&height=50";
		params = params + "&height_units=0";
		params = params + "&margin_top=-50";
		params = params + "&margin_top_units=0";
		params = params + "&margin_bottom_auto=1";
		params = params + "&position=relative";
		params = params + "&position_bottom=0";
		params = params + "&position_bottom_units=0";
		params = params + "&clear=both";
		params = params + "&bkgd_color=#DDDDDD";
		params = params + "&align=center";
		
		xmlhttp4.send(params);
	}
		
	alert("Your footer will now stick to the bottom of the browser window.  You may also want to revise the 'footer' height and the background color to your needs. Be sure to set the footer's margin top to the same but negative of the footer's height.");
	document.getElementById("StatusMsg").innerHTML = "Your footer will now stick to the bottom of the browser window.  You may also want to revise the 'footer' height and the background color to your needs. Be sure to set the footer's margin top to the same but negative of the footer's height.";
	ShowStatusMsgCloseBtn();
}

//////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_css", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function ShowStatusMsg()
{
	var ntop;
	ntop = tempY;
	
	if (ntop < 500)
		ntop = ntop - 20;
	else
		ntop = ntop - 40;
	var strtop = ntop + "px";
	
	document.getElementById("popup_msg_div").style.display = "block";
	document.getElementById("popup_msg_div").style.position = "absolute";
	document.getElementById("popup_msg_div").style.top = strtop;
	document.getElementById("popup_msg_div").style.left = "500px";
}

function ShowStatusMsgCloseBtn()
{
	document.getElementById("popup_msg_close_btn").style.display = "inline";
}

function HideStatusMsg()
{
	document.getElementById("popup_msg_div").style.display = "none";
	document.getElementById("popup_msg_close_btn").style.display = "none";
	document.getElementById("StatusMsg").innerHTML = " ";
}