<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/18/09	ELL
// Revised: 11/11/09	ELL
// Added options for proportional item widths.
// Modified: 10/7/2010		ELL
// Added text align.
// Modified: 2/4/2012	ELL
// Added selection for having sub menus collapse and expand.  Default is to collapse and expand.  New option is to show always expanded.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 6/19/2013	ELL
// Added separate text alignment for sub menus.
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
		
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<script language="javascript" type="text/javascript" >
function SelectMenu(menu)
{
	var url = "edit_css_menu_params.php?menu=" + menu;
	window.location.href = url;
}

function  LoadOrientationDefaults(orientation)
{
	if (orientation == "vertical")
	{
		document.getElementById("menu_width").value = -1;
		document.getElementById("sub_level_offset_top").value = -5;
		document.getElementById("sub_level_offset_left").value = 80;	
	}
	else if (orientation == "horizontal_fixed_width")
	{
		document.getElementById("menu_width").value = -1;
		document.getElementById("sub_level_offset_top").value = 0;
		document.getElementById("sub_level_offset_left").value = 20;
	}
	else if (orientation == "horizontal_variable_width")
	{
		document.getElementById("menu_width").value = 100;
		document.getElementById("menu_width_units").value = 1;
		document.getElementById("sub_level_offset_top").value = 0;
		document.getElementById("sub_level_offset_left").value = 20;
	}
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_css_menu_params", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}
</script>
</head>

<body>

<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td class="bold" width="40%">
Select a menu to add items to:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
?>
</select>
</td>
<td>
<span class="title">CSS Menu Parameters Quick-Setup Editor</span>
</td>
<td align="left">
          <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=menu';" />
		</td>
<td align="right">
<div id="help_button_sm" onClick="OpenHelpWindow();">
&nbsp;
</div>
</td></tr>
</table>

<?php
	if (($menu == "-not selected-") || ($menu == ""))
	{
		echo "Please select a menu to edit menu items.";
		exit;
	}
	else
		$suffix = substr($menu, 4);
	
	$menu_source  = "menu" . $suffix . "_items" ;
	
	$menu_css_table = $menu . "_css" ;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["display"] == "inline")
		$orientation = "horizontal";
	else
		$orientation = "vertical";
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ">li'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["display"] == "table-cell")
		$orientation = "horizontal";
	else
		$orientation = "vertical";
	if (!is_null($row["width"]))
		$top_level_item_width = $row["width"];
	else
		$top_level_item_width = -1;
	$top_level_item_width_units = $row["width_units"];
	if (!is_null($row["line_height"]))
		$top_level_item_height = $row["line_height"];
	else
		$top_level_item_height = -1;
	$top_level_item_height_units = $row["line_height_units"];
	
	if (!is_null($row["padding_top"]))
		$top_level_padding_top = $row["padding_top"];
	else
		$top_level_padding_top = 2;
	if (!is_null($row["padding_right"]))
		$top_level_padding_right = $row["padding_right"];
	else
		$top_level_padding_right = 8;
	if (!is_null($row["padding_bottom"]))
		$top_level_padding_bottom = $row["padding_bottom"];
	else
		$top_level_padding_bottom = 2;
	if (!is_null($row["padding_left"]))
		$top_level_padding_left = $row["padding_left"];
	else
		$top_level_padding_left = 8;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li>ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["margin_top"]))
		$sub_level_offset_top = $row["margin_top"];
	elseif ($orientation == "horizontal")
		$sub_level_offset_top = 0;
	else
		$sub_level_offset_top = 20;
	if (!is_null($row["margin_left"]))
		$sub_level_offset_left = $row["margin_left"];
	elseif ($orientation == "horizontal")
		$sub_level_offset_left = 140;
	else
		$sub_level_offset_left = 20;
		
	if (!is_null($row["width"]))
		$sub_level_item_width = $row["width"];
	else
		$sub_level_item_width = 140;
	$sub_level_item_width_units = $row["width_units"];
	if (!is_null($row["line_height"]))
		$sub_level_item_height = $row["line_height"];
	else
		$sub_level_item_height = -1;
	$sub_level_item_height_units = $row["line_height_units"];
	
	if (!is_null($row["display"]))
	{
		if ($row["display"] == "none")
			$sub_level_collapse = true;
		else
			$sub_level_collapse = false;
	}
	else
		$sub_level_collapse = true;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.nav" . $suffix . " ul li a'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["padding_top"]))
		$sub_level_padding_top = $row["padding_top"];
	else
		$sub_level_padding_top = 2;
	if (!is_null($row["padding_right"]))
		$sub_level_padding_right = $row["padding_right"];
	else
		$sub_level_padding_right = 10;
	if (!is_null($row["padding_bottom"]))
		$sub_level_padding_bottom = $row["padding_bottom"];
	else
		$sub_level_padding_bottom = 2;
	if (!is_null($row["padding_top"]))
		$sub_level_padding_left = $row["padding_left"];
	else
		$sub_level_padding_left = 10;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (($row["table_layout"] == "fixed") && ($orientation == "horizontal"))
		$orientation = "horizontal_variable_width";
	elseif ($orientation == "horizontal")
		$orientation = "horizontal_fixed_width";
	if (!is_null($row["width"]))
		$menu_width = $row["width"];
	else
		$menu_width = 100;
	$menu_width_units = $row["width_units"];
	$top_level_text_align = $row["align"];
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.menu_div" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["position_top"]))
		$menu_top = $row["position_top"];
	else
		$menu_top = 0;
	if (!is_null($row["position_left"]))
		$menu_left = $row["position_left"];
	else
		$menu_left = 0;
	if (!is_null($row["position"]))
		$position = $row["position"];
	else
		$position = "absolute";
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$sub_level_text_align = $row["align"];
		
	/////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '" . $menu . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$proportional_width_top = $row["proportional"];
	$proportional_width_sub = $row["proportional_sub"];
?>

<form name="frm_menu_params" action="save_css_menu_params.php" method="post">
<table width="90%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
		<table width="100%" border="0" cellspacing="1" cellpadding="1">
        <tr>
        	<td class="bold" colspan="9">Menu Layout and Origin (from upper left of page) </td>
        </tr>
        <tr>
            <td>
            Orientation:<br>
				<label>
              <input type="radio" name="OrientationGroup" value="vertical" id="OrientationGroup_0" <?php if ($orientation == "vertical") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('vertical');">
              Vertical</label>
              <br>
              <label>
                <input type="radio" name="OrientationGroup" value="horizontal_fixed_width" id="OrientationGroup_1" <?php if ($orientation == "horizontal_fixed_width") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('horizontal_fixed_width');">
                Horizontal (fixed width)</label>
              <br>
              <label>
                <input type="radio" name="OrientationGroup" value="horizontal_variable_width" id="OrientationGroup_2" <?php if ($orientation == "horizontal_variable_width") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('horizontal_variable_width');">
              Horizontal (variable width)</label>
            </td>
            <td width="20%">
            Menu Location:<br>
				<label>
              <input type="radio" name="PositionGroup" value="absolute" id="PositionGroup_0" <?php if ($position != "relative") echo "checked='checked'"; ?> />
              Top or Left</label>
				<br>
              <label>
                <input type="radio" name="PositionGroup" value="relative" id="PositionGroup_1" <?php if ($position == "relative") echo "checked='checked'"; ?> />
                Bottom or Right</label><br>
                <span class="small_message">Note: Absolute positioning used for top or left and relative positioning used for bottom or right.</span>
            </td>
            <td>
            Offset from Top:<br>
            <input name="menu_top" type="text" id="menu_top" value="<?php echo $menu_top; ?>" size="10" />
            </td>
            <td>
            Offset from Left:<br>
            <input name="menu_left" type="text" id="menu_left" value="<?php echo $menu_left; ?>" size="10" />
            </td>
            <td>
            Menu Width:<br>
            <input name="menu_width" type="text" id="menu_width" value="<?php echo $menu_width; ?>" size="10" />
              <select name="menu_width_units" id="menu_width_units">
                <option value="0" <?php if ($menu_width_units == 0) echo "selected='selected'"; ?>>px</option>
                <option value="1" <?php if ($menu_width_units == 1) echo "selected='selected'"; ?>>%</option>
              </select>
              </td>
      </tr>
      </table>
      
      <table width="100%" border="0" cellspacing="1" cellpadding="1">
	  <tr>
	    <td class="bold">&nbsp;</td>
	    </tr>
      </table>
      
       </td>
      </tr>
      <tr>
      <td>
      
      <table width="100%" border="0">
	  <tr>
		 <td class="bold">Menu Item Size and Padding</td>
	  </tr>
	  <tr>
      <td>
      <table width="100%" border="0">
      <tr>
		<td align="right">Width: </td>
		<td>
          <input name="top_level_item_width" type="text" id="top_level_item_width" value="<?php echo $top_level_item_width; ?>" size="10" />
          
		  <select name="top_level_item_width_units" id="top_level_item_width_units">
		   <option value="0" <?php if ($top_level_item_width_units == 0) echo "selected='selected'"; ?>>px</option>
           <option value="1" <?php if ($top_level_item_width_units == 1) echo "selected='selected'"; ?>>%</option>
		  </select>
 
        	<input name="proportional_width_top" type="checkbox" value="1" <?php if ($proportional_width_top == 1) echo " checked='checked'"; ?>>
        	Proportional
        </td>
		<td align="right">Height: </td>
		<td align="left">
        	<input name="top_level_item_height" type="text" id="top_level_item_height" value="<?php echo $top_level_item_height; ?>" size="10" />
        
               <select name="top_level_item_height_units" id="top_level_item_height_units">
                <option value="2" <?php if ($top_level_item_height_units == 2) echo "selected='selected'"; ?>>px</option>
                <option value="3" <?php if ($top_level_item_height_units == 3) echo "selected='selected'"; ?>>%</option>
               </select>
		</td>
        <td align="right">Text Alignment: </td>
		<td align="left">
               <select name="top_level_text_align" id="top_level_text_align">
                <option value="-not selected-">-not selected-</option>
                <option value="left" <?php if ($top_level_text_align == "left") echo "selected='selected'"; ?>>Left</option>
                <option value="center" <?php if ($top_level_text_align == "center") echo "selected='selected'"; ?>>Center</option>
                <option value="right" <?php if ($top_level_text_align == "right") echo "selected='selected'"; ?>>Right</option>
                <option value="justify" <?php if ($top_level_text_align == "justify") echo "selected='selected'"; ?>>Justify</option>
               </select>
		</td>
        </tr>
        </table>
        
        </td>
	  </tr>
      <tr>
      <td>
      <table width="100%" border="0">
      <tr>
        <td align="center" class="bold">Padding</td>
        <td align="right">Top: </td>
        <td>
            <input name="top_level_padding_top" type="text" id="top_level_padding_top" value="<?php echo $top_level_padding_top; ?>" size="10">
         </td>
         <td align="right">Right: </td>
         <td>
          <input name="top_level_padding_right" type="text" id="top_level_padding_right" value="<?php echo $top_level_padding_right; ?>" size="10"> 
         </td>
         <td align="right">Bottom: </td>
         <td>
          <input name="top_level_padding_bottom" type="text" id="top_level_padding_bottom" value="<?php echo $top_level_padding_bottom; ?>" size="10"> 
         </td>
         <td align="right">Left: </td>
         <td>
          <input name="top_level_padding_left" type="text" id="top_level_padding_left" value="<?php echo $top_level_padding_left; ?>" size="10">
         </td>
         </tr>
        </table> 
       </td>
      </tr> 
      </table>
      
      <table width="100%" border="0">
	  <tr><td>&nbsp;</td></tr>
	 </table>
	</td>
  </tr>
  <tr>
    <td>
	  <table border="0" width="100%"  cellspacing="1" cellpadding="1">
		<tr>  
		  <td colspan="6" class="bold">Sub Menu Positioning</td>
		  </tr>
		  <tr>
		    <td align="right">Offset from Top: </td>
		    <td><input name="sub_level_offset_top" type="text" id="sub_level_offset_top" value="<?php echo $sub_level_offset_top; ?>" size="10" /></td>
		    <td align="right">Offset from Left: </td>
		    <td><input name="sub_level_offset_left" type="text" id="sub_level_offset_left" value="<?php echo $sub_level_offset_left; ?>" size="10" /></td>
            <td align="right">Collapse and Expand: </td>
            <td>
            <input name="sub_level_collapse" id="$sub_level_collapse" type="checkbox" value="1" <?php if ($sub_level_collapse) echo "checked"; ?>>
            </td>
		    </tr>
		  <tr><td colspan="6">&nbsp;</td></tr>
	  </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table border="0" width="100%" cellspacing="1" cellpadding="1">
		  <tr>
		    <td class="bold">Sub Menu Item Size and Padding</td>
		    </tr>
		  <tr>
          <td>
          <table width="100%" border="0">
           <tr>
		    <td align="right">Width: </td>
		    <td>
              <input name="sub_level_item_width" type="text" id="sub_level_item_width" value="<?php echo $sub_level_item_width; ?>" size="10" />
		      <select name="sub_level_item_width_units" id="sub_level_item_width_units">
		       <option value="0" <?php if ($sub_level_item_width_units == 0) echo "selected='selected'"; ?>>px</option>
                <option value="1" <?php if ($sub_level_item_width_units == 1) echo "selected='selected'"; ?>>%</option>
		        </select>
 
                <input name="proportional_width_sub" type="checkbox" value="1" <?php if ($proportional_width_sub == 1) echo " checked='checked'"; ?>>
                Proportional
            </td>
		    <td align="right">Height: </td>
		    <td align="left"><input name="sub_level_item_height" type="text" id="sub_level_item_height" value="<?php echo $sub_level_item_height; ?>" size="10" />
		      <select name="sub_level_item_height_units" id="font_<?php echo $tagid; ?>5">
		        <option value="2" <?php if ($sub_level_item_height_units == 2) echo "selected='selected'"; ?>>px</option>
                <option value="3" <?php if ($sub_level_item_height_units == 3) echo "selected='selected'"; ?>>%</option>
		        </select>
                </td>
                 <td align="right">Text Alignment: </td>
				<td align="left">
               <select name="sub_level_text_align" id="sub_level_text_align">
                <option value="-not selected-">-not selected-</option>
                <option value="left" <?php if ($sub_level_text_align == "left") echo "selected='selected'"; ?>>Left</option>
                <option value="center" <?php if ($sub_level_text_align == "center") echo "selected='selected'"; ?>>Center</option>
                <option value="right" <?php if ($sub_level_text_align == "right") echo "selected='selected'"; ?>>Right</option>
                <option value="justify" <?php if ($sub_level_text_align == "justify") echo "selected='selected'"; ?>>Justify</option>
               </select>
				</td>
               </tr>
              </table>
             </td>
		    </tr>
		  <tr>
		    <td>
            <table width="100%" border="0">
      <tr>
        <td align="center" class="bold">Padding</td>
        <td align="right">Top: </td>
        <td>
            <input name="sub_level_padding_top" type="text" id="sub_level_padding_top" value="<?php echo $sub_level_padding_top; ?>" size="10">
         </td>
         <td align="right">Right: </td>
         <td>
          <input name="sub_level_padding_right" type="text" id="sub_level_padding_right" value="<?php echo $sub_level_padding_right; ?>" size="10"> 
         </td>
         <td align="right">Bottom: </td>
         <td>
          <input name="sub_level_padding_bottom" type="text" id="sub_level_padding_bottom" value="<?php echo $sub_level_padding_bottom; ?>" size="10"> 
         </td>
         <td align="right">Left: </td>
         <td>
          <input name="sub_level_padding_left" type="text" id="sub_level_padding_left" value="<?php echo $sub_level_padding_left; ?>" size="10">
         </td>
         </tr>
        </table> 
            </td>
		    </tr>
		  <tr><td>&nbsp;</td></tr>
	   </table>
	</td>
  </tr>
</table>

<table width="90%" border="0" cellspacing="0" cellpadding="0">
  <tr><td colspan="2">&nbsp;</td></tr>
  <tr>
		<td align="center" width="25%">
          <input type="submit" value="Update" name="submit" />
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
		</td>
		<td align="center" width="50%">
          <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=menu';" />
		</td>
	  </tr>
</table>
</form>
</div>

</body>
</html>