////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/18/2013	ELL
// Revised: 7/1/2013	ELL
// Implemented popup message class.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_schedule", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	var delete_text = document.getElementById("class_delete").value;
	popup_msg.popup_msg_cell = "Are you sure you want to delete the class <b>" + delete_text + "</b>?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteClass(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}

//////////////////////////////////////////////////////////////////////////////////////
function HideDelete()
{
	document.getElementById("delete_confirm").style.display = "none";
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, StatusMsg_control_name, Source)
{
	var query_complete_no_record = "Query complete.  No records found.";
	var query_complete = "<b>Query complete<\/b><br/>\n";
	var query_read_to_send = "Query ready to send...";
	var query_sent = "Query sent";
	var query_starting = "Locating description...";
	if (Source == "Populate")
	{
		query_complete_no_record = "No records found. Could not find description.";
		query_complete = "<b>Description Found<\/b><br/>\n";
		query_starting = "Locating description...";
	}
	else if (Source == "Update")
	{
		query_complete_no_record = "No record found. Could not update description.";
		query_complete = "<b>Description updated<\/b><br/>\n";
		query_starting = "Updating description...";
	}
	
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				var rows_str = xmlhttp.responseText;
				//alert(rows_str);
				if (rows_str == "-no data-")
					document.getElementById(StatusMsg_control_name).innerHTML = query_complete_no_record;
				else
					document.getElementById(StatusMsg_control_name).innerHTML = query_complete;
					
				if (Source == "Populate")
					PopulateDesc(rows_str);
			}
			else
				document.getElementById(StatusMsg_control_name).innerHTML = query_complete_no_record;

			var ClearMessageString = "ClearMessage('" + StatusMsg_control_name + "');";
			mTimer = setTimeout(ClearMessageString, 2000);
		}
		else if (xmlhttp.readyState==1)
			document.getElementById(StatusMsg_control_name).innerHTML = query_read_to_send;
		else if (xmlhttp.readyState==2)
			document.getElementById(StatusMsg_control_name).innerHTML = query_sent;
		else if (xmlhttp.readyState==3)
			document.getElementById(StatusMsg_control_name).innerHTML = query_starting;
	}
	return (xmlhttp);
}

//////////////////////////////////////////////////////////////////////////////////////
function ClearMessage(StatusMsg_control_name)
{
	document.getElementById(StatusMsg_control_name).innerHTML = "&nbsp;";
	clearInterval(mTimer);
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateDesc(rows_str)
{
	document.getElementById("description_edit").value = rows_str;
}

//////////////////////////////////////////////////////////////////////////////////////
function EscapeClass(class_escape)
{
	class_escape = class_escape.replace(".", "PERIOD");
	class_escape = class_escape.replace("#", "POUND");
	class_escape = class_escape.replace(" ", "SPACE");
	class_escape = class_escape.replace(",", "COMMA");
	class_escape = class_escape.replace(".", "PERIOD");
	class_escape = class_escape.replace("#", "POUND");
	class_escape = class_escape.replace(" ", "SPACE");
	class_escape = class_escape.replace(",", "COMMA");
	class_escape = class_escape.replace(".", "PERIOD");
	class_escape = class_escape.replace("#", "POUND");
	class_escape = class_escape.replace(" ", "SPACE");
	class_escape = class_escape.replace(",", "COMMA");
	class_escape = class_escape.replace(".", "PERIOD");
	class_escape = class_escape.replace("#", "POUND");
	class_escape = class_escape.replace(" ", "SPACE");
	class_escape = class_escape.replace(",", "COMMA");
	class_escape = class_escape.replace(".", "PERIOD");
	class_escape = class_escape.replace("#", "POUND");
	class_escape = class_escape.replace(" ", "SPACE");
	class_escape = class_escape.replace(",", "COMMA");
	return(class_escape);
}

///////////////////////////////////////////////////////////////////////////////////////
function EnableDisableSubclass(bChecked)
{
	if (bChecked)
		document.getElementById("subclass").disabled = true;
	else
		document.getElementById("subclass").disabled = false;
}