////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 3/9/2013	ELL
// Revised: 6/28/2013	ELL
// Implemented popup message class.

var mTimer;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_page", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function LoadPage()
{
	$.post( "load_page.php", { page_name: page_name, blog_id: blog_id, special: special, mode: mode } ).done(CompleteLoadPage) ;
}
function CompleteLoadPage(data)
{
	CKEDITOR.instances['editorContainer'].setData(data);
}

function Save(action)
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	$.post( "save_page.php", { sValue: sValue, page_name: page_name, blog_id: blog_id, special: special, mode: mode, action: action } ).done(CompleteSave) ;
}
function CompleteSave(data)	{
	popup_msg.status_msg = data;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	saved = true;
}

function Preview()
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Preparing preview...";
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	$.post( "preview_page_init.php", { sValue: sValue }, function(data){ document.getElementById("StatusMsg").innerHTML = data; }, "text" ) ;
	
	var preview_page_string = "preview_page.php?page_name=" + page_name + "&special=" + special + "&mode=" + mode + "&blog_id=" + blog_id;
	window.open(preview_page_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
}

function ClearContent()
{
	var encap_delim = "<!-- WYSIWYG Encapsulation. Modify HTML inside of these comments only.  All code outside of these comments is discarded. -->";
	
	page_content = prepend + encap_delim + "&nbsp;" + encap_delim + postpend;
	CKEDITOR.instances['editorContainer'].setData(page_content);
}

function Revert()
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Reverting to last published version...";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	$.post( "revert.php", { page_name: page_name, blog_id: blog_id, special: special, mode: mode, prepend: prepend, postpend: postpend }).done(CompleteRevert) ;
	
}
function CompleteRevert(data)	{
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function OptimizeResetImages(action)
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	$.post( "optimize_reset_images.php", { sValue: sValue, userfiles: userfiles, action: action }).done(CompleteOptimizeResetImages);
}
function CompleteOptimizeResetImages(data)	{
	popup_msg.status_msg = data;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function MainMenu(ok)
{
	if (ok)
		window.location.href = 'main.php?mode=' + mode;
	else
	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 300;
		popup_msg.popup_msg_type = 3;
		popup_msg.popup_btn_cnt = 2;
		popup_msg.popup_msg_cell = "Your page is not saved.  Do you want to save your changes?";
		popup_msg.popup_button_2_span = "Yes";
		popup_msg.popup_button_1_span = "No";
		popup_msg.popup_timeout = -1;
		popup_msg.ShowPopupMsg();
		document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
		document.getElementById("popup_button_1_span").onclick = function () { MainMenu(true); };
	}
}

function SaveBeforeMain()
{
	Save('save_draft');
	var mTimer2 = setTimeout('MainMenu(true);', 5000);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function ShowSaveAsMsg()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.popup_msg_type = 4;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_prompt_cell = "Save as: ";
	popup_msg.popup_button_2_span = "Cancel";
	popup_msg.popup_button_1_span = "OK";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { HidePopupMsg(); };
	document.getElementById("popup_button_1_span").onclick = function () { SaveAs(); };
}

function SaveAs()
{
	var old_page_name = page_name;
	var new_page_name = document.getElementById("popup_prompt_textbox").value;
	if ((new_page_name == null) || (new_page_name == ""))
	{
		alert("Page name cannot be blank. Please enter a page name and try again.");
		return;
	}
	var page_exists;
	$.post( "check_page_exists.php", { page_name: new_page_name }, function(data){ page_exists = data; }, "text" ) ;
	if (page_exists == "1")
		alert("Page " + new_page_name + " already exists. Please go back to the main menu to copy and rename your pages.");
	else
	{
		page_name = new_page_name;
		$.post( "copy_rename_page.php", { page_name: old_page_name, new_name: new_page_name, copy_mode: "copy", overwrite: 0, overwrite_content_only: 0, create_new_template: 0 } ) ;
		
		document.getElementById("page_name_label").innerHTML = new_page_name;
		
		Save('publish');
	}
	
	HidePopupMsg();
}