/////////////////////////////////////////////
// Manage Page Access Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/11/2012	ELL
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// 
// 
//
var max_rec = 50;
var page = 0;
var num_users = 0;
var total_pages = 0;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#manage_page_access", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}


function DeleteUserConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.msg_width = 450;
	popup_msg.popup_msg_cell = "Are you sure you want to delete the user <b>" + document.getElementById("selectUserNameDelete").value + "</b>?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteUser(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}

function DeleteUser()
{
	var user_name = document.getElementById("selectUserNameDelete").value;
	var table = document.getElementById("table_delete_user").value;
//	document.getElementById("delete_confirm_user").style.display = "none";
	HidePopupMsg();
	var url = "delete_user.php?user_name=" + user_name + "&table=" + table;
	window.location = url;
}

function GeneratePassword(source)
{
	var password = "";
	var password_length = rand(6,10);
	var i;
	var assci_segment;
	
	for (i = 0; i < password_length; i++)
	{
		assci_segment = rand(1,3);
		if (assci_segment == 1)
			password = password + String.fromCharCode(rand(48,57));	// numeric
		else if (assci_segment == 2)
			password = password + String.fromCharCode(rand(65,90));	// alpha upper case
		else
			password = password + String.fromCharCode(rand(97,122));	// alpha lower case
	}
	password = password.replace('I', 'i');
	password = password.replace('O', 'o');
	password = password.replace('l', 'L');
	
	if (source == "new")
		var frm_obj = document.getElementById ('password_new_user');
	else
		var frm_obj = document.getElementById ('password_existing_user');
		
	frm_obj.value = password;
		
	return password;
}

// Equivalent to PHP rand(min, max);
function rand ( n, m )
{
  return ( n + Math.floor ( Math.random ( ) * (m - n + 1)) );
}

//////////////////////////////////////////////////////////////////////////////////////////////////////

function DeleteAccessLevelConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.msg_width = 450;
	popup_msg.popup_msg_cell = "Are you sure you want to delete the access level <b>" + document.getElementById("access_level_remove").value + "</b>?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { AddRemoveAccessLevel('remove'); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdatePageRestriction(page_name, i)
{		
	var params = "";
	var login_required_ctl = "login_required" + i;
	var user_table_ctl = "user_table" + i;
	var access_level_ctl = "access_level" + i;
	var login_page_ctl = "login_page" + i;

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_page_restriction.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Update");
		
		params = "page_name=" + page_name;
		params = params + "&login_required=" + document.getElementById(login_required_ctl).checked;
		if (document.getElementById(user_table_ctl).value != "")
			params = params + "&user_table=" + document.getElementById(user_table_ctl).value;
		if (document.getElementById(access_level_ctl).value != "")
			params = params + "&access_level=" + document.getElementById(access_level_ctl).value;
		if (document.getElementById(login_page_ctl).value != "")
			params = params + "&login_page=" + document.getElementById(login_page_ctl).value;
//		alert(params);
		xmlhttp.send(params);
	}
}


//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, Source)
{
	var query_complete_no_record = "Query complete.  No records found.";
	var query_complete = "<b>Query complete<\/b><br/>\n";
	var query_read_to_send = "Query ready to send...";
	var query_sent = "Query sent";
	var query_starting = "Locating page restrictions...";
	
	if (Source == "Update")
	{
		query_complete_no_record = "No record found. Could not update page restrictions.";
		query_complete = "<b>Page restrictions updated<\/b><br/>\n";
		query_starting = "Updating page restrictions...";
	}
	else if (Source == "UpdateUserStatus")
	{
		query_complete_no_record = "No record found. Could not update user status.";
		query_complete = "<b>User status updated<\/b><br/>\n";
		query_starting = "Updating user status...";
	}
	else if (Source == "AddFields")
	{
		query_complete_no_record = "Could not modify table.";
		query_complete = "<b>Fields added to table<\/b><br/>\n";
		query_starting = "Adding fields to table...";
	}
	else if (Source == "AssignWelcomeMessage")
	{
		query_complete_no_record = "Could not modify table.";
		query_complete = "<b>Welcome message page added to table<\/b><br/>\n";
		query_starting = "Adding welcome message page to table...";
	}
	else if (Source == "AddRemoveAccessLevel")
	{
		query_complete_no_record = "Could not add or delete access level.";
		query_complete = "<b>Access level records modified<\/b><br/>\n";
		query_starting = "Changing access levels...";
	}
	else if (Source == "PopulateAccessLevels")
		query_starting = "Locating access levels...";
	else if (Source == "PopulateUsers")
		query_starting = "Locating users...";

	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				var rows_str = xmlhttp.responseText;
				//alert(rows_str);
				if (rows_str == "-no data-")
					popup_msg.status_msg = query_complete_no_record;
				else
					popup_msg.status_msg = query_complete;

				if (Source == "Populate")
					PopulatePageTable(rows_str);
				else if (Source == "PopulateAccessLevels")
					PopulateAccessLevels(rows_str);
				else if (Source == "AddFields")
					alert("Make sure the form you are using for users has fields with the names 'email', 'UserID' and 'Password'. If the table you selected was created using the account-creation form plugin, then these fields already exist in this table.");
				else if (Source == "AddRemoveAccessLevel")
					RetrieveAccessLevels(1);
				else if (Source == "PopulateUsers")
					PopulateUserLists(rows_str);

			}
			else
				popup_msg.status_msg = query_complete_no_record;

			popup_msg.popup_timeout = 2000;
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = query_read_to_send;
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = query_sent;
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = query_starting;
		
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

////////////////////////////////////////////////////////////////////////////////////
function RetrievePages()
{		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Retrieving page restrictions...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_page_restrictions.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Populate");
		xmlhttp.send();
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulatePageTable(rows_str)
{
	var rows = new Array();

	var output_str = "<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
	output_str = output_str + "<tr><td colspan='5' class='sub_title'>Restrict Page Access</td></tr>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td class='header_row'><b>Page<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>Require Login<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>User Table<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>Access Level<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>Login Page<\/b><\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";

	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no pages yet (first time).
		var i = 0;
	else	// Create rows for page restrictions.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			if (bgclr == "#dddddd")
				bgclr = "#eeeeee";
			else
				bgclr = "#dddddd";
				
			output_str = output_str + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
	
			output_str = output_str + "<td valign='top'><input type='hidden' name='ID" + i + "' id='ID" + i + "' value='" + JSON_row.ID + "'>\n";
			output_str = output_str + "<input type='hidden' name='page_name" + i + "' id='page_name" + i + "' value='" + JSON_row.page_name + "'>" + JSON_row.page_name + "<\/td>\n";
				
			output_str = output_str + "<td>\n";
			output_str = output_str + " <input type='checkbox' name='login_required" + i + "' id='login_required" + i + "'";
			if (JSON_row.login_required == 1)
				output_str = output_str + " checked='checked'";
			output_str = output_str + " />\n";
			output_str = output_str + "<\/td>\n";

			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='user_table" + i + "' id='user_table" + i + "'>\n";
			output_str = output_str + "<option value=''>-not selected-<\/option>\n";
			for (j = 0; j < table_cnt; j++)
			{
				if (tables[j] == JSON_row.user_table)
					output_str = output_str + "<option value='" + tables[j] + "' selected='selected'>" + tables[j] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + tables[j] + "'>" + tables[j] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			output_str = output_str + "<\/td>\n";

			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='access_level" + i + "' id='access_level" + i + "'>\n";
			output_str = output_str + "<option value=''>-not selected-<\/option>\n";
			for (j = 0; j < access_level_cnt; j++)
			{
				if (access_levels[j] == JSON_row.AccessLevel)
					output_str = output_str + "<option value='" + access_levels[j] + "' selected='selected'>" + access_levels[j] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + access_levels[j] + "'>" + access_levels[j] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			output_str = output_str + "<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='login_page" + i + "' id='login_page" + i + "'>\n";
			for (j = 0; j < login_page_cnt; j++)
			{
				if (login_pages[j] == JSON_row.login_page)
					output_str = output_str + "<option value='" + login_pages[j] + "' selected='selected'>" + login_pages[j] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + login_pages[j] + "'>" + login_pages[j] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			output_str = output_str + "<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdatePageRestriction('" + JSON_row.page_name + "', " + i + ");\" />\n<\/td>\n";
			
			output_str = output_str + "<\/tr>\n";

		}
	}
	output_str = output_str + "<\/table>\n";
	
	document.getElementById("PageRestrictionsTable").innerHTML = output_str;
	document.getElementById("nCount").value = i;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function RetrieveAccessLevels(update_page_table)
{
	update_page_table_mode = update_page_table;
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Retrieving access levels...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_access_levels.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "PopulateAccessLevels");
		xmlhttp.send();
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateAccessLevels(rows_str)
{
	var rows = new Array();
	
	var output_str = "<select name='access_level_remove' id='access_level_remove'>\n";
	var output_str2 = "<select name='selectAccessLevel' id='selectAccessLevel'>\n";
	output_str = output_str + "<option>-not selected-</option>\n";
	output_str2 = output_str2 + "<option>-not selected-</option>\n";

	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no pages yet (first time).
		var i = 0;
	else	// Create options for access level list.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			output_str = output_str + "<option value='" + JSON_row.access_level + "'>" + JSON_row.access_level + "</option>\n";
			output_str2 = output_str2 + "<option value='" + JSON_row.access_level + "'>" + JSON_row.access_level + "</option>\n";
		}
	}
	output_str = output_str + "<\/select>\n";
	output_str2 = output_str2 + "<\/select>\n";
	
	document.getElementById("AccessLevelRemoveDiv").innerHTML = output_str;
	document.getElementById("AccessLevelAddUserDiv").innerHTML = output_str2;

	if (update_page_table_mode == 1)
	{
		if (access_level_add != "-not set-")
		{
			access_levels[access_level_cnt] = access_level_add;
			access_level_cnt++;
			access_level_add = "-not set-";
		}
		else if (access_level_remove != "-not set-")
		{
			access_levels.splice(access_levels.indexOf(access_level_remove), 1);
			access_level_cnt--;
			access_level_remove = "-not set-";
		}
		RetrievePages();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function RetrieveUserLists(user_table, start)
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Retrieving users...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_users.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "PopulateUsers");
		params = "user_table=" + user_table + "&page=" + page + "&max_rec=" + max_rec;
		xmlhttp.send(params);
	}
	
	document.getElementById("user_table_for_users_table").value = user_table;
	document.getElementById("user_table_for_fields").value = user_table;
	document.getElementById("table_add_user").value = user_table;
	document.getElementById("table").value = user_table;
	document.getElementById("table_delete_user").value = user_table;
	
	if (start)
		page = 0;
//	alert (params);
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateUserLists(rows_str)
{
//	alert(rows_str);
	var rows = new Array();

	var output_str = "<select name='selectUserName' id='selectUserName'>\n";
	var output_str2 = "<select name='selectUserNameDelete' id='selectUserNameDelete'>\n";
	var output_str3 =  "<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
	output_str = output_str + "<option>-not selected-</option>\n";
	output_str2 = output_str2 + "<option>-not selected-</option>\n";
	output_str3 = output_str3 + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str3 = output_str3 + "<td class='header_row'><b>User<\/b><\/td>\n";
	output_str3 = output_str3 + "<td class='header_row'><b>Active<\/b><\/td>\n";
	output_str3 = output_str3 + "<td>&nbsp;<\/td>\n";
	output_str3 = output_str3 + "</tr>\n";

	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no pages yet (first time).
		var i = 0;
	else	// Create options for access level list.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			//alert(JSON_row);
			if (JSON_row.UserID)
			{
				if (JSON_row.UserID == last_user)
				{
					output_str = output_str + "<option value='" + JSON_row.UserID + "' selected='selected'>" + JSON_row.UserID + "</option>\n";
					output_str2 = output_str2 + "<option value='" + JSON_row.UserID + "' selected='selected'>" + JSON_row.UserID + "</option>\n";
				}
				else
				{
					output_str = output_str + "<option value='" + JSON_row.UserID + "'>" + JSON_row.UserID + "</option>\n";
					output_str2 = output_str2 + "<option value='" + JSON_row.UserID + "'>" + JSON_row.UserID + "</option>\n";
				}
				
				if (bgclr == "#dddddd")
					bgclr = "#eeeeee";
				else
					bgclr = "#dddddd";
			
				output_str3 = output_str3 + "<tr bgcolor='" + bgclr + "'>\n<td>" + JSON_row.UserID + "<input type='hidden' value='" + JSON_row.UserID + "' id='user_id" + i + "' name='user_id" + i + "' /></td>\n<td>\n";
				
				output_str3 = output_str3 + " <input type='checkbox' name='active" + i + "' id='active" + i + "'";
				if (JSON_row.Active == 1)
					output_str3 = output_str3 + " checked='checked'";
				output_str3 = output_str3 + " />\n</td>\n";
				
				output_str3 = output_str3 + "<td valign='top'>\n<img src='images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateUserStatus('" + JSON_row.UserID + "', " + i + ");\" />\n<\/td>\n";

			}
			if (JSON_row.welcome_message_page)
				document.getElementById("welcome_message_page").value = JSON_row.welcome_message_page;
			else
				document.getElementById("welcome_message_page").selectedIndex = 0;
		}
	}
	output_str = output_str + "<\/select>\n";
	output_str2 = output_str2 + "<\/select>\n";
	output_str3 = output_str3 + "</tr>\n</table>\n";
	
	document.getElementById("UsersChangePassword").innerHTML = output_str;
	document.getElementById("UsersDelete").innerHTML = output_str2;
	document.getElementById("UsersTable").innerHTML = output_str3;

	///////////////////////////////////////////
	GetNumUsers();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function UpdateUserStatus(UserID, i)
{		
	var params = "";
	var user_id_ctl = "user_id" + i;
	var active_ctl = "active" + i;

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_user_status.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "UpdateUserStatus");
		
		params = "UserID=" + document.getElementById(user_id_ctl).value;
		params = params + "&Active=" + document.getElementById(active_ctl).checked;
		params = params + "&user_table=" + document.getElementById("user_table_for_users_table").value;
		//alert(params);
		xmlhttp.send(params);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function AddFieldsToTable()
{		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Adding login fields to table...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","add_login_fields.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "AddFields");
		
		params = "user_table=" + document.getElementById("user_table_for_fields").value;
		xmlhttp.send(params);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function AssignWelcomeMessagePageToTable()
{		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Assigning welcome message page to table...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","assign_welcome_message_to_table.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "AssignWelcomeMessage");
		
		params = "user_table=" + document.getElementById("user_table_for_fields").value;
		params = params + "&welcome_message_page=" + document.getElementById("welcome_message_page").value;
		xmlhttp.send(params);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
function AddRemoveAccessLevel(action)
{		
	if (action == "add")
	{
		popup_msg.status_msg = "Adding access level...";
	}
	else
	{
		HidePopupMsg();
		popup_msg.status_msg = "Removing access level...";
	}
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();

	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","add_remove_access_level.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "AddRemoveAccessLevel");
		
		params = "action=" + action;
		if (action == "add")
		{
			params = params + "&access_level=" + document.getElementById("access_level_add").value;
			access_level_add = document.getElementById("access_level_add").value;
		}
		else
		{
			params = params + "&access_level=" + document.getElementById("access_level_remove").value;
			access_level_remove = document.getElementById("access_level_remove").value;
		}
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////
function moveFirst()
{
	page = 0;
	var user_table = document.getElementById("user_table_for_fields").value;
	RetrieveUserLists(user_table, false);
}

function movePrev()
{
	page = Math.max(0, (page - 1));
	var user_table = document.getElementById("user_table_for_fields").value;
	RetrieveUserLists(user_table, false);
}

function moveNext()
{
	page = Math.min(total_pages, (page + 1));
	var user_table = document.getElementById("user_table_for_fields").value;
	RetrieveUserLists(user_table, false);
}

function moveLast()
{
	page = total_pages;
	var user_table = document.getElementById("user_table_for_fields").value;
	RetrieveUserLists(user_table, false);
}

function GetNumUsers()
{
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	var user_table = document.getElementById("user_table_for_fields").value;

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_num_users.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = FinishGetNumUsers(xmlhttp);
		params = "user_table=" + user_table;
		xmlhttp.send(params);
//		alert(params);
	}
}

function FinishGetNumUsers(xmlhttp)	{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				num_users = xmlhttp.responseText;
				if (num_users == "-no data-")
					num_users = 0;
			}
			else
				num_users = 0;
			total_pages = Math.ceil(num_users/max_rec) - 1;
			ShowHidePageBtns();
		}
	}
	return (xmlhttp);
}

function ShowHidePageBtns()	{
	if (total_pages < 1)
	{
		document.getElementById("user_nav_row_top").style.display = "none";
		document.getElementById("user_nav_row_bot").style.display = "none";
	}
	else
	{
		document.getElementById("user_nav_row_top").style.display = "table-row";
		document.getElementById("user_nav_row_bot").style.display = "table-row";
	}

	if (page < 1)
	{
		document.getElementById("first_top").src = "./images/First_disabled.gif";
		document.getElementById("prev_top").src = "./images/Previous_disabled.gif";
		document.getElementById("first_bot").src = "./images/First_disabled.gif";
		document.getElementById("prev_bot").src = "./images/Previous_disabled.gif";
	}
	else
	{
		document.getElementById("first_top").src = "./images/First.gif";
		document.getElementById("prev_top").src = "./images/Previous.gif";
		document.getElementById("first_bot").src = "./images/First.gif";
		document.getElementById("prev_bot").src = "./images/Previous.gif";
	}
	
	if (page == total_pages)
	{
		document.getElementById("next_top").src = "./images/Next_disabled.gif";
		document.getElementById("last_top").src = "./images/Last_disabled.gif";
		document.getElementById("next_bot").src = "./images/Next_disabled.gif";
		document.getElementById("last_bot").src = "./images/Last_disabled.gif";
	}
	else
	{
		document.getElementById("next_top").src = "./images/Next.gif";
		document.getElementById("last_top").src = "./images/Last.gif";
		document.getElementById("next_bot").src = "./images/Next.gif";
		document.getElementById("last_bot").src = "./images/Last.gif";
	}
}