///////////////////////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	6/25/2013	ELL
// Revised: 7/1/2013	ELL
// Implemented popup message class.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#manage_special", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = "Are you sure you want to delete the <b>" + document.getElementById("area_name").value + "</b> area?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeletePage(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}

function DeletePage()
{
	var area_name = document.getElementById("area_name").value;
	HidePopupMsg();
	var url = "delete_special.php?area_name=" + area_name;
	window.location = url;
}

function GetAreaFromName(page_name)
{
	var initial_prefix;

	switch (page_name.substr(0, 1))	{
	case 't':
		initial_prefix = "top_";
		break;
	case 'b':
		initial_prefix = "bottom_";
		break;
	case 'l':
		initial_prefix = "left_";
		break;
	case 'r':
		initial_prefix = "right_";
		break;
	case 'h':
		initial_prefix = "header_";
		break;
	case 'f':
		initial_prefix = "footer_";
		break;
	}
	
	return(initial_prefix);
}