////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	6/27/2013	ELL

// Popup Message Class
function PopupMsg(param_array)
{
   // Popup Message Properties
   // popup_msg_type:
   // 1 = status message, self closing
   // 2 = status message, with close button
   // 3 = button-response message
   // 4 = input-prompt message
	this.popup_msg_type = (typeof param_array['popup_msg_type'] !== "undefined") ? param_array['popup_msg_type'] : 1;
	this.popup_btn_cnt = (typeof param_array['popup_btn_cnt'] !== "undefined") ? param_array['popup_btn_cnt'] : 2;
	this.status_msg = (typeof param_array['status_msg'] !== "undefined") ? param_array['status_msg'] : '';
	this.popup_msg_cell = (typeof param_array['popup_msg_cell'] !== "undefined") ? param_array['popup_msg_cell'] : '';
	this.popup_prompt_cell = (typeof param_array['popup_prompt_cell'] !== "undefined") ? param_array['popup_prompt_cell'] : '';
	this.popup_prompt_textbox = (typeof param_array['popup_prompt_textbox'] !== "undefined") ? param_array['popup_prompt_textbox'] : '';
	this.popup_button_1_span = (typeof param_array['popup_button_1_span'] !== "undefined") ? param_array['popup_button_1_span'] : '';
	this.popup_button_2_span = (typeof param_array['popup_button_2_span'] !== "undefined") ? param_array['popup_button_2_span'] : '';
	this.popup_btn_1_cmd_str = (typeof param_array['popup_btn_1_cmd_str'] !== "undefined") ? param_array['popup_btn_1_cmd_str'] : '';
	this.popup_btn_2_cmd_str = (typeof param_array['popup_btn_2_cmd_str'] !== "undefined") ? param_array['popup_btn_2_cmd_str'] : '';
	this.popup_timeout = (typeof param_array['popup_timeout'] !== "undefined") ? param_array['popup_timeout'] : -1;
	this.top_offset = (typeof param_array['top_offset'] !== "undefined") ? param_array['top_offset'] : 0;
	this.left_offset = (typeof param_array['left_offset'] !== "undefined") ? param_array['left_offset'] : 500;
	this.msg_width = (typeof param_array['msg_width'] !== "undefined") ? param_array['msg_width'] : -1;
}


// Popup Message Class Methods
PopupMsg.prototype.ShowPopupMsg = function()
{
	var ntop;
	ntop = tempY + this.top_offset;
	
	if (ntop < 500)
		ntop = ntop + 50;
	else
		ntop = ntop - 200;
	var strtop = ntop + "px";
	var strleft = this.left_offset + "px";
	
	document.getElementById("popup_msg_div").style.display = "block";
	document.getElementById("popup_msg_div").style.position = "absolute";
	document.getElementById("popup_msg_div").style.top = strtop;
	document.getElementById("popup_msg_div").style.left = strleft;
	if (this.msg_width > -1)
		document.getElementById("popup_msg_div").style.width = this.msg_width + "px";
		
	switch (this.popup_msg_type){
		case 1:
		document.getElementById("status_msg").style.display = "inline";
		document.getElementById("popup_msg_close_btn").style.display = "none";
		document.getElementById("popup_msg_table_div").style.display = "none";
		document.getElementById("popup_msg_row").style.display = "none";
		document.getElementById("popup_prompt_row").style.display = "none";
		document.getElementById("popup_button_row").style.display = "none";
		break;
		case 2:
		document.getElementById("status_msg").style.display = "inline";
		document.getElementById("popup_msg_close_btn").style.display = "inline";
		document.getElementById("popup_msg_table_div").style.display = "none";
		document.getElementById("popup_msg_row").style.display = "none";
		document.getElementById("popup_prompt_row").style.display = "none";
		document.getElementById("popup_button_row").style.display = "none";
		break;
		case 3:
		document.getElementById("status_msg").style.display = "none";
		document.getElementById("popup_msg_close_btn").style.display = "none";
		document.getElementById("popup_msg_table_div").style.display = "inline";
		document.getElementById("popup_msg_row").style.display = "table-row";
		document.getElementById("popup_prompt_row").style.display = "none";
		document.getElementById("popup_button_row").style.display = "table-row";
		document.getElementById("popup_button_1_cell").style.textAlign = "center";
		break;
		case 4:
		document.getElementById("status_msg").style.display = "none";
		document.getElementById("popup_msg_close_btn").style.display = "none";
		document.getElementById("popup_msg_table_div").style.display = "inline";
		document.getElementById("popup_msg_row").style.display = "none";
		document.getElementById("popup_prompt_row").style.display = "table-row";
		document.getElementById("popup_button_row").style.display = "table-row";
		document.getElementById("popup_button_1_cell").style.textAlign = "right";
		break;
		default : 
		document.getElementById("status_msg").style.display = "inline";
		document.getElementById("popup_msg_close_btn").style.display = "inline";
		document.getElementById("popup_msg_table_div").style.display = "inline";
		document.getElementById("popup_msg_row").style.display = "table-row";
		document.getElementById("popup_prompt_row").style.display = "table-row";
		document.getElementById("popup_button_row").style.display = "table-row";
		document.getElementById("popup_button_1_cell").style.textAlign = "center";
	}
	
	if (this.popup_msg_type > 2)
	{
		switch (this.popup_btn_cnt) {
			case 1:
			document.getElementById("popup_button_1_span").style.display = "inline";
			document.getElementById("popup_button_2_span").style.display = "none";
			document.getElementById("popup_button_3_span").style.display = "none";
			break;
			case 2:
			document.getElementById("popup_button_1_span").style.display = "inline";
			document.getElementById("popup_button_2_span").style.display = "inline";
			document.getElementById("popup_button_3_span").style.display = "none";
			break;
			case 3:
			document.getElementById("popup_button_1_span").style.display = "inline";
			document.getElementById("popup_button_2_span").style.display = "inline";
			document.getElementById("popup_button_3_span").style.display = "inline";
			break;
			default :
			document.getElementById("popup_button_1_span").style.display = "inline";
			document.getElementById("popup_button_2_span").style.display = "inline";
			document.getElementById("popup_button_3_span").style.display = "none";
		}
	}

	document.getElementById("status_msg").innerHTML = this.status_msg;
	document.getElementById("popup_msg_cell").innerHTML = this.popup_msg_cell;
	document.getElementById("popup_prompt_cell").innerHTML = this.popup_prompt_cell;
	document.getElementById("popup_prompt_textbox").value = this.popup_prompt_textbox;
	document.getElementById("popup_button_1_span").innerHTML = this.popup_button_1_span;
	document.getElementById("popup_button_2_span").innerHTML = this.popup_button_2_span;
	
	if (this.popup_timeout > -1)
		mTimer = setTimeout("HidePopupMsg();", this.popup_timeout);
}

function HidePopupMsg()
{
	document.getElementById("popup_msg_div").style.display = "none";
	document.getElementById("status_msg").style.display = "none";
	document.getElementById("popup_msg_close_btn").style.display = "none";
	document.getElementById("popup_msg_table_div").style.display = "none";
	document.getElementById("popup_msg_row").style.display = "none";
	document.getElementById("popup_prompt_row").style.display = "none";
	document.getElementById("popup_button_row").style.display = "none";
	document.getElementById("status_msg").innerHTML = " ";
	document.getElementById("popup_msg_cell").innerHTML = " ";
	document.getElementById("popup_prompt_cell").innerHTML = " ";
	document.getElementById("popup_prompt_textbox").value = " ";
	document.getElementById("popup_button_1_span").innerHTML = " ";
	document.getElementById("popup_button_2_span").innerHTML = " ";
}