<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 6/15/2007
// Added (Home) label on edit page list for index page.
// Revised: 9/9/2008
// Added page titles for individual pages.
// Revised: 9/20/2008
// Moved "Edit Menu Items" to user level and moved "Edit Meta Tags" to administrator level.
// Revised: 6/3/2009 ELL
// Added link to manage special pages for creating additional "right" areas.  Also changed verbage of "special pages" to "border areas".
// Revised: 6/5/2009	ELL
// Added copy mode.
// Revised: 6/19/2009	ELL
// Added option to copy page to new template.
// Revised: 8/1/2009	ELL
// Added link for editing calendar style sheets.
// Removed code for purchased option selection of grid-style calendar.
// Added selection of advanced menu styles based on site options.
// Revised: 8/24/2009	ELL
// Added plugin capability.
// Added template selecting at point of creating pages.  Added template picture.
// Style sheet list now allows editng of ALL style sheets found in style_sheets table.
// Revised: 10/12/09	ELL
// Changed menu assignment to go to menu management page for new multi-menu all-css system.
// Modified: 1/6/10		ELL
// Modified style sheet list to look for menus and build description string based on "menus" table.
// Modified: 2/4/10		ELL
// Completely revised structure from table-based layout to div-based layout for modal viewing.
// Added "wizard view" to display only editing of pages upon entry from site-builder wizard.
// Modified: 4/5/10		ELL
// Added "Manage Zen Cart" button.
// Added ability to enable and disable "Re-run Wizard" and "Manage Zen Cart" buttons.
// Modified: 4/9/10		ELL
// Put access level control back in and added more levels.  The levels are restricted, user, power_user, and admin.
// Modified: 5/6/2010	ELL
// Add version checking.
// Revised: 9/27/2010 ELL
// Added mode follow-thru such that returning to main menu after editing pages, border areas, or creating pages brings up the same mode in the main menu.
// Revised: 10/12/2010	ELL
// Added pruning of page data backup table.
// Revised: 11/9/2010	ELL
// Added persitence of last page edited, last border area edited, and last head edited.
// Revised: 11/13/2010	ELL
// Added flag to edit page and edit border to signify first entering editor.
// Revised: 12/7/2010	ELL
// Added button to access file manager directly called "Manage Images".
// Revised: 10/2/2011	ELL
// Added checking for running wizard locally and made Re-run Wizard button modal both in title and target based on wizard mode.
// Added ability to take site live or off line.
// Revised: 12/28/2011	ELL
// Added startup folder for file, image or flash when calling KFM.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 6/30/2012	ELL
// Added button to access page-access control console.
// Revised: 7/10/2012	ELL
// Added blogging.
// Revised: 10/11/2012	ELL
// Added recall plugins.
// Added modal display of buttons for plugins.
// Revised: 3/10/2013	ELL
// Re-arranged buttons and added group boxes to change layout from access-level oriented to function oriented.
// Revised: 4/9/2013	ELL
// Added plugin installation.
	
	include ("check_session.php");
	
	$last_page_edited = $_SESSION['last_page_edited'];
	$last_border_edited = $_SESSION['last_border_edited'];
	$last_head_edited = $_SESSION['last_head_edited'];
	$last_style_sheet_edited = $_SESSION['last_style_sheet_edited'];
	$last_class_edited = $_SESSION['last_class_edited'];
	$last_menu_edited = $_SESSION['last_menu_edited'];
	$mode = $_REQUEST['mode'];
	$selected_page_name = $_REQUEST['selected_page_name'];
	
//	include "../connect/db_connection.php";
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'EnableWizard'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$enable_wizard = $row['option_value'];
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'EnableZenCart'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$enable_zen_cart = $row['option_value'];
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'RunWizardLocal'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$wiz_mode = $row['option_value'];
	
	if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
		$website_file_path = "/index.php";
	elseif (BWB_BASE_DIR == '')
		$website_file_path = "/" . BWB_WEBPAGE_DIR . "/";
	elseif (BWB_WEBPAGE_DIR == '')
		$website_file_path = "/" . BWB_BASE_DIR . "/";
	else
		$website_file_path = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";
		
	/////////// Determine Plugin Buttons ///////////////////////////
	if ($access_level != "restricted")
	{
		if ($access_level == "user")
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='restricted') OR (AccessLevel='user')) AND (deployed=1)";
		elseif ($access_level == "power_user")
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='restricted') OR (AccessLevel='user') OR (AccessLevel='power_user')) AND (deployed=1)";
		elseif ($access_level == "admin")
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE deployed=1";
			
		$plugin_buttons = array();
		$result = $bwb_dbh->query($query);
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$console_path = $row['console_path'];
			if (isset($console_path) && ($console_path != ""))
			{
				$console_link_text = $row['console_link_text'];
				$console_link_image = $row['console_link_image'];
				if (!in_array($console_path, $plugin_buttons))
				{
					$button_string = "<input type='button' name='plugin_button' value='" . $console_link_text . "' onClick=\"window.location='" . $console_path . "';\" class='plugin_button' />\n";
					$plugin_buttons[$console_link_text] = array($console_path, $button_string);
				}
			}
		}
		$plugin_button_cnt = count($plugin_buttons);
	}
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="stylesheet" href="manager.css" type="text/css">

<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>

<script language="JavaScript"  type="text/javascript">
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

function InitializePage()
{
	UpdateTemplateImage();
	<?php 
		if (isset($mode)) 
			echo "var mode = '$mode';\n";
		else
			echo "var mode = 'edit';\n";
	?>
	ChangeViewMode(mode);
}

function FillInPageTitle(page_name)
{
	location.href="main.php?selected_page_name=" + page_name + "&mode=title";	
}

function EnableDisableCreateNewTemplateCheckbox(copy_mode)
{
	if (copy_mode == "rename")
	{
		document.getElementById("create_new_template").disabled = true;
		document.getElementById("create_new_template_label").style.color = "#EEEEEE";
	}
	else
	{
		document.getElementById("create_new_template").disabled = false;
		document.getElementById("create_new_template_label").style.color = "#000000";
	}
}

function EditCustomCSS()
{
	location.href="edit_custom_css.php";
}

function UpdateTemplateImage()
{
	var i;
	<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `sort_order`";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo "var image = new Array($num_results);\n";
	for ($i = 0; $i < $num_results; $i++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$option_image = $row["option_image"];
		echo "image[$i] = \"$option_image\";\n";
	}
	?>
	
	i = document.getElementById("template_name").selectedIndex;
	document.getElementById("template_pic").src = "images/" + image[i];
}

var inherit = "inherit";
if (browser == "Explorer")
	inherit = "";
function ChangeViewMode(mode)
{
	document.getElementById("view_buttons").style.position="absolute";
	document.getElementById("logout").style.display="block";
	document.getElementById("logout").style.position="absolute";
	if (mode == "wizard")
	{
		document.getElementById("wizard_intro").style.display=inherit;
		document.getElementById("wizard_intro").style.zIndex="1";
		document.getElementById("main_page_heading").style.display="none";
	
		document.getElementById("blog_select").style.display="none";
		document.getElementById("create_page").style.display="none";
		document.getElementById("page_titles").style.display="none";
		document.getElementById("delete_restore_page").style.display="none";
		document.getElementById("copy_rename_page").style.display="none";
		document.getElementById("edit_border_area").style.display="none";
		document.getElementById("edit_css").style.display="none";
		document.getElementById("edit_menu_styles").style.display="none";
		document.getElementById("edit_head").style.display="none";
		document.getElementById("admin_functions").style.display="none";
		document.getElementById("main_page_heading").style.display="none";
		document.getElementById("meta_tags").style.display="none";
		
		document.getElementById("edit_page").style.display="none";
		document.getElementById("show_edit").style.position="absolute";
		document.getElementById("show_edit").style.left="100px";
		document.getElementById("show_edit").style.top="223px";
		document.getElementById("show_edit").style.width="100px";
		document.getElementById("show_edit").style.zIndex="100";
		document.getElementById("show_site").style.position="absolute";
		document.getElementById("show_site").style.left="250px";
		document.getElementById("show_site").style.top="223px";
		document.getElementById("show_site").style.width="150px";
		document.getElementById("show_site").style.zIndex="100";
		document.getElementById("logout").style.left="500px";
		document.getElementById("logout").style.top="288px";
		document.getElementById("logout").style.zIndex="100";
		
		document.getElementById("show_edit").style.display=inherit;
		document.getElementById("show_site").style.display=inherit;
		document.getElementById("show_file_manager").style.display="none";
		document.getElementById("show_blog").style.display="none";
		document.getElementById("show_wizard").style.display="none";
		document.getElementById("show_create").style.display="none";
		document.getElementById("show_menu_items").style.display="none";
		document.getElementById("show_title").style.display="none";
		document.getElementById("manage_zen_cart").style.display="none";
		document.getElementById("manage_page_access").style.display="none";
		document.getElementById("show_delete").style.display="none";
		document.getElementById("show_copy").style.display="none";
		document.getElementById("show_border").style.display="none";
		document.getElementById("show_css").style.display="none";
		document.getElementById("show_menu").style.display="none";
		document.getElementById("show_head").style.display="none";
		document.getElementById("show_admin").style.display="none";
				
		document.getElementById("help_button").style.left="650px";
		document.getElementById("help_button").style.top="290px";
		document.getElementById("help_button").style.zIndex="100";
		
		document.getElementById("plugin_buttons_div").style.display="none";
		
		document.getElementById("content_functions").style.display=inherit;
		document.getElementById("content_functions").style.borderWidth="0px";
		document.getElementById("content_functions").style.outlineWidth="0px";
		document.getElementById("content_label").style.display="none";
		document.getElementById("menu_functions").style.display="none";
		document.getElementById("style_functions").style.display="none";
		document.getElementById("page_functions").style.display="none";
		document.getElementById("other_functions").style.display="none";
		
		
		document.getElementById("wizard_intro").innerHTML = "Congratulations!  You have built your website.  What do you want to do next? <br /><br /><br /><br /><br /><br /><br /><br /><br /><br />Bookmark this page now.  This is the page you will go to to update your website from now on.<br /><span class='small_message'>(Refresh the page after clicking 'See Published Site' to view correct styles.)</span>";
	}
	else
	{
		var access_level = '<?php echo $access_level; ?>';
		
		document.getElementById("view_buttons").style.left="50px";
		document.getElementById("view_buttons").style.top="70px";
		document.getElementById("show_edit").style.position="static";
		document.getElementById("show_site").style.position="static";
		document.getElementById("show_site").style.display=inherit;
		document.getElementById("show_file_manager").style.display=inherit;
		document.getElementById("show_blog").style.display=inherit;
		
		document.getElementById("plugin_buttons_div").style.display=inherit;
		document.getElementById("page_functions").style.display=inherit;
		document.getElementById("other_functions").style.display=inherit;
		document.getElementById("content_functions").style.borderTopWidth="15px";
		document.getElementById("content_functions").style.borderBottomWidth="3px";
		document.getElementById("content_functions").style.borderLeftWidth="3px";
		document.getElementById("content_functions").style.borderRightWidth="3px";
		document.getElementById("content_functions").style.outlineWidth="thin";
		document.getElementById("content_label").style.display=inherit;
		
		if ((access_level != "restricted") && (access_level != "blogger"))	// Visible to user level and up.
		{
			document.getElementById("show_edit").style.display=inherit;
			document.getElementById("show_wizard").style.display=inherit;
			document.getElementById("show_create").style.display=inherit;
			document.getElementById("show_menu_items").style.display=inherit;
			document.getElementById("show_title").style.display=inherit;
			document.getElementById("manage_zen_cart").style.display=inherit;
			
			document.getElementById("content_functions").style.display=inherit;
			document.getElementById("menu_functions").style.display=inherit;
			document.getElementById("page_functions").style.display=inherit;
			document.getElementById("other_functions").style.display=inherit;
		
			if (access_level != "user") // Visible to power_user level and up.
			{
				document.getElementById("manage_page_access").style.display=inherit;
				document.getElementById("show_delete").style.display=inherit;
				document.getElementById("show_copy").style.display=inherit;
				document.getElementById("show_border").style.display=inherit;
				document.getElementById("show_css").style.display=inherit;
				document.getElementById("show_menu").style.display=inherit;
				document.getElementById("show_head").style.display=inherit;
				if (access_level == "admin") // Visible only to admin.
					document.getElementById("show_admin").style.display=inherit;
				else
					document.getElementById("show_admin").style.display="none";
					
				document.getElementById("style_functions").style.display=inherit;
			}
			else
			{
				document.getElementById("manage_page_access").style.display="none";
				document.getElementById("show_delete").style.display="none";
				document.getElementById("show_copy").style.display="none";
				document.getElementById("show_border").style.display="none";
				document.getElementById("show_css").style.display="none";
				document.getElementById("show_menu").style.display="none";
				document.getElementById("show_head").style.display="none";
				document.getElementById("show_admin").style.display="none";
				
				document.getElementById("style_functions").style.display="none";
			}
		}
		else
		{
			if (access_level != "blogger")
			{
				document.getElementById("show_edit").style.display=inherit;
				document.getElementById("show_blog").style.display=inherit;
			}
			else
			{
				document.getElementById("show_edit").style.display="none";
				document.getElementById("show_blog").style.display="none";
				mode = "blog";
			}
			document.getElementById("show_wizard").style.display="none";
			document.getElementById("show_file_manager").style.display="none";
			document.getElementById("show_create").style.display="none";
			document.getElementById("show_menu_items").style.display="none";
			document.getElementById("show_title").style.display="none";
			document.getElementById("manage_zen_cart").style.display="none";
			document.getElementById("manage_page_access").style.display="none";
			document.getElementById("show_delete").style.display="none";
			document.getElementById("show_copy").style.display="none";
			document.getElementById("show_border").style.display="none";
			document.getElementById("show_css").style.display="none";
			document.getElementById("show_menu").style.display="none";
			document.getElementById("show_head").style.display="none";
			document.getElementById("show_admin").style.display="none";
			
			document.getElementById("menu_functions").style.display="none";
			document.getElementById("style_functions").style.display="none";
			document.getElementById("page_functions").style.display="none";
			document.getElementById("other_functions").style.display="none";
		}
		
		document.getElementById("logout").style.left="50px";
		
		document.getElementById("wizard_intro").style.display="none";
		document.getElementById("main_page_heading").style.display=inherit;
		
		document.getElementById("help_button").style.left="50px";
		
		document.getElementById("show_edit").style.width="235px";
		document.getElementById("show_site").style.width="235px";
		
		// Add ~25px for every new button added.
<?php
		$button_offset = $plugin_button_cnt * 25;
		echo "	var button_offset = $button_offset;\n";
?>
		var button_top;
		var button_top_str;

		if ((browser=='Safari') || (browser=='Chrome'))
			button_top = 677 + button_offset;
		else if (browser=='Firefox')
			button_top = 667 + button_offset;
		else if ((browser=='Explorer') && ((browser_version=="8") || (browser_version=="7")))
			button_top = 677 + button_offset;
		else
			button_top = 637 + button_offset;
		button_top_str = button_top + "px";
		document.getElementById("logout").style.top = button_top_str;
		
		if ((browser=='Safari') || (browser=='Chrome'))
			button_top = 717 + button_offset;
		else if (browser=='Firefox')
			button_top = 717 + button_offset;
		else if ((browser=='Explorer') && ((browser_version=="8") || (browser_version=="7")))
			button_top = 717 + button_offset;
		else
			button_top = 667 + button_offset;
		button_top_str = button_top + "px";
		document.getElementById("help_button").style.top = button_top_str;

		if (mode == "edit")
		{
			document.getElementById("edit_page").style.position="absolute";
			document.getElementById("edit_page").style.left="370px";
			document.getElementById("edit_page").style.top="50px";
			document.getElementById("edit_page").style.display=inherit;
		}
		else
			document.getElementById("edit_page").style.display="none";
		if (mode == "create")
		{
			document.getElementById("create_page").style.position="absolute";
			document.getElementById("create_page").style.left="370px";
			document.getElementById("create_page").style.top="50px";
			document.getElementById("create_page").style.display=inherit;
		}
		else
			document.getElementById("create_page").style.display="none";
		
		if (mode == "title")
		{
			document.getElementById("page_titles").style.position="absolute";
			document.getElementById("page_titles").style.left="370px";
			document.getElementById("page_titles").style.top="50px";
			document.getElementById("page_titles").style.display=inherit;
			document.getElementById("meta_tags").style.position="absolute";
			document.getElementById("meta_tags").style.left="370px";
			document.getElementById("meta_tags").style.top="210px";
			document.getElementById("meta_tags").style.display=inherit;
		}
		else
		{
			document.getElementById("page_titles").style.display="none";
			document.getElementById("meta_tags").style.display="none";
		}
		if (mode == "delete")
		{
			document.getElementById("delete_restore_page").style.position="absolute";
			document.getElementById("delete_restore_page").style.left="370px";
			document.getElementById("delete_restore_page").style.top="50px";
			document.getElementById("delete_restore_page").style.display=inherit;
		}
		else
			document.getElementById("delete_restore_page").style.display="none";
		if (mode == "copy")
		{
			document.getElementById("copy_rename_page").style.position="absolute";
			document.getElementById("copy_rename_page").style.left="370px";
			document.getElementById("copy_rename_page").style.top="50px";
			document.getElementById("copy_rename_page").style.display=inherit;
		}
		else
			document.getElementById("copy_rename_page").style.display="none";
		if (mode == "border")
		{
			document.getElementById("edit_border_area").style.position="absolute";
			document.getElementById("edit_border_area").style.left="370px";
			document.getElementById("edit_border_area").style.top="50px";
			document.getElementById("edit_border_area").style.display=inherit;
		}
		else
			document.getElementById("edit_border_area").style.display="none";
		if (mode == "css")
		{
			document.getElementById("edit_css").style.position="absolute";
			document.getElementById("edit_css").style.left="370px";
			document.getElementById("edit_css").style.top="50px";
			document.getElementById("edit_css").style.display=inherit;
		}
		else
			document.getElementById("edit_css").style.display="none";
		if (mode == "menu")
		{
			document.getElementById("edit_menu_styles").style.position="absolute";
			document.getElementById("edit_menu_styles").style.left="370px";
			document.getElementById("edit_menu_styles").style.top="50px";
			document.getElementById("edit_menu_styles").style.display=inherit;
		}
		else
			document.getElementById("edit_menu_styles").style.display="none";
		if (mode == "head")
		{
			document.getElementById("edit_head").style.position="absolute";
			document.getElementById("edit_head").style.left="370px";
			document.getElementById("edit_head").style.top="50px";
			document.getElementById("edit_head").style.display=inherit;
		}
		else
			document.getElementById("edit_head").style.display="none";
		if (mode == "admin")
		{
			document.getElementById("admin_functions").style.position="absolute";
			document.getElementById("admin_functions").style.left="370px";
			document.getElementById("admin_functions").style.top="50px";
			document.getElementById("admin_functions").style.display=inherit;
		}
		else
			document.getElementById("admin_functions").style.display="none";
		if (mode == "blog")
		{
			document.getElementById("blog_select").style.position="absolute";
			document.getElementById("blog_select").style.left="370px";
			document.getElementById("blog_select").style.top="50px";
			document.getElementById("blog_select").style.display=inherit;
		}
		else
			document.getElementById("blog_select").style.display="none";
	}
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#main", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}
	
function DeleteConfirm(delete_mode)
{
	document.getElementById("delete_confirm").style.display = "block";
	document.getElementById("delete_confirm").style.position = "absolute";
	document.getElementById("delete_confirm").style.top = "100px";
	document.getElementById("delete_confirm").style.left = "200px";
	document.getElementById("delete_confirm").style.width = "450px";
	document.getElementById("delete_confirm").style.backgroundColor = "#FFF";
	document.getElementById("delete_confirm").style.borderStyle = "solid";
	document.getElementById("delete_confirm").style.borderWidth = "2px";
	document.getElementById("delete_confirm").style.borderColor = "#000";
	if (delete_mode == "blog")
	{
		document.getElementById("delete").onclick = function() {DeleteBlog(); return false;};
		var list = document.getElementById('selectBlogToDelete');
		var blog = list.options[list.selectedIndex].innerHTML;
		document.getElementById("delete_text").innerHTML = "Are your sure you want to delete <b>" + blog + "</b>?";
	}
	else if (delete_mode == "recall_plugin")
	{
		document.getElementById("delete").onclick = function() {RecallPlugin(); return false;};
		var list = document.getElementById('recall_plugin');
		var plugin_name = list.options[list.selectedIndex].innerHTML;
		var plugin_name_arr = plugin_name.split("-");
		plugin_name = plugin_name_arr[0];
		document.getElementById("delete_text").innerHTML = "Are your sure you want to recall the <b>" + plugin_name + "</b> plugin?";
	}
	else	// page
	{
		document.getElementById("delete").onclick = function() {DeletePage(); return false;};
		document.getElementById("delete_text").innerHTML = "Are your sure you want to delete the <b>" + document.getElementById("selectPageToDelete").value + "</b> page?";
	}
}

function DeletePage()
{
	var page_name = document.getElementById("selectPageToDelete").value;
	document.getElementById("delete_confirm").style.display = "none";
	var url = "delete_page.php?page_name=" + page_name;
	window.location = url;
}

function DeleteBlog()
{
	var blog_id = document.getElementById("selectBlogToDelete").value;
	document.getElementById("delete_confirm").style.display = "none";
	var url = "delete_blog.php?blog_id=" + blog_id;
	window.location = url;
}

function RecallPlugin()
{
	var plugin_id = document.getElementById("recall_plugin").value;
	document.getElementById("delete_confirm").style.display = "none";
	var url = "recall_plugin.php?plugin_id=" + plugin_id;
	window.location = url;
}

function HideDelete()
{
	document.getElementById("delete_confirm").style.display = "none";
}

function ActivateDeactivateConfirm()
{
	document.getElementById("activate_deactivate_confirm").style.display = "block";
	document.getElementById("activate_deactivate_confirm").style.position = "absolute";
	document.getElementById("activate_deactivate_confirm").style.top = "100px";
	document.getElementById("activate_deactivate_confirm").style.left = "200px";
	document.getElementById("activate_deactivate_confirm").style.width = "450px";
	document.getElementById("activate_deactivate_confirm").style.backgroundColor = "#FFF";
	document.getElementById("activate_deactivate_confirm").style.borderStyle = "solid";
	document.getElementById("activate_deactivate_confirm").style.borderWidth = "2px";
	document.getElementById("activate_deactivate_confirm").style.borderColor = "#000";
}

function HideActivateDeactivate()
{
	document.getElementById("activate_deactivate_confirm").style.display = "none";
}

</script>
</head>

<body onLoad="InitializePage();">
<div id="main_page_heading"><img src="images/breeze_logo_sm.png" alt="Breeze Website Builder" id="logo"></div>

<div id="view_buttons">
<br />
<div id="content_functions" class="group_box">
<p id="content_label" class="group_box_label">Content</p>
<input type="button" name="show_edit" id="show_edit" value="Edit Content" onClick="ChangeViewMode('edit');" />
<input type="button" name="show_create" id="show_create" value="Create Page" onClick="ChangeViewMode('create');" />
<input type="button" name="show_border" id="show_border" value="Manage Border Areas" onClick="ChangeViewMode('border');" />
<input type="button" name="show_file_manager" id="show_file_manager" value="Manage Images" onClick="window.location='/kfm/index.php?startup_folder=<?php echo BWB_IMAGE_DIR; ?>';" />
<input type="button" name="show_site" id="show_site" value="See Published Site" onClick="window.open('<?php echo $website_file_path; ?>', 'MySite');" />
<input type="button" name="show_blog" id="show_blog" value="Blog" onClick="ChangeViewMode('blog');" />
</div>
<br/>

<div id="menu_functions" class="group_box">
<p id="menu_label" class="group_box_label">Menus</p>
<input type="button" name="show_menu_items" id="show_menu_items" value="Revise Menu" onClick="window.location='edit_menu_items.php?menu=<? echo $last_menu_edited; ?>';" />
<input type="button" name="show_menu" id="show_menu" value="Edit Menu Styles and Assignments" onClick="ChangeViewMode('menu');" />
</div>
<br/>

<div id="style_functions" class="group_box">
<p id="style_label" class="group_box_label">Styles and Head Content</p>
<input type="button" name="show_css" id="show_css" value="Edit Styles" onClick="ChangeViewMode('css');" />
<input type="button" name="show_head" id="show_head" value="Manage Head Code" onClick="ChangeViewMode('head');" />
</div>
<br/>

<div id="page_functions" class="group_box">
<p id="page_label" class="group_box_label">Page Management</p>
<input type="button" name="show_title" id="show_title" value="Change Page Titles or Meta Tags" onClick="ChangeViewMode('title');" />
<input type="button" name="show_delete" id="show_delete" value="Delete or Restore Pages" onClick="ChangeViewMode('delete');" />
<input type="button" name="show_copy" id="show_copy" value="Copy or Rename Pages" onClick="ChangeViewMode('copy');" />
<input type="button" name="manage_page_access" id="manage_page_access" value="Manage Page Access" onClick="window.location='manage_page_access.php';"  />
</div>
<br/>

<div id="other_functions" class="group_box">
<p id="other_label" class="group_box_label">Site Management</p>
<div id="plugin_buttons_div">
<?php
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $key => $value)
			echo $value[1];
	}
?>
</div>
<input type="button" name="show_wizard" id="show_wizard"
<?php
 	if ($wiz_mode == 1)
 		echo "value=\"Re-run Wizard\" onClick=\"window.location='run_wizard_confirm.php';\"";
	else
		echo "value=\"Upload Template\" onClick=\"window.location='upload_template_confirm.php';\"";
	if ($enable_wizard != 1) echo "disabled"; 
?>
/>
<input type="button" name="manage_zen_cart" id="manage_zen_cart" value="Manage Zen Cart" onClick="window.location='/shoppingcart/manage5678/';" <?php if ($enable_zen_cart != 1) echo "disabled"; ?> />
<input type="button" name="show_admin" id="show_admin" value="Manage Users and Site Options" onClick="ChangeViewMode('admin');" />
</div>

</div>

    <div id="wizard_intro">
    &nbsp;
    </div>
    
    <div id="edit_page">
	<form name="frmSelectPage" method="post" action="edit_page.php">
	<p align="center">Select the page you want to edit: 
		<select name="page_name" class="page_dropdown">
		<?php
			if ($access_level == "restricted")
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE restricted = 0 ORDER BY page_name";
			else
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_name = $row["page_name"];
				if ($page_name == $last_page_edited)
					$selected = " selected='selected'";
				else
					$selected = "";
				if ($page_name == "index")
					$home = " (Home)";
				else
					$home = "";
				
				echo "<option value='" . $page_name . "'" . $selected . ">" . $page_name . $home . "</option>";
			}
			
		?>
			</select>
		</p>
		<p align="center">
		  <input type="submit" name="Submit" value="Edit" />
          <input type="hidden" name="mode" value="edit" />
		</p>
		</form>
	</div>
    <div id="create_page">
		<form name="frmCreatePage" method="post" action="create_page.php">
		<table width="100%" border=="0">
           <tr>
               <td valign="bottom">Enter the name of the page you want to create:</td>
               <td valign="bottom">Select a layout:</td>
               <td rowspan="2" width="100" height="100"><img id="template_pic" src="images/basic.jpg" border="0"></td>
          </tr>
          <tr>
			<td valign="top"><input name="createPage" type="text" id="createPage" /></td>
            <td valign="top">
            <select name="template_name" id="template_name" onChange="UpdateTemplateImage();" >
          <?php
		  	$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'Template'";
			$result2 = $bwb_dbh->query($query2);
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			$option_value_selected = $row2["option_value"];
		
		  	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `sort_order`";
			$result = $bwb_dbh->query($query);
			$i = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$option_value = $row["option_value"];				
				if ($option_value_selected == $option_value)
					echo "<option value='$option_value' selected='selected'>$option_value</option>\n";
				else
					echo "<option value='$option_value'>$option_value</option>\n";
			 	$i++;
			}
			?>
            </select>
            </td>
         </tr>
        </table>
        <table width="100%" border="0">
          <tr>
            <td>Select a plugin you want to install into new page (optional):</td>
          </tr>
          <tr>
           <td>
          <select name="plugin" id="plugin" >
          	<option value='-not selected-'>-not selected-</option>
          <?php
            $query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `available`=1 ORDER BY `sort_order`";
            $result = $bwb_dbh->query($query);
            while ($row = $result->fetch(PDO::FETCH_ASSOC))
            {
                $id = $row["id"];
				$name = $row["name"];
				$description = $row["description"];
				if ($description == "")
                	echo "<option value='$id'>$name</option>\n";
				else
					echo "<option value='$id'>$name - $description</option>\n";
            }
            ?>
            </select>
            </td>
          </tr>
         </table>
			<span class="small_message">Note: To create a printable calendar, first change the template type to "basic" under "Change Site Options".
			(This requires admin access.)</span>
		</p>
		<p align="center" class="small_message">Note: Do NOT include file extension, i.e. ".htm".  This will be added automatically.
		Spaces will be replaced with under scores and non-compatible Unix characters will be removed.</p>
		<p align="center">
		  <input type="submit" name="Submit" value="Create" />
          <input type="hidden" name="mode" value="create" />
		</p>
	  </form>
</div>

<div id="blog_select">
<table><tr><td>
	<form name="frmCreateBlog" method="post" action="create_blog.php">
	<p align="center">Select the page you want to blog to: 
		<select name="page_name" class="page_dropdown">
		<?php
			if (($access_level == "restricted") || ($access_level == "blogger"))
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE restricted = 0 ORDER BY page_name";
			else
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_name = $row["page_name"];
				if ($page_name == $last_page_edited)
					$selected = " selected='selected'";
				else
					$selected = "";
				if ($page_name == "index")
					$home = " (Home)";
				else
					$home = "";
				
				echo "<option value='" . $page_name . "'" . $selected . ">" . $page_name . $home . "</option>";
			}
			
		?>
			</select>
		</p>
		<p align="center">
		  <input type="submit" name="Submit" value="Create" />
          <input type="hidden" name="mode" value="blog" />
		</p>
		</form>
     </td><td>
     <form name="frmEditBlog" method="post" action="edit_page.php">
     <p align="center">Select the post you want to edit: 
		<select name="blog_id" class="page_dropdown">
		<?php
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "blogs WHERE `owner`='" . $userid . "' ORDER BY revised";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$blog_id = $row["id"];
				$blog_page = $row["page_name"];
				$blog_revised = $row["revised"];
				if ($blog_id == $last_blog_edited)
					$selected = " selected='selected'";
				else
					$selected = "";
				
				echo "<option value='" . $blog_id . "'" . $selected . ">" . $blog_page . " " . $blog_revised . "</option>";
			}
			
		?>
		</select>
        </p>
        <p align="center">
       	<input type="submit" name="Submit" value="Edit" />
        <input type="hidden" name="mode" value="blog" />
        </p>
     </form>
     </td></tr></table>
</div>

    <div id="page_titles">
  <table border="0" width="100%">
		<tr>
			<td>
			  <form name="frmChangeTitle" method="post" action="save_page_title.php">
			  <p align="center">
			  Revise Default Site Title:<br>
			  <?php
				$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name = '_default_'";
			
				$result = $bwb_dbh->query($query);
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$title = $row["title"];
				$title = addslashes($title);
				echo "<input type='text' name='title' id='title' value='$title' size='40' />\r\n";
				?>
				</p>
				<p align="center">
				<input type="hidden" name="page_name" id="page_name" value="_default_" />
				<input type="submit" name="Submit2" value="Update" />
				</p>
			  </form>
	  		</td>
	  		<td>
			  <form name="frmChangePageTitles" method="post" action="save_page_title.php">
			  <p align="center">
			  Select a page to change the title of:<br>
			  <select name='page_name' id='page_name' OnChange="FillInPageTitle(this.options[this.selectedIndex].value);" class="page_dropdown">
			  <?php
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
				$result = $bwb_dbh->query($query);
				while ($row = $result->fetch(PDO::FETCH_ASSOC))
				{
					$page_name = $row["page_name"];
					$page_name = addslashes($page_name);
					if (($page_name == $selected_page_name) || (!$selected_page_name && !$page_selected))
					{
						echo "<option value='$page_name' selected='selected'>$page_name</option>\r\n";
						$query2 = "SELECT `title` FROM `" . BWB_TABLE_PREFIX . "page_titles` WHERE `page_name` = '" . $page_name . "'";
						$result2 = $bwb_dbh->query($query2);
						$row2 = $result2->fetch(PDO::FETCH_ASSOC);
						$title = $row2["title"];
						$title = addslashes($title);
						$page_selected = 1;
					}
					else
						echo "<option value='$page_name'>$page_name</option>\r\n";
				}
				?>
				</select>
				<input type='text' name='title' id='title' value='<?php echo $title; ?>' size='40' />
				</p>
				<p align="center">
				<input type="submit" name="Submit2" value="Update" />
				</p>
			  </form>
			</td>
	  	</tr>
	  </table>
	
</div>

     <div id="delete_restore_page">
	  
        <table align="center" border="0"><tr>
        <td align="center">Select the page you want to delete: 
            <select name="selectPageToDelete" id="selectPageToDelete" class="page_dropdown">
        <?php    
            $query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
            $result = $bwb_dbh->query($query);
            while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
                $page_name = $row["page_name"];
                echo "<option value='$page_name'>$page_name</option>";
            }
        ?>
            </select>
          </td>
          </tr>
          <tr>
            <td align="center"><input type="button" name="Submit" value="Delete" onClick="DeleteConfirm('page');"></td>
          </tr>
          </table>
      <hr/>
      <table><tr>
      <td>
     <p align="center">Select the blog post you want to delete: 
		<select name="selectBlogToDelete" id="selectBlogToDelete" class="page_dropdown">
		<?php
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "blogs WHERE `owner`='" . $userid . "' ORDER BY revised";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$blog_id = $row["id"];
				$blog_page = $row["page_name"];
				$blog_revised = $row["revised"];
				if ($blog_id == $last_blog_edited)
					$selected = " selected='selected'";
				else
					$selected = "";
				
				echo "<option value='" . $blog_id . "'" . $selected . ">" . $blog_page . " " . $blog_revised . "</option>";
			}
			
		?>
		</select>
        </p>
        </td>
        </tr>
        <tr>
            <td align="center"><input type="button" name="Submit" value="Delete" onClick="DeleteConfirm('blog');"></td>
          </tr>
		</table>
      <hr/>
	  <a href='restore_page_select.php' title='Restore Page'>Restore Page</a>
	  <br><br>
	 </div>
     
     <div id="meta_tags">
     	<p><a href="edit_meta_tags.php">Edit Meta-Tags</a></p>
     </div>
     
	 <div id="copy_rename_page">
	<form name="frmRenamePage" method="post" action="copy_rename_page.php">
	<p align="center">
        Copy
        <input name="copy_mode" type="radio" value="copy" checked="checked" onClick="EnableDisableCreateNewTemplateCheckbox(this.value);" />
        or Rename
        <input name="copy_mode" type="radio" value="rename" onClick="EnableDisableCreateNewTemplateCheckbox(this.value);" />
	   page
	  <select name="page_name" class="page_dropdown">
		<?php
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_name = $row["page_name"];
				echo "<option value='$page_name'>$page_name</option>";
			}
		?>
	  </select>
		to	
		<input type="text" name="new_name" />
	      <br>
          <label id="create_new_template_label">
	      <input type="checkbox" name="create_new_template" id="create_new_template">
	      Discard old page template and create new
          </label>
	</p>
		<p align="center">
		  <input type="submit" name="Submit" value="Copy/Rename" />
          <input type="hidden" name="overwrite" value="0" />
          <input type="hidden" name="overwrite_content_only" value="0" />
		</p>
	  </form>
	<span class="small_message">Note: Renaming page will NOT change any links that you have created.
	Menu items will be updated automatically, but you will need to change any
	links that exist on any pages to reference the new page name.</span>
</div>

     <div id="edit_border_area">
	 	<form name="frmSelectSpecialPage" method="post" action="edit_page.php">
		<p align="center">Select the border area you want to edit: 
			<select name="page_name">
		<?php
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_name = $row["page_name"];
				if ($page_name == $last_border_edited)
					echo "<option value='$page_name' selected='selected'>$page_name</option>";
				else
					echo "<option value='$page_name'>$page_name</option>";
			}
		?>
			</select>
		</p>
		<p align="center" border="0" width="100%">
		  <input type="submit" name="Submit" value="Edit" />
		  <input type="hidden" name="special" value="1" />
          <input type="hidden" name="mode" value="border" />
	    </p>
	   </form>
       <hr/>
	    <p align="center">
	      <a href="manage_special.php">Manage Custom Border Areas</a>
	    </p>
</div>
     
     <div id="edit_css">
         <form name="frmSelectStyleSheet" method="post" action="edit_css.php">
		<p align="center">Select the style sheet you want to edit:
		  <select name="style_sheet">
		    <?php
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets ORDER BY sort_order";
			$result = $bwb_dbh->query($query);
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$name = $row["name"];
				$description = $row["description"];
				if ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) === false))
				{
					$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$name'";
					$result2 = $bwb_dbh->query($query2);
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$description = $row2['description'] . " Styles";
				}
				if ($name == $last_style_sheet_edited)
					echo "<option value='$name' selected='selected'>$description</option>\n";
				else
					echo "<option value='$name'>$description</option>\n";
			}
		?>
        	<option value='custom' onClick="EditCustomCSS();">Custom Styles</option>
	      </select>
          <input type="hidden" name="goto_class" id="goto_class" value="<?php echo $last_class_edited; ?>" />
		</p>
		<p align="center" border="0" width="100%">
		  <input type="submit" name="Submit" value="Edit" />
	    </p>
	   </form>
</div>

     
     <div id="edit_menu_styles">
     	<p><a href="manage_menu.php" tile="Manage Menu Assignment">Manage Menu Assignment</a></p>
        <hr/>
      	<p><a href='edit_css_menu_params.php' title='Edit Menu Parameters'>Edit CSS-Menu Parameters</a></p>
        <p><a href='edit_css_menu_styles.php' title='Edit Menu Styles'>Edit CSS-Menu Styles</a></p>
        <hr/>
		<p><a href='edit_js_menu_params.php' title='Edit Menu Parameters'>Edit JavaScript-Menu Parameters</a></p>
        <p><a href='edit_js_menu_styles.php' title='Edit Menu Styles'>Edit JavaScript-Menu Styles</a></p> 
</div>

     <div id="edit_head">
     	<form name="frmSelectHeadContent" method="post" action="edit_head.php">
		<p align="center">Select the head content you want to edit:
		  <select name="head_name">
		    <?php
			$query = "SELECT head_name FROM " . BWB_TABLE_PREFIX . "head";
			$result = $bwb_dbh->query($query);
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$head_name = $row["head_name"];
				if ($head_name == $last_head_edited)
					echo "<option value='$head_name' selected='selected'>$head_name</option>";
				else
					echo "<option value='$head_name'>$head_name</option>";
			}
		?>
	      </select>
		</p>
		<p align="center" border="0" width="100%">
		  <input type="submit" name="Submit" value="Edit" />
	    </p>
	   </form>
       <hr/>
       <p align="center">
	      <a href="manage_head.php" title='Manage Head Content'>Manage Head Content</a>
       </p>
       <p align="center"><a href="edit_favicon.php">Edit Favicon</a></p>
</div>
     
<div id="admin_functions">
	<p><a href="users.php" title="Manage Users">Manage Users</a></p>
	<p><a href='options.php' title='Change Site Options'>Change Site Options</a></p>
  <p><a href='restrict_editing_access.php' title='Restrict Page Editing Access'>Restrict Page Editing Access</a></p>
  <hr/>
  <form name="frmPruneTable" method="post" action="prune_table.php">
	<p>Prune page edit backup table to 
	    <input name="prune_page_bkup_days" type="text" id="prune_page_bkup_days" value="30" size="4" />
	days<br>
	  <input type="submit" name="submit" id="prune_page_bkup_submit" value="Submit" />
	</p>
  </form>
  <hr/>
  <p><a href='prune_bkup_files.php' title='Prune CSS, site map, and menu JS backup files'>Prune CSS, site map, and JavaScript menu backup files</a></p>
  <hr />
  <p><a href='upload_plugin.php' title='Install Plugin'>Install Plugin</a></p>
  <hr/>
  Select the plugin you want to recall:<br />
  	<select name="recall_plugin" id="recall_plugin" style="width:400px;">
<?php
	$query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `deployed`=1 ORDER BY `sort_order`";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$id = $row["id"];
		$name = $row["name"];
		$description = $row["description"];
		if ($description == "")
			echo "<option value='$id'>$name</option>\n";
		else
			echo "<option value='$id'>$name - $description</option>\n";
	}
?>
 	</select><br />
    <input type="button" name="recall_plugin_submit" id="recall_plugin_submit" value="Recall" onClick="DeleteConfirm('recall_plugin');" />
  <hr />
  <p><a href="input_sql.php">Upgrade Table Structures</a></p>
<?php
	$document_root = getenv('DOCUMENT_ROOT');
	$html_index = $document_root . "/index.html";
	$construction = $document_root . "/construction.html";
	if (file_exists($html_index) && !file_exists($construction))
		$site_active = false;
	elseif (!file_exists($html_index) && file_exists($construction))
		$site_active = true;
?>
	<p><input type="button" name="activate_deactivate" value="<?php if ($site_active) echo "De-activate Website"; else  echo "Activate Website"; ?>" onClick="ActivateDeactivateConfirm();" /></p>
</div>

<div id="logout">
<form name="frmLogOut" method="post" action="index.php">
<p align="center">
  <input type="submit" name="Submit" value="Logout" />
</p>
</form>
</div>

<div id="help_button" onClick="OpenHelpWindow();">
&nbsp;
</div>

<div id="bwb_version">
<?php include ("version.php"); ?>
</div>

<div id="delete_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td colspan="2"><div id="delete_text">&nbsp;</div></td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="delete" id="delete" value="Yes" onClick="DeletePage();" /></td>
	<td align="center"><input type="button" name="hide_delete" value="No" onClick="HideDelete();" />
    </td>
  </tr>
</table>
</div>

<div id="activate_deactivate_confirm">
<table border="0" cellspacing="0" cellpadding="5" align="center">
<?php
	if ($site_active)
	{
?>
  <tr>
    <td colspan="2">Do you want to take your site off line?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="deactivate"value="Yes" onClick="window.location='activate_deactivate_site.php?activate=0';" /></td>
	<td align="center"><input type="button" name="activate" value="No" onClick="HideActivateDeactivate();" />
    </td>
  </tr>
<?php
	}
	else
	{
?>
  <tr>
    <td colspan="2">Do you want to take your site live?</td>
  </tr>
  <tr>
	<td align="center"><input type="button" name="activate" value="Yes" onClick="window.location='activate_deactivate_site.php?activate=1';" /></td>
	<td align="center"><input type="button" name="deactivate" value="No" onClick="HideActivateDeactivate();" />
    </td>
  </tr>
<?php
	}
?>

</table>
</div>

<script language="JavaScript"  type="text/javascript">
//alert(browser + " " + browser_version);
if ((browser == "Opera") || ((browser == "Explorer") && (browser_version < "10")))
{
	document.getElementById("content_label").style.top = "-25px";
	document.getElementById("menu_label").style.top = "-25px";
	document.getElementById("style_label").style.top = "-25px";
	document.getElementById("page_label").style.top = "-25px";
	document.getElementById("other_label").style.top = "-25px";
}
if ((browser == "Explorer") && (browser_version < "7"))
{
	document.getElementById("content_label").style.top = "0px";
	document.getElementById("menu_label").style.top = "0x";
	document.getElementById("style_label").style.top = "0px";
	document.getElementById("page_label").style.top = "0px";
	document.getElementById("other_label").style.top = "0px";
}
</script>
</body>
</html>
