<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/4/2009
// Added table prefix handling.  Added references to website files folder configurations.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
	
	include ("check_session.php");
	
	// Get last used indexes to preload add-new forms.
	function GetNextIndex($table_prefix, $dbh)
	{
		$query = "SELECT head_name FROM " . $table_prefix . "head ORDER BY head_name DESC";
		$result = $dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$head_name = $row["head_name"];
		
		$index = array();
		$i = 1;
		$index[0] = substr($head_name, strlen('head'));
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$head_name = $row["head_name"];
			$index[$i] = substr($head_name, strlen('head'));
			$i++;
		}
		sort($index);
		$index[$i-1] = $index[$i-1] + 1;
		$next_index = $index[$i-1];
			
		return $next_index;
	}
	
	$next_head = GetNextIndex(BWB_TABLE_PREFIX, $bwb_dbh);
	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Breeze Website Builder</title>

<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/manage_head.js"></script>

</head>

<body>
<p align="center" class="title">Head Content Assignment</p>
<table width="80%" border="1" align="center"><tr><td>
<span class="sub_title">Add Head Content</span>
<table width="100%" border="0" align="center">
<tr>
<td align="center">
  <form name="frmAddHead" method="post" action="add_head.php">
  head<input type="text" name="suffix" style="width:100px;" value="<?php echo $next_head; ?>" />
<br />
  <input type="submit" name="submit" value="Add Another Head Content" />
  </form>
</td>
</tr>
</table>
</td></tr></table>
<br />

<table width="80%" border="1" align="center"><tr><td>
<table width="100%" border="0" align="center">
<tr bgcolor="#CCCCCC">
  <td colspan="3"><span class="sub_title">Assign Head Content to Page</span></td></tr>
  <?php
  		$bgcolor = "#EEEEEE";
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data";
		$result = $bwb_dbh->query($query);
		$i = 1;
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$page_name = $row["page_name"];
			echo "<form name='frmAssign$i' method='post' action='assign_head.php'>\n";
			echo "<tr bgcolor='$bgcolor'>\n";
			echo "<td>$page_name</td>";
			
			/////////////////////////////////////////
			//Test to see if file already exists.
			$document_root = $_SERVER['DOCUMENT_ROOT'];
			if (BWB_BASE_DIR == '')
				$file_name = $document_root . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
			else
				$file_name = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
				
			if (!file_exists($file_name))
			{
				echo "Error: $file_name does not exists.  Click <a href=\"manage_special.php\" title=\"here\">here</a> to return to the area assignment page.";
				exit;
			}
	
			// Read file.
			$fh = fopen($file_name, 'r') or die("Can't read $file_name: $php_errormsg");
			$contents = fread($fh, filesize($file_name));
			fclose($fh) or die($php_errormsg);
		
			$search_str_head = "head_name='head";
		
			$start_pos = strpos($contents, $search_str_head, 1);
			$end_pos = strpos($contents, "\"", $start_pos) - 1;
			$start_pos = $start_pos + strlen("head_name='");
			$head_str = substr($contents, $start_pos, $end_pos - $start_pos);
			////////////////////////////////////
			
			echo "<td>\n";
			echo "<select name=\"head_name\">\n";
			$query2 = "SELECT head_name FROM " . BWB_TABLE_PREFIX . "head";
			$result2 = $bwb_dbh->query($query2);
			while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
			{
				$head_name = $row2["head_name"];
				if ($head_name == $head_str)
					echo "<option value='$head_name' selected='selected'>$head_name</option>\n";
				else
					echo "<option value='$head_name'>$head_name</option>\n";
			}
			echo "</select>\n";
			echo "</td>\n";
			
			echo "<td>\n";
			echo "<input type='submit' name='submit' value='Assign' />\n";
			echo "<input type='hidden' name='page_name' value='$page_name' />\n";
			echo "</td>\n";
			echo "</tr>\n";
			echo "</form>";
			$i++;
			if ($bgcolor == "#EEEEEE")
				$bgcolor = "#DDDDDD";
			else
				$bgcolor = "#EEEEEE";
		}
   ?>
</table>
</td></tr></table>
<br />

	<table width="80%" border="1" align="center"><tr><td>
    
	<table width="100%" align="center" border="0">
      <tr>
      	<td class="sub_title">Rename Head Content</td>
      	<td class="sub_title">Delete Head Content</td>
      </tr>
      <tr>
        <td>
          <form name="frmRename" method="post" action="rename_head.php">
      	  <table width="100%" align="center" border="0">
      		<tr>
              <td align="right">Select head content to rename: </td>
              <td>
                <select name="head_old_name" id="head_old_name">
            <?php
                $query = "SELECT head_name FROM " . BWB_TABLE_PREFIX . "head ORDER BY head_name";
                $result = $bwb_dbh->query($query);
                while($row = $result->fetch(PDO::FETCH_ASSOC))
                {
                    $head_name = $row["head_name"];
                    if ($head_name != "head")
					{
                        echo "<option value='$head_name'>$head_name</option>\n";
					}
                }
            ?>
                </select>
              </td>
              <td align="right">New name: </td>
              <td align="right" style="width:60px;">
              <div id="name_prefix_display">head_</div>
              <input type="hidden" name="name_prefix" id="name_prefix" value="head_" />
              </td>
              <td><input type="text" name="name_suffix" id="name_suffix" style="width:100px;" /></td>
              <td align="center">
              <input type="submit" name="Submit" value="Rename" />
              </td>
			</tr>
         </table>
         </form>
      </td>
      
      <td>
      <table>
      <tr>
      
	  <td align="center">Select  head content  to delete: </td>
	  <td>
		<select name="head_name" id="head_name">
	<?php
		$query = "SELECT head_name FROM " . BWB_TABLE_PREFIX . "head";
		$result = $bwb_dbh->query($query);
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$head_name = $row["head_name"];
			if (($head_name != "head") && ($head_name != ""))
				echo "<option value='$head_name'>$head_name</option>";
		}
	?>
		</select>
	  </td>
	  <td align="center">
	  <input type="button" name="delete" value="Delete" onclick="DeleteConfirm();">
	  </td>
      
      </tr>
      </table>
     </td>
     
	</tr></table>
    
    </td></tr></table>

<br />
<table width="80%" border="0" cellspacing="0" cellpadding="0">
  <tr>
  <td align="center">
  <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=head';">
  </td>
  <td valign="top" align="right" width="10%">
      <div id="help_button" onClick="OpenHelpWindow();">
        &nbsp;
      </div>
  </td>
  </tr>
</table>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
</script>
</body>
</html>