<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/3/2009
// Rezised: 6/29/2009	ELL
// Fixed bug of assignments corrupting templates that do not have all 4: top, bottom, left and right sections.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added references to website files folder configurations.
// Revised: 5/10/2013	ELL
// Added new areas header and footer.  Headers go above the top cell and footers go below the bottom cell.
// Revised: 6/24/2013	ELL
// Added ability to specify meaningful names.
// Revised: 7/1/2013	ELL
// Implemented popup message class.

	
	include ("check_session.php");
	
	// Get last used indexes to preload add-new forms.
	function GetNextIndex($area_type, $table_prefix, $dbh)
	{
		$query = "SELECT page_name FROM " . $table_prefix . "page_data_special WHERE page_name LIKE '". $area_type . "%' ORDER BY page_name DESC";
		$result = $dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$page_name = $row["page_name"];
		
		$index = array();
		$i = 1;
		$index[0] = substr($page_name, strlen($area_type));
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$page_name = $row["page_name"];
			$index[$i] = substr($page_name, strlen($area_type));
			$i++;
		}
		sort($index);
		$index[$i-1] = $index[$i-1] + 1;
		$next_index = $index[$i-1];
			
		return $next_index;
	}
	
	function GetAreaFromName($page_name)
	{
		switch (substr($page_name, 0, 1))	{
		case 't':
			$initial_prefix = "top_";
			break;
		case 'b':
			$initial_prefix = "bottom_";
			break;
		case 'l':
			$initial_prefix = "left_";
			break;
		case 'r':
			$initial_prefix = "right_";
			break;
		case 'h':
			$initial_prefix = "header_";
			break;
		case 'f':
			$initial_prefix = "footer_";
			break;
		}
		
		return($initial_prefix);
	}
	
	$area_type = "right";
	$next_right = GetNextIndex($area_type, BWB_TABLE_PREFIX, $bwb_dbh);
	$area_type = "left";
	$next_left = GetNextIndex($area_type, BWB_TABLE_PREFIX, $bwb_dbh);
	$area_type = "top";
	$next_top = GetNextIndex($area_type, BWB_TABLE_PREFIX, $bwb_dbh);
	$area_type = "bottom";
	$next_bottom = GetNextIndex($area_type, BWB_TABLE_PREFIX, $bwb_dbh);
	$area_type = "header";
	$next_header = GetNextIndex($area_type, BWB_TABLE_PREFIX, $bwb_dbh);
	$area_type = "footer";
	$next_footer = GetNextIndex($area_type, BWB_TABLE_PREFIX, $bwb_dbh);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Breeze Website Builder</title>

<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style>
#help_button	{
	top:30px;
	right:20px;
}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/manage_special.js"></script>

</head>

<body>
<p align="center" class="title">Special Area Assignment</p>
<div id="help_button" onClick="OpenHelpWindow();">
&nbsp;
</div>
<table width="80%" border="1" align="center"><tr><td>
<span class="sub_title">Add Special Area</span>
<table width="100%" border="0" align="center">
<tr>
<td align="center">
<form name="frmAddRight" method="post" action="add_special.php">
right<input type="text" name="suffix" style="width:100px;" value="<?php echo $next_right; ?>" />
<br />
<input type="submit" name="submit" value="Add Another Right Area" />
<input type="hidden" name="area_type" value="right" />
</form>
</td>
<td align="center">
<form name="frmAddLeft" method="post" action="add_special.php">
left<input type="text" name="suffix" style="width:100px;" value="<?php echo $next_left; ?>"/>
<br />
<input type="submit" name="submit" value="Add Another Left Area" />
<input type="hidden" name="area_type" value="left" />
</form>
</td>
<td align="center">
<form name="frmTop" method="post" action="add_special.php">
top<input type="text" name="suffix" style="width:100px;" value="<?php echo $next_top; ?>"/>
<br />
<input type="submit" name="submit" value="Add Another Top Area" />
<input type="hidden" name="area_type" value="top" />
</form>
</td>
<td align="center">
<form name="frmBottom" method="post" action="add_special.php">
bottom<input type="text" name="suffix" style="width:100px;" value="<?php echo $next_bottom; ?>" />
<br />
<input type="submit" name="submit" value="Add Another Bottom Area" />
<input type="hidden" name="area_type" value="bottom" />
</form>
</td>
<td align="center">
<form name="frmHeader" method="post" action="add_special.php">
header<input type="text" name="suffix" style="width:100px;" value="<?php echo $next_header; ?>" />
<br />
<input type="submit" name="submit" value="Add Another Header Area" />
<input type="hidden" name="area_type" value="header" />
</form>
</td>
<td align="center">
<form name="frmFooter" method="post" action="add_special.php">
footer<input type="text" name="suffix" style="width:100px;" value="<?php echo $next_footer; ?>" />
<br />
<input type="submit" name="submit" value="Add Another Footer Area" />
<input type="hidden" name="area_type" value="footer" />
</form>
</td>

</tr>
</table>
</td></tr></table>
<br />

<table width="80%" border="1" align="center"><tr><td>
<table width="100%" border="0" align="center">
<tr bgcolor="#CCCCCC"><td colspan="8"><span class="sub_title">Assign Special Area to Page</span></td></tr>
  <?php
  		$bgcolor = "#EEEEEE";
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
		$result = $bwb_dbh->query($query);
		$i = 1;
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$page_name = $row["page_name"];
			echo "<form name='frmAssign$i' method='post' action='assign_special.php'>\n";
			echo "<tr bgcolor='$bgcolor'>\n";
			echo "<td>$page_name</td>";
			
			/////////////////////////////////////////
			//Test to see if file already exists.
			$document_root = $_SERVER['DOCUMENT_ROOT'];
			if (BWB_BASE_DIR == '')
				$file_name = $document_root . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
			else
				$file_name = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
			
			if (!file_exists($file_name))
			{
				echo "Error: $file_name does not exists.  Click <a href=\"manage_special.php\" title=\"here\">here</a> to return to the area assignment page.";
				exit;
			}
	
			// Read file.
			$fh = fopen($file_name, 'r') or die("Can't read $file_name: $php_errormsg");
			$contents = fread($fh, filesize($file_name));
			fclose($fh) or die($php_errormsg);
		
			$search_str_right = "page_name='right";
			$search_str_left = "page_name='left";
			$search_str_top = "page_name='top";
			$search_str_bottom = "page_name='bottom";
			$search_str_header = "page_name='header";
			$search_str_footer = "page_name='footer";
		
			$start_pos = strpos($contents, $search_str_right, 1);
			if ($start_pos !== false)
			{
				$end_pos = strpos($contents, "\"", $start_pos) - 1;
				$start_pos = $start_pos + strlen("page_name='");
				$right_str = substr($contents, $start_pos, $end_pos - $start_pos);
			}
			else
				$right_str = "-na-";
			
			$start_pos = strpos($contents, $search_str_left, 1);
			if ($start_pos !== false)
			{
				$end_pos = strpos($contents, "\"", $start_pos) - 1;
				$start_pos = $start_pos + strlen("page_name='");
				$left_str = substr($contents, $start_pos, $end_pos - $start_pos);
			}
			else
				$left_str = "-na-";
			
			$start_pos = strpos($contents, $search_str_top, 1);
			if ($start_pos !== false)
			{
				$end_pos = strpos($contents, "\"", $start_pos) - 1;
				$start_pos = $start_pos + strlen("page_name='");
				$top_str = substr($contents, $start_pos, $end_pos - $start_pos);
			}
			else
				$top_str = "-na-";
			
			$start_pos = strpos($contents, $search_str_bottom, 1);
			if ($start_pos !== false)
			{
				$end_pos = strpos($contents, "\"", $start_pos) - 1;
				$start_pos = $start_pos + strlen("page_name='");
				$bottom_str = substr($contents, $start_pos, $end_pos - $start_pos);
			}
			else
				$bottom_str = "-na-";
				
			$start_pos = strpos($contents, $search_str_header, 1);
			if ($start_pos !== false)
			{
				$end_pos = strpos($contents, "\"", $start_pos) - 1;
				$start_pos = $start_pos + strlen("page_name='");
				$header_str = substr($contents, $start_pos, $end_pos - $start_pos);
			}
			else
				$header_str = "-na-";
				
			$start_pos = strpos($contents, $search_str_footer, 1);
			if ($start_pos !== false)
			{
				$end_pos = strpos($contents, "\"", $start_pos) - 1;
				$start_pos = $start_pos + strlen("page_name='");
				$footer_str = substr($contents, $start_pos, $end_pos - $start_pos);
			}
			else
				$footer_str = "-na-";
			////////////////////////////////////
			
			echo "<td>\n";
			if ($right_str != "-na-")
			{
				echo "<select name=\"right_area_name\">\n";
				$query2 = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
				$result2 = $bwb_dbh->query($query2);
				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$area_name = $row2["page_name"];
					if ($area_name == $right_str)
						echo "<option value='$area_name' selected='selected'>$area_name</option>\n";
					elseif(substr($area_name,0,3) == "rig")
						echo "<option value='$area_name'>$area_name</option>\n";
				}
				echo "</select>\n";
			}
			else
				echo "-na-";
			echo "</td>\n";
			
			echo "<td>\n";
			if ($left_str != "-na-")
			{
				echo "<select name=\"left_area_name\">\n";
				$query2 = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
				$result2 = $bwb_dbh->query($query2);
				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$area_name = $row2["page_name"];
					if ($area_name == $left_str)
						echo "<option value='$area_name' selected='selected'>$area_name</option>\n";
					elseif(substr($area_name,0,3) == "lef")
						echo "<option value='$area_name'>$area_name</option>\n";
				}
				echo "</select>\n";
			}
			else
				echo "-na-";
			echo "</td>\n";
			
			echo "<td>\n";
			if ($top_str != "-na-")
			{
				echo "<select name=\"top_area_name\">\n";
				$query2 = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
				$result2 = $bwb_dbh->query($query2);
				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$area_name = $row2["page_name"];
					if ($area_name == $top_str)
						echo "<option value='$area_name' selected='selected'>$area_name</option>\n";
					elseif(substr($area_name,0,3) == "top")
						echo "<option value='$area_name'>$area_name</option>\n";
				}
				echo "</select>\n";
			}
			else
				echo "-na-";
			echo "</td>\n";
			
			echo "<td>\n";
			if ($bottom_str != "-na-")
			{
				echo "<select name=\"bottom_area_name\">\n";
				$query2 = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
				$result2 = $bwb_dbh->query($query2);
				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$area_name = $row2["page_name"];
					if ($area_name == $bottom_str)
						echo "<option value='$area_name' selected='selected'>$area_name</option>\n";
					elseif(substr($area_name,0,3) == "bot")
						echo "<option value='$area_name'>$area_name</option>\n";
				}
						}
			else
				echo "-na-";
			echo "</select>\n";
			echo "</td>\n";
			
			echo "<td>\n";
			if ($header_str != "-na-")
			{
				echo "<select name=\"header_area_name\">\n";
				$query2 = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
				$result2 = $bwb_dbh->query($query2);
				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$area_name = $row2["page_name"];
					if ($area_name == $header_str)
						echo "<option value='$area_name' selected='selected'>$area_name</option>\n";
					elseif(substr($area_name,0,3) == "hea")
						echo "<option value='$area_name'>$area_name</option>\n";
				}
						}
			else
				echo "-na-";
			echo "</select>\n";
			echo "</td>\n";
			
			echo "<td>\n";
			if ($footer_str != "-na-")
			{
				echo "<select name=\"footer_area_name\">\n";
				$query2 = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
				$result2 = $bwb_dbh->query($query2);
				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$area_name = $row2["page_name"];
					if ($area_name == $footer_str)
						echo "<option value='$area_name' selected='selected'>$area_name</option>\n";
					elseif(substr($area_name,0,3) == "foo")
						echo "<option value='$area_name'>$area_name</option>\n";
				}
						}
			else
				echo "-na-";
			echo "</select>\n";
			echo "</td>\n";
			
			echo "<td>\n";
			echo "<input type='submit' name='submit' value='Assign' />\n";
			echo "<input type='hidden' name='page_name' value='$page_name' />\n";
			echo "</td>\n";
			echo "</tr>\n";
			echo "</form>";
			$i++;
			if ($bgcolor == "#EEEEEE")
				$bgcolor = "#DDDDDD";
			else
				$bgcolor = "#EEEEEE";
		}
   ?>
</table>
</td></tr></table>
<br />
	<table width="80%" border="1" align="center"><tr><td>
    
	<table width="100%" align="center" border="0">
      <tr>
        <td>
        	<span class="sub_title">Rename Special Area</span>
        </td>
        <td>
            <span class="sub_title">Delete Special Area</span>
        </td>
      </tr>
      <tr>
      	<td>
          <form name="frmRename" method="post" action="rename_special.php">
      	  <table width="100%" align="center" border="0">
      		<tr>
              <td align="right">Select  border area  to rename: </td>
              <td>
                <select name="area_old_name" id="area_old_name" onchange="var prefix=GetAreaFromName(this.value); document.getElementById('name_prefix_display').innerHTML=prefix; document.getElementById('name_prefix').value=prefix;">
            <?php
                $query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
                $result = $bwb_dbh->query($query);
                while($row = $result->fetch(PDO::FETCH_ASSOC))
                {
                    $page_name = $row["page_name"];
                    if (($page_name != "top") && ($page_name != "bottom") && ($page_name != "left") && ($page_name != "right") && ($page_name != "header") && ($page_name != "footer"))
					{
                        echo "<option value='$page_name'>$page_name</option>\n";
						if (!isset($initial_prefix))
							$initial_prefix = GetAreaFromName($page_name);
					}
                }
            ?>
                </select>
              </td>
              <td align="right">New name: </td>
              <td align="right" style="width:60px;">
              <div id="name_prefix_display"><?php echo $initial_prefix; ?></div>
              <input type="hidden" name="name_prefix" id="name_prefix" value="<?php echo $initial_prefix; ?>" />
              </td>
              <td><input type="text" name="name_suffix" id="name_suffix" style="width:100px;" /></td>
              <td align="center">
              <input type="submit" name="Submit" value="Rename" />
              </td>
			</tr>
         </table>
         </form>
      </td>
      <td>
        <table width="100%" align="center" border="0">
      		<tr>
              <td align="right">Select  border area  to delete: </td>
              <td>
                <select name="area_name" id="area_name">
            <?php
                $query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special ORDER BY page_name";
                $result = $bwb_dbh->query($query);
                while($row = $result->fetch(PDO::FETCH_ASSOC))
                {
                    $page_name = $row["page_name"];
                    if (($page_name != "top") && ($page_name != "bottom") && ($page_name != "left") && ($page_name != "right") && ($page_name != "header") && ($page_name != "footer"))
                        echo "<option value='$page_name'>$page_name</option>\n";
                }
            ?>
                </select>
              </td>
              <td align="center">
              <input type="button" name="Submit" value="Delete" onclick="DeleteConfirm();">
              </td>
            </tr>
        </table>
    
       </td>
     </tr>
    </table>
    
    </td></tr></table>

<br />
<table width="80%" border="0" cellspacing="0" cellpadding="0">
  <tr><td align="right">
  <input type="button" name="Back" value="Back to Main Menu" onClick="window.location.href='main.php?mode=border';">
  </td></tr>
</table>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
</script>


</body>
</html>