<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/23/2009		ELL
// Revised: 11/11/2009	ELL
// Added options for proportional item widths.
// Modified: 1/6/2010		ELL
// Added z-indexing to fix bug of sublevels not popping above main level upon hover.
// Modified: 10/7/2010		ELL
// Added text align.
// Modified: 2/4/2012	ELL
// Added selection for having sub menus collapse and expand.  Default is to collapse and expand.  New option is to show always expanded.
// Revised: 2/10/2012	ELL
// Added table prefix handling.  Added references to CSS folder configurations.
// Revised: 6/19/2013	ELL
// Added separate text alignment for sub menus.
// Revised: 7/21/2013	ELL
// Fixed bug with opacity being left at 0 if menu freshly cerated.
// Revised: 12/16/2013	ELL
// Added ability to specify bottom and right offsets as well as manually editing positioning.
// 
//
//
	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	$suffix = substr($menu, 4);
	$site_css_table = $menu . "_css";
	$css_file = $menu . ".css";


	if (isset($_POST["OrientationGroup"])) $orientation = $_POST["OrientationGroup"];
	else $orientation = "horizontal_fixed_width";
	if (isset($_POST["PositionGroup"])) $position = $_POST["PositionGroup"];
	else $position = "absolute";
	if (is_numeric($_POST["menu_top"])) $menu_top = $_POST["menu_top"];
	else $menu_top = -1000000;
	if (is_numeric($_POST["menu_left"])) $menu_left = $_POST["menu_left"];
	else $menu_left = -1000000;
	if (is_numeric($_POST["menu_bottom"])) $menu_bottom = $_POST["menu_bottom"];
	else $menu_bottom = -1000000;
	if (is_numeric($_POST["menu_right"])) $menu_right = $_POST["menu_right"];
	else $menu_right = -1000000;
	if (is_numeric($_POST["menu_width"])) $menu_width = $_POST["menu_width"];
	else $menu_width = 100;
	if (is_numeric($_POST["menu_width_units"])) $menu_width_units = $_POST["menu_width_units"];
	else $menu_width_units = 1;
	if (is_numeric($_POST["top_level_item_width"])) $top_level_item_width = $_POST["top_level_item_width"];
	else $top_level_item_width = -1;
	if (is_numeric($_POST["top_level_item_width_units"])) $top_level_item_width_units = $_POST["top_level_item_width_units"];
	else $top_level_item_width_units = 0;
	if (is_numeric($_POST["top_level_item_height"])) $top_level_item_height = $_POST["top_level_item_height"];
	else $top_level_item_height = -1;
	if (is_numeric($_POST["top_level_item_height_units"])) $top_level_item_height_units = $_POST["top_level_item_height_units"];
	else $top_level_item_height_units = 0;
	if (isset($_POST["top_level_text_align"])) $top_level_text_align = $_POST["top_level_text_align"];
	else $top_level_text_align = "-not selected-";
	if (is_numeric($_POST["top_level_padding_top"])) $top_level_padding_top = $_POST["top_level_padding_top"];
	else $top_level_padding_top = 2;
	if (is_numeric($_POST["top_level_padding_right"])) $top_level_padding_right = $_POST["top_level_padding_right"];
	else $top_level_padding_right = 8;
	if (is_numeric($_POST["top_level_padding_bottom"])) $top_level_padding_bottom = $_POST["top_level_padding_bottom"];
	else $top_level_padding_bottom = 2;
	if (is_numeric($_POST["top_level_padding_left"])) $top_level_padding_left = $_POST["top_level_padding_left"];
	else $top_level_padding_left = 8;
	if (is_numeric($_POST["sub_level_offset_top"])) $sub_level_offset_top = $_POST["sub_level_offset_top"];
	else $sub_level_offset_top = 0;
	if (is_numeric($_POST["sub_level_offset_left"])) $sub_level_offset_left = $_POST["sub_level_offset_left"];
	else $sub_level_offset_left = 140;
	if (is_numeric($_POST["sub_level_item_width"])) $sub_level_item_width = $_POST["sub_level_item_width"];
	else $sub_level_item_width = 140;
	if (is_numeric($_POST["sub_level_item_width_units"])) $sub_level_item_width_units = $_POST["sub_level_item_width_units"];
	else $sub_level_item_width_units = 0;
	if (is_numeric($_POST["sub_level_item_height"])) $sub_level_item_height = $_POST["sub_level_item_height"];
	else $sub_level_item_height = -1;
	if (is_numeric($_POST["sub_level_item_height_units"])) $sub_level_item_height_units = $_POST["sub_level_item_height_units"];
	else $sub_level_item_height_units = 0;
	if (is_numeric($_POST["sub_level_padding_top"])) $sub_level_padding_top = $_POST["sub_level_padding_top"];
	else $sub_level_padding_top = 2;
	if (is_numeric($_POST["sub_level_padding_right"])) $sub_level_padding_right = $_POST["sub_level_padding_right"];
	else $sub_level_padding_right = 10;
	if (is_numeric($_POST["sub_level_padding_bottom"])) $sub_level_padding_bottom = $_POST["sub_level_padding_bottom"];
	else $sub_level_padding_bottom = 2;
	if (is_numeric($_POST["sub_level_padding_left"])) $sub_level_padding_left = $_POST["sub_level_padding_left"];
	else $sub_level_padding_left = 10;
	if (isset($_POST["sub_level_text_align"])) $sub_level_text_align = $_POST["sub_level_text_align"];
	else $sub_level_text_align = "-not selected-";
	if (isset($_POST["proportional_width_top"])) $proportional_width_top = $_POST["proportional_width_top"];
	else $proportional_width_top = 0;
	if (isset($_POST["proportional_width_sub"])) $proportional_width_sub = $_POST["proportional_width_sub"];
	else $proportional_width_sub = 0;
	if (isset($_POST["sub_level_collapse"])) $sub_level_collapse = true;
	else $sub_level_collapse = false;
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		if ($orientation == "vertical")
			$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, padding_top=0, padding_right=0, padding_bottom=0,"
			. " padding_left=0, margin_top=0, margin_right=0, margin_left=0, margin_bottom=0, display='-not selected-',"
			. " list_style_type='none', bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
		else
			$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, padding_top=0, padding_right=0, padding_bottom=0,"
			. " padding_left=0, margin_top=0, margin_right=0, margin_left=0, margin_bottom=0, display='inline', "
			. "list_style_type='none', bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	}
	else
	{
		//Insert new data into table.	Note: border set to -2 to indicate first time setup.  This triggers loading of default styles.
		if ($orientation == "vertical")
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . ", .nav" . $suffix . " ul', use_table_data=1, padding_top=0,"
			. " padding_right=0, padding_bottom=0, padding_left=0, margin_top=0, margin_right=0, margin_left=0, margin_bottom=0,"
			. " display='-not selected-', list_style_type='none', border=-2, bkgd_opacity=-1";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . ", .nav" . $suffix . " ul', use_table_data=1, padding_top=0,"
			. " padding_right=0, padding_bottom=0, padding_left=0, margin_top=0, margin_right=0, margin_left=0, margin_bottom=0,"
			. " display='inline', list_style_type='none', border=-2, bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = 'ul.nav" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		if ($orientation == "horizontal_variable_width")
			$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, display='table', width=". $menu_width . ", width_units="
			. $menu_width_units . ", table_layout='fixed', align='" . $top_level_text_align . "', bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . "'";
		else
			$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, display='table', width=-1, table_layout='-not selected-', align='" . $top_level_text_align . "'"
			. ", bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		if ($orientation == "horizontal_variable_width")
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . "', use_table_data=1, display='table', width=" 
			. $menu_width . ", width_units=" . $menu_width_units . ", align='" . $top_level_text_align . "', table_layout='fixed', bkgd_opacity=-1";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . "', use_table_data=1, display='table', width=-1, table_layout='-not selected-', align='" . $top_level_text_align . "', bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = 'ul.nav" . $suffix . ">li'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		if ($orientation == "vertical")
			$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, padding_top=" . $top_level_padding_top 
			. ", padding_right=" . $top_level_padding_right
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_left=" . $top_level_padding_left
			. ", width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", position='relative', display='-not selected-', bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . ">li'";
		else
			$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, padding_top=" . $top_level_padding_top 
			. ", padding_right=" . $top_level_padding_right
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_left=" . $top_level_padding_left
			. ", width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", position='relative', display='table-cell', bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . ">li'";
	}
	else
	{
		//Insert new data into table.
		if ($orientation == "vertical")
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . ">li', use_table_data=1, padding_top=" 
			. $top_level_padding_top . ", padding_right=" . $top_level_padding_right
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_left=" . $top_level_padding_left
			. ", width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", position='relative', display='-not selected-', z_index=5, bkgd_opacity=-1";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . ">li', use_table_data=1, padding_top=" 
			. $top_level_padding_top . ", padding_right=" . $top_level_padding_right
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_left=" . $top_level_padding_left
			. ", width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", position='relative', display='table-cell', z_index=5, bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = 'ul.nav" . $suffix . " li>ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($sub_level_collapse == true)
		$position_display_str = "position='absolute', display='none'";
	else
		$position_display_str = "position='', display=''";
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, margin_top=" . $sub_level_offset_top . ", margin_left=" . $sub_level_offset_left
		. ", " . $position_display_str . ", width=" . $sub_level_item_width . ", width_units=" . $sub_level_item_width_units
		. ", line_height=" . $sub_level_item_height . ",   	line_height_units=" . $sub_level_item_height_units . ", bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . " li>ul'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . " li>ul', use_table_data=1, margin_top=" . $sub_level_offset_top . ", margin_left=" . $sub_level_offset_left
		. ", " . $position_display_str . ", width=" . $sub_level_item_width . ", width_units=" . $sub_level_item_width_units
		. ", line_height=" . $sub_level_item_height . ",   	line_height_units=" . $sub_level_item_height_units . ", bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = 'ul.nav" . $suffix . " li:hover>ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, display='block', bkgd_opacity=-1 WHERE class='ul.nav" . $suffix . " li:hover>ul'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='ul.nav" . $suffix . " li:hover>ul', use_table_data=1, display='block', bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.nav" . $suffix . " ul li a'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, padding_top=" . $sub_level_padding_top . ", padding_right="
		. $sub_level_padding_right . ", padding_bottom=" . $sub_level_padding_bottom . ", padding_left=" . $sub_level_padding_left
		. ", display='block', bkgd_opacity=-1 WHERE class='.nav" . $suffix . " ul li a'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='.nav" . $suffix . " ul li a', use_table_data=1, padding_top=" . $sub_level_padding_top
		. ", padding_right="
		. $sub_level_padding_right . ", padding_bottom=" . $sub_level_padding_bottom . ", padding_left=" . $sub_level_padding_left
		. ", display='block', bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.menu_div" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, position='" . $position
		. "', position_top=" . $menu_top . ", position_top_units=0, position_left=" . $menu_left
		. ", position_left_units=0, position_bottom='" . $menu_bottom . "', position_bottom_units=0, position_right='" 
		. $menu_right . "', position_right_units=0, display='block', bkgd_opacity=-1 WHERE class='.menu_div" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='.menu_div" . $suffix 
		. "', use_table_data=1, position='" . $position . "',"
		. " position_top=" . $menu_top . ", position_top_units=0, position_left=" . $menu_left
		. ", position_left_units=0, position_bottom='" . $menu_bottom . "', position_bottom_units=0, position_right='" 
		. $menu_right . "', display='block', bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, align='" . $sub_level_text_align . "', bkgd_opacity=-1 WHERE class='.sub_level_1_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='.sub_level_1_a" . $suffix . "', use_table_data=1, align='" . $sub_level_text_align . "', bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.sub_level_2_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . $site_css_table . " SET use_table_data=1, align='" . $sub_level_text_align . "', bkgd_opacity=-1 WHERE class='.sub_level_2_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $site_css_table . " SET class='.sub_level_2_a" . $suffix . "', use_table_data=1, align='" . $sub_level_text_align . "', bkgd_opacity=-1";
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	//Update menu list for proportional widths.
	$query = "UPDATE " . BWB_TABLE_PREFIX . "menus SET proportional=" . $proportional_width_top . ", proportional_sub=" . $proportional_width_sub . " WHERE menu_name='" . $menu . "'";
	$cnt = $bwb_dbh->exec($query);


	/////////////////////////////////////////////
	// Build string for site.css file /////
	include("build_css_string.php");
			

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo "Could not rename $file_name to $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	header("Location: edit_css_menu_params.php?menu=$menu");	
		
?>
