<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	11/28/2013	ELL
// Revised: 5/27/2016	ELL
// Added lockout of Copy Style Sheet to Mobile.
// Added warning messages about working on menu CSS in CSS editor, and notice about display:list-item; for menus items.
// 

	include ("check_session.php");
	
	$last_style_sheet_edited = $_SESSION['last_style_sheet_edited'];
	$last_class_edited = $_SESSION['last_class_edited'];
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'LockoutCopyStyleSheetToMobile'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$LockoutCopyStyleSheetToMobile = $row['option_value'];
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Edit CSS Select | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<style>
#copy_to_mobile_btn	{
	display:block;
	position:absolute;
	top:50px;
	left:400px;
	cursor:pointer;
}
</style>

<script src="js/edit_css_select.js"></script>
</head>

<body>
<div id="sub_level_1_buttons">
        
          <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_SELECT_HEADING; ?></div><div class="button_heading_help" onClick="OpenHelpWindow('edit_css');">&nbsp;</div></div>
		    <?php
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets ORDER BY sort_order";
			$result = $bwb_dbh->query($query);
			$i = 1;
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$name = $row["name"];
				$description = $row["description"];
				if ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) === false))
				{
					$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$name'";
					$result2 = $bwb_dbh->query($query2);
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$description = $row2['description'] . " Styles";
				}
				elseif ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) !== false))
				{
					$tmp_name = str_replace("_item", "", $name);
					$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$tmp_name'";
					$result2 = $bwb_dbh->query($query2);
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$description = $row2['description'] . " Item Styles";
				}
				
				if ($name == $last_style_sheet_edited)
					$selected = " down_sub";
				else
					$selected = "";
					
				$warning = "";
				$warning_code = "";
				if ((strpos($name, "menu") !== false) && (strpos($name, "_item") === false))
					$warning = " <div class='css_warning' id='warning_$i'>" . EDIT_CSS_SELECT_MENU_WARNING . "</div>\n";
				elseif ((strpos($name, "menu") !== false) && (strpos($name, "_item") !== false))
					$warning = " <div class='css_warning' id='warning_$i'>" . EDIT_CSS_SELECT_MENU_ITEM_WARNING . "</div>\n";
				$top = $i * 31;
				if (strpos($name, "menu") !== false)
					$warning_code = " onmouseover=\"document.getElementById('warning_$i').style='display:block; top:" . $top . "px;';\" onmouseout=\"document.getElementById('warning_$i').style='display:none;';\"";

				echo "<div class='button_sub_level_1$selected' onClick=\"window.location='edit_css.php?style_sheet=$name&goto_class=$last_class_edited';\"$warning_code><span class='button_text_sub_level_1'>$description</span></div>$warning\n";
				$i++;
			}
		?>
        	
          <div class='button_sub_level_1' onClick="window.location='edit_custom_css.php?style_sheet=site';"><span class='button_text_sub_level_1'><?php echo EDIT_CSS_SELECT_CUSTOM_STYLES_BTN; ?></span></div>
          <div class='button_sub_level_1' onClick="window.location='edit_custom_css.php?style_sheet=site_mobile';"><span class='button_text_sub_level_1'><?php echo EDIT_CSS_SELECT_CUSTOM_MOBILE_STYLES_BTN; ?></span></div>
          
</div>

<?php if (($access_level == "admin") && ($LockoutCopyStyleSheetToMobile != 1))	{	?>
<div class="button_heading_sub_level_1" id="copy_to_mobile_btn"><div class="button_heading_text_sub_level_1" onClick="window.location='copy_css_to_mobile_select.php';"><?php echo EDIT_CSS_SELECT_COPY_STYLES_TO_MOBILE_BTN; ?></div><div class="button_heading_help" onClick="OpenHelpWindow('copy_css_to_mobile');" style="left:210px;">&nbsp;</div></div>
<?php }	?>

</body>
</html>