<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/13/2013
// Modified: 3/22/2014	ELL
// Added graceful handling of allow_url_fopen not set.
// Modified: 4/24/2015	ELL
// Added automatic 1-click update.
// 
	
	include ("check_session.php");
	
	if (BWB_REQUIRE_SSL == 1)
		$http = "https://";
	else
		$http = "http://";
?>
<!DOCTYPE html>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}
/*
body	{
	background-image:url(images/Breeze_logo_large_lt-gray.png);
	background-repeat:no-repeat;
	background-position:center;
	background-attachment:fixed;
}
*/
.install_files_warning	{
	color:#Ff0000;
	font-size:18px
}
.download_button	{
	display:inline;
	background-color:#585858;
	color:#FFFFFF;
	padding-top:5px;
	padding-bottom:5px;
	padding-left:15px;
	padding-right:15px;
}
.download_button:hover	{	
	cursor:pointer;
	background-color:#A6A6A6;
	color:#2C2C2C;
}

#uploading_gif_div	{
	position:absolute;
	top:300px;
	left:400px;
	background-color:#D9D9D9;
	box-shadow: 0px 0px 10px 20px #D9D9D9;
	display:none;
	color:#FF0000;
	font-weight:bold;
	text-align:center;
}
</style>

<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/dashboard.js"></script>

<script>
<?php
	echo "	var INSTALL_UPDATE_NEW_VERSION_AVAILABLE = \"" . INSTALL_UPDATE_NEW_VERSION_AVAILABLE . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
?>
</script>

</head>
<body id="workspace_body">

<div class="button_heading_sub_level_1" id="dashboard_heading"><div class="button_heading_text_sub_level_1"><?php echo DASHBOARD_WORD; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>

<p><?php echo WELCOME_1_MSG; ?> <?php echo $userid;	?> <?php echo WELCOME_2_MSG; ?></p>

<?php
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	$install_file = $document_root . "/install/do_install.php";
	$run_sql_file = $document_root . "/install/run_sql_install.php";
	if (file_exists($install_file) || file_exists($run_sql_file))
	{
?>
	<p class="install_files_warning"><?php echo WELCOME_INSTALL_FOLDER_PRESENT_1_WARNING; ?> <a href="delete_install.php"><b><?php echo WELCOME_INSTALL_FOLDER_PRESENT_2_WARNING; ?></b></a> <?php echo WELCOME_INSTALL_FOLDER_PRESENT_3_WARNING; ?></p>
<?php
	}
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "version`";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$version = $row["version"];
	
	if ((ini_get("allow_url_fopen") == 1) || (ini_get("allow_url_fopen") === true) || (strtolower(ini_get("allow_url_fopen")) == "on"))
	{
		$url = $http . 'breezewebsitebuilder.com/breeze_version.php';
		$latest_version = file_get_contents($url);
			
		if ($version == $latest_version)	{
			echo WELCOME_LATEST_VERSION_INSTALLED_MSG . ": " . VERSION_WORD . ": $version<br />\n";
			echo "<script>\n";
			echo "	parent.cancel_set_prev_btn_state = true;\n";
			echo "</script>\n";
		}
		elseif ($version > $latest_version)
			echo WELCOME_BETA_VERSION_INSTALLED_1_MSG . " " . $version . " " . WELCOME_BETA_VERSION_INSTALLED_2_MSG . " $latest_version.<br />\n";
		else
		{
			$url = $http . 'breezewebsitebuilder.com/download_page.php?last_id=dashboard#updates';
			echo WELCOME_OLD_VERSION_INSTALLED_1_MSG ." " . $version . " " . WELCOME_OLD_VERSION_INSTALLED_2_MSG . " " . $latest_version . ".  " . WELCOME_OLD_VERSION_INSTALLED_3_MSG . " <span class='download_button' onClick=\"window.open('$url');\"> " . DOWNLOAD_WORD . " </span>&nbsp;";
			
			// Check if running previous version from latest.  If so, thet popup automatic update message.
			$url = $http . "breezewebsitebuilder.com/download_page.php";
			$html = file_get_contents($url);
			$doc = new DOMDocument(); // create DOMDocument
			libxml_use_internal_errors(true);
			$doc->loadHTML($html); // load HTML you can add $html
			$previous_update_file = $doc->getElementById('previous_update')->nodeValue;
			$previous_ver = str_replace("breeze_update_", "", $previous_update_file);
			$previous_ver = str_replace(".tar.gz", "", $previous_ver);
			$version_file = $_GET['version_file'];
			if (($version == $previous_ver) && ($version_file == $version))
				echo  WELCOME_OLD_VERSION_INSTALLED_5A_MSG . "<br />\n";
			else
				echo  WELCOME_OLD_VERSION_INSTALLED_5_MSG . "<br />\n";
			
			echo "<div style='padding-top:5px;'>\n";
			if ($access_level == "admin")
			{
				if (($version == $previous_ver) && ($version_file == $version))
				{
					echo WELCOME_OLD_VERSION_INSTALLED_6A_MSG . " <span class='download_button' onClick=\"parent.workspace.location='upload_update.php';\"> " . WELCOME_OLD_VERSION_INSTALLED_7_MSG . " </span> &nbsp;" . WELCOME_OLD_VERSION_INSTALLED_8A_MSG . "<br />\n";
					echo "</div>\n";
					
					echo "\n<script>\n";
					echo "	parent.cancel_set_prev_btn_state = true;\n";
					echo "	mTimer = setTimeout(\"ShowUpdatePopup('$version_file');\", 5000);\n";
					echo "</script>\n";
					echo "<div id='uploading_gif_div'>\n";
					echo "<img src='theme/$theme/images/uploading.gif' alt='" . UPLOAD_TEMPLATE_UPLOADING . "' id='uploading_gif' />\n";
					echo "<p>" . WELCOME_PLEASE_WAIT_DOWNLOADING_UPDATES_MSG . "</p>\n</div>\n";
				}
				else
				{
					echo WELCOME_OLD_VERSION_INSTALLED_6_MSG . " <span class='download_button' onClick=\"parent.workspace.location='upload_update.php';\"> " . WELCOME_OLD_VERSION_INSTALLED_7_MSG . " </span> &nbsp;" . WELCOME_OLD_VERSION_INSTALLED_8_MSG . "<br />\n";
					echo "</div>\n";
				}
			}
			else
			{
				echo WELCOME_OLD_VERSION_INSTALLED_7_MSG . "<br />\n";
				echo "</div>\n";
			}
		}
	}
	else
	{
		echo WELCOME_UNKNOWN_VERSION_INSTALLED_1_MSG . " " . $version . " " . WELCOME_UNKNOWN_VERSION_INSTALLED_2_MSG . "<br />\n";
	}
?>


<p>
<?php 
	echo WELCOME_PAGE_COUNT . " ";
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo $num_results;
?>
</p>
<p>
<?php
	echo WELCOME_BLOG_COUNT . " ";
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "blogs ORDER BY revised";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo $num_results;
?>
</p>

<iframe src="<?php echo $http; ?>breezewebsitebuilder.com/news.php?license=<?php echo BWB_SN; ?>&version=<?php echo $version; ?>&lang=<?php echo BWB_LANG; ?>" id="announcements_frame" scrolling="no"></iframe>

<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
HidePopupMsg();
</script>
</body>
</html>