<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/3/2016	ELL
//
//
if ($template_mode != 1)	{
	include ("check_session.php");
	include("lib/build_css_string.php");
}

$delete_style_sheet = $_POST['style_sheet'];
if ($template_mode == 1)
	$delete_style_sheet = "-all-";
else
	$template_mode = 0;

$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets`";
$result2 = $bwb_dbh->query($query);
while ($row2 = $result2->fetch(PDO::FETCH_ASSOC))
{
	if ($delete_style_sheet == "-all-")
		$style_sheet = $row2['name'];
	else
		$style_sheet = $delete_style_sheet;
	$class_table = $style_sheet . "_classes";
	$css_table = $style_sheet . "_css";
	$css_file =  $style_sheet . ".css";
	
	// First, see if the table exists.  If not, going to have to skip.
	$query = "SHOW TABLES LIKE '" . BWB_TABLE_PREFIX . $class_table . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() < 1)
		continue;

	// Start by finding all custom classes and removing from css table.
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` WHERE `custom` = 1";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$class = $row['class'];
		// Remove class from css table.
		$query = "DELETE FROM `" . BWB_TABLE_PREFIX . $css_table . "` WHERE `class` = '$class'";
		$cnt = $bwb_dbh->exec($query);
	}
	// Go ahead and delete tag from class table.
	$query = "DELETE FROM `" . BWB_TABLE_PREFIX . $class_table . "` WHERE `custom` = 1";
	$cnt = $bwb_dbh->exec($query);

	if ($template_mode != 1)
	{
		// Build new CSS string without deleted classes.
		$css_string = BuildCSSString(BWB_TABLE_PREFIX . $css_table, BWB_TABLE_PREFIX . $class_table, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX . "fonts");
		
		////////////////////////////////////////////////////////
		/// Write new css file /////////////
		//Test to see if file already exists.
		$document_root = $_SERVER['DOCUMENT_ROOT'];
		if (BWB_BASE_DIR == '')
			$userfiles = '';
		else
			$userfiles = "/" . BWB_BASE_DIR;
			
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
			
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
		$result = (fputs($fh, $css_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
		
		/////////////////////////////////////////////////////////
		// Add custom styles to CKEditor style list. ///////////
		// Build string for fckstyles.xml file /////
		include("build_jason_style_string.php");
		
		// Rename styles.js file for backup
		$file_name = $document_root . "/ckeditor/styles.js";
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
		$result = (fputs($fh, $jason_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
		
		if ($delete_style_sheet != "-all-")
			break;
	}
}

if ($delete_style_sheet == "-all-")
{
	// Recall all plugins so that plugin factory styles can be added back in when creating a new page with a plugin.
	$query = "UPDATE " . BWB_TABLE_PREFIX . "plugins SET deployed = 0";
	$cnt = $bwb_dbh->exec($query);
}

if ($template_mode != 1)
	echo 1;
	
?>
