<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 10/12/2010	ELL
// Changed timestamping of `revised` field due to change from VARCHAR to DATETIME in table structure.
// Revised: 1/13/2012	ELL
// Added deletion of draft copies as well.
// Revised: 2/8/2012	ELL
// Added table prefix handling. Added reference to user files folder constant.
// Revised: 11/20/2014	ELL
// Added "redirect", "folder" and separated "page_name" from "file_name" such that this module can be used in more than one place.
// Revised: 3/26/2016	ELL
// Fixed bug where delete file, then re-create file and file cache is loaded instead of file.
//
	include ("check_session.php");

	$page_name = $_GET['page_name'];
	$file_name = $_GET['file_name'];
	$folder = $_GET['folder'];
	$redirect = $_GET['redirect'];
	
	$file_name = str_replace("%2F", "/", $file_name);
	$folder = str_replace("%2F", "/", $folder);
	if ($folder == "root")
		$folder = "";
	
	if (strpos($file_name, "/") === 0)
		$file_name = substr($file_name, 1);
	if (strpos($folder, "/") === 0)
		$folder = substr($folder, 1);
	
	if ((strpos($folder, BWB_SCRIPTS_DIR) !== 0) && (strpos($folder, BWB_SCRIPTS_DIR) !== 1) && (strpos($folder, BWB_LIB_DIR) !== 0) && (strpos($folder, BWB_LIB_DIR) !== 1))
	{
		// Before we go any farther, back this puppy up!
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='$page_name'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$page_content = addslashes(stripslashes($row["page_content"]));
		$revised = $row["revised"];
		$today = date("Y-m-d H:i:s");
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_bkup SET page_name='$page_name', page_content='$page_content', revised='$revised', deleted='$today'";
		$cnt = $bwb_dbh->exec($query);
		
		// Now go ahead and delete page record from table.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name = '$page_name'";
		$cnt = $bwb_dbh->exec($query);
		// And remove draft while you are at it.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name = '$page_name' AND `source`=0";
		$cnt = $bwb_dbh->exec($query);
	}
	
	// And delete actual page.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	$path = $document_root . "/" . $folder . "/";
	
	if (file_exists($path . $file_name))
	{
		// Backup file just in case.
		$sub_path = "";
		$source = $path . $file_name;
		if (strpos($file_name, "/") !== false)	{
			$file_name_arr = explode("/", $file_name);
			for ($i = 0; $i < count($file_name_arr) - 1; $i++)	{
				$sub_path .= $file_name_arr[$i] . "/";
			}
			$file_name = $file_name_arr[count($file_name_arr) - 1];
		}
		$dest = $path . $sub_path . "." . $file_name . time();
		copy($source, $dest);
	
		// Delete file.
		$fh = fopen($source, 'w') or die("Can't open $path: $php_errormsg");
		fclose($fh) or die($php_errormsg);
		unlink($source);
	}
	
	// Delete cache file.
	$save_file_path = $path . $sub_path . "." . $file_name . "_save";
	if (file_exists($save_file_path))
	{
		$fh = fopen($save_file_path, 'w') or die("Can't open $path: $php_errormsg");
		fclose($fh) or die($php_errormsg);
		unlink($save_file_path);
	}
	
	header("Location: $redirect");
	
?>
