/////////////////////////////////////////////
// Edit Custom CSS /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/16/2014	ELL
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// 

var mTimer;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_file", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////
function LoadFile()
{
	$.post( "get_file.php", { file_name: file_name, folder: folder } ).done(CompleteLoadFile) ;
}
function CompleteLoadFile(data)
{
//	alert(data);
	CKEDITOR.instances['editorContainer'].setData(data);
}

function Save(action)
{
	var file_parts = file_name.split(".");
	if (file_parts[0] == "untitled")	{
		ShowSaveAsMsg();
		return;
	}
	
	var file_content = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	$.post( "save_file.php", { file_name: file_name, folder: folder, file_content: file_content, action: action } ).done(CompleteSave) ;
}
function CompleteSave(data)	{
	popup_msg.status_msg = data;
//	alert(data);
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	saved = true;
	window.parent.SetWorkSavedNotSaved(saved);
	bwb_ckeditor.resetDirty();
}

function RevertConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	
	popup_msg.popup_msg_cell = EDITOR_REVERT_FILE_CONFIRM_1_MSG + " <b>" + file_name + "</b> " + EDITOR_REVERT_FILE_CONFIRM_2_MSG;
	document.getElementById("popup_button_2_span").onclick = function() { Revert(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
	popup_msg.ShowPopupMsg();
}
function Revert()
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_REVERTING_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	$.post( "revert_file.php", { file_name: file_name, folder: folder } ).done(CompleteRevert) ;
}
function CompleteRevert(data)
{
	if ((data == "Error: no folder specified") || (data == "Error opening file"))
		popup_msg.status_msg = data;
	else	{
		popup_msg.status_msg = EDITOR_REVERT_COMPLETE_MSG;
		if (data.indexOf("No draft found") == 0)
			data = data.replace("No draft found", "");
		CKEDITOR.instances['editorContainer'].setData(data);
	}
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function Preview()
{
	var file_content = CKEDITOR.instances['editorContainer'].getData();

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_PREPARING_PREVIEW_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	$.post( "preview_file_init.php", { file_name: file_name, file_content: file_content }).done(function( data ) {
		CompletePreview(data);
	});
}
function CompletePreview(data)
{
	var ext;
	var path;
	var data_parts = data.split("@@@@@");
	path = data_parts[0];
	ext =  data_parts[1];
	
	var preview_file_string = path + "/pREVIEW." + ext;
	window.open(preview_file_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
}

function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDITOR_FILE_NOT_SAVED_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	Save('save');
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function ShowSaveAsMsg()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.popup_msg_type = 4;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_prompt_cell = SAVE_AS_WORD + ": ";
	popup_msg.popup_button_2_span = CANCEL_WORD;
	popup_msg.popup_button_1_span = OK_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { HidePopupMsg(); };
	document.getElementById("popup_button_1_span").onclick = function () { SaveAs(); };
}

function SaveAs()
{
	var old_file_name = file_name;
	var new_file_name = document.getElementById("popup_prompt_textbox").value;

	if ((new_file_name == null) || (new_file_name == ""))
	{
		alert(EDITOR_FILE_BLANK_ERR);
		return;
	}
	var page_exists;
	var new_page_name;
	var old_page_name;
	var old_ext;
	var new_ext;
	old_file_parts = old_file_name.split(".");
	old_page_name = old_file_parts[0];
	old_ext = old_file_parts[1];
	new_file_parts = new_file_name.split(".");
	if ((new_file_parts[1] == null) || (new_file_parts[1] == undefined) || (new_file_parts[1] == ""))	{
		new_ext = old_ext;
		new_file_name = new_file_name + "." + new_ext;
	}
	else
		new_ext = new_file_parts[1];
		
	var old_file_path_parts = old_file_name.split("/");
	var sub_path = old_file_name.replace(old_file_path_parts[old_file_path_parts.length - 1], "");
		
	if ((folder.indexOf(BWB_SCRIPTS_DIR) !== 0) && (folder.indexOf(BWB_SCRIPTS_DIR) !== 1) && (folder.indexOf(BWB_LIB_DIR) !== 0) && (folder.indexOf(BWB_LIB_DIR) !== 1))	{
		new_page_name = new_file_name.replace(".php", "");
		if ((old_ext == "php") && (new_ext == "php"))
			$.post( "check_page_exists.php", { page_name: new_page_name, special: 0 }, function(data){ page_exists = data; }, "text" ) ;
		else
			$.post( "check_file_exists.php", { file_name: new_file_name, folder: folder }, function(data){ page_exists = data; }, "text" ) ;
	}
	else
		$.post( "check_file_exists.php", { file_name: new_file_name, folder: folder }, function(data){ page_exists = data; }, "text" ) ;

	if (page_exists == "1")
		alert(EDITOR_FILE_ALREADY_EXISTS_1_ERR + " " + new_file_name + " " + EDITOR_FILE_ALREADY_EXISTS_2_ERR);
	else
	{
		if (((folder.indexOf(BWB_SCRIPTS_DIR) !== 0) && (folder.indexOf(BWB_SCRIPTS_DIR) !== 1) && (folder.indexOf(BWB_LIB_DIR) !== 0) && (folder.indexOf(BWB_LIB_DIR) !== 1)) && (old_ext == "php") && (new_ext == "php"))
			$.post( "copy_rename_page.php", { page_name: old_page_name, new_name: new_page_name, copy_mode: "copy", overwrite: 0, overwrite_content_only: 0, create_new_template: 0 } ) ;	
		
		document.getElementById("page_name_label").innerHTML = new_file_name;
		
		file_name = sub_path + new_file_name;
		Save('publish');
		
		var new_title = file_name + " - Editing | Breeze Website Builder";
		document.title = new_title;
		window.parent.document.title = document.title;
	}
	
	HidePopupMsg();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	
	popup_msg.popup_msg_cell = EDITOR_DELETE_FILE_CONFIRM_1_MSG + " <b>" + file_name + "</b> " + EDITOR_DELETE_FILE_CONFIRM_2_MSG;
	document.getElementById("popup_button_2_span").onclick = function() { DeletePage(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
	popup_msg.ShowPopupMsg();
}

function DeletePage()
{
	if ((typeof redirect == 'undefined') || (redirect == ""))
		redirect = "edit_file_select.php";
	var page_name = file_name.replace(".php", "");
	HidePopupMsg();
	if (page_name.indexOf("/") > -1)	{
		var page_name_arr = page_name.split("/");
		page_name = page_name_arr[page_name_arr.length - 1];
	}
	page_name = page_name.replace("/", "");
	var url_file_name = file_name.replace(/\//g, "%2F");
	var url_folder = folder.replace("/", "%2F");
	var url = "delete_page.php?page_name=" + page_name + "&file_name=" + url_file_name + "&folder=" + url_folder + "&redirect=" + redirect;
	window.location = url;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

	var editorWidth = mainWidth - menuWidth;
	var editorHeight = mainHeight - headerHeight - 58;

	CKEDITOR.instances['editorContainer'].resize(editorWidth, editorHeight);
	
	tableWidth = editorWidth - 50;
	sTableWidth = tableWidth.toString() + "px";
	document.getElementById("btn_table").style.width = sTableWidth;
}