////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 3/9/2013	ELL
// Revised: 6/28/2013	ELL
// Implemented popup message class.
// Revised: 12/22/2013	ELL
// Restored ability to check for saved and prompt user for action.
// Revised: 12/30/2013	ELL
// Fixed bug with overzealous not-saved message.
// Revised: 6/16/2014	ELL
// Added content sensitive help for relevant plugins.
// Revised: 9/21/2014	ELL
// Upgraded CKEditor for 4.0.2 to 4.4.4.
// Revised: 10/16/2014	ELL
// Added ability to turn off site styles when disable_site_styles flag is set.
// Revised: 11/21/2014	ELL
// Added delete page, bordar area or blog.
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Added "Save As" for border areas.
// Revised:	2/2/2012	ELL
// Fixed bug with "See Site" button not updating to new file after "Save As".
// Fixed bug of "Save As" not creating new file.

var mTimer;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_page", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function OpenHelpList(plugin_cnt)
{
	document.getElementById('help_list').style.display = "block";
	document.getElementById('help_list').innerHTML = help_list_html;

	var top_offset = -130 - (plugin_cnt * 20);
	var left_offset = -310;
	var ntop;
	var nright;
	ntop = tempY + top_offset;
	nleft = tempX + left_offset;
	
	var strtop = ntop + "px";
	var strleft = nleft + "px";
	
	document.getElementById("help_list").style.position = "absolute";
	document.getElementById("help_list").style.top = strtop;
	document.getElementById("help_list").style.left = strleft;
}
 
function CloseHelpList()
{
	document.getElementById('help_list').style.display = "none";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function LoadPage()
{
	$.post( "load_page.php", { page_name: page_name, blog_id: blog_id, special: special, mode: mode, disable_site_styles: disable_site_styles } ).done(CompleteLoadPage) ;
}
function CompleteLoadPage(data)
{
//	alert(data);
	CKEDITOR.instances['editorContainer'].setData(data);
}

function Save(action)
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	$.post( "save_page.php", { sValue: sValue, page_name: page_name, blog_id: blog_id, special: special, mode: mode, action: action, disable_site_styles: disable_site_styles } ).done(CompleteSave) ;
}
function CompleteSave(data)	{
	popup_msg.status_msg = data;
//	alert(data);
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	saved = true;
	window.parent.SetWorkSavedNotSaved(saved);
	bwb_ckeditor.resetDirty();
}

var preview_window;
function Preview(preview_page_name, do_refresh)
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_PREPARING_PREVIEW_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	$.post( "preview_page_init.php", { sValue: sValue, page_name: page_name, disable_site_styles: disable_site_styles }, function(data){ CompletePreview(data, do_refresh); }, "text" ) ;
	
	if (do_refresh != 1)	{
		var preview_page_string = "preview_page.php?page_name=" + page_name + "&special=" + special + "&mode=" + mode + "&blog_id=" + blog_id;
		preview_window = window.open(preview_page_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
	}
}
function CompletePreview(data, do_refresh)
{
	popup_msg.status_msg = data;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	
	if (do_refresh == 1)
		preview_window.location.reload();
}

function ClearContent()
{
	var encap_delim = "<!-- WYSIWYG Encapsulation. Modify HTML inside of these comments only.  All code outside of these comments is discarded. -->";
	
	page_content = prepend + encap_delim + "&nbsp;" + encap_delim + postpend;
	CKEDITOR.instances['editorContainer'].setData(page_content);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function RevertConfirm(delete_mode)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	
	if (delete_mode == "blog")
		popup_msg.popup_msg_cell = EDITOR_REVERT_BLOG_CONFIRM_1_MSG + " <b>" + blog_id + "</b> " + EDITOR_REVERT_BLOG_CONFIRM_2_MSG;
	else if (delete_mode == "border")
		popup_msg.popup_msg_cell = EDITOR_REVERT_AREA_CONFIRM_1_MSG + " <b>" + page_name + "</b> " + EDITOR_REVERT_AREA_CONFIRM_2_MSG;
	else
		popup_msg.popup_msg_cell = EDITOR_REVERT_PAGE_CONFIRM_1_MSG + " <b>" + page_name + "</b> " + EDITOR_REVERT_PAGE_CONFIRM_2_MSG;
		
	document.getElementById("popup_button_2_span").onclick = function() { Revert(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
	popup_msg.ShowPopupMsg();
}
function Revert()
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_REVERTING_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	$.post( "revert.php", { page_name: page_name, blog_id: blog_id, special: special, mode: mode, prepend: prepend, postpend: postpend }).done(CompleteRevert) ;
}
function CompleteRevert(data)
{
	if (data == "Revert failed")
	{
		popup_msg.status_msg = data;
		popup_msg.popup_timeout = 2000;
		popup_msg.ShowPopupMsg();
	}
	else
		LoadPage();
}

function OptimizeResetImages(action)
{
	var sValue = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	$.post( "optimize_reset_images.php", { sValue: sValue, userfiles: userfiles, action: action }).done(CompleteOptimizeResetImages);
}
function CompleteOptimizeResetImages(data)	{
	popup_msg.status_msg = data;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDITOR_PAGE_NOT_SAVED_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	Save('save_draft');
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function ShowSaveAsMsg()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.popup_msg_type = 4;
	popup_msg.popup_btn_cnt = 2;
	var name_prefix = " ";
	if (special == 1)
	{
		if (page_name.indexOf("_") > -1)	{
			var border_area_parts = page_name.split("_");
			name_prefix = border_area_parts[0] + "_";
		}
		else	{
			if (page_name.indexOf("header") == 0)
				name_prefix = "header_";
			else if (page_name.indexOf("top") == 0)
				name_prefix = "top_";
			else if (page_name.indexOf("left") == 0)
				name_prefix = "left_";
			else if (page_name.indexOf("right") == 0)
				name_prefix = "right_";
			else if (page_name.indexOf("bottom") == 0)
				name_prefix = "bottom_";
			else if (page_name.indexOf("footer") == 0)
				name_prefix = "footer_";
		}
		popup_msg.popup_prompt_cell = SAVE_AS_WORD + ": " + name_prefix;
	}
	else
		popup_msg.popup_prompt_cell = SAVE_AS_WORD + ": ";
		
	popup_msg.popup_button_2_span = CANCEL_WORD;
	popup_msg.popup_button_1_span = OK_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { HidePopupMsg(); };
	document.getElementById("popup_button_1_span").onclick = function () { SaveAs(name_prefix); };
}

function SaveAs(name_prefix)
{
	var old_page_name = page_name;
	var new_page_name = document.getElementById("popup_prompt_textbox").value;
	if ((new_page_name == null) || (new_page_name == ""))
	{
		alert(EDITOR_PAGE_BLANK_ERR);
		return;
	}
	var page_exists;
	$.post( "check_page_exists.php", { page_name: new_page_name, special: special }, function(data){ page_exists = data; }, "text" ) ;
		
	if (page_exists == "1")	{
		if (special != 1)
			alert(EDITOR_PAGE_ALREADY_EXISTS_1_ERR + " " + new_page_name + " " + EDITOR_PAGE_ALREADY_EXISTS_2_ERR);
		else
			alert(EDITOR_AREA_ALREADY_EXISTS_1_ERR + " " + new_page_name + " " + EDITOR_AREA_ALREADY_EXISTS_2_ERR);
	}
	else
	{
		if (special != 1)
			page_name = new_page_name;
		else
			page_name = name_prefix + new_page_name;

		if (special != 1)
			$.post( "copy_rename_page.php", { page_name: old_page_name, new_name: new_page_name, copy_mode: "copy", overwrite: 0, overwrite_content_only: 0, create_new_template: 0 } ) ;
		else
			$.post( "copy_border_area.php", { area_old_name: old_page_name, name_prefix: name_prefix, name_suffix: new_page_name } ) ;
		
		document.getElementById("page_name_label").innerHTML = name_prefix + new_page_name;
		if (special != 1)	{
			var see_site_path = "";
			if ((userfiles == "") && (website_folder == ""))
				see_site_path = "../" + page_name + ".php";
			else
				see_site_path = "../" + userfiles + website_folder + "/" + page_name + ".php";
			document.getElementById("see_site_btn").onclick = function(){window.open(see_site_path, '_blank');};
		}
		
		Save('publish');
		
		var new_title = new_page_name + " - Editing | Breeze Website Builder";
		document.title = new_title;
		window.parent.document.title = document.title;
	}
	
	HidePopupMsg();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(delete_mode)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	
	if (delete_mode == "blog")
	{
		popup_msg.popup_msg_cell = EDITOR_DELETE_BLOG_CONFIRM_1_MSG + " <b>" + blog_id + "</b> " + EDITOR_DELETE_BLOG_CONFIRM_2_MSG;
		document.getElementById("popup_button_2_span").onclick = function() { DeleteBlog(); };
	}
	else if (delete_mode == "border")
	{
		popup_msg.popup_msg_cell = EDITOR_DELETE_AREA_CONFIRM_1_MSG + " <b>" + page_name + "</b> " + EDITOR_DELETE_AREA_CONFIRM_2_MSG;
		document.getElementById("popup_button_2_span").onclick = function() { DeleteBorderArea(); };
	}
	else
	{
		popup_msg.popup_msg_cell = EDITOR_DELETE_PAGE_CONFIRM_1_MSG + " <b>" + page_name + "</b> " + EDITOR_DELETE_PAGE_CONFIRM_2_MSG;
		document.getElementById("popup_button_2_span").onclick = function() { DeletePage(); };
	}
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
	popup_msg.ShowPopupMsg();
}

function DeletePage()
{
	var folder = "";
	if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
		folder = 'root';
	else if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR != ''))
		folder = BWB_WEBPAGE_DIR;
	else if ((BWB_BASE_DIR != '') && (BWB_WEBPAGE_DIR == ''))
		folder = BWB_BASE_DIR;
	else if ((BWB_BASE_DIR != '') && (BWB_WEBPAGE_DIR == ''))
		folder = BWB_BASE_DIR + "%2F" + BWB_WEBPAGE_DIR;
		
	HidePopupMsg();
	var url = "delete_page.php?page_name=" + page_name + "&file_name=" + page_name + ".php&" + folder + "=pages&redirect=edit_page_select.php";
	window.location = url;
}

function DeleteBlog()
{
	HidePopupMsg();
	var url = "delete_blog.php?blog_id=" + blog_id + "&redirect=edit_blog_select.php";
	window.location = url;
}

function DeleteBorderArea()
{
	HidePopupMsg();
	var url = "delete_border_area.php?area_name=" + page_name + "&redirect=manage_border_area_select.php";
	window.location = url;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

	var editorWidth = mainWidth - menuWidth;
	var editorHeight = mainHeight - headerHeight - 58;

	CKEDITOR.instances['editorContainer'].resize(editorWidth, editorHeight);
	
	sEditorWidth = editorWidth.toString() + "px";
	document.getElementById("btn_table").style.width = sEditorWidth;
}