<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/12/2010	ELL
// Revised: 2/8/2012	ELL
// Added references to website files, images, CSS, scripts, media and Flash folder configurations.
// Revised: 8/14/2014	ELL
// Improved to find all backup CSS files.
// Modified: 12/5/2014	ELL
// Added pruning of backup files created when editing files directly (.xxxtimestamp_save), and pruning of preview (pREVIEWxxx) files.
// 
	
	include ("check_session.php");
	
	if (BWB_BASE_DIR == '')
		$userfiles_path = '';
	else
		$userfiles_path = "/" . BWB_BASE_DIR;
		
	if (BWB_WEBPAGE_DIR == '')
		$website_path = $userfiles_path;
	else
		$website_path = $userfiles_path . "/" . BWB_WEBPAGE_DIR;

//////////// Web Pages ///////////////////
	$path = ".." . $website_path . "/";
	if ($handle = opendir($path))
	{
		while (false !== ($file = readdir($handle)))
		{
			if ((!(strpos($file, "sitemap.xml") === false) && (strlen($file) > 20)) || ((substr($file, strlen($file) - 5, 5) == "_save") && (substr($file, 0, 1) == ".")) || (substr($file, 0, 7) == "pREVIEW"))
			{
				$file_path = $path . $file;
				unlink($file_path);
			}
		}
		closedir($handle);
	}
	
//////////// CSS Files ///////////////////
	$path = ".." . $userfiles_path . "/" . BWB_CSS_DIR . "/";
	if ($handle = opendir($path)) 
	{
		while (false !== ($file = readdir($handle)))
		{
			if ((strpos($file, ".css") !== false) && (strpos($file, ".css") < (strlen($file) - 5)))
			{
				$file_path = $path . $file;
				unlink($file_path);
			}
		}
		closedir($handle);
	}
	
//////////// Included Scripts ///////////////////
	$dir_arr = array();
	$path = ".." . $userfiles_path . "/" . BWB_SCRIPTS_DIR . "/";
	if ($handle = opendir($path)) 
	{
		while (false !== ($file = readdir($handle)))
		{
			if (is_dir($path . $file) && ($file != ".") && ($file != ".."))
				$dir_arr[] = $path . $file;
			else
			{
				$file_arr = explode(".", $file);
				$ext = $file_arr[count($file_arr) -1];
				if ((((strpos($file, "menu_items.js") !== false) || (strpos($file, "menu_tpl.js") !== false)) && (strlen($file) > 20))  || ((substr($file, strlen($file) - 5, 5) == "_save") && (substr($file, 0, 1) == ".")) || (((strlen($ext) == 12) || (strlen($ext) == 13)) && (substr($file, 0, 1) == ".")))
				{
					$file_path = $path . $file;
					unlink($file_path);
				}
			}
		}
		closedir($handle);
	}
	
//////////// Library Scripts ///////////////////
	$path = "../" . BWB_LIB_DIR . "/";
	if ($handle = opendir($path)) 
	{
		while (false !== ($file = readdir($handle)))
		{
			if (is_dir($path . $file) && ($file != ".") && ($file != ".."))
				$dir_arr[] = $path . $file;
			else
			{
				$file_arr = explode(".", $file);
				$ext = $file_arr[count($file_arr) -1];
				if (((substr($file, strlen($file) - 5, 5) == "_save") && (substr($file, 0, 1) == ".")) || (((strlen($ext) == 12) || (strlen($ext) == 13)) && (substr($file, 0, 1) == ".")))
				{
					$file_path = $path . $file;
					unlink($file_path);
				}
			}
		}
		closedir($handle);
	}
	
//////////// Sub directories of Included Scripts Library Scripts ///////////////////
	$dir_arr2 = array();
	$dir_arr3 = array();
	foreach ($dir_arr as $path)
	{
		$path .= "/";
		if ($handle = opendir($path)) 
		{
			while (false !== ($file = readdir($handle)))
			{
				if (is_dir($path . $file) && ($file != ".") && ($file != ".."))
					$dir_arr2[] = $path . $file;
				else
				{
					$file_arr = explode(".", $file);
					$ext = $file_arr[count($file_arr) -1];
					if (((substr($file, strlen($file) - 5, 5) == "_save") && (substr($file, 0, 1) == ".")) || (((strlen($ext) == 12) || (strlen($ext) == 13)) && (substr($file, 0, 1) == ".")))
					{
						$file_path = $path . $file;
						unlink($file_path);
					}
				}
			}
			closedir($handle);
		}
	}
	foreach ($dir_arr2 as $path)
	{
		$path .= "/";
		if ($handle = opendir($path)) 
		{
			while (false !== ($file = readdir($handle)))
			{
				if (is_dir($path . $file) && ($file != ".") && ($file != ".."))
					$dir_arr3[] = $path . $file;
				else
				{
					$file_arr = explode(".", $file);
					$ext = $file_arr[count($file_arr) -1];
					if (((substr($file, strlen($file) - 5, 5) == "_save") && (substr($file, 0, 1) == ".")) || (((strlen($ext) == 12) || (strlen($ext) == 13)) && (substr($file, 0, 1) == ".")))
					{
						$file_path = $path . $file;
						unlink($file_path);
					}
				}
			}
			closedir($handle);
		}
	}
	foreach ($dir_arr3 as $path)
	{
		$path .= "/";
		if ($handle = opendir($path)) 
		{
			while (false !== ($file = readdir($handle)))
			{
				if (!is_dir($path . $file) && ($file != ".") && ($file != ".."))
				{
					$file_arr = explode(".", $file);
					$ext = $file_arr[count($file_arr) -1];
					if (((substr($file, strlen($file) - 5, 5) == "_save") && (substr($file, 0, 1) == ".")) || (((strlen($ext) == 12) || (strlen($ext) == 13)) && (substr($file, 0, 1) == ".")))
					{
						$file_path = $path . $file;
						unlink($file_path);
					}
				}
			}
			closedir($handle);
		}
	}
	
	header("Location: admin_function_select.php?display_pruned_bkup_files_msg=1");
?>
