<?php
/////////////////////////////////////////////
// Upload Template /////
////////////////////////////////////////////////////////////////////////
//	Breeze Website Builder
//	Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
//	For licensing, see license.txt.
//	Created: 10/2/2011	ELL
//	Revised: 2/10/2012	ELL
//  Added table prefix handling.  Added references to images folder configuration.
// 	Revised: 4/9/2013	ELL
//  Added call out of SQL file name and changed reference to sql file run module.
//  Revised: 7/13/2016	ELL
//  Replaced archive class and archive.php include with PharData class.
//
// 
//
	include ("check_session.php");
	include ("lib/copy_dir.php");
	include("lib/build_css_string.php");
	
	//////////////////////////////////////
	ini_set('max_execution_time', 10000);
	set_time_limit(10000);
	//////////////////////////////////////////
?>
<!DOCTYPE html>
<html>
<head>
<title>Upload Template | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
</head>
<body>
<h2><?php echo UPLOAD_TEMPLATE_BUILDING_SITE_MSG; ?><br />
&nbsp;&nbsp;<?php echo UPLOAD_TEMPLATE_WHEN_COMPLETE_SCROLL_TO_BOTTOM_MSG; ?></h2>
<?php
	if (is_uploaded_file($_FILES['template_file']['tmp_name']))
	{	
		$source = $_FILES['template_file']['tmp_name'];
		$file_name = $_FILES['template_file']['name'];
		$file_parts = explode(".", $file_name);
		$file_ext = $file_parts[count($file_parts) - 1];
		if (!((strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "gz") == 0)))
		{
			echo UPLOAD_TEMPLATE_ALLOWED_FILE_TYPE_MSG . " <a href='browse_template.php'>" . HERE_WORD . "</a> " . AND_TRY_AGAIN;
			exit;
		}
		$document_root = getenv('DOCUMENT_ROOT');
		$destination = $document_root . "/" . $file_name;
		move_uploaded_file( $source, $destination );
		
		if (strtolower($file_ext) == "gz")
			$tar_file_name = $file_parts[count($file_parts) - 3] . ".tar";
		else
			$tar_file_name = $file_parts[count($file_parts) - 2] . ".tar";
		
		$delete_all_pages = $_POST['delete_all_pages'];
		
		if ($delete_all_pages == 1)
		{
			if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
				$webpage_dir = "/";
			elseif ((BWB_BASE_DIR == '') || (BWB_WEBPAGE_DIR == ''))
				if (BWB_BASE_DIR == '')
					$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";
				elseif (BWB_WEBPAGE_DIR == '')
					$webpage_dir = "/" . BWB_BASE_DIR . "/";
			else
				$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";
					
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data";
			$result = $bwb_dbh->query($query);
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$page_name = $row['page_name'];
				$page_path = $document_root . $webpage_dir . $page_name . ".php";
				try	{
					unlink($page_path);
				}	catch (Exception $e) {
					$e = 0;
				}
			}
			
			$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . "page_data";
			$cnt = $bwb_dbh->exec($query);
			
			$template_mode = 1;
			include("delete_custom_classes.php");
		}
		
		if (file_exists($document_root . "/" . $tar_file_name))
			unlink($document_root . "/" . $tar_file_name);
			
		if (file_exists($document_root . "/tmp"))	// If tmp folder already exists, back it up.
		{
			$bkup = $document_root . "/tmp" . date('YmdHis', time());
			rename($document_root . "/tmp", $bkup);
		}
		
		try {
			$p = new PharData($destination);
			$p->decompress(".tar"); // creates /path/to/my.tar
		} catch (Exception $e) {
			echo $e;
			exit;
		}
		
		try {
			$phar = new PharData($document_root . "/" . $tar_file_name);
			$phar->extractTo($document_root . "/tmp", null, true);
		} catch (Exception $e) {
			echo $e;
			exit;
		}
		
		if (BWB_BASE_DIR == '')
			$userfiles = '';
		else
			$userfiles = "/" . BWB_BASE_DIR;
			
		if (BWB_WEBPAGE_DIR == '')
			$website_dir = '';
		else
			$website_dir = "/" . BWB_WEBPAGE_DIR;
		
		// Copy files to correct folders.
		echo UPLOAD_TEMPLATE_COPYING_USER_FILES_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/userfiles/";
		if (file_exists($source))	{
			$destination = $document_root . $userfiles . "/";
			copydir($source, $destination);
		}
		echo UPLOAD_TEMPLATE_COPYING_PAGES_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/userfiles/file/";
		if (file_exists($source))	{
			$destination = $document_root . $userfiles . $website_dir ."/";
			copydir($source, $destination);
		}
		echo UPLOAD_TEMPLATE_COPYING_IMAGES_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/userfiles/image/";
		if (file_exists($source))	{
			$destination = $document_root . $userfiles . "/" . BWB_IMAGE_DIR . "/";
			copydir($source, $destination);
		}
		echo UPLOAD_TEMPLATE_COPYING_CSS_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/userfiles/css/";
		if (file_exists($source))	{
			$destination = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/";
			copydir($source, $destination);
		}
		echo UPLOAD_TEMPLATE_COPYING_MEDIA_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/userfiles/media/";
		if (file_exists($source))	{
			$destination = $document_root . $userfiles . "/" . BWB_MEDIA_DIR . "/";
			copydir($source, $destination);
		}
		echo UPLOAD_TEMPLATE_COPYING_FLASH_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/userfiles/flash/";
		if (file_exists($source))	{
			$destination = $document_root . $userfiles . "/" . BWB_FLASH_DIR . "/";
			copydir($source, $destination);
		}
		echo UPLOAD_TEMPLATE_COPYING_SCRIPTS_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/userfiles/scripts/";
		if (file_exists($source))	{
			$destination = $document_root . $userfiles . "/" . BWB_SCRIPTS_DIR . "/";
			copydir($source, $destination);
		}
		echo UPLOAD_TEMPLATE_COPYING_XML_MSG . "<br><br>\n";
		$source = $document_root . "/tmp/ckeditor/";
		if (file_exists($source))	{
			$destination = $document_root . "/ckeditor/";
			copydir($source, $destination);
		}
		
		// Run template SQL
		$sql_file = "template.sql";
		include ("run_sql_file.php");
		
		/////////////////////////////////////////////////////////////////////////////////////
		// Build new style-sheet files in case user selected custom background colors or images,
		// or if style and image folders differ from template download site.
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets";
		$result = $bwb_dbh->query($query);
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$style_sheet = $row['name'];
			echo BUILDING_WORD . " " . $style_sheet . " " . STYLE_SHEET_WORD . " ...<br />\n";
			$css_table = $style_sheet . "_css";
			$css_file = $style_sheet . ".css";
			$class_table = $style_sheet . "_classes";
			
			$css_string = BuildCSSString(BWB_TABLE_PREFIX . $css_table, BWB_TABLE_PREFIX . $class_table, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX . "fonts");
			$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
			
			if (file_exists($file_name))
			{
				$bkup_file_name = $file_name . time();
				if (!rename($file_name, $bkup_file_name))
					echo UPLOAD_TEMPLATE_COULD_NOT_RENAME_ERR . " " . $file_name . " " . TO_WORD . " " . $bkup_file_name . ".<br>";
				@chmod($bkup_file_name, 0644);
			}
			
			// Create file.
			$fh = fopen($file_name, 'x') or die(UPLOAD_TEMPLATE_CANT_CREATE_ERR . " $file_name: $php_errormsg");
			$put_result = (fputs($fh, $css_string));
			fclose($fh) or die($php_errormsg);
			@chmod($file_name, 0644);
		}
		
?>
		<h2>Template installation is comlplete.</h2>
        <h2><?php echo CLICK_WORD; ?> <a href="/manage/main.php?mode=wizard" target="_parent"><?php echo HERE_WORD; ?></a> <?php echo UPLOAD_TEMPLATE_TO_CONTINUE_MSG; ?></h2>
<script>
	var bottom = document.body.scrollHeight;
	var from_height = 0;
	var step = parseInt(bottom/100);
	var to_height = 0;
	var code = "AnimateScroll();";
	
	function AnimateScroll()
	{
		if (to_height < bottom)
		{
			to_height = to_height + step;
			window.scrollTo(from_height, to_height);
			setTimeout(code, 10);
			from_height = to_height;
		}
	}
	AnimateScroll();
</script>
<?php
	}
	else
		echo UPLOAD_TEMPLATE_ERROR_UPLOADING_FILE_ERR . " " . CLICK_WORD . " <a href='browse_template.php'>" . HERE_WORD . "</a> " . TO_TRY_AGAIN;
?>
</body>
</html>