<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/23/2009		ELL
// Revised: 11/11/2009	ELL
// Added options for proportional item widths.
// Modified: 1/6/2010		ELL
// Added z-indexing to fix bug of sublevels not popping above main level upon hover.
// Modified: 10/7/2010		ELL
// Added text align.
// Modified: 2/4/2012	ELL
// Added selection for having sub menus collapse and expand.  Default is to collapse and expand.  New option is to show always expanded.
// Revised: 2/10/2012	ELL
// Added table prefix handling.  Added references to CSS folder configurations.
// Revised: 6/19/2013	ELL
// Added separate text alignment for sub menus.
// Revised: 7/21/2013	ELL
// Fixed bug with opacity being left at 0 if menu freshly cerated.
// Revised: 12/16/2013	ELL
// Added ability to specify bottom and right offsets as well as manually editing positioning.
// Revised: 1/15/2015	ELL
// Added full complement of units to all pertinent attributes.
// Revised: 3/28/2016	ELL
// Fixed bug with horizontal fixed width not saving width.
// Fixed bug with menu top and left not saving with insert new record.
// Modified: 12/2/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Modified: 3/27/2017	ELL
// Modified location of some styles per class for CSS menu system overhaul.
// Revised: 5/18/2017	ELL
// Modified to save top-level menu item width as min width of menu for vertical menus.
// Revised fixed-width horizontal menus to restore ability to span items across specified width.  (Required addition of flex.)
// 
//
//
	include ("check_session.php");
	include("lib/build_css_string.php");
		
	$menu = $_REQUEST['menu'];
	$tmp = str_replace("_mobile", "", $menu);
	$suffix = substr($tmp, 4);
	$css_file = $menu . ".css";

	if (isset($_POST["OrientationGroup"])) $orientation = $_POST["OrientationGroup"];
	else $orientation = "horizontal_fixed_width";
	if (isset($_POST["PositionGroup"])) $position = $_POST["PositionGroup"];
	else $position = "absolute";
	if (is_numeric($_POST["menu_top"])) $menu_top = $_POST["menu_top"];
	else $menu_top = -1000000;
	if (is_numeric($_POST["menu_left"])) $menu_left = $_POST["menu_left"];
	else $menu_left = -1000000;
	if (is_numeric($_POST["menu_bottom"])) $menu_bottom = $_POST["menu_bottom"];
	else $menu_bottom = -1000000;
	if (is_numeric($_POST["menu_right"])) $menu_right = $_POST["menu_right"];
	else $menu_right = -1000000;
	
	if (is_numeric($_POST["menu_top_units"])) $menu_top_units = $_POST["menu_top_units"];
	else $menu_top_units = 0;
	if (is_numeric($_POST["menu_left_units"])) $menu_left_units = $_POST["menu_left_units"];
	else $menu_left_units = 0;
	if (is_numeric($_POST["menu_bottom_units"])) $menu_bottom_units = $_POST["menu_bottom_units"];
	else $menu_bottom_units = 0;
	if (is_numeric($_POST["menu_right_units"])) $menu_right_units = $_POST["menu_right_units"];
	else $menu_right_units = 0;
	
	if (is_numeric($_POST["menu_width"])) $menu_width = $_POST["menu_width"];
	else $menu_width = -1;
	if (is_numeric($_POST["menu_width_units"])) $menu_width_units = $_POST["menu_width_units"];
	else $menu_width_units = 1;
	if (is_numeric($_POST["top_level_item_width"])) $top_level_item_width = $_POST["top_level_item_width"];
	else $top_level_item_width = -1;
	if (is_numeric($_POST["top_level_item_width_units"])) $top_level_item_width_units = $_POST["top_level_item_width_units"];
	else $top_level_item_width_units = 0;
	if (is_numeric($_POST["top_level_item_height"])) $top_level_item_height = $_POST["top_level_item_height"];
	else $top_level_item_height = -1;
	if (is_numeric($_POST["top_level_item_height_units"])) $top_level_item_height_units = $_POST["top_level_item_height_units"];
	else $top_level_item_height_units = 0;
	if (isset($_POST["top_level_text_align"])) $top_level_text_align = $_POST["top_level_text_align"];
	else $top_level_text_align = "-not selected-";
	if (is_numeric($_POST["top_level_padding_top"])) $top_level_padding_top = $_POST["top_level_padding_top"];
	else $top_level_padding_top = -1;
	if (is_numeric($_POST["top_level_padding_right"])) $top_level_padding_right = $_POST["top_level_padding_right"];
	else $top_level_padding_right = -1;
	if (is_numeric($_POST["top_level_padding_bottom"])) $top_level_padding_bottom = $_POST["top_level_padding_bottom"];
	else $top_level_padding_bottom = -1;
	if (is_numeric($_POST["top_level_padding_left"])) $top_level_padding_left = $_POST["top_level_padding_left"];
	else $top_level_padding_left = -1;
	
	if (is_numeric($_POST["top_level_padding_top_units"])) $top_level_padding_top_units = $_POST["top_level_padding_top_units"];
	else $top_level_padding_top_units = 0;
	if (is_numeric($_POST["top_level_padding_right_units"])) $top_level_padding_right_units = $_POST["top_level_padding_right_units"];
	else $top_level_padding_right_units = 0;
	if (is_numeric($_POST["top_level_padding_bottom_units"])) $top_level_padding_bottom_units = $_POST["top_level_padding_bottom_units"];
	else $top_level_padding_bottom_units = 0;
	if (is_numeric($_POST["top_level_padding_left_units"])) $top_level_padding_left_units = $_POST["top_level_padding_left_units"];
	else $top_level_padding_left_units = 0;
	
	if (is_numeric($_POST["sub_level_offset_top"])) $sub_level_offset_top = $_POST["sub_level_offset_top"];
	else $sub_level_offset_top = -1000000;
	if (is_numeric($_POST["sub_level_offset_top_units"])) $sub_level_offset_top_units = $_POST["sub_level_offset_top_units"];
	else $sub_level_offset_top_units = 0;
	if (is_numeric($_POST["sub_level_offset_left"])) $sub_level_offset_left = $_POST["sub_level_offset_left"];
	else $sub_level_offset_left = -1000000;
	if (is_numeric($_POST["sub_level_offset_left_units"])) $sub_level_offset_left_units = $_POST["sub_level_offset_left_units"];
	else $sub_level_offset_left_units = 0;
	if (is_numeric($_POST["sub_level_1_item_width"])) $sub_level_1_item_width = $_POST["sub_level_1_item_width"];
	else $sub_level_1_item_width = -1;
	if (is_numeric($_POST["sub_level_1_item_width_units"])) $sub_level_1_item_width_units = $_POST["sub_level_1_item_width_units"];
	else $sub_level_1_item_width_units = 0;
	if (is_numeric($_POST["sub_level_1_item_height"])) $sub_level_1_item_height = $_POST["sub_level_1_item_height"];
	else $sub_level_1_item_height = -1;
	if (is_numeric($_POST["sub_level_1_item_height_units"])) $sub_level_1_item_height_units = $_POST["sub_level_1_item_height_units"];
	else $sub_level_1_item_height_units = 0;
	if (is_numeric($_POST["sub_level_1_padding_top"])) $sub_level_1_padding_top = $_POST["sub_level_1_padding_top"];
	else $sub_level_1_padding_top = -1;
	if (is_numeric($_POST["sub_level_1_padding_right"])) $sub_level_1_padding_right = $_POST["sub_level_1_padding_right"];
	else $sub_level_1_padding_right = -1;
	if (is_numeric($_POST["sub_level_1_padding_bottom"])) $sub_level_1_padding_bottom = $_POST["sub_level_1_padding_bottom"];
	else $sub_level_1_padding_bottom = -1;
	if (is_numeric($_POST["sub_level_1_padding_left"])) $sub_level_1_padding_left = $_POST["sub_level_1_padding_left"];
	else $sub_level_1_padding_left = -1;
	
	if (is_numeric($_POST["sub_level_1_padding_top_units"])) $sub_level_1_padding_top_units = $_POST["sub_level_1_padding_top_units"];
	else $sub_level_1_padding_top_units = 0;
	if (is_numeric($_POST["sub_level_1_padding_right_units"])) $sub_level_1_padding_right_units = $_POST["sub_level_1_padding_right_units"];
	else $sub_level_1_padding_right_units = 0;
	if (is_numeric($_POST["sub_level_1_padding_bottom_units"])) $sub_level_1_padding_bottom_units = $_POST["sub_level_1_padding_bottom_units"];
	else $sub_level_1_padding_bottom_units = 0;
	if (is_numeric($_POST["sub_level_1_padding_left_units"])) $sub_level_1_padding_left_units = $_POST["sub_level_1_padding_left_units"];
	else $sub_level_1_padding_left_units = 0;
	
	if (is_numeric($_POST["sub_level_2_item_width"])) $sub_level_2_item_width = $_POST["sub_level_2_item_width"];
	else $sub_level_2_item_width = -1;
	if (is_numeric($_POST["sub_level_2_item_width_units"])) $sub_level_2_item_width_units = $_POST["sub_level_2_item_width_units"];
	else $sub_level_2_item_width_units = 0;
	if (is_numeric($_POST["sub_level_2_item_height"])) $sub_level_2_item_height = $_POST["sub_level_2_item_height"];
	else $sub_level_2_item_height = -1;
	if (is_numeric($_POST["sub_level_2_item_height_units"])) $sub_level_2_item_height_units = $_POST["sub_level_2_item_height_units"];
	else $sub_level_2_item_height_units = 0;
	if (is_numeric($_POST["sub_level_2_padding_top"])) $sub_level_2_padding_top = $_POST["sub_level_2_padding_top"];
	else $sub_level_2_padding_top = -1;
	if (is_numeric($_POST["sub_level_2_padding_right"])) $sub_level_2_padding_right = $_POST["sub_level_2_padding_right"];
	else $sub_level_2_padding_right = -1;
	if (is_numeric($_POST["sub_level_2_padding_bottom"])) $sub_level_2_padding_bottom = $_POST["sub_level_2_padding_bottom"];
	else $sub_level_2_padding_bottom = -1;
	if (is_numeric($_POST["sub_level_2_padding_left"])) $sub_level_2_padding_left = $_POST["sub_level_2_padding_left"];
	else $sub_level_2_padding_left = -1;
	
	if (is_numeric($_POST["sub_level_2_padding_top_units"])) $sub_level_2_padding_top_units = $_POST["sub_level_2_padding_top_units"];
	else $sub_level_2_padding_top_units = 0;
	if (is_numeric($_POST["sub_level_2_padding_right_units"])) $sub_level_2_padding_right_units = $_POST["sub_level_2_padding_right_units"];
	else $sub_level_2_padding_right_units = 0;
	if (is_numeric($_POST["sub_level_2_padding_bottom_units"])) $sub_level_2_padding_bottom_units = $_POST["sub_level_2_padding_bottom_units"];
	else $sub_level_2_padding_bottom_units = 0;
	if (is_numeric($_POST["sub_level_2_padding_left_units"])) $sub_level_2_padding_left_units = $_POST["sub_level_2_padding_left_units"];
	else $sub_level_2_padding_left_units = 0;
	
	if (isset($_POST["sub_level_1_text_align"])) $sub_level_1_text_align = $_POST["sub_level_1_text_align"];
	else $sub_level_1_text_align = "-not selected-";
	if (isset($_POST["sub_level_2_text_align"])) $sub_level_2_text_align = $_POST["sub_level_2_text_align"];
	else $sub_level_2_text_align = "-not selected-";
	if (isset($_POST["proportional_width_top"])) $proportional_width_top = $_POST["proportional_width_top"];
	else $proportional_width_top = 0;
	if (isset($_POST["proportional_width_sub"])) $proportional_width_sub = $_POST["proportional_width_sub"];
	else $proportional_width_sub = 0;
	if (isset($_POST["sub_level_collapse"])) $sub_level_collapse = true;
	else $sub_level_collapse = false;
	
	if (is_numeric($_POST["top_level_item_spacing"])) $top_level_item_spacing = $_POST["top_level_item_spacing"];
	else $top_level_item_spacing = -1000000;
	if (is_numeric($_POST["top_level_item_spacing_units"])) $top_level_item_spacing_units = $_POST["top_level_item_spacing_units"];
	else $top_level_item_spacing_units = 0;
	if (is_numeric($_POST["sub_level_1_item_spacing"])) $sub_level_1_item_spacing = $_POST["sub_level_1_item_spacing"];
	else $sub_level_1_item_spacing = -1000000;
	if (is_numeric($_POST["sub_level_1_item_spacing_units"])) $sub_level_1_item_spacing_units = $_POST["sub_level_1_item_spacing_units"];
	else $sub_level_1_item_spacing_units = 0;
	if (is_numeric($_POST["sub_level_2_item_spacing"])) $sub_level_2_item_spacing = $_POST["sub_level_2_item_spacing"];
	else $sub_level_2_item_spacing = -1000000;
	if (is_numeric($_POST["sub_level_2_item_spacing_units"])) $sub_level_2_item_spacing_units = $_POST["sub_level_2_item_spacing_units"];
	else $sub_level_2_item_spacing_units = 0;

	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
			
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, padding_top=0, padding_right=0, padding_bottom=0,"
		. " padding_left=0, margin_top=0, margin_right=0, margin_left=0, margin_bottom=0, display='-not selected-',"
		. " list_style_type='none' WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	}
	else
	{
		//Insert new data into table.	Note: border set to -2 to indicate first time setup.  This triggers loading of default styles.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix . ", .nav" . $suffix . " ul', use_table_data=1, padding_top=0,"
		. " padding_right=0, padding_bottom=0, padding_left=0, margin_top=0, margin_right=0, margin_left=0, margin_bottom=0, display='-not selected-',"
		. " list_style_type='none', border=-2";
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = 'ul.nav" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		if ($orientation == "horizontal_fixed_width")
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, display='-not selected-', width=". $menu_width . ", width_units="
			. $menu_width_units . ", width_prefix='-not selected-', table_layout='-not selected-' WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . "'";
		elseif ($orientation == "horizontal_variable_width")
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, display='table', width=-1, table_layout='-not selected-'"
			. " WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . "'";
		else
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, display='table', width=" . $top_level_item_width 
			. ", width_units=" . $top_level_item_width_units . ", width_prefix='min', table_layout='-not selected-'"
			. " WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		if ($orientation == "horizontal_fixed_width")
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix . "', use_table_data=1, display='-not selected-', width=" 
			. $menu_width . ", width_units=" . $menu_width_units . ", width_prefix='-not selected-', table_layout='-not selected-'";
		elseif ($orientation == "horizontal_variable_width")
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix . "', use_table_data=1, display='table', width=-1, table_layout='-not selected-'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix 
			. "', use_table_data=1, display='table', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units 
			. ", width_prefix='min', table_layout='-not selected-'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.top_level_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		if ($orientation == "horizontal_fixed_width")
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, display='flex', table_layout='-not selected-', justify_content='space-between', list_style_type='none' WHERE style_sheet = '" . $menu . "' AND class='.top_level_ul" . $suffix . "'";
		else
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=0 WHERE style_sheet = '" . $menu . "' AND class='.top_level_ul" . $suffix . "'";
	}
	else
	{
		if ($orientation == "horizontal_fixed_width")
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, style_sheet = '" . $menu . "', class='.top_level_ul" . $suffix . "', display='flex', table_layout='-not selected-', justify_content='space-between', list_style_type='none'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET use_table_data=0, style_sheet = '" . $menu . "', class='.top_level_ul" . $suffix . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = 'ul.nav" . $suffix . ">li'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	

	if ($row_count > 0)
	{	
		//Update class record.
		if ($orientation == "vertical")	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, position='relative', display='-not selected-', `float`='-not selected-'"
			. ", z_index=5 WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . ">li'";
		}
		else	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, position='relative', display='block', `float`='left'"
			. ", z_index=5 WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . ">li'";
		}
	}
	else
	{
		//Insert new data into table.
		if ($orientation == "vertical")	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix . ">li', use_table_data=1"
			. ", position='relative', display='-not selected-', `float`='-not selected-', z_index=5";
		}
		else	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix . ">li', use_table_data=1"
			. ", position='relative', display='block', `float`='left', z_index=5";
		}
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.top_level_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		if ($orientation == "vertical")	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $top_level_text_align 
			. "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='-not selected-', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top	. ", padding_top_units=" . $top_level_padding_top_units 
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_bottom=" . $top_level_item_spacing . ", margin_bottom_units=" . $top_level_item_spacing_units
			. " WHERE style_sheet = '" . $menu . "' AND class='.top_level_a" . $suffix . "'";
		}
		else	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $top_level_text_align 
			. "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='min', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top	. ", padding_top_units=" . $top_level_padding_top_units 
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_right=" . $top_level_item_spacing . ", margin_right_units=" . $top_level_item_spacing_units
			. " WHERE style_sheet = '" . $menu . "' AND class='.top_level_a" . $suffix . "'";
		}
	}
	else
	{
		//Insert new data into table.
		if ($orientation == "vertical")	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.top_level_a" . $suffix 
			. "', use_table_data=1, align='" . $top_level_text_align . "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='-not selected-', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top. ", padding_top_units=" . $top_level_padding_top_units
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_bottom=" . $top_level_item_spacing . ", margin_bottom_units=" . $top_level_item_spacing_units;
		}
		else	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.top_level_a" . $suffix 
			. "', use_table_data=1, align='" . $top_level_text_align . "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='min', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top. ", padding_top_units=" . $top_level_padding_top_units
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_right=" . $top_level_item_spacing . ", margin_right_units=" . $top_level_item_spacing_units;
		}
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.top_level_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		if ($orientation == "vertical")	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $top_level_text_align 
			. "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='-not selected-', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top	. ", padding_top_units=" . $top_level_padding_top_units 
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_bottom=" . $top_level_item_spacing . ", margin_bottom_units=" . $top_level_item_spacing_units
			. " WHERE style_sheet = '" . $menu . "' AND class='.top_level_a_down" . $suffix . "'";
		}
		else	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $top_level_text_align 
			. "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='min', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top	. ", padding_top_units=" . $top_level_padding_top_units 
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_right=" . $top_level_item_spacing . ", margin_right_units=" . $top_level_item_spacing_units
			. " WHERE style_sheet = '" . $menu . "' AND class='.top_level_a_down" . $suffix . "'";
		}
	}
	else
	{
		//Insert new data into table.
		if ($orientation == "vertical")	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.top_level_a_down" . $suffix 
			. "', use_table_data=1, align='" . $top_level_text_align . "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='-not selected-', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top. ", padding_top_units=" . $top_level_padding_top_units
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_right=" . $top_level_item_spacing. ", margin_right_units=" . $top_level_item_spacing_units;
		}
		else	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.top_level_a_down" . $suffix 
			. "', use_table_data=1, align='" . $top_level_text_align . "', width=" . $top_level_item_width . ", width_units=" . $top_level_item_width_units
			. ", width_prefix='min', line_height=" . $top_level_item_height . ", line_height_units=" . $top_level_item_height_units
			. ", padding_top=" . $top_level_padding_top. ", padding_top_units=" . $top_level_padding_top_units
			. ", padding_right=" . $top_level_padding_right . ", padding_right_units=" . $top_level_padding_right_units
			. ", padding_bottom=" . $top_level_padding_bottom . ", padding_bottom_units=" . $top_level_padding_bottom_units
			. ", padding_left=" . $top_level_padding_left . ", padding_left_units=" . $top_level_padding_left_units
			. ", margin_bottom=" . $top_level_item_spacing . ", margin_bottom_units=" . $top_level_item_spacing_units;
		}
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = 'ul.nav" . $suffix . " li>ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($sub_level_collapse == true)
		$position_display_str = "position='absolute', display='none'";
	else
		$position_display_str = "position='', display=''";
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, margin_top=" . $sub_level_offset_top . ", margin_top_units=" . $sub_level_offset_top_units 
		. ", margin_left=" . $sub_level_offset_left . ", margin_left_units=" . $sub_level_offset_left_units
		. ", " . $position_display_str . " WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . " li>ul'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix . " li>ul', use_table_data=1, margin_top=" . $sub_level_offset_top
		. ", margin_top_units=" . $sub_level_offset_top_units 
		. ", margin_left=" . $sub_level_offset_left . ", margin_left_units=" . $sub_level_offset_left_units
		. ", " . $position_display_str . "";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = 'ul.nav" . $suffix . " li:hover>ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, display='block', z_index=3 WHERE style_sheet = '" . $menu . "' AND class='ul.nav" . $suffix . " li:hover>ul'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='ul.nav" . $suffix . " li:hover>ul', use_table_data=1, display='block', z_index=3";
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.nav" . $suffix . " ul li a'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1"
		. ", display='block' WHERE style_sheet = '" . $menu . "' AND class='.nav" . $suffix . " ul li a'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.nav" . $suffix . " ul li a', use_table_data=1"
		. ", display='block'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.menu_div" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if (($orientation == "horizontal_fixed_width") && ($menu_width_units == 1))
		$menu_width_str = ", width=". $menu_width . ", width_units=" . $menu_width_units;
	elseif ($orientation == "horizontal_fixed_width")
		$menu_width_str = ", width=-1";
	else
		$menu_width_str = "";

	if ($row_count > 0)
	{	
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, position='" . $position
		. "', position_top=" . $menu_top . ", position_top_units=" . $menu_top_units . ", position_left=" . $menu_left
		. ", position_left_units=" . $menu_left_units . ", position_bottom='" . $menu_bottom . "', position_bottom_units=" . $menu_bottom_units . ", position_right='" 
		. $menu_right . "', position_right_units="  . $menu_right_units . ", display='block', z_index=2" . $menu_width_str . " WHERE style_sheet = '" . $menu . "' AND class='.menu_div" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.menu_div" . $suffix
		. "', use_table_data=1, position='" . $position . "',"
		. " position_top=" . $menu_top . ", position_top_units=" . $menu_top_units . ", position_left=" . $menu_left
		. ", position_left_units=" . $menu_left_units . ", position_bottom='" . $menu_bottom . "', position_bottom_units=" . $menu_bottom_units . ", position_right='" 
		. $menu_right . "', position_right_units="  . $menu_right_units . ", display='block', z_index=2" . $menu_width_str;
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_1_text_align . "', padding_top="
		. $sub_level_1_padding_top . ", padding_top_units=" . $sub_level_1_padding_top_units
		. ", padding_right=" . $sub_level_1_padding_right . ", padding_right_units=" . $sub_level_1_padding_right_units
		. ", padding_bottom=" . $sub_level_1_padding_bottom . ", padding_bottom_units=" . $sub_level_1_padding_bottom_units
		. ", padding_left=" . $sub_level_1_padding_left . ", padding_left_units=" . $sub_level_1_padding_left_units
		. ", width=" . $sub_level_1_item_width . ", width_units=" . $sub_level_1_item_width_units
		. ", line_height=" . $sub_level_1_item_height . ", line_height_units=" . $sub_level_1_item_height_units
		. ", margin_bottom=" . $sub_level_1_item_spacing . ", margin_bottom_units=" . $sub_level_1_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_1_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu 
		. "', class='.sub_level_1_a" . $suffix . "', use_table_data=1, align='" . $sub_level_1_text_align
		. "', width=" . $sub_level_1_item_width . ", width_units=" . $sub_level_1_item_width_units
		. ", line_height=" . $sub_level_1_item_height . ", line_height_units=" . $sub_level_1_item_height_units
		. ", padding_top=" . $sub_level_1_padding_top . ", padding_top_units=" . $sub_level_1_padding_top_units
		. ", padding_right=" . $sub_level_1_padding_right . ", padding_right_units=" . $sub_level_1_padding_right_units
		. ", padding_bottom=" . $sub_level_1_padding_bottom . ", padding_bottom_units=" . $sub_level_1_padding_bottom_units
		. ", padding_left=" . $sub_level_1_padding_left . ", padding_left_units=" . $sub_level_1_padding_left_units
		. ", margin_bottom=" . $sub_level_1_item_spacing . ", margin_bottom_units=" . $sub_level_1_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_1_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.		
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_1_text_align . "', padding_top="
		. $sub_level_1_padding_top . ", padding_top_units=" . $sub_level_1_padding_top_units
		. ", padding_right=" . $sub_level_1_padding_right . ", padding_right_units=" . $sub_level_1_padding_right_units
		. ", padding_bottom=" . $sub_level_1_padding_bottom . ", padding_bottom_units=" . $sub_level_1_padding_bottom_units
		. ", padding_left=" . $sub_level_1_padding_left . ", padding_left_units=" . $sub_level_1_padding_left_units
		. ", width=" . $sub_level_1_item_width . ", width_units=" . $sub_level_1_item_width_units
		. ", line_height=" . $sub_level_1_item_height . ", line_height_units=" . $sub_level_1_item_height_units
		. ", margin_bottom=" . $sub_level_1_item_spacing . ", margin_bottom_units=" . $sub_level_1_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_1_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu 
		. "', class='.sub_level_1_a_down" . $suffix . "', use_table_data=1, align='" . $sub_level_1_text_align
		. "', width=" . $sub_level_1_item_width . ", width_units=" . $sub_level_1_item_width_units
		. ", line_height=" . $sub_level_1_item_height . ", line_height_units=" . $sub_level_1_item_height_units
		. ", padding_top=" . $sub_level_1_padding_top . ", padding_top_units=" . $sub_level_1_padding_top_units
		. ", padding_right=" . $sub_level_1_padding_right . ", padding_right_units=" . $sub_level_1_padding_right_units
		. ", padding_bottom=" . $sub_level_1_padding_bottom . ", padding_bottom_units=" . $sub_level_1_padding_bottom_units
		. ", padding_left=" . $sub_level_1_padding_left . ", padding_left_units=" . $sub_level_1_padding_left_units
		. ", margin_bottom=" . $sub_level_1_item_spacing . ", margin_bottom_units=" . $sub_level_1_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_2_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_2_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_2_a" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_2_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_2_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_2_a_down" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_3_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_3_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_3_a" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_3_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_3_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_3_a_down" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_4_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_4_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_4_a" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_4_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_4_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_4_a_down" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_5_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_5_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_5_a" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_5_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units
		. " WHERE style_sheet = '" . $menu . "' AND class='.sub_level_5_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $menu . "', class='.sub_level_5_a_down" . $suffix . "', use_table_data=1, align='" . $sub_level_2_text_align
		. "', width=" . $sub_level_2_item_width . ", width_units=" . $sub_level_2_item_width_units
		. ", line_height=" . $sub_level_2_item_height . ", line_height_units=" . $sub_level_2_item_height_units 
		. ", padding_top=" . $sub_level_2_padding_top . ", padding_top_units=" . $sub_level_2_padding_top_units
		. ", padding_right=" . $sub_level_2_padding_right . ", padding_right_units=" . $sub_level_2_padding_right_units
		. ", padding_bottom=" . $sub_level_2_padding_bottom . ", padding_bottom_units=" . $sub_level_2_padding_bottom_units
		. ", padding_left=" . $sub_level_2_padding_left . ", padding_left_units=" . $sub_level_2_padding_left_units
		. ", margin_bottom=" . $sub_level_2_item_spacing . ", margin_bottom_units=" . $sub_level_2_item_spacing_units;
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	//Update menu list for proportional widths.
	$query = "UPDATE " . BWB_TABLE_PREFIX . "menus SET proportional=" . $proportional_width_top . ", proportional_sub=" . $proportional_width_sub . " WHERE menu_name='" . $menu . "'";
	$cnt = $bwb_dbh->exec($query);


	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString($menu, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
			

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo ADD_PLUGIN_TO_PAGE_COULD_NOT_RENAME_MSG . " $file_name " . TO_WORD ." $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(UPLOAD_TEMPLATE_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	echo 1;
?>
