<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/12/2009	ELL
// Revised: 11/10/2009	ELL
// Added insertion of individual item class for item by item styling.
// Added proportionalizing.
// Revised: 2/9/2012	ELL
// Added table prefix handling.
// Revised: 6/9/2012	ELL
// Modified for use with shopping cart as well.  Uses $use_with_cart to determine if BWB_BASE_DIR and BWB_WEBPAGE_DIR
// need to be prepended to simple webpage links (selected from dropdown list as they are in webpage folder).
// Modified: 10/15/2012	ELL
// Added use of new `name` field for 'name' attribute.  It turns out that & codes in 'name' attribute are affecting
// menu spacing, so need to trap out these codes before saving in `name`.
// Modified: 12/26/2014	ELL
// Added down-state classes and logic for deployment.
// Revised: 3/23/2015	ELL
// Added modal switching to mobile menu if mobile client detected.
// Revised: 7/19/2015	ELL
// Fixed bug with getting mobile menu items if mobile.
// Revised: 12/2/2016	ELL
// Consolidated all menu items tables into menu_items.
// Revised: 3/14/2017	BAK
// Added additional classes for down state.
// Revised: 8/18/2017	ELL
// Added ability to to top-level item in down state if sub-level item is down.
// Revised: 10/3/2017	ELL
// Modified down-state testing to compare to base URL to page name instead of full URL to handle possibility of parameters being passed
// that cause page name to be otherwise obscurred.
// 

	$default_menu_width = 900;
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menu_assignments` WHERE `border_area` = '" . $border_area . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)
	{
		// Get menu index as suffix.
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$menu_name = $row["menu_name"];
		
		if (strlen($menu_name) > 4)
			$suffix = substr($menu_name, 4);
		else
			$suffix = "";
	
		if ($is_mobile === true)	{
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu = 'menu" . $suffix . "_mobile'";
			$result = $bwb_dbh->query($query);
			
			if ($result->rowCount() > 0)	{
				$menu_name .= "_mobile";
			}
		}
		
		/////////// Check for correct type and get proportional flag. ///////////////////
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` WHERE `menu_name` = '" . $menu_name . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$proportional = $row["proportional"];
		$proportional_sub = $row["proportional_sub"];
		$top_down_on_sub_down = $row["top_down_on_sub_down"];
		///////////////////////////////////////////////////////
		
		if ($proportional == 1)	// If proportional, then need to calculate average menu size.
		{
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' AND level=0";
			$result = $bwb_dbh->query($query);
			$total_menu_items_top = $result->rowCount();
			$total_menu_chars_top = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$item_text = $row['item_text'];
				$total_menu_chars_top = $total_menu_chars_top + strlen($item_text);
			}
			if ($total_menu_items_top > 0)
				$ave_menu_size_top = $total_menu_chars_top/$total_menu_items_top;
			else
				$ave_menu_size_top = 20;

			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet='" . $menu_name . "' AND `class`='.top_level_a" . $suffix . "'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)
				$row = $result->fetch(PDO::FETCH_ASSOC);
			else
				$row['width'] == -1;
			
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet='" . $menu_name . "' AND `class`='ul.nav" . $suffix . ">li'";
			$result2 = $bwb_dbh->query($query);
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			
			if (is_numeric($row['width']) && ($row['width'] > 0))	{
				$top_level_width = $row['width'];
				$top_level_width_units = $row['width_units'];
			}
			elseif (is_numeric($row2['width']) && ($row2['width'] > 0))	{
				$top_level_width = $row2['width'];
				$top_level_width_units = $row2['width_units'];
			}
			
			if ($top_level_width_units == 1) // Item width in percent
			{
				$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet='" . $menu_name . "' AND `class`='ul.nav" . $suffix . "'";
				$result = $bwb_dbh->query($query);
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$menu_width = $row['width'];
				$menu_width_units = $row['width_units'];
				if ($menu_width == -1)
					$menu_width = $default_menu_width;	// If not set then assume 900 px.
				elseif ($menu_width_units == 1)	// Menu width in percent
					$menu_width = $default_menu_width * $menu_width/100;	// Percent of 900 px.
				$top_level_width = $menu_width * $top_level_width/100;
			}	
		}
		
		if ($proportional_sub == 1)	// If proportional sub menus, then need to calculate average submenu sizes.
		{
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' AND level = 1";
			$result = $bwb_dbh->query($query);
			$total_menu_items_sub_1 = $result->rowCount();
			$total_menu_chars_sub_1 = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$item_text = $row['item_text'];
				$total_menu_chars_sub_1 = $total_menu_chars_sub_1 + strlen($item_text);
			}
			if ($ave_menu_size_sub_1 > 0)
				$ave_menu_size_sub_1 = $total_menu_chars_sub_1/$total_menu_items_sub_1;
			else
				$ave_menu_size_sub_1 = 20;
			
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' AND level = 2";
			$result = $bwb_dbh->query($query);
			$total_menu_items_sub_2 = $result->rowCount();
			$total_menu_chars_sub_2 = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$item_text = $row['item_text'];
				$total_menu_chars_sub_2 = $total_menu_chars_sub_2 + strlen($item_text);
			}
			if (($ave_menu_size_sub_2 > 0) && ($total_menu_items_sub_2 > 0))
				$ave_menu_size_sub_2 = $total_menu_chars_sub_2/$total_menu_items_sub_2;
			else
				$ave_menu_size_sub_2 = 20;
			
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' AND level = 3";
			$result = $bwb_dbh->query($query);
			$total_menu_items_sub_3 = $result->rowCount();
			$total_menu_chars_sub_3 = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$item_text = $row['item_text'];
				$total_menu_chars_sub_3 = $total_menu_chars_sub_3 + strlen($item_text);
			}
			if (($ave_menu_size_sub_3 > 0) && ($total_menu_items_sub_3 > 0))
				$ave_menu_size_sub_3 = $total_menu_chars_sub_3/$total_menu_items_sub_3;
			else
				$ave_menu_size_sub_3 = 20;
				
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' AND level = 4";
			$result = $bwb_dbh->query($query);
			$total_menu_items_sub_4 = $result->rowCount();
			$total_menu_chars_sub_4 = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$item_text = $row['item_text'];
				$total_menu_chars_sub_4 = $total_menu_chars_sub_4 + strlen($item_text);
			}
			if (($ave_menu_size_sub_4 > 0) && ($total_menu_items_sub_4 > 0))
				$ave_menu_size_sub_4 = $total_menu_chars_sub_4/$total_menu_items_sub_4;
			else
				$ave_menu_size_sub_4 = 20;
				
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' AND level > 4";
			$result = $bwb_dbh->query($query);
			$total_menu_items_sub_5 = $result->rowCount();
			$total_menu_chars_sub_5 = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$item_text = $row['item_text'];
				$total_menu_chars_sub_5 = $total_menu_chars_sub_5 + strlen($item_text);
			}
			if (($ave_menu_size_sub_5 > 0) && ($total_menu_items_sub_5 > 0))
				$ave_menu_size_sub_5 = $total_menu_chars_sub_5/$total_menu_items_sub_5;
			else
				$ave_menu_size_sub_5 = 20;
			
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet='" . $menu_name . "' AND `class`='.sub_level_1_a" . $suffix . "'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)
				$row = $result->fetch(PDO::FETCH_ASSOC);
			else
				$row['width'] == -1;
			
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet='" . $menu_name . "' AND `class`='ul.nav" . $suffix . " li>ul'";
			$result2 = $bwb_dbh->query($query);
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			
			if (is_numeric($row['width']) && ($row['width'] > 0))	{
				$sub_level_width = $row['width'];
				$sub_level_width_units = $row['width_units'];
			}
			elseif (is_numeric($row2['width']) && ($row2['width'] > 0))	{
				$sub_level_width = $row2['width'];
				$sub_level_width_units = $row2['width_units'];
			}
			
			if ($sub_level_width_units == 1) // Item width in percent
			{
				$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet='" . $menu_name . "' AND `class`='ul.nav" . $suffix . "'";
				$result = $bwb_dbh->query($query);
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$menu_width = $row['width'];
				$menu_width_units = $row['width_units'];
				if ($menu_width == -1)
					$menu_width = $default_menu_width;	// If not set then assume 900 px.
				elseif ($menu_width_units == 1)	// Menu width in percent
					$menu_width = $default_menu_width * $menu_width/100;	// Percent of 900 px.
				$sub_level_width = $menu_width * $sub_level_width/100;
			}	
		}
		
		if ($top_down_on_sub_down == 1)
		{
			// Build array of children-to-top level for extended top-level down states.
			$items = array();
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu = '" . $menu_name . "' AND level = 0 ORDER BY sort_order";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)	{
				while ($row = $result->fetch(PDO::FETCH_ASSOC))
				{
					$ID = $row['ID'];
					$sort_order = $row['sort_order'];
					$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu = '" . $menu_name . "' AND sort_order > " . $sort_order . " ORDER BY sort_order";
					$result2 = $bwb_dbh->query($query);
					while ($row2 = $result2->fetch(PDO::FETCH_ASSOC))
					{
						if ($row2['level'] > 0)	{
							$URL = $row2['URL'];
							if ((SEF_URL == 1) && isset($URL) && ($URL != ""))
							{
								if (stripos($URL, "http") === false)
								{
									$URL = "/" . str_replace(".php", "", $URL);
									if (stripos($URL, "?") > 0)
									{
										$URL_arr = explode("?", $URL);
										$param_delims = array("&", "=");
										$params = str_replace($param_delims, "/", $URL_arr[1]);
										$URL = $URL_arr[0] . "/" . $params . "/";
									}
								}
							}
							$items[] = array($ID, $URL);
						}
						else
							break;
					}
				}
			}
		}

		// Check for existence of menue items table.
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' ORDER BY sort_order";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() < 1)	{
			// If menu items table missing, maybe mobile missing.  Try desktop.
			return;
		}
		
		// Initialize navigation HTML.
		$last_level = 0;
		echo "\n<div class='menu_div" . $suffix . "' id='menu_div" . $suffix . "'>\n";
		$one_indent = "   ";
		$indent = $one_indent;
		echo $indent . "<ul class='top_level_ul" . $suffix . " nav" . $suffix . "'>\n";
		
		// Get items and build navigation HTML.
		$list_item_not_closed = 0;
		$item = 1;
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$ID = $row['ID'];
			$item_text = stripslashes($row['item_text']);
			$level = $row['level'];
			$URL = $row['URL'];
			if ((SEF_URL == 1) && isset($URL) && ($URL != ""))
			{
				if (stripos($URL, "http") === false)
				{
					$URL = "/" . str_replace(".php", "", $URL);
					if (stripos($URL, "?") > 0)
					{
						$URL_arr = explode("?", $URL);
						$param_delims = array("&", "=");
						$params = str_replace($param_delims, "/", $URL_arr[1]);
						$URL = $URL_arr[0] . "/" . $params . "/";
					}
				}
			}
			$target = $row['target'];
			$mega_menu = $row['mega_menu'];
			if ($use_with_cart === true)	{
				if (strpos($URL, "/") === false)	{
					if ((BWB_BASE_DIR == "") && (BWB_WEBPAGE_DIR == ""))
						$URL = "/" . $URL;
					elseif ((BWB_BASE_DIR != "") && (BWB_WEBPAGE_DIR == ""))
						$URL = "/" . BWB_BASE_DIR . "/" . $URL;
					elseif ((BWB_BASE_DIR == "") && (BWB_WEBPAGE_DIR != ""))
						$URL = "/" . BWB_WEBPAGE_DIR . "/" . $URL;
					else
						$URL = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/" . $URL;
				}
			}
			
			if (($proportional == 1) && ($level == 0))	// If proportional, then need to calculate item size.
			{
				$item_length = strlen($item_text);
				if ($item_length < $ave_menu_size_top)
				  $item_width = $top_level_width * (($item_length + ($ave_menu_size_top/$item_length))/$ave_menu_size_top);
				else if ($item_length > $ave_menu_size_top)
				  $item_width = $top_level_width * (($item_length - ($item_length/$ave_menu_size_top))/$ave_menu_size_top);
				else
				  $item_width = $top_level_width;
				$item_width = intval(round($item_width));
			}
			
			if (($proportional_sub == 1) && ($level == 1))	// If proportional, then need to calculate item size.
			{
				$item_length = strlen($item_text);
				if ($item_length < $ave_menu_size_sub_1)
				  $item_width = $sub_level_width * (($item_length + ($ave_menu_size_sub_1/$item_length))/$ave_menu_size_sub_1);
				else if ($item_length > $ave_menu_size_sub_1)
				  $item_width = $sub_level_width * (($item_length - ($item_length/$ave_menu_size_sub_1))/$ave_menu_size_sub_1);
				else
				  $item_width = $sub_level_width;
				$item_width = intval(round($item_width));
			}

			if (($proportional_sub == 1) && ($level == 2))	// If proportional, then need to calculate item size.
			{
				$item_length = strlen($item_text);
				if ($item_length < $ave_menu_size_sub_2)
				  $item_width = $sub_level_width * (($item_length + ($ave_menu_size_sub_2/$item_length))/$ave_menu_size_sub_2);
				else if ($item_length > $ave_menu_size_sub_2)
				  $item_width = $sub_level_width * (($item_length - ($item_length/$ave_menu_size_sub_2))/$ave_menu_size_sub_2);
				else
				  $item_width = $sub_level_width;
				$item_width = intval(round($item_width));
			}
			
			if (($proportional_sub == 1) && ($level == 3))	// If proportional, then need to calculate item size.
			{
				$item_length = strlen($item_text);
				if ($item_length < $ave_menu_size_sub_3)
				  $item_width = $sub_level_width * (($item_length + ($ave_menu_size_sub_3/$item_length))/$ave_menu_size_sub_3);
				else if ($item_length > $ave_menu_size_sub_3)
				  $item_width = $sub_level_width * (($item_length - ($item_length/$ave_menu_size_sub_3))/$ave_menu_size_sub_3);
				else
				  $item_width = $sub_level_width;
				$item_width = intval(round($item_width));
			}
			
			if (($proportional_sub == 1) && ($level == 4))	// If proportional, then need to calculate item size.
			{
				$item_length = strlen($item_text);
				if ($item_length < $ave_menu_size_sub_4)
				  $item_width = $sub_level_width * (($item_length + ($ave_menu_size_sub_4/$item_length))/$ave_menu_size_sub_4);
				else if ($item_length > $ave_menu_size_sub_4)
				  $item_width = $sub_level_width * (($item_length - ($item_length/$ave_menu_size_sub_4))/$ave_menu_size_sub_4);
				else
				  $item_width = $sub_level_width;
				$item_width = intval(round($item_width));
			}
			
			if (($proportional_sub == 1) && ($level > 4))	// If proportional, then need to calculate item size.
			{
				$item_length = strlen($item_text);
				if ($item_length < $ave_menu_size_sub_5)
				  $item_width = $sub_level_width * (($item_length + ($ave_menu_size_sub_5/$item_length))/$ave_menu_size_sub_5);
				else if ($item_length > $ave_menu_size_sub_5)
				  $item_width = $sub_level_width * (($item_length - ($item_length/$ave_menu_size_sub_5))/$ave_menu_size_sub_5);
				else
				  $item_width = $sub_level_width;
				$item_width = intval(round($item_width));
			}
			
			if (SEF_URL == 1)
				$cur_page = "/" . str_replace(".php", "", $this_page);
			else
				$cur_page = $this_page;
				
			if (SEF_URL == 1)	{
				$URL_arr = explode("/", $URL);
				$base_URL = "/" . $URL_arr[1];
			}
			else	{
				$URL_arr = explode("?", $URL);
				$base_URL = $URL_arr[0];
			}
							
			if ($level == 0)
			{
				$got_sub_down_in_top = false;
				if ($top_down_on_sub_down == 1)
				{
					foreach ($items as $item_pair)
					{
						if (($item_pair[0] == $ID) && ($item_pair[1] == $cur_page))
							$got_sub_down_in_top = true;
					}
				}
				
				$class_ul = "top_level_ul" . $suffix;
				if (($base_URL == $cur_page) || ($got_sub_down_in_top))	{
					$class_li = "top_level_li_down" . $suffix;
					$class_a = "top_level_a_down" . $suffix;
					$down_class_span = "<span class='top_level_down$suffix'>";
				}
				else	{
					$class_li = "top_level_li" . $suffix;
					$class_a = "top_level_a" . $suffix;
				}	
			}
			else
			{
				if ($level > 5)
					$class_level = 5;
				else
					$class_level = $level;
				$class_ul = "sub_level_ul" . $suffix . " sub_level_" . $class_level . "_ul" . $suffix;
				if ($base_URL == $cur_page)	{
					$class_li = "sub_level_li" . $suffix . " sub_level_" . $class_level . "_li_down" . $suffix;
					$class_a = "sub_level_a" . $suffix . " sub_level_" . $class_level . "_a_down" . $suffix;
					$down_class_span = "<span class='sub_level_down" . $suffix . " sub_level_" . $class_level . "_down" . $suffix . "'>";
				}
				else	{
					$class_li = "sub_level_li" . $suffix . " sub_level_" . $class_level . "_li" . $suffix;
					$class_a = "sub_level_a" . $suffix . " sub_level_" . $class_level . "_a" . $suffix;
				}
			}
			
			if ($base_URL == $cur_page)
				$down_class_span_end = "</span>";
			else	{
				$down_class_span_end = "";
				$down_class_span = "";
			}
			
			if (isset($URL) && ($URL != ""))
				$a = "a";
			else
				$a = "span";
				
			if ($level == $last_level)
			{
				if ($list_item_not_closed > 0)
				{
					echo "</li>\n";	// No change in levels, close off list item.
					$list_item_not_closed--;
				}
				$item_class = "menu" . $suffix . "_item" . $item;
				$item_li_class = "menu" . $suffix . "_item" . $item . "_li";
				if((($proportional == 1) && ($level == 0)) || (($proportional_sub == 1) && ($level > 0)))	{
					if ($level == 0)
						$width_prefix = "min-";
					else
						$width_prefix = "";
					echo $indent . $one_indent . "<li class='" . $class_li . " " . $item_li_class . "'><span class='" . $item_class . "'><$a href='"
					. $URL . "' target='" . $target . "' class='" . $class_a . "' style='" . $width_prefix . "width:" . $item_width . "px;'>" . $down_class_span . $item_text . $down_class_span_end . "</$a></span>";
					if (isset($mega_menu) && ($mega_menu != ""))	{
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $mega_menu . "'";
						$result2 = $bwb_dbh->query($query);
						$row2 = $result2->fetch(PDO::FETCH_ASSOC);
						$mega_menu_content = stripslashes($row2['page_content']);
						echo $mega_menu_content;
					}
				}
				else	{
					echo $indent . $one_indent . "<li class='" . $class_li . " " . $item_li_class . "'><span class='" . $item_class . "'><$a href='" . $URL 
					. "' target='" . $target . "' class='" . $class_a . "'>" . $down_class_span . $item_text . $down_class_span_end . "</$a></span>";
					if (isset($mega_menu) && ($mega_menu != ""))	{
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $mega_menu . "'";
						$result2 = $bwb_dbh->query($query);
						$row2 = $result2->fetch(PDO::FETCH_ASSOC);
						$mega_menu_content = stripslashes($row2['page_content']);
						echo $mega_menu_content;
					}
				}
				$list_item_not_closed++;
				$item++;
			}
			elseif ($level > $last_level)	// Going deeper into sub levels, nest next ul inside of li.
			{
				$indent .= $one_indent;
				echo "\n" . $indent . "<ul class='" . $class_ul . "'>\n";
				$item_class = "menu" . $suffix . "_item" . $item;
				$item_li_class = "menu" . $suffix . "_item" . $item . "_li";
				if((($proportional == 1) && ($level == 0)) || (($proportional_sub == 1) && ($level > 0)))	{
					if ($level == 0)
						$width_prefix = "min-";
					else
						$width_prefix = "";
					echo $indent . $one_indent . "<li class='" . $class_li . " " . $item_li_class . "'><span class='" . $item_class . "'><$a href='"
					. $URL . "' target='" . $target . "' class='" . $class_a . "' style='" . $width_prefix . "width:" . $item_width . "px;'>" . $down_class_span . $item_text . $down_class_span_end . "</$a></span>";
					if (isset($mega_menu) && ($mega_menu != ""))	{
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $mega_menu . "'";
						$result2 = $bwb_dbh->query($query);
						$row2 = $result2->fetch(PDO::FETCH_ASSOC);
						$mega_menu_content = stripslashes($row2['page_content']);
						echo $mega_menu_content;
					}
				}
				else	{
					echo $indent . $one_indent . "<li class='" . $class_li . " " . $item_li_class . "'><span class='" . $item_class . "'><$a href='" . $URL 
					. "' target='" . $target . "' class='" . $class_a . "'>" . $down_class_span . $item_text . $down_class_span_end . "</$a></span>";
					if (isset($mega_menu) && ($mega_menu != ""))	{
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $mega_menu . "'";
						$result2 = $bwb_dbh->query($query);
						$row2 = $result2->fetch(PDO::FETCH_ASSOC);
						$mega_menu_content = stripslashes($row2['page_content']);
						echo $mega_menu_content;
					}
				}
				$list_item_not_closed++;
				$item++;
			}
			elseif ($level < $last_level)
			{
				echo "</li>\n";	// Coming out of sub level, close off this list item and one ul is nested in.
				$level_diff = $last_level - $level;
				while ($level_diff > 0)
				{
					echo $indent . "</ul>\n";
					$indent = substr($indent, 3);
					if ($list_item_not_closed > 0)
					{
						echo $indent . $one_indent . "</li>\n";
						$list_item_not_closed--;
					}
					$level_diff--;
				}
				$item_class = "menu" . $suffix . "_item" . $item;
				$item_li_class = "menu" . $suffix . "_item" . $item . "_li";
				if((($proportional == 1) && ($level == 0)) || (($proportional_sub == 1) && ($level > 0)))	{
					if ($level == 0)
						$width_prefix = "min-";
					else
						$width_prefix = "";
					echo $indent . $one_indent . "<li class='" . $class_li . " " . $item_li_class . "'><span class='" . $item_class . "'><$a href='"
					. $URL . "' target='" . $target . "' class='" . $class_a . "' style='" . $width_prefix . "width:" . $item_width . "px;'>" . $down_class_span . $item_text . $down_class_span_end . "</$a></span>";
					if (isset($mega_menu) && ($mega_menu != ""))	{
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $mega_menu . "'";
						$result2 = $bwb_dbh->query($query);
						$row2 = $result2->fetch(PDO::FETCH_ASSOC);
						$mega_menu_content = stripslashes($row2['page_content']);
						echo $mega_menu_content;
					}
				}
				else	{
					echo $indent . $one_indent . "<li class='" . $class_li . " " . $item_li_class . "'><span class='" . $item_class . "'><$a href='" . $URL 
					. "' target='" . $target . "' class='" . $class_a . "'>" . $down_class_span . $item_text . $down_class_span_end . "</$a></span>";
					if (isset($mega_menu) && ($mega_menu != ""))	{
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $mega_menu . "'";
						$result2 = $bwb_dbh->query($query);
						$row2 = $result2->fetch(PDO::FETCH_ASSOC);
						$mega_menu_content = stripslashes($row2['page_content']);
						echo $mega_menu_content;
					}
				}
				$list_item_not_closed++;
				$item++;
			}
			
			$last_level = $level;
		}
		
		echo "</li>\n";		// Close last list item.
		$list_item_not_closed--;
		
		while ($last_level > 0)
		{
			echo $indent . "</ul>\n";
			if ($list_item_not_closed > 0)
			{
				echo $indent . "</li>\n";	// If list item open then close it.
				$list_item_not_closed--;
			}
			$indent = substr($indent, 3);
			$last_level--;
		}
		echo $indent . "</ul>\n";
		echo "</div>\n";
	}
?>