<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2014	ELL
// Modified: 10/15/2014	ELL
// Added grouping of plugins by category and sub categories.
// Modified: 6/20/2017	ELL
// Added filtering to not list "Console Only' plugins.
// Modified: 10/6/2017	ELL
// Fixed bug with sub categories that have no plugins display div of next sub category.
// Added message on where to get plugins when category or sub category contions no plugin.
// 
// 
	
	include ("check_session.php");
	$saved_page_name = $_GET['page_name'];
	$saved_plugin_name = $_GET['plugin_name'];
	$refresh_buttons = $_GET['refresh_buttons'];
?>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Add Plugin to Page | Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

.vertical_scroll_div	{
	max-height:550px;
	overflow-y:auto;
	overflow-x:hidden;
}

#selected_page	{	margin-top:50px; margin-left:50px;	}
#selected_plugin	{	margin-top:20px; margin-left:50px;	}

#install_plugin_btn	{
	width:105px;
	position:absolute;
	display:block;
	top:550px;
	left:870px;
}
</style>

<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/add_plugin_to_page_select.js"></script>

<script language="javascript" type="text/javascript">
<?php
	echo "var ADD_PLUGIN_TO_PAGE_PAGE_SELECTED = \"" . ADD_PLUGIN_TO_PAGE_PAGE_SELECTED . "\";\n";
	echo "var ADD_PLUGIN_TO_PAGE_PLUGIN_SELECTED = \"" . ADD_PLUGIN_TO_PAGE_PLUGIN_SELECTED . "\";\n";
	echo "var GET_MORE_PLUGINS_BTN = '" . GET_MORE_PLUGINS_BTN . "';\n";
	echo "var CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_1 = '" . CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_1 . "';\n";
	echo "var CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_2 = '" . CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_2 . "';\n";
	echo "var CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_3 = '" . CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_3 . "';\n";
	
	if (isset($saved_page_name) && ($saved_page_name != "") && isset($saved_plugin_name) && ($saved_plugin_name != ""))
	{
		echo "var saved_page_name = '$saved_page_name';\n";
		echo "var saved_plugin_name = '$saved_plugin_name';\n";
	}
	
	$query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `available` = 1";
	$result = $bwb_dbh->query($query);
	$plugin_cnt = $result->rowCount();
	echo "var plugins = new Array();\n";
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		echo "plugins[" . $row['id'] . "] = '" . $row['name'] . "';\n";
	}
?>
</script>

</head>

<body id="workspace_body">

<table width="90%" border="0" align="center">
    <tr><td>
<div class="button_heading_sub_level_1" id="add_plugin_to_page_heading"><div class="button_heading_text_sub_level_1"><?php echo ADD_PLUGIN_TO_PAGE_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
	</td></tr>
</table>

		<form name="frmAddPluginToPage" id="frmAddPluginToPage" method="post" action="add_plugin_to_page.php" enctype="multipart/form-data">
        <table width="90%" border="0" align="center">
          <tr>
            <td width="280">
            <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo ADD_PLUGIN_TO_PAGE_SELECT_PAGE_HEADING; ?></div></div>
            </td>
            <td>
            <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo ADD_PLUGIN_TO_PAGE_SELECT_PLUGIN_HEADING; ?></div></div>
            </td>
          </tr>
          <tr>
           <td valign="top">
           <div class="vertical_scroll_div">
           <?php
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_name = $row["page_name"];
				if ($page_name == $saved_page_name)
					$selected = " down_sub";
				else
					$selected = "";

				if ($page_name == "index")
					$home = " (Home)";
				else
					$home = "";
					
				echo "<div id='page_name_select$i' class='button_sub_level_1$selected' onClick=\"SelectPage('$page_name', $i);\"><span class='button_text_sub_level_1'>$page_name$home</span></div>\n";
			}
			
			?>

            <input type="hidden" name="page_name" id="page_name" />
            <input type="hidden" name="page_cnt" id="page_cnt" value="<?php echo $i; ?>" />
            </div>
           </td>
           <td valign="top">
            <div class="vertical_scroll_div">
          <?php
			$cat_id = 0;
			$parent_cat_id = 0;
			$i = 0;
			$j = 0;
			$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
			
		  	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugin_categories WHERE (((parent_category IS NULL) OR (parent_category = '')) AND (category <> 'Console Only')) ORDER BY sort_order";
			$result = $bwb_dbh->query($query);
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$category = $row['category'];
				$parent_cat_id = $cat_id;
				echo "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;$top_border_style' onClick=\"SelectPluginCategory('$category', $cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$category</span></div>\n";
				$j++;
				$top_border_style = "";
				
				$query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE (`available` = 1) AND (`category` = '$category') ORDER BY `sort_order`";
				$result3 = $bwb_dbh->query($query);
				$num_results = $result3->rowCount();
				if ($num_results > 0)	{
					echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
					$cat_id++;
				}
				
				$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
				while($row3 = $result3->fetch(PDO::FETCH_ASSOC))
				{
					$id = $row3["id"];
					$plugin_name = $row3["name"];
					$description = $row3["description"];
					if ($description != "")
						$description = " - " . $description;
						
					echo "<div id='plugin_select$i' class='button_sub_level_1' style='width:99%;$top_border_style' onClick=\"SelectPlugin('$id', $i);\"><span class='button_text_sub_level_1'>$plugin_name$description</span></div>\n";
					$i++;
					$top_border_style = "";
				}
				if ($num_results > 0)
					echo "</div>\n";
					
				$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugin_categories WHERE (parent_category = '$category') ORDER BY sort_order";
				$result2 = $bwb_dbh->query($query);
				if ($result2->rowCount() > 0)	{
					echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
					$cat_id++;
				}

				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$sub_category = $row2['category'];
//					echo "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;' onClick=\"SelectPluginCategory($cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$sub_category</span></div>\n";
					$sub_cat_div_str = "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;' onClick=\"SelectPluginCategory('$sub_category', $cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$sub_category</span></div>\n";
					$alt_sub_cat_div_str = "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;' onClick=\"DisplayNoPluginsInSubCatMsg('$sub_category', $cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$sub_category</span></div>\n";
					$j++;
					
					$query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE (`available` = 1) AND (`category` = '$sub_category') ORDER BY `sort_order`";
					$result3 = $bwb_dbh->query($query);
					$num_results = $result3->rowCount();
					if ($num_results > 0)	{
						echo $sub_cat_div_str;
						echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
//						$cat_id++;
					}
					else
						echo $alt_sub_cat_div_str;
					$cat_id++;
					
					$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
					while($row3 = $result3->fetch(PDO::FETCH_ASSOC))
					{
						$id = $row3["id"];
						$plugin_name = $row3["name"];
						$description = $row3["description"];
						if ($description != "")
							$description = " - " . $description;
						
						echo "<div id='plugin_select$i' class='button_sub_level_1' style='width:99%;$top_border_style' onClick=\"SelectPlugin('$id', $i);\"><span class='button_text_sub_level_1'>$plugin_name$description</span></div>\n";
						$i++;
						$top_border_style = "";
					}
					if ($num_results > 0)
						echo "</div>\n";
				}
				if ($result2->rowCount() > 0)
					echo "</div>\n";
			}
			$cat_id++;
            ?>
            <div class='button_sub_level_1' style='width:258px;' ><a href="http://breezewebsitebuilder.com/plugins.php" target="_blank" class="button_console_link"><span class='button_text_sub_level_1'><?php echo GET_MORE_PLUGINS_BTN; ?></span></a></div>
            
            <input type="hidden" name="plugin" id="plugin" />
            <input type="hidden" name="plugin_cnt" id="plugin_cnt" value="<?php echo $plugin_cnt; ?>" />
            <input type="hidden" name="cat_cnt" id="cat_cnt" value="<?php echo $cat_id; ?>" />
            </div>
            <div id="selected_page">&nbsp;</div>
            <div id="selected_plugin">&nbsp;</div>
            </td>
          </tr>
         </table>
        
          <div class='button_console_add_disabled' onClick="AddPluginToPage();" id="install_plugin_btn"><span class='button_console_text_w_icon'>Install</span></div>
		
	  </form>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	popup_msg.HidePopupMsg();
	
<?php	if (isset($saved_page_name) && ($saved_page_name != ""))	{	?>
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	popup_msg.status_msg = '<?php echo ADD_PLUGIN_TO_PAGE_PLUGIN_HAS_BEEN_ADDED_TO_PAGE_1_MSG; ?> <b>' + saved_plugin_name + '</b> <?php echo ADD_PLUGIN_TO_PAGE_PLUGIN_HAS_BEEN_ADDED_TO_PAGE_2_MSG; ?> <b>' + saved_page_name + '</b> <?php echo ADD_PLUGIN_TO_PAGE_PLUGIN_HAS_BEEN_ADDED_TO_PAGE_3_MSG; ?>';
	popup_msg.ShowPopupMsg();
<?php	}	?>
		
<?php 
	if ($refresh_buttons)	{
		echo "	parent.LoadPluginButtons();\n";
	}
?>
</script>
</body>
</html>