<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/10/2009	ELL
// Revised: 11/10/2009	ELL
// Added menu item classes and styles for individual item control.
// Revised: 1/8/2011	ELL
// Added menu type to specify whether CSS or JavaScript menu is being added.
// Revised: 11/20/2011	ELL
// Fixed menu item styles table description to have menu number right after "menu".
// Revised: 2/7/2012	ELL
// Added table prefix handling.
// Revised: 3/23/2015	ELL
// Added handling of moblie flag to create menus with name having "_mobile" in them such that page template files can modally use or not use
// moble/desktop menus.
// Modified: 12/2/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Consolidated all menu items tables into menu_items.
// Revised: 3/14/2017	ELL
// Added additional classes for down state.
// 
// 
	include ("check_session.php");
	include ("lib/create_new_menu_class.php");
	
	$description = $_POST['description'];
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` ORDER BY `menu_name` DESC";
	$result = $bwb_dbh->query($query);
	$row_cnt = $result->rowCount();
	if ($row_cnt < 1)
		$suffix = 1;
	else
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$menu_name = $row["menu_name"];
		
		$index = array();
		$i = 1;
		$index[0] = substr($menu_name, strlen("menu"));
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row["menu_name"];
			$index[$i] = substr($menu_name, strlen("menu"));
			$i++;
		}
		sort($index);
		$suffix = $index[$i-1] + 1;
	}

	$new_menu = substr($menu_name, 0, 4) . $suffix;
	$style_description = "CSS Menu " . $suffix . " Styles";
	$item_style_description = "CSS Menu " . $suffix . " Item Styles";
	$new_menu_mobile = substr($menu_name, 0, 4) . $suffix . "_mobile";
	$style_description_mobile = "CSS Menu " . $suffix . " Mobile Styles";
	$item_style_description_mobile = "CSS Menu " . $suffix . " Mobile Item Styles";
	
	// Add to menus table.
	$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "menus` SET `menu_name` = '" . $new_menu . "', `description` = '" . $description . "'";
	$cnt = $bwb_dbh->exec($query);
	$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "menus` SET `menu_name` = '" . $new_menu_mobile . "', `description` = '" . $description . " Mobile'";
	$cnt = $bwb_dbh->exec($query);
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` LIKE 'menu%' ORDER BY `name` DESC";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$sort_order = $row["sort_order"];
	$sort_order++;

	// Add to style sheet list.
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $new_menu . "'";
	$result = $bwb_dbh->query($query);
	$row_cnt = $result->rowCount();
	if ($row_cnt < 1)
	{
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu . "', `description` = '" . $style_description . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
		$cnt = $bwb_dbh->exec($query);
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu_mobile . "', `description` = '" . $style_description_mobile . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
		$cnt = $bwb_dbh->exec($query);
		$sort_order++;
	}
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $new_menu . "_item'";
	$result = $bwb_dbh->query($query);
	$row_cnt = $result->rowCount();
	if ($row_cnt < 1)
	{
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu . "_item', `description` = '" . $item_style_description . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
		$cnt = $bwb_dbh->exec($query);
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu_mobile . "_item', `description` = '" . $item_style_description_mobile . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
		$cnt = $bwb_dbh->exec($query);
	}
		
	// Insert new menu classes.
	$style_sheet = "menu" . $suffix;
	$style_sheet_mobile = "menu" . $suffix . "_mobile";
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_classes WHERE `style_sheet` = 'menu1'";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$class = $row['class'];
		$class = CreateNewMenuClass($class, 1, $suffix);
		$description = $row['description'];
		$sort_order = $row['sort_order'];
		$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes SET `style_sheet` = '" . $style_sheet . "', `class` = '" . $class . "', `description` = '" . $description . "', `sort_order` = " . $sort_order . "";
		$cnt = $bwb_dbh->exec($sql);
		
		$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes SET `style_sheet` = '" . $style_sheet_mobile . "', `class` = '" . $class . "', `description` = '" . $description . "', `sort_order` = " . $sort_order;
		$cnt = $bwb_dbh->exec($sql);
	}

	header("Location: manage_menu.php?menu=$new_menu");
?>