<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	12/15/2015	ELL
// Revised: 2/5/2018	ELL
// Filtered out fonts style sheet as this is created soley under custom fonts management and thus should not be edited in the CSS editor, 
// has no attributes that should be altered, and has no reason to be modified for mobile.
// 

	include ("check_session.php");
	
	$last_style_sheet_edited = $_SESSION['last_style_sheet_edited'];
	
	$sort_alpha = $_GET['sort_alpha'];
	if (isset($sort_alpha) && ($sort_alpha == 1))
		$_SESSION['style_sheet_sort_method'] = 1;
	elseif (isset($sort_alpha) && ($sort_alpha == 0))
		$_SESSION['style_sheet_sort_method'] = 0;
	
	if (isset($_SESSION['style_sheet_sort_method']) && ($_SESSION['style_sheet_sort_method'] == 1))
		$style_sheet_sort_method = 1;
	else
		$style_sheet_sort_method = 0;
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Copy CSS to Mobile CSS | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style>
#sort_checkbox_div	{
	position:absolute;
	left:300px;
	top:60px;
}

#copy_to_mobile_note	{
	display:block;
	position:absolute;
	top:100px;
	left:350px;
	width:50%;
}
</style>

<script src="js/jquery.min.js"></script>
<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/copy_css_to_mobile_select.js"></script>

<script>
<?php
	echo "	var COPY_STYLE_TO_MOBILE_CONFIRM_1_MSG = \"" . COPY_STYLE_TO_MOBILE_CONFIRM_1_MSG . "\";\n";
	echo "	var COPY_STYLE_TO_MOBILE_CONFIRM_2_MSG = \"" . COPY_STYLE_TO_MOBILE_CONFIRM_2_MSG . "\";\n";
	echo "	var COPY_STYLE_TO_MOBILE_CONFIRM_3_MSG = \"" . COPY_STYLE_TO_MOBILE_CONFIRM_3_MSG . "\";\n";	
	echo "	var COPY_STYLE_TO_MOBILE_COMPLETE_MSG = \"" . COPY_STYLE_TO_MOBILE_COMPLETE_MSG . "\";\n";
	echo "	var COPY_STYLE_TO_MOBILE_COMPLETE_ERR = \"" . COPY_STYLE_TO_MOBILE_COMPLETE_ERR . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var TO_WORD = \"" . TO_WORD . "\";\n";
?>
</script>
</head>

<body>
<div class='button_console_go_back' style="width:250px; position:absolute; right:40px; top:0px;" onClick="window.location.href='edit_css_select.php'"><span class='button_console_text_w_icon'><?php echo COPY_STYLE_TO_MOBILE_BACK_TO_EDIT_CSS_SELECT_BTN; ?></span></div>

<div id="sub_level_1_buttons">
        
          <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_SELECT_COPY_STYLES_TO_MOBILE_BTN; ?></div><div class="button_heading_help" onClick="OpenHelpWindow();" style="left:210px;">&nbsp;</div></div>
		    <?php
			if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
				$sort = "`description`, `name`";
			else
				$sort = "sort_order";
				
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE (`name` NOT LIKE '%_mobile%') AND (`name` NOT LIKE '%_item%') AND (`name` <> 'fonts') ORDER BY $sort";
			$result = $bwb_dbh->query($query);
			$style_sheets = array();
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$name = $row["name"];
				$description = $row["description"];
				if ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) === false))
				{
					$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$name'";
					$result2 = $bwb_dbh->query($query2);
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$description = $row2['description'] . " Styles";
				}
				elseif ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) !== false))
				{
					$tmp_name = str_replace("_item", "", $name);
					$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$tmp_name'";
					$result2 = $bwb_dbh->query($query2);
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$description = $row2['description'] . " Item Styles";
				}
				$style_sheets[$name] = $description;
			}
				
			if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
			asort($style_sheets, SORT_FLAG_CASE);
			
			foreach ($style_sheets as $name => $description)
			{
				if ($name == $last_style_sheet_edited)
					$selected = " down_sub";
				else
					$selected = "";

				echo "<div class='button_sub_level_1$selected' onClick=\"CopyToMobileConfirm('$name');\"><span class='button_text_sub_level_1'>$description</span></div>\n";
			}
		?>
</div>

<div id="sort_checkbox_div">
<span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_style_sheet" name="sort_alpha_style_sheet" <?php if ($style_sheet_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeStyleSheetSort(this.checked);" />
</div>

<div id="copy_to_mobile_note"><?php echo COPY_STYLE_TO_MOBILE_NOTE; ?></div>

<?php include("lib/popup_msg.html"); ?>

<script>
	popup_msg.HidePopupMsg();
</script>

</body>
</html>