<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	11/28/2013	ELL
// Revised: 5/27/2016	ELL
// Added lockout of Copy Style Sheet to Mobile.
// Added warning messages about working on menu CSS in CSS editor, and notice about display:list-item; for menus items.
// Revised: 11/10/2016	ELL
// Modified custom CSS editing to allow for any number of custom CSS records associated with custom style sheets.
// Revised: 3/30/2017	ELL
// Added ability to sort style sheets alphabetically.
// Revised: 2/5/2018	ELL
// Filtered out fonts style sheet as this is created soley under custom fonts management and thus should not be edited in the CSS editor, 
// has no attributes that should be altered, and has no reason to be modified for mobile.
// 
	include ("check_session.php");
	
	$last_style_sheet_edited = $_SESSION['last_style_sheet_edited'];
	$last_class_edited = $_SESSION['last_class_edited'];
	
	$sort_alpha = $_GET['sort_alpha'];
	if (isset($sort_alpha) && ($sort_alpha == 1))
		$_SESSION['style_sheet_sort_method'] = 1;
	elseif (isset($sort_alpha) && ($sort_alpha == 0))
		$_SESSION['style_sheet_sort_method'] = 0;
	
	if (isset($_SESSION['style_sheet_sort_method']) && ($_SESSION['style_sheet_sort_method'] == 1))
		$style_sheet_sort_method = 1;
	else
		$style_sheet_sort_method = 0;
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'LockoutCopyStyleSheetToMobile'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$LockoutCopyStyleSheetToMobile = $row['option_value'];
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Edit CSS Select | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<style>
#copy_to_mobile_btn	{
	display:block;
	position:absolute;
	top:50px;
	left:500px;
	cursor:pointer;
}

#btn_manage_style_sheets	{
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 5px -1px;
}

#sort_checkbox_div	{
	position:absolute;
	left:300px;
	top:60px;
}
</style>

<script src="js/edit_css_select.js"></script>
</head>

<body>
<div id="sub_level_1_buttons">
        
          <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_SELECT_HEADING; ?></div><div class="button_heading_help" onClick="OpenHelpWindow('edit_css');">&nbsp;</div></div>
		    <?php
			if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
				$sort = "`description`, `name`";
			else
				$sort = "sort_order";
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> 'fonts' ORDER BY " . $sort;
			$result = $bwb_dbh->query($query);
			$style_sheets = array();
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$name = $row["name"];
				$description = $row["description"];
				if ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) === false))
				{
					$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$name'";
					$result2 = $bwb_dbh->query($query2);
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$description = $row2['description'] . " Styles";
				}
				elseif ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) !== false))
				{
					$tmp_name = str_replace("_item", "", $name);
					$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$tmp_name'";
					$result2 = $bwb_dbh->query($query2);
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$description = $row2['description'] . " Item Styles";
				}
				$style_sheets[$name] = $description;
			}
			
			if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
				asort($style_sheets, SORT_FLAG_CASE);
			
			$i = 1;
			foreach ($style_sheets as $name => $description)
			{
				if ($name == $last_style_sheet_edited)
					$selected = " down_sub";
				else
					$selected = "";
					
				$warning = "";
				$warning_code = "";
				if ((strpos($name, "menu") !== false) && (strpos($name, "_item") === false))
					$warning = " <div class='css_warning' id='warning_$i'>" . EDIT_CSS_SELECT_MENU_WARNING . "</div>\n";
				elseif ((strpos($name, "menu") !== false) && (strpos($name, "_item") !== false))
					$warning = " <div class='css_warning' id='warning_$i'>" . EDIT_CSS_SELECT_MENU_ITEM_WARNING . "</div>\n";
				$top = $i * 31;
				if (strpos($name, "menu") !== false)
					$warning_code = " onmouseover=\"document.getElementById('warning_$i').style='display:block; top:" . $top . "px;';\" onmouseout=\"document.getElementById('warning_$i').style='display:none;';\"";

				echo "<div class='button_sub_level_1$selected' onClick=\"window.location='edit_css.php?style_sheet=$name&goto_class=$last_class_edited';\"$warning_code><span class='button_text_sub_level_1'>$description</span></div>$warning\n";
				$i++;
			}
			
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE show_custom_styles = 1";
			$result = $bwb_dbh->query($query);
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$name = $row['name'];
				$description = $row['description'];
				echo "<div class='button_sub_level_1' onClick=\"window.location='edit_custom_css.php?style_sheet=$name';\"><span class='button_text_sub_level_1'>Custom $description</span></div>\n";
			}
			
		?>
          
          <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_STYLE_SHEET_ATT_HEADING; ?></div><div class="button_heading_help" onClick="OpenHelpWindow('manage_style_sheet_attrib');" style="left:225px;">&nbsp;</div></div>
        
        <div class="button_sub_level_1" id="btn_manage_style_sheets" onClick="window.location='manage_style_sheet_attrib.php';"><span class='button_text_sub_level_1' style="left:40px;"><?php echo EDIT_STYLE_SHEET_ATT_BTN; ?></span></div>
          
</div>

<div id="sort_checkbox_div">
<span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_style_sheet" name="sort_alpha_style_sheet" <?php if ($style_sheet_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeStyleSheetSort(this.checked);" />
</div>

<?php if (($access_level == "admin") && ($LockoutCopyStyleSheetToMobile != 1))	{	?>
<div class="button_heading_sub_level_1" id="copy_to_mobile_btn"><div class="button_heading_text_sub_level_1" onClick="window.location='copy_css_to_mobile_select.php';"><?php echo EDIT_CSS_SELECT_COPY_STYLES_TO_MOBILE_BTN; ?></div><div class="button_heading_help" onClick="OpenHelpWindow('copy_css_to_mobile');" style="left:210px;">&nbsp;</div></div>
<?php }	?>

</body>
</html>