<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/12/2009
// Modified: 1/6/2010	ELL
// Revised list to show descriptions as well as names.
// Added ability to update descriptions after the fact.
// Revised: 1/8/2011	ELL
// Added ability to assign either CSS or JavaScript menus.
// Revised: 4/7/2011	ELL
// Fixed bug of adding JavaScript menu code to header even though CSS menu type upon assigning menus.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/18/2013	ELL
// Added visual feedback for assigning menus.
// Revised: 3/23/2015	ELL
// Added creation of mobile menus with names having "_mobile" in them such that page template files can modally use or not use
// moble/desktop menus.
// Revised: 5/27/2016	ELL
// Added view of pages that border area is assigned to.
// Revised: 2/17/2018	ELL
// Added ability to copy one menu into a new menu.
//
	
	include ("check_session.php");
	
	$menu_name_assigned = $_REQUEST['menu_name'];
	$border_area_assigned = $_REQUEST['border_area'];

?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Menus | Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#manage_menu_assignments_heading	{	width:290px;	}
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:245px;
	height:31px;
	width:31px;
	z-index:100;
}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/manage_menu.js"></script>

<script language="javascript" type="text/javascript" >
function UpdateDescription(menu_name)
{
	if (menu_name == "-not selected-")	{
		document.getElementById("new_description").value = "";
		document.getElementById("update_desc_btn").className = "button_console_save_disabled";
	}
	else	{
		var menu_name_arr = new Array();
		var menu_desc_arr = new Array();
<?php
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY description, menu_name";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	$i = 0;
	$menus = array();
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		$menus[$menu_name] = $description;
		echo "		menu_name_arr[$i] = '$menu_name';\n";
		echo "		menu_desc_arr[$i] = '$description';\n";
		$i++;
	}
	echo "		var count = $i;\n";
?>
	
		for (i = 0; i < count; i++)
		{
			if (menu_name == menu_name_arr[i])
				document.getElementById("new_description").value = menu_desc_arr[i];
		}
		document.getElementById("update_desc_btn").className = "button_console_save";
	}
}

<?php
	echo "	var MANAGE_MENUS_REASSIGN_MENU_TO_COMPLETE_MSG = \"" . MANAGE_MENUS_REASSIGN_MENU_TO_COMPLETE_MSG . "\";\n";
	echo "	var MANAGE_MENUS_DELETE_MENU_CONFIRM_1_MSG = \"" . MANAGE_MENUS_DELETE_MENU_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_MENUS_DELETE_MENU_CONFIRM_2_MSG = \"" . MANAGE_MENUS_DELETE_MENU_CONFIRM_2_MSG . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var _NOT_ASSIGNED_ = \"" . _NOT_ASSIGNED_ . "\";\n";
	echo "	var MANAGE_MENUS_COPY_MENU_CONFIRM_1_MSG = \"" . MANAGE_MENUS_COPY_MENU_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_MENUS_COPY_MENU_CONFIRM_2_MSG = \"" . MANAGE_MENUS_COPY_MENU_CONFIRM_2_MSG . "\";\n";
	echo "	var MANAGE_MENUS_COPY_MENU_CONFIRM_3_MSG = \"" . MANAGE_MENUS_COPY_MENU_CONFIRM_3_MSG . "\";\n";
	echo "	var MANAGE_MENUS_COPY_MENU_ITEMS_CONFIRM_2_MSG = \"" . MANAGE_MENUS_COPY_MENU_ITEMS_CONFIRM_2_MSG . "\";\n";
?>
</script>

</head>

<body id="workspace_body">
<table width="90%" align="center"><tr><td>
<div class="button_heading_sub_level_1" id="manage_menu_assignments_heading"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_MENUS_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>

<table width="90%" align="center" class="group_box_table"><tr>
  <td>
<span class="sub_title"><?php echo MANAGE_MENUS_ADD_MENU; ?></span>
<form name="frmAddMenu" id="frmAddMenu" method="post" action="add_menu.php">
<table width="100%" class="layout_box_table" align="center">
<tr>

<td align="center">
  <?php echo DESCRIPTION_WORD; ?>: 
  <input type="text" name="description" id="description" class="txt_field_long"  onKeyPress="setTimeout('EnableDisableAddMenuBtn(this.value);', 10);" />
</td>
<td align="center">
<img src="theme/<?php echo $theme; ?>/images/uploading.gif" alt="<?php echo UPLOAD_TEMPLATE_UPLOADING; ?>" id="uploading_gif" style="display:none;" />
</td>
<td align="center">
  <div class='button_console_add_disabled' style="width:180px;" onClick="AddMenu();" id="add_menu_btn"><span class='button_console_text_w_icon'><?php echo MANAGE_MENUS_CREATE_NEW_MENU_BTN; ?></span></div>
</td>
</tr>
</table>
</form>
</td></tr></table>
<br />

<table width="90%" align="center" class="group_box_table"><tr><td>
<table width="100%" class="layout_box_table" align="center">
<tr bgcolor="#CCCCCC">
  <td colspan="4"><span class="sub_title"><?php echo MANAGE_MENUS_ASSIGN_MENU_TO_BORDER; ?></span></td></tr>
  <?php
  		$bgcolor = "#EEEEEE";
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special";
		$result = $bwb_dbh->query($query);
		$i = 1;
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$border_area = $row["page_name"];
			echo "<form name='frmAssign$i' id='frmAssign$i' method='post' action='assign_menu.php'>\n";
			echo "<tr bgcolor='$bgcolor'>\n";
			echo "<td>$border_area</td>";
			
			echo "<td>\n";
			echo "<select name=\"menu_name\">\n";
			echo "<option value='-not assigned-'>" . _NOT_ASSIGNED_ . "</option>\n";
			$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` WHERE `menu_name` NOT LIKE '%_mobile' ORDER BY description, menu_name";
			$result2 = $bwb_dbh->query($query2);
			while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
			{
				$menu_name = $row2["menu_name"];
				$description = $row2['description'];
				
				$query3 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menu_assignments` WHERE menu_name = '$menu_name' AND border_area = '$border_area'";
				$result3 = $bwb_dbh->query($query3);
				if ($result3->rowCount() > 0)
					echo "<option value='$menu_name' selected='selected'>$description ($menu_name)</option>\n";
				else
					echo "<option value='$menu_name'>$description ($menu_name)</option>\n";
			}
			echo "</select>\n";
			echo "</td>\n";
			
			if (strpos($border_area, "header") !== false)
				$border_field = "header_name";
			elseif (strpos($border_area, "top") !== false)
				$border_field = "top_name";
			elseif (strpos($border_area, "left") !== false)
				$border_field = "left_name";
			elseif (strpos($border_area, "right") !== false)
				$border_field = "right_name";
			elseif (strpos($border_area, "bottom") !== false)
				$border_field = "bottom_name";
			elseif (strpos($border_area, "footer") !== false)
				$border_field = "footer_name";
			echo "<td style='min-width:20%;'>\n<img src='theme/$theme/images/icon_eye_sm_mo.png' alt='Show pages border area is assigned to.' style='cursor:pointer;' onmouseover=\"document.getElementById('assigned_pages_$i').style.display = 'block';\" onmouseout=\"document.getElementById('assigned_pages_$i').style.display = 'none';\" />\n<div class='border_area_page_list' id='assigned_pages_$i'>\n";
			$query4 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "page_data` WHERE `$border_field` = '$border_area'";
			$result4 = $bwb_dbh->query($query4);
			while($row4 = $result4->fetch(PDO::FETCH_ASSOC))
			{
				echo $row4['page_name'] . "<br />\n";
			}
			echo "</div>\n</td>\n";

			
			
			echo "<td>\n";
			
			echo "<div class='button_console_edit' style='width:110px;' onClick=\"document.getElementById('frmAssign$i').submit();\"><span class='button_console_text_w_icon'>" . ASSIGN_WORD . "</span></div>\n";
			
			echo "<input type='hidden' name='border_area' value='$border_area' />\n";
			echo "</td>\n";
			echo "</tr>\n";
			echo "</form>";
			$i++;
			if ($bgcolor == "#EEEEEE")
				$bgcolor = "#DDDDDD";
			else
				$bgcolor = "#EEEEEE";
		}
   ?>
</table>
</td></tr></table>
<br />

<table width="90%" align="center" class="group_box_table"><tr>
	  <td>
    <span class="sub_title"><?php echo MANAGE_MENUS_DELETE_MENU; ?></span>
	<table width="100%" align="center" class="layout_box_table"><tr>
	  <td align="right"><?php echo MANAGE_MENUS_SELECT_MENU_TO_DELETE; ?>: </td>
	  <td>
		<select name="selectMenuDelete" id="selectMenuDelete">
	<?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE (menu_name != 'menu') AND (menu_name != 'menu1') AND (menu_name NOT LIKE '%_mobile') ORDER BY description, menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			if ($menu_name == $menu)
				echo "<option value='$menu_name' selected='selected'>$description ($menu_name)</option>\n";
			else
				echo "<option value='$menu_name'>$description ($menu_name)</option>\n";
		}
	?>
		</select>
	  </td>
	  <td align="center"><?php if ($row_count > 0) { ?>
	    <div class='button_console_delete' style="width:110px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
      <?php } ?>
	  </td>
	</tr></table>
</td></tr></table>


<br />
<table width="90%" align="center" class="group_box_table"><tr>
	  <td>
    <span class="sub_title"><?php echo MANAGE_MENUS_UPDATE_MENU_DESCRIPTION; ?></span>
    <form name="frmUpdateMenuDesc" id="frmUpdateMenuDesc" method="post" action="update_menu_description.php">
	<table width="100%" align="center" class="layout_box_table"><tr>
	  <td align="right"><?php echo MANAGE_MENUS_SELECT_MENU_TO_REVISE; ?>: </td>
	  <td>
		<select name="selectMenu2" onChange="UpdateDescription(this.value);">
        <option ><?php echo _NOT_SELECTED_; ?></option>
	<?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name NOT LIKE '%_mobile' ORDER BY description, menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			if ($menu_name == $menu)
				echo "<option value='$menu_name' selected='selected'>$description ($menu_name)</option>\n";
			else
				echo "<option value='$menu_name'>$description ($menu_name)</option>\n";
		}
	?>
		</select>
	  </td>
      <td align="right"><?php echo MANAGE_MENUS_NEW_DESCRIPTION; ?>: </td>
      <td><input type="text" name="new_description" id="new_description" class="txt_field_long" /></td>
	  <td align="center">
      <div class='button_console_save_disabled' style="width:110px;" id="update_desc_btn" onClick="SaveDescription();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
	  </td>
	</tr></table>
    </form>
</td></tr></table>
    <br />
    
<table width="90%" align="center" class="group_box_table"><tr>
  <td>
    <span class="sub_title"><?php echo MANAGE_MENUS_COPY_MENU_BTN; ?></span>
    <form name="frmCopyMenu" id="frmCopyMenu" method="post" action="copy_menu.php">
    <table width="100%" class="layout_box_table" align="center">
    <tr>
    
    <td align="center">
      <?php echo DESCRIPTION_WORD; ?>: 
      <input type="text" name="copy_to_description" id="copy_to_description" class="txt_field_long" />
    </td>
    <td align="center">
<?php echo FROM_WORD; ?>:
	<select name="copy_from_menu" id="copy_from_menu" onChange="EnableDisableCopyMenuBtn(this.value);">
    	<option value=""><?php echo _NOT_SELECTED_; ?></option>
<?php
	foreach($menus as $menu_name => $description)
	{
		if (strpos($menu_name, "_mobile") === false)
			echo "		<option value='$menu_name'>$description ($menu_name)</option>\n";
	}
?>
	</select>
    </td>
    <td align="center">
<?php echo TO_1ST_CAP_WORD; ?>:
	<select name="copy_to_menu" id="copy_to_menu" onChange="EnableDisableCopyCntls(this.value);">
<?php
	echo "		<option value='-new-'>---" . MANAGE_MENUS_CREATE_NEW . "---</option>\n";
	foreach($menus as $menu_name => $description)
	{
		if (strpos($menu_name, "_mobile") === false)
			echo "		<option value='$menu_name'>$description ($menu_name)</option>\n";
	}
?>
	</select>
    </td>
    <td align="center">
    <img src="theme/<?php echo $theme; ?>/images/uploading.gif" alt="<?php echo UPLOAD_TEMPLATE_UPLOADING; ?>" id="uploading_gif2" style="display:none;" />
    </td>
    <td align="center">
      <div class='button_console_copy_disabled' style="width:130px;" id="copy_menu_btn" onClick="CopyMenuConfirm();"><span class='button_console_text_w_icon'><?php echo MANAGE_MENUS_COPY_MENU_BTN; ?></span></div>
    </td>
    </tr>
    </table>
    </form>
</td></tr></table>
<br />
    
<table width="90%" align="center" class="group_box_table"><tr>
  <td>
    <span class="sub_title"><?php echo MANAGE_MENUS_COPY_MENU_ITEMS_TO_MOBILE_BTN; ?></span>
    <form name="frmCopyMenuItemsToMobile" id="frmCopyMenuItemsToMobile" method="post" action="copy_menu_items_to_mobile.php">
    <table width="100%" class="layout_box_table" align="center">
    <tr>
    
    <td align="center">
<?php echo MENU_WORD; ?>:
	<select name="menu_to_mobile" id="menu_to_mobile" onChange="EnableDisableCopyMenuItemsBtn(this.value);">
    	<option value=""><?php echo _NOT_SELECTED_; ?></option>
<?php
	foreach($menus as $menu_name => $description)
	{
		if (strpos($menu_name, "_mobile") === false)
			echo "		<option value='$menu_name'>$description ($menu_name)</option>\n";
	}
?>
	</select>
    </td>
    <td align="center">
      <div class='button_console_copy_disabled' style="width:300px;" id="copy_menu_items_btn" onClick="CopyMenuItemsToMobileConfirm();"><span class='button_console_text_w_icon'><?php echo MANAGE_MENUS_COPY_MENU_ITEMS_TO_MOBILE_BTN; ?></span></div>
    </td>
    </tr>
    </table>
    </form>
</td></tr></table>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	popup_msg.HidePopupMsg();
	
<?php
if (isset($menu_name_assigned) && isset($border_area_assigned))
{
?>
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "<?php echo MANAGE_MENUS_MENU_ASSIGNED_1_MSG . " " . MANAGE_MENUS_MENU_ASSIGNED_2_MSG . " <b>" . $menu_name_assigned . "</b> " .MANAGE_MENUS_MENU_ASSIGNED_3_MSG . " <b>" . $border_area_assigned . "</b> " . MANAGE_MENUS_MENU_ASSIGNED_4_MSG; ?>";
	popup_msg.popup_timeout = 3000;
	popup_msg.ShowPopupMsg();
<?php	}	?>
</script>
</body>
</html>