<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/18/09	ELL
// Revised: 11/11/09	ELL
// Added options for proportional item widths.
// Modified: 10/7/2010		ELL
// Added text align.
// Modified: 2/4/2012	ELL
// Added selection for having sub menus collapse and expand.  Default is to collapse and expand.  New option is to show always expanded.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 6/19/2013	ELL
// Added separate text alignment for sub menus.
// Revised: 12/16/2013	ELL
// Modified menu location buttons to only suggest entries.  Added bottom and right offsets as well as manually
// editted positioning.
// Revised: 1/15/2015	ELL
// Added full complement of units to all pertinent attributes.
// Modified: 12/2/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Modified: 3/27/2017	ELL
// Modified location of some styles per class for CSS menu system overhaul.
// Revised: 5/18/2017	ELL
// Modified to ignore menu width if vertical menu.  Note that save_css_menu_params.php was also modified to save top-level menu item width as min width of menu for vertical menus.
// Added fixed to positioning.
// Moved top-level text align to .top_level_aX
// Modified: 8/21/2017	ELL
// Added Ability to latch sub items as expanded when top or any sub is down.
// Modified: 9/18/2017	ELL
// Added user modifiable menu z-index.
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
		
?>
<!DOCTYPE html>
<html>
<head>
<title>Editing <?php echo $menu; ?> CSS Menu Parameters | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#css_menu_parameters_heading	{	width:370px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:330px;
	height:31px;
	width:31px;
	z-index:100;
}

#top_update_btn	{
	display:block;
	position:relative;
	top:-46px;
}
</style>

<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/jquery.min.js"></script>
<script src="js/edit_css_menu_params.js"></script>

<script>
<?php
	echo "	var EDIT_JS_MENU_PARAMETERS_SAVE_SUCCESS_MSG = \"" . EDIT_JS_MENU_PARAMETERS_SAVE_SUCCESS_MSG . "\";\n";
	echo "	var EDIT_JS_MENU_PARAMETERS_SAVE_FAIL_ERR = \"" . EDIT_JS_MENU_PARAMETERS_SAVE_FAIL_ERR . "\";\n";
	echo "	var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
	echo "	var _NOT_SET_ = \"" . _NOT_SET_ . "\";\n";
?>
</script>

</head>

<body id="workspace_body" onLoad="InitializeForm();">

<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td>
<div class="button_heading_sub_level_1" id="css_menu_parameters_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_MENU_PARAMETERS_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
<td class="bold" width="55%">
<?php echo EDIT_CSS_MENU_PARAMETERS_SELECT_MENU; ?>:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	$menus_not_found = true;
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` ORDER BY description, menu_name";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)	{
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
			$menus_not_found = false;
		}
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
	
	if ($menus_not_found === true)
		$menu = "-not selected-";
?>
</select>
</td>
</tr>
</table>

<?php
	if (($menu == "-not selected-") || ($menu == ""))
	{
		echo EDIT_CSS_MENU_PARAMETERS_SELECT_MENU_MSG;
		exit;
	}
	else
	{
		$suffix = substr($menu, 4);
		$search = array("_mobile", "_touchscreen");
		$suffix = str_replace($search, "", $suffix);
	}
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count < 1)
		$load_defaults = 1;
	else
		$load_defaults = 0;
		
echo "<script>\n";
echo "	var load_defaults = $load_defaults;\n";
echo "</script>\n";
	
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = 'ul.nav" . $suffix . ">li'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);

	if ((($row["display"] == "block") && ($row["float"] == "left")) || ($row["display"] == "table-cell"))
		$orientation = "horizontal";
	else
		$orientation = "vertical";
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . ":hover > ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);

	if ($row["display"] == "flex")
		$sub_level_1_orientation = "horizontal";
	else
		$sub_level_1_orientation = "vertical";
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . ":hover > ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);

	if ($row["display"] == "flex")
		$sub_level_2_orientation = "horizontal";
	else
		$sub_level_2_orientation = "vertical";

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if ((!is_null($row["width"])) && ($row["width"] != -1))
		$top_level_item_width = $row["width"];
	elseif ($load_defaults == 1)
		$top_level_item_width = 120;
	else
		$top_level_item_width = _NOT_SET_;
	$top_level_item_width_units = $row["width_units"];

	if ((!is_null($row["line_height"])) && ($row["line_height"] != -1))
		$top_level_item_height = $row["line_height"];
	elseif ($load_defaults == 1)
		$top_level_item_height = 20;
	else
		$top_level_item_height = _NOT_SET_;
	$top_level_item_height_units = $row["line_height_units"];

	if (!is_null($row["padding_top"]) && ($row["padding_top"] != -1))
		$top_level_padding_top = $row["padding_top"];
	elseif ($load_defaults == 1)
		$top_level_padding_top = 2;
	else
		$top_level_padding_top = _NOT_SET_;
	if (!is_null($row["padding_top_units"]))
		$top_level_padding_top_units = $row["padding_top_units"];
	else
		$top_level_padding_top_units = 0;
		
	if (!is_null($row["padding_right"]) && ($row["padding_right"] != -1))
		$top_level_padding_right = $row["padding_right"];
	elseif ($load_defaults == 1)
		$top_level_padding_right = 8;
	else
		$top_level_padding_right = _NOT_SET_;
	if (!is_null($row["padding_right_units"]))
		$top_level_padding_right_units = $row["padding_right_units"];
	else
		$top_level_padding_right_units = 0;
		
	if (!is_null($row["padding_bottom"]) && ($row["padding_bottom"] != -1))
		$top_level_padding_bottom = $row["padding_bottom"];
	elseif ($load_defaults == 1)
		$top_level_padding_bottom = 2;
	else
		$top_level_padding_bottom = _NOT_SET_;
	if (!is_null($row["padding_bottom_units"]))
		$top_level_padding_bottom_units = $row["padding_bottom_units"];
	else
		$top_level_padding_bottom_units = 0;
		
	if (!is_null($row["padding_left"]) && ($row["padding_left"] != -1))
		$top_level_padding_left = $row["padding_left"];
	elseif ($load_defaults == 1)
		$top_level_padding_left = 8;
	else
		$top_level_padding_left = _NOT_SET_;
	if (!is_null($row["padding_left_units"]))
		$top_level_padding_left_units = $row["padding_left_units"];
	else
		$top_level_padding_left_units = 0;
		
	if (!is_null($row["align"]) && ($row["align"] != ""))
		$top_level_text_align = $row["align"];
	else
		$top_level_text_align = "-not selected-";
	
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if ($orientation == "horizontal")	{
		if (!is_null($row["margin_right"]) && ($row["margin_right"] != -1000000))
			$top_level_item_spacing = $row["margin_right"];
		else
			$top_level_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_right_units"]))
			$top_level_item_spacing_units = $row["margin_right_units"];
		else
			$top_level_item_spacing_units = 0;
	}
	else		{
		if (!is_null($row["margin_bottom"]) && ($row["margin_bottom"] != -1000000))
			$top_level_item_spacing = $row["margin_bottom"];
		else
			$top_level_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_bottom_units"]))
			$top_level_item_spacing_units = $row["margin_bottom_units"];
		else
			$top_level_item_spacing_units = 0;
	}
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . " > ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if (!is_null($row["display"]))
	{
		if ($row["display"] == "none")
			$sub_level_collapse = true;
		else
			$sub_level_collapse = false;
	}
	else
		$sub_level_collapse = true;
		
	if (!is_null($row["margin_top"]) && ($row["margin_top"] != -1000000))
		$sub_level_1_offset_top = $row["margin_top"];
	elseif ($load_defaults == 1)	{
		if ($orientation == "horizontal")
			$sub_level_1_offset_top = 0;
		else
			$sub_level_1_offset_top = 20;
	}
	else
		$sub_level_1_offset_top = _NOT_SET_;
	if (!is_null($row["margin_top_units"]))
		$sub_level_1_offset_top_units = $row["margin_top_units"];
	else
		$sub_level_1_offset_top_units = 0;
		
	if (!is_null($row["margin_left"]) && ($row["margin_left"] != -1000000))
		$sub_level_1_offset_left = $row["margin_left"];
	elseif ($load_defaults == 1)	{
		if ($orientation == "horizontal")
			$sub_level_1_offset_left = 140;
		else
			$sub_level_1_offset_left = 20;
	}
	else
		$sub_level_1_offset_left = _NOT_SET_;
	if (!is_null($row["margin_left_units"]))
		$sub_level_1_offset_left_units = $row["margin_left_units"];
	else
		$sub_level_1_offset_left_units = 0;
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . " > ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["margin_top"]) && ($row["margin_top"] != -1000000))
		$sub_level_2_offset_top = $row["margin_top"];
	elseif ($load_defaults == 1)	{
		if ($sub_level_2_orientation == "horizontal")
			$sub_level_2_offset_top = 0;
		else
			$sub_level_2_offset_top = 20;
	}
	else
		$sub_level_2_offset_top = _NOT_SET_;
	if (!is_null($row["margin_top_units"]))
		$sub_level_2_offset_top_units = $row["margin_top_units"];
	else
		$sub_level_2_offset_top_units = 0;
		
	if (!is_null($row["margin_left"]) && ($row["margin_left"] != -1000000))
		$sub_level_2_offset_left = $row["margin_left"];
	elseif ($load_defaults == 1)	{
		if ($sub_level_2_orientation == "horizontal")
			$sub_level_2_offset_left = 140;
		else
			$sub_level_2_offset_left = 20;
	}
	else
		$sub_level_2_offset_left = _NOT_SET_;
	if (!is_null($row["margin_left_units"]))
		$sub_level_2_offset_left_units = $row["margin_left_units"];
	else
		$sub_level_2_offset_left_units = 0;
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = 'ul.nav" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
//	if (($row["table_layout"] != "fixed") && ($orientation == "horizontal"))
	if (($row["display"] == "table") && ($orientation == "horizontal"))
		$orientation = "horizontal_variable_width";
	elseif ($orientation == "horizontal")
		$orientation = "horizontal_fixed_width";
	$menu_width_units = $row["width_units"];
	if (!is_null($row["width"]) && ($row["width"] != -1) && ($orientation != "vertical"))
		$menu_width = $row["width"];
	elseif (($orientation == "horizontal_fixed_width") && ($load_defaults == 1))	{
		$menu_width = 100;
		$menu_width_units = 1;
	}
	elseif ($load_defaults == 1)
		$menu_width = -1;
	else
		$menu_width = _NOT_SET_;
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.menu_div" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ((!is_null($row["position_top"])) && ($row["position_top"] != -1000000))
		$menu_top = $row["position_top"];
	else
		$menu_top = _NOT_SET_;
	if (!is_null($row["position_top_units"]))
		$menu_top_units = $row["position_top_units"];
	else
		$menu_top_units = 0;
		
	if ((!is_null($row["position_left"])) && ($row["position_left"] != -1000000))
		$menu_left = $row["position_left"];
	else
		$menu_left = _NOT_SET_;
	if (!is_null($row["position_left_units"]))
		$menu_left_units = $row["position_left_units"];
	else
		$menu_left_units = 0;
		
	if ((!is_null($row["position_bottom"])) && ($row["position_bottom"] != -1000000))
		$menu_bottom = $row["position_bottom"];
	else
		$menu_bottom = _NOT_SET_;
	if (!is_null($row["position_bottom_units"]))
		$menu_bottom_units = $row["position_bottom_units"];
	else
		$menu_bottom_units = 0;
		
	if ((!is_null($row["position_right"])) && ($row["position_right"] != -1000000))
		$menu_right = $row["position_right"];
	else
		$menu_right = _NOT_SET_;
	if (!is_null($row["position_right_units"]))
		$menu_right_units = $row["position_right_units"];
	else
		$menu_right_units = 0;
		
	if (!is_null($row["position"]))
		$position = $row["position"];
	elseif ($load_defaults == 1)
		$position = "absolute";
	else
		$position = _NOT_SET_;
		
	if (!is_null($row["z_index"]))
		$menu_z_index = $row["z_index"];
	elseif ($load_defaults == 1)
		$menu_z_index = 100;
	else
		$menu_z_index = 0;
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$sub_level_1_text_align = $row["align"];

	if (!is_null($row["padding_top"]) && ($row["padding_top"] != -1))
		$sub_level_1_padding_top = $row["padding_top"];
	elseif ($load_defaults == 1)
		$sub_level_1_padding_top = 2;
	else
		$sub_level_1_padding_top = _NOT_SET_;
	if (!is_null($row["padding_top_units"]))
		$sub_level_1_padding_top_units = $row["padding_top_units"];
	else
		$sub_level_1_padding_top_units = 0;
		
	if (!is_null($row["padding_right"]) && ($row["padding_right"] != -1))
		$sub_level_1_padding_right = $row["padding_right"];
	elseif ($load_defaults == 1)
		$sub_level_1_padding_right = 8;
	else
		$sub_level_1_padding_right = _NOT_SET_;
	if (!is_null($row["padding_right_units"]))
		$sub_level_1_padding_right_units = $row["padding_right_units"];
	else
		$sub_level_1_padding_right_units = 0;
		
	if (!is_null($row["padding_bottom"]) && ($row["padding_bottom"] != -1))
		$sub_level_1_padding_bottom = $row["padding_bottom"];
	elseif ($load_defaults == 1)
		$sub_level_1_padding_bottom = 2;
	else
		$sub_level_1_padding_bottom = _NOT_SET_;
	if (!is_null($row["padding_bottom_units"]))
		$sub_level_1_padding_bottom_units = $row["padding_bottom_units"];
	else
		$sub_level_1_padding_bottom_units = 0;
		
	if (!is_null($row["padding_left"]) && ($row["padding_left"] != -1))
		$sub_level_1_padding_left = $row["padding_left"];
	elseif ($load_defaults == 1)
		$sub_level_1_padding_left = 8;
	else
		$sub_level_1_padding_left = _NOT_SET_;
	if (!is_null($row["padding_left_units"]))
		$sub_level_1_padding_left_units = $row["padding_left_units"];
	else
		$sub_level_1_padding_left_units = 0;

	$sub_level_1_text_align = $row["align"];

	if (!is_null($row["width"]) && ($row["width"] != -1))
		$sub_level_1_item_width = $row["width"];
	elseif ($load_defaults == 1)
		$sub_level_1_item_width = 140;
	else
		$sub_level_1_item_width = _NOT_SET_;
	
	$sub_level_1_item_width_units = $row["width_units"];
	if ((!is_null($row["line_height"])) && ($row["line_height"] != -1))
		$sub_level_1_item_height = $row["line_height"];
	elseif ($load_defaults == 1)
		$sub_level_1_item_height = 20;
	else
		$sub_level_1_item_height = _NOT_SET_;
	$sub_level_1_item_height_units = $row["line_height_units"];
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if ($sub_level_1_orientation == "vertical")	{
		if (!is_null($row["margin_bottom"]) && ($row["margin_bottom"] != -1000000))
			$sub_level_1_item_spacing = $row["margin_bottom"];
		else
			$sub_level_1_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_bottom_units"]))
			$sub_level_1_item_spacing_units = $row["margin_bottom_units"];
		else
			$sub_level_1_item_spacing_units = 0;
	}
	else	{
		if (!is_null($row["margin_right"]) && ($row["margin_right"] != -1000000))
			$sub_level_1_item_spacing = $row["margin_right"];
		else
			$sub_level_1_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_right_units"]))
			$sub_level_1_item_spacing_units = $row["margin_right_units"];
		else
			$sub_level_1_item_spacing_units = 0;
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if (!is_null($row["padding_top"]) && ($row["padding_top"] != -1))
		$sub_level_2_padding_top = $row["padding_top"];
	elseif ($load_defaults == 1)
		$sub_level_2_padding_top = 2;
	else
		$sub_level_2_padding_top = _NOT_SET_;
	if (!is_null($row["padding_top_units"]))
		$sub_level_2_padding_top_units = $row["padding_top_units"];
	else
		$sub_level_2_padding_top_units = 0;
		
	if (!is_null($row["padding_right"]) && ($row["padding_right"] != -1))
		$sub_level_2_padding_right = $row["padding_right"];
	elseif ($load_defaults == 1)
		$sub_level_2_padding_right = 8;
	else
		$sub_level_2_padding_right = _NOT_SET_;
	if (!is_null($row["padding_right_units"]))
		$sub_level_2_padding_right_units = $row["padding_right_units"];
	else
		$sub_level_2_padding_right_units = 0;
		
	if (!is_null($row["padding_bottom"]) && ($row["padding_bottom"] != -1))
		$sub_level_2_padding_bottom = $row["padding_bottom"];
	elseif ($load_defaults == 1)
		$sub_level_2_padding_bottom = 2;
	else
		$sub_level_2_padding_bottom = _NOT_SET_;
	if (!is_null($row["padding_bottom_units"]))
		$sub_level_2_padding_bottom_units = $row["padding_bottom_units"];
	else
		$sub_level_2_padding_bottom_units = 0;
		
	if (!is_null($row["padding_left"]) && ($row["padding_left"] != -1))
		$sub_level_2_padding_left = $row["padding_left"];
	elseif ($load_defaults == 1)
		$sub_level_2_padding_left = 8;
	else
		$sub_level_2_padding_left = _NOT_SET_;
	if (!is_null($row["padding_left_units"]))
		$sub_level_2_padding_left_units = $row["padding_left_units"];
	else
		$sub_level_2_padding_left_units = 0;
		
	if (!is_null($row["width"]) && ($row["width"] != -1))
		$sub_level_2_item_width = $row["width"];
	elseif ($load_defaults == 1)
		$sub_level_2_item_width = 140;
	else
		$sub_level_2_item_width = _NOT_SET_;
	
	$sub_level_2_item_width_units = $row["width_units"];
	if ((!is_null($row["line_height"])) && ($row["line_height"] != -1))
		$sub_level_2_item_height = $row["line_height"];
	elseif ($load_defaults == 1)
		$sub_level_2_item_height = 20;
	else
		$sub_level_2_item_height = _NOT_SET_;
	$sub_level_2_item_height_units = $row["line_height_units"];
		
	$sub_level_2_text_align = $row["align"];
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if ($sub_level_2_orientation == "vertical")	{
		if (!is_null($row["margin_bottom"]) && ($row["margin_bottom"] != -1000000))
			$sub_level_2_item_spacing = $row["margin_bottom"];
		else
			$sub_level_2_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_bottom_units"]))
			$sub_level_2_item_spacing_units = $row["margin_bottom_units"];
		else
			$sub_level_2_item_spacing_units = 0;
	}
	else	{
		if (!is_null($row["margin_right"]) && ($row["margin_right"] != -1000000))
			$sub_level_2_item_spacing = $row["margin_right"];
		else
			$sub_level_2_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_right_units"]))
			$sub_level_2_item_spacing_units = $row["margin_right_units"];
		else
			$sub_level_2_item_spacing_units = 0;
	}
		
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '" . $menu . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$proportional_width_top = $row["proportional"];
	$proportional_width_sub = $row["proportional_sub"];
	$top_down_on_sub_down = $row["top_down_on_sub_down"];
?>

<form name="frm_menu_params" id="frm_menu_params" action="save_css_menu_params.php" method="post">
<table width="90%" class="group_box_table">
  <tr>
    <td bgcolor="#ccffcc">
		<table width="100%" class="layout_box_table" cellspacing="1" cellpadding="1">
        <tr>
        	<td class="bold" colspan="4"><?php echo EDIT_CSS_MENU_PARAMETERS_LAYOUT_ORIGIN; ?> </td>
            <td align="right">
            	<div class='button_console_save' style="width:110px;" onClick="SaveMenuParams();" id="top_update_btn"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
            </td>
        </tr>
        <tr>
            <td width="25%">
            <?php echo EDIT_CSS_MENU_PARAMETERS_LOCATION; ?>:<br>
              <input type="radio" name="MenuLocationGroup" value="header" id="MenuLocationGroup_0" onChange="PreloadLocationDefaults('header');" />
              <?php echo HEADER_1ST_CAP_WORD; ?><br>	
              <input type="radio" name="MenuLocationGroup" value="top" id="MenuLocationGroup_1" onChange="PreloadLocationDefaults('top');" />
              <?php echo TOP_1ST_CAP_WORD; ?><br>
              <input type="radio" name="MenuLocationGroup" value="left" id="MenuLocationGroup_2" onChange="PreloadLocationDefaults('left');" />
              <?php echo LEFT_1ST_CAP_WORD; ?><br>
                <input type="radio" name="MenuLocationGroup" value="right" id="MenuLocationGroup_3" onChange="PreloadLocationDefaults('right');" />
              <?php echo RIGHT_1ST_CAP_WORD; ?><br>
              <input type="radio" name="MenuLocationGroup" value="bottom" id="MenuLocationGroup_4" onChange="PreloadLocationDefaults('bottom');" />
              <?php echo BOTTOM_1ST_CAP_WORD; ?><br>
                <input type="radio" name="MenuLocationGroup" value="footer" id="MenuLocationGroup_5" onChange="PreloadLocationDefaults('footer');" />
              <?php echo FOOTER_1ST_CAP_WORD; ?><br>
                <span class="extra_small_message"><?php echo EDIT_CSS_MENU_PARAMETERS_SPECIAL_NOTE; ?></span>
            </td>
            <td valign="top">
            <?php echo ORIENTATION_WORD; ?>:<br>
              <span id="vertical">
              <input type="radio" name="OrientationGroup" value="vertical" id="OrientationGroup_0" <?php if ($orientation == "vertical") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('vertical');">
              </span>
              <?php echo VERTICAL_WORD; ?>
              <br>
              <span id="horizontal_fixed">
              <input type="radio" name="OrientationGroup" value="horizontal_fixed_width" id="OrientationGroup_1" <?php if ($orientation == "horizontal_fixed_width") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('horizontal_fixed_width');">
              </span>
              <?php echo HORIZONTAL_WORD; ?> <?php echo EDIT_CSS_MENU_PARAMETERS_FIXED_WIDTH; ?>
              <br>
              <span id="horizontal_variable">
              <input type="radio" name="OrientationGroup" value="horizontal_variable_width" id="OrientationGroup_2" <?php if ($orientation == "horizontal_variable_width") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('horizontal_variable_width');">
              </span>
              <?php echo HORIZONTAL_WORD; ?> <?php echo EDIT_CSS_MENU_PARAMETERS_VARIABLE_WIDTH; ?>
            </td>
            <td>
                <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                <td colspan="2"><?php echo OFFSET_WORD; ?>: </td>
                </tr>
                <tr>
                <td><?php echo TOP_1ST_CAP_WORD; ?>: </td>
                <td id="offset_top">
                	<input name="menu_top" type="text" id="menu_top" value="<?php echo $menu_top; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <select name="menu_top_units" id="menu_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'menu_top', 0);">
                        <option value="0"<?php if ($menu_top_units == 0) echo " selected='selected'"; ?>>px</option>
                        <option value="1"<?php if ($menu_top_units == 1) echo " selected='selected'"; ?>>%</option>
                        <option value="2"<?php if ($menu_top_units == 2) echo " selected='selected'"; ?>>em</option>
                        <option value="3"<?php if ($menu_top_units == 3) echo " selected='selected'"; ?>>pt</option>
                        <option value="4"<?php if ($menu_top_units == 4) echo " selected='selected'"; ?>>pc</option>
                        <option value="5"<?php if ($menu_top_units == 5) echo " selected='selected'"; ?>>cm</option>
                        <option value="6"<?php if ($menu_top_units == 6) echo " selected='selected'"; ?>>mm</option>
                        <option value="7"<?php if ($menu_top_units == 7) echo " selected='selected'"; ?>>in</option>
                        <option value="8"<?php if ($menu_top_units == 8) echo " selected='selected'"; ?>>rem</option>
                        <option value="9"<?php if ($menu_top_units == 9) echo " selected='selected'"; ?>>vw</option>
                        <option value="10"<?php if ($menu_top_units == 10) echo " selected='selected'"; ?>>vh</option>
                        <option value="11"<?php if ($menu_top_units == 11) echo " selected='selected'"; ?>>vmin</option>
                        <option value="12"<?php if ($menu_top_units == 12) echo " selected='selected'"; ?>>vmax</option>
                        <option value="13"<?php if ($menu_top_units == 13) echo " selected='selected'"; ?>>ch</option>
                    </select>
                </td>
                </tr>
                <tr>
                <td><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
                <td id="offset_left">
                	<input name="menu_left" type="text" id="menu_left" value="<?php echo $menu_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <select name="menu_left_units" id="menu_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'menu_left', 0);">
                        <option value="0"<?php if ($menu_left_units == 0) echo " selected='selected'"; ?>>px</option>
                        <option value="1"<?php if ($menu_left_units == 1) echo " selected='selected'"; ?>>%</option>
                        <option value="2"<?php if ($menu_left_units == 2) echo " selected='selected'"; ?>>em</option>
                        <option value="3"<?php if ($menu_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                        <option value="4"<?php if ($menu_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                        <option value="5"<?php if ($menu_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                        <option value="6"<?php if ($menu_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                        <option value="7"<?php if ($menu_left_units == 7) echo " selected='selected'"; ?>>in</option>
                        <option value="8"<?php if ($menu_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                        <option value="9"<?php if ($menu_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                        <option value="10"<?php if ($menu_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                        <option value="11"<?php if ($menu_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                        <option value="12"<?php if ($menu_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                        <option value="13"<?php if ($menu_left_units == 13) echo " selected='selected'"; ?>>ch</option>
                    </select>
                </td>
                </tr>
                <tr>
                <td><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
                <td id="offset_bottom">
                	<input name="menu_bottom" type="text" id="menu_bottom" value="<?php echo $menu_bottom; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <select name="menu_bottom_units" id="menu_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'menu_bottom', 0);">
                        <option value="0"<?php if ($menu_bottom_units == 0) echo " selected='selected'"; ?>>px</option>
                        <option value="1"<?php if ($menu_bottom_units == 1) echo " selected='selected'"; ?>>%</option>
                        <option value="2"<?php if ($menu_bottom_units == 2) echo " selected='selected'"; ?>>em</option>
                        <option value="3"<?php if ($menu_bottom_units == 3) echo " selected='selected'"; ?>>pt</option>
                        <option value="4"<?php if ($menu_bottom_units == 4) echo " selected='selected'"; ?>>pc</option>
                        <option value="5"<?php if ($menu_bottom_units == 5) echo " selected='selected'"; ?>>cm</option>
                        <option value="6"<?php if ($menu_bottom_units == 6) echo " selected='selected'"; ?>>mm</option>
                        <option value="7"<?php if ($menu_bottom_units == 7) echo " selected='selected'"; ?>>in</option>
                        <option value="8"<?php if ($menu_bottom_units == 8) echo " selected='selected'"; ?>>rem</option>
                        <option value="9"<?php if ($menu_bottom_units == 9) echo " selected='selected'"; ?>>vw</option>
                        <option value="10"<?php if ($menu_bottom_units == 10) echo " selected='selected'"; ?>>vh</option>
                        <option value="11"<?php if ($menu_bottom_units == 11) echo " selected='selected'"; ?>>vmin</option>
                        <option value="12"<?php if ($menu_bottom_units == 12) echo " selected='selected'"; ?>>vmax</option>
                        <option value="13"<?php if ($menu_bottom_units == 13) echo " selected='selected'"; ?>>ch</option>
                    </select>
                </td>
                </tr>
                <tr>
                <td><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
                <td id="offset_right">
                	<input name="menu_right" type="text" id="menu_right" value="<?php echo $menu_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <select name="menu_right_units" id="menu_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'menu_right', 0);">
                        <option value="0"<?php if ($menu_right_units == 0) echo " selected='selected'"; ?>>px</option>
                        <option value="1"<?php if ($menu_right_units == 1) echo " selected='selected'"; ?>>%</option>
                        <option value="2"<?php if ($menu_right_units == 2) echo " selected='selected'"; ?>>em</option>
                        <option value="3"<?php if ($menu_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                        <option value="4"<?php if ($menu_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                        <option value="5"<?php if ($menu_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                        <option value="6"<?php if ($menu_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                        <option value="7"<?php if ($menu_right_units == 7) echo " selected='selected'"; ?>>in</option>
                        <option value="8"<?php if ($menu_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                        <option value="9"<?php if ($menu_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                        <option value="10"<?php if ($menu_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                        <option value="11"<?php if ($menu_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                        <option value="12"<?php if ($menu_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                        <option value="13"<?php if ($menu_right_units == 13) echo " selected='selected'"; ?>>ch</option>
                    </select>
                 </td>
                </tr>
                </table>
            </td>
            <td valign="top">
            <?php echo EDIT_CSS_MENU_PARAMETERS_MENU_WIDTH; ?>:<br>
            <input name="menu_width" type="text" id="menu_width" value="<?php echo $menu_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              <select name="menu_width_units" id="menu_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'menu_width', 0);">
                <option value="0"<?php if ($menu_width_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($menu_width_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($menu_width_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($menu_width_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($menu_width_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($menu_width_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($menu_width_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($menu_width_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($menu_width_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($menu_width_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($menu_width_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($menu_width_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($menu_width_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($menu_width_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
                        
              <br/><br/><?php echo POSITIONING_WORD; ?>:<br/>
              <span id="absolute">
              <input type="radio" name="PositionGroup" value="absolute" id="PositionGroup_0" <?php if ($position != "relative") echo "checked='checked'"; ?> />
              </span>
              <?php echo ABSOLUTE_WORD; ?><br>
              <span id="relative">
               <input type="radio" name="PositionGroup" value="relative" id="PositionGroup_1" <?php if ($position == "relative") echo "checked='checked'"; ?> />
               </span>
              <?php echo RELATIVE_WORD; ?><br>
              <span id="fixed">
               <input type="radio" name="PositionGroup" value="relative" id="PositionGroup_2" <?php if ($position == "fixed") echo "checked='checked'"; ?> />
               </span>
              <?php echo FIXED_WORD; ?>
              </td>
              <td>
			  	<?php echo EDIT_CSS_MENU_PARAMETERS_BASE_Z_INDEX; ?>:<br />
                <input name="menu_z_index" type="text" id="menu_z_index" value="<?php echo $menu_z_index; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              </td>
      </tr>
      </table>

       </td>
      </tr>
      
      <tr>
      <td bgcolor="#ccccff">
      <table width="100%" class="layout_box_table">
	  <tr>
		 <td class="bold"><?php echo EDIT_CSS_MENU_PARAMETERS_ITEM_SIZE_PADDING; ?></td>
	  </tr>
	  <tr>
      <td>
      <table width="100%" class="layout_box_table">
      <tr>
		<td align="right"><?php echo WIDTH_WORD; ?>: </td>
		<td>
          <input name="top_level_item_width" type="text" id="top_level_item_width" value="<?php echo $top_level_item_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          
          <select name="top_level_item_width_units" id="top_level_item_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_item_width', 0);">
            <option value="0"<?php if ($top_level_item_width_units == 0) echo " selected='selected'"; ?>>px</option>
            <option value="1"<?php if ($top_level_item_width_units == 1) echo " selected='selected'"; ?>>%</option>
            <option value="2"<?php if ($top_level_item_width_units == 2) echo " selected='selected'"; ?>>em</option>
            <option value="3"<?php if ($top_level_item_width_units == 3) echo " selected='selected'"; ?>>pt</option>
            <option value="4"<?php if ($top_level_item_width_units == 4) echo " selected='selected'"; ?>>pc</option>
            <option value="5"<?php if ($top_level_item_width_units == 5) echo " selected='selected'"; ?>>cm</option>
            <option value="6"<?php if ($top_level_item_width_units == 6) echo " selected='selected'"; ?>>mm</option>
            <option value="7"<?php if ($top_level_item_width_units == 7) echo " selected='selected'"; ?>>in</option>
            <option value="8"<?php if ($top_level_item_width_units == 8) echo " selected='selected'"; ?>>rem</option>
            <option value="9"<?php if ($top_level_item_width_units == 9) echo " selected='selected'"; ?>>vw</option>
            <option value="10"<?php if ($top_level_item_width_units == 10) echo " selected='selected'"; ?>>vh</option>
            <option value="11"<?php if ($top_level_item_width_units == 11) echo " selected='selected'"; ?>>vmin</option>
            <option value="12"<?php if ($top_level_item_width_units == 12) echo " selected='selected'"; ?>>vmax</option>
            <option value="13"<?php if ($top_level_item_width_units == 13) echo " selected='selected'"; ?>>ch</option>
        </select>
 
        	<input name="proportional_width_top" type="checkbox" value="1" <?php if ($proportional_width_top == 1) echo " checked='checked'"; ?>>
        	<?php echo PROPORTIONAL_WORD; ?>
        </td>
		<td align="right"><?php echo HEIGHT_WORD; ?>: </td>
		<td align="left">
        	<input name="top_level_item_height" type="text" id="top_level_item_height" value="<?php echo $top_level_item_height; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
        
               <select name="top_level_item_height_units" id="top_level_item_height_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_item_height', 2);">
                <option value="2"<?php if ($top_level_item_height_units == 2) echo " selected='selected'"; ?>>px</option>
                <option value="3"<?php if ($top_level_item_height_units == 3) echo " selected='selected'"; ?>>%</option>
                <option value="4"<?php if ($top_level_item_height_units == 4) echo " selected='selected'"; ?>>em</option>
                <option value="5"<?php if ($top_level_item_height_units == 5) echo " selected='selected'"; ?>>pt</option>
                <option value="6"<?php if ($top_level_item_height_units == 6) echo " selected='selected'"; ?>>pc</option>
                <option value="7"<?php if ($top_level_item_height_units == 7) echo " selected='selected'"; ?>>cm</option>
                <option value="8"<?php if ($top_level_item_height_units == 8) echo " selected='selected'"; ?>>mm</option>
                <option value="9"<?php if ($top_level_item_height_units == 9) echo " selected='selected'"; ?>>in</option>
                <option value="10"<?php if ($top_level_item_height_units == 10) echo " selected='selected'"; ?>>rem</option>
                <option value="11"<?php if ($top_level_item_height_units == 11) echo " selected='selected'"; ?>>vw</option>
                <option value="12"<?php if ($top_level_item_height_units == 12) echo " selected='selected'"; ?>>vh</option>
                <option value="13"<?php if ($top_level_item_height_units == 13) echo " selected='selected'"; ?>>vmin</option>
                <option value="14"<?php if ($top_level_item_height_units == 14) echo " selected='selected'"; ?>>vmax</option>
                <option value="15"<?php if ($top_level_item_height_units == 15) echo " selected='selected'"; ?>>ch</option>
               </select>
		</td>
        <td align="right"><?php echo EDIT_CSS_MENU_PARAMETERS_ITEM_SPACING; ?>: </td>
        <td aligh="left">
        	<input name="top_level_item_spacing" type="text" id="top_level_item_spacing" value="<?php echo $top_level_item_spacing; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            
            <select name="top_level_item_spacing_units" id="top_level_item_spacing_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_item_spacing', 0);">
                <option value="0"<?php if ($top_level_item_spacing_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_item_spacing_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_item_spacing_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_item_spacing_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_item_spacing_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_item_spacing_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_item_spacing_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_item_spacing_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_item_spacing_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_item_spacing_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_item_spacing_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_item_spacing_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_item_spacing_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_item_spacing_units == 13) echo " selected='selected'"; ?>>ch</option>
               </select>
        </td>
        <td align="right"><?php echo TEXT_ALIGNMENT; ?>: </td>
		<td align="left">
               <select name="top_level_text_align" id="top_level_text_align">
                <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                <option value="left" <?php if ($top_level_text_align == "left") echo "selected='selected'"; ?>><?php echo LEFT_1ST_CAP_WORD; ?></option>
                <option value="center" <?php if ($top_level_text_align == "center") echo "selected='selected'"; ?>><?php echo CENTER_WORD; ?></option>
                <option value="right" <?php if ($top_level_text_align == "right") echo "selected='selected'"; ?>><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                <option value="justify" <?php if ($top_level_text_align == "justify") echo "selected='selected'"; ?>><?php echo JUSTIFY_WORD; ?></option>
               </select>
		</td>
        </tr>
        </table>
        
        </td>
	  </tr>
      <tr>
      <td>
      <table width="100%" class="layout_box_table">
      <tr>
        <td align="center" class="bold"><?php echo PADDING_WORD; ?></td>
        <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
        <td>
            <input name="top_level_padding_top" type="text" id="top_level_padding_top" value="<?php echo $top_level_padding_top; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="top_level_padding_top_units" id="top_level_padding_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_padding_top', 0);">
                <option value="0"<?php if ($top_level_padding_top_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_padding_top_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_padding_top_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_padding_top_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_padding_top_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_padding_top_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_padding_top_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_padding_top_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_padding_top_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_padding_top_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_padding_top_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_padding_top_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_padding_top_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_padding_top_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="top_level_padding_right" type="text" id="top_level_padding_right" value="<?php echo $top_level_padding_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="top_level_padding_right_units" id="top_level_padding_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_padding_right', 0);">
                <option value="0"<?php if ($top_level_padding_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_padding_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_padding_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_padding_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_padding_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_padding_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_padding_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_padding_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_padding_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_padding_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_padding_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_padding_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_padding_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_padding_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="top_level_padding_bottom" type="text" id="top_level_padding_bottom" value="<?php echo $top_level_padding_bottom; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="top_level_padding_bottom_units" id="top_level_padding_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_padding_bottom', 0);">
                <option value="0"<?php if ($top_level_padding_bottom_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_padding_bottom_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_padding_bottom_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_padding_bottom_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_padding_bottom_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_padding_bottom_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_padding_bottom_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_padding_bottom_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_padding_bottom_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_padding_bottom_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_padding_bottom_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_padding_bottom_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_padding_bottom_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_padding_bottom_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="top_level_padding_left" type="text" id="top_level_padding_left" value="<?php echo $top_level_padding_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="top_level_padding_left_units" id="top_level_padding_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_padding_left', 0);">
                <option value="0"<?php if ($top_level_padding_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_padding_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_padding_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_padding_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_padding_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_padding_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_padding_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_padding_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_padding_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_padding_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_padding_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_padding_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_padding_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_padding_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         </tr>
        </table> 
       </td>
      </tr>
      </table>
	</td>
  </tr>
  <tr>
    <td bgcolor="#ffffaa">
	  <table class="layout_box_table" width="100%"  cellspacing="1" cellpadding="1">
		<tr>  
		  <td colspan="6" class="bold"><?php echo EDIT_CSS_MENU_PARAMETERS_SUB_1_MENU_POSITIONING; ?></td>
		  </tr>
		  <tr>
          	<td align="right" valign="top"><?php echo ORIENTATION_WORD; ?>: </td>
            <td>
            	<span id="sub_1_vertical">
              <input type="radio" name="Sub1OrientationGroup" value="vertical" id="Sub1OrientationGroup_0" <?php if ($sub_level_1_orientation == "vertical") echo "checked='checked'"; ?>>
              </span>
              <?php echo VERTICAL_WORD; ?>
              <br>
              <span id="sub_1_horizontal">
              <input type="radio" name="Sub1OrientationGroup" value="horizontal" id="Sub1OrientationGroup_1" <?php if ($sub_level_1_orientation == "horizontal") echo "checked='checked'"; ?>>
              </span>
              <? echo HORIZONTAL_WORD; ?>
            </td>
		    <td align="right"><?php echo EDIT_CSS_MENU_PARAMETERS_OFFSET_FROM_TOP; ?>: </td>
		    <td>
            <input name="sub_level_1_offset_top" type="text" id="sub_level_1_offset_top" value="<?php echo $sub_level_1_offset_top; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_1_offset_top_units" id="sub_level_1_offset_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_offset_top', 0);">
                <option value="0"<?php if ($sub_level_1_offset_top_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_offset_top_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_offset_top_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_offset_top_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_offset_top_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_offset_top_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_offset_top_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_offset_top_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_offset_top_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_offset_top_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_offset_top_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_offset_top_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_offset_top_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_offset_top_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
            </td>
		    <td align="right"><?php echo EDIT_CSS_MENU_PARAMETERS_OFFSET_FROM_LEFT; ?>: </td>
		    <td>
            <input name="sub_level_1_offset_left" type="text" id="sub_level_1_offset_left" value="<?php echo $sub_level_1_offset_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_1_offset_left_units" id="sub_level_1_offset_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_offset_left', 0);">
                <option value="0"<?php if ($sub_level_1_offset_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_offset_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_offset_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_offset_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_offset_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_offset_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_offset_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_offset_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_offset_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_offset_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_offset_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_offset_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_offset_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_offset_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
            </td>
            <td>
            <input name="sub_level_collapse" id="$sub_level_collapse" type="checkbox" value="1" <?php if ($sub_level_collapse) echo "checked"; ?>>
            <?php echo EDIT_CSS_MENU_PARAMETERS_COLLAPSE_EXPAND; ?>
            </td>
            <td>
            <input name="top_down_on_sub_down" id="$top_down_on_sub_down" type="checkbox" value="1" <?php if ($top_down_on_sub_down) echo "checked"; ?>>
            <?php echo EDIT_CSS_MENU_PARAMETERS_LATCH_EXPANDED_ON_DOWN; ?>
            </td>
		    </tr>
	  </table>
	</td>
  </tr>
  <tr>
    <td bgcolor="#ffaaff">
	  <table class="layout_box_table" width="100%"  cellspacing="1" cellpadding="1">
		<tr>  
		  <td colspan="8" class="bold"><?php echo EDIT_CSS_MENU_PARAMETERS_SUB_2_MENU_POSITIONING; ?></td>
		  </tr>
		  <tr>
          	<td align="right" valign="top"><?php echo ORIENTATION_WORD; ?>: </td>
            <td>
            	<span id="sub_2_vertical">
              <input type="radio" name="Sub2OrientationGroup" value="vertical" id="Sub2OrientationGroup_0" <?php if ($sub_level_2_orientation == "vertical") echo "checked='checked'"; ?>>
              </span>
              <?php echo VERTICAL_WORD; ?>
              <br>
              <span id="sub_2_horizontal">
              <input type="radio" name="Sub2OrientationGroup" value="horizontal" id="Sub2OrientationGroup_1" <?php if ($sub_level_2_orientation == "horizontal") echo "checked='checked'"; ?>>
              </span>
              <? echo HORIZONTAL_WORD; ?>
            </td>
		    <td align="right"><?php echo EDIT_CSS_MENU_PARAMETERS_OFFSET_FROM_TOP; ?>: </td>
		    <td>
            <input name="sub_level_2_offset_top" type="text" id="sub_level_2_offset_top" value="<?php echo $sub_level_2_offset_top; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_2_offset_top_units" id="sub_level_2_offset_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_offset_top', 0);">
                <option value="0"<?php if ($sub_level_2_offset_top_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_offset_top_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_offset_top_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_offset_top_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_offset_top_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_offset_top_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_offset_top_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_offset_top_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_offset_top_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_offset_top_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_offset_top_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_offset_top_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_offset_top_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_offset_top_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
            </td>
		    <td align="right"><?php echo EDIT_CSS_MENU_PARAMETERS_OFFSET_FROM_LEFT; ?>: </td>
		    <td>
            <input name="sub_level_2_offset_left" type="text" id="sub_level_2_offset_left" value="<?php echo $sub_level_2_offset_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_2_offset_left_units" id="sub_level_2_offset_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_offset_left', 0);">
                <option value="0"<?php if ($sub_level_2_offset_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_offset_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_offset_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_offset_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_offset_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_offset_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_offset_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_offset_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_offset_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_offset_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_offset_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_offset_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_offset_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_offset_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
            </td>
		    </tr>
	  </table>
	</td>
  </tr>
  <tr>
    <td bgcolor="#aaffff">
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
		  <tr>
		    <td class="bold"><?php echo EDIT_CSS_MENU_PARAMETERS_SUB_MENU_1_SIZE_PADDING; ?></td>
		  </tr>
          <tr>
          <td>
          <table width="100%" class="layout_box_table">
           <tr>
		    <td align="right"><?php echo WIDTH_WORD; ?>: </td>
		    <td>
              <input name="sub_level_1_item_width" type="text" id="sub_level_1_item_width" value="<?php echo $sub_level_1_item_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />

              <select name="sub_level_1_item_width_units" id="sub_level_1_item_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_item_width', 0);">
                <option value="0"<?php if ($sub_level_1_item_width_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_item_width_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_item_width_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_item_width_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_item_width_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_item_width_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_item_width_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_item_width_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_item_width_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_item_width_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_item_width_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_item_width_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_item_width_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_item_width_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
 
                <input name="proportional_width_sub" type="checkbox" value="1" <?php if ($proportional_width_sub == 1) echo " checked='checked'"; ?>>
                <?php echo PROPORTIONAL_WORD; ?>
            </td>
		    <td align="right"><?php echo HEIGHT_WORD; ?>: </td>
		    <td align="left">
              <input name="sub_level_1_item_height" type="text" id="sub_level_1_item_height" value="<?php echo $sub_level_1_item_height; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />

                <select name="sub_level_1_item_height_units" id="sub_level_1_item_height_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_item_height', 2);">
                <option value="2"<?php if ($sub_level_1_item_height_units == 2) echo " selected='selected'"; ?>>px</option>
                <option value="3"<?php if ($sub_level_1_item_height_units == 3) echo " selected='selected'"; ?>>%</option>
                <option value="4"<?php if ($sub_level_1_item_height_units == 4) echo " selected='selected'"; ?>>em</option>
                <option value="5"<?php if ($sub_level_1_item_height_units == 5) echo " selected='selected'"; ?>>pt</option>
                <option value="6"<?php if ($sub_level_1_item_height_units == 6) echo " selected='selected'"; ?>>pc</option>
                <option value="7"<?php if ($sub_level_1_item_height_units == 7) echo " selected='selected'"; ?>>cm</option>
                <option value="8"<?php if ($sub_level_1_item_height_units == 8) echo " selected='selected'"; ?>>mm</option>
                <option value="9"<?php if ($sub_level_1_item_height_units == 9) echo " selected='selected'"; ?>>in</option>
                <option value="10"<?php if ($sub_level_1_item_height_units == 10) echo " selected='selected'"; ?>>rem</option>
                <option value="11"<?php if ($sub_level_1_item_height_units == 11) echo " selected='selected'"; ?>>vw</option>
                <option value="12"<?php if ($sub_level_1_item_height_units == 12) echo " selected='selected'"; ?>>vh</option>
                <option value="13"<?php if ($sub_level_1_item_height_units == 13) echo " selected='selected'"; ?>>vmin</option>
                <option value="14"<?php if ($sub_level_1_item_height_units == 14) echo " selected='selected'"; ?>>vmax</option>
                <option value="15"<?php if ($sub_level_1_item_height_units == 15) echo " selected='selected'"; ?>>ch</option>
                </select>
                </td>
                <td align="right"><?php echo EDIT_CSS_MENU_PARAMETERS_ITEM_SPACING; ?>: </td>
                <td aligh="left">
                    <input name="sub_level_1_item_spacing" type="text" id="sub_level_1_item_spacing" value="<?php echo $sub_level_1_item_spacing; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    
                    <select name="sub_level_1_item_spacing_units" id="sub_level_1_item_spacing_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_item_spacing', 0);">
                        <option value="0"<?php if ($sub_level_1_item_spacing_units == 0) echo " selected='selected'"; ?>>px</option>
                        <option value="1"<?php if ($sub_level_1_item_spacing_units == 1) echo " selected='selected'"; ?>>%</option>
                        <option value="2"<?php if ($sub_level_1_item_spacing_units == 2) echo " selected='selected'"; ?>>em</option>
                        <option value="3"<?php if ($sub_level_1_item_spacing_units == 3) echo " selected='selected'"; ?>>pt</option>
                        <option value="4"<?php if ($sub_level_1_item_spacing_units == 4) echo " selected='selected'"; ?>>pc</option>
                        <option value="5"<?php if ($sub_level_1_item_spacing_units == 5) echo " selected='selected'"; ?>>cm</option>
                        <option value="6"<?php if ($sub_level_1_item_spacing_units == 6) echo " selected='selected'"; ?>>mm</option>
                        <option value="7"<?php if ($sub_level_1_item_spacing_units == 7) echo " selected='selected'"; ?>>in</option>
                        <option value="8"<?php if ($sub_level_1_item_spacing_units == 8) echo " selected='selected'"; ?>>rem</option>
                        <option value="9"<?php if ($sub_level_1_item_spacing_units == 9) echo " selected='selected'"; ?>>vw</option>
                        <option value="10"<?php if ($sub_level_1_item_spacing_units == 10) echo " selected='selected'"; ?>>vh</option>
                        <option value="11"<?php if ($sub_level_1_item_spacing_units == 11) echo " selected='selected'"; ?>>vmin</option>
                        <option value="12"<?php if ($sub_level_1_item_spacing_units == 12) echo " selected='selected'"; ?>>vmax</option>
                        <option value="13"<?php if ($sub_level_1_item_spacing_units == 13) echo " selected='selected'"; ?>>ch</option>
                       </select>
                </td>
                 <td align="right"><?php echo TEXT_ALIGNMENT; ?>: </td>
				<td align="left">
               <select name="sub_level_1_text_align" id="sub_level_1_text_align">
                <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                <option value="left" <?php if ($sub_level_1_text_align == "left") echo "selected='selected'"; ?>><?php echo LEFT_1ST_CAP_WORD; ?></option>
                <option value="center" <?php if ($sub_level_1_text_align == "center") echo "selected='selected'"; ?>><?php echo CENTER_WORD; ?></option>
                <option value="right" <?php if ($sub_level_1_text_align == "right") echo "selected='selected'"; ?>><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                <option value="justify" <?php if ($sub_level_1_text_align == "justify") echo "selected='selected'"; ?>><?php echo JUSTIFY_WORD; ?></option>
               </select>
				</td>
               </tr>
              </table>
             </td>
		    </tr>
		  <tr>
		    <td>
            <table width="100%" class="layout_box_table">
      <tr>
        <td align="center" class="bold"><?php echo PADDING_WORD; ?></td>
        <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
        <td>
            <input name="sub_level_1_padding_top" type="text" id="sub_level_1_padding_top" value="<?php echo $sub_level_1_padding_top; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_1_padding_top_units" id="sub_level_1_padding_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_padding_top', 0);">
                <option value="0"<?php if ($sub_level_1_padding_top_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_padding_top_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_padding_top_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_padding_top_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_padding_top_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_padding_top_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_padding_top_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_padding_top_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_padding_top_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_padding_top_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_padding_top_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_padding_top_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_padding_top_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_padding_top_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="sub_level_1_padding_right" type="text" id="sub_level_1_padding_right" value="<?php echo $sub_level_1_padding_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
          <select name="sub_level_1_padding_right_units" id="sub_level_1_padding_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_padding_right', 0);">
                <option value="0"<?php if ($sub_level_1_padding_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_padding_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_padding_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_padding_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_padding_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_padding_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_padding_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_padding_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_padding_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_padding_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_padding_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_padding_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_padding_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_padding_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="sub_level_1_padding_bottom" type="text" id="sub_level_1_padding_bottom" value="<?php echo $sub_level_1_padding_bottom; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
          <select name="sub_level_1_padding_bottom_units" id="sub_level_1_padding_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_padding_bottom', 0);">
                <option value="0"<?php if ($sub_level_1_padding_bottom_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_padding_bottom_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_padding_bottom_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_padding_bottom_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_padding_bottom_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_padding_bottom_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_padding_bottom_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_padding_bottom_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_padding_bottom_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_padding_bottom_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_padding_bottom_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_padding_bottom_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_padding_bottom_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_padding_bottom_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="sub_level_1_padding_left" type="text" id="sub_level_1_padding_left" value="<?php echo $sub_level_1_padding_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_1_padding_left_units" id="sub_level_1_padding_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_padding_left', 0);">
                <option value="0"<?php if ($sub_level_1_padding_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_padding_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_padding_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_padding_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_padding_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_padding_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_padding_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_padding_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_padding_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_padding_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_padding_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_padding_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_padding_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_padding_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         </tr>
        </table> 
            </td>
		    </tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td bgcolor="#ffbb99">
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
		  <tr>
		    <td class="bold"><?php echo EDIT_CSS_MENU_PARAMETERS_SUB_MENU_2_SIZE_PADDING; ?></td>
		    </tr>
		  <tr>
          <td>
          <table width="100%" class="layout_box_table">
           <tr>
		    <td align="right"><?php echo WIDTH_WORD; ?>: </td>
		    <td>
              <input name="sub_level_2_item_width" type="text" id="sub_level_2_item_width" value="<?php echo $sub_level_2_item_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />

              <select name="sub_level_2_item_width_units" id="sub_level_2_item_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_item_width', 0);">
                <option value="0"<?php if ($sub_level_2_item_width_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_item_width_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_item_width_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_item_width_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_item_width_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_item_width_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_item_width_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_item_width_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_item_width_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_item_width_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_item_width_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_item_width_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_item_width_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_item_width_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
 
            </td>
		    <td align="right"><?php echo HEIGHT_WORD; ?>: </td>
		    <td align="left">
              <input name="sub_level_2_item_height" type="text" id="sub_level_2_item_height" value="<?php echo $sub_level_2_item_height; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />

                <select name="sub_level_2_item_height_units" id="sub_level_2_item_height_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_item_height', 2);">
                <option value="2"<?php if ($sub_level_2_item_height_units == 2) echo " selected='selected'"; ?>>px</option>
                <option value="3"<?php if ($sub_level_2_item_height_units == 3) echo " selected='selected'"; ?>>%</option>
                <option value="4"<?php if ($sub_level_2_item_height_units == 4) echo " selected='selected'"; ?>>em</option>
                <option value="5"<?php if ($sub_level_2_item_height_units == 5) echo " selected='selected'"; ?>>pt</option>
                <option value="6"<?php if ($sub_level_2_item_height_units == 6) echo " selected='selected'"; ?>>pc</option>
                <option value="7"<?php if ($sub_level_2_item_height_units == 7) echo " selected='selected'"; ?>>cm</option>
                <option value="8"<?php if ($sub_level_2_item_height_units == 8) echo " selected='selected'"; ?>>mm</option>
                <option value="9"<?php if ($sub_level_2_item_height_units == 9) echo " selected='selected'"; ?>>in</option>
                <option value="10"<?php if ($sub_level_2_item_height_units == 10) echo " selected='selected'"; ?>>rem</option>
                <option value="11"<?php if ($sub_level_2_item_height_units == 11) echo " selected='selected'"; ?>>vw</option>
                <option value="12"<?php if ($sub_level_2_item_height_units == 12) echo " selected='selected'"; ?>>vh</option>
                <option value="13"<?php if ($sub_level_2_item_height_units == 13) echo " selected='selected'"; ?>>vmin</option>
                <option value="14"<?php if ($sub_level_2_item_height_units == 14) echo " selected='selected'"; ?>>vmax</option>
                <option value="15"<?php if ($sub_level_2_item_height_units == 15) echo " selected='selected'"; ?>>ch</option>
                </select>
                </td>
                <td align="right"><?php echo EDIT_CSS_MENU_PARAMETERS_ITEM_SPACING; ?>: </td>
                <td aligh="left">
                    <input name="sub_level_2_item_spacing" type="text" id="sub_level_2_item_spacing" value="<?php echo $sub_level_2_item_spacing; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    
                	<select name="sub_level_2_item_spacing_units" id="sub_level_2_item_spacing_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_item_spacing', 0);">
                    <option value="0"<?php if ($sub_level_2_item_spacing_units == 0) echo " selected='selected'"; ?>>px</option>
                    <option value="1"<?php if ($sub_level_2_item_spacing_units == 1) echo " selected='selected'"; ?>>%</option>
                    <option value="2"<?php if ($sub_level_2_item_spacing_units == 2) echo " selected='selected'"; ?>>em</option>
                    <option value="3"<?php if ($sub_level_2_item_spacing_units == 3) echo " selected='selected'"; ?>>pt</option>
                    <option value="4"<?php if ($sub_level_2_item_spacing_units == 4) echo " selected='selected'"; ?>>pc</option>
                    <option value="5"<?php if ($sub_level_2_item_spacing_units == 5) echo " selected='selected'"; ?>>cm</option>
                    <option value="6"<?php if ($sub_level_2_item_spacing_units == 6) echo " selected='selected'"; ?>>mm</option>
                    <option value="7"<?php if ($sub_level_2_item_spacing_units == 7) echo " selected='selected'"; ?>>in</option>
                    <option value="8"<?php if ($sub_level_2_item_spacing_units == 8) echo " selected='selected'"; ?>>rem</option>
                    <option value="9"<?php if ($sub_level_2_item_spacing_units == 9) echo " selected='selected'"; ?>>vw</option>
                    <option value="10"<?php if ($sub_level_2_item_spacing_units == 10) echo " selected='selected'"; ?>>vh</option>
                    <option value="11"<?php if ($sub_level_2_item_spacing_units == 11) echo " selected='selected'"; ?>>vmin</option>
                    <option value="12"<?php if ($sub_level_2_item_spacing_units == 12) echo " selected='selected'"; ?>>vmax</option>
                    <option value="13"<?php if ($sub_level_2_item_spacing_units == 13) echo " selected='selected'"; ?>>ch</option>
                   </select>
                </td>
                 <td align="right"><?php echo TEXT_ALIGNMENT; ?>: </td>
				<td align="left">
               <select name="sub_level_2_text_align" id="sub_level_2_text_align">
                <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                <option value="left" <?php if ($sub_level_2_text_align == "left") echo "selected='selected'"; ?>><?php echo LEFT_1ST_CAP_WORD; ?></option>
                <option value="center" <?php if ($sub_level_2_text_align == "center") echo "selected='selected'"; ?>><?php echo CENTER_WORD; ?></option>
                <option value="right" <?php if ($sub_level_2_text_align == "right") echo "selected='selected'"; ?>><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                <option value="justify" <?php if ($sub_level_2_text_align == "justify") echo "selected='selected'"; ?>><?php echo JUSTIFY_WORD; ?></option>
               </select>
				</td>
               </tr>
              </table>
             </td>
		    </tr>
		  <tr>
		    <td>
            <table width="100%" class="layout_box_table">
      <tr>
        <td align="center" class="bold"><?php echo PADDING_WORD; ?></td>
        <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
        <td>
            <input name="sub_level_2_padding_top" type="text" id="sub_level_2_padding_top" value="<?php echo $sub_level_2_padding_top; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_2_padding_top_units" id="sub_level_2_padding_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_padding_top', 0);">
                <option value="0"<?php if ($sub_level_2_padding_top_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_padding_top_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_padding_top_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_padding_top_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_padding_top_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_padding_top_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_padding_top_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_padding_top_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_padding_top_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_padding_top_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_padding_top_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_padding_top_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_padding_top_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_padding_top_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="sub_level_2_padding_right" type="text" id="sub_level_2_padding_right" value="<?php echo $sub_level_2_padding_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
          <select name="sub_level_2_padding_right_units" id="sub_level_2_padding_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_padding_right', 0);">
                <option value="0"<?php if ($sub_level_2_padding_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_padding_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_padding_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_padding_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_padding_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_padding_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_padding_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_padding_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_padding_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_padding_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_padding_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_padding_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_padding_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_padding_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="sub_level_2_padding_bottom" type="text" id="sub_level_2_padding_bottom" value="<?php echo $sub_level_2_padding_bottom; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
          <select name="sub_level_2_padding_bottom_units" id="sub_level_2_padding_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_padding_bottom', 0);">
                <option value="0"<?php if ($sub_level_2_padding_bottom_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_padding_bottom_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_padding_bottom_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_padding_bottom_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_padding_bottom_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_padding_bottom_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_padding_bottom_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_padding_bottom_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_padding_bottom_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_padding_bottom_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_padding_bottom_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_padding_bottom_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_padding_bottom_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_padding_bottom_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
         <td>
          <input name="sub_level_2_padding_left" type="text" id="sub_level_2_padding_left" value="<?php echo $sub_level_2_padding_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_2_padding_left_units" id="sub_level_2_padding_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_padding_left', 0);">
                <option value="0"<?php if ($sub_level_2_padding_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_padding_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_padding_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_padding_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_padding_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_padding_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_padding_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_padding_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_padding_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_padding_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_padding_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_padding_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_padding_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_padding_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         </tr>
        </table> 
            </td>
		    </tr>
	   </table>
	</td>
  </tr>
</table>

<table width="90%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr><td colspan="2">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <div class='button_console_save' style="width:110px;" onClick="SaveMenuParams();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
		</td>
	  </tr>
</table>
</form>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	popup_msg.HidePopupMsg();
</script>

</body>
</html>