////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/10/2013	ELL
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear, min/max prefix for width and height and sticky footer setup button.
// Revised: 6/28/2013	ELL
// Implemented popup message class.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/1/2014	ELL
// Fixed bug with preview and uploading images.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 2/16/2014	ELL
// Added modal color tinting of grouping tables to make it easier to find controls and to make enabled=disabled obvious.
// Revised: 2/18/2014	ELL
// Fixed bug with center site button and sticky footers button that got broke when submit_action was implemented inplace of the submit button.
// Revised 2/20/2014	ELL
// Added checking for correct parameters selected for border and line height.
// Revised: 3/5/2014	ELL
// Replaced image uploader with "AJAX" image uploader.
// Revised: 8/27/2014	ELL
// Added switch between alpha and user-defined sort for class list.
// Revised: 12/28/2014	ELL
// Added thumbnail checking with switch to actual image if no thumb.
// Revised: 12/30/2014	ELL
// Added browser CSS reset button.
// Revised: 1/12/2015	ELL
// Replaced deprecated font-stretch with letter-spacing.
// Revised: 2/14/2015	ELL
// Added visibility.
// Added full compliment of font-size units.
// Added full compliment of length units to border.
// Added full compliment of length units to all paddings.
// Added full compliment of length units to existing unit fields.
// Revised: 5/15/2015	ELL
// Added background transparancy.
// Added overflow-x and overflow-y.
// Revised: 6/10/2015	ELL
// Added margin set to 0 on body upen clicking "Load Browser Reset CSS".
// Revised: 9/21/2015	ELL
// Added text-indent attribute.
// Revised: 1/19/2016	ELL
// Overhauled preview to use popup page.
// Revised: 3/25/2016	ELL
// Replace numeric placeholders of -1 and -1000000 for not set with "-not set".  Added code to clear "-not set-" when user wants to type
// and code to re-apply "-not set-" when user clears the field.
// Revised: 11/3/2016	ELL
// Added ability to set both min and max widths simultaneously, and both min and max heights simultaneously.
// Revised: 11/10/2016	ELL
// Adding alfa sort style sheets.
// Modified: 12/1/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Revised: 2/2/2017	ELL
// Modified to utilize separate browser reset table for browser reset CSS.
// Revised: 4/22/2017	ELL
// Added background RGBA labeled as "Foreground Opaque".
// Revised: 5/25/2017	ELL
// Added various transition, flex and content attributes.
// Added text-transform.
// Revised: 7/17/2017	ELL
// Added button for setting important CSS attributes.
// Revised: 12/29/2017	ELL
// Added quick-setup button to set header as 'sticky'.
// Revised: 3/26/2018	ELL
// Replaced font select dropdowns with custom-built select comprised of divs, JavaScript and CSS for the display of font face both upon reviewing select and after selection.
// Added color feedback to all color selects.
// Revised: 4/16/2018	ELL
// Improved color text-box background and foreground color handling.
// 


var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function popupcolorpicker(form_name, field_name, top_offset)
{
	var start_color = document.getElementById(field_name).value;
	if (start_color == "")
		start_color = "-not set-";
	else
		start_color = start_color.replace("#", "");
	
	var URL = "colorpicker.php?form_name=" + form_name + "&field_name=" + field_name + "&source_page=edit_css.php&start_color=" + start_color;

	if ((typeof top_offset == 'undefined') || isNaN(top_offset))
		top_offset = 0;
	var ntop = parseInt(tempY) + parseInt(top_offset);
	var nleft = tempX;

	window.open (URL, "colorpicker", "alwaysRaised=0,dependent=1,menubar=0,resizable=0,width=450,height=350,scrollbars=0,location=0,top=" + ntop + ",left=" + nleft);
}

function enable_disable_controls(ShowMessage)
{
	if ((document.getElementById("update_btn").className == "button_console_save_disabled") && (ShowMessage == 1))	{
		document.getElementById("use_table_data").checked = false;
		return;
	}
		
	if (document.getElementById("goto_class").value == "")	{
		document.getElementById("update_btn").className = "button_console_save_disabled";
		document.getElementById("update_btn_2").className = "button_console_save_disabled";
		document.getElementById("important_btn").className = "button_console_important_disabled";
		document.getElementById("preview_btn").className = "button_console_preview_disabled";
		document.getElementById("set_display_flex_btn").className = "button_console_disabled";
	}
	else	{
		document.getElementById("update_btn").className = "button_console_save";
		document.getElementById("update_btn_2").className = "button_console_save";
		document.getElementById("important_btn").className = "button_console_important";
		document.getElementById("preview_btn").className = "button_console_preview";
		document.getElementById("set_display_flex_btn").className = "button_console";
	}
		
	if (document.getElementById("use_table_data").checked == true)
	{
		document.getElementById("font").disabled = false;
		document.getElementById("font2").disabled = false;
		document.getElementById("font3").disabled = false;
		document.getElementById("font_size_units").disabled = false;
		document.getElementById("text_color").disabled = false;
		if ((document.getElementById("text_color").value == "") || (document.getElementById("text_color").value == "-not set-"))	{
			document.getElementById("text_color").style.backgroundColor = "";
			document.getElementById("text_color").style.color = "";
			if (document.getElementById("text_color").className.indexOf("not_set") < 0)
				document.getElementById("text_color").className = document.getElementById("text_color").className + " not_set";
		}
		else	{
			document.getElementById("text_color").style.backgroundColor = document.getElementById("text_color").value;
			document.getElementById("text_color").style.color = invertColor(document.getElementById("text_color").value);
		}
		document.getElementById("align").disabled = false;
		document.getElementById("vertical_align").disabled = false;
		document.getElementById("display").disabled = false;
		document.getElementById("weight").disabled = false;
		document.getElementById("letter_spacing_units").disabled = false;
		document.getElementById("italic").disabled = false;
		document.getElementById("underline").disabled = false;
		document.getElementById("overline").disabled = false;
		document.getElementById("blink").disabled = false;
		document.getElementById("linethrough").disabled = false;
		document.getElementById("oblique").disabled = false;
		document.getElementById("small_caps").disabled = false;
		document.getElementById("no_text_decoration").disabled = false;
		document.getElementById("shadow").disabled = false;
		document.getElementById("line_height_units").disabled = false;
		document.getElementById("text_indent").disabled = false;
		document.getElementById("text_indent_units").disabled = false;
		
		document.getElementById("bkgd_color").disabled = false;
		if ((document.getElementById("bkgd_color").value == "") || (document.getElementById("bkgd_color").value == "-not set-"))	{
			document.getElementById("bkgd_color").style.backgroundColor = "";
			document.getElementById("bkgd_color").style.color = "";
			if (document.getElementById("bkgd_color").className.indexOf("not_set") < 0)
				document.getElementById("bkgd_color").className = document.getElementById("bkgd_color").className + " not_set";
		}
		else	{
			document.getElementById("bkgd_color").style.backgroundColor = document.getElementById("bkgd_color").value;
			document.getElementById("bkgd_color").style.color = invertColor(document.getElementById("bkgd_color").value);
		}
		document.getElementById("bkgd_transparent").disabled = false;
		document.getElementById("bkgd_opacity").disabled = false;
		document.getElementById("bkgd_rgba").disabled = false;
		document.getElementById("border").disabled = false;
		document.getElementById("border_units").disabled = false;
		document.getElementById("border_color").disabled = false;
		if ((document.getElementById("border_color").value == "") || (document.getElementById("border_color").value == "-not set-"))	{
			document.getElementById("border_color").style.backgroundColor = "";
			document.getElementById("border_color").style.color = "";
			if (document.getElementById("border_color").className.indexOf("not_set") < 0)
				document.getElementById("border_color").className = document.getElementById("border_color").className + " not_set";
		}
		else	{
			document.getElementById("border_color").style.backgroundColor = document.getElementById("border_color").value;
			document.getElementById("border_color").style.color = invertColor(document.getElementById("border_color").value);
		}
		document.getElementById("border_style").disabled = false;
		document.getElementById("outline_style").disabled = false;
		document.getElementById("border_collapse").disabled = false;
		document.getElementById("border_top").disabled = false;
		document.getElementById("border_bottom").disabled = false;
		document.getElementById("border_left").disabled = false;
		document.getElementById("border_right").disabled = false;
		document.getElementById("padding_top").disabled = false;
		document.getElementById("padding_right").disabled = false;
		document.getElementById("padding_bottom").disabled = false;
		document.getElementById("padding_left").disabled = false;
		document.getElementById("padding_top_units").disabled = false;
		document.getElementById("padding_right_units").disabled = false;
		document.getElementById("padding_bottom_units").disabled = false;
		document.getElementById("padding_left_units").disabled = false;

		document.getElementById("width").disabled = false;
		document.getElementById("width_units").disabled = false;
		document.getElementById("width_prefix").disabled = false;
		document.getElementById("max_width").disabled = false;
		document.getElementById("max_width_units").disabled = false;
		document.getElementById("height").disabled = false;
		document.getElementById("height_units").disabled = false;
		document.getElementById("height_prefix").disabled = false;
		document.getElementById("max_height").disabled = false;
		document.getElementById("max_height_units").disabled = false;
		document.getElementById("background_image").disabled = false;
		document.getElementById("file_browse1").disabled = false;
		document.getElementById("background_attachment").disabled = false;
		document.getElementById("background_repeat").disabled = false;
		document.getElementById("background_position").disabled = false;
		
		document.getElementById("margin_top_auto").disabled = false;
		document.getElementById("margin_right_auto").disabled = false;
		document.getElementById("margin_left_auto").disabled = false;
		document.getElementById("margin_bottom_auto").disabled = false;
		
		document.getElementById("position").disabled = false;
		document.getElementById("position_left").disabled = false;
		document.getElementById("position_left_units").disabled = false;
		document.getElementById("position_top").disabled = false;
		document.getElementById("position_top_units").disabled = false;
		document.getElementById("position_right").disabled = false;
		document.getElementById("position_right_units").disabled = false;
		document.getElementById("position_bottom").disabled = false;
		document.getElementById("position_bottom_units").disabled = false;
		document.getElementById("z_index").disabled = false;
		document.getElementById("overflow").disabled = false;
		document.getElementById("overflow_x").disabled = false;
		document.getElementById("overflow_y").disabled = false;
		document.getElementById("clip_top").disabled = false;
		document.getElementById("clip_top_units").disabled = false;
		document.getElementById("clip_right").disabled = false;
		document.getElementById("clip_right_units").disabled = false;
		document.getElementById("clip_bottom").disabled = false;
		document.getElementById("clip_bottom_units").disabled = false;
		document.getElementById("clip_left").disabled = false;
		document.getElementById("clip_left_units").disabled = false;
		document.getElementById("float").disabled = false;
		document.getElementById("white_space").disabled = false;
		
		document.getElementById("list_style_type").disabled = false;
		document.getElementById("list_style_position").disabled = false;
		document.getElementById("list_style_image").disabled = false;
		document.getElementById("file_browse2").disabled = false;
		
		document.getElementById("table_layout").disabled = false;
		document.getElementById("clear").disabled = false;
		
		document.getElementById("radius_top_left").disabled = false;
		document.getElementById("radius_top_left_units").disabled = false;
		document.getElementById("radius_top_right").disabled = false;
		document.getElementById("radius_top_right_units").disabled = false;
		document.getElementById("radius_bottom_right").disabled = false;
		document.getElementById("radius_bottom_right_units").disabled = false;
		document.getElementById("radius_bottom_left").disabled = false;
		document.getElementById("radius_bottom_left_units").disabled = false;
		
		document.getElementById("box_shadow_horizontal").disabled = false;
		document.getElementById("box_shadow_vertical").disabled = false;
		document.getElementById("box_shadow_blur").disabled = false;
		document.getElementById("box_shadow_spread").disabled = false;
		document.getElementById("box_shadow_color").disabled = false;
		if ((document.getElementById("box_shadow_color").value == "") || (document.getElementById("box_shadow_color").value == "-not set-"))	{
			document.getElementById("box_shadow_color").style.backgroundColor = "";
			document.getElementById("box_shadow_color").style.color = "";
			if (document.getElementById("box_shadow_color").className.indexOf("not_set") < 0)
				document.getElementById("box_shadow_color").className = document.getElementById("box_shadow_color").className + " not_set";
		}
		else	{
			document.getElementById("box_shadow_color").style.backgroundColor = document.getElementById("box_shadow_color").value;
			document.getElementById("box_shadow_color").style.color = invertColor(document.getElementById("box_shadow_color").value);
		}
		document.getElementById("box_shadow_inset").disabled = false;
		
		document.getElementById("cursor").disabled = false;
		
		document.getElementById("background_size").disabled = false;
		
		document.getElementById("visibility").disabled = false;
		
		document.getElementById("text_transform").disabled = false;
				
		document.getElementById("justify_content").disabled = false;
		document.getElementById("content").disabled = false;
		document.getElementById("content_text").disabled = false;
		
		document.getElementById("transition_property").disabled = false;
		document.getElementById("transition_timing_function").disabled = false;
		document.getElementById("transition_duration").disabled = false;
		document.getElementById("transition_duration_units").disabled = false;
		document.getElementById("transition_delay").disabled = false;
		document.getElementById("transition_delay_units").disabled = false;
		
		document.getElementById("flex_basis").disabled = false;
		document.getElementById("flex_grow").disabled = false;
		document.getElementById("flex_shrink").disabled = false;
		document.getElementById("flex_direction").disabled = false;
		document.getElementById("flex_wrap").disabled = false;
		
		document.getElementById("gradient_type").disabled = false;
		
		enable_disable_shadow();
		margin_auto_clicked("top");
		margin_auto_clicked("bottom");
		margin_auto_clicked("left");
		margin_auto_clicked("right");
		enable_disable_background_color("bkgd_transparent");
		enable_disable_background_positions();
		enable_disable_background_sizes();
		enable_disable_letter_spacing();
		enable_disable_line_height();
		enable_disable_font_size();
		ShowHideMaxWidthHeight(document.getElementById("width_prefix").value, "width");
		ShowHideMaxWidthHeight(document.getElementById("height_prefix").value, "height");
		enable_disable_content_text();
		enable_disable_flex_basis_length();
		enable_disable_gradient();
		
		CheckFormatOnUnitSelect("border_units", "border", 0);
		CheckFormatOnUnitSelect("padding_top_units", "padding_top", 0);
		CheckFormatOnUnitSelect("padding_right_units", "padding_right", 0);
		CheckFormatOnUnitSelect("padding_bottom_units", "padding_bottom", 0);
		CheckFormatOnUnitSelect("padding_left_units", "padding_left", 0);
		CheckFormatOnUnitSelect("radius_top_left_units", "radius_top_left", 0);
		CheckFormatOnUnitSelect("radius_top_right_units", "radius_top_right", 0);
		CheckFormatOnUnitSelect("radius_bottom_right_units", "radius_bottom_right", 0);
		CheckFormatOnUnitSelect("radius_bottom_left_units", "radius_bottom_left", 0);
		CheckFormatOnUnitSelect("margin_top_units", "margin_top", 0);
		CheckFormatOnUnitSelect("margin_right_units", "margin_right", 0);
		CheckFormatOnUnitSelect("margin_bottom_units", "margin_bottom", 0);
		CheckFormatOnUnitSelect("margin_left_units", "margin_left", 0);
		CheckFormatOnUnitSelect("width_units", "width", 0);
		CheckFormatOnUnitSelect("height_units", "height", 0);
		CheckFormatOnUnitSelect("max_width_units", "max_width", 0);
		CheckFormatOnUnitSelect("max_height_units", "max_height", 0);
		CheckFormatOnUnitSelect("position_left_units", "position_left", 0);
		CheckFormatOnUnitSelect("position_top_units", "position_top", 0);
		CheckFormatOnUnitSelect("position_right_units", "position_right", 0);
		CheckFormatOnUnitSelect("position_bottom_units", "position_bottom", 0);
		CheckFormatOnUnitSelect("clip_top_units", "clip_top", 0);
		CheckFormatOnUnitSelect("clip_right_units", "clip_right", 0);
		CheckFormatOnUnitSelect("clip_bottom_units", "clip_bottom", 0);
		CheckFormatOnUnitSelect("clip_left_units", "clip_left", 0);
		CheckFormatOnUnitSelect("background_position_units", "background_position_x", 0);
		CheckFormatOnUnitSelect("background_position_units", "background_position_y", 0);
		CheckFormatOnUnitSelect("background_width_units", "background_width", 0);
		CheckFormatOnUnitSelect("background_height_units", "background_height", 0);
		CheckFormatOnUnitSelect("letter_spacing_units", "letter_spacing", 1);
		CheckFormatOnUnitSelect("line_height_units", "line_height", 2);
		CheckFormatOnUnitSelect("flex_basis_length_units", "flex_basis_length", 0);
		
		document.getElementById("text_table").style.backgroundColor = "#FFCCCC";
		document.getElementById("background_table").style.backgroundColor = "#CCFFCC";
		document.getElementById("border_table").style.backgroundColor = "#CCCCFF";
		document.getElementById("margin_table").style.backgroundColor = "#FFFFAA";
		document.getElementById("position_table").style.backgroundColor = "#FFAAFF";
		document.getElementById("background_img_table").style.backgroundColor = "#AAFFFF";
		document.getElementById("list_table").style.backgroundColor = "#FFBB99";
		document.getElementById("box_shadow_table").style.backgroundColor = "#99BBFF";
		document.getElementById("content_table").style.backgroundColor = "#FF99BB";
		document.getElementById("transition_table").style.backgroundColor = "#99FFBB";
		document.getElementById("flex_table").style.backgroundColor = "#BB99FF";
	}
	else
	{
		document.getElementById("font").disabled = true;
		document.getElementById("font2").disabled = true;
		document.getElementById("font3").disabled = true;
		document.getElementById("font_size").disabled = true;
		document.getElementById("font_size_units").disabled = true;
		document.getElementById("text_color").disabled = true;
		document.getElementById("text_color").style.backgroundColor = "";
		document.getElementById("text_color").style.color = "";
		document.getElementById("align").disabled = true;
		document.getElementById("vertical_align").disabled = true;
		document.getElementById("display").disabled = true;
		document.getElementById("weight").disabled = true;
		document.getElementById("letter_spacing").disabled = true;
		document.getElementById("letter_spacing_units").disabled = true;
		document.getElementById("italic").disabled = true;
		document.getElementById("underline").disabled = true;
		document.getElementById("overline").disabled = true;
		document.getElementById("blink").disabled = true;
		document.getElementById("linethrough").disabled = true;
		document.getElementById("oblique").disabled = true;
		document.getElementById("small_caps").disabled = true;
		document.getElementById("no_text_decoration").disabled = true;
		document.getElementById("shadow").disabled = true;
		document.getElementById("shadow_color").disabled = true;
		document.getElementById("shadow_color").style.backgroundColor = "";
		document.getElementById("shadow_color").style.color = "";
		document.getElementById("shadow_x_offset").disabled = true;
		document.getElementById("shadow_y_offset").disabled = true;
		document.getElementById("shadow_blur").disabled = true;
		document.getElementById("line_height").disabled = true;
		document.getElementById("line_height_units").disabled = true;
		document.getElementById("text_indent").disabled = true;
		document.getElementById("text_indent_units").disabled = true;

		document.getElementById("bkgd_color").disabled = true;
		document.getElementById("bkgd_color").style.backgroundColor = "";
		document.getElementById("bkgd_color").style.color = "";
		document.getElementById("bkgd_transparent").disabled = true;
		document.getElementById("bkgd_opacity").disabled = true;
		document.getElementById("bkgd_rgba").disabled = true;
		document.getElementById("border").disabled = true;
		document.getElementById("border_units").disabled = true;
		document.getElementById("border_color").disabled = true;
		document.getElementById("border_color").style.backgroundColor = "";
		document.getElementById("border_color").style.color = "";
		document.getElementById("border_style").disabled = true;
		document.getElementById("outline_style").disabled = true;
		document.getElementById("border_collapse").disabled = true;
		document.getElementById("border_top").disabled = true;
		document.getElementById("border_bottom").disabled = true;
		document.getElementById("border_left").disabled = true;
		document.getElementById("border_right").disabled = true;
		document.getElementById("padding_top").disabled = true;
		document.getElementById("padding_right").disabled = true;
		document.getElementById("padding_bottom").disabled = true;
		document.getElementById("padding_left").disabled = true;
		document.getElementById("padding_top_units").disabled = true;
		document.getElementById("padding_right_units").disabled = true;
		document.getElementById("padding_bottom_units").disabled = true;
		document.getElementById("padding_left_units").disabled = true;
		
		document.getElementById("margin_top").disabled = true;
		document.getElementById("margin_right").disabled = true;
		document.getElementById("margin_left").disabled = true;
		document.getElementById("margin_bottom").disabled = true;
		document.getElementById("width").disabled = true;
		document.getElementById("width_units").disabled = true;
		document.getElementById("width_prefix").disabled = true;
		document.getElementById("max_width").disabled = true;
		document.getElementById("max_width_units").disabled = true;
		document.getElementById("height").disabled = true;
		document.getElementById("height_units").disabled = true;
		document.getElementById("height_prefix").disabled = true;
		document.getElementById("max_height").disabled = true;
		document.getElementById("max_height_units").disabled = true;
		document.getElementById("background_image").disabled = true;
		document.getElementById("file_browse1").disabled = true;
		document.getElementById("background_attachment").disabled = true;
		document.getElementById("background_repeat").disabled = true;
		document.getElementById("background_position").disabled = true;
		document.getElementById("background_position_x").disabled = true;
		document.getElementById("background_position_y").disabled = true;
		document.getElementById("background_position_units").disabled = true;
		
		document.getElementById("margin_top_units").disabled = true;
		document.getElementById("margin_top_auto").disabled = true;
		document.getElementById("margin_right_units").disabled = true;
		document.getElementById("margin_right_auto").disabled = true;
		document.getElementById("margin_left_units").disabled = true;
		document.getElementById("margin_left_auto").disabled = true;
		document.getElementById("margin_bottom_units").disabled = true;
		document.getElementById("margin_bottom_auto").disabled = true;
		
		document.getElementById("position").disabled = true;
		document.getElementById("position_left").disabled = true;
		document.getElementById("position_left_units").disabled = true;
		document.getElementById("position_top").disabled = true;
		document.getElementById("position_top_units").disabled = true;
		document.getElementById("position_right").disabled = true;
		document.getElementById("position_right_units").disabled = true;
		document.getElementById("position_bottom").disabled = true;
		document.getElementById("position_bottom_units").disabled = true;
		document.getElementById("z_index").disabled = true;
		document.getElementById("overflow").disabled = true;
		document.getElementById("overflow_x").disabled = true;
		document.getElementById("overflow_y").disabled = true;
		document.getElementById("clip_top").disabled = true;
		document.getElementById("clip_top_units").disabled = true;
		document.getElementById("clip_right").disabled = true;
		document.getElementById("clip_right_units").disabled = true;
		document.getElementById("clip_bottom").disabled = true;
		document.getElementById("clip_bottom_units").disabled = true;
		document.getElementById("clip_left").disabled = true;
		document.getElementById("clip_left_units").disabled = true;
		document.getElementById("float").disabled = true;
		document.getElementById("white_space").disabled = true;
		
		document.getElementById("list_style_type").disabled = true;
		document.getElementById("list_style_position").disabled = true;
		document.getElementById("list_style_image").disabled = true;
		document.getElementById("file_browse2").disabled = true;
		
		document.getElementById("table_layout").disabled = true;
		document.getElementById("clear").disabled = true;
		
		document.getElementById("radius_top_left").disabled = true;
		document.getElementById("radius_top_left_units").disabled = true;
		document.getElementById("radius_top_right").disabled = true;
		document.getElementById("radius_top_right_units").disabled = true;
		document.getElementById("radius_bottom_right").disabled = true;
		document.getElementById("radius_bottom_right_units").disabled = true;
		document.getElementById("radius_bottom_left").disabled = true;
		document.getElementById("radius_bottom_left_units").disabled = true;
		
		document.getElementById("box_shadow_horizontal").disabled = true;
		document.getElementById("box_shadow_vertical").disabled = true;
		document.getElementById("box_shadow_blur").disabled = true;
		document.getElementById("box_shadow_spread").disabled = true;
		document.getElementById("box_shadow_color").disabled = true;
		document.getElementById("box_shadow_color").style.backgroundColor = "";
		document.getElementById("box_shadow_color").style.color = "";
		document.getElementById("box_shadow_inset").disabled = true;
		
		document.getElementById("cursor").disabled = true;
		
		document.getElementById("background_size").disabled = true;
		document.getElementById("background_width").disabled = true;
		document.getElementById("background_width_units").disabled = true;
		document.getElementById("background_height").disabled = true;
		document.getElementById("background_height_units").disabled = true;
		
		document.getElementById("visibility").disabled = true;
		
		document.getElementById("text_transform").disabled = true;
				
		document.getElementById("justify_content").disabled = true;
		document.getElementById("content").disabled = true;
		document.getElementById("content_text").disabled = true;
		
		document.getElementById("transition_property").disabled = true;
		document.getElementById("transition_timing_function").disabled = true;
		document.getElementById("transition_duration").disabled = true;
		document.getElementById("transition_duration_units").disabled = true;
		document.getElementById("transition_delay").disabled = true;
		document.getElementById("transition_delay_units").disabled = true;
		
		document.getElementById("flex_basis").disabled = true;
		document.getElementById("flex_basis_length").disabled = true;
		document.getElementById("flex_basis_length_units").disabled = true;
		document.getElementById("flex_grow").disabled = true;
		document.getElementById("flex_shrink").disabled = true;
		document.getElementById("flex_direction").disabled = true;
		document.getElementById("flex_wrap").disabled = true;
		
		document.getElementById("gradient_type").disabled = true;
		document.getElementById("gradient_angle").disabled = true;
		document.getElementById("gradient_color_1").disabled = true;
		document.getElementById("gradient_color_2").disabled = true;
		document.getElementById("gradient_color_3").disabled = true;
		document.getElementById("gradient_color_4").disabled = true;
		document.getElementById("gradient_color_5").disabled = true;
		document.getElementById("gradient_color_6").disabled = true;
		document.getElementById("gradient_color_7").disabled = true;
		document.getElementById("gradient_color_8").disabled = true;
		document.getElementById("gradient_opacity_1").disabled = true;
		document.getElementById("gradient_opacity_2").disabled = true;
		document.getElementById("gradient_opacity_3").disabled = true;
		document.getElementById("gradient_opacity_4").disabled = true;
		document.getElementById("gradient_opacity_5").disabled = true;
		document.getElementById("gradient_opacity_6").disabled = true;
		document.getElementById("gradient_opacity_7").disabled = true;
		document.getElementById("gradient_opacity_8").disabled = true;
		document.getElementById("gradient_repeat").disabled = true;
		document.getElementById("gradient_color_1").style.backgroundColor = "";
		document.getElementById("gradient_color_1").style.color = "";
		document.getElementById("gradient_color_2").style.backgroundColor = "";
		document.getElementById("gradient_color_2").style.color = "";
		document.getElementById("gradient_color_3").style.backgroundColor = "";
		document.getElementById("gradient_color_3").style.color = "";
		document.getElementById("gradient_color_4").style.backgroundColor = "";
		document.getElementById("gradient_color_4").style.color = "";
		document.getElementById("gradient_color_5").style.backgroundColor = "";
		document.getElementById("gradient_color_5").style.color = "";
		document.getElementById("gradient_color_6").style.backgroundColor = "";
		document.getElementById("gradient_color_6").style.color = "";
		document.getElementById("gradient_color_7").style.backgroundColor = "";
		document.getElementById("gradient_color_7").style.color = "";
		document.getElementById("gradient_color_8").style.backgroundColor = "";
		document.getElementById("gradient_color_8").style.color = "";
		
		document.getElementById("text_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("background_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("border_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("margin_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("position_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("background_img_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("list_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("box_shadow_table").style.backgroundColor = "#D9D9D9";		
		document.getElementById("content_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("transition_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("flex_table").style.backgroundColor = "#D9D9D9";
	}
	if (ShowMessage == 1)
	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = EDIT_CSS_CLICK_UPDATE_TO_COMMIT_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.popup_timeout = 6000;
		popup_msg.ShowPopupMsg();
	}
}

function text_decoration_none_clicked()
{
	if (document.getElementById("no_text_decoration").checked == true)
	{
		document.getElementById("underline").checked = false;
		document.getElementById("overline").checked = false;
		document.getElementById("blink").checked = false;
		document.getElementById("linethrough").checked = false;
	}
}

function margin_auto_clicked(side)
{
	var margin_auto_control_name = "margin_" + side + "_auto";
	var margin_control_name = "margin_" + side;
	var margin_units_control_name = "margin_" + side + "_units";
	
	if (document.getElementById(margin_auto_control_name).checked == true)
	{
		document.getElementById(margin_control_name).disabled = true;
		document.getElementById(margin_units_control_name).disabled = true;
	}
	else
	{
		document.getElementById(margin_control_name).disabled = false;
		document.getElementById(margin_units_control_name).disabled = false;
	}
}

function enable_disable_shadow()
{
	if (document.getElementById("shadow").checked == true)
	{
		document.getElementById("shadow_color").disabled = false;
		document.getElementById("shadow_x_offset").disabled = false;
		document.getElementById("shadow_y_offset").disabled = false;
		document.getElementById("shadow_blur").disabled = false;
		if ((document.getElementById("shadow_color").value == "") || (document.getElementById("shadow_color").value == "-not set-"))	{
			document.getElementById("shadow_color").style.backgroundColor = "";
			document.getElementById("shadow_color").style.color = "";
			if (document.getElementById("shadow_color").className.indexOf("not_set") < 0)
				document.getElementById("shadow_color").className = document.getElementById("shadow_color").className + " not_set";
		}
		else	{
			document.getElementById("shadow_color").style.backgroundColor = document.getElementById("shadow_color").value;
			document.getElementById("shadow_color").style.color = invertColor(document.getElementById("shadow_color").value);
		}
	}
	else
	{
		document.getElementById("shadow_color").disabled = true;
		document.getElementById("shadow_x_offset").disabled = true;
		document.getElementById("shadow_y_offset").disabled = true;
		document.getElementById("shadow_blur").disabled = true;
		document.getElementById("shadow_color").style.backgroundColor = "";
		document.getElementById("shadow_color").style.color = "";
	}
}

function enable_disable_background_positions()
{
	if (document.getElementById("background_position").value == "xpos ypos")
	{
		document.getElementById("background_position_x").disabled = false;
		document.getElementById("background_position_y").disabled = false;
		document.getElementById("background_position_units").disabled = false;
	}
	else
	{
		document.getElementById("background_position_x").disabled = true;
		document.getElementById("background_position_y").disabled = true;
		document.getElementById("background_position_units").disabled = true;
	}
}

function enable_disable_background_sizes()
{
	if (document.getElementById("background_size").value == "scale")
	{
		document.getElementById("background_width").disabled = false;
		document.getElementById("background_width_units").disabled = false;
		document.getElementById("background_height").disabled = false;
		document.getElementById("background_height_units").disabled = false;
	}
	else
	{
		document.getElementById("background_width").disabled = true;
		document.getElementById("background_width_units").disabled = true;
		document.getElementById("background_height").disabled = true;
		document.getElementById("background_height_units").disabled = true;
	}
}

function enable_disable_letter_spacing()
{
	if ((document.getElementById("letter_spacing_units").value > 0) && (document.getElementById("letter_spacing_units").value < 15))
		document.getElementById("letter_spacing").disabled = false;
	else
		document.getElementById("letter_spacing").disabled = true;
}

function enable_disable_line_height()
{
	if ((document.getElementById("line_height_units").value < 1) || (document.getElementById("line_height_units").value > 3))
		document.getElementById("line_height").disabled = true;
	else
		document.getElementById("line_height").disabled = false;
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, show_preview)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
//			alert(xmlhttp.responseText);
			if (xmlhttp.responseText.length > 0)
				popup_msg.status_msg = EDIT_CSS_UPDATE_COMPLETE_MSG + ": " + xmlhttp.responseText;
			else
				popup_msg.status_msg = EDIT_CSS_UPDATE_COMPLETE_MSG;
			popup_msg.popup_timeout = 2000;
			if (show_preview !== false)
				ShowPreview(show_preview);
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = EDIT_CSS_UPDATE_READY_TO_SEND_MSG;
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = EDIT_CSS_UPDATE_SENT_MSG;
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = EDIT_CSS_UPDATING_MSG;
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

////////////////////////////////////////////////////////////////////////////////////
function LoadBrowserResetParams()
{
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=browser_reset";
		params = params + "&class=html";
		params = params + "&use_table_data=1";
		params = params + "&margin_top=0";
		params = params + "&margin_top_units=0";
		params = params + "&margin_right=0";
		params = params + "&margin_right_units=0";
		params = params + "&margin_left=0";
		params = params + "&margin_left_units=0";
		params = params + "&margin_bottom=0";
		params = params + "&margin_bottom_units=0";
		params = params + "&padding_top=0";
		params = params + "&padding_right=0";
		params = params + "&padding_left=0";
		params = params + "&padding_bottom=0";
		params = params + "&padding_top_units=0";
		params = params + "&padding_right_units=0";
		params = params + "&padding_left_units=0";
		params = params + "&padding_bottom_units=0";
		params = params + "&border=0";
		params = params + "&border_units=0";
		params = params + "&border_sides=15";
		params = params + "&submit_action=Update";
		
		xmlhttp.send(params);
	}
	
	var xmlhttp2;
	xmlhttp2 = getXmlHttpRequestObject();
	if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
	{
		xmlhttp2.open("POST","save_css.php",true);
		xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp2 = UpdateMessage(xmlhttp2, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=browser_reset";
		params = params + "&class=body";
		params = params + "&use_table_data=1";
		params = params + "&margin_top=0";
		params = params + "&margin_top_units=0";
		params = params + "&margin_right=0";
		params = params + "&margin_right_units=0";
		params = params + "&margin_left=0";
		params = params + "&margin_left_units=0";
		params = params + "&margin_bottom=0";
		params = params + "&margin_bottom_units=0";
		params = params + "&submit_action=Update";
		
		xmlhttp2.send(params);
	}

	var msg = EDIT_CSS_RESET_BROWSER_CSS_COMPLETE_MSG;
	mTimer2 = setTimeout(function() { DisplayFinalMsg(msg) }, 3000);
}

////////////////////////////////////////////////////////////////////////////////////
function LoadCenterParams()
{
	alert(EDIT_CSS_LOAD_CENTERED_PAGES_CSS_ALERT_MSG);
	
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=body";
		params = params + "&use_table_data=1";
		params = params + "&align=center";
		params = params + "&bkgd_color=#111111";
		params = params + "&submit_action=Update";
		
		xmlhttp.send(params);
	}

	var xmlhttp2;
	xmlhttp2 = getXmlHttpRequestObject();
	if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
	{
		xmlhttp2.open("POST","save_css.php",true);
		xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp2 = UpdateMessage(xmlhttp2, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=#wrap";
		params = params + "&use_table_data=1";
		params = params + "&align=left";
		params = params + "&bkgd_color=#FFFFFF";
		params = params + "&position=relative";
		params = params + "&width=900";
		params = params + "&width_units=0";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&margin_left_auto=1";
		params = params + "&margin_right_auto=1";
		params = params + "&margin_top=0";
		params = params + "&margin_top_units=0";
		params = params + "&submit_action=Update";
		
		xmlhttp2.send(params);
	}
		
	var msg = EDIT_CSS_LOAD_CENTERED_PAGES_CSS_COMPLETE_MSG;
	mTimer2 = setTimeout(function() { DisplayFinalMsg(msg) }, 5000);
}

//////////////////////////////////////////////////////////////////////////////////////
function LoadStickyFooterParams()
{
	alert(EDIT_CSS_LOAD_STICKY_FOOTERS_ALERT_MSG);
	
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=body";
		params = params + "&use_table_data=1";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&submit_action=Update";
		
		xmlhttp.send(params);
	}
	
	var xmlhttp2;
	xmlhttp2 = getXmlHttpRequestObject();
	if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
	{
		xmlhttp2.open("POST","save_css.php",true);
		xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp2 = UpdateMessage(xmlhttp2, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=#wrap";
		params = params + "&use_table_data=1";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&height_prefix=min";
		params = params + "&overflow=auto";
		params = params + "&padding_bottom=50";
		params = params + "&padding_bottom_units=0";
		params = params + "&position=relative";
		params = params + "&submit_action=Update";
		
		xmlhttp2.send(params);
	}
	
	var xmlhttp3;
	xmlhttp3 = getXmlHttpRequestObject();
	if (xmlhttp3.readyState == 4 || xmlhttp3.readyState == 0)
	{
		xmlhttp3.open("POST","save_css.php",true);
		xmlhttp3.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp3 = UpdateMessage(xmlhttp3, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=html";
		params = params + "&use_table_data=1";
		params = params + "&height=94";
		params = params + "&height_units=1";
		params = params + "&submit_action=Update";
		
		xmlhttp3.send(params);
	}
	
	var xmlhttp4;
	xmlhttp4 = getXmlHttpRequestObject();
	if (xmlhttp4.readyState == 4 || xmlhttp4.readyState == 0)
	{
		xmlhttp4.open("POST","save_css.php",true);
		xmlhttp4.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp4 = UpdateMessage(xmlhttp4, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=footer";
		params = params + "&use_table_data=1";
		params = params + "&width=100";
		params = params + "&width_units=1";
		params = params + "&height=50";
		params = params + "&height_units=0";
		params = params + "&margin_top=-50";
		params = params + "&margin_top_units=0";
		params = params + "&margin_bottom_auto=1";
		params = params + "&position=relative";
		params = params + "&position_bottom=0";
		params = params + "&position_bottom_units=0";
		params = params + "&clear=both";
		params = params + "&bkgd_color=#DDDDDD";
		params = params + "&align=center";
		params = params + "&submit_action=Update";
		
		xmlhttp4.send(params);
	}
		
	var msg = EDIT_CSS_LOAD_STICKY_FOOTERS_COMPLETE_MSG;
	mTimer2 = setTimeout(function() { DisplayFinalMsg(msg) }, 5000);
}

//////////////////////////////////////////////////////////////////////////////////////
function LoadStickyHeaderParams()
{
	alert(EDIT_CSS_LOAD_STICKY_HEADERS_ALERT_MSG);
	
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, false);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=header";
		params = params + "&use_table_data=1";
		params = params + "&position=sticky";
		params = params + "&position_top=0";
		params = params + "&position_top_units=0";
		params = params + "&submit_action=Update";
		
		xmlhttp.send(params);
	}
		
	var msg = EDIT_CSS_LOAD_STICKY_HEADERS_COMPLETE_MSG;
	mTimer2 = setTimeout(function() { DisplayFinalMsg(msg) }, 5000);
}

function DisplayFinalMsg(msg)
{
	popup_msg.status_msg = msg;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = -1;
	popup_msg.left_offset = 250;
	popup_msg.msg_width = 600;
	popup_msg.ShowPopupMsg();
}

//////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_css", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////
function CheckBorderParams(element)
{
	if ((element.value != '-not selected-') && (element.value != '') && (element.value != 0))
	{
		var msg = '';
		
		if ((!document.getElementById('border_top').checked) && (!document.getElementById('border_bottom').checked) && (!document.getElementById('border_left').checked) && (!document.getElementById('border_right').checked))
			msg = EDIT_CSS_BORDER_REQUIREMENTS_MSG;
			
		if (document.getElementById('border_style').value == "-not selected-")
			msg = msg + EDIT_CSS_BORDER_REQUIREMENTS_STYLE_ADENDUM_MSG;
			
		if (msg != '')
		{
			popup_msg.popup_msg_type = 2;
			popup_msg.status_msg = msg;
			popup_msg.popup_timeout = -1;
			popup_msg.top_offset = 0;
			popup_msg.left_offset = 250;
			popup_msg.msg_width = 600;
			popup_msg.popup_timeout = 10000;
			popup_msg.ShowPopupMsg();
		}
	}
}

function CheckLetterSpacing(element)
{
	if (((element.value == 0) || (element.value > 14)) && (document.getElementById('letter_spacing').value != -1000000) && (document.getElementById('letter_spacing').value != '-not set-') && (document.getElementById('letter_spacing').value != ''))
	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = EDIT_CSS_LETTER_SPACING_REQUIREMENTS_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 250;
		popup_msg.msg_width = 600;
		popup_msg.popup_timeout = 10000;
		popup_msg.ShowPopupMsg();
	}
	
	if ((element.value > 0) && (element.value < 15))
		document.getElementById("letter_spacing").disabled = false;
	else
		document.getElementById("letter_spacing").disabled = true;
		
	if ((element.value > 0) && (element.value < 3))	{
		letter_spacing = document.getElementById("letter_spacing").value;
		var letter_spacing_arr = letter_spacing.split(".");
		document.getElementById("letter_spacing").value = letter_spacing_arr[0];
	}
}

function CheckLineHeight(element)
{
	if (((element.value == 0) || (element.value > 15)) && (document.getElementById('line_height').value != -1) && (document.getElementById('line_height').value != '-not set-') && (document.getElementById('line_height').value != ''))
	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = EDIT_CSS_LINE_HEIGHT_REQUIREMENTS_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 250;
		popup_msg.msg_width = 600;
		popup_msg.popup_timeout = 10000;
		popup_msg.ShowPopupMsg();
	}
	
	if ((element.value < 1) || (element.value > 15))
		document.getElementById("line_height").disabled = true;
	else
		document.getElementById("line_height").disabled = false;
		
	if ((element.value > 1) && (element.value < 4))	{
		line_height = document.getElementById("line_height").value;
		var line_height_arr = line_height.split(".");
		document.getElementById("line_height").value = line_height_arr[0];
	}
}

////////////////////////////////////////////////////////////////////////////
var RefreshTimer;
function RunPostAjaxUploadScript()
{
	// Called by ajaxupload.js.  You may use this function to automatically perform actions
	// after your file has uploaded.

	var filename_ctl;
	var preview_ctl;
	var image_select_ctl;
	var jq_filename_ctl = "";
	var jq_filenam_obj;
	
	filename_ctl = "file_browse" + upload_index;
	preview_ctl = "preview" + upload_index;
	
	var image_select_ctl;
	switch(upload_index)
	{
	case 1:
		image_select_ctl = "background_image";
		break;
	case 2:
		image_select_ctl = "list_style_image";
		break;
	default:
		image_select_ctl = "-not found-";
	}
	
	document.getElementById('frmChangeStyleSheet').action = "edit_css.php";
	document.getElementById('frmChangeStyleSheet').target = "_self";

	var file_element = document.getElementById(filename_ctl);
	if (file_element != null)
	{
		var preview_element = document.getElementById(preview_ctl).getElementsByTagName('IMG');
		if (preview_element[0] != null)
		{
			var photo_path_tn = preview_element[0].getAttribute("src");
			var photo_path = photo_path_tn.replace("/tn", "");
//				alert(photo_path);
			
			if (photo_path.indexOf('loading.gif') > -1)
			{
				RefreshTimer = setTimeout(function(){TryFileNameMoveAgain()}, 1000);
				return;
			}
			else if (photo_path != '')
			{
//				alert(photo_path);
				var photo_path_arr = photo_path.split("/");
				var last_el = photo_path_arr.length - 1;
				if (image_select_ctl != "-not found-")
				{
					var image_select_el = document.getElementById(image_select_ctl);
					var option = document.createElement("option");
					option.text = photo_path_arr[last_el];
					image_select_el.add(option, image_select_el[0]);
					image_select_el.selectedIndex = 0;
				}
			}
		}
//			alert(file_element.value);
		file_element.value = '';
		
		jq_filename_ctl = "#" + filename_ctl;
		jq_filenam_obj = $(jq_filename_ctl);
		jq_filenam_obj.replaceWith( jq_filenam_obj.clone( true ) );
	}
}

function TryFileNameMoveAgain()
{
	clearTimeout(RefreshTimer);
	RunPostAjaxUploadScript();
}

///////////////////////////////////////////////////////////////////////////////////////
function UpdateImage(i)
{
	var image_select_ctl;
	var html;
	switch(i)
	{
	case 1:
		image_select_ctl = "background_image";
		break;
	case 2:
		image_select_ctl = "list_style_image";
		break;
	default:
		image_select_ctl = "-not found-";
	}

	var preview_ctl = "preview" + i;
	var photo_img = "photo_img" + i;
	
	if (image_select_ctl != "-not found-")
	{
		var image = document.getElementById(image_select_ctl).value;
		var image_path = "../" + image_dir_path + "/" + image;
		var image_path_tn = "../" + image_tn_dir_path + "/" + image;
		
		if (image != "-not selected-")	{
			html = "<img src='" + image_path_tn + "' border='0' width='104' height='104' style='cursor:default;' onClick=\"window.open('" + image_path + "','view_photo" + i + "','menubar=0,resizable=0,width=600,height=600,location=0,status=0,scrollbars=1,toolbar=0,directories=0');\" onMouseOver=\"this.style.cursor='pointer';\" id='" + photo_img + "'  />";
			var mImageTimer = setTimeout("CheckBkgndImage('" + image_path + "', '" + photo_img + "');", 2000);
		}
		else	{
			html = "<img alt='photo' src='/manage/theme/" + theme + "/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img" + i + "' />";
		}
		
		document.getElementById(preview_ctl).innerHTML = html;
	}
}

function CheckBkgndImage(image_path, photo_img)
{
	if ((document.getElementById(photo_img).naturalWidth == 0) || (document.getElementById(photo_img).naturalWidth == 'undefined'))
		document.getElementById(photo_img).src = image_path;
}

///////////////////////////////////////////////////////////////////////////////////////////
function ChangeStyleSheetSort(bAlpha)
{
	var sort_alpha = 0;
	if (bAlpha === true)
		sort_alpha = 1;
		
	var style_sheet = document.getElementById('style_sheet').value;
	
	window.location = "edit_css.php?style_sheet_sort_method=" + sort_alpha + "&style_sheet=" + style_sheet;
}

function ChangeSort(bAlpha)
{
	var sort_alpha = 0;
	if (bAlpha === true)
		sort_alpha = 1;
	var goto_class = document.getElementById('goto_class').value;
	if (goto_class == "")
		goto_class = 0;
	var style_sheet = document.getElementById('style_sheet').value;
	
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDIT_CSS_SORTING_CLASS_LIST_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();

	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","sort_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage2(xmlhttp);

		params = "sort_alpha=" + sort_alpha;
		params = params + "&goto_class=" + goto_class;
		params = params + "&style_sheet=" + style_sheet;
	
		xmlhttp.send(params);
	}
}

function UpdateMessage2(xmlhttp)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				document.getElementById("goto_class_div").innerHTML = xmlhttp.responseText;
				popup_msg.status_msg = EDIT_CSS_SORT_COMPLETE;
			}
			popup_msg.popup_timeout = 1000;
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = QUERY_READY_TO_SEND;
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = QUERY_SENT;
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = EDIT_CSS_SORTING_MSG;
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function enable_disable_font_size()
{
	var units = document.getElementById("font_size_units").value;
	var font_size = "";
	
	var no_length_arr = new Array("xx-small","x-small","small","medium","large","x-large","xx-large","smaller","larger","initial","inherit");
	var integer_length_arr = new Array("px","%");
	
	if (no_length_arr.indexOf(units) > -1)
		document.getElementById("font_size").disabled = true;
	else
		document.getElementById("font_size").disabled = false;
		
	if (integer_length_arr.indexOf(units) > -1)	{
		font_size = document.getElementById("font_size").value;
		var font_size_arr = font_size.split(".");
		document.getElementById("font_size").value = font_size_arr[0];
	}
}

function CheckFormatOnUnitSelect(unit_el_id, length_el_id, offset)
{
	var units = document.getElementById(unit_el_id).value;
	var length = "";

	if (units < (2 + offset))	{
		length = document.getElementById(length_el_id).value;
		var length_arr = length.split(".");
		var length_str = length_arr[0];
		if (((units == (1 + offset)) && (length_arr.length > 1)) || ((unit_el_id == "line_height_units") && (units == 1)))	{
			var decimal = "";
			if ((length_el_id == "width") || (length_el_id == "height"))
				decimal = length_arr[1].substr(0, 2);
			else
				decimal = length_arr[1].substr(0, 1);
			length_str = length_str + "." + decimal;
		}
		document.getElementById(length_el_id).value = length_str;
	}
}

function CheckOverflowLists(selection, list)
{
	if ((selection != "-not selected-") && (list == "xy"))	{
		document.getElementById("overflow_x").value = "-not selected-";
		document.getElementById("overflow_y").value = "-not selected-";
	}
	else if ((selection != "-not selected-") && ((list == "x") || (list == "y")))	{
		document.getElementById("overflow").value = "-not selected-";
	}
}

function enable_disable_background_color(el_id)
{
	if (el_id == "bkgd_transparent")	{
		if (document.getElementById("bkgd_transparent").checked)	{
			document.getElementById("bkgd_color").value = _NOT_SET_;
			document.getElementById("bkgd_color").disabled = true;
			document.getElementById("bkgd_color").className = "not_set";
			document.getElementById("bkgd_opacity").value = _NOT_SET_;
			document.getElementById("bkgd_opacity").disabled = true;
			document.getElementById("bkgd_rgba").checked = false;
			document.getElementById("bkgd_rgba").disabled = true;
		}
		else	{
			document.getElementById("bkgd_color").disabled = false;
			if (document.getElementById("bkgd_color").value != _NOT_SET_)
				document.getElementById("bkgd_color").className = "";
			else
				document.getElementById("bkgd_color").className = "not_set";
			document.getElementById("bkgd_opacity").disabled = false;
			document.getElementById("bkgd_rgba").disabled = false;
		}
	}
	else	{
		if (document.getElementById("bkgd_rgba").checked)	{
			document.getElementById("bkgd_color").disabled = false;
			if (document.getElementById("bkgd_color").value != _NOT_SET_)
				document.getElementById("bkgd_color").className = "";
			else
				document.getElementById("bkgd_color").className = _NOT_SET_;
			document.getElementById("bkgd_opacity").disabled = false;
			document.getElementById("bkgd_transparent").checked = false;
			document.getElementById("bkgd_transparent").disabled = true;
		}
		else	{
			document.getElementById("bkgd_transparent").disabled = false;
		}
	}
}

function PreviewPageSelect()
{
	if (document.getElementById("preview_btn").className == "button_console_preview_disabled")
		return;

	var ntop = tempY - 1600;
	var strtop = ntop + "px";
	document.getElementById("page_select_div").style.display = "block";
	document.getElementById("page_select_div").style.bottom = strtop;
}
var preview_window;
function Preview(page_name, do_refresh)
{
	document.getElementById("page_select_div").style.display = "none";
	
	UpdateCSS('Preview', page_name + "@@@@@" + do_refresh);
}
function ShowPreview(page_name_do_refresh)
{
	var params = page_name_do_refresh.split("@@@@@");
	page_name = params[0];
	do_refresh = params[1];
	if (do_refresh != 1)	{
		var style_sheet = document.getElementById('style_sheet').value;
		var preview_page_string = "preview_page.php?page_name=" + page_name + "&special=3&mode=0&blog_id=0&style_sheet=" + style_sheet;
		preview_window = window.open(preview_page_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
	}
	else
		preview_window.location.reload();
}

function TextFieldClick(el)
{
	if (el.value.indexOf(_NOT_SET_) > -1)	{
		el.value = "";
		el.className = el.className.replace("not_set", "");
		el.style.color = "";
		el.style.backgroundColor = "";
	}
}
function TextFieldChange(el)
{
	el.value = el.value.replace(/[a-z]/gi, '');
}
function TextFieldBlur(el)
{
	if (el.value == "")	{
		el.value = _NOT_SET_;
		if (el.className == "")
			el.className = "not_set";
		else
			el.className = el.className + " not_set";
		el.style.color = "";
		el.style.backgroundColor = "";
	}
}

function ShowHideMaxWidthHeight(prefix, dimension)
{
	if (prefix == "min-max")	{
		document.getElementById("min_" + dimension + "_label").style.display = "inline";
		document.getElementById(dimension + "_label").style.display = "none";
		document.getElementById("max_" + dimension + "_label").style.visibility = "visible";
		document.getElementById("max_" + dimension + "").style.visibility = "visible";
		document.getElementById("max_" + dimension + "_units").style.visibility = "visible";
		TextFieldBlur(document.getElementById("max_" + dimension + ""));
	}
	else	{
		document.getElementById("min_" + dimension + "_label").style.display = "none";
		document.getElementById(dimension + "_label").style.display = "inline";
		document.getElementById("max_" + dimension + "_label").style.visibility = "hidden";
		document.getElementById("max_" + dimension + "").style.visibility = "hidden";
		document.getElementById("max_" + dimension + "_units").style.visibility = "hidden";
	}
}

function SetDisplayFlex()
{
	if (document.getElementById("set_display_flex_btn").className == "button_console_disabled")
		return;

	document.getElementById("display").value = "flex";
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDIT_CSS_DISPLAY_SET_TO_FLEX;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
}

function enable_disable_content_text()
{
	if ((document.getElementById("content").value == "string") || (document.getElementById("content").value == "url") || (document.getElementById("content").value == "attr"))
		document.getElementById("content_text").disabled = false;
	else
		document.getElementById("content_text").disabled = true;		
}

function display_text_instructions(selection)
{
	if (selection == "string")
		popup_msg.status_msg = EDIT_CSS_ENTER_STR_MSG;
	else if (selection == "url")
		popup_msg.status_msg = EDIT_CSS_ENTER_URL_MSG;
	else if (selection == "attr")
		popup_msg.status_msg = EDIT_CSS_ENTER_ATTR_MSG;

	if ((selection == "string")	|| (selection == "url") || (selection == "attr"))
	{
		popup_msg.popup_timeout = -1;
		popup_msg.popup_msg_type = 2;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.popup_timeout = 8000;
		popup_msg.ShowPopupMsg();
	}
}

function enable_disable_flex_basis_length()
{		
	if (document.getElementById("flex_basis").value == "length")	{
		document.getElementById("flex_basis_length").disabled = false;
		document.getElementById("flex_basis_length_units").disabled = false;
	}
	else	{
		document.getElementById("flex_basis_length").disabled = true;
		document.getElementById("flex_basis_length_units").disabled = true;
	}
}

function enable_disable_gradient()
{
	var gradient_color_el, gradient_opacity_el, i;
	if (document.getElementById("gradient_type").value == 0)	{
		document.getElementById("gradient_angle").disabled = true;
		for (i = 1; i <= 8; i++)
		{
			gradient_color_el = "gradient_color_" + i;
			gradient_opacity_el = "gradient_opacity_" + i;
			document.getElementById(gradient_color_el).className = "not_set";
			document.getElementById(gradient_color_el).style.backgroundColor = "#f0f0f0";
			document.getElementById(gradient_color_el).style.color = "#999999";	
			document.getElementById(gradient_color_el).disabled = true;
			document.getElementById(gradient_opacity_el).disabled = true;
		}
		document.getElementById("gradient_repeat").disabled = true;
	}
	else	{
		if (document.getElementById("gradient_type").value == 2)
			document.getElementById("gradient_angle").disabled = true;
		else
			document.getElementById("gradient_angle").disabled = false;
			
		for (i = 1; i <= 8; i++)
		{
			gradient_color_el = "gradient_color_" + i;
			gradient_opacity_el = "gradient_opacity_" + i;
			document.getElementById(gradient_color_el).className = "";
			if ((document.getElementById(gradient_color_el).value == "-not set-") || (document.getElementById(gradient_color_el).value == ""))	{
				document.getElementById(gradient_color_el).style.backgroundColor = "#ffffff";
				document.getElementById(gradient_color_el).style.color = "#999999";
			}
			else	{
				document.getElementById(gradient_color_el).style.backgroundColor = document.getElementById(gradient_color_el).value;
				document.getElementById(gradient_color_el).style.color = invertColor(document.getElementById(gradient_color_el).value);
			}
			document.getElementById(gradient_color_el).disabled = false;
			document.getElementById(gradient_opacity_el).disabled = false;
		}
		document.getElementById("gradient_repeat").disabled = false;
	}
}

function ManageImportantCSS()
{
	if (document.getElementById("important_btn").className == "button_console_important_disabled")
		return;
		
	var style_sheet = document.getElementById("style_sheet").value;
	var goto_class = document.getElementById("goto_class").value;
		
	window.location = "manage_important_css.php?style_sheet=" + style_sheet + "&class=" + goto_class;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}