////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/3/2014	ELL
// Revised: 3/10/2015	ELL
// Converted deprecated font stretch to letter spacing.
// Revised: 4/5/2015	ELL
// Added font size units.
// Converted save operation to AJAX.
// Revamped preview to show actual popup page.
// Modified: 3/23/2017	ELL
// Added ability to style button down states as well as complete implementation of background and item border colors in hover and active states.
// Revised: 9/12/2017	ELL
// Added ability to turn on or off text shadow for any of normal, hover and down states independently selectable in all 3 levels.
// Revised: 3/26/2018	ELL
// Replaced font select dropdowns with custom-built select comprised of divs, JavaScript and CSS for the display of font face both upon reviewing select and after selection.
// Added color feedback to all color selects.
// Revised: 4/16/2018	ELL
// Improved color text-box background and foreground color handling.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function SelectMenu(menu)
{
	var url = "edit_css_menu_styles.php?menu=" + menu;
	window.location.href = url;
}

function popupcolorpicker(form_name, field_name, top_offset)
{
	var start_color = document.getElementById(field_name).value;
	if (start_color == "")
		start_color = "-not set-";
	else
		start_color = start_color.replace("#", "");
	
	var URL = "colorpicker.php?form_name=" + form_name + "&field_name=" + field_name + "&source_page=edit_css_menu_styles.php&start_color=" + start_color;
	
	if ((typeof top_offset == 'undefined') || isNaN(top_offset))
		top_offset = 0;
	var ntop = parseInt(tempY) + parseInt(top_offset);
	var nleft = tempX;
	
	window.open (URL, "colorpicker", "alwaysRaised=0,dependent=1,menubar=0,resizable=0,width=450,height=350,scrollbars=0,location=0,top=" + ntop + ",left=" + nleft);
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_css_menu_styles", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function CheckLetterSpacing(element, letter_spacing_el_id)
{
	if (((element.value == 0) || (element.value > 14)) && (document.getElementById(letter_spacing_el_id).value != -1000000) && (document.getElementById(letter_spacing_el_id).value != '-not set-') && (document.getElementById(letter_spacing_el_id).value != ''))
	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = EDIT_CSS_MENU_STYLES_LETTER_SPACING_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 250;
		popup_msg.msg_width = 600;
		popup_msg.popup_timeout = 10000;
		popup_msg.ShowPopupMsg();
	}
	
	if ((element.value > 0) && (element.value < 15))
		document.getElementById(letter_spacing_el_id).disabled = false;
	else
		document.getElementById(letter_spacing_el_id).disabled = true;
}

function enable_disable_letter_spacing()
{
	if ((document.getElementById("top_level_letter_spacing_units").value > 0) && (document.getElementById("top_level_letter_spacing_units").value < 15))
		document.getElementById("top_level_letter_spacing").disabled = false;
	else
		document.getElementById("top_level_letter_spacing").disabled = true;
		
	if ((document.getElementById("sub_level_1_letter_spacing_units").value > 0) && (document.getElementById("sub_level_1_letter_spacing_units").value < 15))
		document.getElementById("sub_level_1_letter_spacing").disabled = false;
	else
		document.getElementById("sub_level_1_letter_spacing").disabled = true;
		
	if ((document.getElementById("sub_level_2_letter_spacing_units").value > 0) && (document.getElementById("sub_level_2_letter_spacing_units").value < 15))
		document.getElementById("sub_level_2_letter_spacing").disabled = false;
	else
		document.getElementById("sub_level_2_letter_spacing").disabled = true;

		
	if ((document.getElementById("top_level_letter_spacing_hover_units").value > 0) && (document.getElementById("top_level_letter_spacing_hover_units").value < 15))
		document.getElementById("top_level_letter_spacing_hover").disabled = false;
	else
		document.getElementById("top_level_letter_spacing_hover").disabled = true;
		
	if ((document.getElementById("sub_level_1_letter_spacing_hover_units").value > 0) && (document.getElementById("sub_level_1_letter_spacing_hover_units").value < 15))
		document.getElementById("sub_level_1_letter_spacing_hover").disabled = false;
	else
		document.getElementById("sub_level_1_letter_spacing_hover").disabled = true;
		
	if ((document.getElementById("sub_level_2_letter_spacing_hover_units").value > 0) && (document.getElementById("sub_level_2_letter_spacing_hover_units").value < 15))
		document.getElementById("sub_level_2_letter_spacing_hover").disabled = false;
	else
		document.getElementById("sub_level_2_letter_spacing_hover").disabled = true;
		
		
	if ((document.getElementById("top_level_letter_spacing_down_units").value > 0) && (document.getElementById("top_level_letter_spacing_down_units").value < 15))
		document.getElementById("top_level_letter_spacing_down").disabled = false;
	else
		document.getElementById("top_level_letter_spacing_down").disabled = true;
		
	if ((document.getElementById("sub_level_1_letter_spacing_down_units").value > 0) && (document.getElementById("sub_level_1_letter_spacing_down_units").value < 15))
		document.getElementById("sub_level_1_letter_spacing_down").disabled = false;
	else
		document.getElementById("sub_level_1_letter_spacing_down").disabled = true;
		
	if ((document.getElementById("sub_level_2_letter_spacing_down_units").value > 0) && (document.getElementById("sub_level_2_letter_spacing_down_units").value < 15))
		document.getElementById("sub_level_2_letter_spacing_down").disabled = false;
	else
		document.getElementById("sub_level_2_letter_spacing_down").disabled = true;	
}

function enable_disable_controls()
{
	enable_disable_letter_spacing();
	enable_disable_font_size('top_level_font_size', 'top_level_font_size_units');
	enable_disable_font_size('sub_level_1_font_size', 'sub_level_1_font_size_units');
	enable_disable_font_size('sub_level_2_font_size', 'sub_level_2_font_size_units');
	
	enable_disable_font_size('top_level_font_size_hover', 'top_level_font_size_hover_units');
	enable_disable_font_size('sub_level_1_font_size_hover', 'sub_level_1_font_size_hover_units');
	enable_disable_font_size('sub_level_2_font_size_hover', 'sub_level_2_font_size_hover_units');
	
	enable_disable_font_size('top_level_font_size_down', 'top_level_font_size_down_units');
	enable_disable_font_size('sub_level_1_font_size_down', 'sub_level_1_font_size_down_units');
	enable_disable_font_size('sub_level_2_font_size_down', 'sub_level_2_font_size_down_units');
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function enable_disable_font_size(font_size_el_id, font_size_units_el_id)
{
	var units = document.getElementById(font_size_units_el_id).value;
	var font_size = "";
	
	var no_length_arr = new Array("xx-small","x-small","small","medium","large","x-large","xx-large","smaller","larger","initial","inherit");
	var integer_length_arr = new Array("px","%");
	
	if (no_length_arr.indexOf(units) > -1)
		document.getElementById(font_size_el_id).disabled = true;
	else
		document.getElementById(font_size_el_id).disabled = false;
		
	if (integer_length_arr.indexOf(units) > -1)	{
		font_size = document.getElementById(font_size_el_id).value;
		var font_size_arr = font_size.split(".");
		document.getElementById(font_size_el_id).value = font_size_arr[0];
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function SaveMenuStyles()
{
	document.getElementById('operation').value = 'Update';
	
	$.ajax({type:'POST', url: 'save_css_menu_styles.php', data:$('#frm_menu_styles').serialize(), success: function(response) {
		CompleteSaveMenuStyles(response);
	}});
}
function CompleteSaveMenuStyles(response)
{
//alert(response);
	if (response == 1)
		popup_msg.status_msg = EDIT_CSS_MENU_STYLES_SAVE_SUCCESS_MSG;
	else
		popup_msg.status_msg = EDIT_CSS_MENU_STYLES_SAVE_FAIL_ERR;
	popup_msg.popup_msg_type = 1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 250;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function PreviewPageSelect()
{
	var ntop = tempY - 3000;
	var strtop = ntop + "px";
	document.getElementById("page_select_div").style.display = "block";
	document.getElementById("page_select_div").style.bottom = strtop;
}
function Preview(page_name, do_refresh)
{
	document.getElementById('operation').value = 'Preview';
	if (page_name == "")
		page_name = "index";
	
	$.ajax({type:'POST', url: 'save_css_menu_styles.php', data:$('#frm_menu_styles').serialize(), success: function(response) {
		CompletePreviewMenuStyles(response, page_name, do_refresh);
	}});
}
var preview_window;
function CompletePreviewMenuStyles(response, page_name, do_refresh)
{
	document.getElementById("page_select_div").style.display = "none";
		
	if (do_refresh != 1)	{
		var style_sheet = document.getElementById('menu').value;
		var preview_page_string = "preview_page.php?page_name=" + page_name + "&special=4&mode=0&blog_id=0&style_sheet=" + style_sheet;
		preview_window = window.open(preview_page_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
	}
	else
		preview_window.location.reload();
}

function CheckFormatOnUnitSelect(unit_el_id, length_el_id, offset)
{
	var units = document.getElementById(unit_el_id).value;
	var length = "";

	if (units < (2 + offset))	{
		length = document.getElementById(length_el_id).value;
		var length_arr = length.split(".");
		var length_str = length_arr[0];
		if (((units == (1 + offset)) && (length_arr.length > 1)) || ((unit_el_id == "line_height_units") && (units == 1)))	{
			var decimal = "";
			if ((length_el_id == "width") || (length_el_id == "height"))
				decimal = length_arr[1].substr(0, 2);
			else
				decimal = length_arr[1].substr(0, 1);
			length_str = length_str + "." + decimal;
		}
		document.getElementById(length_el_id).value = length_str;
	}
}

function InitializeForm()
{
	CheckFormatOnUnitSelect("top_level_font_size_units", "top_level_font_size", 0);
	CheckFormatOnUnitSelect("top_level_letter_spacing_units", "top_level_letter_spacing", 0);
	CheckFormatOnUnitSelect("sub_level_1_font_size_units", "sub_level_1_font_size", 0);
	CheckFormatOnUnitSelect("sub_level_1_letter_spacing_units", "sub_level_1_letter_spacing", 0);
	CheckFormatOnUnitSelect("sub_level_2_font_size_units", "sub_level_2_font_size", 0);
	CheckFormatOnUnitSelect("sub_level_2_letter_spacing_units", "sub_level_2_letter_spacing", 0);
	
	CheckFormatOnUnitSelect("top_level_font_size_hover_units", "top_level_font_size_hover", 0);
	CheckFormatOnUnitSelect("top_level_letter_spacing_hover_units", "top_level_letter_spacing_hover", 0);
	CheckFormatOnUnitSelect("sub_level_1_font_size_hover_units", "sub_level_1_font_size_hover", 0);
	CheckFormatOnUnitSelect("sub_level_1_letter_spacing_hover_units", "sub_level_1_letter_spacing_hover", 0);
	CheckFormatOnUnitSelect("sub_level_2_font_size_hover_units", "sub_level_2_font_size_hover", 0);
	CheckFormatOnUnitSelect("sub_level_2_letter_spacing_hover_units", "sub_level_2_letter_spacing_hover", 0);
	
	CheckFormatOnUnitSelect("top_level_font_size_down_units", "top_level_font_size_down", 0);
	CheckFormatOnUnitSelect("top_level_letter_spacing_down_units", "top_level_letter_spacing_down", 0);
	CheckFormatOnUnitSelect("sub_level_1_font_size_down_units", "sub_level_1_font_size_down", 0);
	CheckFormatOnUnitSelect("sub_level_1_letter_spacing_down_units", "sub_level_1_letter_spacing_down", 0);
	CheckFormatOnUnitSelect("sub_level_2_font_size_down_units", "sub_level_2_font_size_down", 0);
	CheckFormatOnUnitSelect("sub_level_2_letter_spacing_down_units", "sub_level_2_letter_spacing_down", 0);
	
	CheckFormatOnUnitSelect("top_level_block_border_units", "top_level_block_border_width", 0);
	CheckFormatOnUnitSelect("sub_level_block_border_units", "sub_level_block_border_width", 0);
	CheckFormatOnUnitSelect("top_level_item_border_units", "top_level_item_border_width", 0);
	CheckFormatOnUnitSelect("sub_level_1_item_border_units", "sub_level_1_item_border_width", 0);
	CheckFormatOnUnitSelect("sub_level_2_item_border_units", "sub_level_2_item_border_width", 0);
	
	CheckFormatOnUnitSelect("top_level_radius_top_left_units", "top_level_radius_top_left", 0);
	CheckFormatOnUnitSelect("top_level_radius_top_right_units", "top_level_radius_top_right", 0);
	CheckFormatOnUnitSelect("top_level_radius_bottom_right_units", "top_level_radius_bottom_right", 0);
	CheckFormatOnUnitSelect("top_level_radius_bottom_left_units", "top_level_radius_bottom_left", 0);
	
	CheckFormatOnUnitSelect("sub_level_1_radius_top_left_units", "sub_level_1_radius_top_left", 0);
	CheckFormatOnUnitSelect("sub_level_1_radius_top_right_units", "sub_level_1_radius_top_right", 0);
	CheckFormatOnUnitSelect("sub_level_1_radius_bottom_right_units", "sub_level_1_radius_bottom_right", 0);
	CheckFormatOnUnitSelect("sub_level_1_radius_bottom_left_units", "sub_level_1_radius_bottom_left", 0);
	
	CheckFormatOnUnitSelect("sub_level_2_radius_top_left_units", "sub_level_2_radius_top_left", 0);
	CheckFormatOnUnitSelect("sub_level_2_radius_top_right_units", "sub_level_2_radius_top_right", 0);
	CheckFormatOnUnitSelect("sub_level_2_radius_bottom_right_units", "sub_level_2_radius_bottom_right", 0);
	CheckFormatOnUnitSelect("sub_level_2_radius_bottom_left_units", "sub_level_2_radius_bottom_left", 0);
	
	if (document.getElementById("top_level_font_size").value == _NOT_SET_)
		document.getElementById("top_level_font_size").className = "not_set";
	else
		document.getElementById("top_level_font_size").className = "";
	if (document.getElementById("top_level_letter_spacing").value == _NOT_SET_)
		document.getElementById("top_level_letter_spacing").className = "not_set";
	else
		document.getElementById("top_level_letter_spacing").className = "";
	if (document.getElementById("top_level_shadow_color").value == _NOT_SET_)
		document.getElementById("top_level_shadow_color").className = "not_set";
	else
		document.getElementById("top_level_shadow_color").className = "";
	if (document.getElementById("top_level_shadow_x_offset").value == _NOT_SET_)
		document.getElementById("top_level_shadow_x_offset").className = "not_set";
	else
		document.getElementById("top_level_shadow_x_offset").className = "";
	if (document.getElementById("top_level_shadow_y_offset").value == _NOT_SET_)
		document.getElementById("top_level_shadow_y_offset").className = "not_set";
	else
		document.getElementById("top_level_shadow_y_offset").className = "";
	if (document.getElementById("top_level_shadow_blur").value == _NOT_SET_)
		document.getElementById("top_level_shadow_blur").className = "not_set";
	else
		document.getElementById("top_level_shadow_blur").className = "";
	if (document.getElementById("sub_level_1_font_size").value == _NOT_SET_)
		document.getElementById("sub_level_1_font_size").className = "not_set";
	else
		document.getElementById("sub_level_1_font_size").className = "";
	if (document.getElementById("sub_level_1_letter_spacing").value == _NOT_SET_)
		document.getElementById("sub_level_1_letter_spacing").className = "not_set";
	else
		document.getElementById("sub_level_1_letter_spacing").className = "";
	if (document.getElementById("sub_level_1_shadow_color").value == _NOT_SET_)
		document.getElementById("sub_level_1_shadow_color").className = "not_set";
	else
		document.getElementById("sub_level_1_shadow_color").className = "";
	if (document.getElementById("sub_level_1_shadow_x_offset").value == _NOT_SET_)
		document.getElementById("sub_level_1_shadow_x_offset").className = "not_set";
	else
		document.getElementById("sub_level_1_shadow_x_offset").className = "";
	if (document.getElementById("sub_level_1_shadow_y_offset").value == _NOT_SET_)
		document.getElementById("sub_level_1_shadow_y_offset").className = "not_set";
	else
		document.getElementById("sub_level_1_shadow_y_offset").className = "";
	if (document.getElementById("sub_level_1_shadow_blur").value == _NOT_SET_)
		document.getElementById("sub_level_1_shadow_blur").className = "not_set";
	else
		document.getElementById("sub_level_1_shadow_blur").className = "";
	if (document.getElementById("sub_level_2_font_size").value == _NOT_SET_)
		document.getElementById("sub_level_2_font_size").className = "not_set";
	else
		document.getElementById("sub_level_2_font_size").className = "";
	if (document.getElementById("sub_level_2_letter_spacing").value == _NOT_SET_)
		document.getElementById("sub_level_2_letter_spacing").className = "not_set";
	else
		document.getElementById("sub_level_2_letter_spacing").className = "";
	if (document.getElementById("sub_level_2_shadow_color").value == _NOT_SET_)
		document.getElementById("sub_level_2_shadow_color").className = "not_set";
	else
		document.getElementById("sub_level_2_shadow_color").className = "";
	if (document.getElementById("sub_level_2_shadow_x_offset").value == _NOT_SET_)
		document.getElementById("sub_level_2_shadow_x_offset").className = "not_set";
	else
		document.getElementById("sub_level_2_shadow_x_offset").className = "";
	if (document.getElementById("sub_level_2_shadow_y_offset").value == _NOT_SET_)
		document.getElementById("sub_level_2_shadow_y_offset").className = "not_set";
	else
		document.getElementById("sub_level_2_shadow_y_offset").className = "";
	if (document.getElementById("sub_level_2_shadow_blur").value == _NOT_SET_)
		document.getElementById("sub_level_2_shadow_blur").className = "not_set";
	else
		document.getElementById("sub_level_2_shadow_blur").className = "";
	if (document.getElementById("top_level_text_color").value == _NOT_SET_)
		document.getElementById("top_level_text_color").className = "not_set";
	else
		document.getElementById("top_level_text_color").className = "";
	if (document.getElementById("top_level_text_color_hover").value == _NOT_SET_)
		document.getElementById("top_level_text_color_hover").className = "not_set";
	else
		document.getElementById("top_level_text_color_hover").className = "";
	if (document.getElementById("top_level_text_color_down").value == _NOT_SET_)
		document.getElementById("top_level_text_color_down").className = "not_set";
	else
		document.getElementById("top_level_text_color_down").className = "";
	if (document.getElementById("top_level_text_color_active").value == _NOT_SET_)
		document.getElementById("top_level_text_color_active").className = "not_set";
	else
		document.getElementById("top_level_text_color_active").className = "";
	if (document.getElementById("sub_level_1_text_color").value == _NOT_SET_)
		document.getElementById("sub_level_1_text_color").className = "not_set";
	else
		document.getElementById("sub_level_1_text_color").className = "";
	if (document.getElementById("sub_level_1_text_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_1_text_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_1_text_color_hover").className = "";
	if (document.getElementById("sub_level_1_text_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_1_text_color_down").className = "not_set";
	else
		document.getElementById("sub_level_1_text_color_down").className = "";
	if (document.getElementById("sub_level_1_text_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_1_text_color_active").className = "not_set";
	else
		document.getElementById("sub_level_1_text_color_active").className = "";
	if (document.getElementById("sub_level_2_text_color").value == _NOT_SET_)
		document.getElementById("sub_level_2_text_color").className = "not_set";
	else
		document.getElementById("sub_level_2_text_color").className = "";
	if (document.getElementById("sub_level_2_text_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_2_text_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_2_text_color_hover").className = "";
	if (document.getElementById("sub_level_2_text_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_2_text_color_down").className = "not_set";
	else
		document.getElementById("sub_level_2_text_color_down").className = "";
	if (document.getElementById("sub_level_2_text_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_2_text_color_active").className = "not_set";
	else
		document.getElementById("sub_level_2_text_color_active").className = "";
	if (document.getElementById("top_level_background_color").value == _NOT_SET_)
		document.getElementById("top_level_background_color").className = "not_set";
	else
		document.getElementById("top_level_background_color").className = "";
	if (document.getElementById("top_level_background_color_hover").value == _NOT_SET_)
		document.getElementById("top_level_background_color_hover").className = "not_set";
	else
		document.getElementById("top_level_background_color_hover").className = "";
	if (document.getElementById("top_level_background_color_down").value == _NOT_SET_)
		document.getElementById("top_level_background_color_down").className = "not_set";
	else
		document.getElementById("top_level_background_color_down").className = "";
	if (document.getElementById("top_level_background_color_active").value == _NOT_SET_)
		document.getElementById("top_level_background_color_active").className = "not_set";
	else
		document.getElementById("top_level_background_color_active").className = "";
	if (document.getElementById("top_level_background_opacity").value == _NOT_SET_)
		document.getElementById("top_level_background_opacity").className = "not_set";
	else
		document.getElementById("top_level_background_opacity").className = "";
	if (document.getElementById("sub_level_1_background_color").value == _NOT_SET_)
		document.getElementById("sub_level_1_background_color").className = "not_set";
	else
		document.getElementById("sub_level_1_background_color").className = "";
	if (document.getElementById("sub_level_1_background_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_1_background_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_1_background_color_hover").className = "";
	if (document.getElementById("sub_level_1_background_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_1_background_color_down").className = "not_set";
	else
		document.getElementById("sub_level_1_background_color_down").className = "";
	if (document.getElementById("sub_level_1_background_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_1_background_color_active").className = "not_set";
	else
		document.getElementById("sub_level_1_background_color_active").className = "";
	if (document.getElementById("sub_level_1_background_opacity").value == _NOT_SET_)
		document.getElementById("sub_level_1_background_opacity").className = "not_set";
	else
		document.getElementById("sub_level_1_background_opacity").className = "";
	if (document.getElementById("sub_level_2_background_color").value == _NOT_SET_)
		document.getElementById("sub_level_2_background_color").className = "not_set";
	else
		document.getElementById("sub_level_2_background_color").className = "";
	if (document.getElementById("sub_level_2_background_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_2_background_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_2_background_color_hover").className = "";
	if (document.getElementById("sub_level_2_background_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_2_background_color_down").className = "not_set";
	else
		document.getElementById("sub_level_2_background_color_down").className = "";
	if (document.getElementById("sub_level_2_background_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_2_background_color_active").className = "not_set";
	else
		document.getElementById("sub_level_2_background_color_active").className = "";
	if (document.getElementById("sub_level_2_background_opacity").value == _NOT_SET_)
		document.getElementById("sub_level_2_background_opacity").className = "not_set";
	else
		document.getElementById("sub_level_2_background_opacity").className = "";
	if (document.getElementById("top_level_block_border_color").value == _NOT_SET_)
		document.getElementById("top_level_block_border_color").className = "not_set";
	else
		document.getElementById("top_level_block_border_color").className = "";
	if (document.getElementById("top_level_block_border_width").value == _NOT_SET_)
		document.getElementById("top_level_block_border_width").className = "not_set";
	else
		document.getElementById("top_level_block_border_width").className = "";
	if (document.getElementById("sub_level_block_border_color").value == _NOT_SET_)
		document.getElementById("sub_level_block_border_color").className = "not_set";
	else
		document.getElementById("sub_level_block_border_color").className = "";
	if (document.getElementById("sub_level_block_border_width").value == _NOT_SET_)
		document.getElementById("sub_level_block_border_width").className = "not_set";
	else
		document.getElementById("sub_level_block_border_width").className = "";
	if (document.getElementById("top_level_item_border_color").value == _NOT_SET_)
		document.getElementById("top_level_item_border_color").className = "not_set";
	else
		document.getElementById("top_level_item_border_color").className = "";
	if (document.getElementById("top_level_item_border_color_hover").value == _NOT_SET_)
		document.getElementById("top_level_item_border_color_hover").className = "not_set";
	else
		document.getElementById("top_level_item_border_color_hover").className = "";
	if (document.getElementById("top_level_item_border_color_down").value == _NOT_SET_)
		document.getElementById("top_level_item_border_color_down").className = "not_set";
	else
		document.getElementById("top_level_item_border_color_down").className = "";
	if (document.getElementById("top_level_item_border_color_active").value == _NOT_SET_)
		document.getElementById("top_level_item_border_color_active").className = "not_set";
	else
		document.getElementById("top_level_item_border_color_active").className = "";
	if (document.getElementById("top_level_item_border_width").value == _NOT_SET_)
		document.getElementById("top_level_item_border_width").className = "not_set";
	else
		document.getElementById("top_level_item_border_width").className = "";
	if (document.getElementById("sub_level_1_item_border_color").value == _NOT_SET_)
		document.getElementById("sub_level_1_item_border_color").className = "not_set";
	else
		document.getElementById("sub_level_1_item_border_color").className = "";
	if (document.getElementById("sub_level_1_item_border_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_1_item_border_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_1_item_border_color_hover").className = "";
	if (document.getElementById("sub_level_1_item_border_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_1_item_border_color_down").className = "not_set";
	else
		document.getElementById("sub_level_1_item_border_color_down").className = "";
	if (document.getElementById("sub_level_1_item_border_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_1_item_border_color_active").className = "not_set";
	else
		document.getElementById("sub_level_1_item_border_color_active").className = "";
	if (document.getElementById("sub_level_1_item_border_width").value == _NOT_SET_)
		document.getElementById("sub_level_1_item_border_width").className = "not_set";
	else
		document.getElementById("sub_level_1_item_border_width").className = "";
	if (document.getElementById("sub_level_2_item_border_color").value == _NOT_SET_)
		document.getElementById("sub_level_2_item_border_color").className = "not_set";
	else
		document.getElementById("sub_level_2_item_border_color").className = "";
	if (document.getElementById("sub_level_2_item_border_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_2_item_border_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_2_item_border_color_hover").className = "";
	if (document.getElementById("sub_level_2_item_border_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_2_item_border_color_down").className = "not_set";
	else
		document.getElementById("sub_level_2_item_border_color_down").className = "";
	if (document.getElementById("sub_level_2_item_border_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_2_item_border_color_active").className = "not_set";
	else
		document.getElementById("sub_level_2_item_border_color_active").className = "";
	if (document.getElementById("sub_level_2_item_border_width").value == _NOT_SET_)
		document.getElementById("sub_level_2_item_border_width").className = "not_set";
	else
		document.getElementById("sub_level_2_item_border_width").className = "";
		
	if (document.getElementById("top_level_radius_top_left").value == _NOT_SET_)
		document.getElementById("top_level_radius_top_left").className = "not_set";
	else
		document.getElementById("top_level_radius_top_left").className = "";
	if (document.getElementById("top_level_radius_top_right").value == _NOT_SET_)
		document.getElementById("top_level_radius_top_right").className = "not_set";
	else
		document.getElementById("top_level_radius_top_right").className = "";
	if (document.getElementById("top_level_radius_bottom_right").value == _NOT_SET_)
		document.getElementById("top_level_radius_bottom_right").className = "not_set";
	else
		document.getElementById("top_level_radius_bottom_right").className = "";
	if (document.getElementById("top_level_radius_bottom_left").value == _NOT_SET_)
		document.getElementById("top_level_radius_bottom_left").className = "not_set";
	else
		document.getElementById("top_level_radius_bottom_left").className = "";
	if (document.getElementById("sub_level_1_radius_top_left").value == _NOT_SET_)
		document.getElementById("sub_level_1_radius_top_left").className = "not_set";
	else
		document.getElementById("sub_level_1_radius_top_left").className = "";
	if (document.getElementById("sub_level_1_radius_top_right").value == _NOT_SET_)
		document.getElementById("sub_level_1_radius_top_right").className = "not_set";
	else
		document.getElementById("sub_level_1_radius_top_right").className = "";
	if (document.getElementById("sub_level_1_radius_bottom_right").value == _NOT_SET_)
		document.getElementById("sub_level_1_radius_bottom_right").className = "not_set";
	else
		document.getElementById("sub_level_1_radius_bottom_right").className = "";
	if (document.getElementById("sub_level_1_radius_bottom_left").value == _NOT_SET_)
		document.getElementById("sub_level_1_radius_bottom_left").className = "not_set";
	else
		document.getElementById("sub_level_1_radius_bottom_left").className = "";
	if (document.getElementById("sub_level_2_radius_top_left").value == _NOT_SET_)
		document.getElementById("sub_level_2_radius_top_left").className = "not_set";
	else
		document.getElementById("sub_level_2_radius_top_left").className = "";
	if (document.getElementById("sub_level_2_radius_top_right").value == _NOT_SET_)
		document.getElementById("sub_level_2_radius_top_right").className = "not_set";
	else
		document.getElementById("sub_level_2_radius_top_right").className = "";
	if (document.getElementById("sub_level_2_radius_bottom_right").value == _NOT_SET_)
		document.getElementById("sub_level_2_radius_bottom_right").className = "not_set";
	else
		document.getElementById("sub_level_2_radius_bottom_right").className = "";
	if (document.getElementById("sub_level_2_radius_bottom_left").value == _NOT_SET_)
		document.getElementById("sub_level_2_radius_bottom_left").className = "not_set";
	else
		document.getElementById("sub_level_2_radius_bottom_left").className = "";
		
	if (document.getElementById("top_level_box_shadow_horizontal").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_horizontal").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_horizontal").className = "";
	if (document.getElementById("top_level_box_shadow_vertical").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_vertical").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_vertical").className = "";	
	if (document.getElementById("top_level_box_shadow_blur").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_blur").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_blur").className = "";
	if (document.getElementById("top_level_box_shadow_spread").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_spread").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_spread").className = "";
	if (document.getElementById("top_level_box_shadow_color").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_color").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_color").className = "";
		
	if (document.getElementById("sub_level_1_box_shadow_horizontal").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_horizontal").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_horizontal").className = "";
	if (document.getElementById("sub_level_1_box_shadow_vertical").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_vertical").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_vertical").className = "";	
	if (document.getElementById("sub_level_1_box_shadow_blur").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_blur").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_blur").className = "";
	if (document.getElementById("sub_level_1_box_shadow_spread").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_spread").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_spread").className = "";
	if (document.getElementById("sub_level_1_box_shadow_color").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_color").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_color").className = "";
		
	if (document.getElementById("sub_level_2_box_shadow_horizontal").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_horizontal").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_horizontal").className = "";
	if (document.getElementById("sub_level_2_box_shadow_vertical").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_vertical").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_vertical").className = "";	
	if (document.getElementById("sub_level_2_box_shadow_blur").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_blur").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_blur").className = "";
	if (document.getElementById("sub_level_2_box_shadow_spread").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_spread").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_spread").className = "";
	if (document.getElementById("sub_level_2_box_shadow_color").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_color").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_color").className = "";
		
	/////////////////////////////////////////////////////////////////////////////
	if (document.getElementById("top_level_font_size_hover").value == _NOT_SET_)
		document.getElementById("top_level_font_size_hover").className = "not_set";
	else
		document.getElementById("top_level_font_size_hover").className = "";
	if (document.getElementById("top_level_letter_spacing_hover").value == _NOT_SET_)
		document.getElementById("top_level_letter_spacing_hover").className = "not_set";
	else
		document.getElementById("top_level_letter_spacing_hover").className = "";
	if (document.getElementById("top_level_shadow_color_hover").value == _NOT_SET_)
		document.getElementById("top_level_shadow_color_hover").className = "not_set";
	else
		document.getElementById("top_level_shadow_color_hover").className = "";
	
	if (document.getElementById("sub_level_1_font_size_hover").value == _NOT_SET_)
		document.getElementById("sub_level_1_font_size_hover").className = "not_set";
	else
		document.getElementById("sub_level_1_font_size_hover").className = "";
	if (document.getElementById("sub_level_1_letter_spacing_hover").value == _NOT_SET_)
		document.getElementById("sub_level_1_letter_spacing_hover").className = "not_set";
	else
		document.getElementById("sub_level_1_letter_spacing_hover").className = "";
	if (document.getElementById("sub_level_1_shadow_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_1_shadow_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_1_shadow_color_hover").className = "";
	
	if (document.getElementById("sub_level_2_font_size_hover").value == _NOT_SET_)
		document.getElementById("sub_level_2_font_size_hover").className = "not_set";
	else
		document.getElementById("sub_level_2_font_size_hover").className = "";
	if (document.getElementById("sub_level_2_letter_spacing_hover").value == _NOT_SET_)
		document.getElementById("sub_level_2_letter_spacing_hover").className = "not_set";
	else
		document.getElementById("sub_level_2_letter_spacing_hover").className = "";
	if (document.getElementById("sub_level_2_shadow_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_2_shadow_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_2_shadow_color_hover").className = "";
	
	if (document.getElementById("top_level_box_shadow_color_hover").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_color_hover").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_color_hover").className = "";
		
	if (document.getElementById("sub_level_1_box_shadow_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_color_hover").className = "";
		
	if (document.getElementById("sub_level_2_box_shadow_color_hover").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_color_hover").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_color_hover").className = "";
	//////////////////////////////////////////////////////////
	if (document.getElementById("top_level_font_size_down").value == _NOT_SET_)
		document.getElementById("top_level_font_size_down").className = "not_set";
	else
		document.getElementById("top_level_font_size_down").className = "";
	if (document.getElementById("top_level_letter_spacing_down").value == _NOT_SET_)
		document.getElementById("top_level_letter_spacing_down").className = "not_set";
	else
		document.getElementById("top_level_letter_spacing_down").className = "";
	if (document.getElementById("top_level_shadow_color_down").value == _NOT_SET_)
		document.getElementById("top_level_shadow_color_down").className = "not_set";
	else
		document.getElementById("top_level_shadow_color_down").className = "";
	
	if (document.getElementById("sub_level_1_font_size_down").value == _NOT_SET_)
		document.getElementById("sub_level_1_font_size_down").className = "not_set";
	else
		document.getElementById("sub_level_1_font_size_down").className = "";
	if (document.getElementById("sub_level_1_letter_spacing_down").value == _NOT_SET_)
		document.getElementById("sub_level_1_letter_spacing_down").className = "not_set";
	else
		document.getElementById("sub_level_1_letter_spacing_down").className = "";
	if (document.getElementById("sub_level_1_shadow_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_1_shadow_color_down").className = "not_set";
	else
		document.getElementById("sub_level_1_shadow_color_down").className = "";
	
	if (document.getElementById("sub_level_2_font_size_down").value == _NOT_SET_)
		document.getElementById("sub_level_2_font_size_down").className = "not_set";
	else
		document.getElementById("sub_level_2_font_size_down").className = "";
	if (document.getElementById("sub_level_2_letter_spacing_down").value == _NOT_SET_)
		document.getElementById("sub_level_2_letter_spacing_down").className = "not_set";
	else
		document.getElementById("sub_level_2_letter_spacing_down").className = "";
	if (document.getElementById("sub_level_2_shadow_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_2_shadow_color_down").className = "not_set";
	else
		document.getElementById("sub_level_2_shadow_color_down").className = "";
	
	if (document.getElementById("top_level_box_shadow_color_down").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_color_down").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_color_down").className = "";
		
	if (document.getElementById("sub_level_1_box_shadow_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_color_down").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_color_down").className = "";
		
	if (document.getElementById("sub_level_2_box_shadow_color_down").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_color_down").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_color_down").className = "";
	////////////////////////////////////////////////////////////////////////
	if (document.getElementById("top_level_box_shadow_color_active").value == _NOT_SET_)
		document.getElementById("top_level_box_shadow_color_active").className = "not_set";
	else
		document.getElementById("top_level_box_shadow_color_active").className = "";
		
	if (document.getElementById("sub_level_1_box_shadow_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_1_box_shadow_color_active").className = "not_set";
	else
		document.getElementById("sub_level_1_box_shadow_color_active").className = "";
		
	if (document.getElementById("sub_level_2_box_shadow_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_2_box_shadow_color_active").className = "not_set";
	else
		document.getElementById("sub_level_2_box_shadow_color_active").className = "";
		
	if (document.getElementById("top_level_shadow_color_active").value == _NOT_SET_)
		document.getElementById("top_level_shadow_color_active").className = "not_set";
	else
		document.getElementById("top_level_shadow_color_active").className = "";
	if (document.getElementById("sub_level_1_shadow_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_1_shadow_color_active").className = "not_set";
	else
		document.getElementById("sub_level_1_shadow_color_active").className = "";
	if (document.getElementById("sub_level_2_shadow_color_active").value == _NOT_SET_)
		document.getElementById("sub_level_2_shadow_color_active").className = "not_set";
	else
		document.getElementById("sub_level_2_shadow_color_active").className = "";
		
		
	CheckItemBorderSettings("top_level");
	CheckItemBorderSettings("sub_level_1");
	CheckItemBorderSettings("sub_level_2");
	
	enable_disable_shadow("top_level");
	enable_disable_shadow("sub_level_1");
	enable_disable_shadow("sub_level_2");
	
	enable_disable_gradient('top_level_', '');
	enable_disable_gradient('top_level_', '_hover');
	enable_disable_gradient('top_level_', '_down');
	enable_disable_gradient('top_level_', '_active');
	enable_disable_gradient('sub_level_1_', '');
	enable_disable_gradient('sub_level_1_', '_hover');
	enable_disable_gradient('sub_level_1_', '_down');
	enable_disable_gradient('sub_level_1_', '_active');
	enable_disable_gradient('sub_level_2_', '');
	enable_disable_gradient('sub_level_2_', '_hover');
	enable_disable_gradient('sub_level_2_', '_down');
	enable_disable_gradient('sub_level_2_', '_active');
}

function CheckItemBorderSettings(level)
{
	var item_omit_adjacent_border;
	if (level == "top_level")
		item_omit_adjacent_border = document.getElementById("top_level_item_omit_adjacent_border");
	else if (level == "sub_level_1")
		item_omit_adjacent_border = document.getElementById("sub_level_1_item_omit_adjacent_border");
	else
		item_omit_adjacent_border = document.getElementById("sub_level_2_item_omit_adjacent_border");
	var item_border_top = document.getElementById(level + "_item_border_top");
	var item_border_bottom = document.getElementById(level + "_item_border_bottom");
	var item_border_left = document.getElementById(level + "_item_border_left");
	var item_border_right = document.getElementById(level + "_item_border_right");
	
	if (item_omit_adjacent_border.checked)
	{
		item_border_top.checked = true;
		item_border_bottom.checked = true;
		item_border_left.checked = true;
		item_border_right.checked = true;
	}
}

function CheckItemBorder(is_checked, level)
{
	var item_omit_adjacent_border = document.getElementById(level + "_item_omit_adjacent_border");
	if (!is_checked)	{
		item_omit_adjacent_border.checked = false;
		CheckItemBorderSettings(level);
	}
}

function TextFieldClick(el)
{
	if (el.value.indexOf(_NOT_SET_) > -1)	{
		el.value = "";
		el.className = el.className.replace("not_set", "");
		el.style.color = "";
		el.style.backgroundColor = "";
	}
}
function TextFieldChange(el)
{
	el.value = el.value.replace(/[a-z]/gi, '');
}
function TextFieldBlur(el)
{
	if (el.value == "")	{
		el.value = _NOT_SET_;
		if (el.className == "")
			el.className = "not_set";
		else
			el.className = el.className + " not_set";
		el.style.color = "";
		el.style.backgroundColor = "";
	}
}

function CheckUncheckAllHoverOnDown(check_uncheck)
{
	document.getElementById("top_level_txt_color_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_1_txt_color_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_2_txt_color_hover_on_down").checked = check_uncheck;
	document.getElementById("top_level_bkgd_color_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_1_bkgd_color_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_2_bkgd_color_hover_on_down").checked = check_uncheck;
	document.getElementById("top_level_border_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_1_border_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_2_border_hover_on_down").checked = check_uncheck;
	document.getElementById("top_level_bkgd_gradient_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_1_bkgd_gradient_hover_on_down").checked = check_uncheck;
	document.getElementById("sub_level_2_bkgd_gradient_hover_on_down").checked = check_uncheck;
}

function enable_disable_shadow(level, initial)
{
	var shadow = level + "_shadow";
	var shadow_hover = level + "_shadow_hover";
	var shadow_down = level + "_shadow_down";
	var shadow_color = level + "_shadow_color";
	var shadow_color_hover = level + "_shadow_color_hover";
	var shadow_color_down = level + "_shadow_color_down";
	var shadow_color_active = level + "_shadow_color_active";
	var shadow_x_offset = level + "_shadow_x_offset";
	var shadow_y_offset = level + "_shadow_y_offset";
	var shadow_blur = level + "_shadow_blur";
	
	
	if ((document.getElementById(shadow).checked == true) || (document.getElementById(shadow_hover).checked == true) || (document.getElementById(shadow_down).checked == true))
	{
		document.getElementById(shadow_color_active).disabled = false;
		document.getElementById(shadow_x_offset).disabled = false;
		document.getElementById(shadow_y_offset).disabled = false;
		document.getElementById(shadow_blur).disabled = false;
	}
	else
	{
		document.getElementById(shadow_color_active).disabled = true;
		document.getElementById(shadow_x_offset).disabled = true;
		document.getElementById(shadow_y_offset).disabled = true;
		document.getElementById(shadow_blur).disabled = true;
	}
	
	if (document.getElementById(shadow).checked == true)
		document.getElementById(shadow_color).disabled = false;
	else
		document.getElementById(shadow_color).disabled = true;
		
	if (document.getElementById(shadow_hover).checked == true)
		document.getElementById(shadow_color_hover).disabled = false;
	else
		document.getElementById(shadow_color_hover).disabled = true;
		
	if (document.getElementById(shadow_down).checked == true)
		document.getElementById(shadow_color_down).disabled = false;
	else
		document.getElementById(shadow_color_down).disabled = true;
}

function enable_disable_gradient(pre, suf)
{
	var gradient_type = pre + "gradient_type" + suf;
	var gradient_angle = pre + "gradient_angle" + suf;
	var gradient_color_1 = pre + "gradient_color_1" + suf;
	var gradient_color_2 = pre + "gradient_color_2" + suf;
	var gradient_color_3 = pre + "gradient_color_3" + suf;
	var gradient_color_4 = pre + "gradient_color_4" + suf;
	var gradient_opacity_1 = pre + "gradient_opacity_1" + suf;
	var gradient_opacity_2 = pre + "gradient_opacity_2" + suf;
	var gradient_opacity_3 = pre + "gradient_opacity_3" + suf;
	var gradient_opacity_4 = pre + "gradient_opacity_4" + suf;
	var gradient_repeat = pre + "gradient_repeat" + suf;
		
	if (document.getElementById(gradient_type).value == 0)	{
		document.getElementById(gradient_angle).disabled = true;
		document.getElementById(gradient_color_1).disabled = true;
		document.getElementById(gradient_color_2).disabled = true;
		document.getElementById(gradient_color_3).disabled = true;
		document.getElementById(gradient_color_4).disabled = true;
		document.getElementById(gradient_opacity_1).disabled = true;
		document.getElementById(gradient_opacity_2).disabled = true;
		document.getElementById(gradient_opacity_3).disabled = true;
		document.getElementById(gradient_opacity_4).disabled = true;
		document.getElementById(gradient_repeat).disabled = true;
	}
	else	{
		if (document.getElementById(gradient_type).value == 2)
			document.getElementById(gradient_angle).disabled = true;
		else
			document.getElementById(gradient_angle).disabled = false;
		document.getElementById(gradient_color_1).disabled = false;
		document.getElementById(gradient_color_2).disabled = false;
		document.getElementById(gradient_color_3).disabled = false;
		document.getElementById(gradient_color_4).disabled = false;
		document.getElementById(gradient_opacity_1).disabled = false;
		document.getElementById(gradient_opacity_2).disabled = false;
		document.getElementById(gradient_opacity_3).disabled = false;
		document.getElementById(gradient_opacity_4).disabled = false;
		document.getElementById(gradient_repeat).disabled = false;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}