////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 3/25/2018	ELL
//
function ExpandCollapseFonts(font_select, font)
{
	if (document.getElementById(font).disabled == true)
		return;
		
	if (font_select.className == "font_select")
		font_select.className = "font_select_expanded";
	else
		font_select.className = "font_select";
}

function SetFont(font_select_id, font, font_face)
{
	if (document.getElementById(font_select_id).className == "font_select_expanded")	{
		document.getElementById(font).value = font_face;
		document.getElementById(font).style.fontFamily = font_face;
		
		SetSelectedOption(font_select_id, font_face);
	}
}

function CollapseFonts(font_select)
{
	font_select.className = "font_select";
}

function SetSelectedOption(font_select_id, font_face)
{
	var option_divs = document.getElementById(font_select_id).children;
	var font_span;
	var font_str;
	for (var i = 0; i < option_divs.length; i++) {
		if (typeof(option_divs[i].children[0]) != "undefined")	{
			font_span = option_divs[i].children;
			font_str = font_span[0].innerHTML;
			font_str_arr = font_str.split("<");
			if (font_str_arr[0] == font_face)
				option_divs[i].className = "font_option_selected";
			else
				option_divs[i].className = "font_option";
		}
	}
}