/////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/20/2018	ELL
// 
//

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

if (self != top)
	window.parent.document.title = document.title;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

////////////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#custom_fonts", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(i, new_row_flag)
{
	var font_ctl = "font" + i;
	var file_browse_ctl = "file_browse" + i;
	var src_ctl = "src" + i;
	var src_type_upload_ctl = "src_type_upload" + i;
	var src_type_url_ctl = "src_type_url" + i;
	var font = document.getElementById(font_ctl).value;
	var	src = document.getElementById(src_ctl).value;
	if (new_row_flag == "-new font-")
		font = "-new font-";
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_1_MSG + " <b>" + font + "</b> " + MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_2_MSG + " <b>" + src + "</b> " + MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_3_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteFont(font, src); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteFont(font, src)
{
	popup_msg.HidePopupMsg();
	if (font != "-new font-")
		$.post( "delete_font.php", { font: font, src: src } ).done(CompleteDeleteFont) ;
	else RetrieveFonts();
}
function CompleteDeleteFont()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	popup_msg.status_msg = MANAGE_CUSTOM_FONTS_DELETE_FONT_COMPLETE_MSG
	popup_msg.ShowPopupMsg();
	RetrieveFonts();
}

//////////////////////////////////////////////////////////////////////////////////////
function ValidateForm(i)
{
	var font_ctl = "font" + i;
	var file_browse_ctl = "file_browse" + i;
	var src_ctl = "src" + i;
	var src_type_upload_ctl = "src_type_upload" + i;
	var src_type_url_ctl = "src_type_url" + i;
	
	document.getElementById(font_ctl).className = "med_txt_field";
	document.getElementById(src_ctl).className = "long_txt_field";
	document.getElementById(file_browse_ctl).className = "file_browse";
	var bResult = true;
	if (document.getElementById(font_ctl).value == "")	{
		document.getElementById(font_ctl).className = "med_txt_field highlight";
		document.getElementById(font_ctl).focus();
		popup_msg.status_msg = MANAGE_FONTS_NO_FONT_ERR;
		bResult = false;
	}
	if ((document.getElementById(file_browse_ctl).value == "") && (document.getElementById(src_ctl).value == "") && (document.getElementById(src_type_upload_ctl).checked === true))	{
		document.getElementById(file_browse_ctl).className = "file_browse highlight";
		document.getElementById(file_browse_ctl).focus();
		popup_msg.status_msg = MANAGE_FONTS_NO_UPLOAD_ERR;
		bResult = false;
	}
	if ((document.getElementById(src_ctl).value == "") && (document.getElementById(src_type_url_ctl).checked === true))	{
		document.getElementById(src_ctl).className = "long_txt_field highlight";
		document.getElementById(src_ctl).focus();
		popup_msg.status_msg = MANAGE_FONTS_NO_URL_ERR;
		bResult = false;
	}
	if (bResult != true)	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 4000;
		popup_msg.ShowPopupMsg();
	}
	return bResult;
}

function UpdateFont(i)
{
	if (update_all)
	{
		UpdateAll();
		return;
	}

	var font_ctl = "font" + i;
	var src_ctl = "src" + i;
	var src_type_upload_ctl = "src_type_upload" + i;
	var src_type_url_ctl = "src_type_url" + i;
	var stretch_ctl = "stretch" + i;
	var style_ctl = "style" + i;
	var weight_ctl = "weight" + i;

	unsaved_new_item = false;

	var font = document.getElementById(font_ctl).value;
	var src = document.getElementById(src_ctl).value;
	var stretch = document.getElementById(stretch_ctl).value;
	var style = document.getElementById(style_ctl).value;
	var weight = document.getElementById(weight_ctl).value;

	var src_type;
	if (document.getElementById(src_type_upload_ctl).checked)
		src_type = "upload";
	else
		src_type = "url";
	
	var ready = ValidateForm(i);

	if (ready == true)	{
		$.post( "save_font.php", { font: font, src: src, src_type: src_type, stretch: stretch, style: style, weight: weight } ).done(CompleteSaveFont) ;
	}
}
function CompleteSaveFont(response)
{
//alert(response);
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (response > 0)	{
		popup_msg.status_msg = MANAGE_FONTS_FONT_SAVED_MSG;
		var code = "RetrieveFonts();";
		setTimeout(code, 3010);
	}
	else
		popup_msg.status_msg = MANAGE_FONTS_ERROR_SAVING_FONT_ERR;
	popup_msg.ShowPopupMsg();
}

function UpdateAll()
{
	var cnt = parseInt(document.getElementById("nCount").value);
	for (var i = 0; i < cnt; i++)	{
		UpdateFont(i);
	}
}

////////////////////////////////////////////////////////////////////////////////////
function AddFont()
{
	if (unsaved_new_item === true)	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = MANAGE_FONTS_ADD_BEFORE_SAVE_NEW_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.ShowPopupMsg();
		return;
	}

//	update_all = true;
	if (self != top)
		window.parent.SetWorkSavedNotSaved(false);
	unsaved_new_item = true;

	var html = document.getElementById("FontsTable").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var i = cnt;
	var srch_str;
	
	if ((browser == "Explorer") && (browser_version < 9))
		srch_str = "</TABLE>";
	else
		srch_str = "</table>";

	var html_arr = new Array();
	html_arr = html.split(srch_str);
	var html_top = html_arr[0];
	var html_bottom = html.substring(html_top.length);

	var bgclr = "#FFFF99";

	var new_row = new_row + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
		
	new_row = new_row + "<td valign='top'><input type='text' name='font" + i + "' id='font" + i + "' value='' onchange=\"SetElementValue('font" + i + "', -1);\" onmouseout=\"SetElementVal('font" + i + "');\" onkeypress=\"SetCurrentItem('font" + i + "', -1);\" class='med_txt_field' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	upload_checked = " checked='checked'";
	url_checked = "";
	upload_visible = "";
	url_visible = " style='display:none;'";

	new_row = new_row + "<form id='uploadForm" + i + "' enctype='multipart/form-data' method='post' action='upload_font.php'>\n";
	new_row = new_row + "<input type='file' name='file_browse" + i + "' id='file_browse" + i + "'" + upload_visible + " onChange=\"UploadFont(" + i + ");\" class='file_browse' />\n";
	new_row = new_row + "</form>\n";
	
	new_row = new_row + "<input type='text' value='' name='src" + i + "' id='src" + i + "' onchange=\"SetElementValue('src" + i + "', -1);\" onmouseout=\"SetElementVal('src" + i + "');\" onkeypress=\"SetCurrentItem('src" + i + "', -1);\" class='long_txt_field'" + url_visible + " /><\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<input type='radio' name='src_type" + i + "' id='src_type_upload" + i + "' value='upload'" + upload_checked + " onClick=\"ShowHideFileBrowse('upload', " + i + ");\" /> " + EDIT_FAVICON_UPLOAD_BTN + "<br />\n";
	new_row = new_row + "<input type='radio' name='src_type" + i + "' id='src_type_url" + i + "' value='url'" + url_checked + " onClick=\"ShowHideFileBrowse('url', " + i + ");\" /> " + EDIT_MENU_ITEMS_URL + "\n";
	new_row = new_row + "</td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='stretch" + i + "' id='stretch" + i + "'>\n";
	new_row = new_row + "<option value=''";
	new_row = new_row + " selected='selected'";
	new_row = new_row + ">" + _NOT_SELECTED_ + "<\/option>\n";
	
	new_row = new_row + "<option value='normal'";
	new_row = new_row + ">" + NORMAL_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='condensed'";
	new_row = new_row + ">" + CONDENSED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='ultra-condensed'";
	new_row = new_row + ">" + ULTRA_CONDENSED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='extra-condensed'";
	new_row = new_row + ">" + EXTRA_CONDENSED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='semi-condensed'";
	new_row = new_row + ">" + SEMI_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='expanded'";
	new_row = new_row + ">" + EXPANDED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='semi-expanded'";
	new_row = new_row + ">" + SEMI_EXPANDED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='extra-expanded'";
	new_row = new_row + ">" + EXTRA_EXPANDED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='ultra-expanded'";
	new_row = new_row + ">" + ULTRA_EXPANDED_WORD + "<\/option>\n";
	new_row = new_row + "<\/select>\n</td>\n";
	
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='style" + i + "' id='style" + i + "'>\n";
	new_row = new_row + "<option value=''";
	new_row = new_row + " selected='selected'";
	new_row = new_row + ">" + _NOT_SELECTED_ + "<\/option>\n";
	
	new_row = new_row + "<option value='normal'";
	new_row = new_row + ">" + NORMAL_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='italic'";
	new_row = new_row + ">" + ITALIC_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='oblique'";
	new_row = new_row + ">" + OBLIQUE_WORD + "<\/option>\n";
	new_row = new_row + "<\/select>\n</td>\n";
	
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='weight" + i + "' id='weight" + i + "'>\n";
	new_row = new_row + "<option value=''";
	new_row = new_row + ">" + _NOT_SELECTED_ + "<\/option>\n";
	
	new_row = new_row + "<option value='normal'";
	new_row = new_row + ">" + NORMAL_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='bold'";
	new_row = new_row + ">" + BOLD_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='100'";
	new_row = new_row + ">100<\/option>\n";
	
	new_row = new_row + "<option value='200'";
	new_row = new_row + ">200<\/option>\n";
	
	new_row = new_row + "<option value='300'";
	new_row = new_row + ">300<\/option>\n";
	
	new_row = new_row + "<option value='400'";
	new_row = new_row + ">400<\/option>\n";
	
	new_row = new_row + "<option value='500'";
	new_row = new_row + ">500<\/option>\n";
	
	new_row = new_row + "<option value='600'";
	new_row = new_row + ">600<\/option>\n";
	
	new_row = new_row + "<option value='700'";
	new_row = new_row + ">700<\/option>\n";
	
	new_row = new_row + "<option value='800'";
	new_row = new_row + ">800<\/option>\n";
	
	new_row = new_row + "<option value='900'";
	new_row = new_row + ">900<\/option>\n";
	new_row = new_row + "<\/select>\n</td>\n";

	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateFont(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm(" + i + ", '-new font-');\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<\/tr>\n";

	
	html = html_top + new_row + html_bottom;
	document.getElementById("FontsTable").innerHTML = html;
	cnt++;
	document.getElementById("nCount").value = cnt;
	
}

////////////////////////////////////////////////////////////////////////////////////
function RetrieveFonts()
{
	$.post( "get_rows.php", { table: "fonts", where: "websafe <> 1", order_by: "font", no_prefix: 0 } ).done(PopulateTable) ;
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateTable(rows_str)
{
//alert(rows_str);
	var rows = new Array();
	var fields = new Array();
	var bgclr, upload_checked, url_checked, upload_visible, url_visible, src_upload, src_url;
	
	var output_str = "<table width='90%' align='center'>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td class='header_row'><b>" + FONT_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + SOURCE_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + COPY_STYLE_TO_MOBILE_SOURCE_TYPE + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_CUSTOM_FONTS_STRETCH + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_CUSTOM_FONTS_STYLE + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_CUSTOM_FONTS_WEIGHT + "<\/b><\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")
		var i = 0;
	else
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			if (bgclr == "#dddddd")
				bgclr = "#eeeeee";
			else
				bgclr = "#dddddd";
				
			output_str = output_str + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
				
			output_str = output_str + "<td valign='top'><input type='text' name='font" + i + "' id='font" + i + "' value='" + JSON_row.font + "' onchange=\"SetElementValue('font" + i + "', -1);\" onmouseout=\"SetElementVal('font" + i + "');\" onkeypress=\"SetCurrentItem('font" + i + "', -1);\" class='med_txt_field' style='font-family:" + JSON_row.font + "' />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			upload_checked = " checked='checked'";
			url_checked = "";
			upload_visible = "";
			src_visible = "";
			if (JSON_row.src == "")
				src_visible = " style='display:none;'";
			if (JSON_row.src.indexOf("http", 0) == 0)	{
				upload_checked = "";
				url_checked = " checked='checked'";
				upload_visible = " style='display:none;'";
				src_visible = "";
			}
			
			output_str = output_str + "<form id='uploadForm" + i + "' enctype='multipart/form-data' method='post' action='upload_font.php'>\n";
			output_str = output_str + "<input type='file' name='file_browse" + i + "' id='file_browse" + i + "'" + upload_visible + " onChange=\"UploadFont(" + i + ");\" class='file_browse' />\n";
			output_str = output_str + "</form>\n";

			output_str = output_str + "<input type='text' value='" + JSON_row.src + "' name='src" + i + "' id='src" + i + "' onchange=\"SetElementValue('src" + i + "', -1);\" onmouseout=\"SetElementVal('src" + i + "');\" onkeypress=\"SetCurrentItem('src" + i + "', -1);\" class='long_txt_field'" + src_visible + " /><\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<input type='radio' name='src_type" + i + "' id='src_type_upload" + i + "' value='upload'" + upload_checked + " onClick=\"ShowHideFileBrowse('upload', " + i + ");\" /> " + EDIT_FAVICON_UPLOAD_BTN + "<br />\n";
			output_str = output_str + "<input type='radio' name='src_type" + i + "' id='src_type_url" + i + "' value='url'" + url_checked + " onClick=\"ShowHideFileBrowse('url', " + i + ");\" /> " + EDIT_MENU_ITEMS_URL + "\n";
			output_str = output_str + "</td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='stretch" + i + "' id='stretch" + i + "'>\n";
			output_str = output_str + "<option value=''";
			if (JSON_row.stretch == "")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + _NOT_SELECTED_ + "<\/option>\n";
			
			output_str = output_str + "<option value='normal'";
			if (JSON_row.stretch == "normal")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + NORMAL_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='condensed'";
			if (JSON_row.stretch == "condensed")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + CONDENSED_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='ultra-condensed'";
			if (JSON_row.stretch == "ultra-condensed")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + ULTRA_CONDENSED_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='extra-condensed'";
			if (JSON_row.stretch == "extra-condensed")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + EXTRA_CONDENSED_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='semi-condensed'";
			if (JSON_row.stretch == "semi-condensed")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + SEMI_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='expanded'";
			if (JSON_row.stretch == "expanded")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + EXPANDED_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='semi-expanded'";
			if (JSON_row.stretch == "semi-expanded")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + SEMI_EXPANDED_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='extra-expanded'";
			if (JSON_row.stretch == "extra-expanded")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + EXTRA_EXPANDED_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='ultra-expanded'";
			if (JSON_row.stretch == "ultra-expanded")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + ULTRA_EXPANDED_WORD + "<\/option>\n";
			output_str = output_str + "<\/select>\n</td>\n";
			
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='style" + i + "' id='style" + i + "'>\n";
			output_str = output_str + "<option value=''";
			if (JSON_row.style == "")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + _NOT_SELECTED_ + "<\/option>\n";
			
			output_str = output_str + "<option value='normal'";
			if (JSON_row.style == "normal")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + NORMAL_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='italic'";
			if (JSON_row.style == "italic")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + ITALIC_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='oblique'";
			if (JSON_row.style == "oblique")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + OBLIQUE_WORD + "<\/option>\n";
			output_str = output_str + "<\/select>\n</td>\n";
			
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='weight" + i + "' id='weight" + i + "'>\n";
			output_str = output_str + "<option value=''";
			if (JSON_row.weight == "")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + _NOT_SELECTED_ + "<\/option>\n";
			
			output_str = output_str + "<option value='normal'";
			if (JSON_row.weight == "normal")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + NORMAL_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='bold'";
			if (JSON_row.weight == "bold")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">" + BOLD_WORD + "<\/option>\n";
			
			output_str = output_str + "<option value='100'";
			if (JSON_row.weight == "100")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">100<\/option>\n";
			
			output_str = output_str + "<option value='200'";
			if (JSON_row.weight == "200")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">200<\/option>\n";
			
			output_str = output_str + "<option value='300'";
			if (JSON_row.weight == "300")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">300<\/option>\n";
			
			output_str = output_str + "<option value='400'";
			if (JSON_row.weight == "400")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">400<\/option>\n";
			
			output_str = output_str + "<option value='500'";
			if (JSON_row.weight == "500")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">500<\/option>\n";
			
			output_str = output_str + "<option value='600'";
			if (JSON_row.weight == "600")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">600<\/option>\n";
			
			output_str = output_str + "<option value='700'";
			if (JSON_row.weight == "700")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">700<\/option>\n";
			
			output_str = output_str + "<option value='800'";
			if (JSON_row.weight == "800")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">800<\/option>\n";
			
			output_str = output_str + "<option value='900'";
			if (JSON_row.weight == "900")
				output_str = output_str + " selected='selected'";
			output_str = output_str + ">900<\/option>\n";
			output_str = output_str + "<\/select>\n</td>\n";
		
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateFont(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm(" + i + ", '');\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<\/tr>\n";
		}
		i++;
	}

	output_str = output_str + "<\/table>\n";
	
	document.getElementById("FontsTable").innerHTML = output_str;
	document.getElementById("nCount").value = i;
	
}

///////////////////////////////////////////////////////////////////////////////////
function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDIT_MENU_ITEMS_NOT_SAVED_CONFIRM_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	UpdateAll();
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	if (self != top)	{
		window.parent.SetWorkSavedNotSaved(true);
		window.parent.DoNextClick();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function SetElementValue(el_id, el_id_2)
{
	var html = document.getElementById("LinksTable").innerHTML;

	if (el_id != -1)	{
		var val = document.getElementById(el_id).value;
		var srch = "id=\"" + el_id;
		var pos1 = html.indexOf(srch, 0);
		if (pos1 == -1)	{
			srch = "id='" + el_id;
			pos1 = html.indexOf(srch, 0);
		}
		srch = "value=";
		var pos2 = html.indexOf(srch, pos1);
		srch = "\"";
		var pos3 = html.indexOf(srch, pos2);
		if (pos3 == -1)	{	// In case browser replaced single quotes with double quotes.
			srch = "'";
			pos3 = html.indexOf(srch, pos2);
		}
		var pos4 = html.indexOf(srch, pos3 + 1);
		var html_start = html.substr(0, pos2);
		var html_end = html.substr(pos4 + 1);
		html = html_start + "value='" + val + "'" + html_end;
	}

	if (el_id_2 != -1)	{
		var val = document.getElementById(el_id_2).value;
		var srch = "id=\"" + el_id_2;
		var pos1 = html.indexOf(srch, 0);
		if (pos1 == -1)	{
			srch = "id='" + el_id_2;
			pos1 = html.indexOf(srch, 0);
		}
		// Get position of next id to compare in case nothing is selected.
		srch = "id=";
		var pos5 = html.indexOf(srch, pos1 + 1);
		// First remove selected option.
		srch = "selected="
		var pos2 = html.indexOf(srch, pos1);
		if ((pos2 < pos5) && (pos2 > -1))	{	// If not true, then nothing selected.
			var html_start = html.substr(0, pos2);
			var html_end = html.substr(pos2 + 19);
			html = html_start + html_end;
		}
		// Now go ahead and insert selected option.
		srch = "value=\"" + val;
		pos2 = html.indexOf(srch, pos1);
		if (pos2 == -1)	{	// In case browser replaced single quotes with double quotes.
			srch = "value='" + val;
			pos2 = html.indexOf(srch, pos1);
		}
		srch = "\"";
		var pos3 = html.indexOf(srch, pos2 + 7);
		if (pos3 == -1)	{
			srch = "'";
			pos3 = html.indexOf(srch, pos2);
		}
		srch = ">"
		var pos4 = html.indexOf(srch, pos3);
		html_start = html.substr(0, pos3 + 1);
		html_end = html.substr(pos4);
		html = html_start + " selected='selected'" + html_end;
	}
	
	document.getElementById("LinksTable").innerHTML = html;

	curr_item_under_edit = "";
}

function SetElementVal(el_id)
{
	if (el_id == curr_item_under_edit)	{
		SetElementValue(el_id, -1);
	}
}

function SetCurrentItem(el_id)
{
	curr_item_under_edit = el_id;
}

function RunPostAjaxUploadScript()
{
	
}


function ShowHideFileBrowse(mode, i)
{
	var file_browse_el = "file_browse" + i;
	var src_el = "src" + i;
	if (mode == "upload")	{
		document.getElementById(file_browse_el).style.display = "initial";
		if ((document.getElementById(src_el).value == "") || (document.getElementById(src_el).value.indexOf("http", 0) == 0))
			document.getElementById(src_el).style.display = "none";
		else
			document.getElementById(src_el).style.display = "initial";
	}
	else	{
		document.getElementById(file_browse_el).style.display = "none";
		document.getElementById(src_el).style.display = "initial";
	}
}

function UploadFont(i)
{
	var file_browse_ctl = "file_browse" + i;
	var src_ctl = "src" + i;
	var xhr = new XMLHttpRequest();
	
	var file_name = document.getElementById(file_browse_ctl).value;
	var file_parts = file_name.split(".");
	var file_ext = file_parts[file_parts.length - 1];
	file_ext = file_ext.toLowerCase();
	if ((file_ext != "ttf") && (file_ext != "otf") && (file_ext != "woff") && (file_ext != "woff2") && (file_ext != "svg")  && (file_ext != "eot")) {
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 5000;
		popup_msg.status_msg = MANAGE_CUSTOM_FONTS_ADDING_FONT_FILE_TYPE_ERR;
		popup_msg.ShowPopupMsg();
		return;
	}
	
	var path_parts = file_name.split("\\");
	var file_path = fonts_dir + path_parts[path_parts.length - 1];
	document.getElementById(src_ctl).value = file_path;

	var form_data = new FormData();
	form_data.append(file_browse_ctl, document.getElementById(file_browse_ctl).files[0]);
	form_data.append("file_browse_name", "file_browse" + i);
  /* event listners */
  xhr.upload.addEventListener("progress", uploadProgress, false);
  xhr.addEventListener("load", uploadComplete, false);
  xhr.addEventListener("error", uploadFailed, false);
  xhr.addEventListener("abort", uploadCanceled, false);

	xhr.open("POST", "upload_font.php", true);
	xhr.send(form_data);
}

function uploadProgress(evt) {
  if (evt.lengthComputable) {
    var percentComplete = Math.round(evt.loaded * 100 / evt.total);
    document.getElementById('progressNumber').innerHTML = percentComplete.toString() + '%';
  }
  else {
    document.getElementById('progressNumber').innerHTML = 'unable to compute';
  }
}

function uploadComplete(evt) {
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (evt.target.responseText != "")
		popup_msg.status_msg = evt.target.responseText;
	else
		popup_msg.status_msg = MANAGE_FONTS_FONT_UPLOADED_MSG;
	popup_msg.ShowPopupMsg();
}

function uploadFailed(evt) {
  	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	popup_msg.status_msg = MANAGE_FONTS_FONT_UPLOAD_ERR;
	popup_msg.ShowPopupMsg();
}

function uploadCanceled(evt) {
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	popup_msg.status_msg = MANAGE_FONTS_FONT_UPLOAD_CANCEL_MSG;
	popup_msg.ShowPopupMsg();
}  

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {
}