<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2014	ELL
// Revised: 6/16/2014	ELL
// Added storing of plugin ID's into page data to facilitate content sensitive help for relevant plugins in page editor.
// Revised: 1/12/2015	ELL
// Fixed bug with single quotes in plugin HTML doubling up in border areas and content.
// 

include ("check_session.php");
		
$page_name = $_POST['page_name'];
$plugin = $_POST['plugin'];

////////////////////////////////////////////////////////////////////////////////////////////////
function copy_table_structure($table, $table_prefix, $dbh, $database)
{
	$query = "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '" . $database . "' AND table_name = '" . $table_prefix . $table . "'";
	$result = $dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$table_count = $row['COUNT(*)'];
	if ($table_count < 1)
	{
		// Must be a missing menu table, find suffix.
		if (strpos($table, "_classes") > 0)
			$source_table = $table_prefix . "site_classes";
		else
			$source_table = $table_prefix . "site_css";
		$query = "CREATE TABLE IF NOT EXISTS " . $table_prefix . $table . " SELECT * FROM " . $source_table;
		$cnt = $dbh->exec($query);
		
		$query = " ALTER TABLE `" . $table_prefix . $table . "` ADD PRIMARY KEY (`class`)";
		$cnt = $dbh->exec($query);
	}
	
	$query = "TRUNCATE TABLE `" . $table_prefix . $table . "`";
	$cnt = $dbh->exec($query);
		
	return "";
}
	
///////////////////////////////////////////////////////////////////////////////
function RunSQL($sql_string, $table_prefix, $dbh)
{
	$sql_string = stripslashes($sql_string);
	$sql_string_arr = array();
	$line_arr = array();
	// Split SQL input into lines.
	$line_arr = preg_split("[\n|\r]", $sql_string);
	$sql_string_arr[0] = "";
	$j = 0;
	$find_start = true;
	$got_script = false;
	$got_php = false;
	$got_style = false;
	// Search for commands and assemble into SQL command array.
	for ($i = 0; $i < count($line_arr); $i++)
	{
		// Test for comment line.
		$curr_line = trim($line_arr[$i]);
		if ($find_start)
		{
			$first_chars = substr($curr_line, 0, 2);
			if (($first_chars == "--") || ($first_chars == "//"))
				continue;
		}
		$find_start = false;
		
		// It is possible for a line to end with a semicolon (;) if records contain JavaScript or PHP.  Need to turn off looking end of SQL command
		// if script or PHP is found until end of script or PHP is also found.  Otherwise we run the risk of trying to run only part of a record insert
		// which usually results in an SQL syntax error.
		if (!$got_script)
		{
			if (stripos($curr_line, "<script") !== false)
				$got_script = true;
		}
		if ($got_script)
		{
			if (stripos($curr_line, "</script>") !== false)
				$got_script = false;
		}
		
		if (!$got_php)
		{
			if (stripos($curr_line, "<?php") !== false)
				$got_php = true;
		}
		if ($got_php)
		{
			if (stripos($curr_line, "?>") !== false)
				$got_php = false;
		}
		
		if (!$got_style)
		{
			if (stripos($curr_line, "<style") !== false)
				$got_style = true;
		}
		if ($got_style)
		{
			if (stripos($curr_line, "</style>") !== false)
				$got_style = false;
		}
		
		// Build SQL command.
		$sql_string_arr[$j] = $sql_string_arr[$j] . $line_arr[$i];
		
		// Look for end of command.
		if ((!$got_script) && (!$got_php) && (!$got_style))
		{
			$last_char = substr($curr_line, (strlen($curr_line) - 1), 1);
			if ($last_char == ";")	// Got end of SQL command.
			{
				// Check for other possible reasons that ; is at end of line.
				$last_6_chars = substr($curr_line, (strlen($curr_line) - 7), 6);
				if (stripos($curr_line, "&") === false) // Looks like ; is not do to & code, good to go.
				{
					$j++;
					$sql_string_arr[$j] = "";
					$find_start = true;
				}
			}
		}
	}
	// Run SQL commands one at a time.
	for ($i = 0; $i < count($sql_string_arr); $i++)
	{
		if (strlen($sql_string_arr[$i]) > 2)
		{
			if ($table_prefix != "bwb_")
			{
				$sql_string_arr[$i] = str_replace("bwb_link", "@@@link_retention@@@", $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("bwb_", $table_prefix, $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("@@@link_retention@@@", "bwb_link", $sql_string_arr[$i]);
			}
//			echo $sql_string_arr[$i] . "<br><br>\n";

			try	{
				$cnt = $dbh->exec($sql_string_arr[$i]);
			} catch (Exception $e) {
				echo $e->getMessage() . "<br>\n";
			}
			
//			if (is_array($cnt))
//			{
//				echo "<pre>\n";
//				print_r($cnt);
//				echo "</pre>\n";
//			}
//			elseif ($cnt > 0)
//				echo $cnt . " row(s) affected.<br>\n";
//			else
//				echo $bwb_dbh->errorInfo() . "<br>\n";
				
//			if ($i < (count($sql_string_arr) - 1))
//				echo "<br>-------------------------------------------------------------------------------<br>\n";
		}
	}
}

///////////////////////////////////////////////////////////////////////////////

	if (($page_name == "-not selected-") || ($plugin == "-not selected-") || ($page_name == "") || ($plugin == ""))
	{
		echo "Oops! You forgot to select a page and/or a plugin.  Click <a href=\"add_plugin_to_page_select.php\" title=\"here\">here</a> and select a page and a plugin.";
		exit;
	}
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `id` = $plugin";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$plugin_id = $row["id"];
	$plugin_name = $row["name"];
	$head_code = $row["head_code"];
	$head_html = $row["head_html"];
	$header_code = $row["header_code"];
	$header_html = $row["header_html"];
	$top_code = $row["top_code"];
	$top_html = $row["top_html"];
	$left_code = $row["left_code"];
	$left_html = $row["left_html"];
	$content_code = $row["content_code"];
	$content_html = $row["content_html"];
	$right_code = $row["right_code"];
	$right_html = $row["right_html"];
	$bottom_code = $row["bottom_code"];
	$bottom_html = $row["bottom_html"];
	$footer_code = $row["footer_code"];
	$footer_html = $row["footer_html"];
	$style_sheet = $row["style_sheet"];
	$style_sheet_description = $row["style_sheet_description"];
	$class_sql = $row["class_sql"];
	$css_sql = $row["css_sql"];
	$plugin_sql = $row["plugin_sql"];
	$deployed = $row["deployed"];
	
	//Get page content from database.
	$today = date("Y-m-d H:i:s");
	$query = "SELECT `page_content`, `plugins` FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='$page_name'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$page_content = addslashes(stripslashes($row["page_content"]));
	$existing_plugins = $row["plugins"];
	$page_content .= "\n\n" . addslashes(stripslashes($content_html));
	
	if ((isset($existing_plugins)) && ($existing_plugins != ""))
		$plugin_ids = $existing_plugins . "," . $plugin_id;
	else
		$plugin_ids = $plugin_id;
	
	//Update page content in database.
	$today = date("Y-m-d H:i:s");
	$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data SET page_content='$page_content', revised='$today', plugins='$plugin_ids' WHERE page_name='$page_name'";
//	echo $query;
	$cnt = $bwb_dbh->exec($query);

// Copy page data to draft table.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name='$page_name'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() < 1)
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_draft SET page_name='$page_name', page_content='$page_content', revised='$today', `source`=0";
	else
		$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_draft SET page_content='$page_content', revised='$today', `source`=0 WHERE page_name='$page_name'";
//	echo $query;
	$cnt = $bwb_dbh->exec($query);
	
	
	///////////////////////////////////////////////////////////////////////////////////////
	// Get page file content.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$file_name = $document_root . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
	else
		$file_name = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
//	echo "File Name: $file_name<br>";
	if (file_exists($file_name))
	{
		if (!($fh = fopen($file_name, 'r'))) {
			echo "Error opening page file.  Please contact your system administrator.  Click <a href=\"add_plugin_to_page_select.php\" title=\"here\">here</a> to return to the insert-plugin-into-page console.\n$php_errormsg";
			exit;
		}
		
		$contents = (fread($fh, filesize($file_name)));
		
		if (!fclose($fh)) {
			echo "Error closing page file.  Please contact your system administrator.  Click <a href=\"add_plugin_to_page_select.php\" title=\"here\">here</a> to return to the insert-plugin-into-page console.\n$php_errormsg";
			exit;
		}
	}
		
	//If plugin is selected, then insert head code snippet after <!--head_code--> comment.
	if (($plugin != "-not selected-") && ($head_code != ""))
	{
		$page_temp_arr = explode("<!--head_code-->", $contents, 2);
		$contents = $page_temp_arr[0] . $head_code . "\n\n<!--head_code-->\n" . $page_temp_arr[1];
		unset($page_temp_arr);
	}
	
	//If plugin is selected, then insert content code snippet after <!--content_code--> comment.
	if (($plugin != "-not selected-") && ($content_code != ""))
	{
		$page_temp_arr = explode("<!--content_code-->", $contents, 2);
		$contents = $page_temp_arr[0] . $content_code . "\n\n<!--content_code-->\n" . $page_temp_arr[1];
		unset($page_temp_arr);
	}
		
	//If plugin is selected, then insert header code snippet after <!--header_code--> comment. (not to be confused with head)
	if (($plugin != "-not selected-") && ($header_code != ""))
	{
		$page_temp_arr = explode("<!--header_code-->", $contents, 2);
		$contents = $page_temp_arr[0] . $header_code . "\n\n<!--header_code-->\n" . $page_temp_arr[1];
		unset($page_temp_arr);
	}
		
	//If plugin is selected, then insert footer code snippet after <!--footer_code--> comment.
	if (($plugin != "-not selected-") && ($footer_code != ""))
	{
		$page_temp_arr = explode("<!--footer_code-->", $contents, 2);
		$contents = $page_temp_arr[0] . $footer_code . "\n\n<!--footer_code-->\n" . $page_temp_arr[1];
		unset($page_temp_arr);
	}

	//If plugin is selected, then insert top code snippet after <!--top_code--> comment.
	if (($plugin != "-not selected-") && ($top_code != ""))
	{
		if (strpos($page_template, "<!--top_code-->") > 0)
		{
			$page_temp_arr = explode("<!--top_code-->", $contents, 2);
			$contents = $page_temp_arr[0] . $top_code . "\n\n<!--top_code-->\n" . $page_temp_arr[1];
			unset($page_temp_arr);
		}
	}
	
	//If plugin is selected, then insert left code snippet after <!--left_code--> comment.
	if (($plugin != "-not selected-") && ($left_code != ""))
	{
		if (strpos($page_template, "<!--left_code-->") > 0)
		{
			$page_temp_arr = explode("<!--left_code-->", $contents, 2);
			$contents = $page_temp_arr[0] . $left_code . "\n\n<!--left_code-->\n" . $page_temp_arr[1];
			unset($page_temp_arr);
		}
	}
	
	//If plugin is selected, then insert right code snippet after <!--right_code--> comment.
	if (($plugin != "-not selected-") && ($right_code != ""))
	{
		if (strpos($page_template, "<!--right_code-->") > 0)
		{
			$page_temp_arr = explode("<!--right_code-->", $contents, 2);
			$contents = $page_temp_arr[0] . $right_code . "\n\n<!--right_code-->\n" . $page_temp_arr[1];
			unset($page_temp_arr);
		}
	}
	
	//If plugin is selected, then insert bottom code snippet after <!--bottom_code--> comment.
	if (($plugin != "-not selected-") && ($bottom_code != ""))
	{
		if (strpos($page_template, "<!--bottom_code-->") > 0)
		{
			$page_temp_arr = explode("<!--bottom_code-->", $contents, 2);
			$contents = $page_temp_arr[0] . $bottom_code . "\n\n<!--bottom_code-->\n" . $page_temp_arr[1];
			unset($page_temp_arr);
		}
	}
	
	if (!($fh = fopen($file_name, 'w'))) {
		echo "Error opening page file.  Please contact your system administrator.  Click <a href=\"add_plugin_to_page_select.php\" title=\"here\">here</a> to return to the insert-plugin-into-page console.\n$php_errormsg";
		exit;
	}
	if (!fwrite($fh, $contents)) {
		echo "Error updating page file.  Please contact your system administrator.  Click <a href=\"add_plugin_to_page_select.php\" title=\"here\">here</a> to return to the insert-plugin-into-page console.\n$php_errormsg";
		exit;
	}
	if (!fclose($fh)) {
		echo "Error closing page file.  Please contact your system administrator.  Click <a href=\"add_plugin_to_page_select.php\" title=\"here\">here</a> to return to the insert-plugin-into-page console.\n$php_errormsg";
		exit;
	}
	@chmod($file_name, 0644);
	
	
	/////////////////////////////////////////////////////////////////////////////////////////
	$search_str_head = "head_name='head";
	$search_str_right = "page_name='right";
	$search_str_left = "page_name='left";
	$search_str_top = "page_name='top";
	$search_str_bottom = "page_name='bottom";
	$search_str_header = "page_name='header";
	$search_str_footer = "page_name='footer";
		
	$start_pos = strpos($contents, $search_str_head, 1);
	$end_pos = strpos($contents, "\"", $start_pos) - 1;
	$start_pos = $start_pos + strlen("head_name='");
	$head_str = substr($contents, $start_pos, $end_pos - $start_pos);

	$start_pos = strpos($contents, $search_str_right, 1);
	if ($start_pos !== false)
	{
		$end_pos = strpos($contents, "\"", $start_pos) - 1;
		$start_pos = $start_pos + strlen("page_name='");
		$right_str = substr($contents, $start_pos, $end_pos - $start_pos);
	}
	else
		$right_str = "-na-";
	
	$start_pos = strpos($contents, $search_str_left, 1);
	if ($start_pos !== false)
	{
		$end_pos = strpos($contents, "\"", $start_pos) - 1;
		$start_pos = $start_pos + strlen("page_name='");
		$left_str = substr($contents, $start_pos, $end_pos - $start_pos);
	}
	else
		$left_str = "-na-";
	
	$start_pos = strpos($contents, $search_str_top, 1);
	if ($start_pos !== false)
	{
		$end_pos = strpos($contents, "\"", $start_pos) - 1;
		$start_pos = $start_pos + strlen("page_name='");
		$top_str = substr($contents, $start_pos, $end_pos - $start_pos);
	}
	else
		$top_str = "-na-";
	
	$start_pos = strpos($contents, $search_str_bottom, 1);
	if ($start_pos !== false)
	{
		$end_pos = strpos($contents, "\"", $start_pos) - 1;
		$start_pos = $start_pos + strlen("page_name='");
		$bottom_str = substr($contents, $start_pos, $end_pos - $start_pos);
	}
	else
		$bottom_str = "-na-";
		
	$start_pos = strpos($contents, $search_str_header, 1);
	if ($start_pos !== false)
	{
		$end_pos = strpos($contents, "\"", $start_pos) - 1;
		$start_pos = $start_pos + strlen("page_name='");
		$header_str = substr($contents, $start_pos, $end_pos - $start_pos);
	}
	else
		$header_str = "-na-";
		
	$start_pos = strpos($contents, $search_str_footer, 1);
	if ($start_pos !== false)
	{
		$end_pos = strpos($contents, "\"", $start_pos) - 1;
		$start_pos = $start_pos + strlen("page_name='");
		$footer_str = substr($contents, $start_pos, $end_pos - $start_pos);
	}
	else
		$footer_str = "-na-";


	/////////////////////////////////////////////////////////////////////////////////////////
	// If plugin is selected, then replace HTML head holder with head code snippet.
	if (($plugin != "-not selected-") && (isset($head_html)) && ($head_html != ""))
	{
		// Get head content from main head.  Most likely that we want this as default.  Can edit later.
		$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name = '" . $head_str . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$head_content = $row["head_content"];
		
		// Combine HTML (Javascript) code with default head content.
		$head_content = $head_content . "\n\n\n" . $head_html;
		$head_content = addslashes(stripslashes($head_content));
		
		// Insert new head into table.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "head SET head_content = '" . $head_content . "', `revised` = '" . $today . "', plugins = '" . $plugin_ids . "' WHERE head_name = '" . $head_str . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	//If plugin is selected, then replace HTML header holder with header HTML code snippet.
	if (($plugin != "-not selected-") && (isset($header_html)) && ($header_html != "") && ($header_str != "-na-"))
	{	
		// Get header content from main header.  Most likely that we want this as default.  Can edit later.
		$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $header_str . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$header_content = $row["page_content"];
		
		// Combine HTML (Javascript) code with default header content.
		$header_content = $header_content . "\n\n\n" . $header_html;
		$header_content = addslashes(stripslashes($header_content));
		
		// Insert new header into table.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_content = '" . $header_content . "', `revised` = '" . $today . "', plugins = '" . $plugin_ids . "' WHERE page_name = '" . $header_str . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	//If plugin is selected, then replace HTML footer holder with footer HTML code snippet.
	if (($plugin != "-not selected-") && (isset($footer_html)) && ($footer_html != "") && ($footer_str != "-na-"))
	{
		// Get footer content from main footer.  Most likely that we want this as default.  Can edit later.
		$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $footer_str . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$footer_content = $row["page_content"];
		
		// Combine HTML (Javascript) code with default footer content.
		$footer_content = $footer_content . "\n\n\n" . $footer_html;
		$footer_content = addslashes(stripslashes($footer_content));
		
		// Insert new footer into table.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_content = '" . $footer_content . "', `revised` = '" . $today . "', plugins = '" . $plugin_ids . "' WHERE page_name = '" . $footer_str . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	//If plugin is selected, then append HTML code snippet to top.
	if (($plugin != "-not selected-") && (isset($top_html)) && ($top_html != "") && ($top_str != "-na-"))
	{
		// Get footer content from main footer.  Most likely that we want this as default.  Can edit later.
		$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $top_str . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$top_content = $row["page_content"];
		
		// Combine HTML (Javascript) code with default top content.
		$top_content = $top_content . "\n\n\n" . $top_html;
		$top_content = addslashes(stripslashes($top_content));
		
		// Insert new top into table.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_content = '" . $top_content . "', `revised` = '" . $today . "', plugins = '" . $plugin_ids . "' WHERE page_name = '" . $top_str . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	//If plugin is selected, then append HTML code snippet to left.
	if (($plugin != "-not selected-") && (isset($left_html)) && ($left_html != "") && ($left_str = "-na-"))
	{
		// Get footer content from main footer.  Most likely that we want this as default.  Can edit later.
		$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $left_str . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$left_content = $row["page_content"];
		
		// Combine HTML (Javascript) code with default left content.
		$left_content = $left_content . "\n\n\n" . $left_html;
		$left_content = addslashes(stripslashes($left_content));
		
		// Insert new top into table.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_content = '" . $left_content . "', `revised` = '" . $today . "', plugins = '" . $plugin_ids . "' WHERE page_name = '" . $left_str . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	//If plugin is selected, then append HTML code snippet to right.
	if (($plugin != "-not selected-") && (isset($right_html)) && ($right_html != "") && ($right_str != "-na-"))
	{
		// Get footer content from main footer.  Most likely that we want this as default.  Can edit later.
		$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $right_str . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$right_content = $row["page_content"];
		
		// Combine HTML (Javascript) code with default right content.
		$right_content = $right_content . "\n\n\n" . $right_html;
		$right_content = addslashes(stripslashes($right_content));
		
		// Insert new top into table.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_content = '" . $right_content . "', `revised` = '" . $today . "', plugins = '" . $plugin_ids . "' WHERE page_name = '" . $right_str . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	//If plugin is selected, then append HTML code snippet to bottom.
	if (($plugin != "-not selected-") && (isset($bottom_html)) && ($bottom_html != "") && ($bottom_str != "-na-"))
	{
		// Get footer content from main footer.  Most likely that we want this as default.  Can edit later.
		$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '" . $bottom_str . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$bottom_content = $row["page_content"];
		
		// Combine HTML (Javascript) code with default bottom content.
		$bottom_content = $bottom_content . "\n\n\n" . $bottom_html;
		$bottom_content = addslashes(stripslashes($bottom_content));
		
		// Insert new top into table.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_content = '" . $bottom_content . "', `revised` = '" . $today . "', plugins = '" . $plugin_ids . "' WHERE page_name = '" . $bottom_str . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Create plugin tables if plugin selected and table not existing.
	if (($plugin != "-not selected-") && ($deployed != 1))
	{
		if (isset($style_sheet) && ($style_sheet != ""))
		{
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name`='" . $style_sheet . "'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() < 1)
			{
				$query = "SELECT MAX(sort_order) AS sort_order FROM " . BWB_TABLE_PREFIX . "style_sheets";
				$result = $bwb_dbh->query($query);
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$sort_order = $row['sort_order'] + 10;
				
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "style_sheets SET `name`='" . $style_sheet . "', `description`='" . $style_sheet_description . "', `sort_order`=" . $sort_order;
				$cnt = $bwb_dbh->exec($query);
			}
		}
		
		if (isset($class_sql) && ($class_sql != ""))
		{
			$table = $style_sheet . "_classes";
			copy_table_structure($table, BWB_TABLE_PREFIX, $bwb_dbh, $bwb_database);
			$result = $bwb_dbh->query($class_sql);
		}
		
		if (isset($css_sql) && ($css_sql != ""))
		{
			$table = $style_sheet . "_css";
			copy_table_structure($table, BWB_TABLE_PREFIX, $bwb_dbh, $bwb_database);
			$result = $bwb_dbh->query($css_sql);
		}
		
		if (isset($plugin_sql) && ($plugin_sql != ""))
		{
//			$result = $bwb_dbh->query($plugin_sql);
			RunSQL($plugin_sql, BWB_TABLE_PREFIX, $bwb_dbh);
		}
		
		$query = "UPDATE " . BWB_TABLE_PREFIX . "plugins SET `deployed`=1 WHERE `id`=$plugin";
		$cnt = $bwb_dbh->exec($query);
	}	
	
	//Go to edit page.
	$domain = $_SERVER['HTTP_HOST'];
	$web_path = "http://" . $domain;
	$php_self = $_SERVER['PHP_SELF'];
	$this_file = substr(strrchr($php_self, "/"), 1);
	$app_dir = substr($php_self, 0, (strlen($php_self)- strlen($this_file)));
	$redirect = $web_path . $app_dir . "add_plugin_to_page_select.php?page_name=$page_name&plugin_name=$plugin_name";
	if ($deployed != 1)
		$redirect .= "&refresh_buttons=1";
	header("Location: $redirect");
	
?>
